/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.pcm.costcalculate.costcollecting.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.industry.emm.pcm.basedata.PayStageInfo;
import com.kingdee.eas.industry.emm.pcm.costcalculate.costcollecting.MaterialCostBillCollection;
import com.kingdee.eas.industry.emm.pcm.costcalculate.costcollecting.MaterialCostBillEntryCollection;
import com.kingdee.eas.industry.emm.pcm.costcalculate.costcollecting.MaterialCostBillEntryInfo;
import com.kingdee.eas.industry.emm.pcm.costcalculate.costcollecting.MaterialCostBillFactory;
import com.kingdee.eas.industry.emm.pcm.costcalculate.costcollecting.MaterialCostBillInfo;
import com.kingdee.eas.industry.emm.pcm.costcalculate.costcollecting.app.AbstractMaterialCostBillControllerBean;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.sql.SQLException;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class MaterialCostBillControllerBean
extends AbstractMaterialCostBillControllerBean {
    private String RESURL = "com.kingdee.eas.industry.emm.lcm.LcmResourceTwo";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.industry.emm.pcm.costcalculate.costcollecting.app.MaterialCostBillControllerBean");

    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        MaterialCostBillInfo info = (MaterialCostBillInfo)model;
        if (info == null) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costcalculate.EMMPCPcmCostcalculate", (String)"0EMMCOST-0008", (Locale)ctx.getLocale())));
        }
        if (info.getStatus() != BillBaseStatusEnum.SUBMITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costcalculate.EMMPCPcmCostcalculate", (String)"0EMMCOST-0009", (Locale)ctx.getLocale())));
        }
        info.setStatus(BillBaseStatusEnum.AUDITED);
        info.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
        info.setAuditDate(new Date());
        super.update(ctx, pk, (CoreBaseInfo)info);
    }

    protected void _unpassAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        MaterialCostBillInfo info = (MaterialCostBillInfo)model;
        if (info == null) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costcalculate.EMMPCPcmCostcalculate", (String)"0EMMCOST-0008", (Locale)ctx.getLocale())));
        }
        if (info.getStatus() != BillBaseStatusEnum.AUDITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costcalculate.EMMPCPcmCostcalculate", (String)"0EMMCOST-0010", (Locale)ctx.getLocale())));
        }
        info.setStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        info.setAuditor(null);
        info.setAuditDate(null);
        ISystemStatusCtrol ictrol = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo orgUnitInfo = (CompanyOrgUnitInfo)info.get("companyOrgUnit");
        PeriodInfo periodInfo = ictrol.getCacheCurrentPeriod(99, orgUnitInfo.getId().toString());
        if (periodInfo == null) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costcalculate.EMMPCPcmCostcalculate", (String)"0EMMCOST-0000", (Locale)ctx.getLocale())));
        }
        if (periodInfo.getNumber() > info.getPeriod().getNumber()) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costcalculate.EMMPCPcmCostcalculate", (String)"0EMMCOST-0072", (Locale)ctx.getLocale())));
        }
        this._checkIsHaveDestBills(ctx, (CoreBaseInfo)info);
        super.update(ctx, pk, (CoreBaseInfo)info);
    }

    protected void _checkIsHaveDestBills(Context ctx, CoreBaseInfo billInfo) throws EASBizException, BOSException {
        String billIdString;
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        if (iBTPManager.ifHaveDestBills(billIdString = billInfo.getId().toString())) {
            throw new SCMBillException(SCMBillException.HASDESTBILL_CANNOTUNAUDIT, new Object[]{billInfo.getString("number")});
        }
    }

    protected void check(Context ctx, MaterialCostBillInfo eti) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)eti.getNumber(), CompareType.EQUALS));
        if (eti.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)eti.getId().toString(), CompareType.NOTEQUALS));
        }
        if (this._exists(ctx, filter)) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costcalculate.EMMPCPcmCostcalculate", (String)"0EMMCOST-0011", (Locale)ctx.getLocale())));
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        MaterialCostBillInfo eti = (MaterialCostBillInfo)model;
        if (eti.get("allocationStatus") == null) {
            this.checkHead(ctx, eti);
            this.check(ctx, eti);
            this.checkEntry(ctx, eti);
            if (eti.getStatus() != BillBaseStatusEnum.TEMPORARILYSAVED && eti.getStatus() != BillBaseStatusEnum.SUBMITED) {
                throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costcalculate.EMMPCPcmCostcalculate", (String)"0EMMCOST-0012", (Locale)ctx.getLocale())));
            }
            eti.setStatus(BillBaseStatusEnum.SUBMITED);
        }
        if (eti.getNumber() == null || eti.getNumber().toString().equals("")) {
            eti.setNumber(this.getNewNumber(ctx, (IObjectValue)eti, ContextUtil.getCurrentAdminUnit((Context)ctx).getId().toString()));
        }
        return super._submit(ctx, model);
    }

    private void checkHead(Context ctx, MaterialCostBillInfo info) throws EASBizException, BOSException {
        ISystemStatusCtrol ictrol = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        if (info.getBizDate() == null) {
            throw new EASBizException(new NumericExceptionSubItem("", info.getNumber() + EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costcalculate.EMMPCPcmCostcalculate", (String)"0EMMCOST-0019", (Locale)ctx.getLocale())));
        }
        if (info.getPayStage() == null) {
            throw new EASBizException(new NumericExceptionSubItem("", info.getNumber() + EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costcalculate.EMMPCPcmCostcalculate", (String)"0EMMCOST-0073", (Locale)ctx.getLocale())));
        }
        if (info.getProject() == null) {
            throw new EASBizException(new NumericExceptionSubItem("", info.getNumber() + EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costcalculate.EMMPCPcmCostcalculate", (String)"0EMMCOST-0020", (Locale)ctx.getLocale())));
        }
        if (info.getCompanyOrgUnit() == null) {
            throw new EASBizException(new NumericExceptionSubItem("", info.getNumber() + EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costcalculate.EMMPCPcmCostcalculate", (String)"0EMMCOST-0021", (Locale)ctx.getLocale())));
        }
        if (info.getPeriod() == null) {
            throw new EASBizException(new NumericExceptionSubItem("", info.getNumber() + EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costcalculate.EMMPCPcmCostcalculate", (String)"0EMMCOST-0022", (Locale)ctx.getLocale())));
        }
        if (info.getAdminOrgUnit() == null) {
            throw new EASBizException(new NumericExceptionSubItem("", info.getNumber() + EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costcalculate.EMMPCPcmCostcalculate", (String)"0EMMCOST-0023", (Locale)ctx.getLocale())));
        }
        PeriodInfo periodInfo = ictrol.getCacheCurrentPeriod(99, info.getCompanyOrgUnit().getId().toString());
        if (periodInfo == null) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costcalculate.EMMPCPcmCostcalculate", (String)"0EMMCOST-0024", (Locale)ctx.getLocale())));
        }
        if (!periodInfo.getId().toString().equals(info.getPeriod().getId().toString())) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costcalculate.EMMPCPcmCostcalculate", (String)"0EMMCOST-0025", (Locale)ctx.getLocale())));
        }
    }

    private void checkEntry(Context ctx, MaterialCostBillInfo info) throws EASBizException {
        MaterialCostBillEntryCollection entryCollection = info.getEntrys();
        for (int i = 0; i < entryCollection.size(); ++i) {
            MaterialCostBillEntryInfo entryInfo = entryCollection.get(i);
            StringBuffer tmpStr = new StringBuffer();
            if (entryInfo.getDutyCenter() == null) {
                tmpStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costcalculate.EMMPCPcmCostcalculate", (String)"0EMMCOST-0026", (Locale)ctx.getLocale()));
            }
            if (entryInfo.getCostItem() == null) {
                tmpStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costcalculate.EMMPCPcmCostcalculate", (String)"0EMMCOST-0074", (Locale)ctx.getLocale()));
            }
            if (entryInfo.getMaterial() == null) {
                tmpStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costcalculate.EMMPCPcmCostcalculate", (String)"0EMMCOST-0028", (Locale)ctx.getLocale()));
            }
            if (entryInfo.getActualCost() == null) {
                tmpStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costcalculate.EMMPCPcmCostcalculate", (String)"0EMMCOST-0077", (Locale)ctx.getLocale()));
            }
            if (entryInfo.getStandardCost() == null) {
                tmpStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costcalculate.EMMPCPcmCostcalculate", (String)"0EMMCOST-0078", (Locale)ctx.getLocale()));
            }
            if (tmpStr.length() <= 0) continue;
            throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.industry.emm.pcm.costcalculate.EMMPCPcmCostcalculate", (String)"FLDJH", (Locale)ctx.getLocale(), (Object[])new Object[]{i + 1}) + "," + tmpStr.toString()));
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        MaterialCostBillInfo info = this.getMaterialCostBillInfo(ctx, pk);
        if (info.getStatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costcalculate.EMMPCPcmCostcalculate", (String)"0EMMCOST-0015", (Locale)ctx.getLocale()) + info.getNumber() + EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costcalculate.EMMPCPcmCostcalculate", (String)"0EMMCOST-0016", (Locale)ctx.getLocale())));
        }
        super._delete(ctx, pk);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        MaterialCostBillInfo eti = (MaterialCostBillInfo)model;
        this.checkHead(ctx, eti);
        this.check(ctx, eti);
        this.checkEntry(ctx, eti);
        if (eti.getStatus() != BillBaseStatusEnum.TEMPORARILYSAVED && eti.getStatus() != BillBaseStatusEnum.ADD) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costcalculate.EMMPCPcmCostcalculate", (String)"0EMMCOST-0017", (Locale)ctx.getLocale())));
        }
        eti.setStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        if (eti.getNumber() == null || eti.getNumber().toString().equals("")) {
            eti.setNumber(this.getNewNumber(ctx, (IObjectValue)eti, ContextUtil.getCurrentAdminUnit((Context)ctx).getId().toString()));
        }
        return super._save(ctx, model);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return super._addnew(ctx, model);
    }

    @Override
    protected void _importIn(Context ctx, Map map) throws BOSException, EASBizException {
        PeriodInfo periodInfo;
        long lstart = System.currentTimeMillis();
        ISystemStatusCtrol ictrol = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo companyOrgUnitInfo = ContextUtil.getCurrentFIUnit((Context)ctx);
        String costItemID = "kcYAAAQcCFCYdYRY";
        String payStageID = "kcYAAAQcBHACzN8O";
        if (companyOrgUnitInfo == null) {
            companyOrgUnitInfo = ContextUtil.getCurrentFIUnit((Context)ctx);
        }
        if ((periodInfo = ictrol.getCacheCurrentPeriod(99, companyOrgUnitInfo.getId().toString())) == null) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costcalculate.EMMPCPcmCostcalculate", (String)"0EMMCOST-0000", (Locale)ctx.getLocale())));
        }
        String reqTempTable = "";
        String createTab = "CREATE TABLE TKPROJECT (   fcompanyorgunitid VARCHAR(44),  fprojectid VARCHAR(44),  ftracknumberid VARCHAR(44),  fdutyCenterid VARCHAR(44),  fmaterialid VARCHAR(44),  fmaterialName VARCHAR(100),  fmaterialModel VARCHAR(100),  factualcost NUMERIC(21,8),  fstandardcost NUMERIC(21,8)  ) \n";
        try {
            reqTempTable = TempTablePool.getInstance((Context)ctx).createTempTable(createTab);
        }
        catch (Exception e) {
            throw new BOSException(e.getCause());
        }
        StringBuffer insertSql = new StringBuffer();
        insertSql.append("/*dialect*/ insert into " + reqTempTable + " ");
        insertSql.append("(fprojectid,ftracknumberid,fdutyCenterid,fmaterialid,fmaterialName,fmaterialModel,factualcost,fstandardcost)\n");
        insertSql.append("select mrentry.fprojectid,mrentry.ftracknumberid ,\n");
        insertSql.append("mr.fcostcenterorgunitid,mrentry.fmaterialid,material.fname_l2 fmaterialName,material.fmodel fmaterialModel,\n");
        insertSql.append("mrentry.factualcost,materialCom.Fstandardcost\n");
        insertSql.append("from T_IM_MaterialReqBill mr\n");
        insertSql.append("left join t_Im_Materialreqbillentry mrentry\n");
        insertSql.append("on mr.fid = mrentry.fparentid\n");
        insertSql.append("left join T_ORG_CostCenter costcenter\n");
        insertSql.append("on mr.fcostcenterorgunitid = costcenter.fid\n");
        insertSql.append("left join T_SCM_TransactionType tstype\n");
        insertSql.append("on tstype.fid = mrentry.ftransactiontypeid\n");
        insertSql.append("left join T_BD_Material material\n");
        insertSql.append("on material.fid = mrentry.fmaterialid\n");
        insertSql.append("left join T_BD_MaterialCompanyInfo materialCom\n");
        insertSql.append("on materialCom.Fmaterialid = mrentry.fmaterialid\n");
        insertSql.append("where mrentry.fyear = '" + periodInfo.getPeriodYear() + "' and mrentry.fperiod='" + periodInfo.getPeriodNumber() + "'\n");
        insertSql.append("  and mr.fbasestatus = 4\n");
        insertSql.append("  and costcenter.fcostcentertype = 0\n");
        insertSql.append("  and costcenter.fisadminorgunit = 1\n");
        insertSql.append("  and tstype.fismanucostcalculate = 1\n");
        insertSql.append("  and mrentry.fcompanyorgunitid = '" + companyOrgUnitInfo.getId() + "'\n");
        insertSql.append("  and materialCom.Fcompanyid = '" + companyOrgUnitInfo.getId() + "'");
        DBUtil.execute((Context)ctx, (String)insertSql.toString());
        StringBuffer querySql = new StringBuffer();
        querySql.append("select imp.fprojectid,count(1) from " + reqTempTable + " imp\n");
        querySql.append("where imp.fprojectid is not null\n");
        querySql.append("group by imp.fprojectid");
        IRowSet projectRs = DBUtil.executeQuery((Context)ctx, (String)querySql.toString());
        PayStageInfo payStageInfo = new PayStageInfo();
        payStageInfo.setId(BOSUuid.read((String)payStageID));
        StringBuffer deleteSql = new StringBuffer();
        String YR = EASResource.getString((String)this.RESURL, (String)"YR", (Locale)ctx.getLocale());
        deleteSql.append("/*dialect*/delete from CT_PCM_MaterialCostBillEntry entrys\n");
        deleteSql.append("where entrys.cfintype = 'YR'\n");
        deleteSql.append("and exists (select 1 from CT_PCM_MaterialCostBill cbill\n");
        deleteSql.append("      where cbill.cfcompanyorgunitid = '" + companyOrgUnitInfo.getId() + "'\n");
        deleteSql.append("      and cbill.cfperiodid = '" + periodInfo.getId() + "' and cbill.cfpaystageid='" + payStageID + "'\n");
        deleteSql.append("      and entrys.fparentid = cbill.fid)");
        DBUtil.execute((Context)ctx, (String)deleteSql.toString());
        try {
            MaterialCostBillCollection billCollection = MaterialCostBillFactory.getLocalInstance(ctx).getMaterialCostBillCollection("select id,project where companyOrgUnit.id='" + companyOrgUnitInfo.getId() + "' and payStage.id = '" + payStageID + "' and period.id = '" + periodInfo.getId() + "' ");
            while (projectRs.next()) {
                String projectID = projectRs.getString("fprojectid");
                boolean isEquals = false;
                for (int i = 0; i < billCollection.size(); ++i) {
                    MaterialCostBillInfo materialCostBillInfo = billCollection.get(i);
                    if (!materialCostBillInfo.getProject().getId().toString().equals(projectID)) continue;
                    isEquals = true;
                    break;
                }
                if (isEquals) continue;
                MaterialCostBillInfo materialCostBillInfo = new MaterialCostBillInfo();
                materialCostBillInfo.setAdminOrgUnit(ContextUtil.getCurrentAdminUnit((Context)ctx));
                materialCostBillInfo.setCompanyOrgUnit(companyOrgUnitInfo);
                materialCostBillInfo.setBizDate(new Date());
                materialCostBillInfo.setPayStage(payStageInfo);
                materialCostBillInfo.setPeriod(periodInfo);
                ProjectInfo projectInfo = new ProjectInfo();
                projectInfo.setId(BOSUuid.read((String)projectID));
                materialCostBillInfo.setProject(projectInfo);
                IObjectPK iObjectPK = this._save(ctx, (IObjectValue)materialCostBillInfo);
            }
            String updateStatus = "/*dialect*/update ct_pcm_materialcostbill t set t.cfstatus = 4\nwhere t.cfcompanyorgunitid = '" + companyOrgUnitInfo.getId() + "' and t.cfpaystageid = '" + payStageID + "'\n   and   t.cfperiodid = '" + periodInfo.getId() + "' and t.cfprojectid in (select imp.fprojectid from " + reqTempTable + " imp\nwhere imp.fprojectid is not null\ngroup by imp.fprojectid) ";
            DBUtil.execute((Context)ctx, (String)updateStatus);
        }
        catch (SQLException e) {
            throw new BOSException(e.getCause());
        }
        StringBuffer proSql = new StringBuffer();
        proSql.append("/*dialect*/ insert into CT_PCM_MaterialCostBillEntry \n");
        proSql.append("(fid,CFTrackNumberID,CFDutyCenterID,CFCostItemID,CFMaterialID,CFMaterialName,CFMaterialModel,CFActualCost,CFStandardCost,FParentID,cfintype)\n");
        proSql.append("select newbosid('BA5E883E'),imp.ftracknumberid,imp.fdutyCenterid,'" + costItemID + "',imp.fmaterialid,imp.fmaterialname,imp.fmaterialmodel,\n");
        proSql.append(" decode(sum( decode(imp.factualcost,null,0,imp.factualcost)),0,'0.00',(to_char(round(sum( decode(imp.factualcost,null,0,imp.factualcost)),2),'fm99999999999990.00') )) fstandardcost,\n");
        proSql.append(" decode(sum( decode(imp.fstandardcost,null,0,imp.fstandardcost)),0,'0.00',(to_char(round(sum( decode(imp.fstandardcost,null,0,imp.fstandardcost)),2),'fm99999999999990.00') )) fstandardcost,\n");
        proSql.append("(select fid from ct_pcm_materialcostbill artb\n");
        proSql.append("where artb.cfperiodid = '" + periodInfo.getId() + "' and artb.cfcompanyorgunitid='" + companyOrgUnitInfo.getId() + "' and\n");
        proSql.append("artb.cfprojectid = imp.fprojectid  ),'YR'\n");
        proSql.append("from " + reqTempTable + " imp\n");
        proSql.append("where imp.fprojectid is not null\n");
        proSql.append("group by imp.fdutyCenterid,imp.fprojectid,imp.ftracknumberid, imp.fmaterialid,imp.fmaterialname,imp.fmaterialmodel");
        DBUtil.execute((Context)ctx, (String)proSql.toString());
        long lstop = System.currentTimeMillis();
        TempTablePool.getInstance((Context)ctx).releaseTable(reqTempTable);
        logger.info((Object)("########### createReqTmpTable end : " + (lstop - lstart)));
        super._importIn(ctx, map);
    }

    protected String getNewNumber(Context ctx, IObjectValue model, String strCompanyID) throws BOSException, EASBizException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        CoreBillBaseInfo aSCMBillBaseInfo = (CoreBillBaseInfo)model;
        String number = iCodingRuleManager.getNumber((IObjectValue)aSCMBillBaseInfo, strCompanyID, "");
        aSCMBillBaseInfo.setNumber(number);
        ObjectUuidPK pk = new ObjectUuidPK(aSCMBillBaseInfo.getId());
        if (this.isSameNumber(ctx, (IObjectPK)pk, (IObjectValue)aSCMBillBaseInfo)) {
            String newNumber = "";
            newNumber = iCodingRuleManager.getNumber((IObjectValue)aSCMBillBaseInfo, strCompanyID, "");
            if (newNumber.equals(aSCMBillBaseInfo.getNumber())) {
                throw new SCMBillException(SCMBillException.NUMBERRULEERROR);
            }
            number = newNumber;
            aSCMBillBaseInfo.setNumber(newNumber);
            if (this.isSameNumber(ctx, (IObjectPK)pk, (IObjectValue)aSCMBillBaseInfo)) {
                return this.getNewNumber(ctx, (IObjectValue)aSCMBillBaseInfo, strCompanyID);
            }
        }
        return number;
    }

    protected boolean isSameNumber(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        CoreBillBaseInfo aSCMBillBaseInfo = (CoreBillBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = null;
        filterItem = aSCMBillBaseInfo.getNumber() == null ? new FilterItemInfo("number", (Object)aSCMBillBaseInfo.getNumber(), CompareType.EQUALS) : new FilterItemInfo("number", (Object)aSCMBillBaseInfo.getNumber().trim(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (aSCMBillBaseInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)aSCMBillBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < filter.getFilterItems().size(); ++i) {
            if (i != 0) {
                sb.append(" and #" + i);
                continue;
            }
            sb.append("#" + i);
        }
        filter.setMaskString(sb.toString());
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        return super._exists(ctx, filter);
    }
}

