/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.pcm.costcalculate.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.report.ReportHeader;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.base.report.app.ReportServerBase;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import com.kingdee.util.NumericExceptionSubItem;
import java.util.Locale;

public class SupplierQuoteRptServer
extends ReportServerBase {
    private Context ctx;
    private String projectNumber = null;
    private String materialNumber = null;
    private String materialName = null;
    private String model = null;
    private String unit = null;
    private Double price;
    private String supplierName = null;

    protected IRowSet getReportData(String arg0, RptParams arg1) throws Exception {
        this.projectNumber = arg1.getObject("ProjectNumber") == null ? "" : arg1.getObject("ProjectNumber").toString();
        this.materialNumber = arg1.getObject("MaterialNumber") == null ? "" : arg1.getObject("MaterialNumber").toString();
        this.ctx = this.getContext();
        String alltempTableName = this.buildReportData();
        StringBuffer selectAll = new StringBuffer();
        selectAll.append("SELECT * FROM ");
        selectAll.append(alltempTableName);
        IRowSet set = DbUtil.executeQuery((Context)this.getContext(), (String)selectAll.toString());
        if (alltempTableName != null) {
            this.dropTempTable(arg0, arg1, alltempTableName);
        }
        return set;
    }

    public String createTableSql() {
        StringBuffer sql = new StringBuffer();
        sql.append("/*dialect*/create table T_Pcm_TempPPCR(");
        sql.append("fid numeric(20),");
        sql.append("fprojectNumber NVARCHAR(80),");
        sql.append("fmaterialNumber NVARCHAR(80),");
        sql.append("fmaterialName NVARCHAR(80),");
        sql.append("ASSTACTNAME NVARCHAR(255),");
        sql.append("fmodel NVARCHAR(255),");
        sql.append("fprice NUMERIC(30,2),");
        sql.append("ftaxprice NUMERIC(30,2),");
        sql.append("funit NVARCHAR(44),");
        sql.append("fseq numeric(20)");
        sql.append(")");
        return sql.toString();
    }

    private String buildReportData() throws BOSException, EASBizException {
        String tempTableName;
        try {
            tempTableName = TempTablePool.getInstance((Context)this.getContext()).createTempTable(this.createTableSql());
        }
        catch (Exception e) {
            throw new BOSException("create temptable case error!" + e);
        }
        this.insertTempTable(tempTableName);
        return tempTableName;
    }

    private void insertTempTable(String tempTableName) throws EASBizException {
        StringBuilder strSql = new StringBuilder();
        strSql.setLength(0);
        strSql.append(" /*dialect*/insert into  ");
        strSql.append(tempTableName);
        strSql.append(" select rownum,tab.* from ( ");
        strSql.append("select p.fnumber fprojectNumber,m.fnumber fmaterialNumber,oe.fmaterialname,");
        strSql.append("o.FAsstActName_l2 ASSTACTNAME,m.fmodel,oe.fprice,oe.ftaxprice,u.fname_l2 funit,");
        strSql.append("row_number() over(partition by oe.fprojectid,oe.fmaterialname order by o.fbizdate desc) fseq ");
        strSql.append(" from t_ap_otherbill o");
        strSql.append(" left join t_ap_otherbillentry oe on o.fid = oe.fparentid");
        strSql.append(" left join t_bd_project p on p.fid = oe.fprojectid");
        strSql.append(" left join t_bd_material m on m.fid = oe.fmaterialid");
        strSql.append(" left join t_bd_measureunit u on u.fid = m.fbaseunit");
        strSql.append(" order by oe.fprojectid,oe.fmaterialid,o.fasstactid");
        strSql.append(" ) tab where fseq = 1");
        if (this.projectNumber != null && !this.projectNumber.trim().equals("")) {
            strSql.append(" and tab.fprojectNumber='" + this.projectNumber + "'");
        }
        if (this.materialNumber != null && !this.materialNumber.trim().equals("")) {
            strSql.append(" and tab.fmaterialNumber='" + this.materialNumber + "'");
        }
        try {
            DbUtil.execute((Context)this.getContext(), (String)strSql.toString());
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costcalculate.EMMPCPcmCostcalculate", (String)"0EMMCOST-0155", (Locale)this.ctx.getLocale())));
        }
    }

    protected ReportHeader getReportHeader(String reportID, RptParams filter) throws Exception {
        ReportHeader firhead = new ReportHeader();
        ReportHeader sechead = new ReportHeader();
        ReportHeader thhead1 = new ReportHeader();
        ReportHeader thhead2 = new ReportHeader();
        thhead1 = firhead.addChild("fid", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costcalculate.EMMPCPcmCostcalculate", (String)"0EMMCOST-0162", (Locale)this.ctx.getLocale()));
        ReportHeader temp = thhead1.addChild("fmaterialNumber", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costcalculate.EMMPCPcmCostcalculate", (String)"0EMMCOST-0103", (Locale)this.ctx.getLocale()));
        temp.setWidth(120);
        temp.setAlign(1);
        temp = thhead1.addChild("fmaterialName", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costcalculate.EMMPCPcmCostcalculate", (String)"0EMMCOST-0104", (Locale)this.ctx.getLocale()));
        temp.setAlign(1);
        temp = thhead1.addChild("fmodel", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costcalculate.EMMPCPcmCostcalculate", (String)"0EMMCOST-0105", (Locale)this.ctx.getLocale()));
        temp.setAlign(1);
        temp = thhead1.addChild("funit", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costcalculate.EMMPCPcmCostcalculate", (String)"0EMMCOST-0144", (Locale)this.ctx.getLocale()));
        temp.setAlign(1);
        temp = thhead1.addChild("fprice", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costcalculate.EMMPCPcmCostcalculate", (String)"0EMMCOST-0163", (Locale)this.ctx.getLocale()));
        temp.setAlign(3);
        temp = thhead1.addChild("ASSTACTNAME", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costcalculate.EMMPCPcmCostcalculate", (String)"0EMMCOST-0164", (Locale)this.ctx.getLocale()));
        temp.setAlign(1);
        return firhead;
    }

    protected ReportTitles getReportTitles(String arg0, RptParams arg1) throws BaseException {
        return null;
    }
}

