/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.pcm.costmanagement.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.industry.emm.pcm.basedata.EnabledStateEnum;
import com.kingdee.eas.industry.emm.pcm.basedata.MarketFitPriceStorageCollection;
import com.kingdee.eas.industry.emm.pcm.basedata.MarketFitPriceStorageFactory;
import com.kingdee.eas.industry.emm.pcm.basedata.MarketFitPriceStorageInfo;
import com.kingdee.eas.industry.emm.pcm.basedata.PurMaterialPriceStorageCollection;
import com.kingdee.eas.industry.emm.pcm.basedata.PurMaterialPriceStorageFactory;
import com.kingdee.eas.industry.emm.pcm.costmanagement.MarketingPartEstimateEntryCollection;
import com.kingdee.eas.industry.emm.pcm.costmanagement.MarketingPartEstimateEntryInfo;
import com.kingdee.eas.industry.emm.pcm.costmanagement.MarketingPartEstimateInfo;
import com.kingdee.eas.industry.emm.pcm.costmanagement.app.AbstractMarketingPartEstimateControllerBean;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.zjbom.app.util.ProcessBomTree;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class MarketingPartEstimateControllerBean
extends AbstractMarketingPartEstimateControllerBean {
    private String RESURL = "com.kingdee.eas.industry.emm.lcm.LcmResourceTwo";
    private String GYBOMSZKQG = EASResource.getString((String)this.RESURL, (String)"GYBOMSZKQG");
    private String CQJCGYBOMSJSFYW = EASResource.getString((String)this.RESURL, (String)"CQJCGYBOMSJSFYW");
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.industry.emm.pcm.costmanagement.app.MarketingPartEstimateControllerBean");

    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        MarketingPartEstimateInfo info = (MarketingPartEstimateInfo)model;
        if (info == null) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costmanagement.EMMPCCostMageResource", (String)"0EMMCOSTMANAGER-0000", (Locale)ctx.getLocale())));
        }
        if (info.getBaseStatus() != BillBaseStatusEnum.SUBMITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costmanagement.EMMPCCostMageResource", (String)"0EMMCOSTMANAGER-0001", (Locale)ctx.getLocale())));
        }
        info.setBaseStatus(BillBaseStatusEnum.AUDITED);
        info.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
        info.setAuditDate(new Date());
        super.update(ctx, pk, (CoreBaseInfo)info);
        if (info.getEntrys().size() != 0) {
            for (int i = 0; i < info.getEntrys().size(); ++i) {
                MarketingPartEstimateEntryInfo entryInfo = info.getEntrys().get(i);
                if (entryInfo.getMaterial() == null) continue;
                String materialId = entryInfo.getMaterial().getId().toString();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("materialNumber.id", (Object)materialId, CompareType.EQUALS));
                if (MarketFitPriceStorageFactory.getLocalInstance(ctx).exists(filter)) {
                    String updSql = "update CT_PCM_MarketFitPriceStorage set CFEstimatePrice=" + entryInfo.getPrice() + ",CFTargetPrice=" + entryInfo.getTargetCost() + " , CFUpdateDate = systimestamp where CFMaterialNumberID='" + materialId + "' --and CFStatus = 2";
                    DBUtil.execute((Context)ctx, (String)updSql);
                    continue;
                }
                MarketFitPriceStorageInfo baseInfo = new MarketFitPriceStorageInfo();
                baseInfo.setMaterialNumber(entryInfo.getMaterial());
                baseInfo.setMaterialName(entryInfo.getMaterial().getName());
                baseInfo.setCtrlUnit(ContextUtil.getCurrentCtrlUnit((Context)ctx));
                baseInfo.setMeasureUnit(entryInfo.getMaterial().getBaseUnit());
                baseInfo.setEstimatePrice(entryInfo.getPrice());
                baseInfo.setUpdateDate(new Date());
                baseInfo.setTypesize(entryInfo.getMaterial().getModel());
                baseInfo.setTargetPrice(entryInfo.getTargetCost());
                baseInfo.setStatus(EnabledStateEnum.ENABLED);
                MarketFitPriceStorageFactory.getLocalInstance(ctx).save((CoreBaseInfo)baseInfo);
            }
        }
    }

    protected void _unpassAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        MarketingPartEstimateInfo info = (MarketingPartEstimateInfo)model;
        if (info == null) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costmanagement.EMMPCCostMageResource", (String)"0EMMCOSTMANAGER-0000", (Locale)ctx.getLocale())));
        }
        if (info.getBaseStatus() != BillBaseStatusEnum.AUDITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costmanagement.EMMPCCostMageResource", (String)"0EMMCOSTMANAGER-0002", (Locale)ctx.getLocale())));
        }
        info.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        info.setAuditor(null);
        info.setAuditDate(null);
        super.update(ctx, pk, (CoreBaseInfo)info);
    }

    protected void check(Context ctx, MarketingPartEstimateInfo eti) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)eti.getNumber(), CompareType.EQUALS));
        if (eti.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)eti.getId().toString(), CompareType.NOTEQUALS));
        }
        if (this._exists(ctx, filter)) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costmanagement.EMMPCCostMageResource", (String)"0EMMCOSTMANAGER-0003", (Locale)ctx.getLocale())));
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        MarketingPartEstimateInfo eti = (MarketingPartEstimateInfo)model;
        this.checkHead(ctx, eti);
        this.check(ctx, eti);
        this.checkEntry(ctx, eti);
        if (eti.getBaseStatus() != BillBaseStatusEnum.TEMPORARILYSAVED && eti.getBaseStatus() != BillBaseStatusEnum.SUBMITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costmanagement.EMMPCCostMageResource", (String)"0EMMCOSTMANAGER-0004", (Locale)ctx.getLocale())));
        }
        eti.setBaseStatus(BillBaseStatusEnum.SUBMITED);
        return super._submit(ctx, model);
    }

    private void checkHead(Context ctx, MarketingPartEstimateInfo model) throws EASBizException {
        if (model.getNumber() == null || model.getNumber().equals("")) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costmanagement.EMMPCCostMageResource", (String)"0EMMCOSTMANAGER-0005", (Locale)ctx.getLocale())));
        }
        if (model.get("adminOrgUnit") == null || model.get("adminOrgUnit").equals("")) {
            throw new EASBizException(new NumericExceptionSubItem("", model.getNumber() + EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costmanagement.EMMPCCostMageResource", (String)"0EMMCOSTMANAGER-0006", (Locale)ctx.getLocale())));
        }
        if (model.getBizDate() == null || model.get("bizDate").equals("")) {
            model.setBizDate(new Date());
        }
    }

    private void checkEntry(Context ctx, MarketingPartEstimateInfo model) throws EASBizException {
        MarketingPartEstimateEntryCollection entryCollection = model.getEntrys();
        for (int i = 0; i < entryCollection.size(); ++i) {
            MarketingPartEstimateEntryInfo info = entryCollection.get(i);
            MaterialInfo materialInfo = info.getMaterial();
            StringBuffer tmpStr = new StringBuffer();
            if (info.getMaterialName() == null || info.getMaterialName().equals("")) {
                tmpStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costmanagement.EMMPCCostMageResource", (String)"0EMMCOSTMANAGER-0007", (Locale)ctx.getLocale()));
            }
            if (info.getRiskCoefficient() == null && info.getRiskCoefficient().compareTo(BigDecimal.ZERO) != 1) {
                tmpStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costmanagement.EMMPCCostMageResource", (String)"0EMMCOSTMANAGER-0008", (Locale)ctx.getLocale()));
            }
            if (materialInfo != null) {
                try {
                    materialInfo = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(info.getMaterial().getId()));
                }
                catch (BOSException e2) {
                    e2.printStackTrace();
                }
                info.setMaterialName(materialInfo.getName());
                info.setModels(materialInfo.getModel());
                info.setMeasureUnit(materialInfo.getBaseUnit());
                EntityViewInfo evi = new EntityViewInfo();
                evi.setSelector(new SelectorItemCollection());
                evi.getSelector().add(new SelectorItemInfo("estimatePrice"));
                evi.getSelector().add(new SelectorItemInfo("targetPrice"));
                evi.setFilter(new FilterInfo());
                evi.getFilter().getFilterItems().add(new FilterItemInfo("materialNumber.number", (Object)materialInfo.getNumber(), CompareType.EQUALS));
                evi.getFilter().getFilterItems().add(new FilterItemInfo("status", (Object)2, CompareType.EQUALS));
                evi.setSorter(new SorterItemCollection());
                SorterItemInfo itemInfo = new SorterItemInfo("updateDate");
                itemInfo.setSortType(SortType.DESCEND);
                evi.getSorter().add(itemInfo);
                MarketFitPriceStorageCollection collection = null;
                try {
                    collection = MarketFitPriceStorageFactory.getLocalInstance(ctx).getMarketFitPriceStorageCollection(evi);
                }
                catch (BOSException e1) {
                    e1.printStackTrace();
                }
                BigDecimal estimatePrice = null;
                if (collection.size() != 0) {
                    estimatePrice = collection.get(0).getEstimatePrice();
                }
                info.setRefEstimate(estimatePrice);
                evi = new EntityViewInfo();
                evi.setSelector(new SelectorItemCollection());
                evi.getSelector().add(new SelectorItemInfo("latestPurPrice"));
                evi.getSelector().add(new SelectorItemInfo("maxPurPrice"));
                evi.setFilter(new FilterInfo());
                evi.getFilter().getFilterItems().add(new FilterItemInfo("materialNumber.number", (Object)materialInfo.getNumber(), CompareType.EQUALS));
                evi.getFilter().getFilterItems().add(new FilterItemInfo("status", (Object)2, CompareType.EQUALS));
                evi.setSorter(new SorterItemCollection());
                SorterItemInfo itemInfo1 = new SorterItemInfo("updateTime");
                itemInfo1.setSortType(SortType.DESCEND);
                evi.getSorter().add(itemInfo1);
                PurMaterialPriceStorageCollection pmpCollection = null;
                try {
                    pmpCollection = PurMaterialPriceStorageFactory.getLocalInstance(ctx).getPurMaterialPriceStorageCollection(evi);
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
                BigDecimal latestPurPrice = null;
                BigDecimal maxPurPrice = null;
                if (pmpCollection.size() != 0) {
                    latestPurPrice = pmpCollection.get(0).getLatestPurPrice();
                    maxPurPrice = pmpCollection.get(0).getMaxPurPrice();
                }
                info.setNewPurPrice(latestPurPrice);
                info.setHighPurPrice(maxPurPrice);
            }
            if (model.getString("importStatus") != null) continue;
            BigDecimal price = null;
            String priceSource = "";
            if (info.getRefEstimate() != BigDecimal.ZERO && info.getRefEstimate() != null) {
                price = info.getRefEstimate();
                priceSource = EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costmanagement.EMMPCCostMageResource", (String)"0EMMCOSTMANAGER-0009", (Locale)ctx.getLocale());
            }
            if (info.getHighPurPrice() != BigDecimal.ZERO && info.getHighPurPrice() != null) {
                price = info.getHighPurPrice();
                priceSource = EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costmanagement.EMMPCCostMageResource", (String)"0EMMCOSTMANAGER-0010", (Locale)ctx.getLocale());
            }
            if (info.getNewPurPrice() != BigDecimal.ZERO && info.getNewPurPrice() != null) {
                price = info.getNewPurPrice();
                priceSource = EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costmanagement.EMMPCCostMageResource", (String)"0EMMCOSTMANAGER-0011", (Locale)ctx.getLocale());
            }
            if (info.getInquiryPrice() != BigDecimal.ZERO && info.getInquiryPrice() != null) {
                price = info.getInquiryPrice();
                priceSource = EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costmanagement.EMMPCCostMageResource", (String)"0EMMCOSTMANAGER-0012", (Locale)ctx.getLocale());
            }
            if (info.getEstimatePrice() != BigDecimal.ZERO && info.getEstimatePrice() != null) {
                price = info.getEstimatePrice();
                priceSource = EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costmanagement.EMMPCCostMageResource", (String)"0EMMCOSTMANAGER-0013", (Locale)ctx.getLocale());
            }
            if (price == null || price.compareTo(BigDecimal.ZERO) != 1) {
                tmpStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costmanagement.EMMPCCostMageResource", (String)"0EMMCOSTMANAGER-0014", (Locale)ctx.getLocale()));
            }
            if (tmpStr.length() > 0) {
                throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costmanagement.EMMPCCostMageResource", (String)"0EMMCOSTMANAGER-0015", (Locale)ctx.getLocale()) + (i + 1) + EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costmanagement.EMMPCCostMageResource", (String)"0EMMCOSTMANAGER-0016") + tmpStr.toString()));
            }
            if (info.getRiskCoefficient() == null) {
                info.setRiskCoefficient(BigDecimal.ZERO);
            }
            if (price == null) continue;
            info.setPriceSource(priceSource);
            info.setPrice(price.multiply(info.getRiskCoefficient()));
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        MarketingPartEstimateInfo info = this.getMarketingPartEstimateInfo(ctx, pk);
        if (info.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costmanagement.EMMPCCostMageResource", (String)"0EMMCOSTMANAGER-0017", (Locale)ctx.getLocale()) + info.getNumber() + EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costmanagement.EMMPCCostMageResource", (String)"0EMMCOSTMANAGER-0018", (Locale)ctx.getLocale())));
        }
        super._delete(ctx, pk);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        MarketingPartEstimateInfo eti = (MarketingPartEstimateInfo)model;
        this.checkHead(ctx, eti);
        this.check(ctx, eti);
        this.checkEntry(ctx, eti);
        if (eti.getBaseStatus() != BillBaseStatusEnum.TEMPORARILYSAVED && eti.getBaseStatus() != BillBaseStatusEnum.ADD) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costmanagement.EMMPCCostMageResource", (String)"0EMMCOSTMANAGER-0019", (Locale)ctx.getLocale())));
        }
        eti.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        return super._save(ctx, model);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return super._addnew(ctx, model);
    }

    @Override
    protected Map _exBom(Context ctx, Map paramMap) throws BOSException, EASBizException {
        MarketingPartEstimateInfo mapeInfo = (MarketingPartEstimateInfo)paramMap.get("billInfo");
        ProjectInfo project = (ProjectInfo)paramMap.get("project");
        TrackNumberInfo trackNumber = (TrackNumberInfo)paramMap.get("trackNumber");
        MaterialInfo materialInfo = null;
        MarketingPartEstimateEntryCollection markColl = (MarketingPartEstimateEntryCollection)((Object)paramMap.get("maEntryColl"));
        int isize = markColl.size();
        for (int i = 0; i < isize; ++i) {
            MarketingPartEstimateEntryInfo entryInfo = new MarketingPartEstimateEntryInfo();
            entryInfo = markColl.get(i);
            materialInfo = entryInfo.getMaterial();
            BomTree tree = new BomTree();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("prmtTrackBegin", trackNumber.getNumber());
            params.put("prmtTrackEnd", trackNumber.getNumber());
            params.put("project_tmp", project);
            params.put("tracknumber_tmp", trackNumber);
            params.put("material", materialInfo);
            params.put("entryInfo", entryInfo);
            params.put("billInfo", mapeInfo);
            tree.run(ctx, project, null, params);
        }
        HashMap<String, MarketingPartEstimateInfo> re = new HashMap<String, MarketingPartEstimateInfo>();
        re.put("billInfo", mapeInfo);
        return re;
    }

    private class BomTree
    extends ProcessBomTree {
        int levelcou = 0;

        private BomTree() {
        }

        protected String getTreeTableSql() {
            StringBuilder sql = new StringBuilder();
            sql.append("Create Table ExpandBOMTable(\r\n");
            sql.append(" xh NVARCHAR(200) ,\r\n");
            sql.append("TREE_ID").append(" NVARCHAR(200) Not Null,\r\n");
            sql.append("TREE_PARENT_ID").append(" NVARCHAR(200) Null,\r\n");
            sql.append("TREE_BOM_ID").append(" VARCHAR(44) Not Null,\r\n");
            sql.append("TREE_PROJECT_ID").append(" VARCHAR(44) Not Null,\r\n");
            sql.append("TREE_TRACK_ID").append(" VARCHAR(44) Not Null,\r\n");
            sql.append("TREE_TRACK_NUMBER").append(" NVARCHAR(80) Not Null,\r\n");
            sql.append("TREE_MATERIAL_ID").append(" VARCHAR(44) Not Null,\r\n");
            sql.append("TREE_MATERIAL_NAME").append(" NVARCHAR(100) Not Null,\r\n");
            sql.append("TREE_MATERIAL_NUMBER").append(" NVARCHAR(80) Not Null,\r\n");
            sql.append("TREE_MATERIAL_PROP").append(" INT Null,\r\n");
            sql.append("TREE_FIXED").append(" Numeric(21,8) Default 0 Not Null,");
            sql.append(" model NVARCHAR(200),");
            sql.append(" measureUnit NVARCHAR(200),");
            sql.append("TREE_PARENT_MATERIAL_ID").append(" VARCHAR(44) Not Null,\r\n");
            sql.append("TREE_PARENT_MATERIAL_NAME").append(" NVARCHAR(100) Not Null,\r\n");
            sql.append("TREE_PARENT_MATERIAL_NUMBER").append(" NVARCHAR(80) Not Null,\r\n");
            sql.append("TREE_PARENT_MATERIAL_PROP").append(" INT Null,\r\n");
            sql.append("TREE_PARENT_FIXED").append(" Numeric(21,8) Default 0 Not Null,");
            sql.append("TREE_LONG_NUMBER").append(" NVARCHAR(2000) Not Null,");
            sql.append("level_long_number").append(" VARCHAR(2000) Not Null,");
            sql.append("TREE_LEVEL").append(" INT Default 0 Not Null,");
            sql.append("Expand_FIXED").append(" Numeric(21,8) Default 0 Not Null,");
            sql.append("TREE_BILL_FIXED").append(" Numeric(21,8) Default 0 Not Null,");
            sql.append("TREE_ISOWNOBJECT").append(" Int Default 0");
            sql.append(",").append("CFIsSplit").append(" Numeric(10)");
            sql.append(", cfweight Numeric(21,8),CFDrawBillOrgID VARCHAR(44),CFStorageOrgUnitID VARCHAR(44),CFUpdateRecord NVARCHAR(255),CFUsingRate Numeric(21,8)");
            sql.append(",CFQuantity Numeric(21,8),CFUnit NVARCHAR(100),cfinitMakeFlow NVARCHAR(100),cfmakeFlow NVARCHAR(100),cfnote NVARCHAR(100),cfstuffNo NVARCHAR(100),CFSizeLength Numeric(21,8),CFSizeWidth Numeric(21,8),CFSizeHheight Numeric(21,8)");
            sql.append(")");
            return sql.toString();
        }

        protected void insertInto() throws Exception {
            boolean level = true;
            StringBuilder insert = new StringBuilder();
            insert.append("insert into ").append(this.treeTable).append(" (");
            insert.append(" xh,");
            insert.append("TREE_ID");
            insert.append(",").append("TREE_PARENT_ID");
            insert.append(",").append("TREE_BOM_ID");
            insert.append(",").append("TREE_PROJECT_ID");
            insert.append(",").append("TREE_TRACK_ID");
            insert.append(",").append("TREE_TRACK_NUMBER");
            insert.append(",").append("TREE_MATERIAL_ID");
            insert.append(",").append("TREE_MATERIAL_NAME");
            insert.append(",").append("TREE_MATERIAL_NUMBER");
            insert.append(",").append("TREE_MATERIAL_PROP");
            insert.append(",").append("TREE_FIXED");
            insert.append(",model");
            insert.append(",measureUnit");
            insert.append(",").append("TREE_PARENT_MATERIAL_ID");
            insert.append(",").append("TREE_PARENT_MATERIAL_NAME");
            insert.append(",").append("TREE_PARENT_MATERIAL_NUMBER");
            insert.append(",").append("TREE_PARENT_MATERIAL_PROP");
            insert.append(",").append("TREE_PARENT_FIXED");
            insert.append(",").append("TREE_LONG_NUMBER");
            insert.append(",").append("level_long_number");
            insert.append(",").append("TREE_LEVEL");
            insert.append(",").append("Expand_FIXED");
            insert.append(",").append("TREE_BILL_FIXED");
            insert.append(",").append("TREE_ISOWNOBJECT");
            insert.append(",").append("CFIsSplit");
            insert.append(", cfweight,CFDrawBillOrgID,CFStorageOrgUnitID,CFUpdateRecord,CFUsingRate");
            insert.append(",CFQuantity,CFUnit,cfinitMakeFlow,cfmakeFlow,cfnote,cfstuffNo,CFSizeLength,CFSizeWidth,CFSizeHheight");
            insert.append(") \r\n (select ");
            insert.append(" rownum as xh,");
            insert.append("'").append(1).append("-'||rownum").append(" AS ").append("TREE_ID");
            insert.append(",null").append(" AS ").append("TREE_PARENT_ID");
            insert.append(",bom.fid").append(" AS ").append("TREE_BOM_ID");
            insert.append(",bom.CFProjectID").append(" AS ").append("TREE_PROJECT_ID");
            insert.append(",track.fid").append(" AS ").append("TREE_TRACK_ID");
            insert.append(",track.fnumber").append(" AS ").append("TREE_TRACK_NUMBER");
            insert.append(",m.fid").append(" AS ").append("TREE_MATERIAL_ID");
            insert.append(",m.fname_l2").append(" AS ").append("TREE_MATERIAL_NAME");
            insert.append(",m.fnumber").append(" AS ").append("TREE_MATERIAL_NUMBER");
            insert.append(",bom.CFMaterialProperty").append(" AS ").append("TREE_MATERIAL_PROP");
            insert.append(",bom.CFRation").append(" AS ").append("TREE_FIXED");
            insert.append(",m.Fmodel").append(" AS model");
            insert.append(",m.FbaseUnit").append(" AS mearsureUnit");
            insert.append(",mp.fid AS ").append("TREE_PARENT_MATERIAL_ID");
            insert.append(",bom.CFParentName AS ").append("TREE_PARENT_MATERIAL_NAME");
            insert.append(",bom.CFParentNo AS ").append("TREE_PARENT_MATERIAL_NUMBER");
            insert.append(",'").append(10030).append("' AS ").append("TREE_PARENT_MATERIAL_PROP");
            String fixed = (String)this.params.get("fixed");
            if (!StringUtils.isEmpty((String)fixed)) {
                insert.append(",").append(fixed).append(" AS ").append("TREE_PARENT_FIXED");
            } else {
                insert.append(",1").append(" AS ").append("TREE_PARENT_FIXED");
            }
            insert.append(",' '").append(" AS ").append("TREE_LONG_NUMBER");
            insert.append(",(case when rownum is not null then right(power(10,5-length(rownum))||'',5-length(rownum))||rownum else right(power(10,5-length(rownum))||'',5-length(rownum))||rownum end)");
            insert.append(",").append(1).append(" AS ").append("TREE_LEVEL");
            if (!StringUtils.isEmpty((String)fixed)) {
                insert.append(",isnull(bom.CFRation,0)*").append(fixed).append(" AS ").append("Expand_FIXED");
            } else {
                insert.append(",isnull(bom.CFRation,0)").append(" AS ").append("Expand_FIXED");
            }
            insert.append(",isnull(bom.CFRation,0)").append(" AS ").append("TREE_BILL_FIXED");
            insert.append(",\r\n").append("Case BOM.CFBOMMaterialPro When '1' Then 1 Else 0 End\r\n");
            insert.append(",\r\n bom.").append("CFIsSplit");
            insert.append(", bom.cfweight,bom.CFDrawBillOrgID,bom.CFStorageOrgUnitID,bom.CFUpdateRecord,bom.CFUsingRate");
            insert.append(",bom.CFQuantity,bom.CFUnit,bom.cfinitMakeFlow,bom.cfmakeFlow,bom.cfnote,bom.cfstuffNo,bom.CFSizeLength,bom.CFSizeWidth,bom.CFSizeHheight");
            insert.append(" from CT_ZJB_ProcessBomBill bom");
            insert.append(" left join T_BD_Material m on m.fid = bom.CFMaterialID");
            insert.append(" left join T_BD_Material mp on mp.fnumber = bom.CFParentNo");
            insert.append(" left Join T_MM_TrackNumber stn on stn.FID=bom.CFBeginCarnoID");
            insert.append(" left Join T_MM_TrackNumber etn on etn.FID=bom.CFEndCarnoID");
            insert.append(" ,T_MM_ProjectCar car left join T_MM_TrackNumber track on track.fid = car.ftrackNumberid ");
            ArrayList<Object> param = new ArrayList<Object>();
            insert.append(" where stn.FNumber <= track.FNumber and etn.FNumber >= track.FNumber and bom.CFProjectID = car.fprojectid ");
            insert.append(" and bom.CFRation is not null and bom.CFRation > 0");
            insert.append(" and bom.CFState = ?");
            param.add(4);
            insert.append(" and bom.CFProjectID = ?");
            param.add(this.project.getId().toString());
            if (this.params.get("material") != null) {
                insert.append(" and bom.CFParentNo = ?");
                MaterialInfo materialInfo = (MaterialInfo)this.params.get("material");
                param.add(materialInfo.getNumber());
            } else {
                insert.append(" and not exists (select 1 from CT_ZJB_ProcessBomBill where bom.CFParentNo = CFPortNo and bom.CFProjectID = CFProjectID)");
            }
            if (this.params.containsKey("prmtTrackBegin")) {
                insert.append(" and track.FNumber >= ?");
                param.add(this.params.get("prmtTrackBegin"));
            }
            if (this.params.containsKey("prmtTrackEnd")) {
                insert.append(" and track.FNumber <= ?");
                param.add(this.params.get("prmtTrackEnd"));
            }
            insert.append(" ) ");
            int count = ProcessBomTree.executeUpdate((Context)this.ctx, (String)insert.toString(), param);
            this.updateLongNumber(1);
            this.insertInto(2, count);
        }

        protected void insertInto(int level, int count) throws Exception {
            if (level == 30) {
                throw new EASBizException(new NumericExceptionSubItem("id_error", "GYBOMSZKQG" + level + "CQJCGYBOMSJSFYW"));
            }
            if (count == 0) {
                return;
            }
            StringBuilder insert = new StringBuilder();
            insert.append("insert into ").append(this.treeTable).append(" (");
            insert.append("TREE_ID");
            insert.append(",").append("TREE_PARENT_ID");
            insert.append(",").append("TREE_BOM_ID");
            insert.append(",").append("TREE_PROJECT_ID");
            insert.append(",").append("TREE_TRACK_ID");
            insert.append(",").append("TREE_TRACK_NUMBER");
            insert.append(",").append("TREE_MATERIAL_ID");
            insert.append(",").append("TREE_MATERIAL_NAME");
            insert.append(",").append("TREE_MATERIAL_NUMBER");
            insert.append(",").append("TREE_MATERIAL_PROP");
            insert.append(",").append("TREE_FIXED");
            insert.append(",model");
            insert.append(",measureUnit");
            insert.append(",").append("TREE_PARENT_MATERIAL_ID");
            insert.append(",").append("TREE_PARENT_MATERIAL_NAME");
            insert.append(",").append("TREE_PARENT_MATERIAL_NUMBER");
            insert.append(",").append("TREE_PARENT_MATERIAL_PROP");
            insert.append(",").append("TREE_PARENT_FIXED");
            insert.append(",").append("TREE_LONG_NUMBER");
            insert.append(",").append("level_long_number");
            insert.append(",").append("TREE_LEVEL");
            insert.append(",").append("Expand_FIXED");
            insert.append(",").append("TREE_BILL_FIXED");
            insert.append(",").append("TREE_ISOWNOBJECT");
            insert.append(",").append("CFIsSplit");
            insert.append(", cfweight,CFDrawBillOrgID,CFStorageOrgUnitID,CFUpdateRecord,CFUsingRate");
            insert.append(",CFQuantity,CFUnit,cfinitMakeFlow,cfmakeFlow,cfnote,cfstuffNo,CFSizeLength,CFSizeWidth,CFSizeHheight");
            insert.append(") \r\n (select ");
            insert.append("'").append(level).append("-'||rownum").append(" AS ").append("TREE_ID");
            insert.append(",tree.").append("TREE_ID").append(" AS ").append("TREE_PARENT_ID");
            insert.append(",bom.fid").append(" AS ").append("TREE_BOM_ID");
            insert.append(",bom.CFProjectID").append(" AS ").append("TREE_PROJECT_ID");
            insert.append(",track.fid").append(" AS ").append("TREE_TRACK_ID");
            insert.append(",track.fnumber").append(" AS ").append("TREE_TRACK_NUMBER");
            insert.append(",m.fid").append(" AS ").append("TREE_MATERIAL_ID");
            insert.append(",m.fname_l2").append(" AS ").append("TREE_MATERIAL_NAME");
            insert.append(",m.fnumber").append(" AS ").append("TREE_MATERIAL_NUMBER");
            insert.append(",bom.CFMaterialProperty").append(" AS ").append("TREE_MATERIAL_PROP");
            insert.append(",bom.CFRation").append(" AS ").append("TREE_FIXED");
            insert.append(",m.Fmodel").append(" AS model");
            insert.append(",m.FbaseUnit").append(" AS mearsureUnit");
            insert.append(",tree.").append("TREE_MATERIAL_ID").append(" AS ").append("TREE_PARENT_MATERIAL_ID");
            insert.append(",tree.").append("TREE_MATERIAL_NAME").append(" AS ").append("TREE_PARENT_MATERIAL_NAME");
            insert.append(",tree.").append("TREE_MATERIAL_NUMBER").append(" AS ").append("TREE_PARENT_MATERIAL_NUMBER");
            insert.append(",tree.").append("TREE_MATERIAL_PROP").append(" AS ").append("TREE_PARENT_MATERIAL_PROP");
            insert.append(",tree.").append("TREE_FIXED").append(" AS ").append("TREE_PARENT_FIXED");
            insert.append(",tree.").append("TREE_LONG_NUMBER").append(" AS ").append("TREE_LONG_NUMBER");
            insert.append(",tree.").append("level_long_number").append("||'.'||(case when bom.CFSeq is not null then right(power(10,5-length(bom.CFSeq))||'',5-length(bom.CFSeq))||bom.CFSeq else right(power(10,5-length(rownum))||'',5-length(rownum))||rownum end)");
            insert.append(",").append(level).append(" AS ").append("TREE_LEVEL");
            insert.append(", tree.").append("Expand_FIXED").append(" * isnull(bom.CFRation,0)");
            insert.append(", ( case when bom.CFMaterialProperty != ").append(10020).append(" and tree.").append("TREE_MATERIAL_PROP").append(" != ").append(10020).append(" then isnull(bom.CFRation,0)").append(" else tree.").append("TREE_BILL_FIXED").append(" * isnull(bom.CFRation,0)").append(" end ) ");
            insert.append(",\r\n").append("Case BOM.CFBOMMaterialPro When '1' Then 1 Else 0 End\r\n");
            insert.append(",bom.").append("CFIsSplit");
            insert.append(", bom.cfweight,bom.CFDrawBillOrgID,bom.CFStorageOrgUnitID,bom.CFUpdateRecord,bom.CFUsingRate");
            insert.append(",bom.CFQuantity,bom.CFUnit,bom.cfinitMakeFlow,bom.cfmakeFlow,bom.cfnote,bom.cfstuffNo,bom.CFSizeLength,bom.CFSizeWidth,bom.CFSizeHheight");
            insert.append(" from CT_ZJB_ProcessBomBill bom");
            insert.append(" left join T_BD_Material m on m.fid = bom.CFMaterialID");
            insert.append(" left Join T_MM_TrackNumber stn on stn.FID=bom.CFBeginCarnoID");
            insert.append(" left Join T_MM_TrackNumber etn on etn.FID=bom.CFEndCarnoID");
            insert.append(" ,T_MM_ProjectCar car left join T_MM_TrackNumber track on track.fid = car.ftrackNumberid ");
            insert.append(" ,").append(this.treeTable).append(" tree ");
            ArrayList<Object> param = new ArrayList<Object>();
            insert.append(" where stn.FNumber <= track.FNumber and etn.FNumber >= track.FNumber and bom.CFProjectID = car.fprojectid ");
            insert.append(" and tree.").append("TREE_MATERIAL_NUMBER").append(" = bom.CFParentNo");
            insert.append(" and tree.").append("TREE_TRACK_ID").append(" = track.fid");
            insert.append(" and tree.").append("TREE_ID").append(" is not null");
            insert.append(" and tree.").append("TREE_LEVEL").append(" = ?");
            param.add(level - 1);
            insert.append(" and bom.CFState = ?");
            param.add(4);
            insert.append(" and bom.CFProjectID = ?");
            param.add(this.project.getId().toString());
            insert.append(" ) ");
            count = ProcessBomTree.executeUpdate((Context)this.ctx, (String)insert.toString(), param);
            this.updateLongNumber(level);
            this.insertInto(level + 1, count);
        }

        protected void updateLongNumber(int level) throws Exception {
            super.updateLongNumber(level);
            if (level > 1) {
                StringBuffer selectSql = new StringBuffer();
                selectSql.setLength(0);
                selectSql.append("select TREE_ID,xh,level_long_number from " + this.treeTable);
                selectSql.append(" where TREE_LEVEL=" + (level - 1));
                IRowSet rss = DbUtil.executeQuery((Context)this.ctx, (String)selectSql.toString());
                while (rss.next()) {
                    String TREE_ID = rss.getString("TREE_ID");
                    String xuhao = rss.getString("xh");
                    String level_long_number = rss.getString("level_long_number");
                    selectSql.setLength(0);
                    selectSql.append(" /*dialect*/update " + this.treeTable).append(" tree");
                    selectSql.append(" set (tree.xh,level_long_number)=");
                    selectSql.append(" (select xh,rw from (select '" + xuhao + "'||'.'||rownum xh,t.TREE_ID,'" + level_long_number + "'||'.'||lpad(rownum,5,'0') as rw");
                    selectSql.append(" from " + this.treeTable + " t");
                    selectSql.append(" where t.TREE_LEVEL=" + level);
                    selectSql.append(" and t.TREE_PARENT_ID='" + TREE_ID + "'");
                    selectSql.append(") t where tree.TREE_ID=t.TREE_ID) where tree.TREE_LEVEL=" + level);
                    selectSql.append(" and tree.TREE_PARENT_ID='" + TREE_ID + "'");
                    DbUtil.execute((Context)this.ctx, (String)selectSql.toString());
                }
            }
            if (level > this.levelcou) {
                this.levelcou = level;
            }
        }

        protected void execute(String treeTemp, Map params) throws Exception {
            this.getMarketPartsEntry(treeTemp, params);
        }

        private void getMarketPartsEntry(String treeTemp, Map params) throws SQLException, BOSException {
            MarketingPartEstimateInfo billInfo = (MarketingPartEstimateInfo)params.get("billInfo");
            MarketingPartEstimateEntryInfo entryInfo = (MarketingPartEstimateEntryInfo)params.get("entryInfo");
            int count = billInfo.getEntrys().indexOf(entryInfo);
            billInfo.getEntrys().removeObject(count);
            entryInfo.setTag(1);
            billInfo.getEntrys().addObject(count, (IObjectValue)entryInfo);
            StringBuilder sql = new StringBuilder();
            sql.append(" /*dialect*/select tree.xh,tree.tree_material_id,tree.TREE_MATERIAL_NAME,tree.TREE_MATERIAL_NUMBER,tree.model,tree.measureUnit,");
            sql.append(" tree.tree_parent_material_id,tree.TREE_PARENT_MATERIAL_NAME,tree.TREE_PARENT_MATERIAL_NUMBER,");
            sql.append(" tree.CFQuantity,tree.TREE_FIXED,tree.Expand_FIXED,");
            sql.append(" tree.CFUnit,nvl(tree.cfweight, 0) * tree.Expand_FIXED,");
            sql.append(" tree.cfinitMakeFlow,tree.cfmakeFlow,");
            sql.append(" tree.TREE_MATERIAL_PROP,");
            sql.append(" tree.cfnote,tree.cfstuffNo,tree.tree_parent_id || tree.tree_id,tree.tree_level");
            sql.append(" from ").append(treeTemp).append(" tree");
            sql.append(" left join t_mm_bomEntry be on be.fid =tree.TREE_BOM_ID");
            sql.append(" left outer join t_mm_pbomentry pbe on  be.fid=pbe.fbomitemid");
            sql.append(" left outer join t_mm_pbom pb on pb.fid=pbe.fparentid");
            sql.append(" left outer join T_MM_MaterialRWP rwp on rwp.fid=pbe.froutingitemid");
            sql.append(" order by tree.level_long_number");
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
            int i = 1;
            MarketingPartEstimateEntryInfo entry = null;
            Object measuInfo = null;
            MaterialInfo lj = null;
            IMeasureUnit im = MeasureUnitFactory.getLocalInstance((Context)this.ctx);
            IMaterial imea = MaterialFactory.getLocalInstance((Context)this.ctx);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("model"));
            sic.add(new SelectorItemInfo("baseUnit.id"));
            sic.add(new SelectorItemInfo("baseUnit.name"));
            sic.add(new SelectorItemInfo("baseUnit.number"));
            while (rs.next()) {
                entry = new MarketingPartEstimateEntryInfo();
                entry.setShowSeq(entryInfo.getShowSeq() + "." + rs.getString("xh"));
                String maString = rs.getString("tree_material_id");
                if (maString != null) {
                    try {
                        lj = imea.getMaterialInfo((IObjectPK)new ObjectUuidPK(maString), sic);
                    }
                    catch (EASBizException e) {
                        e.printStackTrace();
                    }
                    entry.setMaterial(lj);
                    entry.setMaterialName(lj.getName());
                    entry.setModels(lj.getModel());
                    entry.setMeasureUnit(lj.getBaseUnit());
                }
                entry.setTag(2);
                entry.setRiskCoefficient(new BigDecimal(1.0));
                billInfo.getEntrys().addObject(count + i++, (IObjectValue)entry);
            }
        }

        protected Map getRelationPerp(MaterialInfo materialInfo, MarketingPartEstimateEntryInfo entry) {
            if (materialInfo == null) {
                return null;
            }
            HashMap<String, Object> mapSet = new HashMap<String, Object>();
            EntityViewInfo evi = new EntityViewInfo();
            evi.setSelector(new SelectorItemCollection());
            evi.getSelector().add(new SelectorItemInfo("estimatePrice"));
            evi.getSelector().add(new SelectorItemInfo("targetPrice"));
            evi.setFilter(new FilterInfo());
            evi.getFilter().getFilterItems().add(new FilterItemInfo("materialNumber.number", (Object)materialInfo.getNumber(), CompareType.EQUALS));
            evi.getFilter().getFilterItems().add(new FilterItemInfo("status", (Object)2, CompareType.EQUALS));
            evi.setSorter(new SorterItemCollection());
            SorterItemInfo itemInfo = new SorterItemInfo("updateDate");
            itemInfo.setSortType(SortType.DESCEND);
            evi.getSorter().add(itemInfo);
            MarketFitPriceStorageCollection collection = null;
            try {
                collection = MarketFitPriceStorageFactory.getLocalInstance(this.ctx).getMarketFitPriceStorageCollection(evi);
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            BigDecimal estimatePrice = null;
            BigDecimal targetCost = null;
            if (collection.size() != 0) {
                estimatePrice = collection.get(0).getEstimatePrice();
                targetCost = collection.get(0).getTargetPrice();
            }
            mapSet.put("estimatePrice", estimatePrice);
            mapSet.put("targetCost", targetCost);
            evi = new EntityViewInfo();
            evi.setSelector(new SelectorItemCollection());
            evi.getSelector().add(new SelectorItemInfo("latestPurPrice"));
            evi.getSelector().add(new SelectorItemInfo("maxPurPrice"));
            evi.setFilter(new FilterInfo());
            evi.getFilter().getFilterItems().add(new FilterItemInfo("materialNumber.number", (Object)materialInfo.getNumber(), CompareType.EQUALS));
            evi.getFilter().getFilterItems().add(new FilterItemInfo("status", (Object)2, CompareType.EQUALS));
            evi.setSorter(new SorterItemCollection());
            SorterItemInfo itemInfo1 = new SorterItemInfo("updateTime");
            itemInfo1.setSortType(SortType.DESCEND);
            evi.getSorter().add(itemInfo1);
            PurMaterialPriceStorageCollection pmpCollection = null;
            try {
                pmpCollection = PurMaterialPriceStorageFactory.getLocalInstance(this.ctx).getPurMaterialPriceStorageCollection(evi);
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            BigDecimal latestPurPrice = null;
            BigDecimal maxPurPrice = null;
            if (pmpCollection.size() != 0) {
                latestPurPrice = pmpCollection.get(0).getLatestPurPrice();
                maxPurPrice = pmpCollection.get(0).getMaxPurPrice();
            }
            mapSet.put("latestPurPrice", latestPurPrice);
            mapSet.put("maxPurPrice", maxPurPrice);
            BigDecimal newPurPrice = latestPurPrice;
            BigDecimal highPurPrice = maxPurPrice;
            BigDecimal inquiryPrice = BigDecimal.ZERO;
            BigDecimal estPrice = estimatePrice;
            BigDecimal riskCoefficient = entry.getRiskCoefficient();
            BigDecimal price = null;
            String priceSource = "";
            if (estimatePrice != BigDecimal.ZERO && estimatePrice != null) {
                price = estimatePrice;
                priceSource = EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costmanagement.EMMPCCostMageResource", (String)"0EMMCOSTMANAGER-0009", (Locale)this.ctx.getLocale());
            }
            if (highPurPrice != BigDecimal.ZERO && highPurPrice != null) {
                price = highPurPrice;
                priceSource = EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costmanagement.EMMPCCostMageResource", (String)"0EMMCOSTMANAGER-0010", (Locale)this.ctx.getLocale());
            }
            if (newPurPrice != BigDecimal.ZERO && newPurPrice != null) {
                price = newPurPrice;
                priceSource = EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costmanagement.EMMPCCostMageResource", (String)"0EMMCOSTMANAGER-0011", (Locale)this.ctx.getLocale());
            }
            if (inquiryPrice != BigDecimal.ZERO && inquiryPrice != null) {
                price = inquiryPrice;
                priceSource = EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costmanagement.EMMPCCostMageResource", (String)"0EMMCOSTMANAGER-0012", (Locale)this.ctx.getLocale());
            }
            if (estPrice != BigDecimal.ZERO && estPrice != null) {
                price = estPrice;
                priceSource = EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costmanagement.EMMPCCostMageResource", (String)"0EMMCOSTMANAGER-0013", (Locale)this.ctx.getLocale());
            }
            mapSet.put("priceSource", priceSource);
            mapSet.put("price", price != null ? price.multiply(riskCoefficient) : null);
            return mapSet;
        }
    }
}

