/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.pcm.costmanagement.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.industry.emm.pcm.EstimateBillSpareEntryCollection;
import com.kingdee.eas.industry.emm.pcm.EstimateBillSpareEntryFactory;
import com.kingdee.eas.industry.emm.pcm.EstimateBillSpareEntryInfo;
import com.kingdee.eas.industry.emm.pcm.basedata.ClassificationCodeFactory;
import com.kingdee.eas.industry.emm.pcm.basedata.ClassificationCodeInfo;
import com.kingdee.eas.industry.emm.pcm.basedata.ProjectTypesFactory;
import com.kingdee.eas.industry.emm.pcm.basedata.ProjectTypesInfo;
import com.kingdee.eas.industry.emm.pcm.basedata.PurMaterialPriceStorageCollection;
import com.kingdee.eas.industry.emm.pcm.basedata.PurMaterialPriceStorageFactory;
import com.kingdee.eas.industry.emm.pcm.basedata.SparePartPriceCollection;
import com.kingdee.eas.industry.emm.pcm.basedata.SparePartPriceFactory;
import com.kingdee.eas.industry.emm.pcm.basedata.VehicleTypeInfo;
import com.kingdee.eas.industry.emm.pcm.costmanagement.SparePartsExeEstimateEntryCollection;
import com.kingdee.eas.industry.emm.pcm.costmanagement.SparePartsExeEstimateEntryInfo;
import com.kingdee.eas.industry.emm.pcm.costmanagement.SparePartsExeEstimateInfo;
import com.kingdee.eas.industry.emm.pcm.costmanagement.app.AbstractSparePartsExeEstimateControllerBean;
import com.kingdee.eas.industry.emm.pcm.costmanagement.app.SparePartsHelper;
import com.kingdee.eas.industry.emm.pcm.spareparts.SparePartJZPriceCollection;
import com.kingdee.eas.industry.emm.pcm.spareparts.SparePartJZPriceFactory;
import com.kingdee.eas.industry.emm.pcm.util.PcmTreeBillHelper;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import org.apache.log4j.Logger;

public class SparePartsExeEstimateControllerBean
extends AbstractSparePartsExeEstimateControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.industry.emm.pcm.costmanagement.app.SparePartsExeEstimateControllerBean");

    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        SparePartsExeEstimateInfo info = (SparePartsExeEstimateInfo)model;
        if (info == null) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costmanagement.EMMPCCostMageResource", (String)"0EMMCOSTMANAGER-0000", (Locale)ctx.getLocale())));
        }
        if (info.getBaseStatus() != BillBaseStatusEnum.SUBMITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costmanagement.EMMPCCostMageResource", (String)"0EMMCOSTMANAGER-0001", (Locale)ctx.getLocale())));
        }
        info.setBaseStatus(BillBaseStatusEnum.AUDITED);
        info.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
        info.setAuditDate(new Date());
        super.update(ctx, pk, (CoreBaseInfo)info);
    }

    protected void _unpassAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        SparePartsExeEstimateInfo info = (SparePartsExeEstimateInfo)model;
        if (info == null) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costmanagement.EMMPCCostMageResource", (String)"0EMMCOSTMANAGER-0000", (Locale)ctx.getLocale())));
        }
        if (info.getBaseStatus() != BillBaseStatusEnum.AUDITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costmanagement.EMMPCCostMageResource", (String)"0EMMCOSTMANAGER-0002", (Locale)ctx.getLocale())));
        }
        info.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        info.setAuditor(null);
        info.setAuditDate(null);
        this._checkIsHaveDestBills(ctx, (CoreBaseInfo)info);
        super.update(ctx, pk, (CoreBaseInfo)info);
    }

    protected void _checkIsHaveDestBills(Context ctx, CoreBaseInfo billInfo) throws EASBizException, BOSException {
        String billIdString;
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        if (iBTPManager.ifHaveDestBills(billIdString = billInfo.getId().toString())) {
            throw new SCMBillException(SCMBillException.HASDESTBILL_CANNOTUNAUDIT, new Object[]{billInfo.getString("number")});
        }
    }

    protected void check(Context ctx, SparePartsExeEstimateInfo eti) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)eti.getNumber(), CompareType.EQUALS));
        if (eti.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)eti.getId().toString(), CompareType.NOTEQUALS));
        }
        if (this._exists(ctx, filter)) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costmanagement.EMMPCCostMageResource", (String)"0EMMCOSTMANAGER-0003", (Locale)ctx.getLocale())));
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        SparePartsExeEstimateInfo eti = (SparePartsExeEstimateInfo)model;
        this.checkHead(ctx, eti);
        this.check(ctx, eti);
        this.checkEntry(ctx, eti);
        this.updateEstimate(ctx, eti);
        SparePartsHelper.insertTotalRowByClassCode(model, ctx);
        SparePartsHelper.sortMaterialEntryColl((IObjectCollection)eti.getEntrys());
        if (eti.getBaseStatus() != BillBaseStatusEnum.TEMPORARILYSAVED && eti.getBaseStatus() != BillBaseStatusEnum.SUBMITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costmanagement.EMMPCCostMageResource", (String)"0EMMCOSTMANAGER-0004", (Locale)ctx.getLocale())));
        }
        eti.setBaseStatus(BillBaseStatusEnum.SUBMITED);
        return super._submit(ctx, model);
    }

    private void updateEstimate(Context ctx, SparePartsExeEstimateInfo eti) throws EASBizException, BOSException {
        ProjectInfo projectInfo = eti.getProject();
        HashSet<String> codeSet = new HashSet<String>();
        for (int i = 0; i < eti.getEntrys().size(); ++i) {
            SparePartsExeEstimateEntryInfo entryInfo = eti.getEntrys().get(i);
            if (entryInfo.getIdCode() == null) continue;
            codeSet.add(entryInfo.getIdCode());
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add(new SelectorItemInfo("parent.number"));
        evi.getSelector().add(new SelectorItemInfo("discCode"));
        evi.getSelector().add(new SelectorItemInfo("techProjectQty"));
        evi.getSelector().add(new SelectorItemInfo("estimateUnitPrice"));
        evi.getSelector().add(new SelectorItemInfo("projcetCost"));
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("parent.spareProject.number", (Object)projectInfo.getNumber(), CompareType.EQUALS));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("discCode", codeSet, CompareType.INCLUDE));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("parent.status", (Object)4, CompareType.EQUALS));
        EstimateBillSpareEntryCollection collection = EstimateBillSpareEntryFactory.getLocalInstance(ctx).getEstimateBillSpareEntryCollection(evi);
        if (collection.size() > 0) {
            String fnumber = collection.get(0).getParent().getNumber();
            for (int i = 0; i < collection.size(); ++i) {
                if (fnumber.equals(collection.get(i).getParent().getNumber())) continue;
                throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costmanagement.EMMPCCostMageResource", (String)"0EMMCOSTMANAGER-0020", (Locale)ctx.getLocale())));
            }
        }
        block2: for (int i = 0; i < eti.getEntrys().size(); ++i) {
            SparePartsExeEstimateEntryInfo entryInfo = eti.getEntrys().get(i);
            if (entryInfo.getIdCode() == null || entryInfo.getIdCode().equals("")) continue;
            for (int j = 0; j < collection.size(); ++j) {
                EstimateBillSpareEntryInfo billEntryInfo = collection.get(j);
                if (!entryInfo.getIdCode().equals(billEntryInfo.getDiscCode())) continue;
                entryInfo.setProjectBidEstQty(billEntryInfo.getTechProjectQty());
                entryInfo.setBidEstimatePrice(billEntryInfo.getEstimateUnitPrice());
                entryInfo.setProjectCost(billEntryInfo.getProjcetCost());
                continue block2;
            }
        }
    }

    private void checkHead(Context ctx, SparePartsExeEstimateInfo info) throws EASBizException {
        if (info.getNumber() == null) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costmanagement.EMMPCCostMageResource", (String)"0EMMCOSTMANAGER-0021", (Locale)ctx.getLocale())));
        }
        if (info.getProject() == null) {
            throw new EASBizException(new NumericExceptionSubItem("", info.getNumber() + EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costmanagement.EMMPCCostMageResource", (String)"0EMMCOSTMANAGER-0022", (Locale)ctx.getLocale())));
        }
        if (info.getProjectTypes() == null) {
            throw new EASBizException(new NumericExceptionSubItem("", info.getNumber() + EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costmanagement.EMMPCCostMageResource", (String)"0EMMCOSTMANAGER-0023", (Locale)ctx.getLocale())));
        }
        if (info.getVehicleType() == null) {
            throw new EASBizException(new NumericExceptionSubItem("", info.getNumber() + EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costmanagement.EMMPCCostMageResource", (String)"0EMMCOSTMANAGER-0024", (Locale)ctx.getLocale())));
        }
        if (info.getAdminOrgUnit() == null) {
            throw new EASBizException(new NumericExceptionSubItem("", info.getNumber() + EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costmanagement.EMMPCCostMageResource", (String)"0EMMCOSTMANAGER-0025", (Locale)ctx.getLocale())));
        }
        if (info.getBizDate() == null || info.get("bizDate").equals("")) {
            throw new EASBizException(new NumericExceptionSubItem("", info.getNumber() + EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costmanagement.EMMPCCostMageResource", (String)"0EMMCOSTMANAGER-0026", (Locale)ctx.getLocale())));
        }
    }

    private void checkEntry(Context ctx, SparePartsExeEstimateInfo info) throws EASBizException {
        SparePartsExeEstimateEntryCollection entryCollection = info.getEntrys();
        for (int i = 0; i < entryCollection.size(); ++i) {
            BigDecimal riskCoefficient;
            SparePartsExeEstimateEntryInfo entryInfo = entryCollection.get(i);
            if (entryInfo.isIsTotalRow()) continue;
            MaterialInfo materialInfo = entryInfo.getMaterial();
            StringBuffer tmpStr = new StringBuffer();
            if (entryInfo.getMaterialName() == null) {
                tmpStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costmanagement.EMMPCCostMageResource", (String)"0EMMCOSTMANAGER-0027", (Locale)ctx.getLocale()));
            }
            if (entryInfo.getMeasureUnit() == null) {
                tmpStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costmanagement.EMMPCCostMageResource", (String)"0EMMCOSTMANAGER-0028", (Locale)ctx.getLocale()));
            }
            if (entryInfo.getClassIfiCationCode() != null) {
                try {
                    ProjectTypesInfo projectTypesInfo = ProjectTypesFactory.getLocalInstance(ctx).getProjectTypesInfo((IObjectPK)new ObjectUuidPK(info.getProjectTypes().getId()));
                    ClassificationCodeInfo codeInfo = ClassificationCodeFactory.getLocalInstance(ctx).getClassificationCodeInfo((IObjectPK)new ObjectUuidPK(entryInfo.getClassIfiCationCode().getId()));
                    if (!projectTypesInfo.getId().toString().equals(codeInfo.getProjectTypes().getId().toString())) {
                        tmpStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costmanagement.EMMPCCostMageResource", (String)"0EMMCOSTMANAGER-0029", (Locale)ctx.getLocale()));
                    }
                    entryInfo.setClassName(codeInfo.getName());
                    entryInfo.setClassAttr(codeInfo.getAttribute());
                }
                catch (BOSException e1) {
                    e1.printStackTrace();
                }
            }
            EntityViewInfo evi = new EntityViewInfo();
            if (materialInfo != null) {
                evi = new EntityViewInfo();
                try {
                    materialInfo = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(entryInfo.getMaterial().getId()));
                }
                catch (BOSException e2) {
                    e2.printStackTrace();
                }
                entryInfo.setMaterialName(materialInfo.getName());
                entryInfo.setModel(materialInfo.getModel());
                entryInfo.setMeasureUnit(materialInfo.getBaseUnit());
                evi.setSelector(new SelectorItemCollection());
                evi.getSelector().add(new SelectorItemInfo("latestPurPrice"));
                evi.getSelector().add(new SelectorItemInfo("maxPurPrice"));
                evi.setFilter(new FilterInfo());
                evi.getFilter().getFilterItems().add(new FilterItemInfo("materialNumber.number", (Object)materialInfo.getNumber(), CompareType.EQUALS));
                evi.getFilter().getFilterItems().add(new FilterItemInfo("status", (Object)2, CompareType.EQUALS));
                evi.setSorter(new SorterItemCollection());
                SorterItemInfo itemInfo = new SorterItemInfo("updateTime");
                itemInfo.setSortType(SortType.DESCEND);
                evi.getSorter().add(itemInfo);
                PurMaterialPriceStorageCollection pmpCollection = null;
                try {
                    pmpCollection = PurMaterialPriceStorageFactory.getLocalInstance(ctx).getPurMaterialPriceStorageCollection(evi);
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
                BigDecimal latestPurPrice = null;
                if (pmpCollection.size() != 0) {
                    latestPurPrice = pmpCollection.get(0).getLatestPurPrice();
                }
                entryInfo.setNewPurPrice(latestPurPrice);
            } else {
                entryInfo.setNewPurPrice(null);
            }
            ProjectInfo projectInfo = entryInfo.getReferProName();
            if (materialInfo != null && projectInfo != null) {
                evi = new EntityViewInfo();
                evi.setSelector(new SelectorItemCollection());
                evi.getSelector().add(new SelectorItemInfo("estPrice"));
                evi.getSelector().add(new SelectorItemInfo("actPurPrice"));
                evi.setFilter(new FilterInfo());
                evi.getFilter().getFilterItems().add(new FilterItemInfo("project.number", (Object)projectInfo.getNumber(), CompareType.EQUALS));
                evi.getFilter().getFilterItems().add(new FilterItemInfo("material.number", (Object)materialInfo.getNumber(), CompareType.EQUALS));
                evi.getFilter().getFilterItems().add(new FilterItemInfo("updateDate is not null"));
                evi.setSorter(new SorterItemCollection());
                SorterItemInfo itemInfo1 = new SorterItemInfo("updateDate");
                itemInfo1.setSortType(SortType.DESCEND);
                evi.getSorter().add(itemInfo1);
                SparePartPriceCollection pmpCollection1 = null;
                try {
                    pmpCollection1 = SparePartPriceFactory.getLocalInstance(ctx).getSparePartPriceCollection(evi);
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
                BigDecimal actualPurPrice = null;
                if (pmpCollection1.size() != 0 && !PcmTreeBillHelper.isBigDecimalEmptyAndZero(pmpCollection1.get(0).getActPurPrice())) {
                    actualPurPrice = pmpCollection1.get(0).getActPurPrice();
                }
                entryInfo.setReferProCarPrice(actualPurPrice);
            } else {
                entryInfo.setReferProCarPrice(null);
            }
            String idcode = entryInfo.getIdCode();
            VehicleTypeInfo vehicleTypeInfo = info.getVehicleType();
            if (idcode != null && vehicleTypeInfo != null) {
                evi = new EntityViewInfo();
                evi.setSelector(new SelectorItemCollection());
                evi.getSelector().add(new SelectorItemInfo("qty"));
                evi.getSelector().add(new SelectorItemInfo("price"));
                evi.setFilter(new FilterInfo());
                evi.getFilter().getFilterItems().add(new FilterItemInfo("vehicleType.number", (Object)vehicleTypeInfo.getNumber(), CompareType.EQUALS));
                evi.getFilter().getFilterItems().add(new FilterItemInfo("idCode", (Object)idcode, CompareType.EQUALS));
                evi.getFilter().getFilterItems().add(new FilterItemInfo("IsCheck", (Object)true, CompareType.EQUALS));
                evi.setSorter(new SorterItemCollection());
                SparePartJZPriceCollection pmpCollection = null;
                try {
                    pmpCollection = SparePartJZPriceFactory.getLocalInstance(ctx).getSparePartJZPriceCollection(evi);
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
                BigDecimal actualPurPrice = null;
                if (pmpCollection.size() != 0 && !PcmTreeBillHelper.isBigDecimalEmptyAndZero(pmpCollection.get(0).getPrice())) {
                    actualPurPrice = pmpCollection.get(0).getPrice();
                }
                entryInfo.setProjectPriceBase(actualPurPrice);
            }
            BigDecimal execPrice = BigDecimal.ZERO;
            String priceSource = "";
            if (entryInfo.getConfigPrice() != null && entryInfo.getConfigPrice() != BigDecimal.ZERO) {
                execPrice = entryInfo.getConfigPrice();
                priceSource = EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costmanagement.EMMPCCostMageResource", (String)"0EMMCOSTMANAGER-0030", (Locale)ctx.getLocale());
            }
            if (entryInfo.getNewPurPrice() != null && entryInfo.getNewPurPrice() != BigDecimal.ZERO) {
                execPrice = entryInfo.getNewPurPrice();
                priceSource = EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costmanagement.EMMPCCostMageResource", (String)"0EMMCOSTMANAGER-0031", (Locale)ctx.getLocale());
            }
            if (entryInfo.getProjectPriceBase() != null && entryInfo.getProjectPriceBase() != BigDecimal.ZERO) {
                execPrice = entryInfo.getProjectPriceBase();
                priceSource = EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costmanagement.EMMPCCostMageResource", (String)"0EMMCOSTMANAGER-0032", (Locale)ctx.getLocale());
            }
            if (entryInfo.getReferProCarPrice() != null && entryInfo.getReferProCarPrice() != BigDecimal.ZERO) {
                execPrice = entryInfo.getReferProCarPrice();
                priceSource = projectInfo == null ? EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costmanagement.EMMPCCostMageResource", (String)"0EMMCOSTMANAGER-0033", (Locale)ctx.getLocale()) + projectInfo + EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costmanagement.EMMPCCostMageResource", (String)"0EMMCOSTMANAGER-0034", (Locale)ctx.getLocale()) : EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costmanagement.EMMPCCostMageResource", (String)"0EMMCOSTMANAGER-0033", (Locale)ctx.getLocale()) + projectInfo.getNumber() + ":" + projectInfo.getName() + EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costmanagement.EMMPCCostMageResource", (String)"0EMMCOSTMANAGER-0034", (Locale)ctx.getLocale());
            }
            if (entryInfo.getAskPrice() != null && entryInfo.getAskPrice() != BigDecimal.ZERO) {
                execPrice = entryInfo.getAskPrice();
                priceSource = EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costmanagement.EMMPCCostMageResource", (String)"0EMMCOSTMANAGER-0012", (Locale)ctx.getLocale());
            }
            if (entryInfo.getEstimatePrice() != null && entryInfo.getEstimatePrice() != BigDecimal.ZERO) {
                execPrice = entryInfo.getEstimatePrice();
                priceSource = EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costmanagement.EMMPCCostMageResource", (String)"0EMMCOSTMANAGER-0013", (Locale)ctx.getLocale());
            }
            entryInfo.setExecEstimatePrice(execPrice);
            entryInfo.setPriceSource(priceSource);
            if (PcmTreeBillHelper.isBigDecimalEmptyAndZero(entryInfo.getExeProjectQty())) {
                tmpStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costmanagement.EMMPCCostMageResource", (String)"0EMMCOSTMANAGER-0035", (Locale)ctx.getLocale()));
            }
            if (PcmTreeBillHelper.isBigDecimalEmptyAndZero(entryInfo.getExecEstimatePrice())) {
                tmpStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costmanagement.EMMPCCostMageResource", (String)"0EMMCOSTMANAGER-0036", (Locale)ctx.getLocale()));
            }
            BigDecimal bigDecimal = riskCoefficient = entryInfo.getRiskCoefficient() == null ? BigDecimal.ZERO : entryInfo.getRiskCoefficient();
            if (tmpStr.length() > 0) {
                throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costmanagement.EMMPCCostMageResource", (String)"0EMMCOSTMANAGER-0037", (Locale)ctx.getLocale()) + (i + 1) + EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costmanagement.EMMPCCostMageResource", (String)"0EMMCOSTMANAGER-0016", (Locale)ctx.getLocale()) + tmpStr.toString()));
            }
            if (!PcmTreeBillHelper.isBigDecimalEmptyAndZero(riskCoefficient)) {
                entryInfo.setRiskPrice(riskCoefficient.multiply(entryInfo.getExecEstimatePrice().multiply(entryInfo.getExeProjectQty())));
            }
            if (entryInfo.getRiskPrice() == null) {
                entryInfo.setRiskPrice(BigDecimal.ZERO);
            }
            entryInfo.setExecProjectCost(entryInfo.getExeProjectQty().multiply(entryInfo.getExecEstimatePrice()).add(entryInfo.getRiskPrice()));
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SparePartsExeEstimateInfo info = this.getSparePartsExeEstimateInfo(ctx, pk);
        if (info.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costmanagement.EMMPCCostMageResource", (String)"0EMMCOSTMANAGER-0017", (Locale)ctx.getLocale()) + info.getNumber() + EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costmanagement.EMMPCCostMageResource", (String)"0EMMCOSTMANAGER-0018", (Locale)ctx.getLocale())));
        }
        super._delete(ctx, pk);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        SparePartsExeEstimateInfo eti = (SparePartsExeEstimateInfo)model;
        this.checkHead(ctx, eti);
        this.check(ctx, eti);
        this.checkEntry(ctx, eti);
        this.updateEstimate(ctx, eti);
        SparePartsHelper.insertTotalRowByClassCode(model, ctx);
        SparePartsHelper.sortMaterialEntryColl((IObjectCollection)eti.getEntrys());
        if (eti.getBaseStatus() != BillBaseStatusEnum.TEMPORARILYSAVED && eti.getBaseStatus() != BillBaseStatusEnum.ADD) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costmanagement.EMMPCCostMageResource", (String)"0EMMCOSTMANAGER-0019", (Locale)ctx.getLocale())));
        }
        eti.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        return super._save(ctx, model);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return super._addnew(ctx, model);
    }
}

