/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.pcm.costmanagement.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBillEntryBaseInfo;
import com.kingdee.eas.industry.emm.pcm.EstimateBillInfo;
import com.kingdee.eas.industry.emm.pcm.basedata.ClassificationCodeInfo;
import com.kingdee.eas.industry.emm.pcm.costmanagement.SparePartsExeEstimateInfo;
import com.kingdee.eas.industry.emm.pcm.spareparts.SparePartsCalculationInfo;
import com.kingdee.eas.industry.emm.pcm.spareparts.SparePartsTargetCostInfo;
import com.kingdee.eas.scm.cal.util.DBUtil;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;

public class SparePartsHelper {
    static Comparator materialEntryComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            int j;
            String str;
            int i;
            IObjectValue io1 = (IObjectValue)o1;
            IObjectValue io2 = (IObjectValue)o2;
            String code1 = io1.get("idCodeName") == null ? "" : io1.get("idCodeName").toString();
            String code2 = io2.get("idCodeName") == null ? "" : io2.get("idCodeName").toString();
            io1.getObjectValue("classIfiCationCode");
            if (code2 == null) {
                return -1;
            }
            if (code1 == null) {
                return 1;
            }
            String[] codeStrOne = code1.split("\\.");
            String[] codeStrTwo = code2.split("\\.");
            String codeOne = "";
            String codeTwo = "";
            for (i = 0; i < codeStrOne.length; ++i) {
                str = "";
                for (j = 0; j < 4 - codeStrOne[i].length(); ++j) {
                    str = str + "0";
                }
                codeOne = codeOne + str + codeStrOne[i];
            }
            for (i = 0; i < codeStrTwo.length; ++i) {
                str = "";
                for (j = 0; j < 4 - codeStrTwo[i].length(); ++j) {
                    str = str + "0";
                }
                codeTwo = codeTwo + str + codeStrTwo[i];
            }
            if (codeOne.compareTo(codeTwo) != 0) {
                return codeOne.compareTo(codeTwo);
            }
            if (io1.getBoolean("isTotalRow")) {
                return -1;
            }
            if (io2.getBoolean("isTotalRow")) {
                return 1;
            }
            MaterialInfo material1 = (MaterialInfo)io1.getObjectValue("material");
            MaterialInfo material2 = (MaterialInfo)io2.getObjectValue("material");
            if (material1 == null && material2 == null) {
                String materialName1 = io1.getString("materialName");
                String materialName2 = io2.getString("materialName");
                if (materialName2 == null) {
                    return -1;
                }
                if (materialName1 == null) {
                    return 1;
                }
                return materialName1.compareTo(materialName2);
            }
            if (material2 == null) {
                return -1;
            }
            if (material1 == null) {
                return 1;
            }
            return material1.compareTo((Object)material2);
        }
    };

    public static void sortMaterialEntryColl(IObjectCollection coll) {
        Object[] a = coll.toArray();
        Arrays.sort(a, materialEntryComparator);
        coll.clear();
        for (int j = 0; j < a.length; ++j) {
            coll.addObject((IObjectValue)a[j]);
        }
    }

    public static void insertTotalRowByClassCode(IObjectValue model, Context ctx) throws BOSException, EASBizException {
        BigDecimal costAmount;
        String colIdName;
        CoreBillEntryBaseInfo iov;
        int j;
        CoreBillEntryBaseInfo createRow;
        BigDecimal totalCostAmount;
        String idcodeName;
        String codeName;
        IObjectCollection coll = (IObjectCollection)model.get("entrys");
        if (model instanceof EstimateBillInfo) {
            coll = (IObjectCollection)model.get("SpareEntry");
        }
        String costKey = "execProjectCost";
        if (model instanceof EstimateBillInfo) {
            costKey = "projcetCost";
        } else if (model instanceof SparePartsExeEstimateInfo) {
            costKey = "execProjectCost";
        } else if (model instanceof SparePartsCalculationInfo) {
            costKey = "calcProjectCost";
        } else if (model instanceof SparePartsTargetCostInfo) {
            costKey = "targetCost";
        }
        String idCodeNameAll = "idCodeName";
        if (model instanceof EstimateBillInfo) {
            idCodeNameAll = "discName";
        }
        HashSet<String> top1 = new HashSet<String>();
        HashSet<String> top2 = new HashSet<String>();
        HashSet totalRow = new HashSet();
        for (int i = 0; i < coll.size(); ++i) {
            CoreBillEntryBaseInfo coreBillEntryBaseInfo = (CoreBillEntryBaseInfo)coll.getObject(i);
            String idCodeName = coreBillEntryBaseInfo.get(idCodeNameAll) == null ? "" : coreBillEntryBaseInfo.getString(idCodeNameAll);
            String[] codeName2 = idCodeName.split("\\.");
            if (idCodeName.equals("") || idCodeName == "") continue;
            if (coreBillEntryBaseInfo.getBoolean("isTotalRow")) {
                coll.removeObject(i);
                --i;
                continue;
            }
            if (codeName2.length == 1) {
                top1.add(idCodeName);
            }
            if (codeName2.length != 2) continue;
            top2.add(idCodeName);
        }
        for (Object e : top2) {
            codeName = e.toString();
            idcodeName = codeName.split(":")[0];
            totalCostAmount = BigDecimal.ZERO;
            createRow = (CoreBillEntryBaseInfo)((CoreBillEntryBaseInfo)coll.getObject(0)).clone();
            createRow.clear();
            for (j = 0; j < coll.size(); ++j) {
                iov = (CoreBillEntryBaseInfo)coll.getObject(j);
                String string = colIdName = iov.get(idCodeNameAll) == null ? "" : iov.getString(idCodeNameAll);
                if (!idcodeName.equals(colIdName) && (colIdName.split("\\.").length != 3 || !(colIdName.split("\\.")[0] + "." + colIdName.split("\\.")[1]).equals(idcodeName) || iov.getBoolean("isTotalRow"))) continue;
                costAmount = iov.getBigDecimal(costKey) == null ? BigDecimal.ZERO : iov.getBigDecimal(costKey);
                totalCostAmount = totalCostAmount.add(costAmount);
            }
            createRow.setString(idCodeNameAll, idcodeName);
            createRow.setBigDecimal(costKey, totalCostAmount);
            createRow.setBoolean("isTotalRow", true);
            coll.addObject((IObjectValue)createRow);
        }
        for (Object e : top1) {
            codeName = e.toString();
            idcodeName = codeName.split(":")[0];
            totalCostAmount = BigDecimal.ZERO;
            createRow = (CoreBillEntryBaseInfo)((CoreBillEntryBaseInfo)coll.getObject(0)).clone();
            createRow.clear();
            for (j = 0; j < coll.size(); ++j) {
                iov = (CoreBillEntryBaseInfo)coll.getObject(j);
                String string = colIdName = iov.get(idCodeNameAll) == null ? "" : iov.getString(idCodeNameAll);
                if (!idcodeName.equals(colIdName) && (colIdName.split("\\.").length != 2 || !colIdName.split("\\.")[0].equals(idcodeName) || !iov.getBoolean("isTotalRow"))) continue;
                costAmount = iov.getBigDecimal(costKey) == null ? BigDecimal.ZERO : iov.getBigDecimal(costKey);
                totalCostAmount = totalCostAmount.add(costAmount);
            }
            createRow.setString(idCodeNameAll, idcodeName);
            createRow.setBigDecimal(costKey, totalCostAmount);
            createRow.setBoolean("isTotalRow", true);
            coll.addObject((IObjectValue)createRow);
        }
    }

    public static void addAmountLoopForTotal(Map allClassCode, Map classCodeTotalRowMap, ClassificationCodeInfo classCode, BigDecimal totalTrolleyCost, BigDecimal totalRiskAmount, String costKey) {
        if (classCode == null) {
            return;
        }
        if (classCodeTotalRowMap.get(classCode) != null) {
            CoreBillEntryBaseInfo newClone = (CoreBillEntryBaseInfo)classCodeTotalRowMap.get(classCode);
            newClone.put(costKey, (Object)totalTrolleyCost.add(newClone.getBigDecimal(costKey)));
            newClone.put("riskPrice", (Object)totalRiskAmount.add(newClone.getBigDecimal("riskPrice")));
        }
        if (classCode.getLevel() > 1) {
            SparePartsHelper.addAmountLoopForTotal(allClassCode, classCodeTotalRowMap, (ClassificationCodeInfo)allClassCode.get(classCode.getParent()), totalTrolleyCost, totalRiskAmount, costKey);
        }
    }

    public static boolean isBigDecimalEmptyAndZero(Object o) {
        if (o == null) {
            return true;
        }
        if ("".equals(o.toString().trim())) {
            return true;
        }
        try {
            new BigDecimal(o.toString());
        }
        catch (Exception e) {
            return true;
        }
        return BigDecimal.ZERO.compareTo(new BigDecimal(o.toString())) >= 0;
    }

    public static Map updSparePrice(Context ctx, String number, Map map) throws BOSException {
        String updateSql = "/*dialect*/update CT_PCM_SparePartPrice zspp set zspp.cfupdatedate = sysdate ,\n    (zspp.cfactpurprice)  =\n(\n    select atab.fpurprice from\n    (\n        select newbosid('FC719DD7'),aentry.fprojectid,aentry.fmaterialid,--aentry.cfmaterialname,aentry.cfmodel,\n\t\t        null,min(aentry.fpurprice) fpurprice,sysdate,'','',systimestamp,systimestamp\n        from T_SM_PricingPolicyBill ahead inner join T_SM_PricingPolicyBillEntry aentry on ahead.fid = aentry.fparentid\n        where ahead.fnumber = '" + number + "'\n        group by aentry.fprojectid,aentry.FMaterialID\n    ) atab\n    where zspp.cfprojectid = atab.fprojectid and nvl(zspp.cfmaterialid,'xxxxx')=nvl(atab.fmaterialid,'xxxxx')\n)\nwhere exists\n(\n    select 1 from\n    (\n        select newbosid('FC719DD7'),aentry.fprojectid,aentry.fmaterialid,--aentry.cfmaterialname,aentry.cfmodel,\n\t\t        null,min(aentry.fpurprice) fpurprice,sysdate,'','',systimestamp,systimestamp\n        from T_SM_PricingPolicyBill ahead inner join T_SM_PricingPolicyBillEntry aentry on ahead.fid = aentry.fparentid\n        where ahead.fnumber = '" + number + "'\n        group by aentry.fprojectid,aentry.FMaterialID\n    ) atab\n    where zspp.cfprojectid = atab.fprojectid and nvl(zspp.cfmaterialid,'xxxxx')=nvl(atab.fmaterialid,'xxxxx')\n)\n    and zspp.cfidcode is null";
        DBUtil.execute((Context)ctx, (String)updateSql);
        String insertSql = "/*dialect*/insert into CT_PCM_SparePartPrice(fid,CFIdCode,CFProjectID,CFMaterialID,CFMaterialName,CFMaterialModel,\n\t\t\t  CFActPurPrice,CFEstPrice,CFCostPrice,CFUpdateDate,Fcreatorid,Flastupdateuserid,Fcreatetime,Flastupdatetime)\n    select atab.fid,null cfidcode,atab.fprojectid,atab.fmaterialid,mat.fname_l2,mat.fmodel,\n  \t\t\tatab.fpurprice,null CFEstPrice,null CFCostPrice,sysdate,'' a,'' b,systimestamp c,systimestamp d from\n    (\n        select newbosid('FC719DD7') fid,aentry.fprojectid,aentry.fmaterialid,min(aentry.fpurprice) fpurprice\n        from T_SM_PricingPolicyBill ahead inner join T_SM_PricingPolicyBillEntry aentry on ahead.fid = aentry.fparentid\n        where ahead.fnumber = '" + number + "''\n        group by aentry.fprojectid,aentry.FMaterialID\n    ) atab\n    left join t_bd_material mat on mat.fid = atab.fmaterialid\n    where not exists\n    (\n        select 1 from CT_PCM_SparePartPrice spp\n\t\t\twhere spp.cfprojectid = atab.fprojectid and nvl(spp.cfmaterialid,'xxxxx')=nvl(atab.fmaterialid,'xxxxx')\n        and spp.cfidcode is null\n    )";
        DBUtil.execute((Context)ctx, (String)insertSql);
        return map;
    }
}

