/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.pcm.innerprice.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.codingrule.RuleStatus;
import com.kingdee.eas.basedata.master.material.MaterialAttributeEnum;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.industry.emm.common.EmmUtils;
import com.kingdee.eas.industry.emm.pcm.innerprice.BranchAGatherCSBillEntryInfo;
import com.kingdee.eas.industry.emm.pcm.innerprice.BranchAGatherCSBillInfo;
import com.kingdee.eas.industry.emm.pcm.innerprice.PCMInnerPriceUtils;
import com.kingdee.eas.industry.emm.pcm.innerprice.PcmInnerPriceHelper;
import com.kingdee.eas.industry.emm.pcm.innerprice.app.AbstractBranchAGatherCSBillControllerBean;
import com.kingdee.eas.industry.emm.pcm.util.PcmTreeBillHelper;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.ncm.common.CMBillException;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.zjbom.BomMaterialProEnum;
import com.kingdee.eas.zjbom.app.util.ProcessBomTree;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class BranchAGatherCSBillControllerBean
extends AbstractBranchAGatherCSBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.industry.emm.mm.sc.app.YearScRequestBillControllerBean");

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BranchAGatherCSBillInfo bill = (BranchAGatherCSBillInfo)model;
        if (bill.getCU() == null) {
            bill.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        }
        this.checkNumber(ctx, (IObjectValue)bill);
        return super._addnew(ctx, model);
    }

    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        BranchAGatherCSBillInfo info = (BranchAGatherCSBillInfo)model;
        if (info == null) {
            info = (BranchAGatherCSBillInfo)this._getValue(ctx, pk);
        }
        if (info.getStatus() != BillBaseStatusEnum.SUBMITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.innerprice.EMMPCPcmInnerpriceResource", (String)"0EMMINNER-0000", (Locale)ctx.getLocale())));
        }
        info.setStatus(BillBaseStatusEnum.AUDITED);
        info.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
        info.setAuditTime(new Date());
        super.update(ctx, pk, (CoreBaseInfo)info);
    }

    protected void _unpassAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        BranchAGatherCSBillInfo info = (BranchAGatherCSBillInfo)model;
        if (info == null) {
            info = (BranchAGatherCSBillInfo)this._getValue(ctx, pk);
        }
        if (info.getStatus() != BillBaseStatusEnum.AUDITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.innerprice.EMMPCPcmInnerpriceResource", (String)"0EMMINNER-0001", (Locale)ctx.getLocale())));
        }
        info.setStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        info.setAuditor(null);
        info.setAuditTime(null);
        this._checkIsHaveDestBills(ctx, (CoreBaseInfo)info);
        super.update(ctx, pk, (CoreBaseInfo)info);
    }

    protected void _checkIsHaveDestBills(Context ctx, CoreBaseInfo billInfo) throws EASBizException, BOSException {
        String billIdString;
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        if (iBTPManager.ifHaveDestBills(billIdString = billInfo.getId().toString())) {
            throw new SCMBillException(SCMBillException.HASDESTBILL_CANNOTUNAUDIT, new Object[]{billInfo.getString("number")});
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BranchAGatherCSBillInfo info = (BranchAGatherCSBillInfo)this.getValue(ctx, pk);
        if (info.getStatus() == BillBaseStatusEnum.AUDITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.innerprice.EMMPCPcmInnerpriceResource", (String)"0EMMINNER-0002", (Locale)ctx.getLocale())));
        }
        super._delete(ctx, pk);
    }

    protected void check(Context ctx, BranchAGatherCSBillInfo eti) throws EASBizException, BOSException {
        if (eti.getCU() == null) {
            eti.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)eti.getNumber(), CompareType.EQUALS));
        if (eti.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)eti.getId().toString(), CompareType.NOTEQUALS));
        }
        if (this._exists(ctx, filter)) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.innerprice.EMMPCPcmInnerpriceResource", (String)"0EMMINNER-0003", (Locale)ctx.getLocale())));
        }
        StringBuffer errStr = new StringBuffer();
        if (errStr.length() > 0) {
            throw new EASBizException(new NumericExceptionSubItem("", errStr.toString()));
        }
        if (eti.getBizDate() == null) {
            eti.setBizDate(new Date());
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BranchAGatherCSBillInfo eti = (BranchAGatherCSBillInfo)model;
        this.check(ctx, eti);
        if (eti.getStatus() != BillBaseStatusEnum.TEMPORARILYSAVED && eti.getStatus() != BillBaseStatusEnum.SUBMITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.innerprice.EMMPCPcmInnerpriceResource", (String)"0EMMINNER-0004", (Locale)ctx.getLocale())));
        }
        eti.setStatus(BillBaseStatusEnum.SUBMITED);
        this.calEntry(eti, ctx);
        IObjectPK pk = super._submit(ctx, model);
        String sql = "/*dialect*/select distinct substr(cfxh,0,instr(cfxh,'.',-1,1)-1) xh from\n(\n   select ae.fid,ae.cfxh from ct_pcm_branchagathercsbill a\n   inner join ct_pcm_branchagcsbe ae on a.fid = ae.fparentid\n   where a.fnumber='" + eti.getNumber() + "'\n) order by xh desc";
        try {
            IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)sql);
            ArrayList<String> updateListSql = new ArrayList<String>();
            while (rs.next()) {
                String xh = rs.getString("xh");
                String updateSql = "/*dialect*/update ct_pcm_branchagcsbe ae\nset (ae.cftccbhd,ae.cfdjcbhd,ae.Cfwgdjlfhd,ae.CFDjgfhd,ae.Cfdjzzcbhd,ae.Cfdjqjfyhlrhd) =\n(\n  select sum(db.cftccbhd) cfdjcbhd,sum(db.cfdjcbhd) cfdjcbhd,sum(db.Cfwgdjlfhd) Cfwgdjlfhd,sum(db.CFDjgfhd) CFDjgfhd,sum(db.Cfdjzzcbhd) Cfdjzzcbhd,sum(db.Cfdjqjfyhlrhd) Cfdjqjfyhlrhd from\n  (\n   select ae.cfxh,substr(cfxh,0,instr(cfxh,'.',-1,1)-1) xh,ae.cftccbhd,ae.cfdjcbhd,ae.Cfwgdjlfhd,ae.CFDjgfhd,ae.Cfdjzzcbhd,ae.Cfdjqjfyhlrhd from ct_pcm_branchagathercsbill a\n   inner join ct_pcm_branchagcsbe ae on a.fid = ae.fparentid\n   where a.fnumber='" + eti.getNumber() + "'\n   ORDER BY AE.CFXH DESC\n  ) db where db.xh = '" + xh + "'\n  group by db.xh\n)\nwhere ae.fparentid = '" + eti.getId() + "' and ae.cfxh = '" + xh + "'";
                updateListSql.add(updateSql.toString());
            }
            EmmUtils.executeBatchUpdate((Context)ctx, updateListSql);
        }
        catch (BOSException e) {
            throw new BOSException(e.getCause());
        }
        catch (SQLException e) {
            throw new BOSException(e.getCause());
        }
        return pk;
    }

    private void calEntry(BranchAGatherCSBillInfo eti, Context ctx) throws EASBizException {
        for (int i = 0; i < eti.getEntrys().size(); ++i) {
            BranchAGatherCSBillEntryInfo entry = eti.getEntrys().get(i);
            String str = PcmInnerPriceHelper.calEntryForBranchCs(entry, eti, ctx);
            if (str.equals("")) continue;
            throw new EASBizException(new NumericExceptionSubItem("", str));
        }
        PCMInnerPriceUtils.sortEntry((IObjectCollection)eti.getEntrys());
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BranchAGatherCSBillInfo eti = (BranchAGatherCSBillInfo)model;
        if (eti.getCU() == null) {
            eti.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        }
        this.check(ctx, eti);
        if (eti.getStatus() != BillBaseStatusEnum.TEMPORARILYSAVED && eti.getStatus() != BillBaseStatusEnum.ADD) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.innerprice.EMMPCPcmInnerpriceResource", (String)"0EMMINNER-0005", (Locale)ctx.getLocale())));
        }
        eti.setStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        this.calEntry(eti, ctx);
        IObjectPK pk = super._save(ctx, model);
        String sql = "/*dialect*/select distinct substr(cfxh,0,instr(cfxh,'.',-1,1)-1) xh from\n(\n   select ae.fid,ae.cfxh from ct_pcm_branchagathercsbill a\n   inner join ct_pcm_branchagcsbe ae on a.fid = ae.fparentid\n   where a.fnumber='" + eti.getNumber() + "'\n) order by xh desc";
        try {
            IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)sql);
            ArrayList<String> updateListSql = new ArrayList<String>();
            while (rs.next()) {
                String xh = rs.getString("xh");
                String updateSql = "/*dialect*/update ct_pcm_branchagcsbe ae\nset (ae.cftccbhd,ae.cfdjcbhd,ae.Cfwgdjlfhd,ae.CFDjgfhd,ae.Cfdjzzcbhd,ae.Cfdjqjfyhlrhd) =\n(\n  select sum(db.cftccbhd) cfdjcbhd,sum(db.cfdjcbhd) cfdjcbhd,sum(db.Cfwgdjlfhd) Cfwgdjlfhd,sum(db.CFDjgfhd) CFDjgfhd,sum(db.Cfdjzzcbhd) Cfdjzzcbhd,sum(db.Cfdjqjfyhlrhd) Cfdjqjfyhlrhd from\n  (\n   select ae.cfxh,substr(cfxh,0,instr(cfxh,'.',-1,1)-1) xh,ae.cftccbhd,ae.cfdjcbhd,ae.Cfwgdjlfhd,ae.CFDjgfhd,ae.Cfdjzzcbhd,ae.Cfdjqjfyhlrhd from ct_pcm_branchagathercsbill a\n   inner join ct_pcm_branchagcsbe ae on a.fid = ae.fparentid\n   where a.fnumber='" + eti.getNumber() + "'\n   ORDER BY AE.CFXH DESC\n  ) db where db.xh = '" + xh + "'\n  group by db.xh\n)\nwhere ae.fparentid = '" + eti.getId() + "' and ae.cfxh = '" + xh + "'";
                updateListSql.add(updateSql.toString());
            }
            EmmUtils.executeBatchUpdate((Context)ctx, updateListSql);
        }
        catch (BOSException e) {
            throw new BOSException(e.getCause());
        }
        catch (SQLException e) {
            throw new BOSException(e.getCause());
        }
        return pk;
    }

    protected void checkNumber(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BranchAGatherCSBillInfo info = (BranchAGatherCSBillInfo)model;
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        RuleStatus ruleStatus = iCodingRuleManager.getRuleStatus(model, info.getAdminOrgUnit().getId().toString());
        if (ruleStatus.isExist() && (StringUtils.isEmpty((String)info.getNumber()) || ruleStatus.isAddNoBreak() || !ruleStatus.isModifiable() && this.isNumberUsed(ctx, (CoreBillBaseInfo)info))) {
            this.setNewNumber(ctx, (CoreBillBaseInfo)info, iCodingRuleManager, null);
        } else {
            ObjectUuidPK pk = new ObjectUuidPK(model.getBOSUuid("id"));
            super._checkNumberBlank(ctx, (IObjectPK)pk, model);
            super._checkNumberDup(ctx, (IObjectPK)pk, model);
        }
    }

    protected boolean isNumberUsed(Context ctx, CoreBillBaseInfo info) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)info.getNumber(), CompareType.EQUALS));
        if (info.getCU() != null) {
            filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)info.getCU().getId().toString(), CompareType.EQUALS));
        }
        if (info.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
        }
        boolean exist = super._exists(ctx, filter);
        return exist;
    }

    protected void setNewNumber(Context ctx, CoreBillBaseInfo info, ICodingRuleManager iCodingRuleManager, String customString) throws BOSException, EASBizException {
        String number = iCodingRuleManager.getNumber((IObjectValue)info, ((BranchAGatherCSBillInfo)info).getAdminOrgUnit().getId().toString(), customString);
        info.setNumber(number);
        if (this.isNumberUsed(ctx, info)) {
            this.setNewNumber(ctx, info, iCodingRuleManager, customString);
        }
    }

    protected String _getNewNumber(Context ctx, IObjectValue model, String strCompanyID, String customString) throws BOSException, EASBizException {
        String strBindProp;
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        BranchAGatherCSBillInfo aSCMBillBaseInfo = (BranchAGatherCSBillInfo)model;
        String number = "";
        boolean isNumberNoSet = false;
        if (aSCMBillBaseInfo.getNumber() == null || aSCMBillBaseInfo.getNumber().length() == 0) {
            isNumberNoSet = true;
        }
        if ((strBindProp = this.getBindingProperty(ctx)) != null && strBindProp.trim().length() > 0) {
            number = iCodingRuleManager.getNumber((IObjectValue)aSCMBillBaseInfo, strCompanyID, strBindProp, customString);
            aSCMBillBaseInfo.setNumber(number);
        } else {
            number = iCodingRuleManager.getNumber((IObjectValue)aSCMBillBaseInfo, strCompanyID, customString);
            aSCMBillBaseInfo.setNumber(number);
        }
        ObjectUuidPK pk = new ObjectUuidPK(aSCMBillBaseInfo.getId());
        if (this.isSameNumber(ctx, (IObjectPK)pk, (IObjectValue)aSCMBillBaseInfo)) {
            String newNumber = "";
            newNumber = strBindProp != null && strBindProp.trim().length() > 0 ? iCodingRuleManager.getNumber((IObjectValue)aSCMBillBaseInfo, strCompanyID, strBindProp, customString) : iCodingRuleManager.getNumber((IObjectValue)aSCMBillBaseInfo, strCompanyID, customString);
            if (newNumber.equals(aSCMBillBaseInfo.getNumber())) {
                throw new CMBillException(CMBillException.NUMBERRULEERROR);
            }
            number = newNumber;
            aSCMBillBaseInfo.setNumber(newNumber);
            if (this.isSameNumber(ctx, (IObjectPK)pk, (IObjectValue)aSCMBillBaseInfo)) {
                return this._getNewNumber(ctx, (IObjectValue)aSCMBillBaseInfo, strCompanyID, customString);
            }
        }
        return number;
    }

    protected boolean isSameNumber(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        BranchAGatherCSBillInfo aSCMBillBaseInfo = (BranchAGatherCSBillInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)aSCMBillBaseInfo.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (aSCMBillBaseInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)aSCMBillBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (aSCMBillBaseInfo.getCU() != null) {
            filterItem = new FilterItemInfo("CU", (Object)aSCMBillBaseInfo.getCU().getId().toString(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        } else {
            filterItem = new FilterItemInfo("CU", null, CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (this.getBindingProperty(ctx) != null && this.getBindingProperty(ctx).trim().length() > 0 && aSCMBillBaseInfo.get(this.getBindingProperty(ctx)) != null) {
            filterItem = new FilterItemInfo(this.getBindingProperty(ctx), this.getBindingPropertyValue((CoreBillBaseInfo)aSCMBillBaseInfo), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < filter.getFilterItems().size(); ++i) {
            if (i != 0) {
                sb.append(" and #" + i);
                continue;
            }
            sb.append("#" + i);
        }
        filter.setMaskString(sb.toString());
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        return super._exists(ctx, filter);
    }

    protected String getBindingProperty(Context ctx) throws BOSException {
        return null;
    }

    protected Object getBindingPropertyValue(CoreBillBaseInfo aSCMBillBaseInfo) {
        return null;
    }

    @Override
    protected Map _exBom(Context ctx, Map map) throws BOSException, EASBizException {
        BranchAGatherCSBillInfo billInfo = (BranchAGatherCSBillInfo)map.get("billInfo");
        try {
            ProjectInfo project = (ProjectInfo)map.get("project");
            TrackNumberInfo trackNumber = (TrackNumberInfo)map.get("trackNumber");
            StorageOrgUnitInfo sou = (StorageOrgUnitInfo)map.get("sou");
            StringBuffer sql = new StringBuffer();
            sql.append(" select m.fid as materialid from CT_ZJB_PdmEasCarnoEqualSet pce");
            sql.append(" inner join t_bd_material m on pce.CFPMno=m.fnumber");
            sql.append(" inner join t_mm_project p on p.fid=pce.CFEasCarnoID");
            sql.append(" inner join t_mm_tracknumber stn on stn.fid=pce.cfeasbegintracknum");
            sql.append(" inner join t_mm_tracknumber etn on etn.fid=pce.cfeasendtracknumbe");
            sql.append(" where p.fid='" + project.getId().toString() + "'");
            sql.append(" and stn.fnumber<='" + trackNumber.getNumber() + "' and etn.fnumber>='" + trackNumber.getNumber() + "'");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            String topMId = null;
            if (!rs.next()) {
                throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.innerprice.EMMPCPcmInnerpriceResource", (String)"0EMMINNER-0006", (Locale)ctx.getLocale())));
            }
            topMId = rs.getString("materialid");
            String tempTable = TempTablePool.getInstance((Context)ctx).createTempTable(this.getTempTableSql(ctx));
            MaterialInfo topMaterial = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)topMId)));
            BomTree tree = new BomTree();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("tempTable", tempTable);
            params.put("prmtTrackBegin", trackNumber.getNumber());
            params.put("prmtTrackEnd", trackNumber.getNumber());
            params.put("project_tmp", project);
            params.put("tracknumber_tmp", trackNumber);
            params.put("sou_tmp", sou);
            params.put("billInfo", billInfo);
            tree.run(ctx, project, topMaterial, params);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException(e.getCause());
        }
        HashMap<String, BranchAGatherCSBillInfo> re = new HashMap<String, BranchAGatherCSBillInfo>();
        re.put("billInfo", billInfo);
        PCMInnerPriceUtils.sortEntry((IObjectCollection)billInfo.getEntrys());
        return re;
    }

    protected String getTempTableSql(Context ctx) throws BOSException {
        StringBuilder sql = new StringBuilder();
        sql.append("Create Table ExpandBOMTable(\r\n");
        sql.append("FtreeID varchar(44) ,\r\n");
        sql.append("FtreeParentID varchar(44) ,\r\n");
        sql.append("fxh varchar(44) ,\r\n");
        sql.append("fljID VARCHAR(44) Null,\r\n");
        sql.append("fssljID VARCHAR(44) Null,\r\n");
        sql.append("fsszpxh VARCHAR(250) Null,\r\n");
        sql.append("fssljzpsl Numeric(21,8) Null,\r\n");
        sql.append("fdjde Numeric(21,8) Null,\r\n");
        sql.append("ftcde Numeric(21,8) Null,\r\n");
        sql.append("funitID VARCHAR(44) Null,\r\n");
        sql.append("fggjl VARCHAR(250) Null,\r\n");
        sql.append("fdz Numeric(21,8) Null,\r\n");
        sql.append("fzz Numeric(21,8) Null,\r\n");
        sql.append("fgylc VARCHAR(250) Null,\r\n");
        sql.append("fcfhlc VARCHAR(250) Null,\r\n");
        sql.append("fbomMaterialPro VARCHAR(250) Null,\r\n");
        sql.append("fMaterialPro VARCHAR(250) Null,\r\n");
        sql.append("fghkczz VARCHAR(250) Null,\r\n");
        sql.append("flykczz VARCHAR(250) Null,\r\n");
        sql.append("fsjfz VARCHAR(250) Null,\r\n");
        sql.append("fclnumber VARCHAR(250) Null,");
        sql.append("flongnumber VARCHAR(250) Null,");
        sql.append("tree_level int null )");
        return sql.toString();
    }

    private class BomTree
    extends ProcessBomTree {
        private BomTree() {
        }

        protected void execute(String treeTemp, Map params) throws Exception {
            String tempTable = (String)params.get("tempTable");
            StorageOrgUnitInfo sou = (StorageOrgUnitInfo)params.get("sou_tmp");
            StringBuilder sql = new StringBuilder();
            sql.setLength(0);
            sql.append(" /*dialect*/ insert into " + tempTable);
            sql.append(" select tree.tree_id,tree.tree_parent_id,null,");
            sql.append(" tree.tree_material_id,tree.tree_parent_material_id,");
            sql.append(" bom.CFSeq,bom.CFQuantity,tree.TREE_FIXED,tree.Expand_FIXED,");
            sql.append(" bom.CFUnit,bom.CFUpdateRecord,bom.cfweight,nvl(bom.cfweight, 0) * tree.Expand_FIXED,");
            sql.append(" bom.cfinitMakeFlow,bom.cfmakeFlow,");
            sql.append(" bom.CFBomMaterialPro,tree.TREE_MATERIAL_PROP,");
            sql.append(" draw.fid,storage.fid,bom.cfnote,bom.cfstuffNo,tree.tree_parent_id || tree.tree_id,tree.tree_level");
            sql.append(" from " + treeTemp + " tree");
            sql.append(" inner join CT_ZJB_ProcessBomBill bom  on bom.fid = tree.TREE_BOM_ID");
            sql.append(" inner Join T_MM_TrackNumber stn  on stn.FID = bom.CFBeginCarnoID");
            sql.append(" inner Join T_MM_TrackNumber etn   on etn.FID = bom.CFEndCarnoID");
            sql.append(" inner join T_ORG_Storage storage  on storage.fid = bom.CFStorageOrgUnitID");
            sql.append(" inner join T_ORG_Storage draw  on draw.fid = bom.CFDrawBillOrgID");
            sql.append(" where 1 = 1");
            sql.append(" and (draw.fid='" + sou.getId().toString() + "' or storage.fid='" + sou.getId().toString() + "')");
            DbUtil.execute((Context)this.ctx, (String)sql.toString());
            for (int i = 0; i < 10; ++i) {
                sql.setLength(0);
                sql.append(" /*dialect*/ insert into " + tempTable);
                sql.append(" select tree.tree_id,tree.tree_parent_id,null,");
                sql.append(" tree.tree_material_id,tree.tree_parent_material_id,");
                sql.append(" bom.CFSeq,bom.CFQuantity,tree.TREE_FIXED,tree.Expand_FIXED,");
                sql.append(" bom.CFUnit,bom.CFUpdateRecord,bom.cfweight,nvl(bom.cfweight, 0) * tree.Expand_FIXED,");
                sql.append(" bom.cfinitMakeFlow,bom.cfmakeFlow,");
                sql.append(" bom.CFBomMaterialPro,tree.TREE_MATERIAL_PROP,");
                sql.append(" draw.fid,storage.fid,bom.cfnote,bom.cfstuffNo,tree.tree_parent_id || tree.tree_id,tree.tree_level");
                sql.append(" from " + treeTemp + " tree");
                sql.append(" inner join CT_ZJB_ProcessBomBill bom  on bom.fid = tree.TREE_BOM_ID");
                sql.append(" inner Join T_MM_TrackNumber stn  on stn.FID = bom.CFBeginCarnoID");
                sql.append(" inner Join T_MM_TrackNumber etn   on etn.FID = bom.CFEndCarnoID");
                sql.append(" inner join T_ORG_Storage storage  on storage.fid = bom.CFStorageOrgUnitID");
                sql.append(" inner join T_ORG_Storage draw  on draw.fid = bom.CFDrawBillOrgID");
                sql.append(" where 1 = 1");
                sql.append(" and exists (select 1 from " + tempTable + " t2 where t2.FtreeID=tree.tree_parent_id)");
                sql.append(" and not exists (select 1 from " + tempTable + " t3 where t3.FtreeID=tree.tree_id)");
                DbUtil.execute((Context)this.ctx, (String)sql.toString());
            }
            sql.setLength(0);
            sql.append("create table ls (");
            sql.append("ftreeid varchar(44),");
            sql.append("fxh varchar(200))");
            String xhTmp = TempTablePool.getInstance((Context)this.ctx).createTempTable(sql.toString());
            sql.setLength(0);
            sql.append("/*dialect*/ insert into " + xhTmp);
            sql.append(" select ftreeid,rownum from (select t.FtreeID from " + tempTable + " t");
            sql.append(" where not exists (select 1 from " + tempTable + " t3 where t.ftreeparentid=t3.ftreeid)");
            sql.append(" order by to_number(substr(t.ftreeid,0,instr(t.ftreeid,'-')-1)),to_number(substr(t.ftreeid,instr(t.ftreeid,'-')+1,length(t.ftreeid))))");
            DbUtil.execute((Context)this.ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append("/*dialect*/ select max(t.tree_level) tree_level from " + tempTable + " t");
            IRowSet rs_t = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
            while (rs_t.next()) {
                int tree_level = rs_t.getInt("tree_level");
                for (int i = 0; i < tree_level; ++i) {
                    sql.setLength(0);
                    sql.append("/*dialect*/ select fxh,sum(rt) num from ");
                    sql.append(" (select t.FtreeID, xht.fxh ,count(1) as rt ");
                    sql.append(" from " + tempTable + " t");
                    sql.append(" inner join " + xhTmp + " xht on t.ftreeparentid = xht.ftreeid");
                    sql.append("  where not exists (select 1 from " + xhTmp + " t3 where t3.FtreeID = t.FtreeID)");
                    sql.append(" group by t.FtreeID, xht.fxh");
                    sql.append(" order by to_number(substr(t.ftreeid, 0, instr(t.ftreeid, '-') - 1)),");
                    sql.append(" to_number(substr(t.ftreeid,instr(t.ftreeid, '-') + 1,length(t.ftreeid)))");
                    sql.append("  )group by fxh order by fxh");
                    IRowSet rs_tmp = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
                    while (rs_tmp.next()) {
                        sql.setLength(0);
                        sql.append("/*dialect*/ insert into " + xhTmp);
                        sql.append(" select t.FtreeID,xht.fxh || '.' || rownum from " + tempTable + " t");
                        sql.append(" inner join " + xhTmp + " xht on t.ftreeparentid=xht.ftreeid");
                        sql.append(" where not exists (select 1 from " + xhTmp + " t3 where t3.FtreeID=t.FtreeID) and xht.fxh='" + rs_tmp.getString("fxh") + "'");
                        sql.append(" order by to_number(substr(t.ftreeid,0,instr(t.ftreeid,'-')-1)),to_number(substr(t.ftreeid,instr(t.ftreeid,'-')+1,length(t.ftreeid)))");
                        DbUtil.execute((Context)this.ctx, (String)sql.toString());
                    }
                }
            }
            sql.setLength(0);
            sql.append("/*dialect*/ update " + tempTable + " t set t.fxh=(");
            sql.append(" select xht.fxh from " + xhTmp + " xht ");
            sql.append(" where xht.FtreeID=t.FtreeID)");
            sql.append(" where t.fxh is null");
            DbUtil.execute((Context)this.ctx, (String)sql.toString());
            BranchAGatherCSBillInfo billInfo = (BranchAGatherCSBillInfo)params.get("billInfo");
            sql.setLength(0);
            sql.append("/*dialect*/ select lj.fnumber as fljnumber,lj.fname_l2 as fljname,lj.fmodel as fljmodel,");
            sql.append(" sslj.fnumber as fssljnumber,lj.fname_l2 as fssljname,");
            sql.append(" ly.fnumber as flynumber,ly.fname_l2 as flyname,");
            sql.append(" gy.fnumber as fgynumber,gy.fname_l2 as fgyname,");
            sql.append(" cl.fnumber as fcllnumber,cl.fname_l2 as fcllname,");
            sql.append(" clp.CFModel as clpModel,clp.CFPrice as clpPrice,");
            sql.append(" clp.CFMiduMizhong as clpMD,clp.CFType as clpType,");
            sql.append(" rsou.CFGeneralRate as zhflv,");
            sql.append(" t.* from " + tempTable + " t ");
            sql.append(" left join t_bd_material lj on t.fljid=lj.fid ");
            sql.append(" left join t_bd_material sslj on t.fssljid=sslj.fid ");
            sql.append(" left join t_org_storage ly on t.flykczz=ly.fid ");
            sql.append(" left join t_org_storage gy on t.fghkczz=gy.fid ");
            sql.append(" left join t_bd_material cl on cl.fnumber=t.fclnumber ");
            sql.append(" left join CT_PCM_ClInnerPrice clp on clp.CFMaterialID=cl.fid ");
            sql.append(" left join ct_pcm_AdminAndStorageOrg aao on aao.fstorageid=gy.fid");
            sql.append(" left join CT_PCM_RateSOMU rsou on aao.fadminid=rsou.CFUnitsID and rsou.CFExpenseType=1 and rsou.CFRateType=4");
            sql.append(" order by to_number(substr(t.ftreeid,0,instr(t.ftreeid,'-')-1)),to_number(substr(t.ftreeid,instr(t.ftreeid,'-')+1,length(t.ftreeid)))");
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
            billInfo.getEntrys().clear();
            while (rs.next()) {
                BranchAGatherCSBillEntryInfo entry = new BranchAGatherCSBillEntryInfo();
                entry.setXh(rs.getString("fxh"));
                MaterialInfo lj = new MaterialInfo();
                lj.setId(BOSUuid.read((String)rs.getString("fljID")));
                lj.setNumber(rs.getString("fljnumber"));
                lj.setName(rs.getString("fljname"));
                lj.setModel(rs.getString("fljmodel"));
                entry.setMaterial(lj);
                MaterialInfo sslj = new MaterialInfo();
                sslj.setId(BOSUuid.read((String)rs.getString("fssljID")));
                sslj.setNumber(rs.getString("fssljnumber"));
                sslj.setName(rs.getString("fljname"));
                entry.setParentMaterial(sslj);
                entry.setParentOpSeq(rs.getString("fsszpxh"));
                entry.setParentMaterialQty(rs.getBigDecimal("fssljzpsl"));
                entry.setCailiaoNumber(rs.getString("fclnumber"));
                entry.setCailiaoCZ(rs.getString("fcllname"));
                entry.setSingleDE(rs.getBigDecimal("fdjde"));
                entry.setHdSingleQty(rs.getBigDecimal("fdjde"));
                entry.setTrollyDE(rs.getBigDecimal("ftcde"));
                entry.setSingleHeavy(rs.getBigDecimal("fdz"));
                entry.setTotalHeavy(rs.getBigDecimal("fzz"));
                entry.setUnitt(rs.getString("funitID"));
                entry.setGyFlow(rs.getString("fgylc"));
                entry.setSplitFlow(rs.getString("fcfhlc"));
                entry.setBomMaterialPro(BomMaterialProEnum.getEnum((String)rs.getString("fbomMaterialPro")));
                entry.setMaterialPro(MaterialAttributeEnum.getEnum((int)rs.getInt("fMaterialPro")));
                StorageOrgUnitInfo ghkczz = new StorageOrgUnitInfo();
                ghkczz.setId(BOSUuid.read((String)rs.getString("fghkczz")));
                ghkczz.setNumber(rs.getString("fgynumber"));
                ghkczz.setName(rs.getString("fgyname"));
                entry.setSuppSou(ghkczz);
                StorageOrgUnitInfo lykczz = new StorageOrgUnitInfo();
                lykczz.setId(BOSUuid.read((String)rs.getString("flykczz")));
                lykczz.setNumber(rs.getString("flynumber"));
                lykczz.setName(rs.getString("flyname"));
                entry.setReqSou(lykczz);
                entry.setUpdateRecord(rs.getString("fggjl"));
                entry.setSbSingleQty(BigDecimal.ZERO);
                entry.setHdSingleQty(rs.getBigDecimal("fssljzpsl"));
                entry.setSbTrollyQty(BigDecimal.ZERO);
                entry.setHdTrollyQty(BigDecimal.ZERO);
                entry.setClMiduMizhong(rs.getBigDecimal("clpMD") == null ? BigDecimal.ZERO : rs.getBigDecimal("clpMD"));
                entry.setClnbjsj(rs.getBigDecimal("clpPrice") == null ? BigDecimal.ZERO : rs.getBigDecimal("clpPrice"));
                entry.setCailiaoSBbanhoumm(new BigDecimal("1000"));
                entry.setCailiaoHDbanhoumm(entry.getCailiaoSBbanhoumm());
                entry.setCailiaoSBkuanm(new BigDecimal("1000"));
                entry.setCailiaoHDkuanm(entry.getCailiaoSBkuanm());
                entry.setCailiaoSBchangm(BigDecimal.ZERO);
                entry.setCailiaoHDChangm(entry.getCailiaoSBchangm());
                entry.setClLyl(new BigDecimal("1.1"));
                entry.setLylsb(new BigDecimal("1.2"));
                entry.setClSBSingleQty(entry.getClMiduMizhong().multiply(entry.getCailiaoSBbanhoumm()).multiply(entry.getCailiaoSBkuanm()).multiply(entry.getCailiaoSBchangm()).multiply(entry.getLylsb()).divide(new BigDecimal("1000"), 6, RoundingMode.HALF_UP));
                entry.setClHDSingleQty(entry.getClMiduMizhong().multiply(entry.getCailiaoHDbanhoumm()).multiply(entry.getCailiaoHDkuanm()).multiply(entry.getCailiaoHDChangm()).multiply(entry.getClLyl()).divide(new BigDecimal("1000000000"), 6, RoundingMode.HALF_UP));
                entry.setSbSingleLf(PcmInnerPriceHelper.getNo(entry.getClSBSingleQty()).multiply(PcmInnerPriceHelper.getNo(entry.getClSBPrice())).setScale(2, RoundingMode.HALF_UP));
                entry.setHdSingleLf(entry.getClHDSingleQty().multiply(entry.getClnbjsj()).setScale(2, RoundingMode.HALF_UP));
                entry.setWgcldjsb(BigDecimal.ZERO);
                entry.setNbxsdj(BigDecimal.ZERO);
                entry.setNbjsdj(BigDecimal.ZERO);
                entry.setZgdj(BigDecimal.ZERO);
                entry.setWgzgdj(BigDecimal.ZERO);
                BigDecimal wgcldjhd = BigDecimal.ZERO;
                if (!PcmTreeBillHelper.isBigDecimalEmptyAndZero(entry.getNbxsdj())) {
                    wgcldjhd = entry.getNbjsdj();
                } else if (!PcmTreeBillHelper.isBigDecimalEmptyAndZero(entry.getNbjsdj())) {
                    wgcldjhd = entry.getNbjsdj();
                } else if (!PcmTreeBillHelper.isBigDecimalEmptyAndZero(entry.getZgdj())) {
                    wgcldjhd = entry.getZgdj();
                } else if (!PcmTreeBillHelper.isBigDecimalEmptyAndZero(entry.getWgzgdj())) {
                    wgcldjhd = entry.getWgzgdj();
                }
                entry.setWgcldjhd(wgcldjhd);
                entry.setWgdjlfsb(entry.getWgcldjsb().multiply(entry.getSbSingleQty()).setScale(2, RoundingMode.HALF_UP));
                entry.setWgdjlfsb(entry.getWgcldjhd().multiply(entry.getHdSingleQty()).setScale(2, RoundingMode.HALF_UP));
                entry.setZhflsb(BigDecimal.ZERO);
                entry.setZhflhd(rs.getBigDecimal("zhflv") == null ? BigDecimal.ZERO : rs.getBigDecimal("zhflv"));
                entry.setDjgssb(BigDecimal.ZERO);
                entry.setDjgfsb(entry.getDjgssb().multiply(entry.getZhflhd()).setScale(2, RoundingMode.HALF_UP));
                entry.setGshdbl(BigDecimal.ONE);
                entry.setDjgshd(entry.getDjgssb().multiply(entry.getGshdbl()).setScale(2, RoundingMode.HALF_UP));
                entry.setDjgfhd(entry.getDjgshd().multiply(entry.getZhflhd()).setScale(2, RoundingMode.HALF_UP));
                entry.setBmclsb(BigDecimal.ZERO);
                entry.setBmclhd(entry.getBmclsb());
                entry.setXqgsb(BigDecimal.ZERO);
                entry.setXqghd(entry.getXqgsb());
                entry.setDjqtfysb(BigDecimal.ZERO);
                entry.setDjqtfyhd(entry.getDjqtfysb());
                entry.setDjzzcbsb(entry.getSbSingleLf().add(entry.getWgdjlfsb()).add(entry.getDjgfsb()).add(entry.getDjqtfysb()));
                entry.setDjzzcbhd(PcmInnerPriceHelper.getNo(entry.getHdSingleLf()).add(PcmInnerPriceHelper.getNo(entry.getWgdjlfhd())).add(PcmInnerPriceHelper.getNo(entry.getDjgfhd())).add(PcmInnerPriceHelper.getNo(entry.getDjqtfyhd())));
                entry.setDjqjfyhlrsb(BigDecimal.ZERO);
                entry.setDjqjfyhlrhd(BigDecimal.ZERO);
                entry.setDjcbsb(entry.getDjzzcbsb().add(entry.getDjqjfyhlrsb()));
                entry.setDjcbhd(entry.getDjzzcbhd().add(entry.getDjqjfyhlrhd()));
                entry.setTccbsb(entry.getSbSingleQty().multiply(entry.getDjcbsb()));
                entry.setTccbhd(entry.getDjcbhd().multiply(entry.getDjcbhd()));
                if (entry.getYddj() == null) {
                    entry.setYddj(BigDecimal.ZERO);
                }
                entry.setTczzsc(PcmInnerPriceHelper.getNo(entry.getTrollyDE()).multiply(PcmInnerPriceHelper.getNo(entry.getDjcbsc())));
                entry.setDesiRemark(rs.getString("fsjfz"));
                entry.setLongNumber(rs.getString("flongnumber"));
                billInfo.getEntrys().add(entry);
            }
        }
    }
}

