/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.pcm.innerprice.standardcs.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.IBOTMapping;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.basedata.master.material.MaterialAttributeEnum;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.syncdatabase.InterfaceDataBaseException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.industry.emm.pcm.innerprice.standardcs.ComInnerStdPriceBillInfo;
import com.kingdee.eas.industry.emm.pcm.innerprice.standardcs.StandardcsBillAssEntryInfo;
import com.kingdee.eas.industry.emm.pcm.innerprice.standardcs.StandardcsBillEntryInfo;
import com.kingdee.eas.industry.emm.pcm.innerprice.standardcs.StandardcsBillInfo;
import com.kingdee.eas.industry.emm.pcm.innerprice.standardcs.app.AbstractStandardcsBillControllerBean;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.zjbom.app.util.ProcessBomTree;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class StandardcsBillControllerBean
extends AbstractStandardcsBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.industry.emm.pcm.innerprice.standardcs.app.StandardcsBillControllerBean");

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        StandardcsBillInfo eti = (StandardcsBillInfo)model;
        if (eti.getStatus() != BillBaseStatusEnum.TEMPORARILYSAVED && eti.getStatus() != BillBaseStatusEnum.SUBMITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.innerprice.EMMPCPcmInnerpriceResource", (String)"0EMMINNER-0004", (Locale)ctx.getLocale())));
        }
        eti.setStatus(BillBaseStatusEnum.SUBMITED);
        IObjectPK pk = super._submit(ctx, model);
        return pk;
    }

    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        StandardcsBillInfo info = (StandardcsBillInfo)model;
        if (info == null) {
            info = (StandardcsBillInfo)this._getValue(ctx, pk);
        }
        if (info.getStatus() != BillBaseStatusEnum.SUBMITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.innerprice.EMMPCPcmInnerpriceResource", (String)"0EMMINNER-0000", (Locale)ctx.getLocale())));
        }
        info.setStatus(BillBaseStatusEnum.AUDITED);
        info.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
        this.setComInnerStdPriceBill(ctx, info);
        super.update(ctx, pk, (CoreBaseInfo)info);
    }

    private StandardcsBillInfo gl(StandardcsBillInfo info) {
        StandardcsBillInfo nInfo = (StandardcsBillInfo)info.clone();
        for (int i = 0; i < nInfo.getEntrys().size(); ++i) {
            if (nInfo.getEntrys().get(i).getXh().indexOf(".") == -1) continue;
            nInfo.getEntrys().remove(nInfo.getEntrys().get(i));
            --i;
        }
        nInfo.getAssEntrys().clear();
        return nInfo;
    }

    private void setComInnerStdPriceBill(Context ctx, StandardcsBillInfo info) throws EASBizException, BOSException {
        info = this.gl(info);
        String botpNumber = "NBJS0001";
        IBOTMapping botFactory = BOTMappingFactory.getLocalInstance((Context)ctx);
        BOTMappingInfo botInfo = null;
        BOTMappingCollection botCol = botFactory.getBOTMappingCollection("where name='" + botpNumber + "' and extRule.isEffected=1 ");
        if (botCol.size() != 1) {
            NumericExceptionSubItem interfaceException = new NumericExceptionSubItem("NOTBOTP", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.innerprice.EMMPCPcmInnerpriceResource", (String)"0EMMINNER-0049", (Locale)ctx.getLocale()) + botpNumber + EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.innerprice.EMMPCPcmInnerpriceResource", (String)"0EMMINNER-0050", (Locale)ctx.getLocale()));
            throw new InterfaceDataBaseException(interfaceException);
        }
        botInfo = botCol.get(0);
        if (botInfo != null) {
            IBTPManager btp = BTPManagerFactory.getLocalInstance((Context)ctx);
            BTPTransformResult result = null;
            result = btp.transform((CoreBillBaseInfo)info, botInfo);
            for (ComInnerStdPriceBillInfo billInfo : result.getBills()) {
                btp.saveRelations((CoreBillBaseInfo)billInfo, result.getBOTRelationCollection());
            }
        } else {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.innerprice.EMMPCPcmInnerpriceResource", (String)"0EMMINNER-0051", (Locale)ctx.getLocale()) + botpNumber + EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.innerprice.EMMPCPcmInnerpriceResource", (String)"0EMMINNER-0052", (Locale)ctx.getLocale())));
        }
    }

    protected void _unpassAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        StandardcsBillInfo info = (StandardcsBillInfo)model;
        if (info == null) {
            info = (StandardcsBillInfo)this._getValue(ctx, pk);
        }
        if (info.getStatus() != BillBaseStatusEnum.AUDITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.innerprice.EMMPCPcmInnerpriceResource", (String)"0EMMINNER-0001", (Locale)ctx.getLocale())));
        }
        info.setStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        info.setAuditor(null);
        this._checkIsHaveDestBills(ctx, (CoreBaseInfo)info);
        super.update(ctx, pk, (CoreBaseInfo)info);
    }

    protected void _checkIsHaveDestBills(Context ctx, CoreBaseInfo billInfo) throws EASBizException, BOSException {
        String billIdString;
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        if (iBTPManager.ifHaveDestBills(billIdString = billInfo.getId().toString())) {
            throw new SCMBillException(SCMBillException.HASDESTBILL_CANNOTUNAUDIT, new Object[]{billInfo.getString("number")});
        }
    }

    @Override
    protected Map _exBom(Context ctx, Map map) throws BOSException, EASBizException {
        StandardcsBillInfo billInfo = (StandardcsBillInfo)map.get("billInfo");
        try {
            ProjectInfo project = (ProjectInfo)map.get("project");
            TrackNumberInfo trackNumber = (TrackNumberInfo)map.get("trackNumber");
            StorageOrgUnitInfo sou = (StorageOrgUnitInfo)map.get("sou");
            BomTree tree = new BomTree();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("prmtTrackBegin", trackNumber.getNumber());
            params.put("prmtTrackEnd", trackNumber.getNumber());
            params.put("project_tmp", project);
            params.put("tracknumber_tmp", trackNumber);
            params.put("sou_tmp", sou);
            params.put("billInfo", billInfo);
            params.put("botpDown", map.get("botpDown"));
            params.put("sfshpj", map.get("sfshpj"));
            tree.run(ctx, project, null, params);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        HashMap<String, StandardcsBillInfo> re = new HashMap<String, StandardcsBillInfo>();
        re.put("billInfo", billInfo);
        return re;
    }

    private class BomTree
    extends ProcessBomTree {
        int levelcou = 0;

        private BomTree() {
        }

        protected String getTreeTableSql() {
            StringBuilder sql = new StringBuilder();
            sql.append("Create Table ExpandBOMTable(\r\n");
            sql.append(" xh NVARCHAR(200) ,\r\n");
            sql.append("TREE_ID").append(" NVARCHAR(200) Not Null,\r\n");
            sql.append("TREE_PARENT_ID").append(" NVARCHAR(200) Null,\r\n");
            sql.append("TREE_BOM_ID").append(" VARCHAR(44) Not Null,\r\n");
            sql.append("TREE_PROJECT_ID").append(" VARCHAR(44) Not Null,\r\n");
            sql.append("TREE_TRACK_ID").append(" VARCHAR(44) Not Null,\r\n");
            sql.append("TREE_TRACK_NUMBER").append(" NVARCHAR(80) Not Null,\r\n");
            sql.append("TREE_MATERIAL_ID").append(" VARCHAR(44) Not Null,\r\n");
            sql.append("TREE_MATERIAL_NAME").append(" NVARCHAR(100) Not Null,\r\n");
            sql.append("TREE_MATERIAL_NUMBER").append(" NVARCHAR(80) Not Null,\r\n");
            sql.append("TREE_MATERIAL_PROP").append(" INT Null,\r\n");
            sql.append("TREE_FIXED").append(" Numeric(21,8) Default 0 Not Null,");
            sql.append(" model NVARCHAR(200),");
            sql.append("TREE_PARENT_MATERIAL_ID").append(" VARCHAR(44) Not Null,\r\n");
            sql.append("TREE_PARENT_MATERIAL_NAME").append(" NVARCHAR(100) Not Null,\r\n");
            sql.append("TREE_PARENT_MATERIAL_NUMBER").append(" NVARCHAR(80) Not Null,\r\n");
            sql.append("TREE_PARENT_MATERIAL_PROP").append(" INT Null,\r\n");
            sql.append("TREE_PARENT_FIXED").append(" Numeric(21,8) Default 0 Not Null,");
            sql.append("TREE_LONG_NUMBER").append(" NVARCHAR(2000) Not Null,");
            sql.append("level_long_number").append(" VARCHAR(2000) Not Null,");
            sql.append("TREE_LEVEL").append(" INT Default 0 Not Null,");
            sql.append("Expand_FIXED").append(" Numeric(21,8) Default 0 Not Null,");
            sql.append("TREE_BILL_FIXED").append(" Numeric(21,8) Default 0 Not Null,");
            sql.append("TREE_ISOWNOBJECT").append(" Int Default 0");
            sql.append(",cfrationunit Numeric(21,8) Default 0");
            sql.append(",").append("CFIsSplit").append(" Numeric(10)");
            sql.append(", cfweight Numeric(21,8),CFDrawBillOrgID VARCHAR(44),CFStorageOrgUnitID VARCHAR(44),CFUpdateRecord NVARCHAR(255),CFUsingRate Numeric(21,8)");
            sql.append(",CFQuantity Numeric(21,8),CFUnit NVARCHAR(100),cfinitMakeFlow NVARCHAR(100),cfmakeFlow NVARCHAR(100),cfnote NVARCHAR(100),cfstuffNo NVARCHAR(100),CFSizeLength Numeric(21,8),CFSizeWidth Numeric(21,8),CFSizeHheight Numeric(21,8)");
            sql.append(")");
            return sql.toString();
        }

        protected void insertInto() throws Exception {
            boolean level = true;
            StringBuilder insert = new StringBuilder();
            insert.append("insert into ").append(this.treeTable).append(" (");
            insert.append(" xh,");
            insert.append("TREE_ID");
            insert.append(",").append("TREE_PARENT_ID");
            insert.append(",").append("TREE_BOM_ID");
            insert.append(",").append("TREE_PROJECT_ID");
            insert.append(",").append("TREE_TRACK_ID");
            insert.append(",").append("TREE_TRACK_NUMBER");
            insert.append(",").append("TREE_MATERIAL_ID");
            insert.append(",").append("TREE_MATERIAL_NAME");
            insert.append(",").append("TREE_MATERIAL_NUMBER");
            insert.append(",").append("TREE_MATERIAL_PROP");
            insert.append(",").append("TREE_FIXED");
            insert.append(",model");
            insert.append(",").append("TREE_PARENT_MATERIAL_ID");
            insert.append(",").append("TREE_PARENT_MATERIAL_NAME");
            insert.append(",").append("TREE_PARENT_MATERIAL_NUMBER");
            insert.append(",").append("TREE_PARENT_MATERIAL_PROP");
            insert.append(",").append("TREE_PARENT_FIXED");
            insert.append(",").append("TREE_LONG_NUMBER");
            insert.append(",").append("level_long_number");
            insert.append(",").append("TREE_LEVEL");
            insert.append(",").append("Expand_FIXED");
            insert.append(",").append("TREE_BILL_FIXED");
            insert.append(",").append("TREE_ISOWNOBJECT");
            insert.append(",cfrationunit");
            insert.append(",").append("CFIsSplit");
            insert.append(", cfweight,CFDrawBillOrgID,CFStorageOrgUnitID,CFUpdateRecord,CFUsingRate");
            insert.append(",CFQuantity,CFUnit,cfinitMakeFlow,cfmakeFlow,cfnote,cfstuffNo,CFSizeLength,CFSizeWidth,CFSizeHheight");
            insert.append(") \r\n (select ");
            insert.append(" rownum as xh,");
            insert.append("'").append(1).append("-'||rownum").append(" AS ").append("TREE_ID");
            insert.append(",null").append(" AS ").append("TREE_PARENT_ID");
            insert.append(",bom.fid").append(" AS ").append("TREE_BOM_ID");
            insert.append(",bom.CFProjectID").append(" AS ").append("TREE_PROJECT_ID");
            insert.append(",track.fid").append(" AS ").append("TREE_TRACK_ID");
            insert.append(",track.fnumber").append(" AS ").append("TREE_TRACK_NUMBER");
            insert.append(",m.fid").append(" AS ").append("TREE_MATERIAL_ID");
            insert.append(",m.fname_l2").append(" AS ").append("TREE_MATERIAL_NAME");
            insert.append(",m.fnumber").append(" AS ").append("TREE_MATERIAL_NUMBER");
            insert.append(",bom.CFMaterialProperty").append(" AS ").append("TREE_MATERIAL_PROP");
            insert.append(",bom.CFRation").append(" AS ").append("TREE_FIXED");
            insert.append(",m.Fmodel").append(" AS model");
            insert.append(",mp.fid AS ").append("TREE_PARENT_MATERIAL_ID");
            insert.append(",bom.CFParentName AS ").append("TREE_PARENT_MATERIAL_NAME");
            insert.append(",bom.CFParentNo AS ").append("TREE_PARENT_MATERIAL_NUMBER");
            insert.append(",'").append(10030).append("' AS ").append("TREE_PARENT_MATERIAL_PROP");
            String fixed = (String)this.params.get("fixed");
            if (!StringUtils.isEmpty((String)fixed)) {
                insert.append(",").append(fixed).append(" AS ").append("TREE_PARENT_FIXED");
            } else {
                insert.append(",1").append(" AS ").append("TREE_PARENT_FIXED");
            }
            insert.append(",' '").append(" AS ").append("TREE_LONG_NUMBER");
            insert.append(",(case when rownum is not null then right(power(10,5-length(rownum))||'',5-length(rownum))||rownum else right(power(10,5-length(rownum))||'',5-length(rownum))||rownum end)");
            insert.append(",").append(1).append(" AS ").append("TREE_LEVEL");
            insert.append(",1").append(" AS ").append("Expand_FIXED");
            insert.append(",isnull(bom.CFRation,0)").append(" AS ").append("TREE_BILL_FIXED");
            insert.append(",\r\n").append("Case BOM.CFBOMMaterialPro When '1' Then 1 Else 0 End\r\n");
            insert.append(", isnull(bom.cfrationunit,0) as cfrationunit");
            insert.append(",\r\n bom.").append("CFIsSplit");
            insert.append(", bom.cfweight,bom.CFDrawBillOrgID,bom.CFStorageOrgUnitID,bom.CFUpdateRecord,bom.CFUsingRate");
            insert.append(",1 as CFQuantity,bom.CFUnit,bom.cfinitMakeFlow,bom.cfmakeFlow,bom.cfnote,bom.cfstuffNo,bom.CFSizeLength,bom.CFSizeWidth,bom.CFSizeHheight");
            insert.append(" from CT_ZJB_ProcessBomBill bom");
            insert.append(" left join T_BD_Material m on m.fid = bom.CFMaterialID");
            insert.append(" left join T_BD_Material mp on mp.fnumber = bom.CFParentNo");
            insert.append(" left Join T_MM_TrackNumber stn on stn.FID=bom.CFBeginCarnoID");
            insert.append(" left Join T_MM_TrackNumber etn on etn.FID=bom.CFEndCarnoID");
            insert.append(" ,T_MM_ProjectCar car left join T_MM_TrackNumber track on track.fid = car.ftrackNumberid ");
            ArrayList<Object> param = new ArrayList<Object>();
            insert.append(" where stn.FNumber <= track.FNumber and etn.FNumber >= track.FNumber and bom.CFProjectID = car.fprojectid ");
            insert.append(" and bom.CFRation is not null and bom.CFRation > 0");
            insert.append(" and bom.CFState = ?");
            param.add(4);
            insert.append(" and bom.CFProjectID = ?");
            param.add(this.project.getId().toString());
            Integer sfshpj = (Integer)this.params.get("sfshpj");
            StorageOrgUnitInfo sou = (StorageOrgUnitInfo)this.params.get("sou_tmp");
            insert.append(" and (bom.cfinitMakeFlow not like '\u7269%' or bom.cfinitMakeFlow is null)");
            param.add(sou.getId().toString());
            if (sfshpj != null && sfshpj.equals(32)) {
                insert.append(" and ((bom.cfstorageorgunitid!=bom.cfdrawbillorgid");
                insert.append(" and bom.cfdrawbillorgid=?");
                insert.append(" and bom.Cfmaterialpro='10030')");
                insert.append(" or bom.Cfmaterialpro='10020')");
            } else {
                insert.append(" and bom.cfstorageorgunitid!=bom.cfdrawbillorgid");
                insert.append(" and bom.cfdrawbillorgid=?");
                insert.append(" and bom.Cfmaterialpro='10030'");
            }
            if (this.params.containsKey("txtBatch") && this.filterBatch.booleanValue()) {
                insert.append(" and bom.cfbatch = ?");
                param.add(this.params.get("txtBatch"));
            }
            if (this.params.containsKey("prmtTrackBegin")) {
                insert.append(" and stn.FNumber >= ?");
                param.add(this.params.get("prmtTrackBegin"));
            }
            if (this.params.containsKey("prmtTrackEnd")) {
                insert.append(" and etn.FNumber <= ?");
                param.add(this.params.get("prmtTrackEnd"));
            }
            if (this.params.containsKey("tracknumbers")) {
                List tracks = (List)this.params.get("tracknumbers");
                insert.append(" and track.FNumber in (").append(SQLUtil.arrayToString((Object[])tracks.toArray())).append(")");
            }
            insert.append(" ) ");
            int count = ProcessBomTree.executeUpdate((Context)this.ctx, (String)insert.toString(), param);
            this.updateLongNumber(1);
            this.insertInto(2, count);
        }

        protected void insertInto(int level, int count) throws Exception {
            if (level == 30) {
                throw new EASBizException(new NumericExceptionSubItem("id_error", ResourceBase.getString((String)"com.kingdee.eas.industry.emm.pcm.innerprice.EMMPCPcmInnerpriceResource", (String)"GYBOMSZKQGJC", (Locale)this.ctx.getLocale(), (Object[])new Object[]{level})));
            }
            if (count == 0) {
                return;
            }
            StringBuilder insert = new StringBuilder();
            insert.append("insert into ").append(this.treeTable).append(" (");
            insert.append("TREE_ID");
            insert.append(",").append("TREE_PARENT_ID");
            insert.append(",").append("TREE_BOM_ID");
            insert.append(",").append("TREE_PROJECT_ID");
            insert.append(",").append("TREE_TRACK_ID");
            insert.append(",").append("TREE_TRACK_NUMBER");
            insert.append(",").append("TREE_MATERIAL_ID");
            insert.append(",").append("TREE_MATERIAL_NAME");
            insert.append(",").append("TREE_MATERIAL_NUMBER");
            insert.append(",").append("TREE_MATERIAL_PROP");
            insert.append(",").append("TREE_FIXED");
            insert.append(",model");
            insert.append(",").append("TREE_PARENT_MATERIAL_ID");
            insert.append(",").append("TREE_PARENT_MATERIAL_NAME");
            insert.append(",").append("TREE_PARENT_MATERIAL_NUMBER");
            insert.append(",").append("TREE_PARENT_MATERIAL_PROP");
            insert.append(",").append("TREE_PARENT_FIXED");
            insert.append(",").append("TREE_LONG_NUMBER");
            insert.append(",").append("level_long_number");
            insert.append(",").append("TREE_LEVEL");
            insert.append(",").append("Expand_FIXED");
            insert.append(",").append("TREE_BILL_FIXED");
            insert.append(",").append("TREE_ISOWNOBJECT");
            insert.append(",cfrationunit");
            insert.append(",").append("CFIsSplit");
            insert.append(", cfweight,CFDrawBillOrgID,CFStorageOrgUnitID,CFUpdateRecord,CFUsingRate");
            insert.append(",CFQuantity,CFUnit,cfinitMakeFlow,cfmakeFlow,cfnote,cfstuffNo,CFSizeLength,CFSizeWidth,CFSizeHheight");
            insert.append(") \r\n (select ");
            insert.append("'").append(level).append("-'||rownum").append(" AS ").append("TREE_ID");
            insert.append(",tree.").append("TREE_ID").append(" AS ").append("TREE_PARENT_ID");
            insert.append(",bom.fid").append(" AS ").append("TREE_BOM_ID");
            insert.append(",bom.CFProjectID").append(" AS ").append("TREE_PROJECT_ID");
            insert.append(",track.fid").append(" AS ").append("TREE_TRACK_ID");
            insert.append(",track.fnumber").append(" AS ").append("TREE_TRACK_NUMBER");
            insert.append(",m.fid").append(" AS ").append("TREE_MATERIAL_ID");
            insert.append(",m.fname_l2").append(" AS ").append("TREE_MATERIAL_NAME");
            insert.append(",m.fnumber").append(" AS ").append("TREE_MATERIAL_NUMBER");
            insert.append(",bom.CFMaterialProperty").append(" AS ").append("TREE_MATERIAL_PROP");
            insert.append(",bom.CFRation").append(" AS ").append("TREE_FIXED");
            insert.append(",m.Fmodel").append(" AS model");
            insert.append(",tree.").append("TREE_MATERIAL_ID").append(" AS ").append("TREE_PARENT_MATERIAL_ID");
            insert.append(",tree.").append("TREE_MATERIAL_NAME").append(" AS ").append("TREE_PARENT_MATERIAL_NAME");
            insert.append(",tree.").append("TREE_MATERIAL_NUMBER").append(" AS ").append("TREE_PARENT_MATERIAL_NUMBER");
            insert.append(",tree.").append("TREE_MATERIAL_PROP").append(" AS ").append("TREE_PARENT_MATERIAL_PROP");
            insert.append(",tree.").append("TREE_FIXED").append(" AS ").append("TREE_PARENT_FIXED");
            insert.append(",tree.").append("TREE_LONG_NUMBER").append(" AS ").append("TREE_LONG_NUMBER");
            insert.append(",tree.").append("level_long_number").append("||'.'||(case when bom.CFSeq is not null then right(power(10,5-length(bom.CFSeq))||'',5-length(bom.CFSeq))||bom.CFSeq else right(power(10,5-length(rownum))||'',5-length(rownum))||rownum end)");
            insert.append(",").append(level).append(" AS ").append("TREE_LEVEL");
            insert.append(", tree.").append("Expand_FIXED").append(" * isnull(bom.CFRation,0)");
            insert.append(", ( case when bom.CFMaterialProperty != ").append(10020).append(" and tree.").append("TREE_MATERIAL_PROP").append(" != ").append(10020).append(" then isnull(bom.CFRation,0)").append(" else tree.").append("TREE_BILL_FIXED").append(" * isnull(bom.CFRation,0)").append(" end ) ");
            insert.append(",\r\n").append("Case BOM.CFBOMMaterialPro When '1' Then 1 Else 0 End\r\n");
            insert.append(", isnull(bom.cfrationunit,0) as cfrationunit");
            insert.append(",bom.").append("CFIsSplit");
            insert.append(", bom.cfweight,bom.CFDrawBillOrgID,bom.CFStorageOrgUnitID,bom.CFUpdateRecord,bom.CFUsingRate");
            insert.append(",bom.CFQuantity,bom.CFUnit,bom.cfinitMakeFlow,bom.cfmakeFlow,bom.cfnote,bom.cfstuffNo,bom.CFSizeLength,bom.CFSizeWidth,bom.CFSizeHheight");
            insert.append(" from CT_ZJB_ProcessBomBill bom");
            insert.append(" left join T_BD_Material m on m.fid = bom.CFMaterialID");
            insert.append(" left Join T_MM_TrackNumber stn on stn.FID=bom.CFBeginCarnoID");
            insert.append(" left Join T_MM_TrackNumber etn on etn.FID=bom.CFEndCarnoID");
            insert.append(" ,T_MM_ProjectCar car left join T_MM_TrackNumber track on track.fid = car.ftrackNumberid ");
            insert.append(" ,").append(this.treeTable).append(" tree ");
            ArrayList<Object> param = new ArrayList<Object>();
            insert.append(" where stn.FNumber <= track.FNumber and etn.FNumber >= track.FNumber and bom.CFProjectID = car.fprojectid ");
            insert.append(" and tree.").append("TREE_MATERIAL_NUMBER").append(" = bom.CFParentNo");
            insert.append(" and tree.").append("TREE_TRACK_ID").append(" = track.fid");
            insert.append(" and tree.").append("TREE_ID").append(" is not null");
            insert.append(" and tree.").append("TREE_LEVEL").append(" = ?");
            param.add(level - 1);
            insert.append(" and bom.CFRation is not null and bom.CFRation > 0");
            insert.append(" and bom.CFState = ?");
            param.add(4);
            insert.append(" and bom.CFProjectID = ?");
            param.add(this.project.getId().toString());
            if (this.params.containsKey("txtBatch") && this.filterBatch.booleanValue()) {
                insert.append(" and bom.cfbatch = ?");
                param.add(this.params.get("txtBatch"));
            }
            insert.append(" ) ");
            count = ProcessBomTree.executeUpdate((Context)this.ctx, (String)insert.toString(), param);
            this.updateLongNumber(level);
            this.insertInto(level + 1, count);
        }

        protected void updateLongNumber(int level) throws Exception {
            super.updateLongNumber(level);
            if (level > 1) {
                StringBuffer selectSql = new StringBuffer();
                selectSql.setLength(0);
                selectSql.append("select TREE_ID,xh,level_long_number from " + this.treeTable);
                selectSql.append(" where TREE_LEVEL=" + (level - 1));
                IRowSet rss = DbUtil.executeQuery((Context)this.ctx, (String)selectSql.toString());
                while (rss.next()) {
                    String TREE_ID = rss.getString("TREE_ID");
                    String xuhao = rss.getString("xh");
                    String level_long_number = rss.getString("level_long_number");
                    selectSql.setLength(0);
                    selectSql.append(" /*dialect*/update " + this.treeTable).append(" tree");
                    selectSql.append(" set (tree.xh,level_long_number)=");
                    selectSql.append(" (select xh,rw from (select '" + xuhao + "'||'.'||rownum xh,t.TREE_ID,'" + level_long_number + "'||'.'||lpad(rownum,5,'0') as rw");
                    selectSql.append(" from " + this.treeTable + " t");
                    selectSql.append(" where t.TREE_LEVEL=" + level);
                    selectSql.append(" and t.TREE_PARENT_ID='" + TREE_ID + "'");
                    selectSql.append(") t where tree.TREE_ID=t.TREE_ID) where tree.TREE_LEVEL=" + level);
                    selectSql.append(" and tree.TREE_PARENT_ID='" + TREE_ID + "'");
                    DbUtil.execute((Context)this.ctx, (String)selectSql.toString());
                }
            }
            if (level > this.levelcou) {
                this.levelcou = level;
            }
        }

        protected void execute(String treeTemp, Map params) throws Exception {
            StandardcsBillInfo billInfo = (StandardcsBillInfo)params.get("billInfo");
            this.clf(billInfo, treeTemp);
            this.gf(billInfo, treeTemp);
        }

        private void gf(StandardcsBillInfo billInfo, String treeTemp) throws SQLException, BOSException {
            StringBuilder sql = new StringBuilder();
            sql.append(" /*dialect*/select tree.xh,tree.tree_material_id,tree.TREE_MATERIAL_NAME,tree.TREE_MATERIAL_NUMBER,tree.model,");
            sql.append(" tree.tree_parent_material_id,tree.TREE_PARENT_MATERIAL_NAME,tree.TREE_PARENT_MATERIAL_NUMBER,");
            sql.append(" tree.CFQuantity,tree.TREE_FIXED,tree.Expand_FIXED,");
            sql.append(" tree.CFUnit,nvl(tree.cfweight, 0) * tree.Expand_FIXED,");
            sql.append(" tree.cfinitMakeFlow,tree.cfmakeFlow,");
            sql.append(" tree.TREE_MATERIAL_PROP,");
            sql.append(" tree.cfnote,tree.cfstuffNo,tree.tree_parent_id || tree.tree_id,tree.tree_level,");
            sql.append(" tree.cfweight,tree.CFDrawBillOrgID,tree.CFStorageOrgUnitID,");
            sql.append(" ly.fnumber as flynumber,ly.fname_l2 as flyname,");
            sql.append(" gy.fnumber as fgynumber,gy.fname_l2 as fgyname");
            sql.append(" ,op.fid as opid,op.fnumber as gxNumber,op.fname_l2 as gxName,rwp.cffixedworkingtime as cffixedworkingtime,rsou.CFGeneralRate as zhflv");
            sql.append(" ,rwp.fentrusttype,rwp.flaborcost,tree.cfrationunit");
            sql.append(" from ").append(treeTemp).append(" tree");
            sql.append(" left join t_mm_bomEntry be on be.FSOURCEPROCESSID =tree.TREE_BOM_ID");
            sql.append(" left outer join t_mm_pbomentry pbe on  be.fid=pbe.fbomitemid");
            sql.append(" left outer join t_mm_pbom pb on pb.fid=pbe.fparentid");
            sql.append(" left join T_MM_StandardRooting sr on pb.froutingid=sr.fid");
            sql.append(" left join T_MM_MaterialRooting mr ON sr.FMaterialRootingID = mr.FID");
            sql.append(" left join T_MM_MaterialRWP rwp ON mr.FID = rwp.FParentID");
            sql.append(" left outer join t_mm_operation op on rwp.FOperationID=op.fid");
            sql.append(" left join t_org_storage ly on tree.CFStorageOrgUnitID=ly.fid ");
            sql.append(" left join t_org_storage gy on tree.CFDrawBillOrgID=gy.fid ");
            sql.append(" left join ct_pcm_AdminAndStorageOrg aao on aao.fstorageid=gy.fid");
            sql.append(" left join CT_PCM_RateSOMU rsou on aao.fadminid=rsou.CFUnitsID and rsou.CFExpenseType=1 and rsou.CFRateType=4");
            sql.append(" where tree.TREE_MATERIAL_PROP='10030'");
            sql.append(" order by tree.level_long_number");
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
            billInfo.getAssEntrys().clear();
            while (rs.next()) {
                BigDecimal workingtime;
                StandardcsBillAssEntryInfo entry = new StandardcsBillAssEntryInfo();
                entry.setXh(rs.getString("xh"));
                if (rs.getString("tree_material_id") != null) {
                    MaterialInfo lj = new MaterialInfo();
                    lj.setId(BOSUuid.read((String)rs.getString("tree_material_id")));
                    lj.setNumber(rs.getString("TREE_MATERIAL_NUMBER"));
                    lj.setName(rs.getString("TREE_MATERIAL_NAME"));
                    lj.setModel(rs.getString("model"));
                    entry.setLaborMaterialNumber(lj);
                    entry.setMaterialModel(rs.getString("model"));
                    entry.setLaborMaterialName(rs.getString("TREE_MATERIAL_NAME"));
                }
                entry.setSingleHeavy(rs.getBigDecimal("cfweight"));
                entry.setUnitt(rs.getString("cfunit"));
                entry.setGyFlow(rs.getString("cfinitMakeFlow"));
                if (rs.getString("tree_parent_material_id") != null) {
                    MaterialInfo sslj = new MaterialInfo();
                    sslj.setId(BOSUuid.read((String)rs.getString("tree_parent_material_id")));
                    sslj.setNumber(rs.getString("TREE_PARENT_MATERIAL_NUMBER"));
                    sslj.setName(rs.getString("TREE_PARENT_MATERIAL_NAME"));
                    entry.setParentMaterial(sslj);
                    entry.setParentMaterialName(rs.getString("TREE_PARENT_MATERIAL_NAME"));
                }
                entry.setSplitFlow(rs.getString("cfmakeFlow"));
                entry.setMaterialPro(MaterialAttributeEnum.getEnum((int)rs.getInt("TREE_MATERIAL_PROP")));
                if (rs.getString("CFDrawBillOrgID") != null) {
                    StorageOrgUnitInfo ghkczz = new StorageOrgUnitInfo();
                    ghkczz.setId(BOSUuid.read((String)rs.getString("CFDrawBillOrgID")));
                    ghkczz.setNumber(rs.getString("fgynumber"));
                    ghkczz.setName(rs.getString("fgyname"));
                    entry.setSuppSou(ghkczz);
                }
                if (rs.getString("CFStorageOrgUnitID") != null) {
                    StorageOrgUnitInfo lykczz = new StorageOrgUnitInfo();
                    lykczz.setId(BOSUuid.read((String)rs.getString("CFStorageOrgUnitID")));
                    lykczz.setNumber(rs.getString("flynumber"));
                    lykczz.setName(rs.getString("flyname"));
                    entry.setReqSou(lykczz);
                }
                entry.setGxsm(rs.getString("gxName"));
                BigDecimal bigDecimal = workingtime = rs.getBigDecimal("cffixedworkingtime") == null ? BigDecimal.ZERO : rs.getBigDecimal("cffixedworkingtime");
                if (rs.getInt("fentrusttype") == 2) {
                    entry.setDwdegs(rs.getBigDecimal("flaborcost"));
                } else {
                    entry.setDwdegs(workingtime);
                }
                entry.setDjgs(entry.getDwdegs());
                BigDecimal expand_FIXED = rs.getBigDecimal("Expand_FIXED") == null ? BigDecimal.ZERO : rs.getBigDecimal("Expand_FIXED");
                entry.setTrollyDE(expand_FIXED);
                entry.setTcgs(expand_FIXED.multiply(entry.getDjgs()));
                entry.setZhfl(rs.getBigDecimal("zhflv"));
                if (rs.getInt("fentrusttype") == 2) {
                    entry.setDjgf(rs.getBigDecimal("flaborcost"));
                } else {
                    entry.setDjgf(entry.getDjgs().multiply(rs.getBigDecimal("zhflv")));
                }
                entry.setTcgf(expand_FIXED.multiply(entry.getDjgf()));
                entry.setGshdbl(BigDecimal.ONE);
                entry.setHddjgs(entry.getDwdegs());
                entry.setHdtcgs(entry.getTcgs());
                entry.setHddjgf(entry.getDjgf());
                entry.setHdtcgf(entry.getTcgf());
                entry.setZjde(rs.getBigDecimal("Expand_FIXED"));
                if (entry.getZjde() != null && entry.getHddjgf() != null) {
                    entry.setHdtcgf(entry.getHddjgf().multiply(entry.getZjde()));
                }
                billInfo.getAssEntrys().add(entry);
            }
        }

        private void clf(StandardcsBillInfo billInfo, String treeTemp) throws BOSException, UuidException, SQLException {
            StringBuilder sql = new StringBuilder();
            sql.append(" /*dialect*/select distinct tree.xh,tree.level_long_number,tree.tree_material_id,tree.TREE_MATERIAL_NAME,tree.TREE_MATERIAL_NUMBER,tree.model,");
            sql.append(" tree.tree_parent_material_id,tree.TREE_PARENT_MATERIAL_NAME,tree.TREE_PARENT_MATERIAL_NUMBER,");
            sql.append(" tree.CFQuantity,tree.TREE_FIXED,tree.Expand_FIXED,");
            sql.append(" tree.CFUnit,nvl(tree.cfweight, 0) * tree.Expand_FIXED,");
            sql.append(" tree.cfinitMakeFlow,tree.cfmakeFlow,");
            sql.append(" tree.TREE_MATERIAL_PROP,");
            sql.append(" tree.cfnote,tree.cfstuffNo,tree.tree_parent_id || tree.tree_id,tree.tree_level,");
            sql.append(" tree.CFIsSplit,tree.CFSizeLength,tree.CFSizeWidth,tree.CFSizeHheight,tree.CFUsingRate, ");
            sql.append(" tree.cfweight,tree.CFDrawBillOrgID,tree.CFStorageOrgUnitID,tree.CFUpdateRecord,");
            sql.append(" clp.CFMiduMizhong,clp.CFPrice,");
            sql.append(" first_value(oe.fprice) over(partition by oe.fmaterialid order by ob.fbizdate desc) as fprice,");
            sql.append(" ly.fnumber as flynumber,ly.fname_l2 as flyname,");
            sql.append(" gy.fnumber as fgynumber,gy.fname_l2 as fgyname,tree.cfrationunit");
            sql.append(" from " + treeTemp + " tree");
            sql.append(" left join t_org_storage ly on tree.CFStorageOrgUnitID=ly.fid ");
            sql.append(" left join t_org_storage gy on tree.CFDrawBillOrgID=gy.fid ");
            sql.append(" left join CT_PCM_ClInnerPrice clp on clp.CFMaterialID=tree.tree_material_id and clp.Cfstatus=2");
            sql.append(" ");
            sql.append(" left join T_AP_OtherBillEntry oe on oe.fmaterialid=tree.tree_material_id");
            sql.append(" left join T_AP_OtherBill ob on ob.fid=oe.fparentid and ob.fbillstatus=3");
            sql.append(" order by tree.level_long_number");
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
            billInfo.getEntrys().clear();
            while (rs.next()) {
                StandardcsBillEntryInfo entry = new StandardcsBillEntryInfo();
                entry.setXh(rs.getString("xh"));
                if (rs.getString("tree_material_id") != null) {
                    MaterialInfo lj = new MaterialInfo();
                    lj.setId(BOSUuid.read((String)rs.getString("tree_material_id")));
                    lj.setNumber(rs.getString("TREE_MATERIAL_NUMBER"));
                    lj.setName(rs.getString("TREE_MATERIAL_NAME"));
                    lj.setModel(rs.getString("model"));
                    entry.setEntryMaterial(lj);
                    entry.setMaterialModel(rs.getString("model"));
                    entry.setEntryMaterialName(rs.getString("TREE_MATERIAL_NAME"));
                }
                entry.setSingleHeavy(rs.getBigDecimal("cfweight"));
                entry.setUnit(rs.getString("cfunit"));
                entry.setGyFlow(rs.getString("cfinitMakeFlow"));
                if (rs.getString("tree_parent_material_id") != null) {
                    MaterialInfo sslj = new MaterialInfo();
                    sslj.setId(BOSUuid.read((String)rs.getString("tree_parent_material_id")));
                    sslj.setNumber(rs.getString("TREE_PARENT_MATERIAL_NUMBER"));
                    sslj.setName(rs.getString("TREE_PARENT_MATERIAL_NAME"));
                    entry.setParentMaterialNumber(sslj);
                    entry.setParentMaterialName(rs.getString("TREE_PARENT_MATERIAL_NAME"));
                }
                entry.setSingleDE(rs.getBigDecimal("cfrationunit"));
                entry.setTrollyDE(rs.getBigDecimal("Expand_FIXED") == null ? BigDecimal.ZERO : rs.getBigDecimal("Expand_FIXED"));
                entry.setSplitFlow(rs.getString("cfmakeFlow"));
                entry.setMaterialAttr(MaterialAttributeEnum.getEnum((int)rs.getInt("TREE_MATERIAL_PROP")));
                if (rs.getString("CFDrawBillOrgID") != null) {
                    StorageOrgUnitInfo ghkczz = new StorageOrgUnitInfo();
                    ghkczz.setId(BOSUuid.read((String)rs.getString("CFDrawBillOrgID")));
                    ghkczz.setNumber(rs.getString("fgynumber"));
                    ghkczz.setName(rs.getString("fgyname"));
                    entry.setSuppSou(ghkczz);
                }
                if (rs.getString("CFStorageOrgUnitID") != null) {
                    StorageOrgUnitInfo lykczz = new StorageOrgUnitInfo();
                    lykczz.setId(BOSUuid.read((String)rs.getString("CFStorageOrgUnitID")));
                    lykczz.setNumber(rs.getString("flynumber"));
                    lykczz.setName(rs.getString("flyname"));
                    entry.setReqSou(lykczz);
                }
                entry.setUpdateRecord(rs.getString("CFUpdateRecord"));
                entry.setClmdhmz(rs.getBigDecimal("CFMiduMizhong") == null ? BigDecimal.ZERO : rs.getBigDecimal("CFMiduMizhong"));
                if (rs.getBigDecimal("CFPrice") != null) {
                    entry.setClnbjsj(rs.getBigDecimal("CFPrice") == null ? BigDecimal.ZERO : rs.getBigDecimal("CFPrice"));
                } else {
                    entry.setClnbjsj(rs.getBigDecimal("fprice") == null ? BigDecimal.ZERO : rs.getBigDecimal("fprice"));
                }
                if (rs.getBigDecimal("CFSizeHheight") != null) {
                    entry.setClhou(rs.getBigDecimal("CFSizeHheight").compareTo(BigDecimal.ZERO) != 0 ? rs.getBigDecimal("CFSizeHheight") : null);
                }
                if (entry.getClhou() != null && entry.getClhou().compareTo(BigDecimal.ZERO) != 0) {
                    entry.setHouHd(entry.getClhou());
                }
                if (rs.getBigDecimal("CFSizeWidth") != null) {
                    entry.setClkuan(rs.getBigDecimal("CFSizeWidth").compareTo(BigDecimal.ZERO) != 0 ? rs.getBigDecimal("CFSizeWidth") : null);
                }
                if (entry.getClkuan() != null && entry.getClkuan().compareTo(BigDecimal.ZERO) != 0) {
                    entry.setKuanHd(entry.getClkuan());
                }
                if (rs.getBigDecimal("CFSizeLength") != null) {
                    entry.setClchang(rs.getBigDecimal("CFSizeLength").compareTo(BigDecimal.ZERO) != 0 ? rs.getBigDecimal("CFSizeLength") : null);
                }
                if (entry.getClchang() != null && entry.getClchang().compareTo(BigDecimal.ZERO) != 0) {
                    entry.setChangHd(entry.getClchang());
                }
                if (rs.getBigDecimal("CFSizeHheight") != null) {
                    entry.setHdbl(rs.getBigDecimal("CFSizeHheight").compareTo(BigDecimal.ZERO) != 0 ? rs.getBigDecimal("CFSizeHheight") : null);
                }
                if (entry.getClhou() != null && entry.getClkuan() != null && entry.getClchang() != null && entry.getHdbl() != null) {
                    if (entry.getClhou().compareTo(BigDecimal.ZERO) != 0 && entry.getClkuan().compareTo(BigDecimal.ZERO) != 0 && entry.getClchang().compareTo(BigDecimal.ZERO) != 0 && entry.getHdbl().compareTo(BigDecimal.ZERO) != 0) {
                        entry.setCldjde(entry.getClmdhmz().multiply(entry.getClhou()).multiply(entry.getClkuan()).multiply(entry.getClchang()).multiply(entry.getHdbl()).divide(new BigDecimal("1000000000"), 6, RoundingMode.HALF_UP));
                        entry.setHdcldjde(entry.getClmdhmz().multiply(entry.getHouHd()).multiply(entry.getKuanHd()).multiply(entry.getChangHd()).multiply(entry.getHdbl()).divide(new BigDecimal("1000000000"), 6, RoundingMode.HALF_UP));
                    }
                } else {
                    entry.setCldjde(entry.getSingleDE());
                    entry.setHdcldjde(entry.getSingleDE());
                }
                if (entry.getCldjde() != null && entry.getTrollyDE() != null && entry.getCldjde().compareTo(BigDecimal.ZERO) != 0 && entry.getTrollyDE().compareTo(BigDecimal.ZERO) != 0) {
                    entry.setCltcde(entry.getTrollyDE().multiply(entry.getCldjde()));
                }
                if (entry.getHdcldjde() != null && entry.getTrollyDE() != null && entry.getHdcldjde().compareTo(BigDecimal.ZERO) != 0 && entry.getTrollyDE().compareTo(BigDecimal.ZERO) != 0) {
                    entry.setHdcltcde(entry.getTrollyDE().multiply(entry.getHdcldjde()));
                }
                if (entry.getClnbjsj() != null && entry.getCldjde() != null && entry.getClnbjsj().compareTo(BigDecimal.ZERO) != 0 && entry.getCldjde().compareTo(BigDecimal.ZERO) != 0) {
                    entry.setDjlf(entry.getClnbjsj().multiply(entry.getCldjde()).setScale(2, RoundingMode.HALF_UP));
                }
                if (entry.getClnbjsj() != null && entry.getCltcde() != null && entry.getClnbjsj().compareTo(BigDecimal.ZERO) != 0 && entry.getCltcde().compareTo(BigDecimal.ZERO) != 0) {
                    entry.setTclf(entry.getClnbjsj().multiply(entry.getCltcde()).setScale(2, RoundingMode.HALF_UP));
                }
                if (entry.getClnbjsj() != null && entry.getHdcldjde() != null && entry.getClnbjsj().compareTo(BigDecimal.ZERO) != 0 && entry.getHdcldjde().compareTo(BigDecimal.ZERO) != 0) {
                    entry.setHddjlf(entry.getClnbjsj().multiply(entry.getHdcldjde()).setScale(2, RoundingMode.HALF_UP));
                }
                entry.setZjde(rs.getBigDecimal("Expand_FIXED"));
                if (entry.getHddjlf() != null && entry.getClnbjsj().compareTo(BigDecimal.ZERO) != 0) {
                    entry.setHdtclf(entry.getHddjlf());
                } else if (entry.getZjde() != null && entry.getClnbjsj() != null) {
                    entry.setHdtclf(entry.getClnbjsj().multiply(entry.getZjde()));
                }
                entry.setQuantity(rs.getBigDecimal("CFQuantity"));
                billInfo.getEntrys().add(entry);
            }
        }
    }
}

