/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.pcm.marketingpart.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.industry.emm.pcm.basedata.MarketFitPriceStorageCollection;
import com.kingdee.eas.industry.emm.pcm.basedata.MarketFitPriceStorageFactory;
import com.kingdee.eas.industry.emm.pcm.marketingpart.MarketingTargetCostEntryCollection;
import com.kingdee.eas.industry.emm.pcm.marketingpart.MarketingTargetCostEntryInfo;
import com.kingdee.eas.industry.emm.pcm.marketingpart.MarketingTargetCostInfo;
import com.kingdee.eas.industry.emm.pcm.marketingpart.app.AbstractMarketingTargetCostControllerBean;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.zjbom.app.util.AutoNumberUtil;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class MarketingTargetCostControllerBean
extends AbstractMarketingTargetCostControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.industry.emm.pcm.marketingpart.app.MarketingTargetCostControllerBean");

    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        MarketingTargetCostInfo info = (MarketingTargetCostInfo)model;
        if (info == null) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.marketingpart.EMMPCPcmMarketingpartResource", (String)"0EMMPCMarketingpart-0000", (Locale)ctx.getLocale())));
        }
        if (info.getStatus() != BillBaseStatusEnum.SUBMITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.marketingpart.EMMPCPcmMarketingpartResource", (String)"0EMMPCMarketingpart-0001", (Locale)ctx.getLocale())));
        }
        info.setStatus(BillBaseStatusEnum.AUDITED);
        info.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
        info.setAuditDate(new Date());
        super.update(ctx, pk, (CoreBaseInfo)info);
    }

    protected void _unpassAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        MarketingTargetCostInfo info = (MarketingTargetCostInfo)model;
        if (info == null) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.marketingpart.EMMPCPcmMarketingpartResource", (String)"0EMMPCMarketingpart-0000", (Locale)ctx.getLocale())));
        }
        if (info.getStatus() != BillBaseStatusEnum.AUDITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.marketingpart.EMMPCPcmMarketingpartResource", (String)"0EMMPCMarketingpart-0002", (Locale)ctx.getLocale())));
        }
        info.setStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        info.setAuditor(null);
        info.setAuditDate(null);
        this._checkIsHaveDestBills(ctx, (CoreBaseInfo)info);
        super.update(ctx, pk, (CoreBaseInfo)info);
    }

    protected void _checkIsHaveDestBills(Context ctx, CoreBaseInfo billInfo) throws EASBizException, BOSException {
        String billIdString;
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        if (iBTPManager.ifHaveDestBills(billIdString = billInfo.getId().toString())) {
            throw new SCMBillException(SCMBillException.HASDESTBILL_CANNOTUNAUDIT, new Object[]{billInfo.getString("number")});
        }
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        MarketingTargetCostInfo eti = (MarketingTargetCostInfo)model;
        if (eti.getNumber() == null || eti.getNumber().toString().equals("")) {
            if (eti.getCU() == null) {
                eti.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
            }
            eti.setNumber(this.getNewNumber(ctx, (IObjectValue)eti, ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString()));
        }
        this.checkHead(ctx, eti);
        this.check(ctx, eti);
        this.checkEntry(ctx, eti);
        if (eti.getStatus() != BillBaseStatusEnum.TEMPORARILYSAVED && eti.getStatus() != BillBaseStatusEnum.ADD) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.marketingpart.EMMPCPcmMarketingpartResource", (String)"0EMMPCMarketingpart-0003", (Locale)ctx.getLocale())));
        }
        eti.setStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        return super._save(ctx, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        MarketingTargetCostInfo eti = (MarketingTargetCostInfo)model;
        this.checkHead(ctx, eti);
        this.check(ctx, eti);
        this.checkEntry(ctx, eti);
        if (eti.getStatus() != BillBaseStatusEnum.TEMPORARILYSAVED && eti.getStatus() != BillBaseStatusEnum.SUBMITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.marketingpart.EMMPCPcmMarketingpartResource", (String)"0EMMPCMarketingpart-0004", (Locale)ctx.getLocale())));
        }
        eti.setStatus(BillBaseStatusEnum.SUBMITED);
        if (eti.getNumber() == null || eti.getNumber().toString().equals("")) {
            eti.setNumber(this.getNewNumber(ctx, (IObjectValue)eti, ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString()));
        }
        return super._submit(ctx, model);
    }

    private void checkHead(Context ctx, MarketingTargetCostInfo info) throws EASBizException {
        if (info.getNumber() == null) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.marketingpart.EMMPCPcmMarketingpartResource", (String)"0EMMPCMarketingpart-0005", (Locale)ctx.getLocale())));
        }
        if (info.getAdminOrgUnit() == null) {
            info.setAdminOrgUnit(ContextUtil.getCurrentAdminUnit((Context)ctx));
        }
        if (info.getBizDate() == null || info.get("bizDate").equals("")) {
            throw new EASBizException(new NumericExceptionSubItem("", info.getNumber() + EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.marketingpart.EMMPCPcmMarketingpartResource", (String)"0EMMPCMarketingpart-0006", (Locale)ctx.getLocale())));
        }
    }

    private void checkEntry(Context ctx, MarketingTargetCostInfo info) throws EASBizException {
        MarketingTargetCostEntryCollection entryCollection = info.getEntrys();
        for (int i = 0; i < entryCollection.size(); ++i) {
            MarketingTargetCostEntryInfo entryInfo = entryCollection.get(i);
            StringBuffer tmpStr = new StringBuffer();
            MaterialInfo materialInfo = entryInfo.getMaterial();
            if (materialInfo != null) {
                EntityViewInfo evi = new EntityViewInfo();
                evi.setSelector(new SelectorItemCollection());
                evi.getSelector().add(new SelectorItemInfo("targetPrice"));
                evi.setFilter(new FilterInfo());
                evi.getFilter().getFilterItems().add(new FilterItemInfo("materialNumber.number", (Object)materialInfo.getNumber(), CompareType.EQUALS));
                evi.getFilter().getFilterItems().add(new FilterItemInfo("status", (Object)2, CompareType.EQUALS));
                evi.setSorter(new SorterItemCollection());
                SorterItemInfo itemInfo = new SorterItemInfo("updateDate");
                itemInfo.setSortType(SortType.DESCEND);
                evi.getSorter().add(itemInfo);
                MarketFitPriceStorageCollection collection = null;
                try {
                    collection = MarketFitPriceStorageFactory.getLocalInstance(ctx).getMarketFitPriceStorageCollection(evi);
                }
                catch (BOSException e1) {
                    e1.printStackTrace();
                }
                BigDecimal targetPrice = null;
                if (collection.size() != 0) {
                    targetPrice = collection.get(0).getTargetPrice();
                }
                entryInfo.setOneCost(targetPrice);
            }
            entryInfo.setPurCost(this.getNo(entryInfo.getQty()).multiply(this.getNo(entryInfo.getOneCost())));
            if (entryInfo.getOrderPrice() != null && entryInfo.getOrderPrice().compareTo(BigDecimal.ZERO) != 0) {
                entryInfo.setMaoli(this.getNo(entryInfo.getOrderPrice()).subtract(this.getNo(entryInfo.getOneCost())).divide(this.getNo(entryInfo.getOrderPrice()), 2, 4));
            }
            if (tmpStr.length() <= 0) continue;
            throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.industry.emm.pcm.marketingpart.EMMPCPcmMarketingpartResource", (String)"YXPJMBCBFLDJH", (Locale)ctx.getLocale(), (Object[])new Object[]{i + 1}) + ":\n" + tmpStr.toString()));
        }
    }

    protected void check(Context ctx, MarketingTargetCostInfo eti) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)eti.getNumber(), CompareType.EQUALS));
        if (eti.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)eti.getId().toString(), CompareType.NOTEQUALS));
        }
        if (this._exists(ctx, filter)) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.marketingpart.EMMPCPcmMarketingpartResource", (String)"0EMMPCMarketingpart-0007", (Locale)ctx.getLocale())));
        }
    }

    @Override
    protected String _showGYBOM(Context ctx, Map map) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        String projectid = map.get("project") == null ? "" : map.get("project").toString();
        String trackNo = map.get("trackNumber") == null ? "" : map.get("trackNumber").toString();
        String topMaterialNumber = map.get("material") == null ? "" : map.get("material").toString();
        String tempTableBomName = "";
        try {
            tempTableBomName = TempTablePool.getInstance((Context)ctx).createTempTable(this.createTempTable1());
            TempTablePool.getInstance((Context)ctx).createIndex(tempTableBomName, "fmaterialnumber", false, false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        sql.append("insert into " + tempTableBomName + "\n");
        sql.append(" select 0,pb.fid as fbomid ,null as fparentbomid ,pb.cfmakeflow,pb.CFDrawBillOrgID,pb.CFParentNo,pb.CFPortNo,pb.CFWeight,pb.CFRation as fflexQty\n");
        sql.append(" from CT_ZJB_ProcessBomBill pb\n");
        sql.append(" inner join t_bd_material m on m.fnumber=pb.CFParentNo\n");
        sql.append("  inner join t_mm_tracknumber btrack on btrack.fid=pb.CFBeginCarnoID\n");
        sql.append("  inner join t_mm_tracknumber etrack on etrack.fid=pb.CFEndCarnoID\n");
        sql.append(" where pb.cfprojectid='" + projectid + "'\n");
        sql.append(" and pb.cfprojectid='" + projectid + "'\n");
        sql.append(" and btrack.fnumber<='" + trackNo + "' and etrack.fnumber>='" + trackNo + "'\n");
        sql.append(" and pb.CFRation is not null and pb.CFRation>0\n");
        sql.append(" and not exists (select 1 from CT_ZJB_ProcessBomBill pbb where pbb.cfprojectid=pb.cfprojectid and pbb.CFBatch=pb.cfbatch and pbb.cfportno in (" + topMaterialNumber + ") and pb.cfportno in (" + topMaterialNumber + ")  )\n");
        sql.append("  and exists (select 1 from CT_ZJB_ProcessBomBill pbs where  pbs.cfprojectid=pb.cfprojectid and pbs.CFBatch=pb.cfbatch and pbs.cfparentno in (" + topMaterialNumber + ") and pb.cfparentno in (" + topMaterialNumber + ") )\n");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        for (int i = 1; i < 99; ++i) {
            sql.setLength(0);
            sql.append("/*dialect*/insert into " + tempTableBomName);
            sql.append(" select " + i + " ,pbb.fid as fbomid,tmp.fbomid as fparentbomid,\n");
            sql.append(" pbb.cfmakeflow,pbb.CFDrawBillOrgID,\n");
            sql.append(" tmp.fmaterialnumber,pbb.CFPortNo,pbb.CFWeight,\n");
            sql.append(" tmp.fflexQty*pbb.CFRation\n");
            sql.append(" from " + tempTableBomName + " tmp\n");
            sql.append(" inner join CT_ZJB_ProcessBomBill pbb\n");
            sql.append(" on pbb.cfprojectid='" + projectid + "'\n");
            sql.append(" and pbb.cfparentno=tmp.fmaterialnumber\n");
            sql.append("  inner join t_mm_tracknumber btrack on btrack.fid=pbb.CFBeginCarnoID\n");
            sql.append("  inner join t_mm_tracknumber etrack on etrack.fid=pbb.CFEndCarnoID\n");
            sql.append(" where tmp.fsign=" + (i - 1) + " and pbb.CFRation is not null and pbb.CFRation>0\n");
            sql.append(" and pbb.CFState=4\n");
            sql.append(" and btrack.fnumber<='" + trackNo + "' and etrack.fnumber>='" + trackNo + "'\n");
            int t = SQLUtils.execute((Context)ctx, (String)sql.toString());
            if (t == 0) break;
        }
        return tempTableBomName;
    }

    private BigDecimal getNo(BigDecimal bb) {
        return bb == null ? BigDecimal.ZERO : bb;
    }

    private String createTempTable1() {
        StringBuffer sql = new StringBuffer();
        sql.append("create table T_pcm_tempSonCompanyRpt(");
        sql.append("fsign numeric(20),");
        sql.append("fbomid varchar(44),");
        sql.append("fparentbomid varchar(44),");
        sql.append("fgyflow varchar(100),");
        sql.append("fdrawBillOrg varchar(44),");
        sql.append("fparentmterialNo varchar(100),");
        sql.append("fmaterialnumber varchar(100),");
        sql.append("CFWeight numeric(20,8),");
        sql.append("fflexQty numeric(30,8)");
        sql.append(")");
        return sql.toString();
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        MarketingTargetCostInfo info = this.getMarketingTargetCostInfo(ctx, pk);
        if (info.getStatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.marketingpart.EMMPCPcmMarketingpartResource", (String)"0EMMPCMarketingpart-0008", (Locale)ctx.getLocale()) + info.getNumber() + EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.marketingpart.EMMPCPcmMarketingpartResource", (String)"0EMMPCMarketingpart-0009", (Locale)ctx.getLocale())));
        }
        super._delete(ctx, pk);
    }

    protected String getNewNumber(Context ctx, IObjectValue model, String strCompanyID) throws BOSException, EASBizException {
        AutoNumberUtil.initNumber((Context)ctx, (IObjectValue)model, (String)"CU");
        return model.get("number") == null ? "AutoNoNumberRule_" + BOSUuid.create((String)"06F079FA").toString() : model.get("number").toString();
    }

    protected boolean isSameNumber(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        CoreBillBaseInfo aSCMBillBaseInfo = (CoreBillBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = null;
        filterItem = aSCMBillBaseInfo.getNumber() == null ? new FilterItemInfo("number", (Object)aSCMBillBaseInfo.getNumber(), CompareType.EQUALS) : new FilterItemInfo("number", (Object)aSCMBillBaseInfo.getNumber().trim(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (aSCMBillBaseInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)aSCMBillBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (aSCMBillBaseInfo.getCU() != null) {
            filterItem = new FilterItemInfo("CU", (Object)aSCMBillBaseInfo.getCU().getId().toString(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        } else {
            filterItem = new FilterItemInfo("CU", null, CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < filter.getFilterItems().size(); ++i) {
            if (i != 0) {
                sb.append(" and #" + i);
                continue;
            }
            sb.append("#" + i);
        }
        filter.setMaskString(sb.toString());
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        return super._exists(ctx, filter);
    }
}

