/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.pcm.pricestorage.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.codingrule.RuleStatus;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.industry.emm.common.BillBaseStatusEnum;
import com.kingdee.eas.industry.emm.pcm.pricestorage.ProductsPriceStorageEntryInfo;
import com.kingdee.eas.industry.emm.pcm.pricestorage.ProductsPriceStorageInfo;
import com.kingdee.eas.industry.emm.pcm.pricestorage.app.AbstractProductsPriceStorageControllerBean;
import com.kingdee.eas.industry.emm.pcm.util.PCMBOMTreeUtil;
import com.kingdee.eas.mm.basedata.OperationInfo;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.mm.project.ProjectFactory;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ProductsPriceStorageControllerBean
extends AbstractProductsPriceStorageControllerBean {
    private String RESURL = "com.kingdee.eas.industry.emm.lcm.LcmResourceTwo";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.industry.emm.pcm.pricestorage.app.ProductsPriceStorageControllerBean");
    public static final String FID = "F_ID";
    public static final String FLEVEL = "F_LEVEL";
    public static final String FBOMID = "F_BOMID";
    public static final String FBOMENTRYID = "F_BOMENTRYID";
    public static final String FPARENTID = "F_PARENTID";
    public static final String FMaterialID = "F_MaterialID";
    public static final String FMaterialNumber = "F_MaterialNumber";
    public static final String FMaterialProp = "F_MaterialProp";
    public static final String FParentMaterialID = "F_ParentMaterialID";
    public static final String FProductID = "F_ProductID";
    public static final String FProductNumber = "F_ProductNumber";
    public static final String FProjectID = "F_ProjectID";
    public static final String FTrackID = "F_TrackID";
    public static final String FTrackNumber = "F_TrackNumber";
    public static final String FSTrackID = "F_STrackID";
    public static final String FSTrackNumber = "F_STrackNumber";
    public static final String FETrackID = "F_ETrackID";
    public static final String FETrackNumber = "F_ETrackNumber";
    public static final String FParentConsumeFixQTY = "F_ParentConsumeFixQTY";
    public static final String FConsumeFixQTY = "F_ConsumeFixQTY";
    public static final String FConsumeQty = "F_ConsumeQty";
    public static final String FTREE_LONG_NUMBER = "TREE_LONG_NUMBER";
    public static final String FISLEAF = "F_ISLEAF";
    protected Set bomids = new HashSet();
    private Set material = new HashSet();
    private String topMaterialId;
    private BigDecimal totalCost;
    private static final String MATERIALSOU = "4ueEzZGDSYuVfAD/hLHijsznrtQ=";

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ProductsPriceStorageInfo bill = (ProductsPriceStorageInfo)model;
        if (bill.getCU() == null) {
            bill.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        }
        this.checkNumber(ctx, (IObjectValue)bill);
        return super._addnew(ctx, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ProductsPriceStorageInfo eti = (ProductsPriceStorageInfo)model;
        this.check(ctx, eti);
        if (eti.getBillStatus() != BillBaseStatusEnum.TEMPORARILYSAVED && eti.getBillStatus() != BillBaseStatusEnum.SUBMITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.pricestorage.EMMPCPcmPricestorageResource", (String)"0EMMPCPricestorage-0000", (Locale)ctx.getLocale())));
        }
        eti.setBillStatus(BillBaseStatusEnum.SUBMITED);
        return super._submit(ctx, model);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ProductsPriceStorageInfo eti = (ProductsPriceStorageInfo)model;
        if (eti.getCU() == null) {
            eti.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        }
        this.check(ctx, eti);
        if (eti.getBillStatus() != BillBaseStatusEnum.TEMPORARILYSAVED && eti.getBillStatus() != BillBaseStatusEnum.ADD) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.pricestorage.EMMPCPcmPricestorageResource", (String)"0EMMPCPricestorage-0001", (Locale)ctx.getLocale())));
        }
        eti.setBillStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        return super._save(ctx, model);
    }

    protected void checkNumber(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ProductsPriceStorageInfo info = (ProductsPriceStorageInfo)model;
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        RuleStatus ruleStatus = iCodingRuleManager.getRuleStatus(model, info.getAdminOrgUnit().getId().toString());
        if (ruleStatus.isExist() && (StringUtils.isEmpty((String)info.getNumber()) || ruleStatus.isAddNoBreak() || !ruleStatus.isModifiable() && this.isNumberUsed(ctx, info))) {
            this.setNewNumber(ctx, info, iCodingRuleManager, null);
        } else {
            ObjectUuidPK pk = new ObjectUuidPK(model.getBOSUuid("id"));
            super._checkNumberBlank(ctx, (IObjectPK)pk, model);
            super._checkNumberDup(ctx, (IObjectPK)pk, model);
        }
    }

    protected void setNewNumber(Context ctx, CoreBillBaseInfo info, ICodingRuleManager iCodingRuleManager, String customString) throws BOSException, EASBizException {
        String number = iCodingRuleManager.getNumber((IObjectValue)info, ((ProductsPriceStorageInfo)info).getAdminOrgUnit().getId().toString(), customString);
        info.setNumber(number);
        if (this.isNumberUsed(ctx, info)) {
            this.setNewNumber(ctx, info, iCodingRuleManager, customString);
        }
    }

    protected boolean isNumberUsed(Context ctx, CoreBillBaseInfo info) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)info.getNumber(), CompareType.EQUALS));
        if (info.getCU() != null) {
            filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)info.getCU().getId().toString(), CompareType.EQUALS));
        }
        if (info.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
        }
        boolean exist = super._exists(ctx, filter);
        return exist;
    }

    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        ProductsPriceStorageInfo info = (ProductsPriceStorageInfo)model;
        if (info == null) {
            info = (ProductsPriceStorageInfo)this._getValue(ctx, pk);
        }
        if (info.getBillStatus() != BillBaseStatusEnum.SUBMITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.pricestorage.EMMPCPcmPricestorageResource", (String)"0EMMPCPricestorage-0002", (Locale)ctx.getLocale())));
        }
        info.setBillStatus(BillBaseStatusEnum.AUDITED);
        info.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
        info.setAuditDate(new Date(System.currentTimeMillis()));
        super.update(ctx, pk, (CoreBaseInfo)info);
    }

    protected void _unpassAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        ProductsPriceStorageInfo info = (ProductsPriceStorageInfo)model;
        if (info == null) {
            info = (ProductsPriceStorageInfo)this._getValue(ctx, pk);
        }
        if (info.getBillStatus() != BillBaseStatusEnum.AUDITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.pricestorage.EMMPCPcmPricestorageResource", (String)"0EMMPCPricestorage-0003", (Locale)ctx.getLocale())));
        }
        info.setBillStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        info.setAuditor(null);
        info.setAuditDate(null);
        this._checkIsHaveDestBills(ctx, (CoreBaseInfo)info);
        super.update(ctx, pk, (CoreBaseInfo)info);
    }

    protected void _checkIsHaveDestBills(Context ctx, CoreBaseInfo billInfo) throws EASBizException, BOSException {
        String billIdString;
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        if (iBTPManager.ifHaveDestBills(billIdString = billInfo.getId().toString())) {
            throw new SCMBillException(SCMBillException.HASDESTBILL_CANNOTUNAUDIT, new Object[]{billInfo.getString("number")});
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ProductsPriceStorageInfo info = (ProductsPriceStorageInfo)this.getValue(ctx, pk);
        if (info.getBillStatus() == BillBaseStatusEnum.AUDITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.pricestorage.EMMPCPcmPricestorageResource", (String)"0EMMPCPricestorage-0004", (Locale)ctx.getLocale())));
        }
        super._delete(ctx, pk);
    }

    protected void check(Context ctx, ProductsPriceStorageInfo eti) throws EASBizException, BOSException {
        if (eti.getCU() == null) {
            eti.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)eti.getNumber(), CompareType.EQUALS));
        if (eti.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)eti.getId().toString(), CompareType.NOTEQUALS));
        }
        if (this._exists(ctx, filter)) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.pricestorage.EMMPCPcmPricestorageResource", (String)"0EMMPCPricestorage-0005", (Locale)ctx.getLocale())));
        }
        StringBuffer errStr = new StringBuffer();
        if (eti.getProject() == null) {
            errStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.pricestorage.EMMPCPcmPricestorageResource", (String)"0EMMPCPricestorage-0006", (Locale)ctx.getLocale()));
        }
        if (eti.getTrackNumber() == null) {
            errStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.pricestorage.EMMPCPcmPricestorageResource", (String)"0EMMPCPricestorage-0007", (Locale)ctx.getLocale()));
        }
        if (eti.getAdminOrgUnit() == null) {
            errStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.pricestorage.EMMPCPcmPricestorageResource", (String)"0EMMPCPricestorage-0008", (Locale)ctx.getLocale()));
        }
        if (eti.getProductNumber() == null || eti.getProductNumber().getId() == null) {
            errStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.pricestorage.EMMPCPcmPricestorageResource", (String)"0EMMPCPricestorage-0009", (Locale)ctx.getLocale()));
        }
        if (errStr.length() > 0) {
            throw new EASBizException(new NumericExceptionSubItem("", errStr.toString()));
        }
        if (eti.getBizDate() == null) {
            eti.setBizDate(new Date());
        }
    }

    @Override
    protected Map _getDataFromBom(Context ctx, Map paramMap) throws BOSException {
        ProductsPriceStorageInfo billInfo = (ProductsPriceStorageInfo)paramMap.get("billInfo");
        try {
            ProjectInfo project = (ProjectInfo)paramMap.get("project");
            TrackNumberInfo trackNumber = (TrackNumberInfo)paramMap.get("trackNumber");
            HashSet<String> materialSet = new HashSet<String>();
            MaterialInfo mi = (MaterialInfo)paramMap.get("topMaterial");
            this.topMaterialId = mi.getId().toString();
            materialSet.add(mi.getId().toString());
            this.material.clear();
            this.material.add(mi.getId().toString());
            this.update_bom(ctx, project.getId().toString(), trackNumber.getNumber(), billInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        HashMap<String, ProductsPriceStorageInfo> re = new HashMap<String, ProductsPriceStorageInfo>();
        re.put("billInfo", billInfo);
        return re;
    }

    protected void update_bom(final Context ctx, final String project, final String trackNumber, final ProductsPriceStorageInfo billInfo) throws BOSException, EASBizException {
        PCMBOMTreeUtil bomtree = new PCMBOMTreeUtil(){

            @Override
            protected void execute(String treeTemp, Map params) throws Exception {
                ProductsPriceStorageControllerBean.this.add_data(ctx, treeTemp, project, trackNumber, params, billInfo);
            }
        };
        HashMap<String, Boolean> param = new HashMap<String, Boolean>();
        param.put("param_stopVirtual", false);
        ProjectInfo pi = ProjectFactory.getLocalInstance((Context)ctx).getProjectInfo((IObjectPK)new ObjectUuidPK(project));
        param.put("param_project", (Boolean)pi);
        TrackNumberInfo tn = TrackNumberFactory.getLocalInstance((Context)ctx).getTrackNumberInfo("where number = '" + trackNumber + "'");
        param.put("param_track", (Boolean)tn);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add(new SelectorItemInfo("name"));
        evi.getSelector().add(new SelectorItemInfo("number"));
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)this.material, CompareType.INCLUDE));
        MaterialCollection mc = MaterialFactory.getLocalInstance((Context)ctx).getMaterialCollection(evi);
        bomtree.run(ctx, mc, param);
    }

    protected void add_data(Context ctx, String treeTemp, String project, String trackNumber, Map params, ProductsPriceStorageInfo billInfo) throws Exception {
        StringBuffer selectSql = new StringBuffer();
        selectSql.setLength(0);
        String btreeTable = TempTablePool.getInstance((Context)ctx).createTempTable(this.getExpandBOMSql());
        TempTablePool.getInstance((Context)ctx).createIndex(btreeTable, FProjectID, false, false);
        TempTablePool.getInstance((Context)ctx).createIndex(btreeTable, FMaterialID, false, false);
        String tempPurInTable42 = TempTablePool.getInstance((Context)ctx).createTempTable(this.createTempPurInTable42());
        String tempPurInTable43 = TempTablePool.getInstance((Context)ctx).createTempTable(this.createTempPurInTable43());
        String tempPurInTable44 = TempTablePool.getInstance((Context)ctx).createTempTable(this.createTempPurInTable44());
        String tempPurInTable45 = TempTablePool.getInstance((Context)ctx).createTempTable(this.createTempPurInTable45());
        String tempPurInTable4 = TempTablePool.getInstance((Context)ctx).createTempTable(this.createTempPurInTable4());
        TempTablePool.getInstance((Context)ctx).createIndex(tempPurInTable4, "fMaterialId", false, false);
        String tempPurInTable5 = TempTablePool.getInstance((Context)ctx).createTempTable(this.createTempPurInTable5());
        TempTablePool.getInstance((Context)ctx).createIndex(tempPurInTable4, "fMaterialId", false, false);
        String xhTmp = TempTablePool.getInstance((Context)ctx).createTempTable(this.createTempPurInTable6());
        String sumTmp = TempTablePool.getInstance((Context)ctx).createTempTable(this.createTempPurInTable7());
        try {
            selectSql.setLength(0);
            selectSql.append(" insert into " + btreeTable);
            selectSql.append(" select ");
            selectSql.append(" ").append(FID);
            selectSql.append(" ,").append(FPARENTID);
            selectSql.append(", ").append(FProjectID);
            selectSql.append(",").append(FTrackID).append(",").append(FMaterialID).append(",").append(FMaterialProp).append(",").append(FParentMaterialID).append(",").append("cfbomflow").append(",").append(FLEVEL).append(",").append(FISLEAF).append(",sum(").append(FConsumeQty).append(") as ").append(FConsumeQty).append(",").append("null,null,null,null");
            selectSql.append(" from ").append(treeTemp);
            selectSql.append(" group by ").append(FID).append(",").append(FPARENTID).append(",").append(FProjectID).append(",").append(FMaterialID).append(",").append(FTrackID).append(",").append(FMaterialProp).append(",").append(FParentMaterialID).append(",").append("cfbomflow").append(",").append(FLEVEL).append(",").append(FISLEAF);
            int resulecount = SQLUtils.execute((Context)ctx, (String)selectSql.toString());
            selectSql.setLength(0);
            selectSql.append(" /*dialect*/insert into " + tempPurInTable42);
            selectSql.append(" select tmp.F_MaterialID,oe.CFLatestPurPrice,oe.CFAvePurPrice");
            selectSql.append(" from " + btreeTable + " tmp ");
            selectSql.append(" inner join  ");
            selectSql.append("  ct_pcm_purmaterialpricestorage oe");
            selectSql.append(" on oe.CFMaterialNumberID=tmp.F_MaterialID");
            resulecount = SQLUtils.execute((Context)ctx, (String)selectSql.toString());
            selectSql.setLength(0);
            selectSql.append(" /*dialect*/insert into " + tempPurInTable43);
            selectSql.append(" select fmid,fprice");
            selectSql.append(" from (select tmp.F_MaterialID as fmid,oe.CFNoTaxPrice as fprice,");
            selectSql.append(" row_number () over(partition by tmp.F_MaterialID  order by ob.fbizdate desc) as fseq");
            selectSql.append(" from " + btreeTable + " tmp ");
            selectSql.append(" inner join  ");
            selectSql.append("  CT_PCM_GongsiIPBE oe");
            selectSql.append(" on oe.CFMaterialID=tmp.F_MaterialID");
            selectSql.append(" inner join CT_PCM_GongsiInnerPriceBill ob on ob.fid=oe.fparentid and ob.CFProjectID=tmp.F_ProjectID");
            selectSql.append(" and ob.CFStatus=4");
            selectSql.append(" ) where fseq=1");
            resulecount = SQLUtils.execute((Context)ctx, (String)selectSql.toString());
            selectSql.setLength(0);
            selectSql.append(" /*dialect*/insert into " + tempPurInTable44);
            selectSql.append(" select fmid,fprice");
            selectSql.append(" from (select tmp.F_MaterialID as fmid,oe.CFNoTaxPrice as fprice,");
            selectSql.append(" row_number () over(partition by tmp.F_MaterialID  order by ob.fbizdate desc) as fseq");
            selectSql.append(" from " + btreeTable + " tmp ");
            selectSql.append(" inner join  ");
            selectSql.append("  CT_PCM_BranchAGPBE oe");
            selectSql.append(" on oe.cfmaterialid=tmp.F_MaterialID");
            selectSql.append(" inner join CT_PCM_BranchAGatherPriceBill ob on ob.fid=oe.fparentid and ob.CFProjectID=tmp.F_ProjectID");
            selectSql.append(" and ob.CFStatus=4");
            selectSql.append(" ) where fseq=1");
            resulecount = SQLUtils.execute((Context)ctx, (String)selectSql.toString());
            selectSql.setLength(0);
            selectSql.append(" /*dialect*/insert into " + tempPurInTable45);
            selectSql.append(" select tmp.F_MaterialID as fmid, ");
            selectSql.append(" mpu.CFUpdatePrice  ");
            selectSql.append(" from " + btreeTable + " tmp ");
            selectSql.append(" inner join CT_PCM_MaterialPriceUpdate mpu ");
            selectSql.append(" on mpu.CFProjectID=tmp.F_ProjectID");
            selectSql.append(" and mpu.CFMaterialID=tmp.F_MaterialID");
            selectSql.append(" ");
            resulecount = SQLUtils.execute((Context)ctx, (String)selectSql.toString());
            String ZXCGDJ = EASResource.getString((String)this.RESURL, (String)"ZXCGDJ", (Locale)ctx.getLocale());
            String LSCGJJ = EASResource.getString((String)this.RESURL, (String)"LSCGJJ", (Locale)ctx.getLocale());
            String GSNBJSJ = EASResource.getString((String)this.RESURL, (String)"GSNBJSJ", (Locale)ctx.getLocale());
            String FGSNBJSJ = EASResource.getString((String)this.RESURL, (String)"FGSNBJSJ", (Locale)ctx.getLocale());
            String WLZGJ = EASResource.getString((String)this.RESURL, (String)"WLZGJ", (Locale)ctx.getLocale());
            selectSql.setLength(0);
            selectSql.append(" /*dialect*/insert into " + tempPurInTable4);
            selectSql.append(" select DISTINCT tmp.F_MaterialID as fmid, ");
            selectSql.append(" nvl(t42.fLatestPrice,nvl(t42.fAvgPrice,nvl(t43.fprice,nvl(t44.fprice,t45.fprice)))), ");
            selectSql.append(" case when t42.fLatestPrice is not null then 'ZXCGDJ' when t42.fAvgPrice is not null then 'LSCGJJ' when t43.fprice is not null then 'GSNBJSJ'  when t44.fprice is not null then 'FGSNBJSJ' when t45.fprice is not null then 'WLZGJ' end as FPriceSource ");
            selectSql.append(" from " + btreeTable + " tmp ");
            selectSql.append(" left join " + tempPurInTable42 + " t42 ");
            selectSql.append(" on  tmp.F_MaterialID=t42.fmaterialid");
            selectSql.append(" left join " + tempPurInTable43 + " t43");
            selectSql.append(" on  tmp.F_MaterialID=t43.fmaterialid");
            selectSql.append(" left join " + tempPurInTable44 + " t44");
            selectSql.append(" on tmp.F_MaterialID=t44.fmaterialid");
            selectSql.append(" left join " + tempPurInTable45 + " t45");
            selectSql.append(" on tmp.F_MaterialID=t45.fmaterialid");
            resulecount = SQLUtils.execute((Context)ctx, (String)selectSql.toString());
            selectSql.setLength(0);
            selectSql.append("/*dialect*/update " + btreeTable + " tt set(FPrice,FPriceSource,FCost)=");
            selectSql.append("(");
            selectSql.append(" select distinct tm4.Fprice,tm4.fpricesource,tm4.fprice*mtp. F_ConsumeQty");
            selectSql.append(" from " + btreeTable + " mtp");
            selectSql.append(" inner join " + tempPurInTable4 + " tm4 on tm4.fMaterialId=mtp." + FMaterialID);
            selectSql.append(" where mtp.F_ISLEAF=1 and mtp.F_MaterialID=tt.F_MaterialID");
            selectSql.append(" and mtp.F_ParentMaterialID=tt.F_ParentMaterialID");
            selectSql.append(" and mtp.F_MaterialProp=tt.F_MaterialProp");
            selectSql.append(" and mtp.F_LEVEL=tt.F_LEVEL");
            selectSql.append(" and mtp.cfbomflow=tt.cfbomflow");
            selectSql.append(" and mtp.F_ID=tt.F_ID");
            selectSql.append(" and rownum = 1)");
            selectSql.append(" where exists(");
            selectSql.append(" select 1");
            selectSql.append(" from " + btreeTable + " mtp");
            selectSql.append(" inner join " + tempPurInTable4 + " tm4 on tm4.fMaterialId=mtp." + FMaterialID);
            selectSql.append(" where mtp.F_ISLEAF=1 and mtp.F_MaterialID=tt.F_MaterialID");
            selectSql.append(" and mtp.F_ParentMaterialID=tt.F_ParentMaterialID");
            selectSql.append(" and mtp.F_MaterialProp=tt.F_MaterialProp");
            selectSql.append(" and mtp.F_LEVEL=tt.F_LEVEL");
            selectSql.append(" and mtp.cfbomflow=tt.cfbomflow");
            selectSql.append(" and mtp.F_ID=tt.F_ID");
            selectSql.append(" )");
            resulecount = SQLUtils.execute((Context)ctx, (String)selectSql.toString());
            selectSql.setLength(0);
            selectSql.append("select sum(FCost) as fcost from " + btreeTable);
            IRowSet rsc = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
            this.totalCost = null;
            while (rsc.next()) {
                this.totalCost = rsc.getBigDecimal("fcost");
            }
            if (this.totalCost == null) {
                this.totalCost = BigDecimal.ZERO;
            }
            selectSql.setLength(0);
            selectSql.append("/*dialect*/ insert into " + xhTmp);
            selectSql.append(" select fid,null, fmid,fpmid,'" + this.topMaterialId + "',1,fisleaf, rownum from (select distinct t." + FID + " as fid,t." + FMaterialID + " as fmid,t." + FParentMaterialID + " as fpmid,t." + FISLEAF + " as fisleaf from " + btreeTable + " t");
            selectSql.append(" where t.F_LEVEL=1)");
            resulecount = SQLUtils.execute((Context)ctx, (String)selectSql.toString());
            ArrayList sqlList = new ArrayList();
            selectSql.setLength(0);
            selectSql.append("/*dialect*/ select max(t.F_LEVEL) tree_level from " + btreeTable + " t");
            IRowSet rs_t = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
            while (rs_t.next()) {
                int tree_level = rs_t.getInt("tree_level");
                for (int i = 1; i <= tree_level; ++i) {
                    selectSql.setLength(0);
                    selectSql.append("select *  from " + xhTmp);
                    selectSql.append(" where flevel=" + i);
                    selectSql.append(" and fisleaf=0");
                    IRowSet rss = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
                    while (rss.next()) {
                        String fmaterialid = rss.getString("fmaterialid");
                        String fParentMaterialid = rss.getString("fParentMaterialid");
                        String xuhao = rss.getString("fxh");
                        String fid = rss.getString("fid");
                        String fparentid = rss.getString("fParentId") == null ? null : rss.getString("fParentId");
                        int flevel = rss.getInt("flevel");
                        selectSql.setLength(0);
                        selectSql.append(" /*dialect*/ insert into " + xhTmp);
                        selectSql.append(" select t.F_ID,t.F_PARENTID,t.F_MaterialID,t.F_ParentMaterialID,LV.fGrandPMId," + (i + 1) + ",t." + FISLEAF + ",'" + xuhao + "'||'.'||rownum  ");
                        selectSql.append(" from " + btreeTable + " t");
                        selectSql.append(" inner join " + xhTmp + " xht on t." + FParentMaterialID + " = xht.fmaterialid and t." + FLEVEL + "=xht.flevel+1 ");
                        selectSql.append(" and t.F_LEVEL=" + (i + 1));
                        selectSql.append(" and t.F_ParentMaterialID='" + fmaterialid + "'");
                        selectSql.append(" and t.F_PARENTID='" + fid + "'");
                        selectSql.append(" and xht.fid='" + fid + "'");
                        selectSql.append(" inner join (");
                        selectSql.append(" select pt.F_ID as fid,pt.F_ParentMaterialID as fGrandPMId ");
                        selectSql.append(" from " + btreeTable + " pt  ");
                        selectSql.append(" where pt.F_ID='" + fid + "'");
                        selectSql.append(") LV on LV.fid=t.F_PARENTID");
                        resulecount = SQLUtils.execute((Context)ctx, (String)selectSql.toString());
                    }
                }
            }
            selectSql.setLength(0);
            selectSql.append(" /*dialect*/update " + btreeTable + " t set  t.fXuhao=(");
            selectSql.append(" select xht.fxh from " + xhTmp + " xht ");
            selectSql.append(" where t.F_MaterialID=xht.fmaterialid");
            selectSql.append(" and   t.F_LEVEL=xht.flevel");
            selectSql.append(" and   t.F_ParentMaterialID=xht.fParentMaterialid");
            selectSql.append(" and   t.F_ID=xht.fid");
            selectSql.append(" and   nvl(t.F_PARENTID,1)=nvl(xht.fParentId,1)");
            selectSql.append(")");
            selectSql.append(" where exists(");
            selectSql.append(" select 1 from " + xhTmp + " xht ");
            selectSql.append(" where t.F_MaterialID=xht.fmaterialid");
            selectSql.append(" and   t.F_LEVEL=xht.flevel");
            selectSql.append(" and   t.F_ParentMaterialID=xht.fParentMaterialid");
            selectSql.append(" and   t.F_ID=xht.fid");
            selectSql.append(" and   nvl(t.F_PARENTID,-1)=nvl(xht.fParentId,-1)");
            selectSql.append(")");
            resulecount = SQLUtils.execute((Context)ctx, (String)selectSql.toString());
            selectSql.setLength(0);
            selectSql.append("/*dialect*/ select max(t.F_LEVEL) tree_level from " + btreeTable + " t");
            IRowSet rsmt = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
            while (rsmt.next()) {
                int tree_level = rsmt.getInt("tree_level");
                for (int i = 1; i <= tree_level; ++i) {
                    selectSql.setLength(0);
                    selectSql.append("/*dialect*/insert into " + sumTmp);
                    selectSql.append(" select tb,tc,tn,sum(tv),tm from ( select mtp.F_PARENTID as tb,substr(mtp.fxuhao, 0,instr(mtp.fxuhao, '.',-1)-1) as tc,mtp.F_ParentMaterialID as tn,sum(mtp.F_ConsumeQty*mtp.fPrice) as tv,(" + i + "-1) as tm");
                    selectSql.append(" from " + btreeTable + " mtp");
                    selectSql.append(" where mtp.F_LEVEL=" + i);
                    selectSql.append(" and exists(");
                    selectSql.append(" select 1  from " + btreeTable + " tt");
                    selectSql.append(" where tt.F_LEVEL=" + (i - 1));
                    selectSql.append(" and tt.F_MaterialID=mtp.F_ParentMaterialID");
                    selectSql.append(" and substr(mtp.fxuhao, 0,instr(mtp.fxuhao, '.',-1)-1)=tt.fxuhao");
                    selectSql.append(")");
                    selectSql.append(" group by mtp.F_ParentMaterialID,mtp.F_PARENTID,mtp.fxuhao,mtp.F_LEVEL");
                    selectSql.append(" ) group by tb,tc,tn,tm ");
                    resulecount = SQLUtils.execute((Context)ctx, (String)selectSql.toString());
                }
            }
            String HZ = EASResource.getString((String)this.RESURL, (String)"HZ", (Locale)ctx.getLocale());
            selectSql.setLength(0);
            selectSql.append("update " + btreeTable + " tt");
            selectSql.append(" set(FPriceSource,FCost)=");
            selectSql.append(" ( ");
            selectSql.append("  select 'HZ',fcost");
            selectSql.append("  from " + sumTmp + " st");
            selectSql.append(" where st.fid=tt.F_ID");
            selectSql.append(" and st.fxuhao=tt.fxuhao");
            selectSql.append(" and st.fmaterialid=tt.F_MaterialID");
            selectSql.append(" and st.flevel=tt.F_LEVEL");
            selectSql.append(")");
            selectSql.append(" where exists(");
            selectSql.append("  select 1");
            selectSql.append("  from " + sumTmp + " st");
            selectSql.append(" where st.fid=tt.F_ID");
            selectSql.append(" and st.fxuhao=tt.fxuhao");
            selectSql.append(" and st.fmaterialid=tt.F_MaterialID");
            selectSql.append(" and st.flevel=tt.F_LEVEL");
            selectSql.append(")");
            resulecount = SQLUtils.execute((Context)ctx, (String)selectSql.toString());
            selectSql.setLength(0);
            selectSql.append(" /*dialect*/insert into " + tempPurInTable5);
            selectSql.append(" select  MM.mid as mid,MM.opid as opid,MM.opnumber as opnumber,MM.opname as opname,MM.admId,MM.admName as admName,MM.cffixedworkingtime as cffixedworkingtime,rsm.CFGeneralRate as CFGeneralRate,MM.cffixedworkingtime*rsm.CFGeneralRate as lc");
            selectSql.append("  from (select tmp.F_MaterialID as mid ,op.FID as opid,op.fnumber as opnumber,op.fname_l2 as opname,adm.fid as admId,adm.fname_l2 as admName,0 as  cffixedworkingtime ");
            selectSql.append("  from " + btreeTable + "  tmp");
            selectSql.append("  inner join T_MM_StandardRooting sr on sr.FMaterialID=tmp.F_MaterialID");
            selectSql.append("  left OUTER join T_MM_MaterialRooting mr on mr.fid=sr.FMaterialRootingID");
            selectSql.append("  left OUTER join T_MM_MaterialRWP mp on mr.fid=mp.FParentID ");
            selectSql.append("  LEFT OUTER JOIN T_MM_WorkCenter  wc on mp.FWorkCenterID=wc.fid");
            selectSql.append("  left outer join T_ORG_Admin  adm on wc.FAdminOrgUnitID=adm.fid");
            selectSql.append("  left outer join T_MM_Operation  op on op.FID=mp.FOperationID");
            selectSql.append("  where    sr.FIsMainRooting=1");
            selectSql.append("  and      tmp.F_MaterialProp=10030");
            selectSql.append("  ) MM ,");
            selectSql.append(" (select aaa.CFUnitsID,aaa.CFGeneralRate from ");
            selectSql.append(" (");
            selectSql.append(" select rm.CFUnitsID as CFUnitsID,rm.CFGeneralRate CFGeneralRate,");
            selectSql.append("       row_number() over(partition by  rm.CFUnitsID order by rm.cftime desc) fseq");
            selectSql.append(" from CT_PCM_RateSOMU rm where rm.CFRateType=1 and rm.cftimetype=1 and rm.cfstatus = 2");
            selectSql.append(" ) aaa where aaa.fseq = 1");
            selectSql.append("  ) rsm");
            selectSql.append(" where rsm.CFUnitsID=MM.admId  ");
            resulecount = SQLUtils.execute((Context)ctx, (String)selectSql.toString());
            selectSql.setLength(0);
            selectSql.append("/*dialect*/select distinct tmp.F_LEVEL as FLEVEL,tmp.F_ISLEAF as fisleaf ,tmp.fxuhao as fxuhao,tmp.F_MaterialID as fmid,");
            selectSql.append(" M.fnumber as fmaterialnumber,M.fname_l2 as fmaterialName,M.fmodel as fmodel,M.Fnetweight as Fnetweight,");
            selectSql.append(" Mu.fid as funitid,Mu.fname_l2 as funitName,tmp.F_ParentMaterialID as fparentMaterialId,");
            selectSql.append(" pm.fnumber as fpmnumber,tmp.fprice as fprice,");
            selectSql.append(" tmp.F_ConsumeQty as fconsumeqty,tmp.fCost as fMaterialcost,tmp.fpriceSource as fpriceSource ,tmp.CFBomFlow as CFBomFlow,");
            selectSql.append(" tm5.fOperationId as fOperationId,tm5.fOperationNumber as fOperationNumber,tm5.fOperationName as fOperationName, tm5.fadmId as fadmId,tm5.fadmName as fadmName,tm5.cffixedworkingtime as cffixedworkingtime, tm5.CFGeneralRate as CFGeneralRate,tm5.CFLaborCost as CFLaborCost,tmp.fCost+tm5.CFLaborCost as cftrackCost");
            selectSql.append(" from " + btreeTable + " tmp");
            selectSql.append(" inner join t_bd_material M on tmp.F_MaterialID=M.fid");
            selectSql.append(" inner join t_bd_material pm on pm.fid=tmp.F_ParentMaterialID");
            selectSql.append(" left join " + tempPurInTable5 + " tm5 on tm5.fmaterialid=tmp." + FMaterialID);
            selectSql.append(" left join t_bd_measureunit Mu on Mu.fid=M.fbaseunit");
            selectSql.append(" order by tmp.F_LEVEL");
            IRowSet rst = SQLUtils.executeQuery((Context)ctx, (String)selectSql.toString());
            BigDecimal trackCost = BigDecimal.ZERO;
            billInfo.getEntrys().clear();
            while (rst.next()) {
                ProductsPriceStorageEntryInfo qbi = new ProductsPriceStorageEntryInfo();
                qbi.setXuhao(rst.getString("fxuhao"));
                MaterialInfo mi = new MaterialInfo();
                mi.setId(BOSUuid.read((String)rst.getString("fmid")));
                mi.setNumber(rst.getString("fmaterialnumber"));
                mi.setName(rst.getString("fmaterialName"));
                mi.setModel(rst.getString("fmodel"));
                MeasureUnitInfo mui = new MeasureUnitInfo();
                mui.setId(BOSUuid.read((String)rst.getString("funitid")));
                mui.setName(rst.getString("funitName"));
                mi.setBaseUnit(mui);
                qbi.setMaterial(mi);
                qbi.setMaterialName(rst.getString("fmaterialName"));
                qbi.setModel(rst.getString("fmodel"));
                qbi.setBaseunit(rst.getString("funitName"));
                MaterialInfo pmi = new MaterialInfo();
                pmi.setId(BOSUuid.read((String)rst.getString("fparentMaterialId")));
                pmi.setNumber(rst.getString("fpmnumber"));
                qbi.setBelongMaterial(pmi);
                qbi.setWeight(rst.getBigDecimal("Fnetweight"));
                qbi.setTrackQty(rst.getBigDecimal("fconsumeqty"));
                if (rst.getBigDecimal("Fnetweight") != null && rst.getBigDecimal("fconsumeqty") != null) {
                    BigDecimal trackQty = rst.getBigDecimal("Fnetweight").multiply(rst.getBigDecimal("fconsumeqty"));
                    qbi.setTrackWeight(trackQty);
                }
                qbi.setPrice(rst.getBigDecimal("fprice"));
                qbi.setPriceSource(rst.getString("fpriceSource"));
                qbi.setFlow(rst.getString("CFBomFlow"));
                qbi.setLevel(rst.getInt("FLEVEL"));
                qbi.setTrackMaterialCost(rst.getBigDecimal("fMaterialcost"));
                OperationInfo opi = new OperationInfo();
                opi.setId(rst.getString("fOperationId") == null ? null : BOSUuid.read((String)rst.getString("fOperationId")));
                opi.setNumber(rst.getString("fOperationNumber"));
                opi.setName(rst.getString("fOperationName"));
                qbi.setOperation(opi);
                qbi.setOperationName(rst.getString("fOperationName"));
                AdminOrgUnitInfo admi = new AdminOrgUnitInfo();
                admi.setId(rst.getString("fadmId") == null ? null : BOSUuid.read((String)rst.getString("fadmId")));
                admi.setName(rst.getString("fadmName"));
                qbi.setWorkDep(admi);
                qbi.setGongshi(rst.getBigDecimal("cffixedworkingtime"));
                if (rst.getBigDecimal("cffixedworkingtime") != null && rst.getBigDecimal("fconsumeqty") != null) {
                    qbi.setTrackGongshi(rst.getBigDecimal("cffixedworkingtime").multiply(rst.getBigDecimal("fconsumeqty")));
                }
                qbi.setRate(rst.getBigDecimal("CFGeneralRate"));
                qbi.setTrackGongFei(rst.getBigDecimal("CFLaborCost"));
                qbi.setTrackCost(rst.getBigDecimal("cftrackCost"));
                if (rst.getBigDecimal("CFLaborCost") != null) {
                    this.totalCost = this.totalCost.add(rst.getBigDecimal("CFLaborCost"));
                }
                billInfo.getEntrys().add(qbi);
            }
            billInfo.setTrackTotalCost(this.totalCost);
        }
        catch (Exception e) {
            throw new Exception(e.getCause() + "\n" + selectSql);
        }
        finally {
            TempTablePool.getInstance((Context)ctx).releaseTable(tempPurInTable4);
            TempTablePool.getInstance((Context)ctx).releaseTable(tempPurInTable42);
            TempTablePool.getInstance((Context)ctx).releaseTable(tempPurInTable43);
            TempTablePool.getInstance((Context)ctx).releaseTable(tempPurInTable44);
            TempTablePool.getInstance((Context)ctx).releaseTable(tempPurInTable45);
            TempTablePool.getInstance((Context)ctx).releaseTable(tempPurInTable5);
            TempTablePool.getInstance((Context)ctx).releaseTable(xhTmp);
            TempTablePool.getInstance((Context)ctx).releaseTable(sumTmp);
            TempTablePool.getInstance((Context)ctx).releaseTable(btreeTable);
        }
    }

    protected String getExpandBOMSql() throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table ExpandBOMTable(\r\n");
        sql.append(FID).append(" VARCHAR(120) Not Null,\r\n");
        sql.append(FPARENTID).append(" VARCHAR(120) ,\r\n");
        sql.append(FProjectID).append(" VARCHAR(44) Not Null,\r\n");
        sql.append(FTrackID).append(" VARCHAR(44) Not Null,\r\n");
        sql.append(FMaterialID).append(" VARCHAR(44) Not Null,\r\n");
        sql.append(FMaterialProp).append(" INT Default ").append(10060).append(" Not Null,\r\n");
        sql.append("F_ParentMaterialID VARCHAR(44) Not Null,\r\n");
        sql.append("CFBomFlow VARCHAR(100) , \r\n");
        sql.append(FLEVEL).append(" INT ,\r\n");
        sql.append(FISLEAF).append(" INT ,  \r\n");
        sql.append(FConsumeQty).append(" Numeric(21,8) Default 0 Not Null,\r\n");
        sql.append("FPrice numeric(21,2) ,\r\n");
        sql.append("FCost numeric(21,2) ,\r\n");
        sql.append("fXuhao VARCHAR(120),\r\n");
        sql.append("fPriceSource VARCHAR(120)\r\n");
        sql.append(")");
        return sql.toString();
    }

    private String createTempPurInTable42() {
        StringBuffer sql = new StringBuffer();
        sql.append("create table T_PCM_TempPurIn42(");
        sql.append("fMaterialId varchar(44),");
        sql.append("fLatestPrice numeric(30,2),");
        sql.append("fAvgPrice numeric(30,2)");
        sql.append(")");
        return sql.toString();
    }

    private String createTempPurInTable43() {
        StringBuffer sql = new StringBuffer();
        sql.append("create table T_PCM_TempPurIn43(");
        sql.append("fMaterialId varchar(44),");
        sql.append("fPrice numeric(30,2)");
        sql.append(")");
        return sql.toString();
    }

    private String createTempPurInTable44() {
        StringBuffer sql = new StringBuffer();
        sql.append("create table T_PCM_TempPurIn44(");
        sql.append("fMaterialId varchar(44),");
        sql.append("fPrice numeric(30,2)");
        sql.append(")");
        return sql.toString();
    }

    private String createTempPurInTable45() {
        StringBuffer sql = new StringBuffer();
        sql.append("create table T_PCM_TempPurIn45(");
        sql.append("fMaterialId varchar(44),");
        sql.append("fPrice numeric(30,2)");
        sql.append(")");
        return sql.toString();
    }

    private String createTempPurInTable4() {
        StringBuffer sql = new StringBuffer();
        sql.append("create table T_PCM_TempPurIn4(");
        sql.append("fMaterialId varchar(44),");
        sql.append("fPrice numeric(30,2),");
        sql.append("FPriceSource varchar(30)");
        sql.append(")");
        return sql.toString();
    }

    private String createTempPurInTable5() {
        StringBuffer sql = new StringBuffer();
        sql.append("create table T_PCM_TempPurIn5(");
        sql.append("fMaterialId varchar(44),");
        sql.append("fOperationId  varchar(44),");
        sql.append("fOperationNumber  varchar(120),");
        sql.append("fOperationName  varchar(120),");
        sql.append("fadmId  varchar(44),");
        sql.append("fadmName  varchar(120),");
        sql.append("cffixedworkingtime  numeric(22,2),");
        sql.append("CFGeneralRate numeric(22,2),");
        sql.append("CFLaborCost numeric(22,2)");
        sql.append(")");
        return sql.toString();
    }

    private String createTempPurInTable6() {
        StringBuffer selectSql = new StringBuffer();
        selectSql.setLength(0);
        selectSql.append("create table ls (");
        selectSql.append("fid varchar(120),");
        selectSql.append("fParentId varchar(120),");
        selectSql.append("fmaterialid varchar(44),");
        selectSql.append("fParentMaterialid varchar(44),");
        selectSql.append("fGrandPMId varchar(44),");
        selectSql.append("flevel int,");
        selectSql.append("fisleaf int,");
        selectSql.append("fxh varchar(255))");
        return selectSql.toString();
    }

    private String createTempPurInTable7() {
        StringBuffer selectSql = new StringBuffer();
        selectSql.setLength(0);
        selectSql.append("create table ls7 (");
        selectSql.append("fid varchar(120),");
        selectSql.append("fXuhao varchar(255),");
        selectSql.append("fmaterialid varchar(44),");
        selectSql.append("fCost numeric(30,2),");
        selectSql.append("flevel int)");
        return selectSql.toString();
    }
}

