/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.pcm.productmanager.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.codingrule.RuleStatus;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialAttributeEnum;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.industry.emm.common.BillBaseStatusEnum;
import com.kingdee.eas.industry.emm.pcm.productmanager.QuatoAdjustBillInfo;
import com.kingdee.eas.industry.emm.pcm.productmanager.QuatoAssignBillEntryInfo;
import com.kingdee.eas.industry.emm.pcm.productmanager.QuatoAssignBillInfo;
import com.kingdee.eas.industry.emm.pcm.productmanager.app.AbstractQuatoAdjustBillControllerBean;
import com.kingdee.eas.industry.emm.pcm.util.PCMBOMTreeUtil;
import com.kingdee.eas.mm.basedata.BomEntryCollection;
import com.kingdee.eas.mm.basedata.BomEntryFactory;
import com.kingdee.eas.mm.basedata.BomEntryInfo;
import com.kingdee.eas.mm.basedata.IBomEntry;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.mm.project.ProjectFactory;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class QuatoAdjustBillControllerBean
extends AbstractQuatoAdjustBillControllerBean {
    private String RESURL = "com.kingdee.eas.industry.emm.lcm.LcmResource";
    private String RESURLTWO = "com.kingdee.eas.industry.emm.lcm.LcmResourceTwo";
    private String GSNBJSJ = EASResource.getString((String)this.RESURLTWO, (String)"GSNBJSJ");
    private String FGSNBJSJ = EASResource.getString((String)this.RESURLTWO, (String)"FGSNBJSJ");
    private String WLZGJ = EASResource.getString((String)this.RESURLTWO, (String)"WLZGJ");
    private String YFD = EASResource.getString((String)this.RESURLTWO, (String)"YFD");
    private String OutSourcing = EASResource.getString((String)this.RESURL, (String)"OutSourcing");
    private String Field_Oc = EASResource.getString((String)this.RESURL, (String)"Field_Oc");
    private String Otc_Oc = EASResource.getString((String)this.RESURL, (String)"Other");
    private String Oc = EASResource.getString((String)this.RESURL, (String)"Oc");
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.industry.emm.pcm.productmanager.app.QuatoAdjustBillControllerBean");
    public static final String FID = "F_ID";
    public static final String FLEVEL = "F_LEVEL";
    public static final String FBOMID = "F_BOMID";
    public static final String FBOMENTRYID = "F_BOMENTRYID";
    public static final String FPARENTID = "F_PARENTID";
    public static final String FMaterialID = "F_MaterialID";
    public static final String FMaterialNumber = "F_MaterialNumber";
    public static final String FMaterialProp = "F_MaterialProp";
    public static final String FParentMaterialID = "F_ParentMaterialID";
    public static final String FProductID = "F_ProductID";
    public static final String FProductNumber = "F_ProductNumber";
    public static final String FProjectID = "F_ProjectID";
    public static final String FTrackID = "F_TrackID";
    public static final String FTrackNumber = "F_TrackNumber";
    public static final String FSTrackID = "F_STrackID";
    public static final String FSTrackNumber = "F_STrackNumber";
    public static final String FETrackID = "F_ETrackID";
    public static final String FETrackNumber = "F_ETrackNumber";
    public static final String FParentConsumeFixQTY = "F_ParentConsumeFixQTY";
    public static final String FConsumeFixQTY = "F_ConsumeFixQTY";
    public static final String FConsumeQty = "F_ConsumeQty";
    public static final String FTREE_LONG_NUMBER = "TREE_LONG_NUMBER";
    public static final String FISLEAF = "F_ISLEAF";
    private Set idSet = new HashSet();
    protected Set bomids = new HashSet();
    private Set material = new HashSet();
    private static final String MATERIALSOU = "4ueEzZGDSYuVfAD/hLHijsznrtQ=";
    private IBomEntry ibe;

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        QuatoAdjustBillInfo bill = (QuatoAdjustBillInfo)model;
        if (bill.getCU() == null) {
            bill.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        }
        this.checkNumber(ctx, (IObjectValue)bill);
        return super._addnew(ctx, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        QuatoAdjustBillInfo eti = (QuatoAdjustBillInfo)model;
        this.check(ctx, eti);
        if (eti.getBillStatus() != BillBaseStatusEnum.TEMPORARILYSAVED && eti.getBillStatus() != BillBaseStatusEnum.SUBMITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.productmanager.EMMPCPcmProductmanagerResource", (String)"0EMMPCProductmanager-0000", (Locale)ctx.getLocale())));
        }
        eti.setBillStatus(BillBaseStatusEnum.SUBMITED);
        return super._submit(ctx, model);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        QuatoAdjustBillInfo eti = (QuatoAdjustBillInfo)model;
        if (eti.getCU() == null) {
            eti.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        }
        this.checkNumber(ctx, (IObjectValue)eti);
        this.check(ctx, eti);
        if (eti.getBillStatus() != BillBaseStatusEnum.TEMPORARILYSAVED && eti.getBillStatus() != BillBaseStatusEnum.ADD) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.productmanager.EMMPCPcmProductmanagerResource", (String)"0EMMPCProductmanager-0001", (Locale)ctx.getLocale())));
        }
        eti.setBillStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        return super._save(ctx, model);
    }

    protected void checkNumber(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        QuatoAdjustBillInfo info = (QuatoAdjustBillInfo)model;
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        RuleStatus ruleStatus = iCodingRuleManager.getRuleStatus(model, info.getAdminOrgUnit().getId().toString());
        if (ruleStatus.isExist() && (StringUtils.isEmpty((String)info.getNumber()) || ruleStatus.isAddNoBreak() || !ruleStatus.isModifiable() && this.isNumberUsed(ctx, info))) {
            this.setNewNumber(ctx, info, iCodingRuleManager, null);
        } else {
            ObjectUuidPK pk = new ObjectUuidPK(model.getBOSUuid("id"));
            super._checkNumberBlank(ctx, (IObjectPK)pk, model);
            super._checkNumberDup(ctx, (IObjectPK)pk, model);
        }
    }

    protected void setNewNumber(Context ctx, CoreBillBaseInfo info, ICodingRuleManager iCodingRuleManager, String customString) throws BOSException, EASBizException {
        String number = iCodingRuleManager.getNumber((IObjectValue)info, ((QuatoAdjustBillInfo)info).getAdminOrgUnit().getId().toString(), customString);
        info.setNumber(number);
        if (this.isNumberUsed(ctx, info)) {
            this.setNewNumber(ctx, info, iCodingRuleManager, customString);
        }
    }

    protected boolean isNumberUsed(Context ctx, CoreBillBaseInfo info) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)info.getNumber(), CompareType.EQUALS));
        if (info.getCU() != null) {
            filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)info.getCU().getId().toString(), CompareType.EQUALS));
        }
        if (info.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
        }
        boolean exist = super._exists(ctx, filter);
        return exist;
    }

    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        QuatoAdjustBillInfo info = (QuatoAdjustBillInfo)model;
        if (info == null) {
            info = (QuatoAdjustBillInfo)this._getValue(ctx, pk);
        }
        if (info.getBillStatus() != BillBaseStatusEnum.SUBMITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.productmanager.EMMPCPcmProductmanagerResource", (String)"0EMMPCProductmanager-0002", (Locale)ctx.getLocale())));
        }
        info.setBillStatus(BillBaseStatusEnum.AUDITED);
        info.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
        info.setAuditDate(new Date(System.currentTimeMillis()));
        super.update(ctx, pk, (CoreBaseInfo)info);
    }

    protected void _unpassAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        QuatoAdjustBillInfo info = (QuatoAdjustBillInfo)model;
        if (info == null) {
            info = (QuatoAdjustBillInfo)this._getValue(ctx, pk);
        }
        if (info.getBillStatus() != BillBaseStatusEnum.AUDITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.productmanager.EMMPCPcmProductmanagerResource", (String)"0EMMPCProductmanager-0003", (Locale)ctx.getLocale())));
        }
        info.setBillStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        info.setAuditor(null);
        info.setAuditDate(null);
        this._checkIsHaveDestBills(ctx, (CoreBaseInfo)info);
        super.update(ctx, pk, (CoreBaseInfo)info);
    }

    protected void _checkIsHaveDestBills(Context ctx, CoreBaseInfo billInfo) throws EASBizException, BOSException {
        String billIdString;
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        if (iBTPManager.ifHaveDestBills(billIdString = billInfo.getId().toString())) {
            throw new SCMBillException(SCMBillException.HASDESTBILL_CANNOTUNAUDIT, new Object[]{billInfo.getString("number")});
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        QuatoAdjustBillInfo info = (QuatoAdjustBillInfo)this.getValue(ctx, pk);
        if (info.getBillStatus() == BillBaseStatusEnum.AUDITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.productmanager.EMMPCPcmProductmanagerResource", (String)"0EMMPCProductmanager-0004", (Locale)ctx.getLocale())));
        }
        super._delete(ctx, pk);
    }

    protected void check(Context ctx, QuatoAdjustBillInfo eti) throws EASBizException, BOSException {
        if (eti.getCU() == null) {
            eti.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)eti.getNumber(), CompareType.EQUALS));
        if (eti.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)eti.getId().toString(), CompareType.NOTEQUALS));
        }
        if (this._exists(ctx, filter)) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.productmanager.EMMPCPcmProductmanagerResource", (String)"0EMMPCProductmanager-0005", (Locale)ctx.getLocale())));
        }
        StringBuffer errStr = new StringBuffer();
        if (eti.getProject() == null) {
            errStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.productmanager.EMMPCPcmProductmanagerResource", (String)"0EMMPCProductmanager-0006", (Locale)ctx.getLocale()));
        }
        if (eti.getTrackNumber() == null) {
            errStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.productmanager.EMMPCPcmProductmanagerResource", (String)"0EMMPCProductmanager-0007", (Locale)ctx.getLocale()));
        }
        if (eti.getAdminOrgUnit() == null) {
            errStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.productmanager.EMMPCPcmProductmanagerResource", (String)"0EMMPCProductmanager-0008", (Locale)ctx.getLocale()));
        }
        if (errStr.length() > 0) {
            throw new EASBizException(new NumericExceptionSubItem("", errStr.toString()));
        }
        if (eti.getBizDate() == null) {
            eti.setBizDate(new Date());
        }
    }

    @Override
    protected Map _reAssignQuato(Context ctx, Map paramMap) throws BOSException {
        QuatoAdjustBillInfo billInfo = (QuatoAdjustBillInfo)paramMap.get("billInfo");
        QuatoAssignBillInfo si = new QuatoAssignBillInfo();
        try {
            ProjectInfo project = (ProjectInfo)paramMap.get("project");
            TrackNumberInfo trackNumber = (TrackNumberInfo)paramMap.get("trackNumber");
            StringBuffer sql = new StringBuffer();
            sql.append(" select m.fid as materialid from CT_ZJB_PdmEasCarnoEqualSet pce");
            sql.append(" inner join t_bd_material m on pce.CFPMno=m.fnumber");
            sql.append(" inner join t_mm_project p on p.fid=pce.CFEasCarnoID");
            sql.append(" inner join t_mm_tracknumber stn on stn.fid=pce.cfeasbegintracknum");
            sql.append(" inner join t_mm_tracknumber etn on etn.fid=pce.cfeasendtracknumbe");
            sql.append(" where p.fid='" + project.getId().toString() + "'");
            sql.append(" and stn.fnumber<='" + trackNumber.getNumber() + "' and etn.fnumber>='" + trackNumber.getNumber() + "'");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            String topMId = null;
            HashSet<String> materialSet = new HashSet<String>();
            if (!rs.next()) {
                throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.productmanager.EMMPCPcmProductmanagerResource", (String)"0EMMPCProductmanager-0009", (Locale)ctx.getLocale())));
            }
            topMId = rs.getString("materialid");
            materialSet.add(topMId);
            this.material.clear();
            this.idSet.clear();
            this.expand_bom(ctx, materialSet, project.getId().toString(), trackNumber.getNumber(), si);
            this.update_bom(ctx, project.getId().toString(), trackNumber.getNumber(), si);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        HashMap<String, QuatoAdjustBillInfo> re = new HashMap<String, QuatoAdjustBillInfo>();
        re.put("billInfo", billInfo);
        return re;
    }

    protected BomEntryCollection query_bomEntry(Set materialSet, String project, String trackNumber) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent.material.id", (Object)materialSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("parent.basestatus", (Object)4));
        filter.getFilterItems().add(new FilterItemInfo("parent.project.id", (Object)project, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("beginCarno.number", (Object)trackNumber, CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("endCarno.number", (Object)trackNumber, CompareType.GREATER_EQUALS));
        evi.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("parent.id"));
        sic.add(new SelectorItemInfo("material.id"));
        evi.setSelector(sic);
        return this.ibe.getBomEntryCollection(evi);
    }

    protected void expand_bom(Context ctx, Set materialSet, String project, String trackNumber, QuatoAssignBillInfo billInfo) throws BOSException, EASBizException {
        this.idSet.clear();
        this.bomids.clear();
        this.ibe = BomEntryFactory.getLocalInstance((Context)ctx);
        BomEntryCollection entrys = this.query_bomEntry(materialSet, project, trackNumber);
        int level = 1;
        while (entrys.size() > 0) {
            if (level > 30) {
                throw new EASBizException(new NumericExceptionSubItem("id_error", ResourceBase.getString((String)"com.kingdee.eas.industry.emm.pcm.productmanager.EMMPCPcmProductmanagerResource", (String)"ZKBOMCGJC", (Locale)ctx.getLocale(), (Object[])new Object[]{level})));
            }
            ++level;
            materialSet.clear();
            for (int i = 0; i < entrys.size(); ++i) {
                BomEntryInfo be = entrys.get(i);
                String mid = be.getMaterial().getId().toString();
                if (be.getMaterialProp() != MaterialAttributeEnum.PHANTOMPART) {
                    this.idSet.add(mid);
                }
                materialSet.add(mid);
                this.bomids.add(be.getParent().getId().toString());
            }
            entrys = this.query_bomEntry(materialSet, project, trackNumber);
        }
    }

    protected void update_bom(final Context ctx, final String project, final String trackNumber, final QuatoAssignBillInfo billInfo) throws BOSException, EASBizException {
        String GSNBJSJ = EASResource.getString((String)this.RESURLTWO, (String)"GSNBJSJ", (Locale)ctx.getLocale());
        String FGSNBJSJ = EASResource.getString((String)this.RESURLTWO, (String)"FGSNBJSJ", (Locale)ctx.getLocale());
        String WLZGJ = EASResource.getString((String)this.RESURLTWO, (String)"WLZGJ", (Locale)ctx.getLocale());
        String YFD = EASResource.getString((String)this.RESURLTWO, (String)"YFD", (Locale)ctx.getLocale());
        String OutSourcing = EASResource.getString((String)this.RESURL, (String)"OutSourcing", (Locale)ctx.getLocale());
        String Field_Oc = EASResource.getString((String)this.RESURL, (String)"Field_Oc", (Locale)ctx.getLocale());
        String Otc_Oc = EASResource.getString((String)this.RESURL, (String)"Other", (Locale)ctx.getLocale());
        String Oc = EASResource.getString((String)this.RESURL, (String)"Oc", (Locale)ctx.getLocale());
        this.idSet.addAll(this.material);
        String eID = SQLUtil.arrayToString((Object[])this.idSet.toArray());
        PCMBOMTreeUtil bomtree = new PCMBOMTreeUtil(){

            @Override
            protected void execute(String treeTemp, Map params) throws Exception {
                QuatoAdjustBillControllerBean.this.add_data(ctx, treeTemp, project, trackNumber, params, billInfo);
            }
        };
        HashMap<String, Boolean> param = new HashMap<String, Boolean>();
        param.put("param_stopVirtual", true);
        ProjectInfo pi = ProjectFactory.getLocalInstance((Context)ctx).getProjectInfo((IObjectPK)new ObjectUuidPK(project));
        param.put("param_project", (Boolean)pi);
        TrackNumberInfo tn = TrackNumberFactory.getLocalInstance((Context)ctx).getTrackNumberInfo("where number = '" + trackNumber + "'");
        param.put("param_track", (Boolean)tn);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add(new SelectorItemInfo("name"));
        evi.getSelector().add(new SelectorItemInfo("number"));
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)this.idSet, CompareType.INCLUDE));
        MaterialCollection mc = MaterialFactory.getLocalInstance((Context)ctx).getMaterialCollection(evi);
        bomtree.run(ctx, mc, param);
    }

    protected void add_data(Context ctx, String treeTemp, String project, String trackNumber, Map params, QuatoAssignBillInfo billInfo) throws EASBizException, Exception {
        StringBuffer selectSql = new StringBuffer();
        selectSql.setLength(0);
        selectSql.append(" delete from " + treeTemp);
        selectSql.append(" where F_MaterialProp not in(10040,10070,10080,10090)");
        selectSql.append("  or FStorageOrgUnitID ='4ueEzZGDSYuVfAD/hLHijsznrtQ='");
        SQLUtils.execute((Context)ctx, (String)selectSql.toString());
        String btreeTable = TempTablePool.getInstance((Context)ctx).createTempTable(this.getExpandBOMSql());
        TempTablePool.getInstance((Context)ctx).createIndex(btreeTable, FProjectID, false, false);
        TempTablePool.getInstance((Context)ctx).createIndex(btreeTable, FMaterialID, false, false);
        String tempPurInTable42 = TempTablePool.getInstance((Context)ctx).createTempTable(this.createTempPurInTable42());
        String tempPurInTable43 = TempTablePool.getInstance((Context)ctx).createTempTable(this.createTempPurInTable43());
        String tempPurInTable44 = TempTablePool.getInstance((Context)ctx).createTempTable(this.createTempPurInTable44());
        String tempPurInTable45 = TempTablePool.getInstance((Context)ctx).createTempTable(this.createTempPurInTable45());
        String tempPurInTable4 = TempTablePool.getInstance((Context)ctx).createTempTable(this.createTempPurInTable4());
        try {
            selectSql.setLength(0);
            selectSql.append(" insert into " + btreeTable);
            selectSql.append(" select ");
            selectSql.append(" ").append(FProjectID);
            selectSql.append(",").append(FTrackID).append(",").append(FMaterialID).append(",").append(FMaterialProp).append(",").append("FStorageOrgUnitID").append(",").append("cfbomflow").append(",sum(").append(FConsumeQty).append(") as ").append(FConsumeQty);
            selectSql.append(" from ").append(treeTemp);
            selectSql.append(" group by ").append(FProjectID).append(",").append(FMaterialID).append(",").append(FTrackID).append(",").append(FMaterialProp).append(",").append("FStorageOrgUnitID").append(",").append("cfbomflow");
            SQLUtils.execute((Context)ctx, (String)selectSql.toString());
            selectSql.setLength(0);
            selectSql.append(" /*dialect*/insert into " + tempPurInTable42);
            selectSql.append(" select fmid,fprice");
            selectSql.append(" from (select tmp.F_MaterialID as fmid,oe.fprice as fprice,");
            selectSql.append(" row_number () over(partition by tmp.F_MaterialID  order by ob.fbizdate desc) as fseq");
            selectSql.append(" from " + btreeTable + " tmp ");
            selectSql.append(" inner join  ");
            selectSql.append("  T_AP_OtherBillEntry oe");
            selectSql.append(" on oe.fmaterialid=tmp.F_MaterialID");
            selectSql.append(" inner join T_AP_OtherBill ob on ob.fid=oe.fparentid");
            selectSql.append(" and ob.fbillstatus=3");
            selectSql.append(" ) where fseq=1");
            DbUtil.execute((Context)ctx, (String)selectSql.toString());
            selectSql.setLength(0);
            selectSql.append(" /*dialect*/insert into " + tempPurInTable43);
            selectSql.append(" select fmid,fprice");
            selectSql.append(" from (select tmp.F_MaterialID as fmid,oe.CFNoTaxPrice as fprice,");
            selectSql.append(" row_number () over(partition by tmp.F_MaterialID  order by ob.fbizdate desc) as fseq");
            selectSql.append(" from " + btreeTable + " tmp ");
            selectSql.append(" inner join  ");
            selectSql.append("  CT_PCM_GongsiIPBE oe");
            selectSql.append(" on oe.CFMaterialID=tmp.F_MaterialID");
            selectSql.append(" inner join CT_PCM_GongsiInnerPriceBill ob on ob.fid=oe.fparentid and ob.CFProjectID=tmp.F_ProjectID");
            selectSql.append(" and ob.CFStatus=4");
            selectSql.append(" ) where fseq=1");
            DbUtil.execute((Context)ctx, (String)selectSql.toString());
            selectSql.setLength(0);
            selectSql.append(" /*dialect*/insert into " + tempPurInTable44);
            selectSql.append(" select fmid,fprice");
            selectSql.append(" from (select tmp.F_MaterialID as fmid,oe.CFNoTaxPrice as fprice,");
            selectSql.append(" row_number () over(partition by tmp.F_MaterialID  order by ob.fbizdate desc) as fseq");
            selectSql.append(" from " + btreeTable + " tmp ");
            selectSql.append(" inner join  ");
            selectSql.append("  CT_PCM_BranchAGPBE oe");
            selectSql.append(" on oe.cfmaterialid=tmp.F_MaterialID");
            selectSql.append(" inner join CT_PCM_BranchAGatherPriceBill ob on ob.fid=oe.fparentid and ob.CFProjectID=tmp.F_ProjectID");
            selectSql.append(" and ob.CFStatus=4");
            selectSql.append(" ) where fseq=1");
            DbUtil.execute((Context)ctx, (String)selectSql.toString());
            selectSql.setLength(0);
            selectSql.append(" /*dialect*/insert into " + tempPurInTable45);
            selectSql.append(" select tmp.F_MaterialID as fmid, ");
            selectSql.append(" mpu.CFUpdatePrice  ");
            selectSql.append(" from " + btreeTable + " tmp ");
            selectSql.append(" inner join CT_PCM_MaterialPriceUpdate mpu ");
            selectSql.append(" on mpu.CFProjectID=tmp.F_ProjectID");
            selectSql.append(" and mpu.CFMaterialID=tmp.F_MaterialID");
            selectSql.append(" ");
            DbUtil.execute((Context)ctx, (String)selectSql.toString());
            selectSql.setLength(0);
            selectSql.append(" /*dialect*/insert into " + tempPurInTable4);
            selectSql.append(" select tmp.F_MaterialID as fmid, ");
            selectSql.append(" nvl(t42.fprice,nvl(t43.fprice,nvl(t44.fprice,t45.fprice))), ");
            selectSql.append(" case when t42.fprice is not null then 'YFD' when t43.fprice is not null then 'GSNBJSJ'  when t44.fprice is not null then 'FGSNBJSJ' when t45.fprice is not null then 'WLZGJ' end as FPriceSource ");
            selectSql.append(" from " + btreeTable + " tmp ");
            selectSql.append(" left join " + tempPurInTable42 + " t42 ");
            selectSql.append(" on  tmp.F_MaterialID=t42.fmaterialid");
            selectSql.append(" left join " + tempPurInTable43 + " t43");
            selectSql.append(" on  tmp.F_MaterialID=t43.fmaterialid");
            selectSql.append(" left join " + tempPurInTable44 + " t44");
            selectSql.append(" on tmp.F_MaterialID=t44.fmaterialid");
            selectSql.append(" left join " + tempPurInTable45 + " t45");
            selectSql.append(" on tmp.F_MaterialID=t45.fmaterialid");
            DbUtil.execute((Context)ctx, (String)selectSql.toString());
            selectSql.setLength(0);
            selectSql.append("select  tmp.FStorageOrgUnitID as fstorageId,st.fname_l2 as fstorageName").append(",sum(round(tmp.").append(FConsumeQty).append(",2)*tmp4.fPrice) as ftrackCost");
            selectSql.append(" from " + btreeTable + " tmp");
            selectSql.append(" inner join t_org_storage st on st.fid=tmp.FStorageOrgUnitID");
            selectSql.append(" left join " + tempPurInTable4 + " tmp4  on tmp." + FMaterialID + "=tmp4.fmaterialId");
            selectSql.append(" group by tmp.FStorageOrgUnitID,st.fname_l2");
            IRowSet rst = SQLUtils.executeQuery((Context)ctx, (String)selectSql.toString());
            BigDecimal trackCost = BigDecimal.ZERO;
            billInfo.getEntrys().clear();
            while (rst.next()) {
                QuatoAssignBillEntryInfo qbi = new QuatoAssignBillEntryInfo();
                StorageOrgUnitInfo sti = new StorageOrgUnitInfo();
                sti.setId(BOSUuid.read((String)rst.getString("fstorageId")));
                sti.setName(rst.getString("fstorageName"));
                qbi.setStorageOrgUnit(sti);
                qbi.setTrackCost(rst.getBigDecimal("ftrackCost"));
                qbi.setIsTotalRow(true);
                BigDecimal mtc = rst.getBigDecimal("ftrackCost") == null ? BigDecimal.ZERO : rst.getBigDecimal("ftrackCost");
                trackCost = trackCost.add(mtc);
                billInfo.getEntrys().add(qbi);
            }
            trackCost = trackCost.setScale(4, 2);
            billInfo.setTrackTotalCost(trackCost);
            selectSql.setLength(0);
            selectSql.append(" /*dialect*/select ");
            selectSql.append("").append("tmp.F_MaterialID as FMaterialID").append(",").append("M.fnumber as fmaterialnumber").append(",").append("M.fname_l2 as fmaterialname").append(",").append("M.fmodel as fmodel").append(",").append("M.fbaseunit as funitid").append(",").append("Mu.fname_l2 as funit,");
            selectSql.append("case tmp.F_MaterialProp  \n");
            selectSql.append("when 10040 then 'OutSourcing'\n");
            selectSql.append("when 10070 then 'Field_Oc'\n");
            selectSql.append("when 10080 then 'Otc_Oc'\n");
            selectSql.append("when 10090 then 'Oc'\n");
            selectSql.append(" end\n as FMaterialProp");
            selectSql.append(",").append("tmp.FStorageOrgUnitID as fstorageId").append(",").append("st.fname_l2 as fstorageName").append(",").append("tmp.cfbomflow as cfbomflow").append(",round(tmp.").append(FConsumeQty).append(" ,2)as ").append(FConsumeQty).append(",round(tmp.").append(FConsumeQty).append(",2)*tmp4.fPrice as ftrackCost").append(",tmp4.fPrice as fprice,tmp4.FPricesource as FPricesource");
            selectSql.append(" from ").append(btreeTable).append(" tmp");
            selectSql.append(" inner join t_bd_material M");
            selectSql.append(" on M.fid=tmp.F_MaterialID");
            selectSql.append(" left outer join t_bd_measureunit mu on mu.fid=M.fbaseunit");
            selectSql.append(" left outer join t_org_storage st on st.fid=tmp.FStorageOrgUnitID");
            selectSql.append(" left join " + tempPurInTable4 + " tmp4  on tmp." + FMaterialID + "=tmp4.fmaterialId \n");
            selectSql.append(" order by tmp.FStorageOrgUnitID,M.fnumber");
            selectSql.append("");
            IRowSet rs = SQLUtils.executeQuery((Context)ctx, (String)selectSql.toString());
            while (rs.next()) {
                QuatoAssignBillEntryInfo qbi = new QuatoAssignBillEntryInfo();
                MaterialInfo mi = new MaterialInfo();
                mi.setId(BOSUuid.read((String)rs.getString("FMaterialID")));
                mi.setNumber(rs.getString("fmaterialnumber"));
                mi.setName(rs.getString("fmaterialname"));
                mi.setModel(rs.getString("fmodel"));
                MeasureUnitInfo mui = new MeasureUnitInfo();
                mui.setId(BOSUuid.read((String)rs.getString("funitid")));
                mui.setName(rs.getString("funit"));
                mi.setBaseUnit(mui);
                qbi.setMaterial(mi);
                qbi.setMaterialName(rs.getString("fmaterialname"));
                qbi.setModel(rs.getString("fmodel"));
                qbi.setBaseUnit(rs.getString("funit"));
                qbi.setMaterialSource(rs.getString("FMaterialProp"));
                StorageOrgUnitInfo sti = new StorageOrgUnitInfo();
                sti.setId(BOSUuid.read((String)rs.getString("fstorageId")));
                sti.setName(rs.getString("fstorageName"));
                qbi.setStorageOrgUnit(sti);
                qbi.setTargetQty(rs.getBigDecimal(FConsumeQty));
                qbi.setTrackCost(rs.getBigDecimal("ftrackCost"));
                qbi.setFlow(rs.getString("cfbomflow"));
                qbi.setPrice(rs.getBigDecimal("fprice"));
                qbi.setPriceSource(rs.getString("FPricesource"));
                qbi.setIsTotalRow(false);
                billInfo.getEntrys().add(qbi);
            }
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
        finally {
            TempTablePool.getInstance((Context)ctx).releaseTable(tempPurInTable4);
            TempTablePool.getInstance((Context)ctx).releaseTable(tempPurInTable42);
            TempTablePool.getInstance((Context)ctx).releaseTable(tempPurInTable43);
            TempTablePool.getInstance((Context)ctx).releaseTable(tempPurInTable44);
            TempTablePool.getInstance((Context)ctx).releaseTable(tempPurInTable45);
            TempTablePool.getInstance((Context)ctx).releaseTable(btreeTable);
        }
    }

    protected String getExpandBOMSql() throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table ExpandBOMTable(\r\n");
        sql.append(FProjectID).append(" VARCHAR(44) Not Null,\r\n");
        sql.append(FTrackID).append(" VARCHAR(44) Not Null,\r\n");
        sql.append(FMaterialID).append(" VARCHAR(44) Not Null,\r\n");
        sql.append(FMaterialProp).append(" INT Default ").append(10060).append(" Not Null,\r\n");
        sql.append("FStorageOrgUnitID VARCHAR(44) Not Null,\r\n");
        sql.append("CFBomFlow VARCHAR(100) , \r\n");
        sql.append(FConsumeQty).append(" Numeric(21,8) Default 0 Not Null");
        sql.append(")");
        return sql.toString();
    }

    private String createTempPurInTable42() {
        StringBuffer sql = new StringBuffer();
        sql.append("create table T_PCM_TempPurIn42(");
        sql.append("fMaterialId varchar(44),");
        sql.append("fPrice numeric(30,2)");
        sql.append(")");
        return sql.toString();
    }

    private String createTempPurInTable43() {
        StringBuffer sql = new StringBuffer();
        sql.append("create table T_PCM_TempPurIn43(");
        sql.append("fMaterialId varchar(44),");
        sql.append("fPrice numeric(30,2)");
        sql.append(")");
        return sql.toString();
    }

    private String createTempPurInTable44() {
        StringBuffer sql = new StringBuffer();
        sql.append("create table T_PCM_TempPurIn44(");
        sql.append("fMaterialId varchar(44),");
        sql.append("fPrice numeric(30,2)");
        sql.append(")");
        return sql.toString();
    }

    private String createTempPurInTable45() {
        StringBuffer sql = new StringBuffer();
        sql.append("create table T_PCM_TempPurIn45(");
        sql.append("fMaterialId varchar(44),");
        sql.append("fPrice numeric(30,2)");
        sql.append(")");
        return sql.toString();
    }

    private String createTempPurInTable4() {
        StringBuffer sql = new StringBuffer();
        sql.append("create table T_PCM_TempPurIn4(");
        sql.append("fMaterialId varchar(44),");
        sql.append("fPrice numeric(30,2),");
        sql.append("FPriceSource varchar(30)");
        sql.append(")");
        return sql.toString();
    }
}

