/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.pcm.spareparts.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.syncdatabase.SQLFacadeFactory;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillEntryBaseInfo;
import com.kingdee.eas.industry.emm.pcm.basedata.ClassificationCodeFactory;
import com.kingdee.eas.industry.emm.pcm.basedata.ClassificationCodeInfo;
import com.kingdee.eas.industry.emm.pcm.basedata.ProjectTypesFactory;
import com.kingdee.eas.industry.emm.pcm.basedata.ProjectTypesInfo;
import com.kingdee.eas.industry.emm.pcm.basedata.PurMaterialPriceStorageCollection;
import com.kingdee.eas.industry.emm.pcm.basedata.PurMaterialPriceStorageFactory;
import com.kingdee.eas.industry.emm.pcm.basedata.RateStorageOfManufacturingUnitsCollection;
import com.kingdee.eas.industry.emm.pcm.basedata.RateStorageOfManufacturingUnitsFactory;
import com.kingdee.eas.industry.emm.pcm.basedata.SparePartPriceCollection;
import com.kingdee.eas.industry.emm.pcm.basedata.SparePartPriceFactory;
import com.kingdee.eas.industry.emm.pcm.basedata.VehicleTypeInfo;
import com.kingdee.eas.industry.emm.pcm.costmanagement.SparePartsExeEstimateEntryCollection;
import com.kingdee.eas.industry.emm.pcm.costmanagement.SparePartsExeEstimateEntryFactory;
import com.kingdee.eas.industry.emm.pcm.costmanagement.SparePartsExeEstimateEntryInfo;
import com.kingdee.eas.industry.emm.pcm.costmanagement.app.SparePartsHelper;
import com.kingdee.eas.industry.emm.pcm.spareparts.SparePartJZPriceCollection;
import com.kingdee.eas.industry.emm.pcm.spareparts.SparePartJZPriceFactory;
import com.kingdee.eas.industry.emm.pcm.spareparts.SparePartsCalculationCostEntryCollection;
import com.kingdee.eas.industry.emm.pcm.spareparts.SparePartsCalculationEntryCollection;
import com.kingdee.eas.industry.emm.pcm.spareparts.SparePartsCalculationEntryInfo;
import com.kingdee.eas.industry.emm.pcm.spareparts.SparePartsCalculationInfo;
import com.kingdee.eas.industry.emm.pcm.spareparts.SparePartsCalculationMaterialEntryCollection;
import com.kingdee.eas.industry.emm.pcm.spareparts.app.AbstractSparePartsCalculationControllerBean;
import com.kingdee.eas.industry.emm.pcm.util.PcmTreeBillHelper;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class SparePartsCalculationControllerBean
extends AbstractSparePartsCalculationControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.industry.emm.pcm.spareparts.app.SparePartsCalculationControllerBean");

    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        SparePartsCalculationInfo info = (SparePartsCalculationInfo)model;
        if (info == null) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.spareparts.EMMPCPcmSparepartsResource", (String)"0EMMPCPcmSpareparts-0005", (Locale)ctx.getLocale())));
        }
        if (info.getBaseStatus() != BillBaseStatusEnum.SUBMITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.spareparts.EMMPCPcmSparepartsResource", (String)"0EMMPCPcmSpareparts-0006", (Locale)ctx.getLocale())));
        }
        info.setBaseStatus(BillBaseStatusEnum.AUDITED);
        info.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
        info.setAuditDate(new Date());
        super.update(ctx, pk, (CoreBaseInfo)info);
    }

    protected void _unpassAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        SparePartsCalculationInfo info = (SparePartsCalculationInfo)model;
        if (info == null) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.spareparts.EMMPCPcmSparepartsResource", (String)"0EMMPCPcmSpareparts-0005", (Locale)ctx.getLocale())));
        }
        if (info.getBaseStatus() != BillBaseStatusEnum.AUDITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.spareparts.EMMPCPcmSparepartsResource", (String)"0EMMPCPcmSpareparts-0007", (Locale)ctx.getLocale())));
        }
        info.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        info.setAuditor(null);
        info.setAuditDate(null);
        this._checkIsHaveDestBills(ctx, (CoreBaseInfo)info);
        super.update(ctx, pk, (CoreBaseInfo)info);
    }

    protected void _checkIsHaveDestBills(Context ctx, CoreBaseInfo billInfo) throws EASBizException, BOSException {
        String billIdString;
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        if (iBTPManager.ifHaveDestBills(billIdString = billInfo.getId().toString())) {
            throw new SCMBillException(SCMBillException.HASDESTBILL_CANNOTUNAUDIT, new Object[]{billInfo.getString("number")});
        }
    }

    protected void check(Context ctx, SparePartsCalculationInfo eti) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)eti.getNumber(), CompareType.EQUALS));
        if (eti.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)eti.getId().toString(), CompareType.NOTEQUALS));
        }
        if (this._exists(ctx, filter)) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.spareparts.EMMPCPcmSparepartsResource", (String)"0EMMPCPcmSpareparts-0008", (Locale)ctx.getLocale())));
        }
    }

    @Override
    protected String _showGYBOM(Context ctx, Map map) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        String projectid = map.get("project") == null ? "" : map.get("project").toString();
        String trackNo = map.get("trackNumber") == null ? "" : map.get("trackNumber").toString();
        String topMaterialNumber = map.get("material") == null ? "" : map.get("material").toString();
        String tempTableBomName = "";
        try {
            tempTableBomName = TempTablePool.getInstance((Context)ctx).createTempTable(this.createTempTable1());
            TempTablePool.getInstance((Context)ctx).createIndex(tempTableBomName, "fmaterialnumber", false, false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        sql.setLength(0);
        sql.append("insert into " + tempTableBomName + "\n");
        sql.append(" select 0,pb.fid as fbomid ,null as fparentbomid ,pb.cfmakeflow,pb.CFDrawBillOrgID,pb.CFParentNo,pb.CFPortNo,pb.CFWeight,pb.CFRation as fflexQty\n");
        sql.append(" ,null from CT_ZJB_ProcessBomBill pb\n");
        sql.append(" inner join t_bd_material m on m.fnumber=pb.CFParentNo\n");
        sql.append("  inner join t_mm_tracknumber btrack on btrack.fid=pb.CFBeginCarnoID\n");
        sql.append("  inner join t_mm_tracknumber etrack on etrack.fid=pb.CFEndCarnoID\n");
        sql.append(" where pb.cfprojectid='" + projectid + "'\n");
        sql.append(" and pb.cfprojectid='" + projectid + "'\n");
        sql.append(" and btrack.fnumber<='" + trackNo + "' and etrack.fnumber>='" + trackNo + "'\n");
        sql.append(" and pb.CFRation is not null and pb.CFRation>0\n");
        sql.append(" and not exists (select 1 from CT_ZJB_ProcessBomBill pbb where pbb.cfprojectid=pb.cfprojectid and pbb.CFBatch=pb.cfbatch and pbb.cfportno in (" + topMaterialNumber + ") and pb.cfportno in (" + topMaterialNumber + ")  )\n");
        sql.append("  and exists (select 1 from CT_ZJB_ProcessBomBill pbs where  pbs.cfprojectid=pb.cfprojectid and pbs.CFBatch=pb.cfbatch and pbs.cfparentno in (" + topMaterialNumber + ") and pb.cfparentno in (" + topMaterialNumber + ") )\n");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        for (int j = 1; j < 99; ++j) {
            sql.setLength(0);
            sql.append("/*dialect*/insert into " + tempTableBomName);
            sql.append(" select " + j + " ,pbb.fid as fbomid,tmp.fbomid as fparentbomid,\n");
            sql.append(" pbb.cfmakeflow,pbb.CFDrawBillOrgID,\n");
            sql.append(" tmp.fmaterialnumber,pbb.CFPortNo,pbb.CFWeight,\n");
            sql.append(" tmp.fflexQty*pbb.CFRation\n");
            sql.append(" ,null from " + tempTableBomName + " tmp\n");
            sql.append(" inner join CT_ZJB_ProcessBomBill pbb\n");
            sql.append(" on pbb.cfprojectid='" + projectid + "'\n");
            sql.append(" and pbb.cfparentno=tmp.fmaterialnumber\n");
            sql.append("  inner join t_mm_tracknumber btrack on btrack.fid=pbb.CFBeginCarnoID\n");
            sql.append("  inner join t_mm_tracknumber etrack on etrack.fid=pbb.CFEndCarnoID\n");
            sql.append(" where tmp.fsign=" + (j - 1) + " and pbb.CFRation is not null and pbb.CFRation>0\n");
            sql.append(" and pbb.CFState=4\n");
            sql.append(" and btrack.fnumber<='" + trackNo + "' and etrack.fnumber>='" + trackNo + "'\n");
            int t = SQLUtils.execute((Context)ctx, (String)sql.toString());
            if (t == 0) break;
        }
        sql.setLength(0);
        sql.append("/*dialect*/update " + tempTableBomName + " t set fsparePartsPrice=( ");
        sql.append(" select CFCOSTPRICE from (select c.cfmaterialid,CFCOSTPRICE,");
        sql.append(" (row_number() over(partition by c.cfmaterialid order by c.Flastupdatetime desc)) rn from CT_PCM_SparePartPrice c) C");
        sql.append("  inner join t_bd_material m on C.cfmaterialid=m.fid");
        sql.append(" where rn = 1 and m.fnumber = t.fmaterialnumber) ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        return tempTableBomName;
    }

    private BigDecimal getNo(BigDecimal bb) {
        return bb == null ? BigDecimal.ZERO : bb;
    }

    private String createTempTable1() {
        StringBuffer sql = new StringBuffer();
        sql.append("create table T_pcm_tempSonCompanyRpt(");
        sql.append("fsign numeric(20),");
        sql.append("fbomid varchar(44),");
        sql.append("fparentbomid varchar(44),");
        sql.append("fgyflow varchar(100),");
        sql.append("fdrawBillOrg varchar(44),");
        sql.append("fparentmterialNo varchar(100),");
        sql.append("fmaterialnumber varchar(100),");
        sql.append("CFWeight numeric(20,8),");
        sql.append("fflexQty numeric(30,8),");
        sql.append("fsparePartsPrice numeric(30,8)");
        sql.append(")");
        return sql.toString();
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        SparePartsCalculationInfo eti = (SparePartsCalculationInfo)model;
        this.checkHead(ctx, eti);
        this.check(ctx, eti);
        this.checkEntry(ctx, eti);
        this.updateCalculation(ctx, eti);
        SparePartsHelper.insertTotalRowByClassCode(model, ctx);
        SparePartsHelper.sortMaterialEntryColl((IObjectCollection)eti.getEntrys());
        if (eti.getBaseStatus() != BillBaseStatusEnum.TEMPORARILYSAVED && eti.getBaseStatus() != BillBaseStatusEnum.SUBMITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.spareparts.EMMPCPcmSparepartsResource", (String)"0EMMPCPcmSpareparts-0009", (Locale)ctx.getLocale())));
        }
        eti.setBaseStatus(BillBaseStatusEnum.SUBMITED);
        return super._submit(ctx, model);
    }

    private void updateCalculation(Context ctx, SparePartsCalculationInfo eti) throws EASBizException, BOSException {
        ProjectInfo projectInfo = eti.getProject();
        HashSet<String> codeSet = new HashSet<String>();
        for (int i = 0; i < eti.getEntrys().size(); ++i) {
            SparePartsCalculationEntryInfo entryInfo = eti.getEntrys().get(i);
            if (entryInfo.getIdCode() == null) continue;
            codeSet.add(entryInfo.getIdCode());
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add(new SelectorItemInfo("parent.number"));
        evi.getSelector().add(new SelectorItemInfo("idCode"));
        evi.getSelector().add(new SelectorItemInfo("exeProjectQty"));
        evi.getSelector().add(new SelectorItemInfo("execEstimatePrice"));
        evi.getSelector().add(new SelectorItemInfo("execProjectCost"));
        evi.getSelector().add(new SelectorItemInfo("projectBidEstQty"));
        evi.getSelector().add(new SelectorItemInfo("bidEstimatePrice"));
        evi.getSelector().add(new SelectorItemInfo("projectCost"));
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("parent.project.number", (Object)projectInfo.getNumber(), CompareType.EQUALS));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("idCode", codeSet, CompareType.INCLUDE));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("parent.baseStatus", (Object)4, CompareType.EQUALS));
        SparePartsExeEstimateEntryCollection collection = SparePartsExeEstimateEntryFactory.getLocalInstance(ctx).getSparePartsExeEstimateEntryCollection(evi);
        if (collection.size() > 0) {
            String fnumber = collection.get(0).getParent().getNumber();
            for (int i = 0; i < collection.size(); ++i) {
                if (fnumber.equals(collection.get(i).getParent().getNumber())) continue;
                throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.spareparts.EMMPCPcmSparepartsResource", (String)"0EMMPCPcmSpareparts-0010", (Locale)ctx.getLocale())));
            }
        }
        block2: for (int i = 0; i < eti.getEntrys().size(); ++i) {
            SparePartsCalculationEntryInfo entryInfo = eti.getEntrys().get(i);
            if (entryInfo.getIdCode() == null || entryInfo.getIdCode().equals("")) continue;
            for (int j = 0; j < collection.size(); ++j) {
                SparePartsExeEstimateEntryInfo billEntryInfo = collection.get(j);
                if (!entryInfo.getIdCode().equals(billEntryInfo.getIdCode())) continue;
                entryInfo.setProjectBidEstQty(billEntryInfo.getProjectBidEstQty());
                entryInfo.setBidEstimatePrice(billEntryInfo.getBidEstimatePrice());
                entryInfo.setProjectCost(billEntryInfo.getProjectCost());
                entryInfo.setExecEstimatePrice(billEntryInfo.getExecEstimatePrice());
                entryInfo.setExeProjectQty(billEntryInfo.getExeProjectQty());
                entryInfo.setExecProjectCost(billEntryInfo.getExecProjectCost());
                continue block2;
            }
        }
    }

    private void checkHead(Context ctx, SparePartsCalculationInfo info) throws EASBizException {
        if (info.getNumber() == null) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.spareparts.EMMPCPcmSparepartsResource", (String)"0EMMPCPcmSpareparts-0011", (Locale)ctx.getLocale())));
        }
        if (info.getProject() == null) {
            throw new EASBizException(new NumericExceptionSubItem("", info.getNumber() + EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.spareparts.EMMPCPcmSparepartsResource", (String)"0EMMPCPcmSpareparts-0012", (Locale)ctx.getLocale())));
        }
        if (info.getProjectTypes() == null) {
            throw new EASBizException(new NumericExceptionSubItem("", info.getNumber() + EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.spareparts.EMMPCPcmSparepartsResource", (String)"0EMMPCPcmSpareparts-0013", (Locale)ctx.getLocale())));
        }
        if (info.getVehicleType() == null) {
            throw new EASBizException(new NumericExceptionSubItem("", info.getNumber() + EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.spareparts.EMMPCPcmSparepartsResource", (String)"0EMMPCPcmSpareparts-0014", (Locale)ctx.getLocale())));
        }
        if (info.getAdminOrgUnit() == null) {
            throw new EASBizException(new NumericExceptionSubItem("", info.getNumber() + EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.spareparts.EMMPCPcmSparepartsResource", (String)"0EMMPCPcmSpareparts-0015", (Locale)ctx.getLocale())));
        }
        if (info.getBizDate() == null || info.get("bizDate").equals("")) {
            throw new EASBizException(new NumericExceptionSubItem("", info.getNumber() + EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.spareparts.EMMPCPcmSparepartsResource", (String)"0EMMPCPcmSpareparts-0016", (Locale)ctx.getLocale())));
        }
    }

    private void checkEntry(Context ctx, SparePartsCalculationInfo info) throws EASBizException {
        CoreBillEntryBaseInfo entryInfo;
        StringBuffer tmpStr;
        BigDecimal latestPurPrice;
        PurMaterialPriceStorageCollection pmpCollection;
        SorterItemInfo itemInfo;
        EntityViewInfo evi;
        int i;
        SparePartsCalculationEntryCollection entryCollection = info.getEntrys();
        SparePartsCalculationMaterialEntryCollection materialEntryCollection = info.getMaterialEntrys();
        SparePartsCalculationCostEntryCollection costCollection = info.getCostEntrys();
        for (i = 0; i < entryCollection.size(); ++i) {
            BigDecimal riskCoefficient;
            SparePartsCalculationEntryInfo entryInfo2 = entryCollection.get(i);
            if (entryInfo2.isIsTotalRow()) continue;
            MaterialInfo materialInfo = entryInfo2.getMaterial();
            StringBuffer tmpStr2 = new StringBuffer();
            if (entryInfo2.getMaterialName() == null) {
                tmpStr2.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.spareparts.EMMPCPcmSparepartsResource", (String)"0EMMPCPcmSpareparts-0017", (Locale)ctx.getLocale()));
            }
            if (entryInfo2.getMeasureUnit() == null) {
                tmpStr2.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.spareparts.EMMPCPcmSparepartsResource", (String)"0EMMPCPcmSpareparts-0018", (Locale)ctx.getLocale()));
            }
            if (entryInfo2.getClassIfiCationCode() != null) {
                try {
                    ProjectTypesInfo projectTypesInfo = ProjectTypesFactory.getLocalInstance(ctx).getProjectTypesInfo((IObjectPK)new ObjectUuidPK(info.getProjectTypes().getId()));
                    ClassificationCodeInfo codeInfo = ClassificationCodeFactory.getLocalInstance(ctx).getClassificationCodeInfo((IObjectPK)new ObjectUuidPK(entryInfo2.getClassIfiCationCode().getId()));
                    if (!projectTypesInfo.getId().toString().equals(codeInfo.getProjectTypes().getId().toString())) {
                        tmpStr2.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.spareparts.EMMPCPcmSparepartsResource", (String)"0EMMPCPcmSpareparts-0019", (Locale)ctx.getLocale()));
                    }
                    entryInfo2.setClassName(codeInfo.getName());
                    entryInfo2.setClassAttr(codeInfo.getAttribute());
                }
                catch (BOSException e1) {
                    e1.printStackTrace();
                }
            }
            evi = new EntityViewInfo();
            if (materialInfo != null) {
                try {
                    materialInfo = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(entryInfo2.getMaterial().getId()));
                }
                catch (BOSException e2) {
                    e2.printStackTrace();
                }
                entryInfo2.setMaterialName(materialInfo.getName());
                entryInfo2.setModel(materialInfo.getModel());
                entryInfo2.setMeasureUnit(materialInfo.getBaseUnit());
                evi.setSelector(new SelectorItemCollection());
                evi.getSelector().add(new SelectorItemInfo("latestPurPrice"));
                evi.getSelector().add(new SelectorItemInfo("maxPurPrice"));
                evi.setFilter(new FilterInfo());
                evi.getFilter().getFilterItems().add(new FilterItemInfo("materialNumber.number", (Object)materialInfo.getNumber(), CompareType.EQUALS));
                evi.getFilter().getFilterItems().add(new FilterItemInfo("status", (Object)2, CompareType.EQUALS));
                evi.setSorter(new SorterItemCollection());
                itemInfo = new SorterItemInfo("updateTime");
                itemInfo.setSortType(SortType.DESCEND);
                evi.getSorter().add(itemInfo);
                pmpCollection = null;
                try {
                    pmpCollection = PurMaterialPriceStorageFactory.getLocalInstance(ctx).getPurMaterialPriceStorageCollection(evi);
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
                latestPurPrice = null;
                if (pmpCollection.size() != 0) {
                    latestPurPrice = pmpCollection.get(0).getLatestPurPrice();
                }
                entryInfo2.setNewPurPrice(latestPurPrice);
            } else {
                entryInfo2.setNewPurPrice(null);
            }
            ProjectInfo projectInfo = entryInfo2.getReferProName();
            if (materialInfo != null && projectInfo != null) {
                evi = new EntityViewInfo();
                evi.setSelector(new SelectorItemCollection());
                evi.getSelector().add(new SelectorItemInfo("estPrice"));
                evi.getSelector().add(new SelectorItemInfo("actPurPrice"));
                evi.setFilter(new FilterInfo());
                evi.getFilter().getFilterItems().add(new FilterItemInfo("project.number", (Object)projectInfo.getNumber(), CompareType.EQUALS));
                evi.getFilter().getFilterItems().add(new FilterItemInfo("material.number", (Object)materialInfo.getNumber(), CompareType.EQUALS));
                evi.getFilter().getFilterItems().add(new FilterItemInfo("updateDate is not null"));
                evi.setSorter(new SorterItemCollection());
                SorterItemInfo itemInfo1 = new SorterItemInfo("updateDate");
                itemInfo1.setSortType(SortType.DESCEND);
                evi.getSorter().add(itemInfo1);
                SparePartPriceCollection pmpCollection1 = null;
                try {
                    pmpCollection1 = SparePartPriceFactory.getLocalInstance(ctx).getSparePartPriceCollection(evi);
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
                BigDecimal actualPurPrice = null;
                if (pmpCollection1.size() != 0 && !PcmTreeBillHelper.isBigDecimalEmptyAndZero(pmpCollection1.get(0).getActPurPrice())) {
                    actualPurPrice = pmpCollection1.get(0).getActPurPrice();
                }
                entryInfo2.setReferProCarPrice(actualPurPrice);
            } else {
                entryInfo2.setReferProCarPrice(null);
            }
            String idcode = entryInfo2.getIdCode();
            VehicleTypeInfo vehicleTypeInfo = info.getVehicleType();
            if (idcode != null && vehicleTypeInfo != null) {
                evi = new EntityViewInfo();
                evi.setSelector(new SelectorItemCollection());
                evi.getSelector().add(new SelectorItemInfo("qty"));
                evi.getSelector().add(new SelectorItemInfo("price"));
                evi.setFilter(new FilterInfo());
                evi.getFilter().getFilterItems().add(new FilterItemInfo("vehicleType.number", (Object)vehicleTypeInfo.getNumber(), CompareType.EQUALS));
                evi.getFilter().getFilterItems().add(new FilterItemInfo("idCode", (Object)idcode, CompareType.EQUALS));
                evi.getFilter().getFilterItems().add(new FilterItemInfo("IsCheck", (Object)true, CompareType.EQUALS));
                evi.setSorter(new SorterItemCollection());
                SparePartJZPriceCollection pmpCollection2 = null;
                try {
                    pmpCollection2 = SparePartJZPriceFactory.getLocalInstance(ctx).getSparePartJZPriceCollection(evi);
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
                BigDecimal actualPurPrice = null;
                if (pmpCollection2.size() != 0 && !PcmTreeBillHelper.isBigDecimalEmptyAndZero(pmpCollection2.get(0).getPrice())) {
                    actualPurPrice = pmpCollection2.get(0).getPrice();
                }
                entryInfo2.setProjectPriceBase(actualPurPrice);
            }
            BigDecimal execPrice = BigDecimal.ZERO;
            String priceSource = "";
            if (entryInfo2.getConfigPrice() != null && entryInfo2.getConfigPrice() != BigDecimal.ZERO) {
                execPrice = entryInfo2.getConfigPrice();
                priceSource = EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.spareparts.EMMPCPcmSparepartsResource", (String)"0EMMPCPcmSpareparts-0020", (Locale)ctx.getLocale());
            }
            if (entryInfo2.getNewPurPrice() != null && entryInfo2.getNewPurPrice() != BigDecimal.ZERO) {
                execPrice = entryInfo2.getNewPurPrice();
                priceSource = EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.spareparts.EMMPCPcmSparepartsResource", (String)"0EMMPCPcmSpareparts-0021", (Locale)ctx.getLocale());
            }
            if (entryInfo2.getProjectPriceBase() != null && entryInfo2.getProjectPriceBase() != BigDecimal.ZERO) {
                execPrice = entryInfo2.getProjectPriceBase();
                priceSource = EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.spareparts.EMMPCPcmSparepartsResource", (String)"0EMMPCPcmSpareparts-0022", (Locale)ctx.getLocale());
            }
            if (entryInfo2.getReferProCarPrice() != null && entryInfo2.getReferProCarPrice() != BigDecimal.ZERO) {
                execPrice = entryInfo2.getReferProCarPrice();
                priceSource = projectInfo == null ? EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.spareparts.EMMPCPcmSparepartsResource", (String)"0EMMPCPcmSpareparts-0023", (Locale)ctx.getLocale()) + projectInfo + EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.spareparts.EMMPCPcmSparepartsResource", (String)"0EMMPCPcmSpareparts-0024", (Locale)ctx.getLocale()) : EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.spareparts.EMMPCPcmSparepartsResource", (String)"0EMMPCPcmSpareparts-0023", (Locale)ctx.getLocale()) + projectInfo.getNumber() + ":" + projectInfo.getName() + EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.spareparts.EMMPCPcmSparepartsResource", (String)"0EMMPCPcmSpareparts-0024", (Locale)ctx.getLocale());
            }
            if (entryInfo2.getAskPrice() != null && entryInfo2.getAskPrice() != BigDecimal.ZERO) {
                execPrice = entryInfo2.getAskPrice();
                priceSource = EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.spareparts.EMMPCPcmSparepartsResource", (String)"0EMMPCPcmSpareparts-0025", (Locale)ctx.getLocale());
            }
            if (entryInfo2.getEstimatePrice() != null && entryInfo2.getEstimatePrice() != BigDecimal.ZERO) {
                execPrice = entryInfo2.getEstimatePrice();
                priceSource = EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.spareparts.EMMPCPcmSparepartsResource", (String)"0EMMPCPcmSpareparts-0026", (Locale)ctx.getLocale());
            }
            entryInfo2.setCalcProjectPrice(execPrice);
            entryInfo2.setPriceSource(priceSource);
            if (PcmTreeBillHelper.isBigDecimalEmptyAndZero(entryInfo2.getCalcProjectQty())) {
                tmpStr2.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.spareparts.EMMPCPcmSparepartsResource", (String)"0EMMPCPcmSpareparts-0027", (Locale)ctx.getLocale()));
            }
            if (PcmTreeBillHelper.isBigDecimalEmptyAndZero(entryInfo2.getCalcProjectPrice())) {
                tmpStr2.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.spareparts.EMMPCPcmSparepartsResource", (String)"0EMMPCPcmSpareparts-0028", (Locale)ctx.getLocale()));
            }
            BigDecimal bigDecimal = riskCoefficient = entryInfo2.getRiskCoefficient() == null ? BigDecimal.ZERO : entryInfo2.getRiskCoefficient();
            if (tmpStr2.length() > 0) {
                throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.industry.emm.pcm.spareparts.EMMPCPcmSparepartsResource", (String)"BPBJGSFLDJH", (Locale)ctx.getLocale(), (Object[])new Object[]{i + 1}) + "," + tmpStr2.toString()));
            }
            if (!PcmTreeBillHelper.isBigDecimalEmptyAndZero(riskCoefficient)) {
                entryInfo2.setRiskPrice(riskCoefficient.multiply(entryInfo2.getCalcProjectPrice().multiply(entryInfo2.getCalcProjectQty())));
            }
            if (entryInfo2.getRiskPrice() == null) {
                entryInfo2.setRiskPrice(BigDecimal.ZERO);
            }
            entryInfo2.setCalcProjectCost(entryInfo2.getCalcProjectQty().multiply(entryInfo2.getCalcProjectPrice()).add(entryInfo2.getRiskPrice()));
        }
        for (int j = 0; j < materialEntryCollection.size(); ++j) {
            tmpStr = new StringBuffer();
            entryInfo = materialEntryCollection.get(j);
            MaterialInfo materialInfo = entryInfo.getMaterial();
            if (materialInfo == null || materialInfo.getNumber() == null) break;
            evi = new EntityViewInfo();
            if (materialInfo != null) {
                evi.setSelector(new SelectorItemCollection());
                evi.getSelector().add(new SelectorItemInfo("latestPurPrice"));
                evi.setFilter(new FilterInfo());
                evi.getFilter().getFilterItems().add(new FilterItemInfo("materialNumber.number", (Object)materialInfo.getNumber(), CompareType.EQUALS));
                evi.getFilter().getFilterItems().add(new FilterItemInfo("status", (Object)2, CompareType.EQUALS));
                evi.setSorter(new SorterItemCollection());
                itemInfo = new SorterItemInfo("updateTime");
                itemInfo.setSortType(SortType.DESCEND);
                evi.getSorter().add(itemInfo);
                pmpCollection = null;
                try {
                    pmpCollection = PurMaterialPriceStorageFactory.getLocalInstance(ctx).getPurMaterialPriceStorageCollection(evi);
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
                latestPurPrice = null;
                if (pmpCollection.size() != 0) {
                    latestPurPrice = pmpCollection.get(0).getLatestPurPrice();
                }
                entryInfo.setNewPurPrice(latestPurPrice);
            } else {
                entryInfo.setNewPurPrice(null);
            }
            BigDecimal execPrice = BigDecimal.ZERO;
            if (entryInfo.getAskPrice() != null && entryInfo.getAskPrice() != BigDecimal.ZERO) {
                execPrice = entryInfo.getAskPrice();
            }
            if (entryInfo.getNewPurPrice() != null && entryInfo.getNewPurPrice() != BigDecimal.ZERO) {
                execPrice = entryInfo.getNewPurPrice();
            }
            if (entryInfo.getEstimatePrice() != null && entryInfo.getEstimatePrice() != BigDecimal.ZERO) {
                execPrice = entryInfo.getEstimatePrice();
            }
            entryInfo.setPrice(execPrice);
            entryInfo.setAllPrice(execPrice.multiply(this.getNo(entryInfo.getQty())));
            StringBuffer sql = new StringBuffer();
            sql.append(" /*dialect*/select CFCOSTPRICE from CT_PCM_SparePartPrice where CFMaterialID='" + entryInfo.getMaterial().getId() + "' order by Flastupdatetime desc");
            BigDecimal sparePartsPrice = null;
            try {
                IRowSet rs = SQLFacadeFactory.getLocalInstance((Context)ctx).getRowset(sql.toString());
                if (rs.size() <= 0) continue;
                sparePartsPrice = rs.getBigDecimal("CFCOSTPRICE");
                entryInfo.setSparePartsPrice(sparePartsPrice);
                continue;
            }
            catch (Exception ex) {
                throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.spareparts.EMMPCPcmSparepartsResource", (String)"0EMMPCPcmSpareparts-0029", (Locale)ctx.getLocale())));
            }
        }
        for (i = 0; i < costCollection.size(); ++i) {
            tmpStr = new StringBuffer();
            entryInfo = costCollection.get(i);
            AdminOrgUnitInfo adminInfo = entryInfo.getDept();
            if (adminInfo == null) {
                tmpStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.spareparts.EMMPCPcmSparepartsResource", (String)"0EMMPCPcmSpareparts-0030", (Locale)ctx.getLocale()));
            }
            if (SparePartsHelper.isBigDecimalEmptyAndZero(entryInfo.getQty())) {
                tmpStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.spareparts.EMMPCPcmSparepartsResource", (String)"0EMMPCPcmSpareparts-0031", (Locale)ctx.getLocale()));
            }
            if (SparePartsHelper.isBigDecimalEmptyAndZero(entryInfo.getWorkHour())) {
                tmpStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.spareparts.EMMPCPcmSparepartsResource", (String)"0EMMPCPcmSpareparts-0032", (Locale)ctx.getLocale()));
            }
            int rateType = 1;
            EntityViewInfo evi2 = new EntityViewInfo();
            evi2.setSelector(new SelectorItemCollection());
            evi2.getSelector().add(new SelectorItemInfo("generalRate"));
            evi2.setFilter(new FilterInfo());
            evi2.getFilter().getFilterItems().add(new FilterItemInfo("units.number", (Object)adminInfo.getNumber(), CompareType.EQUALS));
            evi2.getFilter().getFilterItems().add(new FilterItemInfo("rateType", (Object)rateType, CompareType.EQUALS));
            evi2.setSorter(new SorterItemCollection());
            SorterItemInfo itemInfo2 = new SorterItemInfo("time");
            itemInfo2.setSortType(SortType.DESCEND);
            evi2.getSorter().add(itemInfo2);
            RateStorageOfManufacturingUnitsCollection rateCollection = null;
            try {
                rateCollection = RateStorageOfManufacturingUnitsFactory.getLocalInstance(ctx).getRateStorageOfManufacturingUnitsCollection(evi2);
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            rateType = 2;
            evi2 = new EntityViewInfo();
            evi2.setSelector(new SelectorItemCollection());
            evi2.getSelector().add(new SelectorItemInfo("generalRate"));
            evi2.setFilter(new FilterInfo());
            evi2.getFilter().getFilterItems().add(new FilterItemInfo("units.number", (Object)adminInfo.getNumber(), CompareType.EQUALS));
            evi2.getFilter().getFilterItems().add(new FilterItemInfo("rateType", (Object)rateType, CompareType.EQUALS));
            evi2.setSorter(new SorterItemCollection());
            SorterItemInfo itemInfo1 = new SorterItemInfo("time");
            itemInfo1.setSortType(SortType.DESCEND);
            evi2.getSorter().add(itemInfo1);
            RateStorageOfManufacturingUnitsCollection rateCollection2 = null;
            try {
                rateCollection2 = RateStorageOfManufacturingUnitsFactory.getLocalInstance(ctx).getRateStorageOfManufacturingUnitsCollection(evi2);
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            BigDecimal workHourRate = BigDecimal.ZERO;
            BigDecimal markRate = BigDecimal.ZERO;
            if (rateCollection.size() != 0) {
                workHourRate = rateCollection.get(0).getGeneralRate();
            }
            if (rateCollection2.size() != 0) {
                markRate = rateCollection2.get(0).getGeneralRate();
            }
            entryInfo.setWorkHourRate(workHourRate);
            entryInfo.setMarkRate(markRate);
            BigDecimal qty = entryInfo.getQty() == null ? BigDecimal.ZERO : entryInfo.getQty();
            BigDecimal workHour = entryInfo.getWorkHour() == null ? BigDecimal.ZERO : entryInfo.getWorkHour();
            BigDecimal workHourRates = entryInfo.getWorkHourRate() == null ? BigDecimal.ZERO : entryInfo.getWorkHourRate();
            BigDecimal markRates = entryInfo.getMarkRate() == null ? BigDecimal.ZERO : entryInfo.getMarkRate();
            BigDecimal proDynCost = entryInfo.getProDynCost() == null ? BigDecimal.ZERO : entryInfo.getProDynCost();
            BigDecimal proSpeCost = entryInfo.getProSpeCost() == null ? BigDecimal.ZERO : entryInfo.getProSpeCost();
            entryInfo.setProArtCost(qty.multiply(workHour).multiply(workHourRates));
            entryInfo.setProMakeCost(qty.multiply(workHour).multiply(markRates));
            entryInfo.setTotalCost(entryInfo.getProArtCost().add(entryInfo.getProMakeCost()).add(proDynCost).add(proSpeCost));
            if (tmpStr.length() <= 0) continue;
            throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.industry.emm.pcm.spareparts.EMMPCPcmSparepartsResource", (String)"BPBJGSGFFLDJH", (Locale)ctx.getLocale(), (Object[])new Object[]{i + 1}) + "," + tmpStr.toString()));
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SparePartsCalculationInfo info = this.getSparePartsCalculationInfo(ctx, pk);
        if (info.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.spareparts.EMMPCPcmSparepartsResource", (String)"0EMMPCPcmSpareparts-0033", (Locale)ctx.getLocale()) + info.getNumber() + EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.spareparts.EMMPCPcmSparepartsResource", (String)"0EMMPCPcmSpareparts-0034", (Locale)ctx.getLocale())));
        }
        super._delete(ctx, pk);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        SparePartsCalculationInfo eti = (SparePartsCalculationInfo)model;
        this.checkHead(ctx, eti);
        this.check(ctx, eti);
        this.checkEntry(ctx, eti);
        this.updateCalculation(ctx, eti);
        SparePartsHelper.insertTotalRowByClassCode(model, ctx);
        SparePartsHelper.sortMaterialEntryColl((IObjectCollection)eti.getEntrys());
        if (eti.getBaseStatus() != BillBaseStatusEnum.TEMPORARILYSAVED && eti.getBaseStatus() != BillBaseStatusEnum.ADD) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.spareparts.EMMPCPcmSparepartsResource", (String)"0EMMPCPcmSpareparts-0035", (Locale)ctx.getLocale())));
        }
        eti.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        return super._save(ctx, model);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return super._addnew(ctx, model);
    }
}

