/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.pcm.template.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.BaseTreeModel;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.industry.emm.pcm.template.EstimateTemplateEntryCollection;
import com.kingdee.eas.industry.emm.pcm.template.EstimateTemplateInfo;
import com.kingdee.eas.industry.emm.pcm.template.app.AbstractEstimateTemplateControllerBean;
import com.kingdee.eas.industry.emm.pcm.util.PcmTreeBillHelper;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.NumericExceptionSubItem;
import java.util.Date;
import java.util.Locale;
import org.apache.log4j.Logger;

public class EstimateTemplateControllerBean
extends AbstractEstimateTemplateControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.industry.emm.pcm.template.app.EstimateTemplateControllerBean");

    @Override
    protected BaseTreeModel _getClassCodeTree(Context ctx, String esTmpId) throws BOSException, EASBizException {
        return super._getClassCodeTree(ctx, esTmpId);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        EstimateTemplateInfo eti = (EstimateTemplateInfo)model;
        return super._addnew(ctx, model);
    }

    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        EstimateTemplateInfo info = (EstimateTemplateInfo)model;
        if (info == null) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.template.EMMPROJECTPcmTemplateResource", (String)"0EMMPcmTemplate-0000", (Locale)ctx.getLocale())));
        }
        this.checkIsInvalid(ctx, info);
        if (info.getStatus() != BillBaseStatusEnum.SUBMITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.template.EMMPROJECTPcmTemplateResource", (String)"0EMMPcmTemplate-0001", (Locale)ctx.getLocale())));
        }
        info.setStatus(BillBaseStatusEnum.AUDITED);
        info.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
        info.setAuditTime(new Date());
        super.update(ctx, pk, (CoreBaseInfo)info);
    }

    private void checkIsInvalid(Context ctx, EstimateTemplateInfo info) throws EASBizException {
        if (info.getStatus() == BillBaseStatusEnum.DELETED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.template.EMMPROJECTPcmTemplateResource", (String)"0EMMPcmTemplate-0002", (Locale)ctx.getLocale())));
        }
    }

    protected void _unpassAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        EstimateTemplateInfo info = (EstimateTemplateInfo)model;
        if (info == null) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.template.EMMPROJECTPcmTemplateResource", (String)"0EMMPcmTemplate-0000", (Locale)ctx.getLocale())));
        }
        this.checkIsInvalid(ctx, info);
        if (info.getStatus() != BillBaseStatusEnum.AUDITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.template.EMMPROJECTPcmTemplateResource", (String)"0EMMPcmTemplate-0003", (Locale)ctx.getLocale())));
        }
        info.setStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        info.setAuditor(null);
        info.setAuditTime(null);
        this._update(ctx, pk, (IObjectValue)info);
    }

    protected void _checkIsHaveDestBills(Context ctx, CoreBaseInfo billInfo) throws EASBizException, BOSException {
        String billIdString;
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        if (iBTPManager.ifHaveDestBills(billIdString = billInfo.getId().toString())) {
            throw new SCMBillException(SCMBillException.HASDESTBILL_CANNOTUNAUDIT, new Object[]{billInfo.getString("number")});
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        EstimateTemplateInfo info = (EstimateTemplateInfo)this.getValue(ctx, pk);
        if (info.getStatus() == BillBaseStatusEnum.AUDITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.template.EMMPROJECTPcmTemplateResource", (String)"0EMMPcmTemplate-0004", (Locale)ctx.getLocale())));
        }
        super._delete(ctx, pk);
    }

    protected void isCanDelete(Context ctx, IObjectPK pk, CoreBillBaseInfo coreBillInfo) throws BOSException, EASBizException {
        super.isCanDelete(ctx, pk, coreBillInfo);
    }

    protected void check(Context ctx, EstimateTemplateInfo eti) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)eti.getNumber(), CompareType.EQUALS));
        if (eti.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)eti.getId().toString(), CompareType.NOTEQUALS));
        }
        if (this._exists(ctx, filter)) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.template.EMMPROJECTPcmTemplateResource", (String)"0EMMPcmTemplate-0005", (Locale)ctx.getLocale())));
        }
        if (eti.getCtrlUnit() == null) {
            eti.setCtrlUnit(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        }
        if (eti.getBizDate() == null) {
            eti.setBizDate(new Date());
        }
        StringBuffer errStr = new StringBuffer();
        if (eti.getName() == null) {
            errStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.template.EMMPROJECTPcmTemplateResource", (String)"0EMMPcmTemplate-0006", (Locale)ctx.getLocale()));
        }
        if (eti.getProjectType() == null) {
            errStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.template.EMMPROJECTPcmTemplateResource", (String)"0EMMPcmTemplate-0007", (Locale)ctx.getLocale()));
        }
        if (eti.getVehicleType() == null) {
            errStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.template.EMMPROJECTPcmTemplateResource", (String)"0EMMPcmTemplate-0008", (Locale)ctx.getLocale()));
        }
        if (errStr.length() > 0) {
            throw new EASBizException(new NumericExceptionSubItem("", errStr.toString()));
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        EstimateTemplateInfo eti = (EstimateTemplateInfo)model;
        this.checkIsInvalid(ctx, eti);
        this.check(ctx, eti);
        this.checkEntrys(ctx, eti);
        this.materialEntryBeforeSave(ctx, eti);
        if (eti.getStatus() != BillBaseStatusEnum.TEMPORARILYSAVED && eti.getStatus() != BillBaseStatusEnum.SUBMITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.template.EMMPROJECTPcmTemplateResource", (String)"0EMMPcmTemplate-0009", (Locale)ctx.getLocale())));
        }
        eti.setStatus(BillBaseStatusEnum.SUBMITED);
        return super._submit(ctx, model);
    }

    protected void checkEntrys(Context ctx, EstimateTemplateInfo eti) throws EASBizException, BOSException {
        String error = null;
        try {
            error = PcmTreeBillHelper.commCheckForEntrys(ctx, eti);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        if (error != null) {
            throw new EASBizException(new NumericExceptionSubItem("", error));
        }
        EstimateTemplateEntryCollection entrysColl = eti.getEntrys();
        for (int i = 0; i < entrysColl.size(); ++i) {
            StringBuffer tmpStr = new StringBuffer();
            IObjectValue materialEntry = entrysColl.getObject(i);
            boolean isTotalRow = materialEntry.getBoolean("isTotalRow");
            if (!isTotalRow) {
                if (PcmTreeBillHelper.isStringEmpty(materialEntry.get("discCode"))) {
                    tmpStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.template.EMMPROJECTPcmTemplateResource", (String)"0EMMPcmTemplate-0010", (Locale)ctx.getLocale()));
                }
                if (PcmTreeBillHelper.isStringEmpty(materialEntry.get("discName"))) {
                    tmpStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.template.EMMPROJECTPcmTemplateResource", (String)"0EMMPcmTemplate-0011", (Locale)ctx.getLocale()));
                }
                if (PcmTreeBillHelper.isStringEmpty(materialEntry.get("flow"))) {
                    tmpStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.template.EMMPROJECTPcmTemplateResource", (String)"0EMMPcmTemplate-0012", (Locale)ctx.getLocale()));
                }
            }
            if (tmpStr.length() <= 0) continue;
            throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.industry.emm.pcm.template.EMMPROJECTPcmTemplateResource", (String)"CLFFLDJH", (Locale)ctx.getLocale(), (Object[])new Object[]{i + 1, tmpStr.toString()})));
        }
    }

    protected void materialEntryBeforeSave(Context ctx, EstimateTemplateInfo model) throws BOSException, EASBizException {
        PcmTreeBillHelper.insertTotalRowByClassCode((IObjectValue)model, ctx);
        PcmTreeBillHelper.sortMaterialEntryColl((IObjectCollection)model.getEntrys());
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        EstimateTemplateInfo eti = (EstimateTemplateInfo)model;
        this.checkIsInvalid(ctx, eti);
        this.check(ctx, eti);
        if (eti.getStatus() != BillBaseStatusEnum.TEMPORARILYSAVED && eti.getStatus() != BillBaseStatusEnum.ADD) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.template.EMMPROJECTPcmTemplateResource", (String)"0EMMPcmTemplate-0013", (Locale)ctx.getLocale())));
        }
        eti.setStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        return super._save(ctx, model);
    }

    protected void _cancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        EstimateTemplateInfo info = (EstimateTemplateInfo)model;
        info = (EstimateTemplateInfo)this._getValue(ctx, pk);
        if (info == null) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.template.EMMPROJECTPcmTemplateResource", (String)"0EMMPcmTemplate-0000", (Locale)ctx.getLocale())));
        }
        this.checkIsInvalid(ctx, info);
        DbUtil.execute((Context)ctx, (String)("update CT_TMP_EstimateTemplate set CFStatus=3 where fid='" + info.getId().toString() + "'"));
    }

    protected void _cancelCancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        EstimateTemplateInfo info = (EstimateTemplateInfo)model;
        info = (EstimateTemplateInfo)this._getValue(ctx, pk);
        if (info == null) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.template.EMMPROJECTPcmTemplateResource", (String)"0EMMPcmTemplate-0000", (Locale)ctx.getLocale())));
        }
        if (info.getStatus() != BillBaseStatusEnum.DELETED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.template.EMMPROJECTPcmTemplateResource", (String)"0EMMPcmTemplate-0014", (Locale)ctx.getLocale())));
        }
        DbUtil.execute((Context)ctx, (String)("update CT_TMP_EstimateTemplate set CFStatus=1 where fid='" + info.getId().toString() + "'"));
    }
}

