/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.pcm.template.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.MeasureUnitCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.industry.emm.pcm.PurchaseAttrEnum;
import com.kingdee.eas.industry.emm.pcm.basedata.ClassificationCodeCollection;
import com.kingdee.eas.industry.emm.pcm.basedata.ClassificationCodeFactory;
import com.kingdee.eas.industry.emm.pcm.basedata.ClassificationCodeInfo;
import com.kingdee.eas.industry.emm.pcm.basedata.IClassificationCode;
import com.kingdee.eas.industry.emm.pcm.basedata.IProjectTypes;
import com.kingdee.eas.industry.emm.pcm.basedata.IVehicleType;
import com.kingdee.eas.industry.emm.pcm.basedata.ProjectTypesFactory;
import com.kingdee.eas.industry.emm.pcm.basedata.ProjectTypesInfo;
import com.kingdee.eas.industry.emm.pcm.basedata.VehicleTypeFactory;
import com.kingdee.eas.industry.emm.pcm.basedata.VehicleTypeInfo;
import com.kingdee.eas.industry.emm.pcm.template.EstimateTemplateCollection;
import com.kingdee.eas.industry.emm.pcm.template.EstimateTemplateEntryInfo;
import com.kingdee.eas.industry.emm.pcm.template.EstimateTemplateFactory;
import com.kingdee.eas.industry.emm.pcm.template.EstimateTemplateInfo;
import com.kingdee.eas.industry.emm.pcm.template.IEstimateTemplate;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.util.Hashtable;
import java.util.Locale;

public class EstimateTemplateImport
extends AbstractDataTransmission {
    IClassificationCode iClassCode;

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return EstimateTemplateFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw new TaskExternalException("", (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable ht, Context ctx) throws TaskExternalException {
        EstimateTemplateInfo billInfo = null;
        int count = 0;
        try {
            for (int i = 0; i < ht.size(); ++i) {
                this.iClassCode = ClassificationCodeFactory.getLocalInstance(ctx);
                Hashtable lineData = (Hashtable)ht.get(new Integer(i));
                if (count == 0 && (billInfo = this.transmitHead(lineData, ctx)) == null) {
                    return null;
                }
                EstimateTemplateEntryInfo entryinfo = this.transmitEntry(lineData, ctx, billInfo);
                int seq = billInfo.getEntrys().size() + 1;
                entryinfo.setSeq(seq);
                entryinfo.setParent(billInfo);
                billInfo.getEntrys().add(entryinfo);
                ++count;
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        return billInfo;
    }

    private EstimateTemplateEntryInfo transmitEntry(Hashtable lineData, Context ctx, EstimateTemplateInfo billInfo) throws TaskExternalException {
        EstimateTemplateEntryInfo entryInfo = new EstimateTemplateEntryInfo();
        Object data = null;
        String str = "";
        try {
            BigDecimal value;
            BigDecimal value2;
            Object flow;
            Object supplier;
            Object purchaseAttr;
            Object collection;
            Object discName;
            Object discNumber = ((DataToken)lineData.get((Object)"FEntrys_discCode")).data;
            if (discNumber != null && discNumber.toString().trim().length() > 0) {
                entryInfo.setDiscCode((String)discNumber);
            }
            if ((discName = ((DataToken)lineData.get((Object)"FEntrys_discName")).data) != null && discName.toString().trim().length() > 0) {
                entryInfo.setDiscName((String)discName);
            }
            if ((data = ((DataToken)lineData.get((Object)"FEntrys$classCode_number")).data) != null && data.toString().length() > 0 && data != null && data.toString().trim().length() > 0) {
                EntityViewInfo ev = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)data.toString(), CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("projectTypes.id", (Object)billInfo.getProjectType().getId().toString(), CompareType.EQUALS));
                ev.setFilter(filter);
                collection = this.iClassCode.getClassificationCodeCollection(ev);
                if (collection != null && collection.size() > 0) {
                    ClassificationCodeInfo classCodeInfo = ((ClassificationCodeCollection)((Object)collection)).get(0);
                    entryInfo.setClassCode(classCodeInfo);
                } else {
                    throw new TaskExternalException(data.toString() + EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.template.EMMPROJECTPcmTemplateResource", (String)"0EMMPcmTemplate-0015", (Locale)ctx.getLocale()) + billInfo.getProjectType().getCategory().getName());
                }
            }
            if ((data = ((DataToken)lineData.get((Object)"FEntrys_isTotalRow")).data) != null && data.toString().trim().length() > 0 && ("true".equalsIgnoreCase(data.toString()) || "1".equals(data.toString()))) {
                entryInfo.setIsTotalRow(true);
            }
            MaterialInfo materialInfo = null;
            data = ((DataToken)lineData.get((Object)"FEntrys$material_number")).data;
            if (data != null && data.toString().length() > 0 && data != null && data.toString().trim().length() > 0) {
                IMaterial imaterial = MaterialFactory.getLocalInstance((Context)ctx);
                collection = imaterial.getMaterialCollection(this.getFilter(data.toString()));
                if (collection != null && collection.size() > 0) {
                    materialInfo = collection.get(0);
                    entryInfo.setMaterial(materialInfo);
                    entryInfo.setMaterialName(materialInfo.getName());
                    entryInfo.setMaterialModel(materialInfo.getModel());
                } else {
                    throw new TaskExternalException(data.toString() + EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.template.EMMPROJECTPcmTemplateResource", (String)"0EMMPcmTemplate-0016", (Locale)ctx.getLocale()));
                }
            }
            if (materialInfo == null) {
                Object materialModel;
                Object materialName = ((DataToken)lineData.get((Object)"FEntrys_materialName")).data;
                if (materialName != null && materialName.toString().trim().length() > 0) {
                    entryInfo.setMaterialName((String)materialName);
                }
                if ((materialModel = ((DataToken)lineData.get((Object)"FEntrys_materialModel")).data) != null && materialModel.toString().trim().length() > 0) {
                    entryInfo.setMaterialModel((String)materialModel);
                }
            }
            if ((purchaseAttr = ((DataToken)lineData.get((Object)"FEntrys_purchaseAttr")).data) != null && purchaseAttr.toString().trim().length() > 0) {
                PurchaseAttrEnum pe = PurchaseAttrEnum.getEnum(Integer.parseInt(purchaseAttr.toString()));
                entryInfo.setPurchaseAttr(pe);
            }
            if ((supplier = ((DataToken)lineData.get((Object)"FEntrys_supplier")).data) != null && supplier.toString().trim().length() > 0) {
                entryInfo.setSupplier((String)supplier);
            }
            if ((flow = ((DataToken)lineData.get((Object)"FEntrys_flow")).data) != null && flow.toString().trim().length() > 0) {
                entryInfo.setFlow((String)flow);
            }
            if ((data = ((DataToken)lineData.get((Object)"FEntrys$unit_number")).data) != null && data.toString().length() > 0 && data != null && data.toString().trim().length() > 0) {
                IMeasureUnit iMeasureUnit = MeasureUnitFactory.getLocalInstance((Context)ctx);
                MeasureUnitCollection collection2 = iMeasureUnit.getMeasureUnitCollection(this.getFilter(data.toString()));
                if (collection2 != null && collection2.size() > 0) {
                    MeasureUnitInfo unitInfo = collection2.get(0);
                    entryInfo.setUnit(unitInfo);
                } else if (materialInfo != null) {
                    entryInfo.setUnit(materialInfo.getBaseUnit());
                } else {
                    throw new TaskExternalException(data.toString() + EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.template.EMMPROJECTPcmTemplateResource", (String)"0EMMPcmTemplate-0017", (Locale)ctx.getLocale()));
                }
            }
            Object qty = ((DataToken)lineData.get((Object)"FEntrys_trolleyQty")).data;
            entryInfo.setTrolleyQty(BigDecimal.ZERO);
            if (qty != null && qty.toString().trim().length() > 0 && (value2 = new BigDecimal(qty.toString())) != null) {
                if (value2.compareTo(BigDecimal.ZERO) < 0) {
                    throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.template.EMMPROJECTPcmTemplateResource", (String)"0EMMPcmTemplate-0018", (Locale)ctx.getLocale()));
                }
                entryInfo.setTrolleyQty(value2);
            }
            Object price = ((DataToken)lineData.get((Object)"FEntrys_trolleyPrice")).data;
            entryInfo.setTrolleyPrice(BigDecimal.ZERO);
            if (price != null && price.toString().trim().length() > 0 && (value = new BigDecimal(price.toString())) != null) {
                entryInfo.setTrolleyPrice(value);
            }
            if (!entryInfo.isIsTotalRow()) {
                entryInfo.setTrolleyCost(entryInfo.getTrolleyQty().multiply(entryInfo.getTrolleyPrice()));
            } else {
                BigDecimal value3;
                Object cost = ((DataToken)lineData.get((Object)"FEntrys_trolleyCost")).data;
                entryInfo.setTrolleyCost(BigDecimal.ZERO);
                if (cost != null && cost.toString().trim().length() > 0 && (value3 = new BigDecimal(cost.toString())) != null) {
                    entryInfo.setTrolleyCost(value3);
                }
            }
            Object remark = ((DataToken)lineData.get((Object)"FEntrys_remark")).data;
            if (remark != null && remark.toString().trim().length() > 0) {
                entryInfo.setRemark(remark.toString());
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
        return entryInfo;
    }

    private EntityViewInfo getFilter(String number) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        return viewInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private EstimateTemplateInfo transmitHead(Hashtable lineData, Context ctx) throws TaskExternalException, BOSException {
        AbstractObjectCollection collection;
        EstimateTemplateInfo billInfo = new EstimateTemplateInfo();
        Object data = null;
        Object str = null;
        boolean tryDoNumber = false;
        boolean userCodingRuleManager = false;
        Object number = ((DataToken)lineData.get((Object)"FNumber")).data;
        if (number != null && number.toString().trim().length() > 0) {
            billInfo.setNumber(number.toString().trim());
            String existId = this.getIdFromNumber(number.toString().trim(), ctx);
            if (!this.isSltImportUpdate() && !StringUtil.isEmptyString((String)existId)) {
                throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.template.EMMPROJECTPcmTemplateResource", (String)"0EMMPcmTemplate-0019", (Locale)ctx.getLocale()));
            }
            if (this.isSltImportUpdate() && !StringUtil.isEmptyString((String)existId)) {
                EstimateTemplateInfo existInfo = null;
                try {
                    existInfo = ((IEstimateTemplate)this.getController(ctx)).getEstimateTemplateInfo((IObjectPK)new ObjectUuidPK(existId));
                }
                catch (Exception e) {
                    throw new TaskExternalException("", (Throwable)e);
                }
                if (!BillBaseStatusEnum.TEMPORARILYSAVED.equals((Object)existInfo.getStatus())) {
                    throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.template.EMMPROJECTPcmTemplateResource", (String)"0EMMPcmTemplate-0020", (Locale)ctx.getLocale()));
                }
            }
            if (StringUtil.isEmptyString((String)existId)) {
                userCodingRuleManager = true;
                tryDoNumber = true;
            }
        } else {
            tryDoNumber = true;
        }
        Object name = ((DataToken)lineData.get((Object)"FName")).data;
        if (name != null && name.toString().trim().length() > 0) {
            billInfo.setName((String)name);
        }
        if ((data = ((DataToken)lineData.get((Object)"FProjectType_number")).data) == null || data.toString().length() <= 0) throw new TaskExternalException(data.toString() + EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.template.EMMPROJECTPcmTemplateResource", (String)"0EMMPcmTemplate-0021", (Locale)ctx.getLocale()));
        if (data != null && data.toString().trim().length() > 0) {
            IProjectTypes iProjectTypes = ProjectTypesFactory.getLocalInstance(ctx);
            collection = iProjectTypes.getProjectTypesCollection(this.getFilter(data.toString()));
            if (collection == null || collection.size() <= 0) throw new TaskExternalException(data.toString() + EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.template.EMMPROJECTPcmTemplateResource", (String)"0EMMPcmTemplate-0021", (Locale)ctx.getLocale()));
            ProjectTypesInfo projectTypes = collection.get(0);
            billInfo.setProjectType(projectTypes);
        }
        if ((data = ((DataToken)lineData.get((Object)"FVehicleType_number")).data) == null || data.toString().length() <= 0) throw new TaskExternalException(data.toString() + EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.template.EMMPROJECTPcmTemplateResource", (String)"0EMMPcmTemplate-0022", (Locale)ctx.getLocale()));
        if (data == null || data.toString().trim().length() <= 0) return billInfo;
        IVehicleType iVehicleType = VehicleTypeFactory.getLocalInstance(ctx);
        collection = iVehicleType.getVehicleTypeCollection(this.getFilter(data.toString()));
        if (collection == null || collection.size() <= 0) throw new TaskExternalException(data.toString() + EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.template.EMMPROJECTPcmTemplateResource", (String)"0EMMPcmTemplate-0022", (Locale)ctx.getLocale()));
        VehicleTypeInfo vehicleTypeInfo = collection.get(0);
        billInfo.setVehicleType(vehicleTypeInfo);
        return billInfo;
    }

    private String getIdFromNumber(String number, Context ctx) throws TaskExternalException {
        EstimateTemplateCollection collection;
        try {
            collection = EstimateTemplateFactory.getLocalInstance(ctx).getEstimateTemplateCollection("where number ='" + number + "'");
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        if (collection != null && collection.size() > 0) {
            return collection.get(0).getId().toString();
        }
        return null;
    }

    public int getSubmitType() {
        return 1;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            if (rs.getString("number") != null) {
                result.put("FNumber", rs.getString("number"));
            }
            if (rs.getString("name") != null) {
                result.put("FName", rs.getString("name"));
            }
            if (rs.getString("bizDate") != null) {
                result.put("FBizDate", rs.getString("bizDate"));
            }
            if (rs.getString("projectType.number") != null) {
                result.put("FProjectType_number", rs.getString("projectType.number"));
            }
            if (rs.getString("vehicleType.number") != null) {
                result.put("FVehicleType_number", rs.getString("vehicleType.number"));
            }
            if (rs.getString("entrys.discCode") != null) {
                result.put("FEntrys_discCode", rs.getString("entrys.discCode"));
            }
            if (rs.getString("entrys.discName") != null) {
                result.put("FEntrys_discName", rs.getString("entrys.discName"));
            }
            if (rs.getString("entrys.classCode.number") != null) {
                result.put("FEntrys$classCode_number", rs.getString("entrys.classCode.number"));
            }
            if (rs.getString("entrys.isTotalRow") != null) {
                result.put("FEntrys_isTotalRow", rs.getString("entrys.isTotalRow"));
            }
            if (rs.getString("entrys_classCode.name") != null) {
                result.put("FEntrys_className", rs.getString("entrys_classCode.name"));
            }
            if (rs.getString("entrys_classCode.attribute") != null) {
                result.put("FEntrys_classCodeAttr", rs.getString("entrys_classCode.attribute"));
            }
            if (rs.getString("entrys.material.number") != null) {
                result.put("FEntrys$material_number", rs.getString("entrys.material.number"));
            }
            if (rs.getString("entrys.materialName") != null) {
                result.put("FEntrys_materialName", rs.getString("entrys.materialName"));
            }
            if (rs.getString("entrys.materialModel") != null) {
                result.put("FEntrys_materialModel", rs.getString("entrys.materialModel"));
            }
            if (rs.getString("entrys.purchaseAttr") != null) {
                result.put("FEntrys_purchaseAttr", rs.getString("entrys.purchaseAttr"));
            }
            if (rs.getString("entrys.supplier") != null) {
                result.put("FEntrys_supplier", rs.getString("entrys.supplier"));
            }
            if (rs.getString("entrys.flow") != null) {
                result.put("FEntrys_flow", rs.getString("entrys.flow"));
            }
            if (rs.getString("entrys_unit.number") != null) {
                result.put("FEntrys$unit_number", rs.getString("entrys_unit.number"));
            }
            if (rs.getString("entrys.unit.name") != null) {
                result.put("FEntrys$unit_name", rs.getString("entrys.unit.name"));
            }
            if (rs.getString("entrys.trolleyQty") != null) {
                result.put("FEntrys_trolleyQty", rs.getString("entrys.trolleyQty"));
            }
            if (rs.getString("entrys.trolleyPrice") != null) {
                result.put("FEntrys_trolleyPrice", rs.getString("entrys.trolleyPrice"));
            }
            if (rs.getString("entrys.trolleyCost") != null) {
                result.put("FEntrys_trolleyCost", rs.getString("entrys.trolleyCost"));
            }
            if (rs.getString("entrys.remark") != null) {
                result.put("FEntrys_remark", rs.getString("entrys.remark"));
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        EstimateTemplateInfo info = (EstimateTemplateInfo)coreBaseInfo;
        if (coreBaseInfo == null || !(coreBaseInfo instanceof EstimateTemplateInfo)) {
            return;
        }
        try {
            ((EstimateTemplateInfo)coreBaseInfo).setStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
            this.getController(ctx).save(coreBaseInfo);
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }
}

