/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.pcm.yearbudget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.codingrule.RuleStatus;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.industry.emm.pcm.yearbudget.ProjectWGHoursBillInfo;
import com.kingdee.eas.industry.emm.pcm.yearbudget.app.AbstractProjectWGHoursBillControllerBean;
import com.kingdee.eas.ncm.common.CMBillException;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.util.Date;
import java.util.Locale;
import org.apache.log4j.Logger;

public class ProjectWGHoursBillControllerBean
extends AbstractProjectWGHoursBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.industry.emm.mm.sc.app.YearScRequestBillControllerBean");

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ProjectWGHoursBillInfo bill = (ProjectWGHoursBillInfo)model;
        if (bill.getCU() == null) {
            bill.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        }
        this.checkNumber(ctx, (IObjectValue)bill);
        return super._addnew(ctx, model);
    }

    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        ProjectWGHoursBillInfo info = (ProjectWGHoursBillInfo)model;
        if (info == null) {
            info = (ProjectWGHoursBillInfo)this._getValue(ctx, pk);
        }
        if (info.getStatus() != BillBaseStatusEnum.SUBMITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.yearbudget.EMMPROJECTPcmYearbudgetResource", (String)"0EMMPcmYearbudget-0000", (Locale)ctx.getLocale())));
        }
        info.setStatus(BillBaseStatusEnum.AUDITED);
        info.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
        info.setAuditTime(new Date());
        super.update(ctx, pk, (CoreBaseInfo)info);
    }

    protected void _unpassAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        ProjectWGHoursBillInfo info = (ProjectWGHoursBillInfo)model;
        if (info == null) {
            info = (ProjectWGHoursBillInfo)this._getValue(ctx, pk);
        }
        if (info.getStatus() != BillBaseStatusEnum.AUDITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.yearbudget.EMMPROJECTPcmYearbudgetResource", (String)"0EMMPcmYearbudget-0001", (Locale)ctx.getLocale())));
        }
        info.setStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        info.setAuditor(null);
        info.setAuditTime(null);
        this._checkIsHaveDestBills(ctx, (CoreBaseInfo)info);
        super.update(ctx, pk, (CoreBaseInfo)info);
    }

    protected void _checkIsHaveDestBills(Context ctx, CoreBaseInfo billInfo) throws EASBizException, BOSException {
        String billIdString;
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        if (iBTPManager.ifHaveDestBills(billIdString = billInfo.getId().toString())) {
            throw new SCMBillException(SCMBillException.HASDESTBILL_CANNOTUNAUDIT, new Object[]{billInfo.getString("number")});
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ProjectWGHoursBillInfo info = (ProjectWGHoursBillInfo)this.getValue(ctx, pk);
        if (info.getStatus() == BillBaseStatusEnum.AUDITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.yearbudget.EMMPROJECTPcmYearbudgetResource", (String)"0EMMPcmYearbudget-0002", (Locale)ctx.getLocale())));
        }
        super._delete(ctx, pk);
    }

    protected void check(Context ctx, ProjectWGHoursBillInfo eti) throws EASBizException, BOSException {
        if (eti.getCU() == null) {
            eti.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)eti.getNumber(), CompareType.EQUALS));
        if (eti.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)eti.getId().toString(), CompareType.NOTEQUALS));
        }
        if (this._exists(ctx, filter)) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.yearbudget.EMMPROJECTPcmYearbudgetResource", (String)"0EMMPcmYearbudget-0003", (Locale)ctx.getLocale())));
        }
        StringBuffer errStr = new StringBuffer();
        if (errStr.length() > 0) {
            throw new EASBizException(new NumericExceptionSubItem("", errStr.toString()));
        }
        if (eti.getBizDate() == null) {
            eti.setBizDate(new Date());
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ProjectWGHoursBillInfo eti = (ProjectWGHoursBillInfo)model;
        this.check(ctx, eti);
        if (eti.getStatus() != BillBaseStatusEnum.TEMPORARILYSAVED && eti.getStatus() != BillBaseStatusEnum.SUBMITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.yearbudget.EMMPROJECTPcmYearbudgetResource", (String)"0EMMPcmYearbudget-0004", (Locale)ctx.getLocale())));
        }
        eti.setStatus(BillBaseStatusEnum.SUBMITED);
        return super._submit(ctx, model);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ProjectWGHoursBillInfo eti = (ProjectWGHoursBillInfo)model;
        if (eti.getCU() == null) {
            eti.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        }
        this.check(ctx, eti);
        if (eti.getStatus() != BillBaseStatusEnum.TEMPORARILYSAVED && eti.getStatus() != BillBaseStatusEnum.ADD) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.yearbudget.EMMPROJECTPcmYearbudgetResource", (String)"0EMMPcmYearbudget-0005", (Locale)ctx.getLocale())));
        }
        eti.setStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        return super._save(ctx, model);
    }

    protected void checkNumber(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ProjectWGHoursBillInfo info = (ProjectWGHoursBillInfo)model;
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        RuleStatus ruleStatus = iCodingRuleManager.getRuleStatus(model, info.getAdminOrgUnit().getId().toString());
        if (ruleStatus.isExist() && (StringUtils.isEmpty((String)info.getNumber()) || ruleStatus.isAddNoBreak() || !ruleStatus.isModifiable() && this.isNumberUsed(ctx, (CoreBillBaseInfo)info))) {
            this.setNewNumber(ctx, (CoreBillBaseInfo)info, iCodingRuleManager, null);
        } else {
            ObjectUuidPK pk = new ObjectUuidPK(model.getBOSUuid("id"));
            super._checkNumberBlank(ctx, (IObjectPK)pk, model);
            super._checkNumberDup(ctx, (IObjectPK)pk, model);
        }
    }

    protected boolean isNumberUsed(Context ctx, CoreBillBaseInfo info) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)info.getNumber(), CompareType.EQUALS));
        if (info.getCU() != null) {
            filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)info.getCU().getId().toString(), CompareType.EQUALS));
        }
        if (info.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
        }
        boolean exist = super._exists(ctx, filter);
        return exist;
    }

    protected void setNewNumber(Context ctx, CoreBillBaseInfo info, ICodingRuleManager iCodingRuleManager, String customString) throws BOSException, EASBizException {
        String number = iCodingRuleManager.getNumber((IObjectValue)info, ((ProjectWGHoursBillInfo)info).getAdminOrgUnit().getId().toString(), customString);
        info.setNumber(number);
        if (this.isNumberUsed(ctx, info)) {
            this.setNewNumber(ctx, info, iCodingRuleManager, customString);
        }
    }

    protected String _getNewNumber(Context ctx, IObjectValue model, String strCompanyID, String customString) throws BOSException, EASBizException {
        String strBindProp;
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        ProjectWGHoursBillInfo aSCMBillBaseInfo = (ProjectWGHoursBillInfo)model;
        String number = "";
        boolean isNumberNoSet = false;
        if (aSCMBillBaseInfo.getNumber() == null || aSCMBillBaseInfo.getNumber().length() == 0) {
            isNumberNoSet = true;
        }
        if ((strBindProp = this.getBindingProperty(ctx)) != null && strBindProp.trim().length() > 0) {
            number = iCodingRuleManager.getNumber((IObjectValue)aSCMBillBaseInfo, strCompanyID, strBindProp, customString);
            aSCMBillBaseInfo.setNumber(number);
        } else {
            number = iCodingRuleManager.getNumber((IObjectValue)aSCMBillBaseInfo, strCompanyID, customString);
            aSCMBillBaseInfo.setNumber(number);
        }
        ObjectUuidPK pk = new ObjectUuidPK(aSCMBillBaseInfo.getId());
        if (this.isSameNumber(ctx, (IObjectPK)pk, (IObjectValue)aSCMBillBaseInfo)) {
            String newNumber = "";
            newNumber = strBindProp != null && strBindProp.trim().length() > 0 ? iCodingRuleManager.getNumber((IObjectValue)aSCMBillBaseInfo, strCompanyID, strBindProp, customString) : iCodingRuleManager.getNumber((IObjectValue)aSCMBillBaseInfo, strCompanyID, customString);
            if (newNumber.equals(aSCMBillBaseInfo.getNumber())) {
                throw new CMBillException(CMBillException.NUMBERRULEERROR);
            }
            number = newNumber;
            aSCMBillBaseInfo.setNumber(newNumber);
            if (this.isSameNumber(ctx, (IObjectPK)pk, (IObjectValue)aSCMBillBaseInfo)) {
                return this._getNewNumber(ctx, (IObjectValue)aSCMBillBaseInfo, strCompanyID, customString);
            }
        }
        return number;
    }

    protected boolean isSameNumber(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        ProjectWGHoursBillInfo aSCMBillBaseInfo = (ProjectWGHoursBillInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)aSCMBillBaseInfo.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (aSCMBillBaseInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)aSCMBillBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (aSCMBillBaseInfo.getCU() != null) {
            filterItem = new FilterItemInfo("CU", (Object)aSCMBillBaseInfo.getCU().getId().toString(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        } else {
            filterItem = new FilterItemInfo("CU", null, CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (this.getBindingProperty(ctx) != null && this.getBindingProperty(ctx).trim().length() > 0 && aSCMBillBaseInfo.get(this.getBindingProperty(ctx)) != null) {
            filterItem = new FilterItemInfo(this.getBindingProperty(ctx), this.getBindingPropertyValue((CoreBillBaseInfo)aSCMBillBaseInfo), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < filter.getFilterItems().size(); ++i) {
            if (i != 0) {
                sb.append(" and #" + i);
                continue;
            }
            sb.append("#" + i);
        }
        filter.setMaskString(sb.toString());
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        return super._exists(ctx, filter);
    }

    protected String getBindingProperty(Context ctx) throws BOSException {
        return null;
    }

    protected Object getBindingPropertyValue(CoreBillBaseInfo aSCMBillBaseInfo) {
        return null;
    }
}

