/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.pcm.yearbudget.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.codingrule.RuleStatus;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.industry.emm.pcm.basedata.ProjectTypesInfo;
import com.kingdee.eas.industry.emm.pcm.yearbudget.ProjectZyExBudgetBillEntryCollection;
import com.kingdee.eas.industry.emm.pcm.yearbudget.ProjectZyExBudgetBillEntryInfo;
import com.kingdee.eas.industry.emm.pcm.yearbudget.ProjectZyExBudgetBillInfo;
import com.kingdee.eas.industry.emm.pcm.yearbudget.ZxExpenseTypeCollection;
import com.kingdee.eas.industry.emm.pcm.yearbudget.ZxExpenseTypeFactory;
import com.kingdee.eas.industry.emm.pcm.yearbudget.ZxExpenseTypeInfo;
import com.kingdee.eas.industry.emm.pcm.yearbudget.app.AbstractProjectZyExBudgetBillControllerBean;
import com.kingdee.eas.ncm.common.CMBillException;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.Locale;
import org.apache.log4j.Logger;

public class ProjectZyExBudgetBillControllerBean
extends AbstractProjectZyExBudgetBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.industry.emm.mm.sc.app.YearScRequestBillControllerBean");

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ProjectZyExBudgetBillInfo bill = (ProjectZyExBudgetBillInfo)model;
        if (bill.getCU() == null) {
            bill.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        }
        this.checkNumber(ctx, (IObjectValue)bill);
        return super._addnew(ctx, model);
    }

    protected void _handleAfterTransform(Context ctx, String action, IObjectCollection collection) throws BOSException, EASBizException {
        super._handleAfterTransform(ctx, action, collection);
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            IObjectValue objectValue = collection.getObject(i);
            if (!(objectValue instanceof ProjectZyExBudgetBillInfo)) continue;
            ProjectZyExBudgetBillInfo pbi = this.getZxExpenseTypeInfo(ctx, (ProjectZyExBudgetBillInfo)collection.getObject(i));
            collection.addObject((IObjectValue)pbi);
        }
    }

    private ProjectZyExBudgetBillInfo getZxExpenseTypeInfo(Context ctx, ProjectZyExBudgetBillInfo info) throws BOSException {
        ProjectZyExBudgetBillInfo pbi = (ProjectZyExBudgetBillInfo)info.clone();
        pbi.getEntrys().clear();
        for (int i = 0; i < info.getEntrys().size(); ++i) {
            ProjectZyExBudgetBillEntryInfo peio = info.getEntrys().get(i);
            ProjectTypesInfo project_type = peio.getProjectType();
            if (project_type == null) continue;
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("projectType.id", (Object)project_type.getId().toString(), CompareType.EQUALS));
            ev.setFilter(filter);
            ZxExpenseTypeCollection zc = ZxExpenseTypeFactory.getLocalInstance(ctx).getZxExpenseTypeCollection(ev);
            if (zc == null || zc.size() <= 0) continue;
            ProjectZyExBudgetBillEntryCollection poc = new ProjectZyExBudgetBillEntryCollection();
            for (int j = 0; j < zc.size(); ++j) {
                ZxExpenseTypeInfo zi = zc.get(j);
                ProjectZyExBudgetBillEntryInfo pei = new ProjectZyExBudgetBillEntryInfo();
                pei.setProject(peio.getProject());
                pei.setProjectAttr(peio.getProjectAttr());
                pei.setProjectType(peio.getProjectType());
                pei.setZyExType(zi);
                poc.add(pei);
            }
            Boolean bl = pbi.getEntrys().addCollection(poc);
        }
        return pbi;
    }

    public void _handleAfterTransform(Context ctx, String action, IObjectValue objectValue) throws BOSException, EASBizException {
        super._handleAfterTransform(ctx, action, objectValue);
        if (objectValue instanceof ProjectZyExBudgetBillInfo) {
            // empty if block
        }
    }

    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        ProjectZyExBudgetBillInfo info = (ProjectZyExBudgetBillInfo)model;
        if (info == null) {
            info = (ProjectZyExBudgetBillInfo)this._getValue(ctx, pk);
        }
        if (info.getStatus() != BillBaseStatusEnum.SUBMITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.yearbudget.EMMPROJECTPcmYearbudgetResource", (String)"0EMMPcmYearbudget-0000", (Locale)ctx.getLocale())));
        }
        info.setStatus(BillBaseStatusEnum.AUDITED);
        info.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
        info.setAuditTime(new Date());
        super.update(ctx, pk, (CoreBaseInfo)info);
    }

    protected void _unpassAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        ProjectZyExBudgetBillInfo info = (ProjectZyExBudgetBillInfo)model;
        if (info == null) {
            info = (ProjectZyExBudgetBillInfo)this._getValue(ctx, pk);
        }
        if (info.getStatus() != BillBaseStatusEnum.AUDITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.yearbudget.EMMPROJECTPcmYearbudgetResource", (String)"0EMMPcmYearbudget-0001", (Locale)ctx.getLocale())));
        }
        info.setStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        info.setAuditor(null);
        info.setAuditTime(null);
        this._checkIsHaveDestBills(ctx, (CoreBaseInfo)info);
        super.update(ctx, pk, (CoreBaseInfo)info);
    }

    protected void _checkIsHaveDestBills(Context ctx, CoreBaseInfo billInfo) throws EASBizException, BOSException {
        String billIdString;
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        if (iBTPManager.ifHaveDestBills(billIdString = billInfo.getId().toString())) {
            throw new SCMBillException(SCMBillException.HASDESTBILL_CANNOTUNAUDIT, new Object[]{billInfo.getString("number")});
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ProjectZyExBudgetBillInfo info = (ProjectZyExBudgetBillInfo)this.getValue(ctx, pk);
        if (info.getStatus() == BillBaseStatusEnum.AUDITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.yearbudget.EMMPROJECTPcmYearbudgetResource", (String)"0EMMPcmYearbudget-0002", (Locale)ctx.getLocale())));
        }
        super._delete(ctx, pk);
    }

    protected void check(Context ctx, ProjectZyExBudgetBillInfo eti) throws EASBizException, BOSException {
        if (eti.getCU() == null) {
            eti.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)eti.getNumber(), CompareType.EQUALS));
        if (eti.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)eti.getId().toString(), CompareType.NOTEQUALS));
        }
        if (this._exists(ctx, filter)) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.yearbudget.EMMPROJECTPcmYearbudgetResource", (String)"0EMMPcmYearbudget-0003", (Locale)ctx.getLocale())));
        }
        StringBuffer errStr = new StringBuffer();
        if (errStr.length() > 0) {
            throw new EASBizException(new NumericExceptionSubItem("", errStr.toString()));
        }
        if (eti.getBizDate() == null) {
            eti.setBizDate(new Date());
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ProjectZyExBudgetBillInfo eti = (ProjectZyExBudgetBillInfo)model;
        this.check(ctx, eti);
        if (eti.getStatus() != BillBaseStatusEnum.TEMPORARILYSAVED && eti.getStatus() != BillBaseStatusEnum.SUBMITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.yearbudget.EMMPROJECTPcmYearbudgetResource", (String)"0EMMPcmYearbudget-0004", (Locale)ctx.getLocale())));
        }
        eti.setStatus(BillBaseStatusEnum.SUBMITED);
        this.calEntry(ctx, eti);
        return super._submit(ctx, model);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void calEntry(Context ctx, ProjectZyExBudgetBillInfo eti) throws BOSException {
        int year = eti.getYear();
        String tmpFyys = null;
        String tmpXmsx = null;
        String tmpFsgs = null;
        try {
            StringBuffer sql2332 = new StringBuffer();
            sql2332.append("create table txxxx (");
            sql2332.append(" fyear int,");
            sql2332.append(" fadminid varchar(44),");
            sql2332.append(" ftypeid varchar(44),");
            sql2332.append(" famount NUMERIC(28,2))");
            tmpFyys = TempTablePool.getInstance((Context)ctx).createTempTable(sql2332.toString());
            sql2332.setLength(0);
            sql2332.append("/*dialect*/ insert into " + tmpFyys);
            sql2332.append(" select b.cfyear as fyear,ad.fid as  fadminid,ty.fid as ftypeid,sum(e.cfamount)");
            sql2332.append(" from CT_PCM_ZyExBudgetRequestBill b");
            sql2332.append(" inner join CT_PCM_ZyEBRBE e on b.fid=e.fparentid");
            sql2332.append(" inner join CT_PCM_ZxExpenseType ty on e.CFZyExID=ty.fid");
            sql2332.append(" inner join t_org_admin ad on b.cfrequestdeptid=ad.fid");
            sql2332.append(" where b.cfstatus=4");
            sql2332.append(" and b.cfyear=" + year);
            sql2332.append(" group by b.cfyear ,ad.fid ,ty.fid");
            DbUtil.execute((Context)ctx, (String)sql2332.toString());
            sql2332.setLength(0);
            sql2332.append("create table txxxx (");
            sql2332.append(" fyear int,");
            sql2332.append(" fprojectattr int,");
            sql2332.append(" fprojectid varchar(44),");
            sql2332.append(" fsaleincome NUMERIC(28,2))");
            tmpXmsx = TempTablePool.getInstance((Context)ctx).createTempTable(sql2332.toString());
            sql2332.setLength(0);
            sql2332.append("/*dialect*/ insert into " + tmpXmsx);
            sql2332.append(" select b.cfyear as fyear,pt.cfprojectattr,p.fid,sum(e.cfsaleIncome)");
            sql2332.append(" from CT_PCM_ProjectMCBRB b");
            sql2332.append(" inner join CT_PCM_ProjectMCBRBE e on b.fid=e.fparentid");
            sql2332.append(" inner join t_org_admin ad on b.cfrequestdeptid=ad.fid");
            sql2332.append(" inner join ct_pcm_projecttypes pt on e.cfprojecttypeid=pt.fid");
            sql2332.append(" inner join t_mm_project p on p.fid=e.cfprojectid");
            sql2332.append(" where b.cfstatus=4");
            sql2332.append(" and b.cfyear=" + year);
            sql2332.append(" group by b.cfyear ,pt.cfprojectattr,p.fid");
            DbUtil.execute((Context)ctx, (String)sql2332.toString());
            sql2332.setLength(0);
            sql2332.append("create table txxxx (");
            sql2332.append(" fyear int,");
            sql2332.append(" fadminid varchar(44),");
            sql2332.append(" fprojectattr int,");
            sql2332.append(" fprojectid varchar(44),");
            sql2332.append(" fsinglehours NUMERIC(28,2),");
            sql2332.append(" fhours NUMERIC(28,2))");
            tmpFsgs = TempTablePool.getInstance((Context)ctx).createTempTable(sql2332.toString());
            sql2332.setLength(0);
            sql2332.append("/*dialect*/ insert into " + tmpFsgs);
            sql2332.append(" select b.cfyear as fyear,ad.fid as fadminid,pt.cfprojectattr,p.fid,sum(e.cfwgHours),sum(e.cfwgHoursAll)");
            sql2332.append(" from CT_PCM_ProjectWGHoursBill b");
            sql2332.append(" inner join CT_PCM_ProjectWGHoursBillEntry e on b.fid=e.fparentid");
            sql2332.append(" inner join t_org_admin ad on b.cfrequestdeptid=ad.fid");
            sql2332.append(" inner join ct_pcm_projecttypes pt on e.cfprojecttypeid=pt.fid");
            sql2332.append(" inner join t_mm_project p on p.fid=e.cfprojectid");
            sql2332.append(" where b.cfstatus=4");
            sql2332.append(" and b.cfyear=" + year);
            sql2332.append(" group by b.cfyear ,ad.fid ,pt.cfprojectattr ,p.fid");
            DbUtil.execute((Context)ctx, (String)sql2332.toString());
            String adminID = eti.getRequestDept().getId().toString();
            for (int i = 0; i < eti.getEntrys().size(); ++i) {
                ProjectZyExBudgetBillEntryInfo entry = eti.getEntrys().get(i);
                ZxExpenseTypeInfo zyTypeInfo = ZxExpenseTypeFactory.getLocalInstance(ctx).getZxExpenseTypeInfo((IObjectPK)new ObjectUuidPK(entry.getZyExType().getId()));
                if (!zyTypeInfo.isIsCal()) continue;
                String projectID = entry.getProject().getId().toString();
                String zyTypeId = zyTypeInfo.getId().toString();
                BigDecimal zyfAll = BigDecimal.ZERO;
                IRowSet rst = DbUtil.executeQuery((Context)ctx, (String)("select famount from " + tmpFyys + " where fadminid='" + adminID + "' and ftypeid='" + zyTypeId + "'"));
                if (rst.next()) {
                    zyfAll = rst.getBigDecimal("famount") == null ? BigDecimal.ZERO : rst.getBigDecimal("famount");
                }
                BigDecimal singHour = BigDecimal.ZERO;
                rst = DbUtil.executeQuery((Context)ctx, (String)("select fsinglehours as famount from " + tmpFsgs + " where fadminid='" + adminID + "' and fprojectid='" + projectID + "'"));
                if (rst.next()) {
                    singHour = rst.getBigDecimal("famount") == null ? BigDecimal.ZERO : rst.getBigDecimal("famount");
                }
                BigDecimal hourAll = BigDecimal.ZERO;
                rst = DbUtil.executeQuery((Context)ctx, (String)("select sum(fhours) as famount from " + tmpFsgs + " where fadminid='" + adminID + "'"));
                if (rst.next()) {
                    hourAll = rst.getBigDecimal("famount") == null ? BigDecimal.ZERO : rst.getBigDecimal("famount");
                }
                BigDecimal result = BigDecimal.ZERO;
                if (hourAll.compareTo(BigDecimal.ZERO) != 0) {
                    result = zyfAll.multiply(singHour).setScale(2, RoundingMode.HALF_UP).divide(hourAll, 2, RoundingMode.HALF_UP);
                }
                entry.setAmount(result);
            }
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                try {
                    TempTablePool.getInstance((Context)ctx).createTempTable(tmpFyys);
                    TempTablePool.getInstance((Context)ctx).createTempTable(tmpXmsx);
                    TempTablePool.getInstance((Context)ctx).createTempTable(tmpFsgs);
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            TempTablePool.getInstance((Context)ctx).createTempTable(tmpFyys);
            TempTablePool.getInstance((Context)ctx).createTempTable(tmpXmsx);
            TempTablePool.getInstance((Context)ctx).createTempTable(tmpFsgs);
            return;
        }
        catch (Exception sql2332) {
            return;
        }
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ProjectZyExBudgetBillInfo eti = (ProjectZyExBudgetBillInfo)model;
        if (eti.getCU() == null) {
            eti.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        }
        this.check(ctx, eti);
        if (eti.getStatus() != BillBaseStatusEnum.TEMPORARILYSAVED && eti.getStatus() != BillBaseStatusEnum.ADD) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.yearbudget.EMMPROJECTPcmYearbudgetResource", (String)"0EMMPcmYearbudget-0005", (Locale)ctx.getLocale())));
        }
        eti.setStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        this.calEntry(ctx, eti);
        return super._save(ctx, model);
    }

    protected void checkNumber(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ProjectZyExBudgetBillInfo info = (ProjectZyExBudgetBillInfo)model;
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        RuleStatus ruleStatus = iCodingRuleManager.getRuleStatus(model, info.getAdminOrgUnit().getId().toString());
        if (ruleStatus.isExist() && (StringUtils.isEmpty((String)info.getNumber()) || ruleStatus.isAddNoBreak() || !ruleStatus.isModifiable() && this.isNumberUsed(ctx, (CoreBillBaseInfo)info))) {
            this.setNewNumber(ctx, (CoreBillBaseInfo)info, iCodingRuleManager, null);
        } else {
            ObjectUuidPK pk = new ObjectUuidPK(model.getBOSUuid("id"));
            super._checkNumberBlank(ctx, (IObjectPK)pk, model);
            super._checkNumberDup(ctx, (IObjectPK)pk, model);
        }
    }

    protected boolean isNumberUsed(Context ctx, CoreBillBaseInfo info) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)info.getNumber(), CompareType.EQUALS));
        if (info.getCU() != null) {
            filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)info.getCU().getId().toString(), CompareType.EQUALS));
        }
        if (info.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
        }
        boolean exist = super._exists(ctx, filter);
        return exist;
    }

    protected void setNewNumber(Context ctx, CoreBillBaseInfo info, ICodingRuleManager iCodingRuleManager, String customString) throws BOSException, EASBizException {
        String number = iCodingRuleManager.getNumber((IObjectValue)info, ((ProjectZyExBudgetBillInfo)info).getAdminOrgUnit().getId().toString(), customString);
        info.setNumber(number);
        if (this.isNumberUsed(ctx, info)) {
            this.setNewNumber(ctx, info, iCodingRuleManager, customString);
        }
    }

    protected String _getNewNumber(Context ctx, IObjectValue model, String strCompanyID, String customString) throws BOSException, EASBizException {
        String strBindProp;
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        ProjectZyExBudgetBillInfo aSCMBillBaseInfo = (ProjectZyExBudgetBillInfo)model;
        String number = "";
        boolean isNumberNoSet = false;
        if (aSCMBillBaseInfo.getNumber() == null || aSCMBillBaseInfo.getNumber().length() == 0) {
            isNumberNoSet = true;
        }
        if ((strBindProp = this.getBindingProperty(ctx)) != null && strBindProp.trim().length() > 0) {
            number = iCodingRuleManager.getNumber((IObjectValue)aSCMBillBaseInfo, strCompanyID, strBindProp, customString);
            aSCMBillBaseInfo.setNumber(number);
        } else {
            number = iCodingRuleManager.getNumber((IObjectValue)aSCMBillBaseInfo, strCompanyID, customString);
            aSCMBillBaseInfo.setNumber(number);
        }
        ObjectUuidPK pk = new ObjectUuidPK(aSCMBillBaseInfo.getId());
        if (this.isSameNumber(ctx, (IObjectPK)pk, (IObjectValue)aSCMBillBaseInfo)) {
            String newNumber = "";
            newNumber = strBindProp != null && strBindProp.trim().length() > 0 ? iCodingRuleManager.getNumber((IObjectValue)aSCMBillBaseInfo, strCompanyID, strBindProp, customString) : iCodingRuleManager.getNumber((IObjectValue)aSCMBillBaseInfo, strCompanyID, customString);
            if (newNumber.equals(aSCMBillBaseInfo.getNumber())) {
                throw new CMBillException(CMBillException.NUMBERRULEERROR);
            }
            number = newNumber;
            aSCMBillBaseInfo.setNumber(newNumber);
            if (this.isSameNumber(ctx, (IObjectPK)pk, (IObjectValue)aSCMBillBaseInfo)) {
                return this._getNewNumber(ctx, (IObjectValue)aSCMBillBaseInfo, strCompanyID, customString);
            }
        }
        return number;
    }

    protected boolean isSameNumber(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        ProjectZyExBudgetBillInfo aSCMBillBaseInfo = (ProjectZyExBudgetBillInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)aSCMBillBaseInfo.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (aSCMBillBaseInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)aSCMBillBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (aSCMBillBaseInfo.getCU() != null) {
            filterItem = new FilterItemInfo("CU", (Object)aSCMBillBaseInfo.getCU().getId().toString(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        } else {
            filterItem = new FilterItemInfo("CU", null, CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (this.getBindingProperty(ctx) != null && this.getBindingProperty(ctx).trim().length() > 0 && aSCMBillBaseInfo.get(this.getBindingProperty(ctx)) != null) {
            filterItem = new FilterItemInfo(this.getBindingProperty(ctx), this.getBindingPropertyValue((CoreBillBaseInfo)aSCMBillBaseInfo), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < filter.getFilterItems().size(); ++i) {
            if (i != 0) {
                sb.append(" and #" + i);
                continue;
            }
            sb.append("#" + i);
        }
        filter.setMaskString(sb.toString());
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        return super._exists(ctx, filter);
    }

    protected String getBindingProperty(Context ctx) throws BOSException {
        return null;
    }

    protected Object getBindingPropertyValue(CoreBillBaseInfo aSCMBillBaseInfo) {
        return null;
    }
}

