/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.pcm.yearbudget.rpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.report.ReportHeader;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.base.report.app.ReportServerBase;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.industry.emm.common.EmmUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Locale;
import org.apache.log4j.Logger;

public class ZZFYSBBRptServer
extends ReportServerBase {
    private Logger logger = Logger.getLogger((String)((Object)((Object)this)).getClass().getName());
    private int year;
    private String[] projects;
    private String[] projectTypes;
    private String[] mebrBillNumbers;
    private String[][] strings;

    private String createTempTable() {
        StringBuffer sql = new StringBuffer();
        sql.append("create table tempTableX(");
        for (int i = 0; i < this.strings.length; ++i) {
            sql.append(this.strings[i][2] + " NUMERIC(28,2) default 0,");
        }
        sql.append("FExpenseTypeID varchar(44))");
        return sql.toString();
    }

    protected IRowSet getReportData(String s, RptParams rptparams) throws Exception {
        int i;
        this.setSort(new Boolean(true));
        this.setSortClickType(new Integer(2));
        this.initRptParams(rptparams);
        StringBuffer sql = new StringBuffer();
        sql.append(" select ad.fname_l2, b.CFRequestDeptID,ad.fnumber from CT_PCM_ManuExBudgetRequestBill b");
        sql.append(" inner join t_org_admin ad on ad.fid = b.CFRequestDeptID group by ad.fname_l2, b.CFRequestDeptID,ad.fnumber");
        IRowSet orgRs = DbUtil.executeQuery((Context)this.getContext(), (String)sql.toString());
        this.strings = new String[orgRs.size()][4];
        int i2 = 0;
        while (orgRs.next()) {
            this.strings[i2][0] = orgRs.getString("CFRequestDeptID");
            this.strings[i2][1] = orgRs.getString("fname_l2");
            this.strings[i2][2] = "row" + i2;
            this.strings[i2][3] = orgRs.getString("fnumber");
            ++i2;
        }
        String tmpTable = TempTablePool.getInstance((Context)this.getContext()).createTempTable(this.createTempTable());
        String rsTemp = TempTablePool.getInstance((Context)this.getContext()).createTempTable(this.createTempTable());
        sql.setLength(0);
        sql.append(" /*dialect*/ insert into " + rsTemp + " (FExpenseTypeID)");
        sql.append(" select fid");
        sql.append(" from CT_PCM_ProjectZzExpenseType");
        DbUtil.execute((Context)this.getContext(), (String)sql.toString());
        for (i = 0; i < this.strings.length; ++i) {
            sql.setLength(0);
            sql.append(" /*dialect*/ insert into " + tmpTable + "");
            sql.append(" (FExpenseTypeID," + this.strings[i][2] + ")");
            sql.append(" select e.cftypeid,sum(nvl(e.cfamount,0))");
            sql.append(" from CT_PCM_ManuExBudgetRequestBill b ");
            sql.append(" inner join CT_PCM_ManuEBRBE e on b.fid=e.fparentid");
            sql.append(" inner join t_org_admin ad on ad.fid=b.CFRequestDeptID");
            sql.append(" where b.cfyear=" + this.year);
            sql.append(" and b.cfstatus=4");
            sql.append(" and ad.fnumber='" + this.strings[i][3] + "'");
            sql.append(" and b.fbizdate=(select max(fbizdate) from CT_PCM_ManuExBudgetRequestBill bn   inner join t_org_admin adn on adn.fid=bn.CFRequestDeptID  where bn.cfyear=" + this.year + " and bn.cfstatus=4 and adn.fnumber = '" + this.strings[i][3] + "')");
            sql.append(this.getFilterSql());
            sql.append(" group by e.cftypeid");
            DbUtil.execute((Context)this.getContext(), (String)sql.toString());
            sql.setLength(0);
            sql.append("/*dialect*/ update " + rsTemp + " t set t." + this.strings[i][2] + "=(");
            sql.append(" select sum(t2." + this.strings[i][2] + ") from " + tmpTable + " t2 ");
            sql.append(" where t.FExpenseTypeID=t2.FExpenseTypeID");
            sql.append(" ) where t.FExpenseTypeID in (select FExpenseTypeID from " + tmpTable + ")");
            DbUtil.execute((Context)this.getContext(), (String)sql.toString());
        }
        sql.setLength(0);
        sql.append(" /*dialect*/ select ty.fnumber as FExpenseNumber,");
        for (i = 0; i < this.strings.length; ++i) {
            sql.append(this.strings[i][2] + ",");
        }
        sql.append(" ty.fname_l2 as FExpenseName from " + rsTemp + " t");
        sql.append(" inner join CT_PCM_ProjectZzExpenseType ty on t.FExpenseTypeID=ty.fid");
        sql.append(" order by ty.fnumber");
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)sql.toString());
        this.dropTempTable(s, rptparams, tmpTable);
        this.dropTempTable(s, rptparams, rsTemp);
        return rs;
    }

    private String getFilterSql() {
        StringBuffer sql = new StringBuffer();
        if (this.projects != null) {
            sql.append(" and pj.fnumber in (" + EmmUtils.getSqlFromArray((String[])this.projects) + ")");
        }
        if (this.projectTypes != null) {
            sql.append(" and pt.fnumber in (" + EmmUtils.getSqlFromArray((String[])this.projectTypes) + ")");
        }
        if (this.mebrBillNumbers != null) {
            sql.append(" and b.fnumber in (" + EmmUtils.getSqlFromArray((String[])this.mebrBillNumbers) + ")");
        }
        return sql.toString();
    }

    private void initRptParams(RptParams params) throws BOSException, SQLException {
        int i;
        String[] tmp;
        if (params.getObject("project") != null) {
            tmp = ((String)params.getObject("project")).split(";");
            this.projects = new String[tmp.length];
            for (i = 0; i < tmp.length; ++i) {
                this.projects[i] = tmp[i].trim();
            }
        } else {
            this.projects = null;
        }
        this.year = params.getObject("year") != null ? Integer.parseInt(params.getObject("year").toString()) : Calendar.getInstance().get(1);
        if (params.getObject("projectType") != null) {
            tmp = ((String)params.getObject("projectType")).split(";");
            this.projectTypes = new String[tmp.length];
            for (i = 0; i < tmp.length; ++i) {
                this.projectTypes[i] = tmp[i].trim();
            }
        } else {
            this.projectTypes = null;
        }
        if (params.getObject("mebrBillNumber") != null) {
            tmp = ((String)params.getObject("mebrBillNumber")).split(";");
            this.mebrBillNumbers = new String[tmp.length];
            for (i = 0; i < tmp.length; ++i) {
                this.mebrBillNumbers[i] = tmp[i].trim();
            }
        } else {
            this.mebrBillNumbers = null;
        }
    }

    protected ReportTitles getReportTitles(String s, RptParams rptparams) throws BaseException {
        ReportTitles title = new ReportTitles();
        title.AddTitle(1, this.year + EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.yearbudget.EMMPROJECTPcmYearbudgetResource", (String)"0EMMPcmYearbudget-0073", (Locale)this.getContext().getLocale()));
        title.AddTitle(5, EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.yearbudget.EMMPROJECTPcmYearbudgetResource", (String)"0EMMPcmYearbudget-0027", (Locale)this.getContext().getLocale()));
        return title;
    }

    protected ReportHeader getReportHeader(String reportID, RptParams filter) throws Exception {
        ReportHeader reportHeader = new ReportHeader();
        reportHeader.addChild("FExpenseNumber", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.yearbudget.EMMPROJECTPcmYearbudgetResource", (String)"0EMMPcmYearbudget-0074", (Locale)this.getContext().getLocale()));
        reportHeader.addChild("FExpenseName", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.yearbudget.EMMPROJECTPcmYearbudgetResource", (String)"0EMMPcmYearbudget-0075", (Locale)this.getContext().getLocale()));
        for (int i = 0; i < this.strings.length; ++i) {
            ReportHeader t = reportHeader.addChild(this.strings[i][2], this.strings[i][1]);
            t.setAlign(3);
        }
        return reportHeader;
    }
}

