/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.industry.emm.app.AbstractGetMaterialFromBOMFacadeControllerBean;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.util.IndustryUtils;
import com.kingdee.util.NumericExceptionSubItem;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import org.apache.log4j.Logger;

public class GetMaterialFromBOMFacadeControllerBean
extends AbstractGetMaterialFromBOMFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.industry.emm.app.GetMaterialFromBOMFacadeControllerBean");
    private String RESOURCE_NAME = "com.kingdee.eas.industry.emm.EMMSCMEMMBaseResource";
    private String SCM_BOMZKCC = EASResource.getString((String)this.RESOURCE_NAME, (String)"SCM_IDLXZHCW_LOG");

    @Override
    protected String _expandBOM4Material(Context ctx, String BOMID, String ProjectID, String TrackNumID, String expandType) throws BOSException, EASBizException {
        if (IndustryUtils.isEmptyString((String)expandType)) {
            return null;
        }
        if (IndustryUtils.isEmptyString((String)BOMID)) {
            return null;
        }
        TrackNumberInfo trackNumberInfo = null;
        if (TrackNumID != null && !"".equals(TrackNumID)) {
            try {
                trackNumberInfo = TrackNumberFactory.getLocalInstance((Context)ctx).getTrackNumberInfo((IObjectPK)new ObjectUuidPK(TrackNumID));
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
        }
        StringBuffer sql = new StringBuffer();
        String expandPBBTempTable = null;
        sql.setLength(0);
        try {
            expandPBBTempTable = this.createTempTable(ctx);
            int effectedRows = 0;
            int level = 0;
            int row = 0;
            while (level < 99) {
                sql.setLength(0);
                sql.append(this.getInsertExpandPBBTempTableSQL(expandPBBTempTable));
                sql.append("Select\r\n");
                if (level == 0) {
                    sql.append(" 0 FLevel,\r\n");
                    sql.append(" a.FStorageOrgUnitID FStorageOrgUnitID,\r\n");
                    sql.append(" a.FStorageOrgUnitID FSupplyStorageOrgUnitID,\r\n");
                    sql.append(" a.fprojectid FProjectID,\r\n");
                    sql.append(" a.FMaintenanceLevelID ,\r\n");
                    sql.append(" a.FdesignModeID ,\r\n");
                    if (TrackNumID == null || "".equals(TrackNumID)) {
                        sql.append(" Null As  FTrackNumberID,\r\n");
                    } else {
                        sql.append("'").append(TrackNumID).append("' As FTrackNumberID,\r\n");
                    }
                    sql.append(" a.fmaterialid As FMaterialID,\r\n");
                    sql.append(" isnull(mp.fmaterialattr,").append("10030").append(")").append(" As FMaterialAttribute \r\n");
                    sql.append(",Null");
                    sql.append(",0");
                    sql.append(" From t_mm_bom a \r\n");
                    sql.append(" left outer join t_bd_materialplan mp on mp.Fmaterialid = a.fmaterialid and mp.Forgunit = a.FStorageOrgUnitID \r\n");
                    sql.append(" WHERE a.fid = '" + BOMID + "'");
                } else {
                    sql.append(level).append(" FLevel,\r\n");
                    sql.append(" a.FStorageOrgUnitID FStorageOrgUnitID,\r\n");
                    sql.append(" b.fsupplystorageorgunitid FsupplyOrgid,\r\n");
                    sql.append(" a.fprojectid FProjectID,\r\n");
                    sql.append(" a.FMaintenanceLevelID ,\r\n");
                    sql.append(" a.FdesignModeID ,\r\n");
                    if (TrackNumID == null || "".equals(TrackNumID) || "NOTExpand".equals(TrackNumID)) {
                        sql.append(" Null As  FTrackNumberID,\r\n");
                    } else {
                        sql.append("'").append(TrackNumID).append("' As FTrackNumberID,\r\n");
                    }
                    sql.append("b.fmaterialid FMaterialID,\r\n");
                    sql.append(" b.fmaterialprop FMaterialAttribute \r\n");
                    sql.append(",a.FMaterialID\r\n");
                    sql.append(",b.FConsumeFixQty\r\n");
                    sql.append("From ").append(expandPBBTempTable).append(" T \r\n");
                    sql.append("Inner Join t_mm_bom a On  a.fmaterialid = T.FMaterialID and a.FStorageOrgUnitID = T.FSupplyStorageOrgUnitID \r\n");
                    sql.append("Inner Join t_mm_bomentry b On a.fid = b.fparentid \r\n");
                    sql.append("left outer Join t_mm_trackNumber bt on b.fbegincarnoid = bt.fid \r\n");
                    sql.append("left outer Join t_mm_trackNumber et on b.fendcarnoid = et.fid \r\n");
                    sql.append("");
                    sql.append("Where\r\n");
                    sql.append("T.FLevel=").append(level - 1).append("\r\n");
                    sql.append(" And a.fbasestatus = 4  \r\n");
                    sql.append(" And a.fdesignmodeid is not null  \r\n");
                    if (TrackNumID != null && !"".equals(TrackNumID) && trackNumberInfo != null) {
                        sql.append(" AND (((bt.fnumber <= '").append(trackNumberInfo.getNumber()).append("'\r\n");
                        sql.append(" AND et.fnumber >= '").append(trackNumberInfo.getNumber()).append("' ))\r\n");
                        sql.append(" or (b.fbegincarnoid is null and b.fendcarnoid is null )) \r\n");
                    }
                    if ("1".equals(expandType) && level >= 2) {
                        sql.append(" AND T.FMaterialAttribute = 10020 ");
                    }
                }
                effectedRows = this.executeSQL(ctx, sql.toString());
                row += effectedRows;
                if (effectedRows > 0 && (!"0".equals(expandType) || ++level != 2)) continue;
            }
            return expandPBBTempTable;
        }
        catch (Exception e) {
            e.printStackTrace();
            if (expandPBBTempTable != null && !"".equals(expandPBBTempTable)) {
                this.releaseTable(ctx, expandPBBTempTable);
            }
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)this.RESOURCE_NAME, (String)"SCM_IDLXZHCW_LOG", (Locale)ctx.getLocale()) + e.getMessage()));
        }
    }

    @Override
    protected void _releaseTable(Context ctx, String tableName) throws BOSException, EASBizException {
        TempTablePool.getInstance((Context)ctx).releaseTable(tableName);
    }

    protected int executeSQL(Context ctx, String sql) throws BOSException {
        Connection connection = null;
        Statement statement = null;
        try {
            connection = EJBFactory.getConnection((Context)ctx);
            statement = connection.createStatement();
            long startTime = System.currentTimeMillis();
            int effectedRows = statement.executeUpdate(sql);
            long endTime = System.currentTimeMillis();
            long duration = (endTime - startTime) / 1000L;
            System.out.println("Execute SQL Effected Rows " + effectedRows + " Duration " + duration + " Sec:\r\n" + sql.toString());
            int n = effectedRows;
            return n;
        }
        catch (SQLException e) {
            throw new BOSException(sql, (Throwable)e);
        }
        finally {
            if (connection != null && connection != null) {
                SQLUtils.cleanup((Statement)statement, (Connection)connection);
            }
        }
    }

    private String createTempTable(Context ctx) throws Exception {
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table DataNew ( ");
        sql.append("FLevel Int,\r\n");
        sql.append("FStorageOrgUnitID VARCHAR(44),\r\n");
        sql.append("FSupplyStorageOrgUnitID VARCHAR(44),\r\n");
        sql.append("FProjectID VARCHAR(44),\r\n");
        sql.append("FMaintenanceLevelID VARCHAR(44),\r\n");
        sql.append("FdesignModeID VARCHAR(44),\r\n");
        sql.append("FTrackNumberID VARCHAR(44),\r\n");
        sql.append("FMaterialID VARCHAR(44),\r\n");
        sql.append("FMaterialAttribute varchar(100), \r\n");
        sql.append("FQty NUMERIC(28, 10),\r\n");
        sql.append("FParentMaterialID varchar(44) );\r\n");
        return TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
    }

    protected String getInsertExpandPBBTempTableSQL(String expandPPBTempTableName) {
        StringBuffer sql = new StringBuffer();
        sql.append("Insert Into ").append(expandPPBTempTableName).append("(\r\n");
        sql.append("FLevel,\r\n");
        sql.append("FStorageOrgUnitID,\r\n");
        sql.append("FSupplyStorageOrgUnitID,\r\n");
        sql.append("FProjectID,\r\n");
        sql.append(" FMaintenanceLevelID ,\r\n");
        sql.append(" FdesignModeID ,\r\n");
        sql.append("FTrackNumberID,\r\n");
        sql.append("FMaterialID,\r\n");
        sql.append("FMaterialAttribute,\r\n");
        sql.append("FParentMaterialID ,\r\n");
        sql.append("FQty \r\n");
        sql.append(")\r\n");
        return sql.toString();
    }
}

