/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.common.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.IServiceManager;
import com.kingdee.bos.service.ServiceManagerFactory;
import com.kingdee.bos.service.binding.IServiceBinder;
import com.kingdee.bos.service.binding.ServiceBindItem;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerSaleInfoCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerSaleInfoFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerSupplierException;
import com.kingdee.eas.basedata.master.cssp.ICustomer;
import com.kingdee.eas.basedata.master.cssp.ICustomerCompanyInfo;
import com.kingdee.eas.basedata.master.cssp.ICustomerSaleInfo;
import com.kingdee.eas.basedata.master.cssp.ISupplier;
import com.kingdee.eas.basedata.master.cssp.ISupplierCompanyInfo;
import com.kingdee.eas.basedata.master.cssp.ISupplierPurchaseInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierPurchaseInfoCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierPurchaseInfoFactory;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.MaterialBaseException;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.IPurchaseOrgUnit;
import com.kingdee.eas.basedata.org.ISaleOrgUnit;
import com.kingdee.eas.basedata.org.IStorageOrgUnit;
import com.kingdee.eas.basedata.org.ITransportOrgUnit;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitCollection;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitFactory;
import com.kingdee.eas.basedata.org.SaleOrgUnitCollection;
import com.kingdee.eas.basedata.org.SaleOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.TransportOrgUnitCollection;
import com.kingdee.eas.basedata.org.TransportOrgUnitFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.ResponseContext;
import com.kingdee.eas.industry.emm.common.EMMBillException;
import com.kingdee.eas.industry.emm.common.service.SCMServiceFactory;
import com.kingdee.eas.industry.emm.common.util.SortUtil;
import com.kingdee.eas.industry.emm.common.util.StringUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public final class SCMGroupServerUtils {
    public static OrgUnitCollection getOrgsByRelation(Context ctx, OrgType srcOrgType, OrgType destOrgType, String orgPK) throws BOSException, EASBizException {
        IOrgUnitRelation iOrgRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        int iSrcOrg = srcOrgType.getValue();
        int iDestOrg = destOrgType.getValue();
        switch (iSrcOrg) {
            case 0: {
                return iDestOrg == 1 ? iOrgRelation.getToUnit(orgPK, iSrcOrg, iDestOrg) : iOrgRelation.getFromUnit(orgPK, iSrcOrg, iDestOrg);
            }
            case 1: {
                return iOrgRelation.getFromUnit(orgPK, iSrcOrg, iDestOrg);
            }
            case 2: {
                if (iDestOrg == 4) {
                    return iOrgRelation.getFromUnit(orgPK, iSrcOrg, iDestOrg);
                }
                if (iDestOrg == 3) {
                    return SCMGroupServerUtils.getSalePurchaseRelation(ctx, srcOrgType, destOrgType, orgPK);
                }
                return iOrgRelation.getToUnit(orgPK, iSrcOrg, iDestOrg);
            }
            case 3: {
                if (iDestOrg == 1 || iDestOrg == 32) {
                    return iOrgRelation.getToUnit(orgPK, iSrcOrg, iDestOrg);
                }
                if (iDestOrg == 2) {
                    return SCMGroupServerUtils.getSalePurchaseRelation(ctx, srcOrgType, destOrgType, orgPK);
                }
                return iOrgRelation.getFromUnit(orgPK, iSrcOrg, iDestOrg);
            }
            case 4: {
                return iOrgRelation.getToUnit(orgPK, iSrcOrg, iDestOrg);
            }
            case 24: {
                if (iDestOrg != 4) break;
                return iOrgRelation.getFromUnit(orgPK, iSrcOrg, iDestOrg);
            }
            case 32: {
                if (iDestOrg == 1) {
                    return iOrgRelation.getToUnit(orgPK, iSrcOrg, iDestOrg);
                }
                return iOrgRelation.getFromUnit(orgPK, iSrcOrg, iDestOrg);
            }
        }
        return null;
    }

    public static OrgUnitInfo getDefaultOrgsByRelation(Context ctx, OrgType srcOrgType, OrgType destOrgType, String orgPK) throws BOSException, EASBizException {
        OrgUnitInfo defaultOrg = null;
        if (srcOrgType.equals((Object)OrgType.Storage) && (destOrgType.equals((Object)OrgType.Purchase) || destOrgType.equals((Object)OrgType.Sale) || destOrgType.equals((Object)OrgType.Quality)) || srcOrgType.equals((Object)OrgType.Admin) && destOrgType.equals((Object)OrgType.Storage)) {
            IOrgUnitRelation iOrgRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
            defaultOrg = iOrgRelation.getDefaultToUnit(orgPK, srcOrgType.getValue(), destOrgType.getValue());
        }
        return defaultOrg;
    }

    private static OrgUnitCollection getSalePurchaseRelation(Context ctx, OrgType srcOrgType, OrgType destOrgType, String orgPK) throws BOSException, EASBizException {
        OrgUnitCollection resultOrgs = new OrgUnitCollection();
        OrgUnitCollection companyOrgs = SCMGroupServerUtils.getOrgsByRelation(ctx, srcOrgType, OrgType.Company, orgPK);
        if (companyOrgs != null && companyOrgs.size() > 0) {
            return SCMGroupServerUtils.getOrgsByRelation(ctx, OrgType.Company, destOrgType, companyOrgs.get(0).getId().toString());
        }
        return resultOrgs;
    }

    public static String getPermissionItem(Context context, IMetaDataPK pk) throws BOSException, EASBizException {
        IServiceManager manager = ServiceManagerFactory.getServiceManager();
        IServiceBinder binder = manager.getServiceBinder(context);
        ServiceBindItem[] bind = binder.getServiceBindings(MetaDataTypeList.BASEQUERY, pk);
        if (bind != null) {
            int len = bind.length;
            for (int i = 0; i < len; ++i) {
                String permItemName;
                if (bind[i].getType() != 0 || StringUtils.isEmpty((String)(permItemName = bind[i].getName()))) continue;
                return permItemName;
            }
        }
        return null;
    }

    public static OrgUnitCollection getAuthOrgByPermItem(Context context, OrgType orgType, String permItem) throws BOSException, EASBizException {
        FullOrgUnitInfo fullInfo = null;
        OrgUnitCollection collection = new OrgUnitCollection();
        IPermission permission = PermissionFactory.getLocalInstance((Context)context);
        if (orgType == null) {
            return null;
        }
        ObjectUuidPK treePK = new ObjectUuidPK(NewOrgViewHelper.convert2TreeId((OrgType)orgType));
        FullOrgUnitCollection result = permission.getAuthorizedOrg(context.getCaller(), orgType, (IObjectPK)treePK, permItem);
        for (int i = 0; i < result.size(); ++i) {
            fullInfo = result.get(i);
            collection.add((OrgUnitInfo)fullInfo);
        }
        return collection;
    }

    public static void validateMaterialInfo(Context ctx, OrgType orgType, String orgId, String[] materialIds) throws Exception {
        ResultSet resultSet;
        Statement statement;
        Connection con;
        block25: {
            FullOrgUnitInfo fullOrgUnitInfo = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectStringPK(orgId));
            con = null;
            statement = null;
            resultSet = null;
            StringBuffer sqlParams = new StringBuffer();
            int c = materialIds.length;
            for (int i = 0; i < c; ++i) {
                if (i > 0) {
                    sqlParams.append(",");
                }
                sqlParams.append("'");
                sqlParams.append(materialIds[i]);
                sqlParams.append("'");
            }
            try {
                String materialName;
                con = EJBFactory.getConnection((Context)ctx);
                statement = con.createStatement();
                IMaterial iMaterial = MaterialFactory.getLocalInstance((Context)ctx);
                ObjectUuidPK pk = new ObjectUuidPK(fullOrgUnitInfo.getCU().getId().toString());
                FilterInfo filterInfo = iMaterial.getDatabaseDFilter((IObjectPK)pk, "FID", "FAdminCUID");
                StringBuffer materialBuffer = new StringBuffer();
                materialBuffer.append(" select fid,fname_").append(SysContext.getSysContext().getLocale()).append(" from ").append(" T_BD_Material ").append(" where fid in(").append(sqlParams.toString()).append(")").append(" and ").append(filterInfo.toString());
                resultSet = statement.executeQuery(materialBuffer.toString());
                StringBuffer noFitMaterialNameBuffer = new StringBuffer();
                while (resultSet.next()) {
                    String materialName2 = resultSet.getString(2);
                    String id = resultSet.getString(1);
                    if (sqlParams.indexOf(id) >= 0) continue;
                    if (noFitMaterialNameBuffer.length() > 0) {
                        noFitMaterialNameBuffer.append(",");
                    }
                    noFitMaterialNameBuffer.append(materialName2);
                }
                if (noFitMaterialNameBuffer.length() > 0) {
                    throw new MaterialBaseException(MaterialBaseException.ORGVIEWMATERIALFORBIDEN, (Object[])new String[]{noFitMaterialNameBuffer.toString()});
                }
                if (orgType.equals((Object)OrgType.Company)) {
                    StringBuffer companyBuffer = new StringBuffer();
                    companyBuffer.append(" select material.fid,material.fname_").append(SysContext.getSysContext().getLocale()).append(" from ").append(" T_BD_Material material").append(" inner join T_BD_MaterialCompanyInfo companyInfo on material.FID = companyInfo.FMaterial").append(" where material.FID in(").append(sqlParams.toString()).append(")").append(" and companyInfo.FCompanyID in ('").append(orgId).append("'").append(",'").append(fullOrgUnitInfo.getCU().getId().toString()).append("')");
                    resultSet = statement.executeQuery(companyBuffer.toString());
                    noFitMaterialNameBuffer = new StringBuffer();
                    while (resultSet.next()) {
                        materialName = resultSet.getString(2);
                        String id = resultSet.getString(1);
                        if (sqlParams.indexOf(id) >= 0) continue;
                        if (noFitMaterialNameBuffer.length() > 0) {
                            noFitMaterialNameBuffer.append(",");
                        }
                        noFitMaterialNameBuffer.append(materialName);
                    }
                    if (noFitMaterialNameBuffer.length() > 0) {
                        throw new MaterialBaseException(MaterialBaseException.ORGNOTMAINTAINMATEIALCOMPANY, (Object[])new String[]{noFitMaterialNameBuffer.toString()});
                    }
                    break block25;
                }
                if (orgType.equals((Object)OrgType.Purchase)) {
                    StringBuffer purchaseBuffer = new StringBuffer();
                    purchaseBuffer.append(" select material.fid,material.fname_").append(SysContext.getSysContext().getLocale()).append(" from ").append(" T_BD_Material material").append(" inner join T_BD_MaterialPurchasing purchaseInfo on material.FID = purchaseInfo.FMaterialID").append(" where material.FID in(").append(sqlParams.toString()).append(")").append(" and purchaseInfo.FOrgUnit in ('").append(orgId).append("'").append(",'").append(fullOrgUnitInfo.getCU().getId().toString()).append("')");
                    resultSet = statement.executeQuery(purchaseBuffer.toString());
                    noFitMaterialNameBuffer = new StringBuffer();
                    while (resultSet.next()) {
                        materialName = resultSet.getString(2);
                        String id = resultSet.getString(1);
                        if (sqlParams.indexOf(id) >= 0) continue;
                        if (noFitMaterialNameBuffer.length() > 0) {
                            noFitMaterialNameBuffer.append(",");
                        }
                        noFitMaterialNameBuffer.append(materialName);
                    }
                    if (noFitMaterialNameBuffer.length() > 0) {
                        throw new MaterialBaseException(MaterialBaseException.ORGNOTMAINTAINMATEIALPURCHASE, (Object[])new String[]{noFitMaterialNameBuffer.toString()});
                    }
                    break block25;
                }
                if (orgType.equals((Object)OrgType.Sale)) {
                    StringBuffer saleBuffer = new StringBuffer();
                    saleBuffer.append(" select material.fid,material.fname_").append(SysContext.getSysContext().getLocale()).append(" from ").append(" T_BD_Material material").append(" inner join T_BD_MaterialSales saleInfo on material.FID = saleInfo.FMaterialID").append(" where material.FID in(").append(sqlParams.toString()).append(")").append(" and saleInfo.FOrgUnit in ('").append(orgId).append("'").append(",'").append(fullOrgUnitInfo.getCU().getId().toString()).append("')");
                    resultSet = statement.executeQuery(saleBuffer.toString());
                    noFitMaterialNameBuffer = new StringBuffer();
                    while (resultSet.next()) {
                        materialName = resultSet.getString(2);
                        String id = resultSet.getString(1);
                        if (sqlParams.indexOf(id) >= 0) continue;
                        if (noFitMaterialNameBuffer.length() > 0) {
                            noFitMaterialNameBuffer.append(",");
                        }
                        noFitMaterialNameBuffer.append(materialName);
                    }
                    if (noFitMaterialNameBuffer.length() > 0) {
                        throw new MaterialBaseException(MaterialBaseException.ORGNOTMAINTAINMATEIALSALE, (Object[])new String[]{noFitMaterialNameBuffer.toString()});
                    }
                    break block25;
                }
                if (orgType.equals((Object)OrgType.Storage)) {
                    StringBuffer inventoryBuffer = new StringBuffer();
                    inventoryBuffer.append(" select material.fid,material.fname_").append(SysContext.getSysContext().getLocale()).append(" from ").append(" T_BD_Material material").append(" inner join T_BD_MaterialInventory inventory on material.FID = inventory.FMaterialID").append(" where material.FID in(").append(sqlParams.toString()).append(")").append(" and inventory.FOrgUnit in ('").append(orgId).append("'").append(",'").append(fullOrgUnitInfo.getCU().getId().toString()).append("')");
                    resultSet = statement.executeQuery(inventoryBuffer.toString());
                    noFitMaterialNameBuffer = new StringBuffer();
                    while (resultSet.next()) {
                        materialName = resultSet.getString(2);
                        String id = resultSet.getString(1);
                        if (sqlParams.indexOf(id) >= 0) continue;
                        if (noFitMaterialNameBuffer.length() > 0) {
                            noFitMaterialNameBuffer.append(",");
                        }
                        noFitMaterialNameBuffer.append(materialName);
                    }
                    if (noFitMaterialNameBuffer.length() > 0) {
                        throw new MaterialBaseException(MaterialBaseException.ORGNOTMAINTAINMATEIALINVENTARY, (Object[])new String[]{noFitMaterialNameBuffer.toString()});
                    }
                    break block25;
                }
                throw new EMMBillException(EMMBillException.ORGTYPEERROE);
            }
            catch (SQLException e) {
                try {
                    throw new Exception(e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(resultSet);
                    SQLUtils.cleanup((Statement)statement, (Connection)con);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)resultSet);
        SQLUtils.cleanup((Statement)statement, (Connection)con);
    }

    public static void validateSupplierInfo(Context ctx, OrgType orgType, String orgId, String supplierId) throws Exception {
        SupplierCollection supplierCollection;
        FullOrgUnitInfo fullOrgUnitInfo = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectStringPK(orgId));
        EntityViewInfo view = new EntityViewInfo();
        ISupplier iSupplier = SupplierFactory.getLocalInstance((Context)ctx);
        ObjectUuidPK pk = new ObjectUuidPK(fullOrgUnitInfo.getCU().getId().toString());
        view.setFilter(new FilterInfo());
        view.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)supplierId, CompareType.EQUALS));
        view.getFilter().getFilterItems().add(new FilterItemInfo("adminCU", (Object)pk.toString(), CompareType.EQUALS));
        FilterInfo filterInfo = iSupplier.getDatabaseDFilter((IObjectPK)pk, "id", "adminCU.id");
        if (filterInfo != null && filterInfo.getFilterItems().size() > 0) {
            view.getFilter().mergeFilter(filterInfo, "and");
        }
        if ((supplierCollection = iSupplier.getSupplierCollection(view)) == null || supplierCollection.size() <= 0) {
            throw new CustomerSupplierException(CustomerSupplierException.ORGVIEWSUPPLIERFORBIDDEN);
        }
        if (orgType.equals((Object)OrgType.Company)) {
            ISupplierCompanyInfo iSupplierCompany = SupplierCompanyInfoFactory.getLocalInstance((Context)ctx);
            view.getFilter().getFilterItems().add(new FilterItemInfo("supplier", (Object)supplierId, CompareType.EQUALS));
            view.getFilter().getFilterItems().add(new FilterItemInfo("companyOrgUnit", (Object)orgId, CompareType.EQUALS));
            view.getFilter().getFilterItems().add(new FilterItemInfo("companyOrgUnit", (Object)fullOrgUnitInfo.getCU().getId().toString(), CompareType.EQUALS));
            view.getFilter().setMaskString("#0 and (#1 or #2)");
            SupplierCompanyInfoCollection companyCollection = iSupplierCompany.getSupplierCompanyInfoCollection(view);
            if (companyCollection == null || companyCollection.size() <= 0) {
                throw new CustomerSupplierException(CustomerSupplierException.ORGNOTMAINTAINSUPPLIERCOMPANY);
            }
        } else if (orgType.equals((Object)OrgType.Purchase)) {
            ISupplierPurchaseInfo iSupplierPurchase = SupplierPurchaseInfoFactory.getLocalInstance((Context)ctx);
            view.getFilter().getFilterItems().add(new FilterItemInfo("supplier", (Object)supplierId, CompareType.EQUALS));
            view.getFilter().getFilterItems().add(new FilterItemInfo("purchaseOrgUnit", (Object)orgId, CompareType.EQUALS));
            view.getFilter().getFilterItems().add(new FilterItemInfo("purchaseOrgUnit", (Object)fullOrgUnitInfo.getCU().getId().toString(), CompareType.EQUALS));
            view.getFilter().setMaskString("#0 and (#1 or #2)");
            SupplierPurchaseInfoCollection purchaseCollection = iSupplierPurchase.getSupplierPurchaseInfoCollection(view);
            if (purchaseCollection == null || purchaseCollection.size() <= 0) {
                throw new CustomerSupplierException(CustomerSupplierException.ORGNOTMAINTAINSUPPLIERPURCHASE);
            }
        } else {
            throw new EMMBillException(EMMBillException.ORGTYPEERROE);
        }
    }

    public static void validateCustomerInfo(Context ctx, OrgType orgType, String orgId, String customerId) throws Exception {
        CustomerCollection customerCollection;
        FullOrgUnitInfo fullOrgUnitInfo = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectStringPK(orgId));
        EntityViewInfo view = new EntityViewInfo();
        ICustomer iCustomer = CustomerFactory.getLocalInstance((Context)ctx);
        ObjectUuidPK pk = new ObjectUuidPK(fullOrgUnitInfo.getCU().getId().toString());
        view.setFilter(new FilterInfo());
        view.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)customerId, CompareType.EQUALS));
        view.getFilter().getFilterItems().add(new FilterItemInfo("adminCU", (Object)pk.toString(), CompareType.EQUALS));
        FilterInfo filterInfo = iCustomer.getDatabaseDFilter((IObjectPK)pk, "id", "adminCU.id");
        if (filterInfo != null && filterInfo.getFilterItems().size() > 0) {
            view.getFilter().mergeFilter(filterInfo, "and");
        }
        if ((customerCollection = iCustomer.getCustomerCollection(view)) == null || customerCollection.size() <= 0) {
            throw new CustomerSupplierException(CustomerSupplierException.ORGVIEWCUSTOMERFORBIDDEN);
        }
        if (orgType.equals((Object)OrgType.Company)) {
            ICustomerCompanyInfo iCustomerCompany = CustomerCompanyInfoFactory.getLocalInstance((Context)ctx);
            view.getFilter().getFilterItems().add(new FilterItemInfo("customer", (Object)customerId, CompareType.EQUALS));
            view.getFilter().getFilterItems().add(new FilterItemInfo("companyOrgUnit", (Object)orgId, CompareType.EQUALS));
            view.getFilter().getFilterItems().add(new FilterItemInfo("companyOrgUnit", (Object)fullOrgUnitInfo.getCU().getId().toString(), CompareType.EQUALS));
            view.getFilter().setMaskString("#0 and (#1 or #2)");
            CustomerCompanyInfoCollection companyCollection = iCustomerCompany.getCustomerCompanyInfoCollection(view);
            if (companyCollection == null || companyCollection.size() <= 0) {
                throw new CustomerSupplierException(CustomerSupplierException.ORGNOTMAINTAINCUSTOMERCOMPANY);
            }
        } else if (orgType.equals((Object)OrgType.Sale)) {
            ICustomerSaleInfo iCustomerSale = CustomerSaleInfoFactory.getLocalInstance((Context)ctx);
            view.getFilter().getFilterItems().add(new FilterItemInfo("customer", (Object)customerId, CompareType.EQUALS));
            view.getFilter().getFilterItems().add(new FilterItemInfo("saleOrgUnit", (Object)orgId, CompareType.EQUALS));
            view.getFilter().getFilterItems().add(new FilterItemInfo("saleOrgUnit", (Object)fullOrgUnitInfo.getCU().getId().toString(), CompareType.EQUALS));
            view.getFilter().setMaskString("#0 and (#1 or #2)");
            CustomerSaleInfoCollection saleCollection = iCustomerSale.getCustomerSaleInfoCollection(view);
            if (saleCollection == null || saleCollection.size() <= 0) {
                throw new CustomerSupplierException(CustomerSupplierException.ORGNOTMAINTAINCUSTOMERSALE);
            }
        } else {
            throw new EMMBillException(EMMBillException.ORGTYPEERROE);
        }
    }

    public static OrgUnitCollection getOrgUnitInfosByType(Context ctx, OrgUnitCollection orgs, OrgType orgType) {
        OrgUnitCollection results = new OrgUnitCollection();
        if (orgs == null || orgs.size() == 0) {
            return null;
        }
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        for (int i = 0; i < orgs.size(); ++i) {
            keys.add(orgs.get(i).getId().toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", keys, CompareType.INCLUDE));
        if (!orgType.equals((Object)OrgType.Admin)) {
            filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)new Boolean(true), CompareType.EQUALS));
        }
        view.setFilter(filter);
        try {
            switch (orgType.getValue()) {
                case 0: {
                    IAdminOrgUnit iAdmin = AdminOrgUnitFactory.getLocalInstance((Context)ctx);
                    AdminOrgUnitCollection collection = iAdmin.getAdminOrgUnitCollection(view);
                    if (collection != null && collection.size() > 0) {
                        for (int i = 0; i < collection.size(); ++i) {
                            results.add((OrgUnitInfo)collection.get(i));
                        }
                    }
                    return results;
                }
                case 1: {
                    ICompanyOrgUnit iCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
                    CompanyOrgUnitCollection collection = iCompany.getCompanyOrgUnitCollection(view);
                    if (collection != null && collection.size() > 0) {
                        for (int i = 0; i < collection.size(); ++i) {
                            results.add((OrgUnitInfo)collection.get(i));
                        }
                    }
                    return results;
                }
                case 2: {
                    ISaleOrgUnit iSale = SaleOrgUnitFactory.getLocalInstance((Context)ctx);
                    SaleOrgUnitCollection collection = iSale.getSaleOrgUnitCollection(view);
                    if (collection != null && collection.size() > 0) {
                        for (int i = 0; i < collection.size(); ++i) {
                            results.add((OrgUnitInfo)collection.get(i));
                        }
                    }
                    return results;
                }
                case 3: {
                    IPurchaseOrgUnit iPurchase = PurchaseOrgUnitFactory.getLocalInstance((Context)ctx);
                    PurchaseOrgUnitCollection collection = iPurchase.getPurchaseOrgUnitCollection(view);
                    if (collection != null && collection.size() > 0) {
                        for (int i = 0; i < collection.size(); ++i) {
                            results.add((OrgUnitInfo)collection.get(i));
                        }
                    }
                    return results;
                }
                case 4: {
                    IStorageOrgUnit iStorage = StorageOrgUnitFactory.getLocalInstance((Context)ctx);
                    StorageOrgUnitCollection collection = iStorage.getStorageOrgUnitCollection(view);
                    if (collection != null && collection.size() > 0) {
                        for (int i = 0; i < collection.size(); ++i) {
                            results.add((OrgUnitInfo)collection.get(i));
                        }
                    }
                    return results;
                }
                case 24: {
                    ITransportOrgUnit iTransport = TransportOrgUnitFactory.getLocalInstance((Context)ctx);
                    TransportOrgUnitCollection collection = iTransport.getTransportOrgUnitCollection(view);
                    if (collection != null && collection.size() > 0) {
                        for (int i = 0; i < collection.size(); ++i) {
                            results.add((OrgUnitInfo)collection.get(i));
                        }
                    }
                    return results;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static OrgUnitInfo getDefaultMainBizOrg(RequestContext request, ResponseContext response, Context context) throws EASBizException, BOSException {
        String loginOrgId;
        OrgUnitInfo mainOrg = (OrgUnitInfo)request.get("_SCMMAINORG");
        if (mainOrg != null) {
            return mainOrg;
        }
        OrgUnitInfo[] mainOrgs = SCMServiceFactory.getLocalInstance(context).getAuthorizedBizOrgUnits(request.getUserPK(), (OrgType)request.get("_SCMMAINORGTYPE"), (String)request.get("_SCMPERMISSIONITEM"));
        if (mainOrgs == null || mainOrgs.length == 0) {
            return null;
        }
        String string = loginOrgId = request.getOrg() != null ? request.getOrg().toString() : null;
        if (loginOrgId != null) {
            for (int i = 0; i < mainOrgs.length; ++i) {
                if (!loginOrgId.equals(mainOrgs[i].getId().toString())) continue;
                return mainOrgs[i];
            }
        }
        mainOrgs = (OrgUnitInfo[])SortUtil.sortDataByNumber((DataBaseInfo[])mainOrgs, true);
        return mainOrgs[0];
    }

    public static OrgUnitInfo[] getOrgUnitInfos(Context context, String ids) {
        try {
            IFullOrgUnit iOrgUnit = FullOrgUnitFactory.getLocalInstance((Context)context);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)StringUtil.getKeyIdList(ids), CompareType.INCLUDE));
            view.setFilter(filter);
            FullOrgUnitCollection collection = iOrgUnit.getFullOrgUnitCollection(view);
            OrgUnitInfo[] results = new OrgUnitInfo[collection.size()];
            for (int i = 0; i < collection.size(); ++i) {
                results[i] = collection.get(i);
            }
            return results;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Map getOrgUnitInfos(Context context, Set ids) {
        try {
            IFullOrgUnit iOrgUnit = FullOrgUnitFactory.getLocalInstance((Context)context);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
            view.setFilter(filter);
            FullOrgUnitCollection collection = iOrgUnit.getFullOrgUnitCollection(view);
            HashMap<String, FullOrgUnitInfo> orgInfos = new HashMap<String, FullOrgUnitInfo>();
            FullOrgUnitInfo info = null;
            for (int i = 0; i < collection.size(); ++i) {
                info = collection.get(i);
                orgInfos.put(info.getId().toString(), info);
            }
            return orgInfos;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Map getOrgUnitInfos(Context context, String[] ids) {
        if (ids == null) {
            return null;
        }
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < ids.length; ++i) {
            set.add(ids[i]);
        }
        return SCMGroupServerUtils.getOrgUnitInfos(context, set);
    }
}

