/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.qm.qc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.IBOTMapping;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.syncdatabase.InterfaceDataBaseException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.industry.emm.qm.qc.AuditFlagEnum;
import com.kingdee.eas.industry.emm.qm.qc.EMMNCRBizException;
import com.kingdee.eas.industry.emm.qm.qc.NCRAuditerFactory;
import com.kingdee.eas.industry.emm.qm.qc.NCRAuditerInfo;
import com.kingdee.eas.industry.emm.qm.qc.NCRQcBillEntryCollection;
import com.kingdee.eas.industry.emm.qm.qc.NCRQcBillEntryInfo;
import com.kingdee.eas.industry.emm.qm.qc.NCRQcBillInfo;
import com.kingdee.eas.industry.emm.qm.qc.NCRreportCollection;
import com.kingdee.eas.industry.emm.qm.qc.NCRreportFactory;
import com.kingdee.eas.industry.emm.qm.qc.NCRreportInfo;
import com.kingdee.eas.industry.emm.qm.qc.app.AbstractNCRQcBillControllerBean;
import com.kingdee.eas.industry.webservice.ncr.Ncr_servicePortTypeProxy;
import com.kingdee.eas.industry.webservice.ncr.xsd.EasNcrlistVO;
import com.kingdee.eas.industry.webservice.ncr.xsd.EasNcrlistdetailVO;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class NCRQcBillControllerBean
extends AbstractNCRQcBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.industry.emm.qm.qc.app.NCRQcBillControllerBean");
    private String RESOURCE_NAME = "com.kingdee.eas.industry.emm.qm.qc.NCRBizResource";

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK pk = super._submit(ctx, model);
        this.afterSubmitNCR(ctx, model);
        return pk;
    }

    protected void afterSubmitNCR(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        UserInfo userInfo = (UserInfo)ctx.get((Object)"UserInfo");
        PersonInfo personInfo = userInfo.getPerson();
        if (personInfo == null) {
            NumericExceptionSubItem interfaceException = new NumericExceptionSubItem("", EASResource.getString((String)this.RESOURCE_NAME, (String)"SCM_DQYHBSYZY", (Locale)ctx.getLocale()));
            throw new InterfaceDataBaseException(interfaceException);
        }
        NCRQcBillInfo ncrQcBillInfo = (NCRQcBillInfo)model;
        NCRreportCollection ncrReportColl = NCRreportFactory.getLocalInstance(ctx).getNCRreportCollection("Where sourceBillId = '" + ncrQcBillInfo.getId().toString() + "'");
        if (ncrReportColl.size() <= 0) {
            IBOTMapping botFactory = BOTMappingFactory.getLocalInstance((Context)ctx);
            BOTMappingInfo botInfo = null;
            BOTMappingCollection botCol = botFactory.getBOTMappingCollection("where name='NCRQCTONCR' and extRule.isEffected=1 ");
            if (botCol.size() != 1) {
                throw new EMMNCRBizException(EMMNCRBizException.NOFINDBOTP, new Object[]{"NCRQCTONCR"});
            }
            botInfo = botCol.get(0);
            if (botInfo != null) {
                IBTPManager btp = BTPManagerFactory.getLocalInstance((Context)ctx);
                BTPTransformResult result = null;
                result = btp.transform((CoreBillBaseInfo)ncrQcBillInfo, botInfo);
                if (result.getBills().size() <= 0) {
                    return;
                }
                BOTRelationCollection relations = result.getBOTRelationCollection();
                Map map = this.getMapByRelation(relations);
                for (int i = 0; i < result.getBills().size(); ++i) {
                    IObjectValue destBillInfo = result.getBills().getObject(i);
                    NCRreportInfo ncrReportInfo = (NCRreportInfo)destBillInfo;
                    BOTRelationCollection botrelationcollection = (BOTRelationCollection)map.get(ncrReportInfo.getId().toString());
                    btp.saveRelations((CoreBillBaseInfo)ncrReportInfo, botrelationcollection);
                    ObjectUuidPK pk = new ObjectUuidPK(ncrReportInfo.getId());
                    ncrReportInfo.setBaseStatus(BillBaseStatusEnum.EDITED);
                    NCRreportFactory.getLocalInstance(ctx).update((IObjectPK)pk, ncrReportInfo);
                    if (ncrReportInfo.getTransType().isIsAudit()) {
                        NCRAuditerInfo ncrAuditerInfo = new NCRAuditerInfo();
                        ncrAuditerInfo.setNcrReport(ncrReportInfo);
                        ncrAuditerInfo.setAuditer(personInfo);
                        ncrAuditerInfo.setAuditFlag(AuditFlagEnum.AUDITE);
                        ncrAuditerInfo.setIsPass(true);
                        ncrAuditerInfo.setAuditeDate(new Timestamp(new Date().getTime()));
                        NCRAuditerFactory.getLocalInstance(ctx).save((CoreBaseInfo)ncrAuditerInfo);
                    }
                    NCRreportFactory.getLocalInstance(ctx).submit((CoreBaseInfo)ncrReportInfo);
                    this.tranFracasSystemNCRreport(ctx, ncrQcBillInfo);
                }
            }
        }
    }

    protected void tranFracasSystemNCRreport(Context ctx, NCRQcBillInfo ncrQcBillInfo) throws BOSException, EASBizException {
        try {
            Ncr_servicePortTypeProxy proxy = new Ncr_servicePortTypeProxy();
            EasNcrlistVO vo = new EasNcrlistVO();
            vo.setAuditingtype(ncrQcBillInfo.getTransType().getName());
            vo.setOccuredate(Constants.FORMAT_DAY.format(ncrQcBillInfo.getBizDate()));
            vo.setQuantity(ncrQcBillInfo.getUnPassQty().intValue());
            BigDecimal qcQty = ncrQcBillInfo.getQcQty();
            if (qcQty == null) {
                qcQty = BigDecimal.ZERO;
            }
            vo.setCheckquantity(qcQty.intValue());
            vo.setBatchno(ncrQcBillInfo.getManuLot());
            BigDecimal qcLotQty = ncrQcBillInfo.getQcLotQty();
            if (qcLotQty == null) {
                qcLotQty = BigDecimal.ZERO;
            }
            vo.setBatchquantity(qcLotQty.intValue());
            vo.setInvent_code(ncrQcBillInfo.getMaterial().getNumber());
            vo.setInvent_name(ncrQcBillInfo.getMaterial().getName());
            vo.setM_pk_projectnum(ncrQcBillInfo.getProject().getNumber());
            vo.setProject_code(ncrQcBillInfo.getProject().getNumber());
            vo.setProject_name(ncrQcBillInfo.getProject().getName());
            if (ncrQcBillInfo.getCheckUer() != null) {
                vo.setInspector_code(ncrQcBillInfo.getCheckUer().getNumber());
                vo.setInspector_name(ncrQcBillInfo.getCheckUer().getName());
            }
            if (ncrQcBillInfo.getOccurDept() != null) {
                vo.setFoundorg_code(ncrQcBillInfo.getOccurDept().getNumber());
                vo.setFoundorg_name(ncrQcBillInfo.getOccurDept().getName());
            }
            if (ncrQcBillInfo.getStandardRooting() != null) {
                vo.setProcessroute_code(ncrQcBillInfo.getStandardRooting().getNumber());
                vo.setProcessroute_name(ncrQcBillInfo.getStandardRooting().getName());
            }
            if (ncrQcBillInfo.getWorkCenter() != null) {
                vo.setWorkcenter_code(ncrQcBillInfo.getWorkCenter().getNumber());
                vo.setWorkcenter_name(ncrQcBillInfo.getWorkCenter().getName());
            }
            if (ncrQcBillInfo.getOperation() != null) {
                vo.setProcedure_code(ncrQcBillInfo.getOperation().getNumber());
                vo.setProcedure_name(ncrQcBillInfo.getOperation().getName());
            }
            if (ncrQcBillInfo.getSupplier() != null) {
                vo.setSupplier_code(ncrQcBillInfo.getSupplier().getNumber());
                vo.setSupplier_name(ncrQcBillInfo.getSupplier().getName());
            }
            if (ncrQcBillInfo.getClassGroup() != null) {
                vo.setProduceteam(ncrQcBillInfo.getClassGroup().getName());
            }
            vo.setOrderid(ncrQcBillInfo.getNumber());
            vo.setEas_ncrid(ncrQcBillInfo.getId().toString());
            NCRQcBillEntryCollection ncrQcEntryColl = ncrQcBillInfo.getEntry();
            EasNcrlistdetailVO[] details = new EasNcrlistdetailVO[ncrQcEntryColl.size()];
            for (int i = 0; i < ncrQcEntryColl.size(); ++i) {
                NCRQcBillEntryInfo ncrEntryInfo = ncrQcEntryColl.get(i);
                EasNcrlistdetailVO dvo = new EasNcrlistdetailVO();
                dvo.setCharsort(ncrEntryInfo.getUnPassItem().getAlias());
                dvo.setNcrdesc(ncrEntryInfo.getUnPassDesc());
                dvo.setQuantity(ncrEntryInfo.getUnPassItemQty().intValue());
                details[i] = dvo;
            }
            vo.setDetailvo(details);
            String[] msg = proxy.insertNcrlist(vo);
            if (msg[0].equals("N")) {
                throw new BOSException("Fracas" + msg[1]);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public Map getMapByRelation(BOTRelationCollection relations) {
        HashMap<String, BOTRelationCollection> map = new HashMap<String, BOTRelationCollection>();
        for (int i = 0; i < relations.size(); ++i) {
            BOTRelationCollection botrelationcollection;
            BOTRelationInfo relationInfo = relations.get(i);
            String oid = relationInfo.getDestObjectID();
            if (map.get(oid) != null) {
                botrelationcollection = (BOTRelationCollection)map.get(oid);
                botrelationcollection.add(relationInfo);
                map.put(oid, botrelationcollection);
                continue;
            }
            botrelationcollection = new BOTRelationCollection();
            botrelationcollection.add(relationInfo);
            map.put(oid, botrelationcollection);
        }
        return map;
    }

    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        super._passAudit(ctx, pk, model);
        this.updateAuditStatus(ctx, model);
    }
}

