/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.qm.qc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.sm.pur.IPurOrderEntry;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurReturnsEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurReturnsEntryFactory;
import com.kingdee.eas.scm.sm.pur.PurReturnsEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurReturnsInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Locale;

public class PurReturnsApprovePurOrderProcessor
extends AbstractBusinessProcessor {
    private String RESOURCE_NAME = "com.kingdee.eas.industry.emm.qm.qc.NCRBizResource";

    public PurReturnsApprovePurOrderProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public PurReturnsApprovePurOrderProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    public PurReturnsApprovePurOrderProcessor(ProcessorConstructParam param) {
        super(param);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        IObjectCollection objCol = batchResults.getObjCollection();
        for (int n = 0; n < objCol.size(); ++n) {
            PurReturnsInfo purReturnsInfo = (PurReturnsInfo)objCol.getObject(n);
            BillTypeInfo billTypeInfo = purReturnsInfo.getSourceBillType();
            if (billTypeInfo == null || !"EJEsRRHOSHihY7IVuv7KHUY+1VI=".equals(purReturnsInfo.getSourceBillType().getId().toString())) continue;
            PurReturnsEntryCollection PurReturnsEntryColls = this.getPurReturnsEntryColls(purReturnsInfo.getId().toString());
            int size = PurReturnsEntryColls.size();
            if (size > 0) {
                for (int i = 0; i < size; ++i) {
                    PurReturnsEntryInfo purReturnsEntryInfo = PurReturnsEntryColls.get(i);
                    BigDecimal purReturnsQty = purReturnsEntryInfo.getQty();
                    String PurOrderEntryId = this.getPurOrderEntryIdByPurReturnsEntryId(purReturnsEntryInfo.getId().toString());
                    if (PurOrderEntryId == null) continue;
                    if (this.batchAction.equals((Object)BatchActionEnum.AUDIT)) {
                        this.writeBackPurOrder(PurOrderEntryId, purReturnsQty, true);
                    }
                    if (!this.batchAction.equals((Object)BatchActionEnum.UNAUDIT)) continue;
                    this.writeBackPurOrder(PurOrderEntryId, purReturnsQty, false);
                }
                continue;
            }
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)this.RESOURCE_NAME, (String)"SCM_HQCGTHSQDFLWK", (Locale)this.ctx.getLocale())));
        }
    }

    private PurReturnsEntryCollection getPurReturnsEntryColls(String PurReturnsId) throws BOSException {
        EntityViewInfo paramEntityViewInfo = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        paramEntityViewInfo.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)PurReturnsId, CompareType.EQUALS));
        paramEntityViewInfo.setFilter(filter);
        return PurReturnsEntryFactory.getLocalInstance((Context)this.ctx).getPurReturnsEntryCollection(paramEntityViewInfo);
    }

    private void writeBackPurOrder(String purOrderEntryId, BigDecimal purReturnsQty, boolean isAdd) throws BOSException, EASBizException {
        IPurOrderEntry iPurOrderEntry = PurOrderEntryFactory.getLocalInstance((Context)this.ctx);
        PurOrderEntryInfo purOrderEntryInfo = iPurOrderEntry.getPurOrderEntryInfo((IObjectPK)new ObjectUuidPK(purOrderEntryId));
        BigDecimal oldQty = purOrderEntryInfo.getTotalReturnedQty();
        if (isAdd) {
            purOrderEntryInfo.setTotalReturnedQty(oldQty.add(purReturnsQty));
        } else {
            purOrderEntryInfo.setTotalReturnedQty(oldQty.subtract(purReturnsQty));
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("totalReturnedQty"));
        iPurOrderEntry.updatePartial((CoreBaseInfo)purOrderEntryInfo, selector);
    }

    private String getPurOrderEntryIdByPurReturnsEntryId(String PurReturnsEntryId) throws BOSException, EASBizException {
        String PurOrderEntryId = null;
        StringBuffer sql = new StringBuffer();
        sql.append("  SELECT A.FID PurOrderEntryId FROM T_SM_purOrderEntry A where A.FID =");
        sql.append(" (SELECT B.FSOURCEBILLENTRYID  FROM T_IM_PurReceivalentry B where b.FID =");
        sql.append(" (SELECT isnull(C.FcoreBillEntryID,c.FSOURCEBILLENTRYID)   FROM T_EI_QcBillEntry C where C.FID =");
        sql.append(" (SELECT D.FSOURCEBILLID  FROM T_EMM_NCRreport D where D.FID =");
        sql.append(" (SELECT E.FSOURCEBILLID  FROM T_SM_purreturnsentry E where E.FID ='" + PurReturnsEntryId + "'))))");
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                PurOrderEntryId = rs.getString("PurOrderEntryId");
            }
        }
        catch (SQLException e) {
            throw new EASBizException(new NumericExceptionSubItem("", e.getMessage()));
        }
        return PurOrderEntryId;
    }
}

