/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.qm.qc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.IBOTMapping;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.basedata.zj.app.ZJDefaultWarehouseServerUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.syncdatabase.InterfaceDataBaseException;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.industry.emm.qm.qc.EMMNCRBizException;
import com.kingdee.eas.industry.emm.qm.qc.ReworkBillInfo;
import com.kingdee.eas.industry.emm.qm.qc.app.AbstractReworkBillControllerBean;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.im.inv.OtherIssueBillCollection;
import com.kingdee.eas.scm.im.inv.OtherIssueBillEntryCollection;
import com.kingdee.eas.scm.im.inv.OtherIssueBillEntryInfo;
import com.kingdee.eas.scm.im.inv.OtherIssueBillFactory;
import com.kingdee.eas.scm.im.inv.OtherIssueBillInfo;
import com.kingdee.eas.scm.im.inv.PurReceivalBillCollection;
import com.kingdee.eas.scm.im.inv.PurReceivalBillFactory;
import com.kingdee.eas.scm.im.inv.PurReceivalBillInfo;
import com.kingdee.eas.scm.im.inv.PurReceivalEntryCollection;
import com.kingdee.eas.scm.im.inv.PurReceivalEntryInfo;
import com.kingdee.util.NumericExceptionSubItem;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class ReworkBillControllerBean
extends AbstractReworkBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.industry.emm.qm.qc.app.ReworkBillControllerBean");
    private String RESOURCE_NAME = "com.kingdee.eas.industry.emm.qm.qc.NCRBizResource";

    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        if (model == null) {
            model = this.getReworkBillInfo(ctx, pk);
        }
        super._passAudit(ctx, pk, model);
        ReworkBillInfo reworkBillInfo = this.getReworkBillInfo(ctx, pk);
        reworkBillInfo.setBaseStatus(BillBaseStatusEnum.AUDITED);
        this.updateAuditStatus(ctx, (IObjectValue)reworkBillInfo);
        this.afterAudit(ctx, reworkBillInfo);
    }

    protected void afterAudit(Context ctx, ReworkBillInfo reworkBillInfo) throws EASBizException, BOSException {
        ctx.put((Object)"isSourceDel", (Object)"YES");
        this.tranOtherIssueBillBOTP(ctx, reworkBillInfo);
        this.tranPurReceivalBillBOTP(ctx, reworkBillInfo);
    }

    protected IObjectPK[] _submitBatchData(Context ctx, IObjectCollection coll) throws BOSException, EASBizException {
        for (int i = 0; i < coll.size(); ++i) {
            ReworkBillInfo info = (ReworkBillInfo)coll.getObject(i);
            info.setBaseStatus(BillBaseStatusEnum.SUBMITED);
        }
        return super._submitBatchData(ctx, coll);
    }

    protected IObjectPK _submit(Context arg0, IObjectValue arg1) throws BOSException, EASBizException {
        return super._submit(arg0, arg1);
    }

    protected void tranOtherIssueBillBOTP(Context ctx, ReworkBillInfo reworkBillInfo) throws EASBizException, BOSException {
        IBOTMapping botFactory = BOTMappingFactory.getLocalInstance((Context)ctx);
        BOTMappingInfo botInfo = null;
        BOTMappingCollection botColapp = botFactory.getBOTMappingCollection("where name='REWORKBILLTOOTHERISSUE' and extRule.isEffected=1 ");
        if (botColapp.size() != 1) {
            throw new EMMNCRBizException(EMMNCRBizException.NOFINDBOTP, new Object[]{"REWORKBILLTOOTHERISSUE"});
        }
        botInfo = botColapp.get(0);
        if (botInfo != null) {
            IBTPManager btp = BTPManagerFactory.getLocalInstance((Context)ctx);
            BTPTransformResult result = null;
            result = btp.transform((CoreBillBaseInfo)reworkBillInfo, botInfo);
            if (result.getBills().size() <= 0) {
                return;
            }
            BOTRelationCollection relations = result.getBOTRelationCollection();
            Map map = this.getMapByRelation(relations);
            for (int i = 0; i < result.getBills().size(); ++i) {
                IObjectValue destBillInfo = result.getBills().getObject(i);
                OtherIssueBillInfo otherIssueBillInfo = (OtherIssueBillInfo)destBillInfo;
                if (otherIssueBillInfo.getStorageOrgUnit() == null) {
                    NumericExceptionSubItem interfaceException = new NumericExceptionSubItem("", EASResource.getString((String)this.RESOURCE_NAME, (String)"SCM_QTCKDKCZZ_ISNULL", (Locale)ctx.getLocale()));
                    throw new InterfaceDataBaseException(interfaceException);
                }
                StorageOrgUnitInfo stoOrgUnitInfo = otherIssueBillInfo.getStorageOrgUnit();
                OtherIssueBillEntryCollection otherIssueBillEntryColl = otherIssueBillInfo.getEntry();
                for (int j = 0; j < otherIssueBillEntryColl.size(); ++j) {
                    OtherIssueBillEntryInfo otherIssueBillEntryInfo = otherIssueBillEntryColl.get(j);
                    MaterialInfo materialInfo = otherIssueBillEntryInfo.getMaterial();
                    ProjectInfo projectInfo = otherIssueBillEntryInfo.getProject();
                    WarehouseInfo defaultWarehouseInfo = ZJDefaultWarehouseServerUtils.getDefaultWarehouse(ctx, stoOrgUnitInfo, materialInfo, projectInfo, true);
                    WarehouseInfo disWarehouse = null;
                    if (defaultWarehouseInfo != null) {
                        disWarehouse = (WarehouseInfo)defaultWarehouseInfo.get("disWarehouse");
                    }
                    otherIssueBillEntryInfo.setWarehouse(disWarehouse);
                    if (disWarehouse == null) continue;
                    LocationInfo locationInfo = ZJDefaultWarehouseServerUtils.getDefLocation(ctx, materialInfo, stoOrgUnitInfo, disWarehouse);
                    otherIssueBillEntryInfo.setLocation(locationInfo);
                }
                BOTRelationCollection botrelationcollection = (BOTRelationCollection)map.get(otherIssueBillInfo.getId().toString());
                btp.saveRelations((CoreBillBaseInfo)otherIssueBillInfo, botrelationcollection);
            }
        }
    }

    protected void tranPurReceivalBillBOTP(Context ctx, ReworkBillInfo reworkBillInfo) throws EASBizException, BOSException {
        IBOTMapping botFactory = BOTMappingFactory.getLocalInstance((Context)ctx);
        BOTMappingInfo botInfo = null;
        BOTMappingCollection botColapp = botFactory.getBOTMappingCollection("where name='REWORKBILLTOPURRECEIVAL' and extRule.isEffected=1 ");
        if (botColapp.size() != 1) {
            throw new EMMNCRBizException(EMMNCRBizException.NOFINDBOTP, new Object[]{"REWORKBILLTOPURRECEIVAL"});
        }
        botInfo = botColapp.get(0);
        if (botInfo != null) {
            IBTPManager btp = BTPManagerFactory.getLocalInstance((Context)ctx);
            BTPTransformResult result = null;
            result = btp.transform((CoreBillBaseInfo)reworkBillInfo, botInfo);
            if (result.getBills().size() <= 0) {
                return;
            }
            BOTRelationCollection relations = result.getBOTRelationCollection();
            Map map = this.getMapByRelation(relations);
            for (int i = 0; i < result.getBills().size(); ++i) {
                IObjectValue destBillInfo = result.getBills().getObject(i);
                PurReceivalBillInfo purReceivalBillInfo = (PurReceivalBillInfo)destBillInfo;
                StorageOrgUnitInfo stoOrgUnitInfo = null;
                if (purReceivalBillInfo.getStorageOrgUnit() != null) {
                    stoOrgUnitInfo = purReceivalBillInfo.getStorageOrgUnit();
                }
                PurReceivalEntryCollection purReceivalEntryColl = purReceivalBillInfo.getEntry();
                for (int j = 0; j < purReceivalEntryColl.size(); ++j) {
                    PurReceivalEntryInfo purReceivalEntryInfo = purReceivalEntryColl.get(j);
                    MaterialInfo materialInfo = purReceivalEntryInfo.getMaterial();
                    ProjectInfo projectInfo = purReceivalEntryInfo.getProject();
                    WarehouseInfo defaultWarehouseInfo = ZJDefaultWarehouseServerUtils.getDefaultWarehouse(ctx, stoOrgUnitInfo, materialInfo, projectInfo, true);
                    purReceivalEntryInfo.setWarehouse(defaultWarehouseInfo);
                }
                BOTRelationCollection botrelationcollection = (BOTRelationCollection)map.get(purReceivalBillInfo.getId().toString());
                btp.saveRelations((CoreBillBaseInfo)purReceivalBillInfo, botrelationcollection);
            }
        }
    }

    public Map getMapByRelation(BOTRelationCollection relations) {
        HashMap<String, BOTRelationCollection> map = new HashMap<String, BOTRelationCollection>();
        for (int i = 0; i < relations.size(); ++i) {
            BOTRelationCollection botrelationcollection;
            BOTRelationInfo relationInfo = relations.get(i);
            String oid = relationInfo.getDestObjectID();
            if (map.get(oid) != null) {
                botrelationcollection = (BOTRelationCollection)map.get(oid);
                botrelationcollection.add(relationInfo);
                map.put(oid, botrelationcollection);
                continue;
            }
            botrelationcollection = new BOTRelationCollection();
            botrelationcollection.add(relationInfo);
            map.put(oid, botrelationcollection);
        }
        return map;
    }

    protected void _unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (pk == null) {
            return;
        }
        super._unAudit(ctx, pk);
        ReworkBillInfo reworkBillInfo = this.getReworkBillInfo(ctx, pk);
        reworkBillInfo.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        this.updateUnAuditStatus(ctx, (IObjectValue)reworkBillInfo);
        this.afterUnAudit(ctx, reworkBillInfo);
    }

    protected void _unAudit(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        for (IObjectPK pk : pks) {
            this._unAudit(ctx, pk);
        }
    }

    protected void afterUnAudit(Context ctx, ReworkBillInfo reworkBillInfo) throws BOSException, EASBizException {
        ctx.put((Object)"isSourceDel", (Object)"YES");
        this.tranDeleteOtherIssueBill(ctx, reworkBillInfo);
        this.tranDeletePurReceivalBill(ctx, reworkBillInfo);
    }

    protected void tranDeleteOtherIssueBill(Context ctx, ReworkBillInfo reworkBillInfo) throws BOSException, EASBizException {
        OtherIssueBillCollection otherIssueBillColl = OtherIssueBillFactory.getLocalInstance((Context)ctx).getOtherIssueBillCollection("Where sourceBillId = '" + reworkBillInfo.getId().toString() + "'");
        if (otherIssueBillColl.size() > 0) {
            OtherIssueBillInfo otherIssueBillInfo = otherIssueBillColl.get(0);
            if (otherIssueBillInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.TEMPORARILYSAVED) || otherIssueBillInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.SUBMITED)) {
                OtherIssueBillFactory.getLocalInstance((Context)ctx).delete((IObjectPK)new ObjectUuidPK(otherIssueBillInfo.getId()));
            } else {
                NumericExceptionSubItem interfaceException = new NumericExceptionSubItem("", EASResource.getString((String)this.RESOURCE_NAME, (String)"SCM_QTCKD", (Locale)ctx.getLocale()) + otherIssueBillInfo.getNumber() + EASResource.getString((String)this.RESOURCE_NAME, (String)"SCM_YCLBYYXFSHFGFXD", (Locale)ctx.getLocale()));
                throw new InterfaceDataBaseException(interfaceException);
            }
        }
    }

    protected void tranDeletePurReceivalBill(Context ctx, ReworkBillInfo reworkBillInfo) throws BOSException, EASBizException {
        PurReceivalBillCollection purReceivalBillColl = PurReceivalBillFactory.getLocalInstance((Context)ctx).getPurReceivalBillCollection("Where sourceBillId = '" + reworkBillInfo.getId().toString() + "'");
        if (purReceivalBillColl.size() > 0) {
            PurReceivalBillInfo purReceivalBillInfo = purReceivalBillColl.get(0);
            if (purReceivalBillInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.TEMPORARILYSAVED) || purReceivalBillInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.SUBMITED)) {
                PurReceivalBillFactory.getLocalInstance((Context)ctx).delete((IObjectPK)new ObjectUuidPK(purReceivalBillInfo.getId()));
            } else {
                NumericExceptionSubItem interfaceException = new NumericExceptionSubItem("", EASResource.getString((String)this.RESOURCE_NAME, (String)"SCM_CGSHD", (Locale)ctx.getLocale()) + purReceivalBillInfo.getNumber() + EASResource.getString((String)this.RESOURCE_NAME, (String)"SCM_YCLBYYXFSHFGFXD", (Locale)ctx.getLocale()));
                throw new InterfaceDataBaseException(interfaceException);
            }
        }
    }
}

