/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.scm.material.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.industry.emm.scm.material.EMMMaterialFactory;
import com.kingdee.eas.industry.emm.scm.material.EMMMaterialInfo;
import com.kingdee.eas.industry.emm.scm.material.app.AbstractEMMMaterialControllerBean;
import com.kingdee.util.NumericExceptionSubItem;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;

public class EMMMaterialControllerBean
extends AbstractEMMMaterialControllerBean {
    private static final long serialVersionUID = -8528955411222437623L;

    @Override
    protected void _startup(Context ctx, List ids, boolean basestatus) throws BOSException, EASBizException {
        this.checkValidate(ctx, ids, basestatus);
        this.execStartup(ctx, ids, basestatus);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkValidateExist(ctx, model);
        return super._addnew(ctx, model);
    }

    @Override
    protected EMMMaterialInfo _queryInfoByMaterial(Context ctx, String storageOrgUnitId, String materialId) throws BOSException, EASBizException {
        EMMMaterialInfo info = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgUnitId, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialId, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)1, CompareType.EQUALS));
        view.setFilter(filterInfo);
        CoreBaseCollection colls = this.getCollection(ctx, view);
        if (colls.size() > 0) {
            info = (EMMMaterialInfo)colls.get(0);
        }
        return info;
    }

    private void checkValidateExist(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        EMMMaterialInfo _model = (EMMMaterialInfo)model;
        String storageUnitOrgid = _model.getStorageOrgUnit().getId().toString();
        String materialid = _model.getMaterial().getId().toString();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageUnitOrgid, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialid, CompareType.EQUALS));
        view.setFilter(filterInfo);
        CoreBaseCollection colls = this.getCollection(ctx, view);
        if (colls.size() > 0) {
            throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.material.EMMSCMMaterialResource", (String)"0EMMSCMMMaterial-0002", (Locale)ctx.getLocale()), EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.material.EMMSCMMaterialResource", (String)"0EMMSCMMMaterial-0010", (Locale)ctx.getLocale())));
        }
    }

    private void checkValidate(Context ctx, List<String> ids, boolean basestatus) throws BOSException, EASBizException {
        if (ids.contains(null) && basestatus) {
            throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.material.EMMSCMMaterialResource", (String)"0EMMSCMMMaterial-0002", (Locale)ctx.getLocale()), EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.material.EMMSCMMaterialResource", (String)"0EMMSCMMMaterial-0004", (Locale)ctx.getLocale())));
        }
        if (ids.contains(null) && !basestatus) {
            throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.material.EMMSCMMaterialResource", (String)"0EMMSCMMMaterial-0002", (Locale)ctx.getLocale()), EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.material.EMMSCMMaterialResource", (String)"0EMMSCMMMaterial-0005", (Locale)ctx.getLocale())));
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        HashSet<String> set = new HashSet<String>();
        set.addAll(ids);
        filterInfo.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        view.setFilter(filterInfo);
        CoreBaseCollection colls = this.getCollection(ctx, view);
        for (int i = 0; i < colls.size(); ++i) {
            EMMMaterialInfo emmmaterial = (EMMMaterialInfo)colls.get(i);
            boolean _basestatus = emmmaterial.isBaseStatus();
            if (!Boolean.toString(basestatus).equals(Boolean.toString(_basestatus))) continue;
            if (basestatus) {
                throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.material.EMMSCMMaterialResource", (String)"0EMMSCMMMaterial-0002", (Locale)ctx.getLocale()), EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.material.EMMSCMMaterialResource", (String)"0EMMSCMMMaterial-0011", (Locale)ctx.getLocale())));
            }
            throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.material.EMMSCMMaterialResource", (String)"0EMMSCMMMaterial-0002", (Locale)ctx.getLocale()), EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.material.EMMSCMMaterialResource", (String)"0EMMSCMMMaterial-0007", (Locale)ctx.getLocale())));
        }
    }

    private void execStartup(Context ctx, List<String> ids, boolean basestatus) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        HashSet<String> set = new HashSet<String>();
        set.addAll(ids);
        filterInfo.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        view.setFilter(filterInfo);
        CoreBaseCollection colls = this.getCollection(ctx, view);
        for (int i = 0; i < colls.size(); ++i) {
            EMMMaterialInfo emmmaterial = (EMMMaterialInfo)colls.get(i);
            emmmaterial.setBaseStatus(basestatus);
        }
        try {
            EMMMaterialFactory.getLocalInstance(ctx).save(colls);
        }
        catch (EASBizException e) {
            if (basestatus) {
                throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.material.EMMSCMMaterialResource", (String)"0EMMSCMMMaterial-0002", (Locale)ctx.getLocale()), EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.material.EMMSCMMaterialResource", (String)"0EMMSCMMMaterial-0012", (Locale)ctx.getLocale())));
            }
            throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.material.EMMSCMMaterialResource", (String)"0EMMSCMMMaterial-0002", (Locale)ctx.getLocale()), EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.material.EMMSCMMaterialResource", (String)"0EMMSCMMMaterial-0009", (Locale)ctx.getLocale())));
        }
    }
}

