/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.master.material.IMaterialInventory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryCollection;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.OrgUnitRelationInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class EMMInvUtils {
    public static final BigDecimal BIGDECIMAL_ZERO = new BigDecimal("0.00");
    public static final String DISLOCK = "disLock";
    public static final String NODELETE = "noDelete";
    public static final String NOCONTROL = "noControl";

    public static void delInOutInvOrderCheSizeCode(Context ctx, String fid) throws BOSException {
        try {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("relabillId", (Object)fid, CompareType.EQUALS));
            viewInfo.setFilter(filter);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static Map getMaterialIntoryCollc(Context ctx, Set materialIDS, Set storageIDS) throws Exception {
        if (materialIDS == null || storageIDS == null) {
            return new HashMap();
        }
        HashMap<String, MaterialInventoryInfo> materialIntorys = new HashMap<String, MaterialInventoryInfo>();
        MaterialInventoryInfo materialInvInfo = null;
        IMaterialInventory iMaterialInv = MaterialInventoryFactory.getLocalInstance((Context)ctx);
        String key = "";
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialIDS, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)storageIDS, CompareType.INCLUDE));
        view.setFilter(filter);
        MaterialInventoryCollection coll = iMaterialInv.getMaterialInventoryCollection(view);
        for (int i = 0; i < coll.size(); ++i) {
            materialInvInfo = coll.get(i);
            if (materialInvInfo == null || materialInvInfo.getMaterial() == null || materialInvInfo.getOrgUnit() == null) continue;
            key = materialInvInfo.getMaterial().getId().toString() + materialInvInfo.getOrgUnit().getId().toString();
            materialIntorys.put(key, materialInvInfo);
        }
        return materialIntorys;
    }

    public static BigDecimal getInventory(Context ctx, MaterialInfo material, StorageOrgUnitInfo storage, WarehouseInfo warehouse) throws BOSException {
        try {
            if (material == null || storage == null || warehouse == null) {
                return BigDecimal.ZERO;
            }
            String sql = new StringBuffer("select sum(fbaseqty)  as  fbaseQty from t_im_inventory where fmaterialid='").append(material.getId()).append("' and fstorageOrgunitid ='").append(storage.getId()).append("' and fwarehouseid='").append(warehouse.getId()).append("'").toString();
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            String currentInventory = null;
            if (rs.next()) {
                currentInventory = rs.getString("fbaseQty");
            }
            if (currentInventory == null || currentInventory.length() < 1) {
                return BigDecimal.ZERO;
            }
            return new BigDecimal(currentInventory);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static String getSizeBizResource(String strKey) {
        if (strKey == null || strKey.trim().length() == 0) {
            return null;
        }
        return EASResource.getString((String)"com.kingdee.eas.industry.emm.scm.inv.SizeBizResource", (String)strKey);
    }

    protected static Map getCompanyInfos(Context ctx, String[] orgIds, OrgType fromType, OrgType toType) throws BOSException, EASBizException {
        if (orgIds == null || orgIds.length <= 0) {
            return new HashMap();
        }
        HashMap<String, Object> couMap = new HashMap<String, Object>(orgIds.length);
        HashSet<String> souIdSet = new HashSet<String>(orgIds.length);
        int length = orgIds.length;
        for (int i = 0; i < length && orgIds[i] != null; ++i) {
            couMap.put(orgIds[i].toString(), null);
            souIdSet.add(orgIds[i]);
        }
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("toUnit"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("fromUnit", souIdSet, CompareType.INCLUDE));
        filter.appendFilterItem("typeRelation.fromType", (Object)new Integer(fromType.getValue()));
        filter.appendFilterItem("typeRelation.toType", (Object)new Integer(toType.getValue()));
        filter.setMaskString("#0 and #1 and #2");
        view.setFilter(filter);
        view.getSelector().add("toUnit.id");
        view.getSelector().add("fromUnit.id");
        OrgUnitRelationCollection ourCol = OrgUnitRelationFactory.getLocalInstance((Context)ctx).getOrgUnitRelationCollection(view);
        if (ourCol.size() > 0) {
            HashSet<BOSUuid> couIdSet = new HashSet<BOSUuid>(ourCol.size());
            int size = ourCol.size();
            for (int i = 0; i < size; ++i) {
                OrgUnitRelationInfo ourInfo = ourCol.get(i);
                couMap.put(ourInfo.getFromUnit().getId().toString(), ourInfo.getToUnit().getId());
                couIdSet.add(ourInfo.getToUnit().getId());
            }
            FilterInfo couFilter = new FilterInfo();
            couFilter.getFilterItems().add(new FilterItemInfo("id", couIdSet, CompareType.INCLUDE));
            EntityViewInfo couView = new EntityViewInfo();
            couView.setFilter(couFilter);
            CompanyOrgUnitCollection couCol = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(couView);
            HashMap<BOSUuid, CompanyOrgUnitInfo> couMap2 = new HashMap<BOSUuid, CompanyOrgUnitInfo>();
            int size2 = couCol.size();
            for (int i = 0; i < size2; ++i) {
                couMap2.put(couCol.get(i).getId(), couCol.get(i));
            }
            for (Object key : couMap.keySet()) {
                if (couMap.get(key) == null) continue;
                couMap.put((String)key, couMap2.get(couMap.get(key)));
            }
        }
        return couMap;
    }

    public static CompanyOrgUnitInfo getCompanyInfoByStorage(Context ctx, BOSUuid souId) throws BOSException, EASBizException {
        if (souId == null) {
            return null;
        }
        IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        OrgUnitCollection orgCol = iUnitRel.getToUnit(souId.toString(), 4, 1);
        CompanyOrgUnitInfo ret = (CompanyOrgUnitInfo)orgCol.get(0);
        if (ret != null && ret.getBaseCurrency() != null && ret.getBaseCurrency().getName() == null) {
            try {
                ret.setBaseCurrency(CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(ret.getBaseCurrency().getId())));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ret;
    }
}

