/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app.processor.stocktransferplan;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.industry.emm.mm.mo.StockTransferPlan;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.scm.im.inv.StockTransferBillEntryCollection;
import com.kingdee.eas.scm.im.inv.StockTransferBillEntryInfo;
import com.kingdee.eas.scm.im.inv.StockTransferBillInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class StockTransferWriteBackSTPProcessor
extends AbstractBusinessProcessor {
    private static final long serialVersionUID = 3699577628799055820L;
    public static final BigDecimal ZERO = BigDecimal.valueOf(0L);

    public StockTransferWriteBackSTPProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    public StockTransferWriteBackSTPProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public StockTransferWriteBackSTPProcessor(ProcessorConstructParam param) {
        super(param);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        IObjectCollection collection = batchResults.getObjCollection();
        BatchExecuteParamsEntry[] entries = batchResults.getParamEntries();
        IObjectPK[] arrayPK = batchResults.getToDoPkArray();
        if (null == collection || collection.size() == 0 || entries == null || entries.length == 0) {
            return;
        }
        if (!(BatchActionEnum.SAVE.equals((Object)this.batchAction) || BatchActionEnum.ADDNEW.equals((Object)this.batchAction) || BatchActionEnum.AUDIT.equals((Object)this.batchAction) || BatchActionEnum.UNAUDIT.equals((Object)this.batchAction))) {
            return;
        }
        this.writeBackSTP(this.ctx, collection, this.batchAction);
    }

    protected void writeBackSTP(Context ctx, IObjectCollection objectCollection, BatchActionEnum action) throws BOSException, EASBizException {
        if (ctx == null || objectCollection == null || action == null) {
            return;
        }
        if (objectCollection.size() == 0) {
            return;
        }
        boolean effectedRows = false;
        StringBuffer sql = new StringBuffer();
        HashMap<String, BigDecimal> qtyMap = new HashMap<String, BigDecimal>();
        StockTransferBillInfo stbInfo = new StockTransferBillInfo();
        for (int index = 0; index < objectCollection.size(); ++index) {
            StockTransferBillEntryCollection stbCollection;
            IObjectValue objectValue = objectCollection.getObject(index);
            StockTransferBillInfo stockTransferBillInfo = objectValue == null ? null : (stbInfo = objectValue instanceof StockTransferBillInfo ? (StockTransferBillInfo)objectValue : null);
            if (stbInfo == null || (stbCollection = stbInfo.getEntry()) == null || stbCollection.size() <= 0) continue;
            for (int entryIndex = 0; entryIndex < stbCollection.size(); ++entryIndex) {
                BigDecimal qty;
                BOSObjectType sourceBillType;
                String sourceBillID;
                StockTransferBillEntryInfo stbEntryInfo = stbCollection.get(entryIndex);
                String string = sourceBillID = stbEntryInfo == null ? null : stbEntryInfo.getSourceBillId();
                BOSUuid sourceBillBOSUUID = sourceBillID == null ? null : (sourceBillID.trim().length() == 0 ? null : BOSUuid.read((String)sourceBillID));
                BOSObjectType bOSObjectType = sourceBillType = sourceBillBOSUUID == null ? null : sourceBillBOSUUID.getType();
                if (sourceBillID == null || sourceBillBOSUUID == null || sourceBillType == null || !new StockTransferPlan().getType().equals((Object)sourceBillType)) continue;
                BigDecimal bigDecimal = stbEntryInfo == null ? BigDecimal.ZERO : (qty = stbEntryInfo.getQty() == null ? BigDecimal.ZERO : stbEntryInfo.getQty());
                BigDecimal sumQty = qtyMap.containsKey(sourceBillID) ? (qtyMap.get(sourceBillID) == null ? BigDecimal.ZERO : (qtyMap.get(sourceBillID) instanceof BigDecimal ? (BigDecimal)qtyMap.get(sourceBillID) : BigDecimal.ZERO)) : BigDecimal.ZERO;
                qtyMap.put(sourceBillID, sumQty.add(qty));
            }
        }
        if (qtyMap != null && qtyMap.size() > 0) {
            Set qtyMapKeySet = qtyMap.keySet();
            for (Object qtyMapKey : qtyMapKeySet) {
                BOSObjectType sourceType;
                String sourceID;
                String string = sourceID = qtyMapKey == null ? null : qtyMapKey.toString();
                BOSUuid sourceBOSUUID = sourceID == null ? null : (sourceID.trim().length() == 0 ? null : BOSUuid.read((String)sourceID));
                BOSObjectType bOSObjectType = sourceType = sourceBOSUUID == null ? null : sourceBOSUUID.getType();
                if (sourceID == null || sourceID == null || sourceType == null || !new StockTransferPlan().getType().equals((Object)sourceType)) continue;
                this.writeBackSTP(ctx, sourceID, action, stbInfo == null ? null : stbInfo.getId().toString());
            }
        }
    }

    protected void writeBackSTP(Context ctx, String id, BatchActionEnum action, String stbId) throws BOSException, EASBizException {
        if (id == null) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("Update CT_MO_StockTransferPlan UT\r\n");
        sql.append("Set\r\n");
        if (BatchActionEnum.ADDNEW.equals((Object)action) || BatchActionEnum.SAVE.equals((Object)action)) {
            sql.append("CFTransferQTY=IsNull((");
            sql.append("Select\r\n");
            sql.append("Sum(STBE.FQty) FTOBESumQty\r\n");
            sql.append("From CT_MO_StockTransferPlan STP\r\n");
            sql.append("Inner Join T_IM_StockTransferBillEntry STBE On STBE.FSourceBillID=STP.FID\r\n");
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            sql.append("And STP.FID='").append(id).append("'\r\n");
            sql.append("),0)\r\n");
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            sql.append("And UT.FID='").append(id).append("'\r\n");
            int effectedRows = SQLUtils.execute((Context)ctx, (String)sql.toString());
            System.out.println("Execute SQL Effected Rows " + effectedRows + ":\r\n" + sql.toString());
        } else if (BatchActionEnum.AUDIT.equals((Object)action)) {
            sql.append("CFAuditTransferQTY=IsNull((\r\n");
            sql.append("Select\r\n");
            sql.append("Sum(STBE.FQTY)\r\n");
            sql.append("From T_IM_StockTransferBill STB\r\n");
            sql.append("Inner Join T_IM_StockTransferBillEntry STBE On STBE.FParentID=STB.FID\r\n");
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            sql.append("And STB.FSourceBillID=UT.FID\r\n");
            sql.append("And STB.FBaseStatus In (\r\n");
            sql.append(4).append(",\r\n");
            sql.append(7).append("\r\n");
            sql.append(")\r\n");
            sql.append("And STB.FID<>'").append(stbId).append("'\r\n");
            sql.append("),0)\r\n");
            sql.append("+\r\n");
            sql.append("IsNull((\r\n");
            sql.append("Select\r\n");
            sql.append("Sum(STBE.FQTY)\r\n");
            sql.append("From T_IM_StockTransferBill STB\r\n");
            sql.append("Inner Join T_IM_StockTransferBill SSTB On SSTB.FID=STB.FSourceBillID\r\n");
            sql.append("Inner Join T_IM_StockTransferBillEntry STBE On STBE.FParentID=STB.FID\r\n");
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            sql.append("And SSTB.FSourceBillID=UT.FID\r\n");
            sql.append("And STB.FBaseStatus In (\r\n");
            sql.append(4).append(",\r\n");
            sql.append(7).append("\r\n");
            sql.append(")\r\n");
            sql.append("And STB.FID<>'").append(stbId).append("'\r\n");
            sql.append("),0)\r\n");
            sql.append("+\r\n");
            sql.append("IsNull((\r\n");
            sql.append("Select\r\n");
            sql.append("Sum(STBE.FQTY)\r\n");
            sql.append("From T_IM_StockTransferBillEntry STBE\r\n");
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            sql.append("And STBE.FParentID='").append(stbId).append("'\r\n");
            sql.append("),0),\r\n");
            sql.append("CFSTBAuditTime=Now()\r\n");
        } else if (BatchActionEnum.UNAUDIT.equals((Object)action)) {
            sql.append("CFAuditTransferQTY=IsNull((\r\n");
            sql.append("Select\r\n");
            sql.append("Sum(STBE.FQTY)\r\n");
            sql.append("From T_IM_StockTransferBill STB\r\n");
            sql.append("Inner Join T_IM_StockTransferBillEntry STBE On STBE.FParentID=STB.FID\r\n");
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            sql.append("And STB.FSourceBillID=UT.FID\r\n");
            sql.append("And STB.FBaseStatus In (\r\n");
            sql.append(4).append(",\r\n");
            sql.append(7).append("\r\n");
            sql.append(")\r\n");
            sql.append("And STB.FID<>'").append(stbId).append("'\r\n");
            sql.append("),0)\r\n");
            sql.append("+\r\n");
            sql.append("IsNull((\r\n");
            sql.append("Select\r\n");
            sql.append("Sum(STBE.FQTY)\r\n");
            sql.append("From T_IM_StockTransferBill STB\r\n");
            sql.append("Inner Join T_IM_StockTransferBill SSTB On SSTB.FID=STB.FSourceBillID\r\n");
            sql.append("Inner Join T_IM_StockTransferBillEntry STBE On STBE.FParentID=STB.FID\r\n");
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            sql.append("And SSTB.FSourceBillID=UT.FID\r\n");
            sql.append("And STB.FBaseStatus In (\r\n");
            sql.append(4).append(",\r\n");
            sql.append(7).append("\r\n");
            sql.append(")\r\n");
            sql.append("And STB.FID<>'").append(stbId).append("'\r\n");
            sql.append("),0),\r\n");
            sql.append("CFSTBAuditTime=Null\r\n");
        }
        if (!BatchActionEnum.ADDNEW.equals((Object)action) && !BatchActionEnum.SAVE.equals((Object)action)) {
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            sql.append("And UT.FID In (\r\n");
            sql.append("Select\r\n");
            sql.append("STB.FSourceBillID\r\n");
            sql.append("From T_IM_StockTransferBill STB\r\n");
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            sql.append("And STB.FID='").append(stbId).append("'\r\n");
            sql.append("Union All\r\n");
            sql.append("Select\r\n");
            sql.append("(\r\n");
            sql.append("Select\r\n");
            sql.append("SSTB.FSourceBillID\r\n");
            sql.append("From T_IM_StockTransferBill SSTB\r\n");
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            sql.append("And SSTB.FID=STB.FSourceBillID\r\n");
            sql.append(")\r\n");
            sql.append("From T_IM_StockTransferBill STB\r\n");
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            sql.append("And STB.FID='").append(stbId).append("'\r\n");
            sql.append(")\r\n");
            SQLUtils.execute((Context)ctx, (String)sql.toString());
        }
        sql.setLength(0);
        sql.append("Update CT_MO_StockTransferPlan UT\r\n");
        sql.append("Set (\r\n");
        sql.append("CFTransferStatus,\r\n");
        sql.append("CFSubmitTransferQty\r\n");
        sql.append(")=(\r\n");
        sql.append("Select\r\n");
        sql.append("Case\r\n");
        sql.append("When IsNull(T.CFTransferQTY,0)<=0 Then ").append(0).append("\r\n");
        sql.append("When IsNull(T.CFTransferQTY,0)>0 And IsNull(T.CFTransferQTY,0)<IsNull(T.CFSubmitQTY,0) Then ").append(1).append("\r\n");
        sql.append("When IsNull(T.CFTransferQTY,0)>0 And IsNull(T.CFTransferQTY,0)>=IsNull(T.CFSubmitQTY,0) Then ").append(2).append("\r\n");
        sql.append("End,\r\n");
        sql.append("IsNull(T.CFTransferQty,0) \r\n");
        sql.append("From CT_MO_StockTransferPlan T\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And T.FID=UT.FID\r\n");
        sql.append(")\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And UT.FID In (\r\n");
        sql.append("Select\r\n");
        sql.append("STB.FSourceBillID\r\n");
        sql.append("From T_IM_StockTransferBill STB\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And STB.FSourceBillID='").append(id).append("'\r\n");
        sql.append("Union All\r\n");
        sql.append("Select\r\n");
        sql.append("(\r\n");
        sql.append("Select\r\n");
        sql.append("SSTB.FSourceBillID\r\n");
        sql.append("From T_IM_StockTransferBill SSTB\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And SSTB.FID=STB.FSourceBillID\r\n");
        sql.append(")\r\n");
        sql.append("From T_IM_StockTransferBill STB\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And STB.FSourceBillID='").append(id).append("'\r\n");
        sql.append(")\r\n");
        SQLUtils.execute((Context)ctx, (String)sql.toString());
        List<String> stockIdList = this.writeStockTransferPlanDetial(ctx, id, action);
    }

    protected List<String> writeStockTransferPlanDetial(Context ctx, String sourceBillid, BatchActionEnum action) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" Select fid, CFSTORAGEORGUNITID,CFMATERIALID,Isnull(CFTRANSFERQTY,0) As CFTRANSFERQTY ,Isnull(CFSUBMITQTY,0) As CFSUBMITQTY,Isnull(CFAUDITTRANSFERQTY,0) As CFAUDITTRANSFERQTY , \r\n");
        sql.append(" CFPROJECTID,CFTRACEID,CFPROJECTJCHID,Isnull(CFSUBMITTRANSFERQTY,0) As CFSUBMITTRANSFERQTY,CFPROCESSFLOW,CFSUPPLYSOUID \r\n");
        sql.append(" From CT_MO_StockTransferPlan UT\r\n");
        sql.append(" where fid = '").append(sourceBillid).append("'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        IRowSet rs2 = null;
        ArrayList<String> sqlList = new ArrayList<String>();
        ArrayList<String> idlist = new ArrayList<String>();
        int irow = 0;
        int rsSize = 0;
        try {
            while (rs.next()) {
                String fid = rs.getString("fid");
                BigDecimal fqty = rs.getBigDecimal("CFSUBMITTRANSFERQTY");
                BigDecimal fTransferQty = rs.getBigDecimal("CFTRANSFERQTY");
                BigDecimal fAuditTransferQty = rs.getBigDecimal("CFAUDITTRANSFERQTY");
                sql.setLength(0);
                sql.append(" Select ut.fid,ut.fentrySourceBillID stockid, ut.CFSTORAGEORGUNITID,ut.CFMATERIALID,Isnull(ut.CFTRANSFERQTY,0) As CFTRANSFERQTY,\r\n");
                sql.append(" Isnull(ut.CFSUBMITQTY,0) As CFSUBMITQTY,Isnull(ut.CFAUDITTRANSFERQTY,0) As CFAUDITTRANSFERQTY, \r\n");
                sql.append(" ut.CFPROJECTID,ut.CFTRACEID,ut.CFPROJECTJCHID,Isnull(ut.CFSUBMITTRANSFERQTY,0) As CFSUBMITTRANSFERQTY,ut.CFPROCESSFLOW,ut.CFSUPPLYSOUID \r\n");
                sql.append(" From CT_MO_StockTransferPlandetial ut\r\n");
                sql.append(" Left outer join t_mm_tracknumber t on ut.CFTRACEID = t.fid \r\n");
                sql.append(" where exists(select 1 from t_bot_relation a where a.FSRCOBJECTID = ut.fid and a.FDESTOBJECTID = '").append(fid);
                sql.append("' and a.FSRCENTITYID = '9CBCD44C' and a.FDESTENTITYID = '08B2670B')\r\n");
                sql.append(" and exists(Select 1 from CT_MO_StockTransferPlan b where b.fid = '").append(fid);
                sql.append("' and isnull(b.CFMATERIALID,'Null') = isnull(ut.cfmaterialid,'Null') \r\n");
                sql.append(" and isnull(b.CFPROJECTID,'Null') = isnull(ut.CFPROJECTID,'Null') ");
                sql.append(" and isnull(b.CFSTORAGEORGUNITID,'Null') = isnull(ut.CFSTORAGEORGUNITID,'Null') ");
                sql.append(" and isnull(b.CFSUPPLYSOUID,'Null') = isnull(ut.CFSUPPLYSOUID,'Null') ");
                sql.append(" and isnull(b.CFPROCESSFLOW,'Null') = isnull(ut.CFPROCESSFLOW,'Null') ");
                sql.append(" and isnull(b.Fsourcefunction,'Null') = 'stocktransferplandetial' ");
                sql.append(" )\r\n");
                sql.append(" order by t.fnumber \r\n");
                rs2 = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                rsSize = rs2.size();
                irow = 0;
                while (rs2.next()) {
                    String stockid = rs2.getString("stockid");
                    String fdetialid = rs2.getString("fid");
                    BigDecimal fdetialQty = rs2.getBigDecimal("CFSubmitQTY");
                    BigDecimal fnewdetialsubmitQty = ZERO;
                    BigDecimal fnewdetialTransferQty = ZERO;
                    BigDecimal fnewdetialAuditTransferQty = ZERO;
                    if (fdetialQty.compareTo(fqty) >= 0) {
                        fnewdetialsubmitQty = fqty;
                        fqty = ZERO;
                    } else {
                        fnewdetialsubmitQty = fdetialQty;
                        fqty = fqty.subtract(fdetialQty);
                    }
                    if (fdetialQty.compareTo(fTransferQty) >= 0) {
                        fnewdetialTransferQty = fTransferQty;
                        fTransferQty = ZERO;
                    } else {
                        fnewdetialTransferQty = fdetialQty;
                        fTransferQty = fTransferQty.subtract(fdetialQty);
                    }
                    if (fdetialQty.compareTo(fAuditTransferQty) >= 0) {
                        fnewdetialAuditTransferQty = fAuditTransferQty;
                        fAuditTransferQty = new BigDecimal(0);
                    } else {
                        fnewdetialAuditTransferQty = fdetialQty;
                        fAuditTransferQty = fAuditTransferQty.subtract(fdetialQty);
                    }
                    if (++irow == rsSize) {
                        if (fqty.compareTo(ZERO) > 0) {
                            fnewdetialsubmitQty = fnewdetialsubmitQty.add(fqty);
                            fqty = ZERO;
                        }
                        if (fTransferQty.compareTo(ZERO) > 0) {
                            fnewdetialTransferQty = fnewdetialTransferQty.add(fTransferQty);
                            fTransferQty = ZERO;
                        }
                        if (fAuditTransferQty.compareTo(ZERO) > 0) {
                            fnewdetialAuditTransferQty = fnewdetialAuditTransferQty.add(fAuditTransferQty);
                            fAuditTransferQty = ZERO;
                        }
                    }
                    int fmoveStatus = 0;
                    if (fnewdetialTransferQty.compareTo(ZERO) > 0) {
                        if (!idlist.contains(stockid)) {
                            idlist.add(stockid);
                        }
                        fmoveStatus = fnewdetialTransferQty.compareTo(fdetialQty) >= 0 ? 2 : 1;
                    }
                    sql.setLength(0);
                    sql.append("update CT_MO_StockTransferPlandetial  ");
                    sql.append(" set CFSUBMITTRANSFERQTY = ").append(fnewdetialsubmitQty);
                    sql.append(" , CFTRANSFERQTY = ").append(fnewdetialTransferQty);
                    sql.append(" , CFAUDITTRANSFERQTY = ").append(fnewdetialAuditTransferQty);
                    sql.append(" , CFTransferStatus = ").append(fmoveStatus);
                    sql.append(" where fid = '").append(fdetialid).append("'");
                    sqlList.add(sql.toString());
                }
            }
            if (sqlList.size() > 0) {
                com.kingdee.eas.base.core.util.DbUtil.executeBatch((Context)ctx, sqlList);
            }
        }
        catch (SQLException e) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.scm.im.inv.EMMSCMInvResource", (String)"0EMMSCMInv-0006", (Locale)ctx.getLocale()) + e.getMessage()));
        }
        return idlist;
    }

    private void writeBackStock(Context ctx, String stpId, List<String> stockIdList) throws BOSException, EASBizException {
        if (stockIdList == null || stockIdList.size() < 1) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.scm.im.inv.EMMSCMInvResource", (String)"0EMMSCMInv-0007", (Locale)ctx.getLocale())));
        }
        StringBuffer sql = new StringBuffer();
        sql.append("update T_MM_MFTOrderStock mt set (FAlrMoveQty,FActMoveQty) = (\r\n");
        sql.append("Select \r\n");
        sql.append("Isnull(STP.CFTransferQTY, 0) TransferQTY, \r\n");
        sql.append("Isnull(STP.CFAuditTransferQTY, 0) AuditTransferQTY \r\n");
        sql.append("From CT_MO_StockTransferPlan STP \r\n");
        sql.append("where STP.FID='").append(stpId).append("'\r\n");
        sql.append(")\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And mt.FID in(").append(SQLUtil.arrayToString((Object[])stockIdList.toArray())).append(")\r\n");
        int effectedRows = SQLUtils.execute((Context)ctx, (String)sql.toString());
        System.out.println("Execute SQL Effected Rows " + effectedRows + ":\r\n" + sql.toString());
    }
}

