/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.app.bizprocess.processor.purreturns;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryInfo;
import com.kingdee.eas.util.IndustryUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;

public class PurReturnsAudit4OrderProcessor
extends AbstractBusinessProcessor {
    private static final long serialVersionUID = -6203256645401609601L;

    public PurReturnsAudit4OrderProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public PurReturnsAudit4OrderProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    public PurReturnsAudit4OrderProcessor(ProcessorConstructParam param) {
        super(param);
    }

    protected void doProcessing(BatchActionResults arg0) throws BOSException, EASBizException {
        String[] pks = arg0.getAllIDs();
        StringBuffer params = new StringBuffer();
        for (int i = 0; i < pks.length; ++i) {
            if (i > 0) {
                params.append(",");
            }
            params.append("'");
            params.append(pks[i].toString());
            params.append("'");
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" ");
        sql.append(" select tpr.fid as fid ,tpr.fqty , tpe.fid  as purentryid  ,tb.fnumber from T_SM_PurReturnsentry tpr ");
        sql.append(" left join T_EMM_NCRreport tnp on tnp.fid = tpr.fsourcebillid ");
        sql.append(" left join T_EI_QcBillEntry tqb on tqb.fid = tnp.fsourcebillid ");
        sql.append(" left join T_IM_PurReceivalEntry tpre on tpre.fid = tqb.fcorebillentryid ");
        sql.append(" left join T_SM_PurOrderEntry tpe on tpe.fid = tpre.fsourcebillentryid ");
        sql.append(" left join T_SM_PurReturns tp on tp.fid = tpr.fparentid ");
        sql.append(" left join T_SCM_BizType tb on tb.fid = tp.fbiztypeid ");
        sql.append(" where tpr.fparentid in (" + params + ") ");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
            while (rs.next()) {
                String purreturnentryId = rs.getString("fid");
                BigDecimal qty = rs.getBigDecimal("fqty");
                String purentryId = rs.getString("purentryid");
                String bizType = rs.getString("fnumber");
                if (IndustryUtils.isEmptyString((String)purentryId) || IndustryUtils.isEmptyString((String)bizType)) continue;
                PurOrderEntryInfo eInfo = PurOrderEntryFactory.getLocalInstance((Context)this.ctx).getPurOrderEntryInfo((IObjectPK)new ObjectUuidPK(purentryId));
                SelectorItemCollection dhsic = new SelectorItemCollection();
                dhsic.add(new SelectorItemInfo("totalReturnedQty"));
                eInfo.setTotalReturnedQty(eInfo.getTotalReturnedQty().add(qty));
                if ("112".equals(bizType)) {
                    eInfo.setTotalSupplyStockQty(eInfo.getTotalSupplyStockQty().add(qty));
                    eInfo.setTotalSupplyStockBaseQty(eInfo.getTotalSupplyStockBaseQty().add(qty));
                    eInfo.setTotalUnReceiveBaseQty(eInfo.getTotalUnReceiveBaseQty().add(qty));
                    eInfo.setTotalUnReceiveQty(eInfo.getTotalUnReceiveQty().add(qty));
                    dhsic.add(new SelectorItemInfo("totalSupplyStockQty"));
                    dhsic.add(new SelectorItemInfo("totalSupplyStockBaseQty"));
                    dhsic.add(new SelectorItemInfo("totalUnReceiveQty"));
                    dhsic.add(new SelectorItemInfo("totalUnReceiveBaseQty"));
                }
                PurOrderEntryFactory.getLocalInstance((Context)this.ctx).updatePartial((CoreBaseInfo)eInfo, dhsic);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage());
        }
    }
}

