/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.analysis.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.TableManagerFacadeFactory;
import com.kingdee.eas.eqm.analysis.WorkOrderTreeInfo;
import com.kingdee.eas.eqm.analysis.app.AbstractWorkorderCostAnalysisTreeFacadeControllerBean;
import com.kingdee.eas.eqm.common.core.app.util.GeneDbUtil;
import com.kingdee.eas.eqm.maintain.WorkOrderFactory;
import com.kingdee.eas.eqm.maintain.WorkOrderInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class WorkorderCostAnalysisTreeFacadeControllerBean
extends AbstractWorkorderCostAnalysisTreeFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.eqm.analysis.app.WorkorderCostAnalysisTreeFacadeControllerBean");
    private String tempTableName = "";

    private String createTempTable(Context ctx) throws Exception {
        String temp = TableManagerFacadeFactory.getLocalInstance((Context)ctx).getTableName("analyzeMontor");
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        StringBuffer sb = new StringBuffer();
        sb.append("Create table " + temp + " (");
        sb.append("FID VARCHAR(44) DEFAULT '' NOT NULL ,FPARENTID VARCHAR(44) DEFAULT '',FNAME NVARCHAR(100) DEFAULT N'',FNUMBER NVARCHAR(80) DEFAULT N'',FISLEAF INT,FLEVEL INT,FDISPLAYNAME VARCHAR(255) DEFAULT '',FLONGNUMBER NVARCHAR(300) DEFAULT N'',FPLANMATERIALCOST NUMERIC(21,8),FREALMATERIALCOSE NUMERIC(21,8),FPLANSTAFFCOST NUMERIC(21,8),FREALSTAFFCOST NUMERIC(21,8),FPLANTOOLSCOST NUMERIC(21,8),FPLANSERVICECOST NUMERIC(21,8),FREALSERVICECOST NUMERIC(21,8),FREALTOOLSCOST NUMERIC(21,8),CONSTRAINT  PK_" + temp.substring(0, 14) + "  PRIMARY KEY (FID)");
        sb.append(");");
        String createSql = sb.toString();
        this.tempTableName = pool.createTempTable(createSql);
        return this.tempTableName;
    }

    private StringBuffer makeQuerySql(String FID) {
        StringBuffer querySql = new StringBuffer();
        querySql.append("SELECT WO.FID,WO.FPARENTID,WO.FNAME,WO.FNUMBER,WO.FISLEAF,WO.FLEVEL,WO.FDisplayName_L2,WO.FLongNumber,");
        querySql.append("(select sum(FLineCost) from T_EQM_WorkOrderToolsEntry  where FParentID=").append(FID).append(") as RTCOST,");
        querySql.append("(select sum(FLineCost) from T_EQM_WorkOrderServiceEntry  where FParentID=").append(FID).append(") as RSCOST,");
        querySql.append("(select sum(FLineCost) from T_EQM_WorkOrderUserEntry  where FParentID=").append(FID).append(") as RUCOST,");
        querySql.append("(select sum(FLineCost) from T_EQM_WorkOrderMaterialEntry  where FParentID=").append(FID).append(") as RMCOST,");
        querySql.append("(select sum(FLineCost) from T_EQM_WorkOrderPlanUserEntry  where FParentID=").append(FID).append(") as PUCOST,");
        querySql.append("(select sum(FLineCost) from T_EQM_WorkOrderPlanToolsEntry  where FParentID=").append(FID).append(") as PTCOST,");
        querySql.append("(select sum(FLineCost) from T_EQM_WorkOrderPServiceEntry  where FParentID=").append(FID).append(") as PSCOST,");
        querySql.append("(select sum(FLineCost) from T_EQM_WorkOrderPMEntry  where FParentID=").append(FID).append(") as PMCOST");
        querySql.append(" FROM T_EQM_WORKORDER as WO ");
        return querySql;
    }

    private int iterative(Context ctx, String workOrderId, int level, List paramList, List treeInfoList, String longNumber) throws BOSException, SQLException {
        IRowSet rowSet = null;
        if (level == 0) {
            String FID = "'" + workOrderId + "'";
            StringBuffer queryParentSql = this.makeQuerySql(FID);
            queryParentSql.append(" where WO.FID='");
            String tempSql = queryParentSql.toString() + workOrderId + "'  and WO.FTaskType=10;";
            rowSet = DbUtil.executeQuery((Context)ctx, (String)tempSql);
            level = this.prepareInsertData(rowSet, paramList, treeInfoList, level, ctx, null);
        }
        StringBuffer querySql = this.makeQuerySql("WO.FID");
        querySql.append(" where WO.FPARENTID='");
        String sql = querySql.toString() + workOrderId + "'  and WO.FTaskType=10;";
        rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        level = this.prepareInsertData(rowSet, paramList, treeInfoList, level, ctx, longNumber);
        return level;
    }

    private static String formatLongNumber(int number) {
        if (number >= 10 && number < 100) {
            return "00" + String.valueOf(number);
        }
        if (number >= 100 && number < 1000) {
            return "0" + String.valueOf(number);
        }
        if (number >= 1000 && number < 10000) {
            return String.valueOf(number);
        }
        if (number < 10 && number > 0) {
            return "000" + String.valueOf(number);
        }
        return String.valueOf(number);
    }

    private int prepareInsertData(IRowSet rowSet, List paramList, List treeInfoList, int level, Context ctx, String longNumber) throws BOSException, SQLException {
        if (rowSet != null && rowSet.size() > 0) {
            ++level;
            int location = 0;
            while (rowSet.next()) {
                String newLongNumber = longNumber == null ? WorkorderCostAnalysisTreeFacadeControllerBean.formatLongNumber(location) : longNumber + ":" + WorkorderCostAnalysisTreeFacadeControllerBean.formatLongNumber(++location);
                WorkOrderTreeInfo info = new WorkOrderTreeInfo();
                Object[] obj = new Object[16];
                info.setId(rowSet.getString("FID"));
                info.setPid(rowSet.getString("FPARENTID"));
                info.setName(rowSet.getString("FNAME"));
                info.setNumber(rowSet.getString("FNUMBER"));
                info.setLeaf(Boolean.valueOf(rowSet.getString("FISLEAF")));
                info.setLevel(Integer.valueOf(String.valueOf(level)));
                info.setLongNumber(newLongNumber);
                info.setDisplayName(rowSet.getString("FDisplayName_L2"));
                info.setRuCost(rowSet.getBigDecimal("RUCOST"));
                info.setPtCost(rowSet.getBigDecimal("PTCOST"));
                info.setPsCost(rowSet.getBigDecimal("PSCOST"));
                info.setRsCost(rowSet.getBigDecimal("RSCOST"));
                info.setRtCost(rowSet.getBigDecimal("RTCOST"));
                info.setPuCost(rowSet.getBigDecimal("PUCOST"));
                info.setRmCost(rowSet.getBigDecimal("RMCOST"));
                info.setPmCost(rowSet.getBigDecimal("PMCOST"));
                obj[0] = rowSet.getString("FID");
                obj[1] = rowSet.getString("FPARENTID");
                obj[2] = rowSet.getString("FNAME");
                obj[3] = rowSet.getString("FNUMBER");
                obj[4] = rowSet.getString("FISLEAF");
                obj[5] = Integer.valueOf(String.valueOf(level));
                obj[6] = rowSet.getString("FDisplayName_L2") == null ? "" : rowSet.getString("FDisplayName_L2");
                obj[7] = newLongNumber;
                obj[8] = rowSet.getBigDecimal("PMCOST") == null ? new BigDecimal(0) : rowSet.getBigDecimal("PMCOST");
                obj[9] = rowSet.getBigDecimal("RMCOST") == null ? new BigDecimal(0) : rowSet.getBigDecimal("RMCOST");
                obj[10] = rowSet.getBigDecimal("PUCOST") == null ? new BigDecimal(0) : rowSet.getBigDecimal("PUCOST");
                obj[11] = rowSet.getBigDecimal("RUCOST") == null ? new BigDecimal(0) : rowSet.getBigDecimal("RUCOST");
                obj[12] = rowSet.getBigDecimal("PTCOST") == null ? new BigDecimal(0) : rowSet.getBigDecimal("PTCOST");
                obj[13] = rowSet.getBigDecimal("PSCOST") == null ? new BigDecimal(0) : rowSet.getBigDecimal("PSCOST");
                obj[14] = rowSet.getBigDecimal("RSCOST") == null ? new BigDecimal(0) : rowSet.getBigDecimal("RSCOST");
                obj[15] = rowSet.getBigDecimal("RTCOST") == null ? new BigDecimal(0) : rowSet.getBigDecimal("RTCOST");
                treeInfoList.add(info);
                paramList.add(obj);
                if (level <= 1) continue;
                String woId = rowSet.getString("FID");
                this.iterative(ctx, woId, level, paramList, treeInfoList, newLongNumber);
            }
        }
        return level;
    }

    protected List _doAnalysisCost(Context ctx, String workOrderId) throws BOSException, EASBizException {
        ArrayList treeInfoList = null;
        try {
            this.tempTableName = this.createTempTable(ctx);
            ctx.put((Object)"tempTableName", (Object)this.tempTableName);
            ArrayList paramList = new ArrayList();
            treeInfoList = new ArrayList();
            String longNumber = "0001";
            this.iterative(ctx, workOrderId, 0, paramList, treeInfoList, longNumber);
            String insertSql = "insert into " + this.tempTableName + "(FID,FPARENTID,FNAME,FNUMBER,FISLEAF,FLEVEL,FDISPLAYNAME,FLONGNUMBER," + "FPLANMATERIALCOST,FREALMATERIALCOSE,FPLANSTAFFCOST,FREALSTAFFCOST,FPLANTOOLSCOST,FPLANSERVICECOST,FREALSERVICECOST,FREALTOOLSCOST)" + " Values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            if (paramList.size() > 0) {
                GeneDbUtil.executeBatch((Context)ctx, (String)insertSql, paramList);
            }
            ArrayList<Object> result = new ArrayList<Object>();
            result.add(treeInfoList);
            result.add(this.tempTableName);
            return result;
        }
        catch (SQLException e) {
            logger.error((Object)e);
            this.releaseTempTable(ctx, this.tempTableName);
            this.tempTableName = "";
        }
        catch (Exception e1) {
            logger.error((Object)e1);
        }
        return treeInfoList;
    }

    private void releaseTempTable(Context ctx, String tableName) throws BOSException {
        if (!StringUtil.isEmptyString((String)tableName)) {
            TableManagerFacadeFactory.getLocalInstance((Context)ctx).releaseTableName(tableName);
        }
    }

    protected Map _getChildrenCostResult(Context ctx, String id, String longNumber, String tempTableName, int level) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (tempTableName == null || tempTableName.equals("")) {
            return result;
        }
        ObjectUuidPK workOrderPK = new ObjectUuidPK(id);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("eqmLocation.number"));
        sic.add(new SelectorItemInfo("eqmLocation.name"));
        sic.add(new SelectorItemInfo("equipmentArchives.number"));
        sic.add(new SelectorItemInfo("equipmentArchives.name"));
        sic.add(new SelectorItemInfo("billStatus"));
        sic.add(new SelectorItemInfo("maintainOrgUnit.*"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("planOrgunit.*"));
        sic.add(new SelectorItemInfo("workOrderModel.*"));
        WorkOrderInfo workOrderInfo = (WorkOrderInfo)WorkOrderFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)workOrderPK, sic);
        result.put(id, workOrderInfo);
        String querySql = "select sum(FPLANMATERIALCOST) as FPLANMATERIALCOST ,sum(FREALMATERIALCOSE) as FREALMATERIALCOSE,sum(FPLANSTAFFCOST) as FPLANSTAFFCOST,sum(FREALSTAFFCOST) as FREALSTAFFCOST,sum(FPLANTOOLSCOST) as FPLANTOOLSCOST,sum(FPLANSERVICECOST) as FPLANSERVICECOST,sum(FREALSERVICECOST) as FREALSERVICECOST,sum(FREALTOOLSCOST) as FREALTOOLSCOST from " + tempTableName + " where FLONGNUMBER like '" + longNumber + "%' and FLEVEL>=" + String.valueOf(level);
        IRowSet rowSet = null;
        rowSet = DbUtil.executeQuery((Context)ctx, (String)querySql);
        try {
            while (rowSet.next()) {
                result.put("FPLANMATERIALCOST", rowSet.getBigDecimal("FPLANMATERIALCOST"));
                result.put("FREALMATERIALCOSE", rowSet.getBigDecimal("FREALMATERIALCOSE"));
                result.put("FPLANSTAFFCOST", rowSet.getBigDecimal("FPLANSTAFFCOST"));
                result.put("FREALSTAFFCOST", rowSet.getBigDecimal("FREALSTAFFCOST"));
                result.put("FPLANTOOLSCOST", rowSet.getBigDecimal("FPLANTOOLSCOST"));
                result.put("FPLANSERVICECOST", rowSet.getBigDecimal("FPLANSERVICECOST"));
                result.put("FREALSERVICECOST", rowSet.getBigDecimal("FREALSERVICECOST"));
                result.put("FREALTOOLSCOST", rowSet.getBigDecimal("FREALTOOLSCOST"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            this.releaseTempTable(ctx, tempTableName);
        }
        return result;
    }
}

