/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.archives;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.eqm.archives.AbstractEquipmentLocationTreeFacadeControllerBean;
import com.kingdee.eas.eqm.archives.EquipmentArchivesFactory;
import com.kingdee.eas.eqm.archives.IEquipmentArchives;
import com.kingdee.eas.eqm.basedata.EquipmentLocationFactory;
import com.kingdee.eas.eqm.basedata.EquipmentLocationInfo;
import com.kingdee.eas.eqm.basedata.IEquipmentLocation;
import com.kingdee.eas.eqm.common.core.IGeneCoreTreeBaseInfo;
import com.kingdee.eas.eqm.common.core.app.util.GeneVirtualModeQueryHelper;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.util.FilterUtility;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class EquipmentLocationTreeFacadeControllerBean
extends AbstractEquipmentLocationTreeFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.eqm.archives.EquipmentArchivesTreeFacadeControllerBean");

    @Override
    protected IObjectCollection _getChildren(Context ctx, IGeneCoreTreeBaseInfo parentNodeInfo, int level) throws BOSException {
        return this._getChildren(ctx, parentNodeInfo, level, null);
    }

    @Override
    protected IObjectCollection _getChildren(Context ctx, IGeneCoreTreeBaseInfo parentNodeInfo, int level, FilterInfo filter) throws BOSException {
        AbstractObjectCollection result = null;
        result = parentNodeInfo instanceof EquipmentLocationInfo ? this.getLocationCollection(ctx, parentNodeInfo, level, filter) : this.getArchivesCollection(ctx, parentNodeInfo, level, filter);
        return result;
    }

    private AbstractObjectCollection getLocationCollection(Context ctx, IGeneCoreTreeBaseInfo parentNodeInfo, int level, FilterInfo filter) throws BOSException {
        IEquipmentLocation ctrl = EquipmentLocationFactory.getLocalInstance((Context)ctx);
        SelectorItemCollection sic = this.getLocationSelectors();
        EntityViewInfo viewInfo = this.getViewInfo(parentNodeInfo, level, filter, sic);
        CoreBaseCollection locationCollection = ctrl.getCollection(viewInfo);
        SelectorItemCollection archiveSic = this.getArchivesSelectors();
        AbstractObjectCollection archivesCollection = this.getArchivesByLocation(ctx, parentNodeInfo, level, filter, archiveSic);
        locationCollection.addObjectCollection((IObjectCollection)archivesCollection);
        return locationCollection;
    }

    private AbstractObjectCollection getArchivesByLocation(Context ctx, IGeneCoreTreeBaseInfo parentNodeInfo, int level, FilterInfo filter, SelectorItemCollection sic) throws BOSException {
        IEquipmentArchives ctrl = EquipmentArchivesFactory.getLocalInstance(ctx);
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(new FilterInfo());
        if (parentNodeInfo != null) {
            viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("location", (Object)parentNodeInfo.getId().toString(), CompareType.EQUALS));
        }
        if (FilterUtility.hasFilterItem((FilterInfo)filter)) {
            viewInfo.getFilter().mergeFilter(filter, "AND");
        }
        viewInfo.getSorter().add(new SorterItemInfo("longNumber"));
        viewInfo.setSelector(sic);
        CoreBaseCollection archivesCollection = ctrl.getCollection(viewInfo);
        return archivesCollection;
    }

    private AbstractObjectCollection getArchivesCollection(Context ctx, IGeneCoreTreeBaseInfo parentNodeInfo, int level, FilterInfo filter) throws BOSException {
        IEquipmentArchives ctrl = EquipmentArchivesFactory.getLocalInstance(ctx);
        SelectorItemCollection sic = this.getArchivesSelectors();
        EntityViewInfo viewInfo = this.getViewInfo(parentNodeInfo, level, filter, sic);
        return ctrl.getCollection(viewInfo);
    }

    private EntityViewInfo getViewInfo(IGeneCoreTreeBaseInfo parentNodeInfo, int level, FilterInfo filter, SelectorItemCollection selector) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(new FilterInfo());
        if (parentNodeInfo != null) {
            viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("longNumber", (Object)(parentNodeInfo.getLongNumber() + "%"), CompareType.LIKE));
            viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("level", (Object)new Integer(parentNodeInfo.getLevel()), CompareType.GREATER_EQUALS));
            viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("level", (Object)new Integer(parentNodeInfo.getLevel() + 1), CompareType.LESS_EQUALS));
        }
        if (FilterUtility.hasFilterItem((FilterInfo)filter)) {
            viewInfo.getFilter().mergeFilter(filter, "AND");
        }
        viewInfo.getSorter().add(new SorterItemInfo("longNumber"));
        viewInfo.setSelector(selector);
        return viewInfo;
    }

    public SelectorItemCollection getArchivesSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("auditor.name"));
        sic.add(new SelectorItemInfo("storageOrgUnit.number"));
        sic.add(new SelectorItemInfo("storageOrgUnit.name"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("location.number"));
        sic.add(new SelectorItemInfo("location.name"));
        sic.add(new SelectorItemInfo("category.number"));
        sic.add(new SelectorItemInfo("category.name"));
        sic.add(new SelectorItemInfo("type.number"));
        sic.add(new SelectorItemInfo("type.name"));
        sic.add(new SelectorItemInfo("effectDate"));
        sic.add(new SelectorItemInfo("model"));
        sic.add(new SelectorItemInfo("material.number"));
        sic.add(new SelectorItemInfo("material.name"));
        sic.add(new SelectorItemInfo("serialNumber"));
        sic.add(new SelectorItemInfo("bizStatus"));
        sic.add(new SelectorItemInfo("logic"));
        sic.add(new SelectorItemInfo("special"));
        sic.add(new SelectorItemInfo("initial"));
        sic.add(new SelectorItemInfo("dependable"));
        sic.add(new SelectorItemInfo("abcIdentify"));
        sic.add(new SelectorItemInfo("parent.number"));
        sic.add(new SelectorItemInfo("parent.name"));
        sic.add(new SelectorItemInfo("billStatus"));
        sic.add(new SelectorItemInfo("auditTime"));
        sic.add(new SelectorItemInfo("maintainOrgUnit.number"));
        sic.add(new SelectorItemInfo("maintainOrgUnit.name"));
        sic.add(new SelectorItemInfo("planOrgUnit.number"));
        sic.add(new SelectorItemInfo("planOrgUnit.name"));
        sic.add(new SelectorItemInfo("maintainDept.number"));
        sic.add(new SelectorItemInfo("maintainDept.name"));
        sic.add(new SelectorItemInfo("isLeaf"));
        sic.add(new SelectorItemInfo("level"));
        sic.add(new SelectorItemInfo("longNumber"));
        return sic;
    }

    public SelectorItemCollection getLocationSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("storageOrgUnit.number"));
        sic.add(new SelectorItemInfo("storageOrgUnit.name"));
        sic.add(new SelectorItemInfo("planOrgUnit.number"));
        sic.add(new SelectorItemInfo("planOrgUnit.name"));
        sic.add(new SelectorItemInfo("maintainOrgUnit.number"));
        sic.add(new SelectorItemInfo("maintainOrgUnit.name"));
        sic.add(new SelectorItemInfo("maintainDept.number"));
        sic.add(new SelectorItemInfo("maintainDept.name"));
        sic.add(new SelectorItemInfo("abcIdentify"));
        sic.add(new SelectorItemInfo("installLimit"));
        sic.add(new SelectorItemInfo("parent.name"));
        sic.add(new SelectorItemInfo("checkedStatus"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("isLeaf"));
        sic.add(new SelectorItemInfo("level"));
        sic.add(new SelectorItemInfo("longNumber"));
        return sic;
    }

    @Override
    protected List _getObjectCollection(Context ctx, IGeneCoreTreeBaseInfo parentNodeInfo, EntityViewInfo viewInfo, int start, int length) throws BOSException, EASBizException {
        List result = null;
        if (viewInfo == null) {
            return result;
        }
        result = parentNodeInfo instanceof EquipmentLocationInfo ? this.getLocationCollection(ctx, parentNodeInfo, viewInfo, start, length) : this.getArchivesCollection(ctx, parentNodeInfo, viewInfo, start, length);
        return result;
    }

    private List getArchivesCollection(Context ctx, IGeneCoreTreeBaseInfo parentNodeInfo, EntityViewInfo viewInfo, int start, int length) throws BOSException, EASBizException {
        ArrayList<List> result = new ArrayList<List>();
        if (viewInfo != null) {
            viewInfo.setSelector(this.getArchivesSelectors());
        }
        GeneVirtualModeQueryHelper helper = new GeneVirtualModeQueryHelper(parentNodeInfo.getBOSType());
        List archivesList = helper.getGeneDataCollection(ctx, viewInfo, start, length);
        result.add(0, null);
        result.add(1, archivesList);
        return result;
    }

    private List getLocationCollection(Context ctx, IGeneCoreTreeBaseInfo parentNodeInfo, EntityViewInfo viewInfo, int start, int length) throws BOSException, EASBizException {
        ArrayList<List> result = new ArrayList<List>();
        if (viewInfo != null) {
            viewInfo.setSelector(this.getLocationSelectors());
        }
        GeneVirtualModeQueryHelper helper = new GeneVirtualModeQueryHelper(parentNodeInfo.getBOSType());
        List locationList = helper.getGeneDataCollection(ctx, viewInfo, start, length);
        result.add(0, locationList);
        List archivesList = this.getArchivesByLocation(ctx, parentNodeInfo, start, length);
        result.add(1, archivesList);
        return result;
    }

    private List getArchivesByLocation(Context ctx, IGeneCoreTreeBaseInfo parentNodeInfo, int start, int length) throws BOSException, EASBizException {
        IEquipmentArchives ctrl = EquipmentArchivesFactory.getLocalInstance(ctx);
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(new FilterInfo());
        if (parentNodeInfo != null) {
            viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("location", (Object)parentNodeInfo.getId().toString(), CompareType.EQUALS));
        }
        viewInfo.getSorter().add(new SorterItemInfo("longNumber"));
        viewInfo.setSelector(this.getArchivesSelectors());
        GeneVirtualModeQueryHelper helper = new GeneVirtualModeQueryHelper(ctrl.getType());
        List archivesList = helper.getGeneDataCollection(ctx, viewInfo, start, length);
        return archivesList;
    }
}

