/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.archives.adjustment.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.AppLogFactory;
import com.kingdee.eas.base.log.IAppLog;
import com.kingdee.eas.base.log.app.LogServerUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.eqm.archives.EquipmentArchivesCollection;
import com.kingdee.eas.eqm.archives.EquipmentArchivesFactory;
import com.kingdee.eas.eqm.archives.EquipmentArchivesInfo;
import com.kingdee.eas.eqm.archives.IEquipmentArchives;
import com.kingdee.eas.eqm.archives.adjustment.ArchivesaAjustmentCollection;
import com.kingdee.eas.eqm.archives.adjustment.ArchivesaAjustmentFacadeFactory;
import com.kingdee.eas.eqm.archives.adjustment.ArchivesaAjustmentInfo;
import com.kingdee.eas.eqm.archives.adjustment.IArchivesaAjustmentFacade;
import com.kingdee.eas.eqm.archives.adjustment.app.AbstractArchivesaAjustmentControllerBean;
import com.kingdee.eas.eqm.archives.adjustment.app.util.ArchivesaAjustmentAuditUtil;
import com.kingdee.eas.eqm.archives.adjustment.app.verify.ArchivesaAjustmentAuditVerifyItem;
import com.kingdee.eas.eqm.archives.adjustment.app.verify.ArchivesaAjustmentSubmitVerifyItem;
import com.kingdee.eas.eqm.common.core.GeneBillBaseInfo;
import com.kingdee.eas.eqm.common.core.GeneException;
import com.kingdee.eas.eqm.common.core.app.util.GeneSeverMetadataUtils;
import com.kingdee.eas.eqm.common.core.util.GeneParamUtil;
import com.kingdee.eas.eqm.common.core.verify.IVerifyItem;
import com.kingdee.eas.eqm.common.core.verify.IVerifyManager;
import com.kingdee.eas.eqm.common.core.verify.VerifyManager;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class ArchivesaAjustmentControllerBean
extends AbstractArchivesaAjustmentControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.eqm.archives.adjustment.app.ArchivesaAjustmentControllerBean");
    private static String LOG_ITEM = "eqm_ArchivesaAjustment_audit";

    @Override
    public ArchivesaAjustmentInfo getArchivesaAjustmentInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        try {
            return super.getArchivesaAjustmentInfo(ctx, pk);
        }
        catch (ObjectNotFoundException e) {
            throw new GeneException(GeneException.OBJECTNOEXIST);
        }
    }

    @Override
    public ArchivesaAjustmentInfo getArchivesaAjustmentInfo(Context ctx, IObjectPK pk, SelectorItemCollection selector) throws BOSException, EASBizException {
        try {
            return super.getArchivesaAjustmentInfo(ctx, pk, selector);
        }
        catch (ObjectNotFoundException e) {
            throw new GeneException(GeneException.OBJECTNOEXIST);
        }
    }

    protected IVerifyManager getAuditVerifyManager(Context ctx, GeneBillBaseInfo info) {
        IVerifyManager verifymanager = super.getAuditVerifyManager(ctx, info);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("equipment.number"));
        sic.add(new SelectorItemInfo("equipment.storageOrgUnit.id"));
        sic.add(new SelectorItemInfo("equipment.planOrgUnit.id"));
        sic.add(new SelectorItemInfo("equipment.maintainOrgUnit.id"));
        sic.add(new SelectorItemInfo("equipment.location.id"));
        sic.add(new SelectorItemInfo("equipment.address.id"));
        sic.add(new SelectorItemInfo("equipment.parent.id"));
        sic.add(new SelectorItemInfo("equipment.usingDept.id"));
        ArchivesaAjustmentInfo info1 = null;
        try {
            info1 = this.getArchivesaAjustmentInfo(ctx, (IObjectPK)new ObjectUuidPK(info.getId()), sic);
        }
        catch (EASBizException e) {
            logger.error((Object)"error in ArchivesaAjustmentControllerBean:getAuditVerifyManager", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)"error in ArchivesaAjustmentControllerBean:getAuditVerifyManager", (Throwable)e);
        }
        ArchivesaAjustmentAuditVerifyItem verifyItem = new ArchivesaAjustmentAuditVerifyItem(ctx, (ArchivesaAjustmentInfo)(info1 == null ? info : info1));
        verifymanager.addVerifyItem((IVerifyItem)verifyItem);
        return verifymanager;
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ArchivesaAjustmentInfo info = (ArchivesaAjustmentInfo)model;
        this.getSubmitVerifyManager(ctx, info).verify();
        return super._submit(ctx, model);
    }

    protected boolean isAuditBySubmit(Context ctx, GeneBillBaseInfo info) throws BOSException, EASBizException {
        boolean isAutoAudit = GeneParamUtil.paramIsSelected((Context)ctx, (String)"EQM001", (String)info.getMainOrgUnit().getId().toString());
        return isAutoAudit;
    }

    protected IVerifyManager getSubmitVerifyManager(Context ctx, ArchivesaAjustmentInfo info) {
        VerifyManager verifymanager = new VerifyManager();
        ArchivesaAjustmentSubmitVerifyItem verifyItem = new ArchivesaAjustmentSubmitVerifyItem(ctx, info);
        verifymanager.addVerifyItem((IVerifyItem)verifyItem);
        return verifymanager;
    }

    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IArchivesaAjustmentFacade iaf = ArchivesaAjustmentFacadeFactory.getLocalInstance(ctx);
        IEquipmentArchives iea = EquipmentArchivesFactory.getLocalInstance(ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("equipment.number"));
        sic.add(new SelectorItemInfo("equipment.billStatus"));
        sic.add(new SelectorItemInfo("equipment.auditor.id"));
        sic.add(new SelectorItemInfo("equipment.auditTime"));
        sic.add(new SelectorItemInfo("equipment.lastUpdateUser.id"));
        sic.add(new SelectorItemInfo("equipment.lastUpdateTime"));
        sic.add(new SelectorItemInfo("equipment.storageOrgUnit.id"));
        sic.add(new SelectorItemInfo("equipment.planOrgUnit.id"));
        sic.add(new SelectorItemInfo("equipment.maintainOrgUnit.id"));
        sic.add(new SelectorItemInfo("equipment.location.id"));
        sic.add(new SelectorItemInfo("equipment.address.id"));
        sic.add(new SelectorItemInfo("equipment.parent.id"));
        sic.add(new SelectorItemInfo("equipment.usingDept.id"));
        sic.add(new SelectorItemInfo("equipment.dependable"));
        ArchivesaAjustmentInfo info = this.getArchivesaAjustmentInfo(ctx, pk, sic);
        EquipmentArchivesInfo currentEqm = info.getEquipment();
        if (null != currentEqm) {
            ArchivesaAjustmentAuditUtil.updateSourceArchivesInfoWhenAdjustOrderAudit(ctx, info);
        }
        super._audit(ctx, pk);
        info = this.getArchivesaAjustmentInfo(ctx, pk, sic);
        boolean flag = ArchivesaAjustmentAuditUtil.isAutoCreateChildAdjustOrder(ctx, info);
        ArchivesaAjustmentCollection adjustmentOrderCollection = new ArchivesaAjustmentCollection();
        if (flag) {
            int i;
            EquipmentArchivesCollection childEqmCollection = iaf.getChildsByEquipmentArchivesID(currentEqm, null);
            EquipmentArchivesCollection childEqmCollectionDependable = new EquipmentArchivesCollection();
            EquipmentArchivesCollection childEqmCollectionNoDependable = new EquipmentArchivesCollection();
            EquipmentArchivesInfo tmpInfo = null;
            int count = childEqmCollection.size();
            for (i = 0; i < count; ++i) {
                tmpInfo = childEqmCollection.get(i);
                if (tmpInfo.isDependable()) {
                    childEqmCollectionDependable.add(tmpInfo);
                    continue;
                }
                childEqmCollectionNoDependable.add(tmpInfo);
            }
            if (0 < childEqmCollectionDependable.size()) {
                adjustmentOrderCollection = iaf.autoCreateAdjustOrderByChildArchives(info, childEqmCollectionDependable);
            }
            if ((flag = ArchivesaAjustmentAuditUtil.isMoveUnDependableChildNode(ctx, info)) && 0 < childEqmCollectionNoDependable.size()) {
                count = childEqmCollectionNoDependable.size();
                for (i = 0; i < count; ++i) {
                    iea.moveTreeNode(childEqmCollectionNoDependable.get(i), null);
                }
            }
        }
        if (flag = ArchivesaAjustmentAuditUtil.isMoveNodeInCurrentOrder(ctx, info)) {
            iea.moveTreeNode(info.getEquipment(), info.getParentEqmD());
        }
        adjustmentOrderCollection.add(info);
        iaf.updateEquipmentArchivesByAdjustOrders(adjustmentOrderCollection);
        iaf.updateEquipmentArchivesChangingHistoryByAdjustOrder(adjustmentOrderCollection);
        this.writeLog(ctx, (GeneBillBaseInfo)info);
    }

    private void writeLog(Context ctx, GeneBillBaseInfo insertList) throws BOSException {
        IAppLog appLog = AppLogFactory.getLocalInstance((Context)ctx);
        EntityObjectInfo entityObjectInfo = GeneSeverMetadataUtils.getBOSEntity((Context)ctx, (BOSObjectType)this.getBOSType());
        HashMap<String, Object> hashLog = new HashMap<String, Object>();
        LogServerUtil.setLogInfo(null, (Context)ctx, hashLog);
        if (hashLog.get("FClientName") != null && !hashLog.get("FClientName").toString().equals("")) {
            return;
        }
        hashLog.put("isSuccessed", new Boolean(false));
        hashLog.put("successed", new Boolean(true));
        hashLog.put("FEntityID", this.getBOSType().toString());
        hashLog.put("FEntityName", entityObjectInfo.getName());
        hashLog.put("FEntityAlias_L1", entityObjectInfo.getAlias(ctx.getLocale()));
        hashLog.put("FEntityAlias_L2", entityObjectInfo.getAlias(ctx.getLocale()));
        hashLog.put("FEntityAlias_L3", entityObjectInfo.getAlias(ctx.getLocale()));
        hashLog.put("FMethodName", "audit");
        hashLog.put("FInstanceID", insertList.getId() == null ? null : insertList.getId().toString());
        hashLog.put("FInstanceNo", insertList.getLogInfo());
        hashLog.put("FItemName", LOG_ITEM);
        hashLog.put("LOG_HIDDEN_WRITE_MODE", "LOG_HIDDEN_WRITE_MODE");
        appLog.writeLog(hashLog);
    }
}

