/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.archives.adjustment.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.assistant.AddressInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.eqm.archives.EquipmentArchivesInfo;
import com.kingdee.eas.eqm.archives.adjustment.AdjustType;
import com.kingdee.eas.eqm.archives.adjustment.ArchivesaAjustmentInfo;
import com.kingdee.eas.eqm.common.core.util.GeneEqualsUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import org.apache.log4j.Logger;

public class ArchivesaAjustmentAuditUtil {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.eqm.archives.adjustment.app.util.ArchivesaAjustmentAuditUtil");

    private ArchivesaAjustmentAuditUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateSourceArchivesInfoWhenAdjustOrderAudit(Context ctx, ArchivesaAjustmentInfo info) throws BOSException, EASBizException {
        IORMappingDAO dao = null;
        Connection con = null;
        try {
            con = ArchivesaAjustmentAuditUtil.getConnection(ctx);
            dao = ORMappingDAO.getInstance((BOSObjectType)info.getBOSType(), (Context)ctx, (Connection)con);
            EquipmentArchivesInfo eqmInfo = info.getEquipment();
            info.setStorageOrgS(eqmInfo.getStorageOrgUnit());
            info.setPlanOrgS(eqmInfo.getPlanOrgUnit());
            info.setMaintainOrgS(eqmInfo.getMaintainOrgUnit());
            info.setLocationS(eqmInfo.getLocation());
            info.setAddressS(eqmInfo.getAddress());
            info.setParentEqmS(eqmInfo.getParent());
            info.setUsingDeptS(eqmInfo.getUsingDept());
            info.setBizStatusS(eqmInfo.getBizStatus());
            info.setDependableS(eqmInfo.isDependable());
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("storageOrgS"));
            sic.add(new SelectorItemInfo("planOrgS"));
            sic.add(new SelectorItemInfo("maintainOrgS"));
            sic.add(new SelectorItemInfo("locationS"));
            sic.add(new SelectorItemInfo("addressS"));
            sic.add(new SelectorItemInfo("parentEqmS"));
            sic.add(new SelectorItemInfo("usingDeptS"));
            sic.add(new SelectorItemInfo("bizStatusS"));
            sic.add(new SelectorItemInfo("dependableS"));
            dao.updatePartial((IObjectValue)info, sic);
        }
        finally {
            SQLUtils.cleanup((Connection)con);
        }
    }

    public static boolean isAutoCreateChildAdjustOrder(Context ctx, ArchivesaAjustmentInfo info) throws BOSException, EASBizException {
        boolean flag = false;
        if (null != info) {
            StorageOrgUnitInfo orgUnitS = info.getStorageOrgS();
            StorageOrgUnitInfo orgUnitD = info.getStorageOrgD();
            AddressInfo addressS = info.getAddressS();
            AddressInfo addressD = info.getAddressD();
            if (!GeneEqualsUtils.equals((Object)orgUnitS, (Object)orgUnitD)) {
                flag = true;
            }
            if (!flag && !GeneEqualsUtils.equals((Object)addressS, (Object)addressD)) {
                flag = true;
            }
        }
        return flag;
    }

    public static boolean isMoveUnDependableChildNode(Context ctx, ArchivesaAjustmentInfo info) throws BOSException, EASBizException {
        StorageOrgUnitInfo orgUnitD;
        StorageOrgUnitInfo orgUnitS;
        boolean flag = false;
        if (null != info && !GeneEqualsUtils.equals((Object)(orgUnitS = info.getStorageOrgS()), (Object)(orgUnitD = info.getStorageOrgD()))) {
            flag = true;
        }
        return flag;
    }

    public static boolean isMoveNodeInCurrentOrder(Context ctx, ArchivesaAjustmentInfo info) throws BOSException, EASBizException {
        EquipmentArchivesInfo parentEqmD;
        EquipmentArchivesInfo parentEqmS;
        boolean flag = false;
        if (null != info && !GeneEqualsUtils.equals((Object)(parentEqmS = info.getParentEqmS()), (Object)(parentEqmD = info.getParentEqmD()))) {
            flag = true;
        }
        return flag;
    }

    public static boolean isCheckUnClosedWorkOrder(Context ctx, ArchivesaAjustmentInfo info) throws BOSException, EASBizException {
        boolean flag = false;
        if (null != info) {
            AdjustType at = info.getAdjustType();
            if (AdjustType.CHANGE == at || AdjustType.REMOVE == at) {
                flag = true;
            }
            if (!flag) {
                StorageOrgUnitInfo orgUnitS = info.getStorageOrgS();
                StorageOrgUnitInfo orgUnitD = info.getStorageOrgD();
                StorageOrgUnitInfo planOrgUnitS = info.getPlanOrgS();
                StorageOrgUnitInfo planOrgUnitD = info.getPlanOrgD();
                StorageOrgUnitInfo maintainOrgUnitS = info.getMaintainOrgS();
                StorageOrgUnitInfo maintainOrgUnitD = info.getMaintainOrgD();
                if (!(GeneEqualsUtils.equals((Object)orgUnitS, (Object)orgUnitD) && GeneEqualsUtils.equals((Object)planOrgUnitS, (Object)planOrgUnitD) && GeneEqualsUtils.equals((Object)maintainOrgUnitS, (Object)maintainOrgUnitD))) {
                    flag = true;
                }
            }
        }
        return flag;
    }

    public static Connection getConnection(Context ctx) throws SQLDataException {
        try {
            return EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException sqle) {
            throw new SQLDataException(sqle);
        }
    }

    public static boolean isCheckUnClosedWorkOrderForCurrentAdjustOrder(Context ctx, ArchivesaAjustmentInfo info) throws BOSException, EASBizException {
        boolean flag = false;
        if (null != info) {
            AdjustType at = info.getAdjustType();
            if (AdjustType.CHANGE == at || AdjustType.REMOVE == at) {
                flag = true;
            }
            if (!flag) {
                StorageOrgUnitInfo orgUnitS = info.getStorageOrgS();
                StorageOrgUnitInfo orgUnitD = info.getStorageOrgD();
                StorageOrgUnitInfo planOrgUnitS = info.getPlanOrgS();
                StorageOrgUnitInfo planOrgUnitD = info.getPlanOrgD();
                StorageOrgUnitInfo maintainOrgUnitS = info.getMaintainOrgS();
                StorageOrgUnitInfo maintainOrgUnitD = info.getMaintainOrgD();
                if (!(GeneEqualsUtils.equals((Object)orgUnitS, (Object)orgUnitD) && GeneEqualsUtils.equals((Object)planOrgUnitS, (Object)planOrgUnitD) && GeneEqualsUtils.equals((Object)maintainOrgUnitS, (Object)maintainOrgUnitD))) {
                    flag = true;
                }
            }
        }
        return flag;
    }

    public static boolean isCheckUnClosedWorkOrderForChildAdjustOrder(Context ctx, ArchivesaAjustmentInfo info) throws BOSException, EASBizException {
        StorageOrgUnitInfo orgUnitD;
        StorageOrgUnitInfo orgUnitS;
        boolean flag = false;
        if (null != info && !flag && !GeneEqualsUtils.equals((Object)(orgUnitS = info.getStorageOrgS()), (Object)(orgUnitD = info.getStorageOrgD()))) {
            flag = true;
        }
        return flag;
    }

    public static String[] getBatchNumber(Context ctx, ArchivesaAjustmentInfo info, String storageOrgUnitId, int numberCount) {
        String[] str = null;
        try {
            ICodingRuleManager cr = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            CodingRuleInfo codingRuleInfo = cr.getCodingRule((IObjectValue)info, storageOrgUnitId);
            if (null != codingRuleInfo) {
                str = cr.getBatchNumber((IObjectValue)info, storageOrgUnitId, numberCount);
            }
        }
        catch (EASBizException e) {
            logger.error((Object)"error in ArchivesaAjustmentAuditUtil:getBatchNumber", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)"error in ArchivesaAjustmentAuditUtil:getBatchNumber", (Throwable)e);
        }
        return str;
    }

    public static String createTempTable(Context ctx, String createTableSQL) throws Exception {
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        return pool.createTempTable(createTableSQL);
    }

    public static void releaseTempTable(Context ctx, String tableName) {
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        pool.releaseTable(tableName);
    }

    public static void releasseAllTmpTable(Context ctx, List tmpTableNameList) {
        String str = null;
        int count = tmpTableNameList.size();
        for (int i = 0; i < count; ++i) {
            str = (String)tmpTableNameList.get(i);
            if (null == str || "".equals(str.trim())) continue;
            ArchivesaAjustmentAuditUtil.releaseTempTable(ctx, str);
        }
    }

    public static void handleException(Context ctx, EASBizException e, List tmpTableNameList) throws EASBizException {
        if (null != tmpTableNameList) {
            ArchivesaAjustmentAuditUtil.releasseAllTmpTable(ctx, tmpTableNameList);
            throw e;
        }
    }
}

