/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.archives.adjustment.app.verify;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.eqm.archives.EquipmentArchivesCollection;
import com.kingdee.eas.eqm.archives.EquipmentArchivesInfo;
import com.kingdee.eas.eqm.archives.adjustment.AdjustmentException;
import com.kingdee.eas.eqm.archives.adjustment.ArchivesaAjustmentFacadeFactory;
import com.kingdee.eas.eqm.archives.adjustment.ArchivesaAjustmentInfo;
import com.kingdee.eas.eqm.archives.adjustment.IArchivesaAjustmentFacade;
import com.kingdee.eas.eqm.archives.adjustment.app.util.ArchivesaAjustmentAuditUtil;
import com.kingdee.eas.eqm.common.core.util.GeneEqualsUtils;
import com.kingdee.eas.eqm.common.core.verify.AbstractVerifyItem;

public class ArchivesaAjustmentAuditVerifyItem
extends AbstractVerifyItem {
    private Context ctx;
    private ArchivesaAjustmentInfo info;

    public ArchivesaAjustmentAuditVerifyItem(Context ctx, ArchivesaAjustmentInfo info) {
        this.ctx = ctx;
        this.info = info;
    }

    public boolean verify() throws EASBizException, BOSException {
        String[] unCloseedWorkOrderNumber;
        int i;
        IArchivesaAjustmentFacade iaf = ArchivesaAjustmentFacadeFactory.getLocalInstance(this.ctx);
        EquipmentArchivesInfo currentEqm = this.info.getEquipment();
        if (!GeneEqualsUtils.equals((Object)this.info.getStorageOrgUnit(), (Object)this.info.getEquipment().getStorageOrgUnit())) {
            throw new AdjustmentException(AdjustmentException.UNCONSISTENTSTORAGEORGUNIT);
        }
        EquipmentArchivesCollection collection = new EquipmentArchivesCollection();
        boolean flag = ArchivesaAjustmentAuditUtil.isCheckUnClosedWorkOrderForCurrentAdjustOrder(this.ctx, this.info);
        if (flag) {
            collection.add(currentEqm);
        }
        if ((flag = ArchivesaAjustmentAuditUtil.isCheckUnClosedWorkOrderForChildAdjustOrder(this.ctx, this.info)) && (flag = ArchivesaAjustmentAuditUtil.isAutoCreateChildAdjustOrder(this.ctx, this.info))) {
            EquipmentArchivesCollection childEqmCollection = iaf.getChildsByEquipmentArchivesID(currentEqm, null);
            EquipmentArchivesInfo tmpInfo = null;
            int count = childEqmCollection.size();
            for (i = 0; i < count; ++i) {
                tmpInfo = childEqmCollection.get(i);
                if (!tmpInfo.isDependable()) continue;
                collection.add(tmpInfo);
            }
        }
        if (!collection.isEmpty() && null != (unCloseedWorkOrderNumber = iaf.getUnfinishedWorkOrder(collection)) && 0 < unCloseedWorkOrderNumber.length) {
            StringBuffer woNumbers = new StringBuffer();
            for (i = 0; i < unCloseedWorkOrderNumber.length; ++i) {
                woNumbers.append("\n").append(unCloseedWorkOrderNumber[i]);
            }
            throw new AdjustmentException(AdjustmentException.EXISTUNCLOSEDWORKORDEREXCEPTION, new String[]{woNumbers.toString()});
        }
        return true;
    }
}

