/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.archives.app;

import com.kingdee.bos.Context;
import com.kingdee.eas.base.param.BooleanDataType;
import com.kingdee.eas.eqm.archives.EquipmentBizStatus;
import com.kingdee.eas.eqm.archives.ProductUsageEnum;
import com.kingdee.eas.eqm.archives.RepairUnitTypeEnum;
import com.kingdee.eas.eqm.archives.SourceWayTypeEnum;
import com.kingdee.eas.eqm.archives.TimeUnitEnum;
import com.kingdee.eas.eqm.archives.app.DataImportEqmArchivesGroup;
import com.kingdee.eas.eqm.basedata.ABCIdentifyEnum;
import com.kingdee.eas.eqm.common.core.GeneBillBaseStatusEnum;
import com.kingdee.eas.eqm.common.eqmcore.app.util.DataImportEqmTools;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.Hashtable;
import java.util.Locale;

public class DataImportEqmArchives
extends DataImportEqmArchivesGroup {
    private static final String LEVEL_FLG = "\u00b7";

    @Override
    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = new Hashtable();
        try {
            Locale locale = ctx.getLocale();
            int intLevel = rs.getInt("level");
            String srtLevelFlg = "";
            for (int i = 0; i < intLevel; ++i) {
                srtLevelFlg = srtLevelFlg + LEVEL_FLG;
            }
            this.putTable(result, "FLevel", srtLevelFlg);
            this.putTable(result, "FNumber", rs.getString("number"));
            this.putTable(result, "FName", rs.getString("name"));
            this.putTable(result, "FStorageOrgUnit_Number", rs.getString("storageOrgUnit.number"));
            this.putTable(result, "FPlanOrgUnit_Number", rs.getString("planOrgUnit.number"));
            this.putTable(result, "FMaintainOrgUnit_Number", rs.getString("maintainOrgUnit.number"));
            this.putTable(result, "FMaintainDept_Number", rs.getString("maintainDept.number"));
            this.putTable(result, "FCategory_Number", rs.getString("category.number"));
            this.putTable(result, "FCategory_Name", rs.getString("category.name"));
            this.putTable(result, "FType_Number", rs.getString("type.number"));
            this.putTable(result, "FEffectDate", rs.getString("effectDate"));
            this.putTable(result, "FModel", rs.getString("model"));
            this.putTable(result, "FSize", rs.getString("size"));
            this.putTable(result, "FWeight", rs.getString("weight"));
            this.putTable(result, "FMaterial_Number", rs.getString("material.number"));
            this.putTable(result, "FMaterial_Name", rs.getString("material.name"));
            this.putTable(result, "FSerialNumber", rs.getString("serialNumber"));
            this.putTable(result, "FBizStatus", EquipmentBizStatus.getEnum(rs.getInt("bizStatus")).getAlias(locale));
            this.putTable(result, "FUnit_Number", rs.getString("unit.number"));
            this.putTable(result, "FBillStatus", GeneBillBaseStatusEnum.getEnum((int)rs.getInt("billStatus")).getAlias(locale));
            this.putTable(result, "FParent_Number", rs.getString("parent.number"));
            this.putTable(result, "FParent_Name", rs.getString("parent.name"));
            this.putTable(result, "FDependable", BooleanDataType.getEnum((String)rs.getString("dependable")).getAlias(locale));
            this.putTable(result, "FAddress_Number", rs.getString("address.number"));
            this.putTable(result, "FLocation_Number", rs.getString("location.number"));
            this.putTable(result, "FLocation_Name", rs.getString("location.name"));
            this.putTable(result, "FUsingDept_Number", rs.getString("usingDept.number"));
            this.putTable(result, "FResponsiblStaff_Number", rs.getString("responsiblStaff.number"));
            this.putTable(result, "FLogic", BooleanDataType.getEnum((String)rs.getString("logic")).getAlias(locale));
            this.putTable(result, "FSpecial", BooleanDataType.getEnum((String)rs.getString("special")).getAlias(locale));
            this.putTable(result, "FInitial", BooleanDataType.getEnum((String)rs.getString("initial")).getAlias(locale));
            this.putTable(result, "FMader", rs.getString("mader"));
            this.putTable(result, "FMadedCountry_Number", rs.getString("madedCountry.number"));
            this.putTable(result, "madeDate", rs.getString("madeDate"));
            this.putTable(result, "FSupplier_Number", rs.getString("supplier.number"));
            this.putTable(result, "FReachedDate", rs.getString("reachedDate"));
            this.putTable(result, "FIdentifyNumber", rs.getString("identifyNumber"));
            this.putTable(result, "FTechLevel_Number", rs.getString("techLevel.number"));
            this.putTable(result, "FAbcIdentify", ABCIdentifyEnum.getEnum((int)rs.getInt("abcIdentify")).getAlias(locale));
            this.putTable(result, "FInstaller_Number", rs.getString("installer.number"));
            this.putTable(result, "FDebuger_Number", rs.getString("debuger.number"));
            this.putTable(result, "FCheckDate", rs.getString("checkDate"));
            this.putTable(result, "FDeadline", DataImportEqmTools.getNumByPrecision((String)rs.getString("deadline"), (int)0));
            this.putTable(result, "FDeadlineUnit", TimeUnitEnum.getEnum(rs.getInt("deadlineUnit")).getAlias(locale));
            this.putTable(result, "FSourceWay_Number", rs.getString("sourceWay.number"));
            this.putTable(result, "FSourceWayType", SourceWayTypeEnum.getEnum(rs.getInt("sourceWayType")).getAlias(locale));
            this.putTable(result, "FSourceUnit", this.getSourceUnitNumber(ctx, rs));
            this.putTable(result, "FCapacity", DataImportEqmTools.getNumByPrecision((String)rs.getString("capacity"), (int)4));
            this.putTable(result, "FPower", DataImportEqmTools.getNumByPrecision((String)rs.getString("power"), (int)4));
            this.putTable(result, "FProductCapacity", rs.getString("productCapacity"));
            this.putTable(result, "FProductUsage", ProductUsageEnum.getEnum(rs.getInt("productUsage")).getAlias(locale));
            this.putTable(result, "FComRatiof", DataImportEqmTools.getNumByPrecision((String)rs.getString("comRatiof"), (int)4));
            this.putTable(result, "FComRatiod", DataImportEqmTools.getNumByPrecision((String)rs.getString("comRatiod"), (int)4));
            this.putTable(result, "FRepairStartDate", rs.getString("repairStartDate"));
            this.putTable(result, "FRepairEndDate", rs.getString("repairEndDate"));
            this.putTable(result, "FRepairNumber", rs.getString("repairNumber"));
            this.putTable(result, "FRepairUnitType", RepairUnitTypeEnum.getEnum(rs.getInt("repairUnitType")).getAlias(locale));
            this.putTable(result, "FRepairInherit", BooleanDataType.getEnum((String)rs.getString("repairInherit")).getAlias(locale));
            this.putTable(result, "FRepairExtend", BooleanDataType.getEnum((String)rs.getString("repairExtend")).getAlias(locale));
            this.putTable(result, "FAsset_Number", rs.getString("asset.number"));
            this.putTable(result, "FAssetValue", DataImportEqmTools.getNumByPrecision((String)rs.getString("assetValue"), (int)2));
            this.putTable(result, "FInstallFee", DataImportEqmTools.getNumByPrecision((String)rs.getString("installFee"), (int)2));
            this.putTable(result, "FAssetStatus_Number", rs.getString("assetStatus.number"));
            this.putTable(result, "FAuditor_Number", rs.getString("auditor.number"));
            this.putTable(result, "FAuditTime", rs.getString("auditTime"));
            this.putTable(result, "FDescription", rs.getString("description"));
        }
        catch (Exception e) {
            throw new TaskExternalException("", (Throwable)e);
        }
        return result;
    }
}

