/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.archives.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.param.BooleanDataType;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.app.service.OrgPermissionService;
import com.kingdee.eas.basedata.assistant.CountryFactory;
import com.kingdee.eas.basedata.assistant.CountryInfo;
import com.kingdee.eas.basedata.assistant.ICountry;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.ICustomer;
import com.kingdee.eas.basedata.master.cssp.ISupplier;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.cssp.app.DataImportUtils;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.eqm.archives.EquipmentArchivesFactory;
import com.kingdee.eas.eqm.archives.EquipmentArchivesInfo;
import com.kingdee.eas.eqm.archives.EquipmentBizStatus;
import com.kingdee.eas.eqm.archives.IEquipmentArchives;
import com.kingdee.eas.eqm.archives.ProductUsageEnum;
import com.kingdee.eas.eqm.archives.RepairUnitTypeEnum;
import com.kingdee.eas.eqm.archives.SourceWayTypeEnum;
import com.kingdee.eas.eqm.archives.TimeUnitEnum;
import com.kingdee.eas.eqm.archives.app.DataImportEqmArchivesGroupTools;
import com.kingdee.eas.eqm.basedata.ABCIdentifyEnum;
import com.kingdee.eas.eqm.basedata.EquipmentCategoryFactory;
import com.kingdee.eas.eqm.basedata.EquipmentCategoryInfo;
import com.kingdee.eas.eqm.basedata.EquipmentLocationFactory;
import com.kingdee.eas.eqm.basedata.EquipmentLocationInfo;
import com.kingdee.eas.eqm.basedata.EquipmentTechLevelFactory;
import com.kingdee.eas.eqm.basedata.EquipmentTechLevelInfo;
import com.kingdee.eas.eqm.basedata.IEquipmentCategory;
import com.kingdee.eas.eqm.basedata.IEquipmentLocation;
import com.kingdee.eas.eqm.basedata.IEquipmentTechLevel;
import com.kingdee.eas.eqm.common.core.GeneBillBaseStatusEnum;
import com.kingdee.eas.eqm.common.datatask.EQMBaseDataTransmission;
import com.kingdee.eas.eqm.common.eqmcore.EqmFinanceFacadeFactory;
import com.kingdee.eas.eqm.common.eqmcore.IEqmFinanceFacade;
import com.kingdee.eas.eqm.common.eqmcore.app.util.DataImportEqmTools;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;

public class DataImportEqmArchivesGroup
extends EQMBaseDataTransmission {
    private Boolean importDataByRule = null;
    private Boolean isEqmArchivesUsedCodingRule = null;
    private static final String EQUIPMENTARCHIVESGROUP_RESOURCE_PATH = "com.kingdee.eas.eqm.archives.EquipmentArchivesResource";
    private static final String ORG_TREE_ID = "00000000-0000-0000-0000-0000000000014F2827FD";

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return EquipmentArchivesFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        String orgNumber;
        EquipmentArchivesInfo info;
        String str;
        block104: {
            ISupplier iSupplier;
            str = null;
            StorageOrgUnitInfo storageInfo = null;
            StorageOrgUnitInfo planInfo = null;
            StorageOrgUnitInfo maintainInfo = null;
            info = new EquipmentArchivesInfo();
            Hashtable baseData = (Hashtable)hsData.get(new Integer(0));
            String orgId = null;
            orgNumber = this.getDataString(baseData, "FStorageOrgUnit_Number");
            if (orgNumber == null || "".equals(orgNumber.trim())) {
                throw new TaskExternalException(this.getResourceMsg("org_IsNotNull"));
            }
            this.isAuthorizedOrgUnit(ctx, orgNumber);
            try {
                storageInfo = this.getStorageOrgUnitInfoFromNumber(ctx, orgNumber);
                orgId = storageInfo.getId().toString();
            }
            catch (BOSException e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
            info.setStorageOrgUnit(storageInfo);
            str = this.getDataString(baseData, "FName");
            if (str == null || "".equals(str.trim())) {
                throw new TaskExternalException(this.getResourceMsg("name_IsNotNull"));
            }
            DataImportEqmTools.checkMaxLen((Context)ctx, (AbstractObjectValue)info, (String)str, (String)this.getResourceMsg("FName"), (int)80);
            info.setName(str);
            OrgPermissionService orgPermissionService = new OrgPermissionService(ctx);
            ObjectUuidPK userPK = new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
            ObjectUuidPK orgTreePK = new ObjectUuidPK(ORG_TREE_ID);
            FullOrgUnitCollection fullOrgUnitCollection = null;
            try {
                fullOrgUnitCollection = orgPermissionService.getOrgRange((IObjectPK)userPK, OrgType.Storage, (IObjectPK)orgTreePK);
            }
            catch (Exception e) {
                throw new TaskExternalException(this.getResourceMsg("getOrgRangeErr"));
            }
            str = this.getDataString(baseData, "FPlanOrgUnit_Number");
            if (str == null || "".equals(str.trim())) {
                throw new TaskExternalException(this.getResourceMsg("planOrgUnit_IsNotNull"));
            }
            try {
                planInfo = this.getStorageOrgUnitInfoFromNumber(ctx, str);
                if (!fullOrgUnitCollection.contains((Object)planInfo.getId())) {
                    throw new TaskExternalException(this.getResourceMsg("planOrg_NotIn_orgRange"));
                }
                info.setPlanOrgUnit(planInfo);
            }
            catch (BOSException e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
            str = this.getDataString(baseData, "FMaintainOrgUnit_Number");
            if (str == null || "".equals(str.trim())) {
                throw new TaskExternalException(this.getResourceMsg("maintainOrgUnit_IsNotNull"));
            }
            try {
                maintainInfo = this.getStorageOrgUnitInfoFromNumber(ctx, str);
                if (!fullOrgUnitCollection.contains((Object)maintainInfo.getId())) {
                    throw new TaskExternalException(this.getResourceMsg("maintainOrg_NotIn_orgRange"));
                }
                info.setMaintainOrgUnit(maintainInfo);
            }
            catch (BOSException e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
            str = this.getDataString(baseData, "FMaintainDept_Number");
            info.setMaintainDept(DataImportEqmArchivesGroupTools.getAdminOrgByStorageOrgUnit(ctx, str, orgId, "maintainDeptErr"));
            str = this.getDataString(baseData, "FCategory_Number");
            if (str == null || "".equals(str.trim())) {
                throw new TaskExternalException(this.getResourceMsg("category_IsNotNull"));
            }
            try {
                IEquipmentCategory iEquipmentCategory = EquipmentCategoryFactory.getLocalInstance((Context)ctx);
                info.setCategory((EquipmentCategoryInfo)this.getInfoByNumber(ctx, (ICoreBase)iEquipmentCategory, str, null, null));
            }
            catch (BOSException e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
            str = this.getDataString(baseData, "FType_Number");
            info.setType(DataImportEqmArchivesGroupTools.getTypeInfo(ctx, str));
            str = this.getDataString(baseData, "FEffectDate");
            Date effectDate = null;
            if (str == null || "".equals(str.trim())) {
                throw new TaskExternalException(this.getResourceMsg("effectDate_IsNotNull"));
            }
            try {
                effectDate = DataImportEqmTools.getFormatDate((String)str);
                info.setEffectDate(effectDate);
            }
            catch (ParseException e) {
                throw new TaskExternalException(this.getResourceMsg("effectDateErr"));
            }
            str = this.getDataString(baseData, "FModel");
            DataImportEqmTools.checkMaxLen((Context)ctx, (AbstractObjectValue)info, (String)str, (String)this.getResourceMsg("FModel"), (int)80);
            info.setModel(str);
            str = this.getDataString(baseData, "FSize");
            DataImportEqmTools.checkMaxLen((Context)ctx, (AbstractObjectValue)info, (String)str, (String)this.getResourceMsg("FSize"), (int)80);
            info.setSize(str);
            str = this.getDataString(baseData, "FWeight");
            DataImportEqmTools.checkMaxLen((Context)ctx, (AbstractObjectValue)info, (String)str, (String)this.getResourceMsg("FWeight"), (int)80);
            info.setWeight(str);
            str = this.getDataString(baseData, "FLogic");
            info.setLogic(DataImportEqmArchivesGroupTools.getBooleanDataType(str));
            try {
                this.doSomethingAboutLogic(info, baseData, ctx);
            }
            catch (Exception e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
            str = this.getDataString(baseData, "FBizStatus");
            if (str == null || "".equals(str.trim())) {
                throw new TaskExternalException(this.getResourceMsg("bizStatus_IsNotNull"));
            }
            info.setBizStatus(DataImportEqmArchivesGroupTools.getBizStatus(str));
            str = this.getDataString(baseData, "FUnit_Number");
            info.setUnit(DataImportEqmArchivesGroupTools.getMeasureUnitInfo(ctx, str));
            str = this.getDataString(baseData, "FBillStatus");
            if (str == null || "".equals(str.trim())) {
                throw new TaskExternalException(this.getResourceMsg("billStatus_IsNotNull"));
            }
            info.setBillStatus(DataImportEqmArchivesGroupTools.getBillBaseStatus(str));
            str = this.getDataString(baseData, "FSpecial");
            info.setSpecial(DataImportEqmArchivesGroupTools.getBooleanDataType(str));
            str = this.getDataString(baseData, "FInitial");
            info.setInitial(DataImportEqmArchivesGroupTools.getBooleanDataType(str));
            str = this.getDataString(baseData, "FDescription");
            DataImportEqmTools.checkMaxLen((Context)ctx, (AbstractObjectValue)info, (String)str, (String)this.getResourceMsg("FDescription"), (int)255);
            info.setDescription(str);
            str = this.getDataString(baseData, "FParent_Number");
            if (str != null && !"".equals(str.trim())) {
                DataImportEqmTools.checkMaxLen((Context)ctx, (AbstractObjectValue)info, (String)str, (String)this.getResourceMsg("FParent_Number"), (int)80);
                info.setParent(DataImportEqmArchivesGroupTools.getEquipmentArchivesInfo(ctx, str, orgId));
            }
            str = this.getDataString(baseData, "FDependable");
            boolean isDependable = false;
            if (DataImportEqmArchivesGroupTools.getBooleanDataType(str)) {
                if (info.getParent() != null) {
                    info.setAddress(info.getParent().getAddress());
                    isDependable = true;
                } else {
                    throw new TaskExternalException(this.getResourceMsg("FParent_Number_IsNotNull"));
                }
            }
            info.setDependable(isDependable);
            if (!isDependable) {
                str = this.getDataString(baseData, "FAddress_Number");
                info.setAddress(DataImportEqmArchivesGroupTools.getAddressInfo(ctx, str));
            }
            if ((str = this.getDataString(baseData, "FLocation_Number")) != null && !"".equals(str.trim())) {
                try {
                    IEquipmentLocation iEquipmentLocation = EquipmentLocationFactory.getLocalInstance((Context)ctx);
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("number", (Object)str));
                    filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)orgId));
                    filter.getFilterItems().add(new FilterItemInfo("installLimit", (Object)Boolean.TRUE));
                    EntityViewInfo viewInfo = new EntityViewInfo();
                    viewInfo.setFilter(filter);
                    info.setLocation((EquipmentLocationInfo)this.getInfoByNumber(ctx, (ICoreBase)iEquipmentLocation, str, orgNumber, viewInfo));
                }
                catch (BOSException e1) {
                    throw new TaskExternalException(e1.getMessage(), (Throwable)e1);
                }
            }
            str = this.getDataString(baseData, "FUsingDept_Number");
            info.setUsingDept(DataImportEqmArchivesGroupTools.getAdminOrgByStorageOrgUnit(ctx, str, orgId, "usingDeptErr"));
            str = this.getDataString(baseData, "FResponsiblStaff_Number");
            info.setResponsiblStaff(DataImportEqmArchivesGroupTools.getPersonInfo(ctx, str, orgId));
            str = this.getDataString(baseData, "FMader");
            DataImportEqmTools.checkMaxLen((Context)ctx, (AbstractObjectValue)info, (String)str, (String)this.getResourceMsg("FMader"), (int)80);
            info.setMader(str);
            str = this.getDataString(baseData, "FMadedCountry_Number");
            try {
                ICountry iCountry = CountryFactory.getLocalInstance((Context)ctx);
                info.setMadedCountry((CountryInfo)this.getInfoByNumber(ctx, (ICoreBase)iCountry, str, null, null));
            }
            catch (BOSException e1) {
                throw new TaskExternalException(e1.getMessage(), (Throwable)e1);
            }
            str = this.getDataString(baseData, "madeDate");
            Date madeDate = null;
            try {
                if (str != null && !"".equals(str.trim())) {
                    madeDate = DataImportEqmTools.getFormatDate((String)str);
                    info.setMadeDate(madeDate);
                }
            }
            catch (ParseException e) {
                throw new TaskExternalException(this.getResourceMsg("madeDateErr"));
            }
            if (effectDate != null && madeDate != null && madeDate.compareTo(effectDate) == 1) {
                throw new TaskExternalException(this.getResourceMsg("madeDate_effectDate_Err"));
            }
            str = this.getDataString(baseData, "FSupplier_Number");
            try {
                DataImportEqmTools.checkMaxLen((Context)ctx, (AbstractObjectValue)info, (String)str, (String)this.getResourceMsg("FSupplier_Number"), (int)80);
                iSupplier = SupplierFactory.getLocalInstance((Context)ctx);
                info.setSupplier((SupplierInfo)this.getInfoByNumber(ctx, (ICoreBase)iSupplier, str, null, null));
            }
            catch (BOSException e1) {
                throw new TaskExternalException(e1.getMessage(), (Throwable)e1);
            }
            str = this.getDataString(baseData, "FReachedDate");
            try {
                if (str != null && !"".equals(str.trim())) {
                    info.setReachedDate(DataImportEqmTools.getFormatDate((String)str));
                }
            }
            catch (ParseException e) {
                throw new TaskExternalException(this.getResourceMsg("FReachedDateErr"));
            }
            str = this.getDataString(baseData, "FIdentifyNumber");
            DataImportEqmTools.checkMaxLen((Context)ctx, (AbstractObjectValue)info, (String)str, (String)this.getResourceMsg("FIdentifyNumber"), (int)80);
            info.setIdentifyNumber(str);
            str = this.getDataString(baseData, "FTechLevel_Number");
            try {
                IEquipmentTechLevel iEquipmentTechLevel = EquipmentTechLevelFactory.getLocalInstance((Context)ctx);
                info.setTechLevel((EquipmentTechLevelInfo)this.getInfoByNumber(ctx, (ICoreBase)iEquipmentTechLevel, str, null, null));
            }
            catch (BOSException e1) {
                throw new TaskExternalException(e1.getMessage(), (Throwable)e1);
            }
            str = this.getDataString(baseData, "FAbcIdentify");
            if (str == null || "".equals(str.trim())) {
                throw new TaskExternalException(this.getResourceMsg("abcIdentify_IsNotNull"));
            }
            info.setAbcIdentify(DataImportEqmArchivesGroupTools.getAbcIdentify(str));
            str = this.getDataString(baseData, "FInstaller_Number");
            try {
                iSupplier = SupplierFactory.getLocalInstance((Context)ctx);
                info.setInstaller((SupplierInfo)this.getInfoByNumber(ctx, (ICoreBase)iSupplier, str, null, null));
            }
            catch (BOSException e1) {
                throw new TaskExternalException(this.getResourceMsg("FInstaller_NumberErr"), (Throwable)e1);
            }
            str = this.getDataString(baseData, "FDebuger_Number");
            try {
                iSupplier = SupplierFactory.getLocalInstance((Context)ctx);
                info.setDebuger((SupplierInfo)this.getInfoByNumber(ctx, (ICoreBase)iSupplier, str, null, null));
            }
            catch (BOSException e1) {
                throw new TaskExternalException(this.getResourceMsg("FDebuger_NumberErr"), (Throwable)e1);
            }
            str = this.getDataString(baseData, "FCheckDate");
            try {
                if (str != null && !"".equals(str.trim())) {
                    info.setCheckDate(DataImportEqmTools.getFormatDate((String)str));
                }
            }
            catch (ParseException e) {
                throw new TaskExternalException(this.getResourceMsg("FCheckDateErr"));
            }
            String timeLimit = this.getDataString(baseData, "FDeadline");
            if (timeLimit != null && !"".equals(timeLimit.trim())) {
                info.setDeadline(DataImportEqmTools.getNumByPrecision((String)timeLimit, (int)0, (String)this.getResourceMsg("FDeadline"), (boolean)true));
            }
            if ((str = this.getDataString(baseData, "FDeadlineUnit")) != null && !"".equals(str.trim())) {
                info.setDeadlineUnit(DataImportEqmArchivesGroupTools.getTimeUnit(str));
            }
            str = this.getDataString(baseData, "FSourceWay_Number");
            try {
                IEqmFinanceFacade fainanceFacade = EqmFinanceFacadeFactory.getLocalInstance((Context)ctx);
                CompanyOrgUnitInfo companyInfo = fainanceFacade.getFinanceOrg(storageInfo.getId().toString(), 4);
                if (companyInfo == null) {
                    throw new TaskExternalException(this.getResourceMsg("faAlterModeErr"));
                }
                IObjectValue sourceWay = DataImportEqmArchivesGroupTools.getFaAlterModeInfo(ctx, str, companyInfo.getId().toString());
                if (sourceWay != null) {
                    String sourceWayID = sourceWay.getBOSUuid("id").toString();
                    info.setSourcewayId(sourceWayID);
                }
            }
            catch (Exception e1) {
                throw new TaskExternalException(e1.getMessage(), (Throwable)e1);
            }
            str = this.getDataString(baseData, "FSourceWayType");
            info.setSourceWayType(DataImportEqmArchivesGroupTools.getSourceWayType(str));
            if (info.getSourceWayType() != null && (str = this.getDataString(baseData, "FSourceUnit")) != null && !str.trim().equals("")) {
                switch (info.getSourceWayType().getValue()) {
                    case 10: {
                        try {
                            ICustomer iCustomer = CustomerFactory.getLocalInstance((Context)ctx);
                            CustomerInfo customerInfo = (CustomerInfo)this.getInfoByNumber(ctx, (ICoreBase)iCustomer, str, null, null);
                            info.setSourceUnit(customerInfo.getId().toString());
                            break;
                        }
                        catch (BOSException e1) {
                            throw new TaskExternalException(this.getResourceMsg("CUSTOMER_VALUE_Err"));
                        }
                    }
                    case 20: {
                        try {
                            ISupplier iSupplier2 = SupplierFactory.getLocalInstance((Context)ctx);
                            SupplierInfo supplierInfo = (SupplierInfo)this.getInfoByNumber(ctx, (ICoreBase)iSupplier2, str, null, null);
                            info.setSourceUnit(supplierInfo.getId().toString());
                            break;
                        }
                        catch (BOSException e1) {
                            throw new TaskExternalException(this.getResourceMsg("SUPPLIER_VALUE_Err"));
                        }
                    }
                    case 30: {
                        try {
                            ICompanyOrgUnit iCompanyOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
                            CompanyOrgUnitInfo orgUnitInfo = (CompanyOrgUnitInfo)this.getInfoByNumber(ctx, (ICoreBase)iCompanyOrgUnit, str, null, null);
                            info.setSourceUnit(orgUnitInfo.getId().toString());
                            break;
                        }
                        catch (BOSException e1) {
                            throw new TaskExternalException(this.getResourceMsg("SELFCOMPANY_VALUE_Err"));
                        }
                    }
                }
            }
            if ((str = this.getDataString(baseData, "FCapacity")) != null && !"".equals(str.trim())) {
                info.setCapacity(DataImportEqmTools.getNumByPrecision((String)str, (int)4, (String)this.getResourceMsg("FCapacity"), (boolean)true));
            }
            if ((str = this.getDataString(baseData, "FPower")) != null && !"".equals(str.trim())) {
                info.setPower(DataImportEqmTools.getNumByPrecision((String)str, (int)4, (String)this.getResourceMsg("FPower"), (boolean)true));
            }
            str = this.getDataString(baseData, "FProductCapacity");
            DataImportEqmTools.checkMaxLen((Context)ctx, (AbstractObjectValue)info, (String)str, (String)this.getResourceMsg("FProductCapacity"), (int)100);
            info.setProductCapacity(str);
            str = this.getDataString(baseData, "FProductUsage");
            info.setProductUsage(DataImportEqmArchivesGroupTools.getProductUsage(str));
            str = this.getDataString(baseData, "FComRatiof");
            if (str != null && !"".equals(str.trim())) {
                info.setComRatiof(DataImportEqmTools.getNumByPrecision((String)str, (int)4, (String)this.getResourceMsg("FComRatiof"), (boolean)true));
            }
            if ((str = this.getDataString(baseData, "FComRatiod")) != null && !"".equals(str.trim())) {
                info.setComRatiod(DataImportEqmTools.getNumByPrecision((String)str, (int)4, (String)this.getResourceMsg("FComRatiod"), (boolean)true));
            }
            str = this.getDataString(baseData, "FRepairStartDate");
            Date repairStartDate = null;
            try {
                if (str != null && !"".equals(str.trim())) {
                    repairStartDate = DataImportEqmTools.getFormatDate((String)str);
                    info.setRepairStartDate(repairStartDate);
                }
            }
            catch (ParseException e) {
                throw new TaskExternalException(this.getResourceMsg("FRepairStartDateErr"));
            }
            str = this.getDataString(baseData, "FRepairEndDate");
            Date repairEndDate = null;
            try {
                if (str != null && !"".equals(str.trim())) {
                    repairEndDate = DataImportEqmTools.getFormatDate((String)str);
                    info.setRepairEndDate(repairEndDate);
                }
            }
            catch (ParseException e) {
                throw new TaskExternalException(this.getResourceMsg("FRepairEndDateErr"));
            }
            if (repairStartDate != null && repairEndDate != null && repairStartDate.compareTo(repairEndDate) == 1) {
                throw new TaskExternalException(this.getResourceMsg("repairDateErr"));
            }
            str = this.getDataString(baseData, "FRepairNumber");
            DataImportEqmTools.checkMaxLen((Context)ctx, (AbstractObjectValue)info, (String)str, (String)this.getResourceMsg("FRepairNumber"), (int)80);
            info.setRepairNumber(str);
            if (str != null && !"".equals(str.trim())) {
                str = this.getDataString(baseData, "FRepairUnitType");
                info.setRepairUnitType(DataImportEqmArchivesGroupTools.getRepairUnitType(str));
            }
            str = this.getDataString(baseData, "FRepairInherit");
            info.setRepairInherit(DataImportEqmArchivesGroupTools.getBooleanDataType(str, true));
            str = this.getDataString(baseData, "FRepairExtend");
            info.setRepairExtend(DataImportEqmArchivesGroupTools.getBooleanDataType(str, true));
            str = this.getDataString(baseData, "FInstallFee");
            if (str != null && !"".equals(str.trim())) {
                info.setInstallFee(DataImportEqmTools.getNumByPrecision((String)str, (int)2, (String)this.getResourceMsg("FInstallFee"), (boolean)true));
            }
            String auditor_Number = this.getDataString(baseData, "FAuditor_Number");
            String auditTime = this.getDataString(baseData, "FAuditTime");
            if (GeneBillBaseStatusEnum.Audit == info.getBillStatus()) {
                if (auditor_Number == null || "".equals(auditor_Number.trim())) {
                    throw new TaskExternalException(this.getResourceMsg("FAuditor_Number_IsNotNull"));
                }
                if (auditTime == null || "".equals(auditTime.trim())) {
                    throw new TaskExternalException(this.getResourceMsg("FAuditTime_IsNotNull"));
                }
                try {
                    IUser iUser = UserFactory.getLocalInstance((Context)ctx);
                    info.setAuditor((UserInfo)this.getInfoByNumber(ctx, (ICoreBase)iUser, auditor_Number, null, null));
                }
                catch (BOSException e1) {
                    throw new TaskExternalException(e1.getMessage(), (Throwable)e1);
                }
                try {
                    info.setAuditTime(DataImportEqmTools.getFormatDate((String)auditTime));
                }
                catch (ParseException e) {
                    throw new TaskExternalException(this.getResourceMsg("FAuditTimeErr"));
                }
            }
            str = this.getDataString(baseData, "FNumber");
            if (this.isImportDataByRule(ctx)) {
                str = null;
            }
            if (str == null || "".equals(str.trim())) {
                if (this.isImportDataByRule(ctx)) {
                    try {
                        str = this.getNumberByCodingRule(ctx, (IObjectValue)info);
                        if (str == null || "".equals(str)) {
                            throw new CodingRuleException(CodingRuleException.ERROR_CR_NOTEXIST, new Object[]{"\u8bbe\u5907\u6863\u6848"});
                        }
                        break block104;
                    }
                    catch (CodingRuleException e) {
                        throw new TaskExternalException(e.getMessage(), (Throwable)e);
                    }
                    catch (EASBizException e) {
                        throw new TaskExternalException(e.getMessage(), (Throwable)e);
                    }
                    catch (BOSException e) {
                        throw new TaskExternalException(e.getMessage(), (Throwable)e);
                    }
                }
                throw new TaskExternalException(this.getResourceMsg("number_IsNotNull"));
            }
        }
        DataImportEqmTools.checkMaxLen((Context)ctx, (AbstractObjectValue)info, (String)str, (String)this.getResourceMsg("FNumber"), (int)80);
        try {
            IEquipmentArchives iEquipmentArchives = EquipmentArchivesFactory.getLocalInstance(ctx);
            EquipmentArchivesInfo tempInfo = null;
            try {
                tempInfo = (EquipmentArchivesInfo)this.getInfoByNumber(ctx, (ICoreBase)iEquipmentArchives, str, orgNumber, null);
            }
            catch (BOSException e) {
                // empty catch block
            }
            if (tempInfo != null) {
                throw new TaskExternalException(this.getResourceMsg("numberIsExist"));
            }
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        info.setNumber(str);
        return info;
    }

    private boolean isEqmArchivesUsedCodingRule(Context ctx, String orgId) throws CodingRuleException, EASBizException, BOSException {
        if (this.isEqmArchivesUsedCodingRule != null) {
            return this.isEqmArchivesUsedCodingRule;
        }
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        EquipmentArchivesInfo info = new EquipmentArchivesInfo();
        boolean exist = iCodingRuleManager.isExist((IObjectValue)info, orgId);
        this.isEqmArchivesUsedCodingRule = exist;
        return exist;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = new Hashtable();
        try {
            Locale locale = ctx.getLocale();
            this.putTable(result, "FNumber", rs.getString("number"));
            this.putTable(result, "FName", rs.getString("name"));
            this.putTable(result, "FStorageOrgUnit_Number", rs.getString("storageOrgUnit.number"));
            this.putTable(result, "FPlanOrgUnit_Number", rs.getString("planOrgUnit.number"));
            this.putTable(result, "FMaintainOrgUnit_Number", rs.getString("maintainOrgUnit.number"));
            this.putTable(result, "FMaintainDept_Number", rs.getString("maintainDept.number"));
            this.putTable(result, "FCategory_Number", rs.getString("category.number"));
            this.putTable(result, "FCategory_Name", rs.getString("category.name"));
            this.putTable(result, "FType_Number", rs.getString("type.number"));
            this.putTable(result, "FEffectDate", rs.getString("effectDate"));
            this.putTable(result, "FModel", rs.getString("model"));
            this.putTable(result, "FSize", rs.getString("size"));
            this.putTable(result, "FWeight", rs.getString("weight"));
            this.putTable(result, "FMaterial_Number", rs.getString("material.number"));
            this.putTable(result, "FMaterial_Name", rs.getString("material.name"));
            this.putTable(result, "FSerialNumber", rs.getString("serialNumber"));
            this.putTable(result, "FBizStatus", EquipmentBizStatus.getEnum(rs.getInt("bizStatus")).getAlias(locale));
            this.putTable(result, "FUnit_Number", rs.getString("unit.number"));
            this.putTable(result, "FBillStatus", GeneBillBaseStatusEnum.getEnum((int)rs.getInt("billStatus")).getAlias(locale));
            this.putTable(result, "FParent_Number", rs.getString("parent.number"));
            this.putTable(result, "FParent_Name", rs.getString("parent.name"));
            this.putTable(result, "FDependable", BooleanDataType.getEnum((String)(rs.getString("dependable") != null ? rs.getString("dependable") : "false")).getAlias(locale));
            this.putTable(result, "FAddress_Number", rs.getString("address.number"));
            this.putTable(result, "FLocation_Number", rs.getString("location.number"));
            this.putTable(result, "FLocation_Name", rs.getString("location.name"));
            this.putTable(result, "FUsingDept_Number", rs.getString("usingDept.number"));
            this.putTable(result, "FResponsiblStaff_Number", rs.getString("responsiblStaff.number"));
            this.putTable(result, "FLogic", BooleanDataType.getEnum((String)(rs.getString("logic") != null ? rs.getString("logic") : "false")).getAlias(locale));
            this.putTable(result, "FSpecial", BooleanDataType.getEnum((String)(rs.getString("special") != null ? rs.getString("special") : "false")).getAlias(locale));
            this.putTable(result, "FInitial", BooleanDataType.getEnum((String)(rs.getString("initial") != null ? rs.getString("initial") : "false")).getAlias(locale));
            this.putTable(result, "FMader", rs.getString("mader"));
            this.putTable(result, "FMadedCountry_Number", rs.getString("madedCountry.number"));
            this.putTable(result, "madeDate", rs.getString("madeDate"));
            this.putTable(result, "FSupplier_Number", rs.getString("supplier.number"));
            this.putTable(result, "FReachedDate", rs.getString("reachedDate"));
            this.putTable(result, "FIdentifyNumber", rs.getString("identifyNumber"));
            this.putTable(result, "FTechLevel_Number", rs.getString("techLevel.number"));
            this.putTable(result, "FAbcIdentify", ABCIdentifyEnum.getEnum((int)rs.getInt("abcIdentify")).getAlias(locale));
            this.putTable(result, "FInstaller_Number", rs.getString("installer.number"));
            this.putTable(result, "FDebuger_Number", rs.getString("debuger.number"));
            this.putTable(result, "FCheckDate", rs.getString("checkDate"));
            this.putTable(result, "FDeadline", DataImportEqmTools.getNumByPrecision((String)rs.getString("deadline"), (int)0));
            this.putTable(result, "FDeadlineUnit", TimeUnitEnum.getEnum(rs.getInt("deadlineUnit")).getAlias(locale));
            this.putTable(result, "FSourceWay_Number", rs.getString("sourceWay.number"));
            this.putTable(result, "FSourceWayType", SourceWayTypeEnum.getEnum(rs.getInt("sourceWayType")).getAlias(locale));
            this.putTable(result, "FSourceUnit", this.getSourceUnitNumber(ctx, rs));
            this.putTable(result, "FCapacity", DataImportEqmTools.getNumByPrecision((String)rs.getString("capacity"), (int)4));
            this.putTable(result, "FPower", DataImportEqmTools.getNumByPrecision((String)rs.getString("power"), (int)4));
            this.putTable(result, "FProductCapacity", rs.getString("productCapacity"));
            this.putTable(result, "FProductUsage", ProductUsageEnum.getEnum(rs.getInt("productUsage")).getAlias(locale));
            this.putTable(result, "FComRatiof", DataImportEqmTools.getNumByPrecision((String)rs.getString("comRatiof"), (int)4));
            this.putTable(result, "FComRatiod", DataImportEqmTools.getNumByPrecision((String)rs.getString("comRatiod"), (int)4));
            this.putTable(result, "FRepairStartDate", rs.getString("repairStartDate"));
            this.putTable(result, "FRepairEndDate", rs.getString("repairEndDate"));
            this.putTable(result, "FRepairNumber", rs.getString("repairNumber"));
            this.putTable(result, "FRepairUnitType", RepairUnitTypeEnum.getEnum(rs.getInt("repairUnitType")).getAlias(locale));
            this.putTable(result, "FRepairInherit", BooleanDataType.getEnum((String)(rs.getString("repairInherit") != null ? rs.getString("repairInherit") : "false")).getAlias(locale));
            this.putTable(result, "FRepairExtend", BooleanDataType.getEnum((String)(rs.getString("repairExtend") != null ? rs.getString("repairExtend") : "false")).getAlias(locale));
            this.putTable(result, "FAsset_Number", rs.getString("asset.number"));
            this.putTable(result, "FAssetValue", DataImportEqmTools.getNumByPrecision((String)rs.getString("assetValue"), (int)2));
            this.putTable(result, "FInstallFee", DataImportEqmTools.getNumByPrecision((String)rs.getString("installFee"), (int)2));
            this.putTable(result, "FAssetStatus_Number", rs.getString("assetStatus.number"));
            this.putTable(result, "FAuditor_Number", rs.getString("auditor.number"));
            this.putTable(result, "FAuditTime", rs.getString("auditTime"));
            this.putTable(result, "FDescription", rs.getString("description"));
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public Object getSourceUnitNumber(Context ctx, IRowSet rs) throws SQLException {
        int sourceWayType = rs.getInt("sourceWayType");
        String id = rs.getString("sourceUnit");
        if (id == null || "".equals(id)) {
            return null;
        }
        switch (sourceWayType) {
            case 10: {
                return rs.getString("sourceUnit.number");
            }
            case 20: {
                return rs.getString("sourceUnit.number");
            }
            case 30: {
                ICompanyOrgUnit iOrgUnit = null;
                try {
                    ObjectUuidPK pk = new ObjectUuidPK(id);
                    iOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
                    CompanyOrgUnitInfo info = iOrgUnit.getCompanyOrgUnitInfo((IObjectPK)pk);
                    if (info != null) {
                        return info.getNumber();
                    }
                    break;
                }
                catch (Exception e) {
                    return null;
                }
            }
        }
        return null;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.eqm.archives.app.EquipmentArchivesQuery";
    }

    public int getSubmitType() {
        return 1;
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            EquipmentArchivesInfo equipmentArchivesInfo = (EquipmentArchivesInfo)coreBaseInfo;
            boolean isInitial = equipmentArchivesInfo.isInitial();
            equipmentArchivesInfo.setInitial(false);
            this.getController(ctx).addnew((CoreBaseInfo)equipmentArchivesInfo);
            if (isInitial) {
                ((IEquipmentArchives)this.getController(ctx)).finishInitial((IObjectPK)new ObjectUuidPK(equipmentArchivesInfo.getId().toString()), false);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    protected String getNumberByCodingRule(Context ctx, IObjectValue caller) throws BOSException, CodingRuleException, EASBizException {
        String number = null;
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        String orgId = iCodingRuleManager.getCurrentAppOUID(caller);
        if (this.isEqmArchivesUsedCodingRule(ctx, orgId)) {
            if (orgId == null || orgId.trim().length() == 0) {
                orgId = "00000000-0000-0000-0000-000000000000CCE7AED4";
            }
            number = iCodingRuleManager.getNumber(caller, orgId);
        }
        return number;
    }

    public boolean isSameBlock(Hashtable firstData, Hashtable currentData) {
        return false;
    }

    private String getResourceMsg(String key) {
        return ResourceUtils.getMessage((String)EQUIPMENTARCHIVESGROUP_RESOURCE_PATH, (String)key);
    }

    protected String getImportPermItemName() {
        return "eqm_equipmentarchives_13import";
    }

    protected boolean isImportDataByRule(Context ctx) throws TaskExternalException {
        if (this.importDataByRule == null) {
            try {
                this.importDataByRule = DataImportUtils.getImportParamBooleanObject((Context)ctx);
            }
            catch (EASBizException e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
            catch (BOSException e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
        }
        return this.importDataByRule;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doSomethingAboutLogic(EquipmentArchivesInfo info, Hashtable baseData, Context ctx) throws TaskExternalException, BOSException, EASBizException {
        String material_Number = this.getDataString(baseData, "FMaterial_Number");
        String serialNumber = this.getDataString(baseData, "FSerialNumber");
        String unit_Number = this.getDataString(baseData, "FUnit_Number");
        String asset_Number = this.getDataString(baseData, "FAsset_Number");
        String ssetValue = this.getDataString(baseData, "FAssetValue");
        String assetStatus_Number = this.getDataString(baseData, "FAssetStatus_Number");
        if (info.isLogic()) {
            if (material_Number != null && !"".equals(material_Number.trim())) {
                throw new TaskExternalException(this.getResourceMsg("material_Number_ReadOnly"));
            }
            if (asset_Number == null || "".equals(asset_Number.trim())) return;
            throw new TaskExternalException(this.getResourceMsg("asset_Number"));
        }
        IMeasureUnit iMeasureUnit = MeasureUnitFactory.getLocalInstance((Context)ctx);
        MeasureUnitInfo measureUnitInfo = (MeasureUnitInfo)this.getInfoByNumber(ctx, (ICoreBase)iMeasureUnit, unit_Number, null, null);
        if (material_Number != null && !"".equals(material_Number.trim())) {
            IMaterial iMat = MaterialFactory.getLocalInstance((Context)ctx);
            MaterialInfo materialInfo = (MaterialInfo)this.getInfoByNumber(ctx, (ICoreBase)iMat, material_Number, null, null);
            info.setMaterial(materialInfo);
            DataImportEqmTools.checkMaxLen((Context)ctx, (AbstractObjectValue)info, (String)serialNumber, (String)this.getResourceMsg("serialNumber"), (int)80);
            info.setSerialNumber(serialNumber);
            if (measureUnitInfo != null) {
                MultiMeasureUnitInfo multiMeasureUnitInfo = DataImportEqmArchivesGroupTools.getMultiMeasureUnit(ctx, materialInfo, measureUnitInfo);
                if (multiMeasureUnitInfo == null) throw new TaskExternalException(this.getResourceMsg("MeasureUnit_Err"));
                info.setUnit(measureUnitInfo);
            }
        } else {
            info.setUnit(measureUnitInfo);
        }
        if (asset_Number != null && !"".equals(asset_Number.trim())) {
            EntityViewInfo viewInfo = this.getDefaultView(asset_Number, null);
            viewInfo.getSelector().add("useStatus.id");
            viewInfo.getSelector().add("useStatus.number");
            viewInfo.getSelector().add("useStatus.name");
            viewInfo.getSelector().add("assetValue");
            viewInfo.getSelector().add("assetAmt");
            IObjectValue card = this.getInfoByNumber(ctx, BOSObjectType.create((String)"42AC39EC"), asset_Number, null, viewInfo);
            info.setAssetId(card.getBOSUuid("id").toString());
            info.setAssetValue(card.getBigDecimal("assetValue").divide(card.getBigDecimal("assetAmt"), 3, 0));
            if (card.getObjectValue("useStatus") == null) return;
            info.setAssetStatusId(card.getObjectValue("useStatus").getBOSUuid("id").toString());
            return;
        } else {
            if (ssetValue != null && !"".equals(ssetValue.trim())) {
                info.setAssetValue(DataImportEqmTools.getNumByPrecision((String)ssetValue, (int)2, (String)this.getResourceMsg("AssetValue"), (boolean)true));
            }
            info.setAssetStatusId(null);
        }
    }
}

