/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.archives.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.eqm.archives.EquipmentArchivesFactory;
import com.kingdee.eas.eqm.archives.EquipmentArchivesInfo;
import com.kingdee.eas.eqm.archives.EquipmentArchivesSCMException;
import com.kingdee.eas.eqm.archives.EquipmentBizStatus;
import com.kingdee.eas.eqm.archives.ProductUsageEnum;
import com.kingdee.eas.eqm.archives.SourceWayTypeEnum;
import com.kingdee.eas.eqm.archives.app.AbstractEquipmentArchivesBotpFacadeControllerBean;
import com.kingdee.eas.eqm.basedata.ABCIdentifyEnum;
import com.kingdee.eas.eqm.common.core.app.util.GeneDbUtil;
import com.kingdee.eas.eqm.common.core.util.GeneSelectorUtils;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.scm.im.inv.MaterialReqBillEntryCollection;
import com.kingdee.eas.scm.im.inv.MaterialReqBillEntryInfo;
import com.kingdee.eas.scm.im.inv.MaterialReqBillFactory;
import com.kingdee.eas.scm.im.inv.MaterialReqBillInfo;
import com.kingdee.eas.scm.im.inv.PurReceivalBillFactory;
import com.kingdee.eas.scm.im.inv.PurReceivalBillInfo;
import com.kingdee.eas.scm.im.inv.PurReceivalEntryCollection;
import com.kingdee.eas.scm.im.inv.PurReceivalEntryInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Locale;
import org.apache.log4j.Logger;

public class EquipmentArchivesBotpFacadeControllerBean
extends AbstractEquipmentArchivesBotpFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.eqm.archives.app.EquipmentArchivesBotpFacadeControllerBean");
    private static final String FileName = "com.kingdee.eas.eqm.archives.EquipmentArchivesBotpResource";

    @Override
    protected Object[] _geneEquipmentByPurReceivalBill(Context ctx, BOSUuid pk) throws BOSException, EASBizException {
        ObjectUuidPK purReceivalPK = new ObjectUuidPK(pk);
        PurReceivalBillInfo purReceivalInfo = PurReceivalBillFactory.getLocalInstance((Context)ctx).getPurReceivalBillInfo((IObjectPK)purReceivalPK, GeneSelectorUtils.getSelector((BOSObjectType)new PurReceivalBillInfo().getBOSType(), (String)"", (boolean)true, (boolean)true, (boolean)false));
        if (purReceivalInfo.getBaseStatus().getValue() == 4) {
            PurReceivalEntryCollection purReceivalEntrys = purReceivalInfo.getEntry();
            Object[] size = this.createEquipmentArchives1(ctx, purReceivalInfo, purReceivalEntrys);
            return size;
        }
        throw new EquipmentArchivesSCMException(EquipmentArchivesSCMException.PURRECEIVALBILLAUDIT);
    }

    private Object[] createEquipmentArchives1(Context ctx, PurReceivalBillInfo purReceivalInfo, PurReceivalEntryCollection purReceivalEntrys) throws EASBizException, BOSException {
        int size = 0;
        StringBuffer sb = new StringBuffer();
        PurReceivalEntryInfo purReceivalEntryInfo = null;
        for (int i = 0; i < purReceivalEntrys.size(); ++i) {
            purReceivalEntryInfo = purReceivalEntrys.get(i);
            if (purReceivalEntryInfo.getBillRowType() != null && purReceivalEntryInfo.getBillRowType().getNumber().equalsIgnoreCase("050")) {
                int sum;
                BigDecimal accuEquipmentArchiveQty = (BigDecimal)purReceivalEntryInfo.get("accuEquipmentArchiveQty");
                if (accuEquipmentArchiveQty == null) {
                    accuEquipmentArchiveQty = new BigDecimal(0);
                }
                if ((sum = purReceivalEntryInfo.getQty().intValue() - accuEquipmentArchiveQty.intValue()) > 0) {
                    for (int j = 0; j < sum; ++j) {
                        EquipmentArchivesInfo equipmentArchivesInfo = new EquipmentArchivesInfo();
                        equipmentArchivesInfo.setName(purReceivalEntryInfo.getNoNummaterialName());
                        equipmentArchivesInfo.setStorageOrgUnit(purReceivalInfo.getStorageOrgUnit());
                        equipmentArchivesInfo.setPlanOrgUnit(purReceivalInfo.getStorageOrgUnit());
                        equipmentArchivesInfo.setMaintainOrgUnit(purReceivalInfo.getStorageOrgUnit());
                        equipmentArchivesInfo.setModel(purReceivalEntryInfo.getNoNumMaterialModel());
                        equipmentArchivesInfo.setMaterial(purReceivalEntryInfo.getMaterial());
                        equipmentArchivesInfo.setUnit(purReceivalEntryInfo.getUnit());
                        equipmentArchivesInfo.setBizStatus(EquipmentBizStatus.using);
                        equipmentArchivesInfo.setUsingDept(purReceivalInfo.getAdminOrgUnit());
                        equipmentArchivesInfo.setMadeDate(purReceivalEntryInfo.getMfg());
                        equipmentArchivesInfo.setSupplier(purReceivalInfo.getSupplier());
                        equipmentArchivesInfo.setReachedDate(purReceivalInfo.getBizDate());
                        equipmentArchivesInfo.setAbcIdentify(ABCIdentifyEnum.GeneralLoc);
                        equipmentArchivesInfo.setSourceWayType(SourceWayTypeEnum.supplier);
                        equipmentArchivesInfo.setSourceUnit(purReceivalInfo.getSupplier() == null || purReceivalInfo.getSupplier().getId() == null ? null : purReceivalInfo.getSupplier().getId().toString());
                        equipmentArchivesInfo.setProductUsage(ProductUsageEnum.producted);
                        equipmentArchivesInfo.setRepairInherit(true);
                        equipmentArchivesInfo.setRepairExtend(true);
                        equipmentArchivesInfo.setEffectDate(new Timestamp(System.currentTimeMillis()));
                        equipmentArchivesInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
                        equipmentArchivesInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
                        equipmentArchivesInfo.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
                        equipmentArchivesInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
                        equipmentArchivesInfo.setFromBOTP(true);
                        equipmentArchivesInfo.setSourceBillId(purReceivalInfo.getId().toString());
                        equipmentArchivesInfo.setSourceBillNumber(purReceivalInfo.getNumber() + "PurReceivalBill");
                        equipmentArchivesInfo.setSourceFunction(purReceivalEntryInfo.getId().toString());
                        IObjectPK pk = EquipmentArchivesFactory.getLocalInstance(ctx).save((CoreBaseInfo)equipmentArchivesInfo);
                        ++size;
                        this.botpSave(ctx, "15F2BD83", "F6065B07", pk.toString(), purReceivalInfo.getId().toString());
                    }
                } else if (purReceivalEntryInfo.getQty().intValue() > 0) {
                    String msg = ResourceBase.getString((String)FileName, (String)"EntryHavedGenerate", (Locale)ContextUtils.getLocaleFromEnv());
                    sb.append(MessageFormat.format(msg, new Integer(purReceivalEntryInfo.getSeq()), new Integer(purReceivalEntryInfo.getQty().intValue())) + "\n");
                } else {
                    String msg = ResourceBase.getString((String)FileName, (String)"EntiryBelowZero", (Locale)ContextUtils.getLocaleFromEnv());
                    sb.append(MessageFormat.format(msg, new Integer(purReceivalEntryInfo.getSeq())) + "\n");
                }
                if (sum <= 0) continue;
                String msg = ResourceBase.getString((String)FileName, (String)"EntryGenetingEqm", (Locale)ContextUtils.getLocaleFromEnv());
                sb.append(MessageFormat.format(msg, new Integer(purReceivalEntryInfo.getSeq()), new Integer(sum)) + "\n");
                continue;
            }
            String msg = ResourceBase.getString((String)FileName, (String)"EntryNoSuitableCondition", (Locale)ContextUtils.getLocaleFromEnv());
            sb.append(MessageFormat.format(msg, new Integer(purReceivalEntryInfo.getSeq())) + "\n");
        }
        Object[] a = new Object[]{new Integer(size), sb.toString()};
        return a;
    }

    @Override
    protected Object[] _geneEquipmentByMaterialReqBill(Context ctx, BOSUuid pk) throws BOSException, EASBizException {
        ObjectUuidPK materialReqBillPK = new ObjectUuidPK(pk);
        SelectorItemCollection sic = GeneSelectorUtils.getSelector((BOSObjectType)new MaterialReqBillInfo().getBOSType(), (String)"", (boolean)true, (boolean)true, (boolean)false);
        sic.add("entry.material.model");
        sic.add("transactionType.billType.number");
        sic.add("transactionType.billType.id");
        sic.add("transactionType.billType.name");
        MaterialReqBillInfo materialReqInfo = MaterialReqBillFactory.getLocalInstance((Context)ctx).getMaterialReqBillInfo((IObjectPK)materialReqBillPK, sic);
        if (materialReqInfo.getBaseStatus().getValue() == 4 && materialReqInfo.getBizType() != null && materialReqInfo.getBizType().getNumber().equalsIgnoreCase("357")) {
            MaterialReqBillEntryCollection materialReqEntrys = materialReqInfo.getEntry();
            Object[] size = this.createEquipmentArchives2(ctx, materialReqInfo, materialReqEntrys);
            return size;
        }
        throw new EquipmentArchivesSCMException(EquipmentArchivesSCMException.MATERIALREQBILLAUDITEX);
    }

    private Object[] createEquipmentArchives2(Context ctx, MaterialReqBillInfo materialReqInfo, MaterialReqBillEntryCollection materialReqEntrys) throws EASBizException, BOSException {
        int size = 0;
        StringBuffer sb = new StringBuffer();
        MaterialReqBillEntryInfo materialReqEntryInfo = null;
        for (int i = 0; i < materialReqEntrys.size(); ++i) {
            int sum;
            materialReqEntryInfo = materialReqEntrys.get(i);
            BigDecimal accuEquipmentArchiveQty = (BigDecimal)materialReqEntryInfo.get("accuEquipmentArchiveQty");
            if (accuEquipmentArchiveQty == null) {
                accuEquipmentArchiveQty = new BigDecimal(0);
            }
            if ((sum = materialReqEntryInfo.getQty().intValue() - accuEquipmentArchiveQty.intValue()) > 0) {
                for (int j = 0; j < sum; ++j) {
                    EquipmentArchivesInfo equipmentArchivesInfo = new EquipmentArchivesInfo();
                    equipmentArchivesInfo.setName(materialReqEntryInfo.getMaterial().getName());
                    equipmentArchivesInfo.setStorageOrgUnit(materialReqInfo.getStorageOrgUnit());
                    equipmentArchivesInfo.setPlanOrgUnit(materialReqInfo.getStorageOrgUnit());
                    equipmentArchivesInfo.setMaintainOrgUnit(materialReqInfo.getStorageOrgUnit());
                    equipmentArchivesInfo.setModel(materialReqEntryInfo.getMaterial().getModel());
                    equipmentArchivesInfo.setMaterial(materialReqEntryInfo.getMaterial());
                    equipmentArchivesInfo.setUnit(materialReqEntryInfo.getUnit());
                    equipmentArchivesInfo.setBizStatus(EquipmentBizStatus.using);
                    equipmentArchivesInfo.setUsingDept(materialReqInfo.getAdminOrgUnit());
                    equipmentArchivesInfo.setMadeDate(materialReqEntryInfo.getMfg());
                    equipmentArchivesInfo.setSupplier(materialReqInfo.getSupplier());
                    equipmentArchivesInfo.setReachedDate(materialReqInfo.getBizDate());
                    equipmentArchivesInfo.setAbcIdentify(ABCIdentifyEnum.GeneralLoc);
                    equipmentArchivesInfo.setSourceWayType(SourceWayTypeEnum.supplier);
                    equipmentArchivesInfo.setSourceUnit(materialReqInfo.getSupplier() == null || materialReqInfo.getSupplier().getId() == null ? null : materialReqInfo.getSupplier().getId().toString());
                    equipmentArchivesInfo.setProductUsage(ProductUsageEnum.producted);
                    equipmentArchivesInfo.setRepairInherit(true);
                    equipmentArchivesInfo.setRepairExtend(true);
                    equipmentArchivesInfo.setFromBOTP(true);
                    equipmentArchivesInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
                    equipmentArchivesInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
                    equipmentArchivesInfo.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
                    equipmentArchivesInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
                    equipmentArchivesInfo.setEffectDate(new Timestamp(System.currentTimeMillis()));
                    equipmentArchivesInfo.setSourceBillId(materialReqInfo.getId().toString());
                    equipmentArchivesInfo.setSourceBillNumber(materialReqInfo.getNumber() + ";MaterialReqBill");
                    equipmentArchivesInfo.setSourceFunction(materialReqEntryInfo.getId().toString());
                    IObjectPK pk = EquipmentArchivesFactory.getLocalInstance(ctx).save((CoreBaseInfo)equipmentArchivesInfo);
                    ++size;
                    this.botpSave(ctx, "500AB75E", "F6065B07", pk.toString(), materialReqInfo.getId().toString());
                }
            } else if (materialReqEntryInfo.getQty().intValue() > 0) {
                String msg = ResourceBase.getString((String)FileName, (String)"EntryHavedGenerate", (Locale)ContextUtils.getLocaleFromEnv());
                sb.append(MessageFormat.format(msg, new Integer(materialReqEntryInfo.getSeq()), new Integer(materialReqEntryInfo.getQty().intValue())) + "\n");
            } else {
                String msg = ResourceBase.getString((String)FileName, (String)"EntiryBelowZero", (Locale)ContextUtils.getLocaleFromEnv());
                sb.append(MessageFormat.format(msg, new Integer(materialReqEntryInfo.getSeq())) + "\n");
            }
            if (sum <= 0) continue;
            String msg = ResourceBase.getString((String)FileName, (String)"EntryGenetingEqm", (Locale)ContextUtils.getLocaleFromEnv());
            sb.append(MessageFormat.format(msg, new Integer(materialReqEntryInfo.getSeq()), new Integer(sum)) + "\n");
        }
        Object[] a = new Object[]{new Integer(size), sb.toString()};
        return a;
    }

    private void botpSave(Context ctx, String srcEntityTypeID, String destEntityTypeID, String destObjectid, String srcObjectid) throws BOSException {
        String sql_addRelation = "insert into t_bot_relation(  FID,  FSRCENTITYID,  FDESTENTITYID,  FSRCOBJECTID,  FDESTOBJECTID,  FDATE,  FOPERATORID,  FISEFFECTED,  FBOTMAPPINGID,  FTYPE) Values(newbosid('59302EC6'),'" + srcEntityTypeID + "','" + destEntityTypeID + "','" + srcObjectid + "','" + destObjectid + "',now(),'" + ContextUtil.getCurrentUserInfo((Context)ctx).getName() + "',1,null,0)";
        GeneDbUtil.execute((Context)ctx, (String)sql_addRelation);
    }
}

