/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.archives.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.VerifyUtil;
import com.kingdee.eas.base.log.app.adapter.LogControllManager;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.eqm.archives.EquipmentAdjustHistoryFactory;
import com.kingdee.eas.eqm.archives.EquipmentAdjustHistoryInfo;
import com.kingdee.eas.eqm.archives.EquipmentArchivesException;
import com.kingdee.eas.eqm.archives.EquipmentArchivesInfo;
import com.kingdee.eas.eqm.archives.EquipmentOrgTypeEnum;
import com.kingdee.eas.eqm.archives.app.AbstractEquipmentArchivesControllerBean;
import com.kingdee.eas.eqm.basedata.IEquipmentReadingCommon;
import com.kingdee.eas.eqm.basedata.app.EquipmentReadingServerUtils;
import com.kingdee.eas.eqm.common.core.GeneBillBaseInfo;
import com.kingdee.eas.eqm.common.core.GeneBillBaseStatusEnum;
import com.kingdee.eas.eqm.common.core.GeneException;
import com.kingdee.eas.eqm.common.core.IGeneCoreTreeBaseInfo;
import com.kingdee.eas.eqm.common.core.app.GeneCoreTreeBaseControllerBeanTools;
import com.kingdee.eas.eqm.common.core.codingrule.ISuportCodingRule;
import com.kingdee.eas.eqm.common.core.codingrule.ISuportCodingRuleInfo;
import com.kingdee.eas.eqm.common.core.util.GeneEqualsUtils;
import com.kingdee.eas.eqm.common.core.util.GeneParamUtil;
import com.kingdee.eas.eqm.common.core.verify.IVerifyManager;
import com.kingdee.eas.framework.BaseTreeModel;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.framework.Result;
import com.kingdee.eas.framework.TreeBaseException;
import com.kingdee.eas.framework.app.ObjectBaseControllerBean;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class EquipmentArchivesControllerBean
extends AbstractEquipmentArchivesControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.eqm.archives.app.EquipmentArchivesControllerBean");
    private static final String EQUIPMENTARCHIVESGROUP_RESOURCE_PATH = "com.kingdee.eas.eqm.archives.EquipmentArchivesResource";
    GeneCoreTreeBaseControllerBeanTools tools = new GeneCoreTreeBaseControllerBeanTools((ObjectBaseControllerBean)this, this.getBOSType());
    EquipmentReadingServerUtils serverUtils = new EquipmentReadingServerUtils();

    @Override
    protected void _checkParentDataExist(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, TreeBaseException, EASBizException {
        this.tools.checkParentDataExist(ctx, pk, model);
    }

    @Override
    protected void _checkParentValid(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, TreeBaseException, EASBizException {
        this.tools.checkParentValid(ctx, pk, model);
    }

    @Override
    protected void _checkParentBeUsed(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, TreeBaseException, EASBizException {
        this.tools.checkParentBeUsed(ctx, pk, model);
    }

    @Override
    protected IObjectValue _getRoot(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return this.tools.getRoot(ctx, model);
    }

    @Override
    protected IObjectCollection _getChildren(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return this.tools.getChildren(ctx, model);
    }

    @Override
    protected IObjectCollection _getAllChildren(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return this.tools.getAllChildren(ctx, model);
    }

    @Override
    protected BaseTreeModel _getTreeModel(Context ctx, IObjectValue node) throws BOSException, EASBizException {
        return this.tools.getTreeModel(ctx, node);
    }

    @Override
    protected void _deleteWithChildren(Context ctx, IObjectValue model) throws BOSException, TreeBaseException, EASBizException {
        this.tools.deleteWithChildren(ctx, model);
    }

    @Override
    protected IObjectValue _getValueWithParent(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return this.tools.getValueWithParent(ctx, pk);
    }

    @Override
    protected IObjectCollection _getAllChildren(Context ctx, IObjectValue model, EntityViewInfo view) throws BOSException, EASBizException {
        return this.tools.getAllChildren(ctx, model, view);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IGeneCoreTreeBaseInfo info = null;
        info = (IGeneCoreTreeBaseInfo)this.tools.getValueWithParent(ctx, pk);
        this.tools.checkDelete(ctx, info);
        this.serverUtils.checkDelete(ctx, info);
        super._delete(ctx, pk);
        this.tools.afterDelete(ctx, info);
    }

    @Override
    protected void _moveTreeNode(Context ctx, IObjectValue sourceNode, IObjectValue targetNode) throws BOSException, EASBizException {
        this.tools.moveTreeNode(ctx, sourceNode, targetNode);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        model = this.tools.updateTreePropertiesOnAddNew(ctx, model);
        IObjectPK objPK = super._addnew(ctx, model);
        this.serverUtils.synEquipmentReading(ctx, model);
        return objPK;
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK pk = super._submit(ctx, model);
        GeneBillBaseInfo info = (GeneBillBaseInfo)model;
        if (this.isAutoInitiation(ctx, info)) {
            this._finishInitial(ctx, (IObjectPK)new ObjectUuidPK(info.getId().toString()), false);
        }
        return pk;
    }

    private boolean isAutoInitiation(Context ctx, GeneBillBaseInfo info) throws BOSException, EASBizException {
        return GeneParamUtil.paramIsSelected((Context)ctx, (String)"EQM007", (String)info.getMainOrgUnit().getId().toString());
    }

    protected boolean isAuditBySubmit(Context ctx, GeneBillBaseInfo info) throws BOSException, EASBizException {
        return GeneParamUtil.paramIsSelected((Context)ctx, (String)"EQM006", (String)info.getMainOrgUnit().getId().toString());
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        model = this.tools.updateTreePropertiesOnAddNew(ctx, pk, model);
        GeneBillBaseInfo info = (GeneBillBaseInfo)model;
        VerifyUtil.checkBlank((Context)ctx, (IObjectValue)info, (String)info.getBizOrgPropertyName());
        this.getCodingRuleStrategy().initNumber((ISuportCodingRule)this, ctx, (ISuportCodingRuleInfo)info);
        LogControllManager.getInstance().enableLog();
        this.logAddnew(ctx, info);
        this._checkNumberBlank(ctx, null, (IObjectValue)info);
        this._checkNumberDup(ctx, null, (IObjectValue)info);
        IVerifyManager verifymanager = this.getAddnewVerifyManager(ctx, info);
        verifymanager.verify();
        super._addnew(ctx, pk, model);
        this.serverUtils.synEquipmentReading(ctx, model);
    }

    protected Result _addnew(Context ctx, IObjectCollection colls) throws BOSException, EASBizException {
        for (IObjectValue value : colls) {
            GeneBillBaseInfo info = (GeneBillBaseInfo)value;
            VerifyUtil.checkBlank((Context)ctx, (IObjectValue)info, (String)info.getBizOrgPropertyName());
            this.getCodingRuleStrategy().initNumber((ISuportCodingRule)this, ctx, (ISuportCodingRuleInfo)info);
            LogControllManager.getInstance().enableLog();
            this.logAddnew(ctx, info);
            this._checkNumberBlank(ctx, null, (IObjectValue)info);
            this._checkNumberDup(ctx, null, (IObjectValue)info);
            IVerifyManager verifymanager = this.getAddnewVerifyManager(ctx, info);
            verifymanager.verify();
            value = this.tools.updateTreePropertiesOnAddNew(ctx, value);
            this.serverUtils.synEquipmentReading(ctx, value);
        }
        return super._addnew(ctx, colls);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        model = this.tools.updateTreePropertyOnUpdate(ctx, pk, model);
        EquipmentArchivesInfo oldInfo = (EquipmentArchivesInfo)this.getValue(ctx, pk);
        EquipmentArchivesInfo newInfo = (EquipmentArchivesInfo)model;
        boolean isParentChanged = false;
        if (!GeneEqualsUtils.equals((Object)oldInfo.getParent(), (Object)newInfo.getParent())) {
            isParentChanged = true;
        }
        super._update(ctx, pk, model);
        oldInfo.setLastUpdateTime(newInfo.getLastUpdateTime());
        oldInfo.setLastUpdateUser(newInfo.getLastUpdateUser());
        Object from = newInfo.get("From");
        if (isParentChanged && from == null) {
            this.setCheckLastUptTime(false);
            oldInfo.put("AllInfo", "AllInfo");
            this.moveTreeNode(ctx, oldInfo, newInfo.getParent());
            this.setCheckLastUptTime(true);
        }
        this.serverUtils.synEquipmentReading(ctx, model);
    }

    protected Result _update(Context ctx, IObjectCollection colls) throws BOSException, EASBizException {
        for (IObjectValue value : colls) {
            value = this.tools.updateTreePropertyOnUpdate(ctx, (IObjectPK)new ObjectUuidPK(((ObjectBaseInfo)value).getId().toString()), value);
            this.serverUtils.synEquipmentReading(ctx, value);
        }
        return super._update(ctx, colls);
    }

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk, SelectorItemCollection selector) throws BOSException, EASBizException {
        IEquipmentReadingCommon info = (IEquipmentReadingCommon)super._getValue(ctx, pk, selector);
        this.serverUtils.loadMeter(ctx, info);
        return info;
    }

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IEquipmentReadingCommon info = (IEquipmentReadingCommon)super._getValue(ctx, pk);
        this.serverUtils.loadMeter(ctx, info);
        return info;
    }

    protected IObjectValue _getValue(Context ctx, IObjectPK pk, SelectorItemCollection selector, SorterItemCollection sorter) throws BOSException, EASBizException {
        IEquipmentReadingCommon info = (IEquipmentReadingCommon)super._getValue(ctx, pk, selector, sorter);
        this.serverUtils.loadMeter(ctx, info);
        return info;
    }

    protected IObjectValue _getValue(Context ctx, IObjectPK pk, SorterItemCollection sorter) throws BOSException, EASBizException {
        IEquipmentReadingCommon info = (IEquipmentReadingCommon)super._getValue(ctx, pk, sorter);
        this.serverUtils.loadMeter(ctx, info);
        return info;
    }

    @Override
    protected IObjectValue _getValue(Context ctx, String oql) throws BOSException, EASBizException {
        IEquipmentReadingCommon info = (IEquipmentReadingCommon)super._getValue(ctx, oql);
        this.serverUtils.loadMeter(ctx, info);
        return info;
    }

    @Override
    protected void _finishInitial(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this._finishInitial(ctx, pk, true);
    }

    @Override
    protected void _finishInitial(Context ctx, IObjectPK pk, boolean isCheckStatus) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        if (isCheckStatus) {
            sql.append(" SELECT FBillStatus,FInitial,FNumber FROM T_EQM_EquipmentArchives WHERE FID = ? ");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{pk.toString()});
            try {
                if (rowSet.next()) {
                    String number = rowSet.getString("FNumber");
                    int billStatus = rowSet.getInt("FBillStatus");
                    int initial = rowSet.getInt("FInitial");
                    if (initial == 1) {
                        throw new EquipmentArchivesException(EquipmentArchivesException.MSG_ALREADYINITIAL, new Object[]{number});
                    }
                    if (billStatus != 30) {
                        throw new EquipmentArchivesException(EquipmentArchivesException.CHECK_NOTAUDITED, new Object[]{number, GeneBillBaseStatusEnum.getEnum((int)billStatus).getAlias()});
                    }
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        sql.setLength(0);
        sql.append(" UPDATE T_EQM_EquipmentArchives SET FInitial = ? WHERE FID = ? ");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{Boolean.TRUE, pk.toString()});
        try {
            sql.setLength(0);
            sql.append(" Select FID,FMaintainOrgUnitID,FPlanOrgUnitID,FStorageOrgUnitID From T_EQM_EquipmentArchives Where FID = ? ");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{pk.toString()});
            CoreBaseCollection l = new CoreBaseCollection();
            while (rs.next()) {
                EquipmentArchivesInfo archivesInfo = new EquipmentArchivesInfo();
                archivesInfo.setId(BOSUuid.read((String)rs.getString("FID")));
                EquipmentAdjustHistoryInfo storage = new EquipmentAdjustHistoryInfo();
                storage.setEquipment(archivesInfo);
                storage.setBizOrgType(EquipmentOrgTypeEnum.ownedOrg);
                storage.setOrgType(OrgType.Storage);
                storage.setOrgID(rs.getString("FStorageOrgUnitID"));
                l.add((CoreBaseInfo)storage);
                EquipmentAdjustHistoryInfo maintain = new EquipmentAdjustHistoryInfo();
                maintain.setEquipment(archivesInfo);
                maintain.setBizOrgType(EquipmentOrgTypeEnum.maintainedOrg);
                maintain.setOrgType(OrgType.Storage);
                maintain.setOrgID(rs.getString("FMaintainOrgUnitID"));
                l.add((CoreBaseInfo)maintain);
                EquipmentAdjustHistoryInfo plan = new EquipmentAdjustHistoryInfo();
                plan.setEquipment(archivesInfo);
                plan.setBizOrgType(EquipmentOrgTypeEnum.plannedOrg);
                plan.setOrgType(OrgType.Storage);
                plan.setOrgID(rs.getString("FPlanOrgUnitID"));
                l.add((CoreBaseInfo)plan);
            }
            EquipmentAdjustHistoryFactory.getLocalInstance(ctx).addnew(l);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    public EquipmentArchivesInfo getEquipmentArchivesInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        try {
            return super.getEquipmentArchivesInfo(ctx, pk);
        }
        catch (ObjectNotFoundException e) {
            throw new GeneException(GeneException.OBJECTNOEXIST);
        }
    }

    @Override
    public EquipmentArchivesInfo getEquipmentArchivesInfo(Context ctx, IObjectPK pk, SelectorItemCollection selector) throws BOSException, EASBizException {
        try {
            return super.getEquipmentArchivesInfo(ctx, pk, selector);
        }
        catch (ObjectNotFoundException e) {
            throw new GeneException(GeneException.OBJECTNOEXIST);
        }
    }

    @Override
    protected List _getBotpList(Context ctx, List idList) throws BOSException, EASBizException {
        ArrayList geneList = new ArrayList();
        ArrayList<String> unGeneList = new ArrayList<String>();
        for (int i = 0; i < idList.size(); ++i) {
            EquipmentArchivesInfo info = super.getEquipmentArchivesInfo(ctx, (IObjectPK)new ObjectUuidPK(idList.get(i).toString()));
            if (info.isHasDestBill()) {
                unGeneList.add(info.getNumber() + " " + EquipmentArchivesControllerBean.getString(ctx, "CheckHasDestBill"));
                continue;
            }
            if (!info.isInitial()) {
                unGeneList.add(info.getNumber() + " " + EquipmentArchivesControllerBean.getString(ctx, "CheckNotInitial"));
                continue;
            }
            if (info.isLogic()) {
                unGeneList.add(info.getNumber() + " " + EquipmentArchivesControllerBean.getString(ctx, "CheckLogic"));
                continue;
            }
            if (info.getAssetId() != null) {
                unGeneList.add(info.getNumber() + " " + EquipmentArchivesControllerBean.getString(ctx, "CheckAssetNotNull"));
                continue;
            }
            OrgUnitCollection unitCol = OrgUnitRelationFactory.getLocalInstance((Context)ctx).getToUnit(info.getStorageOrgUnit().getId().toString(), 4, 1);
            if (unitCol == null || unitCol.size() < 1) {
                unGeneList.add(info.getNumber() + " " + EquipmentArchivesControllerBean.getString(ctx, "CheckToOrgIsNull"));
                continue;
            }
            geneList.add(idList.get(i));
        }
        if (geneList.size() < 1) {
            StringBuffer tips = new StringBuffer();
            for (int i = 0; i < unGeneList.size(); ++i) {
                tips.append("\n").append(unGeneList.get(i));
            }
            throw new EquipmentArchivesException(EquipmentArchivesException.CHECK_BOTP, new Object[]{tips.toString()});
        }
        return geneList;
    }

    public static String getString(Context ctx, String resourceName) {
        String strTemp = ResourceBase.getString((String)EQUIPMENTARCHIVESGROUP_RESOURCE_PATH, (String)resourceName, (Locale)ctx.getLocale());
        if (strTemp.equals("Missing Resource")) {
            return "Missing Resource{" + resourceName + "}";
        }
        return strTemp;
    }
}

