/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.archives.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.eqm.archives.EquipmentArchivesFactory;
import com.kingdee.eas.eqm.archives.EquipmentArchivesInfo;
import com.kingdee.eas.eqm.archives.app.AbstractEquipmentArchivesExpireCheckFacadeControllerBean;
import com.kingdee.eas.eqm.common.core.util.GeneDateUtils;
import java.util.Date;
import org.apache.log4j.Logger;

public class EquipmentArchivesExpireCheckFacadeControllerBean
extends AbstractEquipmentArchivesExpireCheckFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.eqm.archives.app.EquipmentArchivesExpireCheckFacadeControllerBean");

    @Override
    protected boolean _isNotExpired(Context ctx, EquipmentArchivesInfo equipmentArchivesInfo) throws BOSException, EASBizException {
        boolean isNotExpired = false;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("repairStartDate"));
        sic.add(new SelectorItemInfo("repairEndDate"));
        equipmentArchivesInfo = (EquipmentArchivesInfo)EquipmentArchivesFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(equipmentArchivesInfo.getId().toString()), sic);
        Date repairStartDate = equipmentArchivesInfo.getRepairStartDate();
        Date repairEndDate = equipmentArchivesInfo.getRepairEndDate();
        if (repairStartDate == null && repairEndDate == null) {
            isNotExpired = false;
        } else if (repairStartDate != null && repairEndDate == null) {
            try {
                if (GeneDateUtils.compareToNowByDate((Date)repairStartDate) >= 0) {
                    isNotExpired = true;
                }
                isNotExpired = false;
            }
            catch (Exception e) {
                throw new BOSException("Date Parse Exception : ", (Throwable)e);
            }
        } else if (repairStartDate == null && repairEndDate != null) {
            try {
                if (GeneDateUtils.compareToNowByDate((Date)repairEndDate) <= 0) {
                    isNotExpired = true;
                }
                isNotExpired = false;
            }
            catch (Exception e) {
                throw new BOSException("Date Parse Exception : ", (Throwable)e);
            }
        } else {
            try {
                isNotExpired = GeneDateUtils.compareToNowByDate((Date)repairStartDate) >= 0 && GeneDateUtils.compareToNowByDate((Date)repairEndDate) <= 0;
            }
            catch (Exception e) {
                throw new BOSException("Date Parse Exception : ", (Throwable)e);
            }
        }
        return isNotExpired;
    }
}

