/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.archives.datatask;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.basedata.master.material.app.DataImportTools;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.eqm.archives.EquipmentArchivesAttachToolFactory;
import com.kingdee.eas.eqm.archives.EquipmentArchivesAttachToolInfo;
import com.kingdee.eas.eqm.archives.TimeUnitEnum;
import com.kingdee.eas.eqm.archives.datatask.DataImportEqmArchivesTools;
import com.kingdee.eas.eqm.basedata.util.DataImportUtils;
import com.kingdee.eas.eqm.common.datatask.EQMBaseDataTransmission;
import com.kingdee.eas.eqm.common.eqmcore.app.util.DataImportEqmTools;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.util.Hashtable;
import java.util.Locale;

public class DataImportEqmArchivesAttachTool
extends EQMBaseDataTransmission {
    private static final String RESOURCE_PATH = "com.kingdee.eas.eqm.archives.EquipmentArchivesTransmissionResource";

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return EquipmentArchivesAttachToolFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        StorageOrgUnitInfo storageInfo = null;
        EquipmentArchivesAttachToolInfo info = new EquipmentArchivesAttachToolInfo();
        Hashtable baseData = hsData;
        String storageOrgNumber = this.getDataString(baseData, "FStorageOrgUnit_number");
        String material_number = this.getDataString(baseData, "FMaterial_number");
        String equipment_number = this.getDataString(baseData, "FEquipment_number");
        String qty = this.getDataString(baseData, "FQty");
        String timeLimit = this.getDataString(baseData, "FTimeLimit");
        String timeUnit = this.getDataString(baseData, "FTimeUnit");
        String remark = this.getDataString(baseData, "FRemark");
        if (storageOrgNumber == null || "".equals(storageOrgNumber.trim())) {
            throw new TaskExternalException(DataImportEqmArchivesAttachTool.getResourceMsg("storageOrgUnit_IsNotNull"));
        }
        if (equipment_number == null || "".equals(equipment_number.trim())) {
            throw new TaskExternalException(DataImportEqmArchivesAttachTool.getResourceMsg("equipment_IsNotNull"));
        }
        if (material_number == null || "".equals(material_number.trim())) {
            throw new TaskExternalException(DataImportEqmArchivesAttachTool.getResourceMsg("attachTool_IsNotNull"));
        }
        if (qty == null || "".equals(qty.trim())) {
            throw new TaskExternalException(DataImportEqmArchivesAttachTool.getResourceMsg("qty_IsNotNull"));
        }
        DataImportEqmTools.checkMaxLen((Context)ctx, (AbstractObjectValue)info, (String)remark, (String)DataImportEqmArchivesAttachTool.getResourceMsg("remark"), (int)100);
        TimeUnitEnum timeUnitEnum = DataImportUtils.getTimeUnit((String)timeUnit);
        this.isAuthorizedOrgUnit(ctx, storageOrgNumber);
        try {
            storageInfo = DataImportTools.getStorageOrgUnitInfoFromNumber((Context)ctx, (String)storageOrgNumber);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        info = DataImportEqmArchivesTools.getEquipmentArchivesAttachToolInfo(ctx, equipment_number, material_number, storageInfo.getId().toString());
        int precision = info.getMaterial().getBaseUnit().getQtyPrecision();
        BigDecimal num = DataImportEqmTools.getNumByPrecision((String)qty, (int)0, (String)DataImportEqmArchivesAttachTool.getResourceMsg("qty"), (boolean)true, (boolean)false);
        info.setQty(num);
        info.setRemark(remark);
        info.setTimeUnit(timeUnitEnum);
        info.setTimeLimit(DataImportEqmTools.getNumByPrecision((String)timeLimit, (int)0, (String)ResourceUtils.getMessage((String)"com.kingdee.eas.eqm.archives.ARCHIVESAutoGenerateResource", (String)"10_DataImportEqmArchivesAttachTool"), (boolean)true));
        return info;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.eqm.archives.app.ExpEquipmentArchivesAttachToolQuery";
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        EntityViewInfo viewInfo = (EntityViewInfo)this.getContextParameter("meterQuery");
        return viewInfo.getFilter();
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = new Hashtable();
        try {
            Locale locale = ctx.getLocale();
            this.putTable(result, "FStorageOrgUnit_number", rs.getString("storageOrgUnit.number"));
            this.putTable(result, "FStorageOrgUnit_name", rs.getString("storageOrgUnit.name"));
            this.putTable(result, "FEquipment_number", rs.getString("number"));
            this.putTable(result, "FEquipment_name", rs.getString("name"));
            this.putTable(result, "FMaterial_number", rs.getString("attachTools.number"));
            this.putTable(result, "FMaterial_name", rs.getString("attachTools.name"));
            this.putTable(result, "FMaterial_model", rs.getString("attachTools.model"));
            this.putTable(result, "FUnit_number", rs.getString("attachTools.unit.number"));
            this.putTable(result, "FUnit_name", rs.getString("attachTools.unit.name"));
            String timeLimit = DataImportEqmTools.getNumByPrecision((String)rs.getString("attachTools.timeLimit"), (int)0);
            this.putTable(result, "FTimeLimit", timeLimit);
            this.putTable(result, "FTimeUnit", TimeUnitEnum.getEnum(rs.getInt("attachTools.timeUnit")) != null ? TimeUnitEnum.getEnum(rs.getInt("attachTools.timeUnit")).getAlias(locale) : "");
            String qty = DataImportEqmTools.getNumByPrecision((String)rs.getString("attachTools.qty"), (int)0);
            this.putTable(result, "FQty", qty);
            this.putTable(result, "FRemark", rs.getString("attachTools.remark"));
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    protected String getImportPermItemName() {
        return "eqm_equipmentarchives_13import";
    }

    public static String getResourceMsg(String key) {
        return ResourceUtils.getMessage((String)RESOURCE_PATH, (String)key);
    }
}

