/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.archives.datatask;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.basedata.master.material.app.DataImportTools;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.eqm.archives.EquipmentArchivesTechParamFactory;
import com.kingdee.eas.eqm.archives.EquipmentArchivesTechParamInfo;
import com.kingdee.eas.eqm.archives.datatask.DataImportEqmArchivesTools;
import com.kingdee.eas.eqm.basedata.ValueTypeEnum;
import com.kingdee.eas.eqm.basedata.util.DataImportUtils;
import com.kingdee.eas.eqm.common.datatask.EQMBaseDataTransmission;
import com.kingdee.eas.eqm.common.eqmcore.app.util.DataImportEqmTools;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.Hashtable;
import java.util.Locale;

public class DataImportEqmArchivesTechParam
extends EQMBaseDataTransmission {
    private static final String RESOURCE_PATH = "com.kingdee.eas.eqm.archives.EquipmentArchivesTransmissionResource";

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return EquipmentArchivesTechParamFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        StorageOrgUnitInfo storageInfo = null;
        EquipmentArchivesTechParamInfo info = new EquipmentArchivesTechParamInfo();
        Hashtable baseData = hsData;
        String storageOrgNumber = this.getDataString(baseData, "FStorageOrgUnit_number");
        String equipment_number = this.getDataString(baseData, "FEquipment_number");
        String unit_number = this.getDataString(baseData, "FUnit_number");
        String paramName = this.getDataString(baseData, "FParamName");
        String paramDesp = this.getDataString(baseData, "FParamDesp");
        String paramType = this.getDataString(baseData, "FParamType");
        String value = this.getDataString(baseData, "FValue");
        String remark = this.getDataString(baseData, "FRemark");
        if (storageOrgNumber == null || "".equals(storageOrgNumber.trim())) {
            throw new TaskExternalException(DataImportEqmArchivesTechParam.getResourceMsg("storageOrgUnit_IsNotNull"));
        }
        if (equipment_number == null || "".equals(equipment_number.trim())) {
            throw new TaskExternalException(DataImportEqmArchivesTechParam.getResourceMsg("equipment_IsNotNull"));
        }
        if (paramName == null || "".equals(paramName.trim())) {
            throw new TaskExternalException(DataImportEqmArchivesTechParam.getResourceMsg("paramName_IsNotNull"));
        }
        if (paramType == null || "".equals(paramType.trim())) {
            throw new TaskExternalException(DataImportEqmArchivesTechParam.getResourceMsg("paramType_IsNotNull"));
        }
        DataImportEqmTools.checkMaxLen((Context)ctx, (AbstractObjectValue)info, (String)remark, (String)DataImportEqmArchivesTechParam.getResourceMsg("remark"), (int)100);
        DataImportEqmTools.checkMaxLen((Context)ctx, (AbstractObjectValue)info, (String)paramName, (String)DataImportEqmArchivesTechParam.getResourceMsg("paramName"), (int)80);
        DataImportEqmTools.checkMaxLen((Context)ctx, (AbstractObjectValue)info, (String)paramDesp, (String)DataImportEqmArchivesTechParam.getResourceMsg("paramDesp"), (int)100);
        ValueTypeEnum valueTypeEnum = DataImportUtils.getValueType((String)paramType);
        this.isAuthorizedOrgUnit(ctx, storageOrgNumber);
        try {
            storageInfo = DataImportTools.getStorageOrgUnitInfoFromNumber((Context)ctx, (String)storageOrgNumber);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        info = DataImportEqmArchivesTools.getEquipmentArchivesTechParamInfo(ctx, equipment_number, unit_number, storageInfo.getId().toString(), paramName);
        value = DataImportEqmArchivesTools.getStrandedValue(ctx, (AbstractObjectValue)info, value, paramType, unit_number);
        info.setValue(value);
        info.setRemark(remark);
        info.setParamType(valueTypeEnum);
        info.setParamName(paramName);
        info.setParamDesp(paramDesp);
        return info;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.eqm.archives.app.ExpEquipmentArchivesTechParamQuery";
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        EntityViewInfo viewInfo = (EntityViewInfo)this.getContextParameter("meterQuery");
        return viewInfo.getFilter();
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = new Hashtable();
        try {
            Locale locale = ctx.getLocale();
            this.putTable(result, "FStorageOrgUnit_number", rs.getString("storageOrgUnit.number"));
            this.putTable(result, "FStorageOrgUnit_name", rs.getString("storageOrgUnit.name"));
            this.putTable(result, "FEquipment_number", rs.getString("number"));
            this.putTable(result, "FEquipment_name", rs.getString("name"));
            this.putTable(result, "FParamName", rs.getString("techParams.paramName"));
            this.putTable(result, "FParamDesp", rs.getString("techParams.paramDesp"));
            this.putTable(result, "FParamType", ValueTypeEnum.getEnum((int)rs.getInt("techParams.paramType")) != null ? ValueTypeEnum.getEnum((int)rs.getInt("techParams.paramType")).getAlias(locale) : "");
            this.putTable(result, "FUnit_number", rs.getString("techParams.standardUnit.number"));
            this.putTable(result, "FUnit_name", rs.getString("techParams.standardUnit.name"));
            this.putTable(result, "FValue", rs.getString("techParams.value"));
            this.putTable(result, "FRemark", rs.getString("techParams.remark"));
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    protected String getImportPermItemName() {
        return "eqm_equipmentarchives_13import";
    }

    public static String getResourceMsg(String key) {
        return ResourceUtils.getMessage((String)RESOURCE_PATH, (String)key);
    }
}

