/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.archives.datatask;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.MeasureUnitCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.app.DataImportTools;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.eqm.archives.EquipmentArchivesAttachToolInfo;
import com.kingdee.eas.eqm.archives.EquipmentArchivesCollection;
import com.kingdee.eas.eqm.archives.EquipmentArchivesEntryInfo;
import com.kingdee.eas.eqm.archives.EquipmentArchivesFactory;
import com.kingdee.eas.eqm.archives.EquipmentArchivesInfo;
import com.kingdee.eas.eqm.archives.EquipmentArchivesTechParamCollection;
import com.kingdee.eas.eqm.archives.EquipmentArchivesTechParamFactory;
import com.kingdee.eas.eqm.archives.EquipmentArchivesTechParamInfo;
import com.kingdee.eas.eqm.archives.IEquipmentArchives;
import com.kingdee.eas.eqm.archives.IEquipmentArchivesTechParam;
import com.kingdee.eas.eqm.basedata.EquipmentMeterApplyCollection;
import com.kingdee.eas.eqm.basedata.EquipmentMeterApplyFactory;
import com.kingdee.eas.eqm.basedata.EquipmentMeterApplyInfo;
import com.kingdee.eas.eqm.basedata.EquipmentMeterCollection;
import com.kingdee.eas.eqm.basedata.EquipmentMeterFactory;
import com.kingdee.eas.eqm.basedata.EquipmentMeterInfo;
import com.kingdee.eas.eqm.basedata.EquipmentReadingFactory;
import com.kingdee.eas.eqm.basedata.EquipmentReadingHistoryCollection;
import com.kingdee.eas.eqm.basedata.EquipmentReadingHistoryFactory;
import com.kingdee.eas.eqm.basedata.EquipmentReadingHistoryInfo;
import com.kingdee.eas.eqm.basedata.EquipmentReadingInfo;
import com.kingdee.eas.eqm.basedata.IEquipmentMeter;
import com.kingdee.eas.eqm.basedata.IEquipmentMeterApply;
import com.kingdee.eas.eqm.basedata.IEquipmentReadingHistory;
import com.kingdee.eas.eqm.basedata.ValueTypeEnum;
import com.kingdee.eas.eqm.common.eqmcore.app.util.DataImportEqmTools;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.util.enums.Enum;
import java.math.BigDecimal;

public class DataImportEqmArchivesTools {
    private static final String RESOURCE_PATH = "com.kingdee.eas.eqm.archives.EquipmentArchivesTransmissionResource";

    public static EquipmentMeterApplyInfo getMeterApplyInfo(Context ctx, String equipment_number, String meter_number, String orgId) throws TaskExternalException {
        EquipmentArchivesInfo equipmentInfo = DataImportEqmArchivesTools.getEquipmentArchivesInfo(ctx, equipment_number, orgId);
        EquipmentMeterInfo meterInfo = DataImportEqmArchivesTools.getEquipmentMeterInfoWithUnit(ctx, meter_number, orgId);
        EquipmentMeterApplyInfo info = new EquipmentMeterApplyInfo();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("meter", (Object)meterInfo.getId()));
        filter.getFilterItems().add(new FilterItemInfo("equipment", (Object)equipmentInfo.getId()));
        viewInfo.setFilter(filter);
        try {
            IEquipmentMeterApply iEquipmentMeterApply = EquipmentMeterApplyFactory.getLocalInstance((Context)ctx);
            EquipmentMeterApplyCollection equipmentMeterApplyCollection = iEquipmentMeterApply.getEquipmentMeterApplyCollection(viewInfo);
            if (equipmentMeterApplyCollection != null && equipmentMeterApplyCollection.size() > 0) {
                throw new TaskExternalException(DataImportEqmArchivesTools.getResourceMsg("equipment") + " : " + equipmentInfo + DataImportEqmArchivesTools.getResourceMsg("meter_isExisting") + " : " + meterInfo);
            }
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        info.setEquipment(equipmentInfo);
        info.setMeter(meterInfo);
        return info;
    }

    public static void changeReadingToMeterApply(EquipmentMeterApplyInfo meterApplyInfo, EquipmentReadingHistoryInfo readingInfo) {
        meterApplyInfo.setAccumulatedValue(readingInfo.getAccumulatedValue());
        meterApplyInfo.setActivedStatus(readingInfo.isActivedStatus());
        meterApplyInfo.setReadingWay(readingInfo.getReadingWay());
        meterApplyInfo.setReadingDate(readingInfo.getReadingDate());
        meterApplyInfo.setCurrentValue(readingInfo.getCurrentValue());
    }

    public static EquipmentMeterInfo getEquipmentMeterInfoWithUnit(Context ctx, String number, String orgId) throws TaskExternalException {
        if (number == null || "".equals(number)) {
            return null;
        }
        FilterInfo filter = new FilterInfo();
        IEquipmentMeter iEquipmentMeter = null;
        EquipmentMeterCollection equipmentMeterCollection = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("*"));
        viewInfo.getSelector().add(new SelectorItemInfo("unit.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("unit.number"));
        viewInfo.getSelector().add(new SelectorItemInfo("unit.qtyPrecision"));
        try {
            filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit", (Object)orgId));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
            filter.setMaskString("#0 and #1");
            viewInfo.setFilter(filter);
            iEquipmentMeter = EquipmentMeterFactory.getLocalInstance((Context)ctx);
            equipmentMeterCollection = iEquipmentMeter.getEquipmentMeterCollection(viewInfo);
            if (equipmentMeterCollection == null || equipmentMeterCollection.size() <= 0) {
                throw new TaskExternalException(DataImportEqmArchivesTools.getResourceMsg("getMeter_Err"));
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return equipmentMeterCollection.get(0);
    }

    public static EquipmentReadingHistoryInfo getReadingHistoryInfo(Context ctx, String equipment_number, String meter_number, String orgId) throws TaskExternalException {
        EquipmentReadingHistoryCollection equipmentReadingHistoryCollection;
        if (equipment_number == null || "".equals(equipment_number)) {
            return null;
        }
        if (meter_number == null || "".equals(meter_number)) {
            return null;
        }
        EquipmentArchivesInfo equipmentInfo = DataImportEqmArchivesTools.getEquipmentArchivesInfo(ctx, equipment_number, orgId);
        EquipmentMeterInfo meterInfo = DataImportEqmArchivesTools.getEquipmentMeterInfo(ctx, meter_number, orgId);
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("currentValue"));
        viewInfo.getSelector().add(new SelectorItemInfo("accumulatedValue"));
        viewInfo.getSelector().add(new SelectorItemInfo("ReadingHistoryDate"));
        viewInfo.getSelector().add(new SelectorItemInfo("activedStatus"));
        viewInfo.getSelector().add(new SelectorItemInfo("averageCalWay"));
        viewInfo.getSelector().add(new SelectorItemInfo("initValue"));
        viewInfo.getSelector().add(new SelectorItemInfo("ReadingHistoryWay"));
        viewInfo.getSelector().add(new SelectorItemInfo("meter.*"));
        viewInfo.getSelector().add(new SelectorItemInfo("equipment.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("equipment.number"));
        viewInfo.getSelector().add(new SelectorItemInfo("storageOrgUnit"));
        viewInfo.getSelector().add(new SelectorItemInfo("CU.*"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("meter", (Object)meterInfo.getId()));
        filter.getFilterItems().add(new FilterItemInfo("equipment", (Object)equipmentInfo.getId()));
        viewInfo.setFilter(filter);
        try {
            IEquipmentReadingHistory iEquipmentReadingHistory = EquipmentReadingHistoryFactory.getLocalInstance((Context)ctx);
            equipmentReadingHistoryCollection = iEquipmentReadingHistory.getEquipmentReadingHistoryCollection(viewInfo);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return equipmentReadingHistoryCollection.get(0);
    }

    public static EquipmentArchivesEntryInfo getEquipmentArchivesEntryInfo(Context ctx, String equipment_number, String material_number, String orgId) throws TaskExternalException {
        EquipmentArchivesEntryInfo equipmentEntryInfo = new EquipmentArchivesEntryInfo();
        EquipmentArchivesInfo equipmentInfo = DataImportEqmArchivesTools.getEquipmentArchivesInfo(ctx, equipment_number, orgId);
        MaterialInfo materialInfo = DataImportEqmArchivesTools.getMaterialInfoForEntry(ctx, material_number, equipmentInfo.getCU().getId().toString(), true);
        equipmentEntryInfo.setMaterial(materialInfo);
        equipmentEntryInfo.setParent(equipmentInfo);
        return equipmentEntryInfo;
    }

    public static EquipmentArchivesAttachToolInfo getEquipmentArchivesAttachToolInfo(Context ctx, String equipment_number, String material_number, String orgId) throws TaskExternalException {
        EquipmentArchivesAttachToolInfo equipmentAttachToolInfo = new EquipmentArchivesAttachToolInfo();
        EquipmentArchivesInfo equipmentInfo = DataImportEqmArchivesTools.getEquipmentArchivesInfo(ctx, equipment_number, orgId);
        MaterialInfo materialInfo = DataImportEqmArchivesTools.getMaterialInfoForEntry(ctx, material_number, equipmentInfo.getCU().getId().toString(), false);
        equipmentAttachToolInfo.setMaterial(materialInfo);
        equipmentAttachToolInfo.setParent(equipmentInfo);
        return equipmentAttachToolInfo;
    }

    public static EquipmentArchivesTechParamInfo getEquipmentArchivesTechParamInfo(Context ctx, String equipment_number, String unit_number, String orgId, String paramName) throws TaskExternalException {
        EquipmentArchivesTechParamInfo info = new EquipmentArchivesTechParamInfo();
        EquipmentArchivesInfo equipmentInfo = DataImportEqmArchivesTools.getEquipmentArchivesInfo(ctx, equipment_number, orgId);
        DataImportEqmArchivesTools.checkParamName(ctx, equipmentInfo.getId().toString(), orgId, paramName);
        info.setParent(equipmentInfo);
        return info;
    }

    public static MaterialInfo getMaterialInfoForEntry(Context ctx, String number, String cuId, boolean isEntrys) throws TaskExternalException {
        MaterialCollection matCollection;
        try {
            if (number == null || "".equals(number)) {
                return null;
            }
            IMaterial iMat = MaterialFactory.getLocalInstance((Context)ctx);
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.getSelector().add(new SelectorItemInfo("number"));
            viewInfo.getSelector().add(new SelectorItemInfo("name"));
            viewInfo.getSelector().add(new SelectorItemInfo("model"));
            viewInfo.getSelector().add(new SelectorItemInfo("baseUnit.name"));
            viewInfo.getSelector().add(new SelectorItemInfo("baseUnit.number"));
            viewInfo.getSelector().add(new SelectorItemInfo("baseUnit.qtyPrecision"));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
            if (isEntrys) {
                filter.getFilterItems().add(new FilterItemInfo("equipProperty", (Object)new Integer(1)));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("equipProperty", (Object)new Integer(2)));
            }
            filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)cuId, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)("SELECT FDataBaseDID FROM T_BD_DataBaseDAssign WHERE FBOSObjectType = '4409E7F0' AND FAssignCUID = '" + cuId + "')"), CompareType.INNER));
            filter.setMaskString("#0 and #1 and  (#2 or #3 )");
            viewInfo.setFilter(filter);
            matCollection = iMat.getMaterialCollection(viewInfo);
            if (matCollection == null || matCollection.size() <= 0) {
                throw new TaskExternalException(DataImportEqmArchivesTools.getResourceMsg("getMaterial_Err"));
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return matCollection.get(0);
    }

    public static void saveReadingInfo(Context ctx, EquipmentMeterInfo meterInfo, EquipmentArchivesInfo equipmentInfo, EquipmentMeterApplyInfo applyInfo, StorageOrgUnitInfo storageInfo) throws TaskExternalException {
        EquipmentReadingInfo info = new EquipmentReadingInfo();
        info.setParent(applyInfo);
        info.setEquipment(equipmentInfo);
        info.setMeter(meterInfo);
        info.setStorageOrgUnit(storageInfo);
        info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        info.setActivedStatus(true);
        try {
            EquipmentReadingFactory.getLocalInstance((Context)ctx).submit((CoreBaseInfo)info);
        }
        catch (EASBizException e) {
            throw new TaskExternalException(DataImportEqmArchivesTools.getResourceMsg("saveReadingInfo_Err"));
        }
        catch (BOSException e) {
            throw new TaskExternalException(DataImportEqmArchivesTools.getResourceMsg("saveReadingInfo_Err"));
        }
    }

    public static String getStrandedValue(Context ctx, AbstractObjectValue dataBaseInfo, String value, String paramType, String unit_number) throws TaskExternalException {
        EquipmentArchivesTechParamInfo info = (EquipmentArchivesTechParamInfo)dataBaseInfo;
        if (DataImportEqmTools.enumEqualByAlias((String)paramType, (Enum)ValueTypeEnum.NUMBER)) {
            if (unit_number == null || "".equals(unit_number.trim())) {
                throw new TaskExternalException(DataImportEqmArchivesTools.getResourceMsg("getStrandedValue_Unit_IsNotNull"));
            }
            if (value == null || "".equals(value.trim())) {
                throw new TaskExternalException(DataImportEqmArchivesTools.getResourceMsg("getStrandedValue_Value_IsNotNull"));
            }
            MeasureUnitInfo unitInfo = DataImportEqmArchivesTools.getMeasureUnitInfo(ctx, unit_number);
            info.setStandardUnit(unitInfo);
            int precision = unitInfo.getQtyPrecision();
            BigDecimal v = DataImportEqmTools.getNumByPrecision((String)value, (int)precision, (String)DataImportEqmArchivesTools.getResourceMsg("value"), (boolean)false);
            if (v != null) {
                return v.toString();
            }
            throw new TaskExternalException("getStrandedValue_Value_IsNotNull");
        }
        if (DataImportEqmTools.enumEqualByAlias((String)paramType, (Enum)ValueTypeEnum.STRING)) {
            DataImportEqmTools.checkMaxLen((Context)ctx, (AbstractObjectValue)info, (String)value, (String)DataImportEqmArchivesTools.getResourceMsg("value"), (int)100);
            return value;
        }
        throw new TaskExternalException(ResourceUtils.getMessage((String)"com.kingdee.eas.eqm.archives.ARCHIVESAutoGenerateResource", (String)"13_DataImportEqmArchivesTools"));
    }

    public static void checkParamName(Context ctx, String equipment_id, String orgId, String ParamName) throws TaskExternalException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("paramName", (Object)ParamName));
        filter.getFilterItems().add(new FilterItemInfo("parent", (Object)equipment_id));
        try {
            IEquipmentArchivesTechParam iTechParam = EquipmentArchivesTechParamFactory.getLocalInstance(ctx);
            EquipmentArchivesTechParamCollection techParamCollection = iTechParam.getEquipmentArchivesTechParamCollection(DataImportEqmTools.getViewInfo((FilterInfo)filter));
            if (techParamCollection != null && techParamCollection.size() > 0) {
                throw new TaskExternalException(DataImportEqmArchivesTools.getResourceMsg("checkParamName_TechParam") + " : " + ParamName + DataImportEqmArchivesTools.getResourceMsg("checkParamName_TechParam_IsExisting"));
            }
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public static EquipmentArchivesInfo getEquipmentArchivesInfo(Context ctx, String number, String orgId) throws TaskExternalException {
        FilterInfo filter = new FilterInfo();
        IEquipmentArchives iEquipmentArchives = null;
        EquipmentArchivesCollection equipmentArchivesCollection = null;
        if (number == null || "".equals(number)) {
            return null;
        }
        try {
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.getSelector().add(new SelectorItemInfo("number"));
            viewInfo.getSelector().add(new SelectorItemInfo("name"));
            viewInfo.getSelector().add(new SelectorItemInfo("CU.id"));
            DataImportTools.AddFilterItemInfo((FilterInfo)filter, (String)"storageOrgUnit", (Object)orgId);
            DataImportTools.AddFilterItemInfo((FilterInfo)filter, (String)"number", (Object)number);
            filter.setMaskString("#0 and #1");
            iEquipmentArchives = EquipmentArchivesFactory.getLocalInstance(ctx);
            equipmentArchivesCollection = iEquipmentArchives.getEquipmentArchivesCollection(DataImportEqmTools.getViewInfo((FilterInfo)filter));
            if (equipmentArchivesCollection == null || equipmentArchivesCollection.size() <= 0) {
                throw new TaskExternalException(ResourceUtils.getMessage((String)"com.kingdee.eas.eqm.archives.ARCHIVESAutoGenerateResource", (String)"14_DataImportEqmArchivesTools"));
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return equipmentArchivesCollection.get(0);
    }

    public static EquipmentMeterInfo getEquipmentMeterInfo(Context ctx, String number, String orgId) throws TaskExternalException {
        FilterInfo filter = new FilterInfo();
        IEquipmentMeter iEquipmentMeter = null;
        EquipmentMeterCollection equipmentMeterCollection = null;
        if (number == null || "".equals(number)) {
            return null;
        }
        try {
            DataImportTools.AddFilterItemInfo((FilterInfo)filter, (String)"storageOrgUnit", (Object)orgId);
            DataImportTools.AddFilterItemInfo((FilterInfo)filter, (String)"number", (Object)number);
            filter.setMaskString("#0 and #1");
            iEquipmentMeter = EquipmentMeterFactory.getLocalInstance((Context)ctx);
            equipmentMeterCollection = iEquipmentMeter.getEquipmentMeterCollection(DataImportEqmTools.getViewInfo((FilterInfo)filter));
            if (equipmentMeterCollection == null || equipmentMeterCollection.size() <= 0) {
                throw new TaskExternalException(ResourceUtils.getMessage((String)"com.kingdee.eas.eqm.archives.ARCHIVESAutoGenerateResource", (String)"15_DataImportEqmArchivesTools"));
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return equipmentMeterCollection.get(0);
    }

    public static MeasureUnitInfo getMeasureUnitInfo(Context ctx, String number) throws TaskExternalException {
        MeasureUnitCollection measureUnitCollection;
        try {
            if (number == null || "".equals(number)) {
                return null;
            }
            IMeasureUnit iMeasureUnit = MeasureUnitFactory.getLocalInstance((Context)ctx);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
            measureUnitCollection = iMeasureUnit.getMeasureUnitCollection(DataImportEqmTools.getViewInfo((FilterInfo)filter));
            if (measureUnitCollection == null || measureUnitCollection.size() <= 0) {
                throw new TaskExternalException(ResourceUtils.getMessage((String)"com.kingdee.eas.eqm.archives.ARCHIVESAutoGenerateResource", (String)"16_DataImportEqmArchivesTools"));
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return measureUnitCollection.get(0);
    }

    public static String getResourceMsg(String key) {
        return ResourceUtils.getMessage((String)RESOURCE_PATH, (String)key);
    }
}

