/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.common.core.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.framework.DataBaseDAssignFactory;
import com.kingdee.eas.basedata.framework.DataBaseDAssignInfo;
import com.kingdee.eas.basedata.framework.DataBaseDInfo;
import com.kingdee.eas.basedata.framework.DataStateEnum;
import com.kingdee.eas.basedata.framework.IDataBaseDAssign;
import com.kingdee.eas.basedata.org.CUBDControlFactory;
import com.kingdee.eas.basedata.org.CUBDControlInfo;
import com.kingdee.eas.basedata.org.CUBDDispatchPattern;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.ICUBDControl;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.RefChkFilter;
import com.kingdee.eas.common.RefChkFilterItemEnum;
import com.kingdee.eas.common.RefChkFilterSet;
import com.kingdee.eas.common.app.dao.ReferenceDAO;
import com.kingdee.eas.eqm.common.core.GeneDataBaseDAssignFactory;
import com.kingdee.eas.eqm.common.core.GeneDataBaseDAssignInfo;
import com.kingdee.eas.eqm.common.core.GeneDataBaseDInfo;
import com.kingdee.eas.eqm.common.core.GeneDatabaseCanInfo;
import com.kingdee.eas.eqm.common.core.GeneDatabaseDException;
import com.kingdee.eas.eqm.common.core.IGeneDataBaseDAssign;
import com.kingdee.eas.eqm.common.core.app.AbstractGeneDataBaseDControllerBean;
import com.kingdee.eas.eqm.common.core.app.GeneDataBaseDNewImpl;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashSet;
import org.apache.log4j.Logger;

public abstract class GeneDataBaseDControllerBean
extends AbstractGeneDataBaseDControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.eqm.common.core.app.GeneDataBaseDControllerBean");

    @Override
    protected void _delete(Context ctx, IObjectPK dataBasePK, IObjectPK orgPK) throws BOSException, EASBizException {
        GeneDataBaseDInfo info = (GeneDataBaseDInfo)this.getValue(ctx, dataBasePK);
        boolean hasAdminRight = orgPK.toString().equals(info.getMainOrgUnit().getId().toString());
        IGeneDataBaseDAssign baseDAssign = GeneDataBaseDAssignFactory.getLocalInstance(ctx);
        if (hasAdminRight) {
            boolean isAssigned = baseDAssign.existAssignment(dataBasePK, null);
            if (isAssigned) {
                throw new GeneDatabaseDException(GeneDatabaseDException.CAN_NOT_DELETE_ASSIGNED_DATABASED);
            }
            super._delete(ctx, dataBasePK);
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("dataBaseDID", (Object)info.getId().toString()));
            filterInfo.getFilterItems().add(new FilterItemInfo("assignOrgUnit.id", (Object)info.getMainOrgUnit().getId().toString()));
            filterInfo.getFilterItems().add(new FilterItemInfo("ownable", (Object)new Integer(1)));
            baseDAssign.delete(filterInfo);
        } else {
            boolean isAssigned = baseDAssign.existAssignment(dataBasePK, null);
            if (isAssigned) {
                this.checkDelPolicy(ctx, orgPK, info.getBOSType(), dataBasePK);
                baseDAssign.delete(orgPK, dataBasePK);
            } else {
                throw new GeneDatabaseDException(GeneDatabaseDException.CAN_NOT_DELETE_UNASSIGNED_DATABASED);
            }
        }
    }

    @Override
    protected void _update(Context ctx, IObjectPK dataBaseDPK, IObjectValue model, IObjectPK orgPK) throws BOSException, EASBizException {
        GeneDataBaseDInfo info = (GeneDataBaseDInfo)model;
        boolean hasAdminRight = orgPK.toString().equals(info.getMainOrgUnit().getId().toString());
        if (hasAdminRight) {
            super._update(ctx, dataBaseDPK, info);
        } else {
            IGeneDataBaseDAssign baseDAssign = GeneDataBaseDAssignFactory.getLocalInstance(ctx);
            boolean isDataBaseDAssigned = baseDAssign.checkAssignment(orgPK, dataBaseDPK);
            if (isDataBaseDAssigned) {
                this.checkUpdatePolicy(ctx, orgPK, info.getBOSType());
                super._update(ctx, dataBaseDPK, info);
            } else {
                throw new GeneDatabaseDException(GeneDatabaseDException.CAN_NOT_UPDATE_UNASSIGNED_DATABASED);
            }
        }
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this._delete(ctx, pk, (IObjectPK)new ObjectUuidPK(this.getCurrentOrgUnit(ctx).getId()));
    }

    protected IObjectPK[] _delete(Context ctx, FilterInfo filter) throws BOSException, EASBizException {
        IObjectPK[] arrayPK = this.getPKList(ctx, filter, null);
        int length = arrayPK.length;
        for (int i = 0; i < length; ++i) {
            this._delete(ctx, arrayPK[i]);
        }
        return arrayPK;
    }

    protected void _delete(Context ctx, IObjectPK[] arrayPK) throws BOSException, EASBizException {
        int length = arrayPK.length;
        for (int i = 0; i < length; ++i) {
            this._delete(ctx, arrayPK[i]);
        }
    }

    protected IObjectPK[] _delete(Context ctx, String oql) throws BOSException, EASBizException {
        IObjectPK[] arrayPK = this.getPKList(ctx, oql);
        this._delete(ctx, arrayPK);
        return arrayPK;
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        GeneDataBaseDInfo info = (GeneDataBaseDInfo)model;
        info.setId(BOSUuid.read((String)pk.toString()));
        this.checkAddPolicy(ctx, new ObjectUuidPK(info.getMainOrgUnit().getId()), info.getBOSType());
        super._addnew(ctx, info);
        this.addDataBaseDAssign(ctx, info, pk);
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        GeneDataBaseDInfo info = (GeneDataBaseDInfo)model;
        this.checkAddPolicy(ctx, new ObjectUuidPK(info.getMainOrgUnit().getId()), info.getBOSType());
        IObjectPK pk = super._addnew(ctx, model);
        this.addDataBaseDAssign(ctx, info, pk);
        return pk;
    }

    @Override
    protected void _update(Context ctx, IObjectPK dataBaseDPK, IObjectValue model) throws BOSException, EASBizException {
        Object orgPK = null;
        orgPK = model.get("uiOrgPK") != null ? (IObjectPK)model.get("uiOrgPK") : new ObjectUuidPK(this.getCurrentOrgUnit(ctx).getId());
        this._update(ctx, dataBaseDPK, model, (IObjectPK)orgPK);
    }

    protected void checkAddPolicy(Context ctx, ObjectUuidPK orgPK, BOSObjectType type) {
    }

    protected void checkUpdatePolicy(Context ctx, IObjectPK ctrlUnitPK, BOSObjectType objectType) throws EASBizException, BOSException {
    }

    protected void checkDelPolicy(Context ctx, IObjectPK orgPK, BOSObjectType type, IObjectPK dataBasePK) throws GeneDatabaseDException {
        boolean isReferencedInCU = false;
        HashSet<String> filterValues = new HashSet<String>();
        filterValues.add(orgPK.toString());
        RefChkFilterSet filters = new RefChkFilterSet();
        filters.add(new RefChkFilter(RefChkFilterItemEnum.IncludedCUIDList, filterValues));
        BOSUuid dataID = BOSUuid.read((String)dataBasePK.toString());
        isReferencedInCU = ReferenceDAO.isReferenced((Context)ctx, (BOSUuid)dataID, (RefChkFilterSet)filters);
        if (isReferencedInCU) {
            throw new GeneDatabaseDException(GeneDatabaseDException.CAN_NOT_DELETE_IN_THIS_CU);
        }
    }

    @Override
    protected void _batchAssign(Context ctx, String srcOrgUnit, boolean all, String sql, String[] dataMap, String[] assignedOrgUnits) throws BOSException, EASBizException {
        this.getGeneDataBaseDNewImpl().batchAssign(ctx, srcOrgUnit, all, sql, dataMap, assignedOrgUnits, this.getBOSType(), true);
    }

    protected GeneDataBaseDNewImpl getGeneDataBaseDNewImpl() {
        GeneDataBaseDNewImpl dbImpl = new GeneDataBaseDNewImpl();
        return dbImpl;
    }

    @Override
    protected void _unBatchAssign(Context ctx, String srcOrgUnit, boolean all, String sql, String[] dataMap, String[] assignedOrgUnits) throws BOSException, EASBizException {
        this.getGeneDataBaseDNewImpl().unBatchAssign(ctx, srcOrgUnit, all, sql, dataMap, assignedOrgUnits, this.getBOSType(), true);
    }

    @Override
    protected void _batchRefer(Context ctx, String srcOrgUnit, String referOrgUnit, boolean all, String sql, String[] selDbids) throws BOSException, EASBizException {
        this.getGeneDataBaseDNewImpl().batchAssign(ctx, srcOrgUnit, all, sql, selDbids, new String[]{referOrgUnit}, this.getBOSType(), false);
    }

    @Override
    protected void _unBatchRefer(Context ctx, String srcOrgUnit, String referOrgUnit, boolean all, String sql, String[] selDbids) throws BOSException, EASBizException {
        this.getGeneDataBaseDNewImpl().unBatchAssign(ctx, srcOrgUnit, all, sql, selDbids, new String[]{referOrgUnit}, this.getBOSType(), false);
    }

    @Override
    protected void _upgrade(Context ctx, IObjectPK dataPK, IObjectPK subordinateCUPK, IObjectPK superiorCUPK) throws BOSException, EASBizException {
        BOSUuid dataID = BOSUuid.read((String)dataPK.toString());
        CtrlUnitInfo assignCU = new CtrlUnitInfo();
        assignCU.setId(BOSUuid.read((String)subordinateCUPK.toString()));
        String bosType = dataID.getType().toString();
        IDataBaseDAssign idbda = DataBaseDAssignFactory.getLocalInstance((Context)ctx);
        DataBaseDAssignInfo dbdai = new DataBaseDAssignInfo();
        dbdai.setDataBaseDID(dataID);
        dbdai.setAssignCU(assignCU);
        dbdai.setBosObjectType(bosType);
        idbda.addnew((CoreBaseInfo)dbdai);
        DataBaseDInfo dataInfo = (DataBaseDInfo)this._getValue(ctx, dataPK);
        CtrlUnitInfo CU = dataInfo.getCU();
        CtrlUnitInfo CUCopy = (CtrlUnitInfo)CU.clone();
        CUCopy.setId(BOSUuid.read((String)superiorCUPK.toString()));
        dataInfo.setAdminCU(CUCopy);
        dataInfo.setCU(CUCopy);
        super._update(ctx, dataPK, (IObjectValue)dataInfo);
    }

    @Override
    protected boolean _canBeAssigned(Context ctx, BOSObjectType bosObjectType, IObjectPK ctrlUnitPK) throws BOSException, EASBizException {
        try {
            String treeID = "00000000-0000-0000-0000-0000000000014F2827FD";
            String longNumber = this.getCULongNumber(ctx, ctrlUnitPK);
            IFullOrgUnit iFullOrgUnit = FullOrgUnitFactory.getLocalInstance((Context)ctx);
            String ctrlUnitID = iFullOrgUnit.getFullOrgUnitInfo(ctrlUnitPK).getCU().getId().toString();
            StringBuffer sql = new StringBuffer(500);
            sql.append(" SELECT Structure.FUnitId FROM T_ORG_Structure Structure ").append(" INNER JOIN T_ORG_BaseUnit BaseUnit ON BaseUnit.FID = Structure.FUnitId ").append(" WHERE Structure.FTreeId = ? ").append(" AND CHARINDEX( N'").append(longNumber).append("!' , Structure.FLongNumber || N'!' ) > 0 ").append(" AND BaseUnit.FControlUnitID = ? ").append(" ORDER BY Structure.FLongNumber ASC ");
            Object[] params = new Object[]{treeID, ctrlUnitID};
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
            while (rowSet.next()) {
                if (!this.canBeAssigned(ctx, bosObjectType, ctrlUnitID)) continue;
                return true;
            }
        }
        catch (SQLException e) {
            throw new GeneDatabaseDException(GeneDatabaseDException.GET_INFO_FAIL, e);
        }
        return false;
    }

    private String getCULongNumber(Context ctx, IObjectPK orgPK) throws BOSException, SQLException {
        String longNumber = null;
        String treeID = "00000000-0000-0000-0000-0000000000014F2827FD";
        String orgID = orgPK.toString();
        Object[] params = new Object[]{treeID, orgID};
        StringBuffer sql = new StringBuffer(500);
        sql.append(" SELECT FLongNumber FROM T_ORG_Structure ").append(" WHERE\tFTreeId = ? ").append(" AND FUnitId = ? ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
        if (rowSet.next()) {
            longNumber = rowSet.getString("FLongNumber");
        }
        return longNumber;
    }

    private boolean canBeAssigned(Context ctx, BOSObjectType objectType, String ctrlUnitID) throws EASBizException, BOSException {
        ICUBDControl iCUBDControl = CUBDControlFactory.getLocalInstance((Context)ctx);
        CUBDControlInfo controlInfo = iCUBDControl.getBDCtrlInfo(objectType.toString(), ctrlUnitID);
        return controlInfo == null ? false : controlInfo.getDispatchPattern().equals((Object)CUBDDispatchPattern.DISPATCH);
    }

    @Override
    protected boolean _canBeUpgraded(Context ctx, BOSObjectType bosType, IObjectPK ctrUnitPK) throws BOSException, EASBizException {
        ICUBDControl iCUBDControl = CUBDControlFactory.getLocalInstance((Context)ctx);
        CUBDControlInfo controlInfo = iCUBDControl.getBDCtrlInfo(bosType.toString(), ctrUnitPK.toString());
        return controlInfo == null ? false : controlInfo.isIsSubordinateUpgradable();
    }

    @Override
    protected boolean _canRefer(Context ctx, BOSObjectType bosObjectType, IObjectPK ctrlUnitPK) throws BOSException, EASBizException {
        ICUBDControl iCUBDControl = CUBDControlFactory.getLocalInstance((Context)ctx);
        CUBDControlInfo controlInfo = iCUBDControl.getBDCtrlInfo(bosObjectType.toString(), ctrlUnitPK.toString());
        return controlInfo == null ? false : controlInfo.getDispatchPattern().equals((Object)CUBDDispatchPattern.REFERENCE);
    }

    @Override
    protected GeneDatabaseCanInfo _allCan(Context ctx, BOSObjectType bosObjectType, IObjectPK ctrlUnitPK) throws BOSException, EASBizException {
        GeneDatabaseCanInfo info = new GeneDatabaseCanInfo();
        CtrlUnitInfo curCtrl = CtrlUnitFactory.getLocalInstance((Context)ctx).getCtrlUnitInfo(ctrlUnitPK);
        ICUBDControl iCUBDControl = CUBDControlFactory.getLocalInstance((Context)ctx);
        CUBDControlInfo controlInfo = iCUBDControl.getBDCtrlInfo(bosObjectType.toString(), ctrlUnitPK.toString());
        info.setCanAssign(this._canBeAssigned(ctx, bosObjectType, ctrlUnitPK));
        info.setCanRefer(controlInfo == null ? false : controlInfo.getDispatchPattern().equals((Object)CUBDDispatchPattern.REFERENCE));
        info.setCanUpgrade(controlInfo == null ? false : controlInfo.isIsSubordinateUpgradable());
        info.setCurCtrlUnit((OrgUnitInfo)curCtrl);
        return info;
    }

    private OrgUnitInfo getCurrentOrgUnit(Context ctx) {
        return ContextUtil.getCurrentOrgUnit((Context)ctx, (OrgType)this.getOrgType());
    }

    public abstract OrgType getOrgType();

    private void addDataBaseDAssign(Context ctx, GeneDataBaseDInfo info, IObjectPK pk) throws BOSException, EASBizException {
        GeneDataBaseDAssignInfo baseDAssignInfo = new GeneDataBaseDAssignInfo();
        baseDAssignInfo.setDataBaseDID(BOSUuid.read((String)pk.toString()));
        baseDAssignInfo.setBosObjectType(info.getBOSType().toString());
        baseDAssignInfo.setStatus(DataStateEnum.ENABLE);
        baseDAssignInfo.setAssignOrgUnit((StorageOrgUnitInfo)info.getMainOrgUnit());
        baseDAssignInfo.setCreator(info.getCreator());
        baseDAssignInfo.setCreateTime(info.getCreateTime());
        baseDAssignInfo.setLastUpdateTime(info.getLastUpdateTime());
        baseDAssignInfo.setLastUpdateUser(info.getLastUpdateUser());
        baseDAssignInfo.setCU(info.getCU());
        baseDAssignInfo.setOwnable(1);
        GeneDataBaseDAssignFactory.getLocalInstance(ctx).save((CoreBaseInfo)baseDAssignInfo);
    }
}

