/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.common.core.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.eqm.common.core.app.util.GeneDbUtil;
import com.kingdee.eas.eqm.common.core.app.util.GeneSeverMetadataUtils;
import com.kingdee.eas.eqm.common.core.util.GeneCommonUtils;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.Iterator;

public class GeneLongNumberGenerator {
    public static String genLongNumber(Context ctx, CoreBaseInfo parent, BOSObjectType bosType) throws BOSException, EASBizException {
        String currentLongNumber = "";
        if (parent != null && parent.get("longNumber") != null) {
            currentLongNumber = currentLongNumber + parent.get("longNumber");
        }
        String maxLongNumber = GeneLongNumberGenerator.findAggregationPropertiesByProperties(ctx, parent == null ? null : parent, bosType);
        currentLongNumber = GeneLongNumberGenerator.calLongNumber(maxLongNumber, currentLongNumber);
        return currentLongNumber;
    }

    public static void updateTreeLongNumber(Context ctx, CoreBaseInfo parent, IObjectCollection srcChildren, CoreBaseCollection col) throws EASBizException, BOSException {
        if (GeneCommonUtils.isEmpty(srcChildren) || GeneCommonUtils.isEmpty(parent)) {
            return;
        }
        Iterator iter = srcChildren.iterator();
        String maxLongNumber = null;
        while (iter.hasNext()) {
            CoreBaseInfo baseInfo = (CoreBaseInfo)iter.next();
            CoreBaseInfo tmpParent = (CoreBaseInfo)baseInfo.get("parent");
            if (tmpParent == null || !tmpParent.getId().equals((Object)parent.getId())) continue;
            baseInfo.put("longNumber", (Object)GeneLongNumberGenerator.calLongNumber(maxLongNumber, (String)parent.get("longNumber")));
            baseInfo.put("level", (Object)new Integer(parent.get("level") == null ? 1 : (Integer)parent.get("level") + 1));
            maxLongNumber = (String)baseInfo.get("longNumber");
            col.add(baseInfo);
            GeneLongNumberGenerator.updateTreeLongNumber(ctx, baseInfo, srcChildren, col);
        }
    }

    public static String calLongNumber(String maxLongNumber, String currentLongNumber) throws EASBizException, BOSException {
        if (maxLongNumber == null) {
            currentLongNumber = currentLongNumber == null || currentLongNumber.length() <= 0 ? "1001" : currentLongNumber + "!" + "1001";
        } else {
            String last5 = "";
            last5 = maxLongNumber.length() > 5 ? maxLongNumber.substring(maxLongNumber.length() - 4, maxLongNumber.length()) : maxLongNumber;
            int i = Integer.parseInt(last5, 36) + 1;
            if (i > 9999) {
                currentLongNumber = currentLongNumber + (GeneCommonUtils.isEmpty(currentLongNumber) ? "" : "!") + Integer.toString(i, 36);
            } else if (i >= 0 && i <= 9) {
                currentLongNumber = currentLongNumber + (GeneCommonUtils.isEmpty(currentLongNumber) ? "" : "!") + "000" + i;
            } else if (i >= 10 && i <= 99) {
                currentLongNumber = currentLongNumber + (GeneCommonUtils.isEmpty(currentLongNumber) ? "" : "!") + "00" + i;
            } else if (i >= 100 && i <= 999) {
                currentLongNumber = currentLongNumber + (GeneCommonUtils.isEmpty(currentLongNumber) ? "" : "!") + "0" + i;
            } else if (i >= 1000 && i <= 9999) {
                currentLongNumber = currentLongNumber + (GeneCommonUtils.isEmpty(currentLongNumber) ? "" : "!") + "" + i;
            }
        }
        return currentLongNumber;
    }

    public static String findAggregationPropertiesByProperties(Context ctx, CoreBaseInfo parent, BOSObjectType bosType) throws EASBizException, BOSException {
        String sql = null;
        sql = parent == null ? "select max(flongnumber) as maxlongnumber from " + GeneSeverMetadataUtils.getMainTableName(ctx, bosType) + " where  fparentid is null" : "select max(flongnumber) as maxlongnumber from " + GeneSeverMetadataUtils.getMainTableName(ctx, bosType) + " where  fparentid='" + parent.getId().toString() + "'";
        IRowSet rs = GeneDbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            if (rs.next()) {
                return rs.getString(1);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return null;
    }
}

