/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.common.eqmcore.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.eas.base.param.BooleanDataType;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.eqm.common.core.ActivedStatusEnum;
import com.kingdee.eas.eqm.common.core.GeneBillBaseStatusEnum;
import com.kingdee.eas.eqm.common.core.GeneCheckedStatusEnum;
import com.kingdee.eas.eqm.common.core.GeneCommonFacadeFactory;
import com.kingdee.eas.eqm.common.core.GeneUsableStatusEnum;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.TypeConversionUtils;
import com.kingdee.util.enums.Enum;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DataImportEqmTools {
    public static final String Locale_en = "l1";
    public static final String Locale_zh = "l2";
    public static final String Locale_tw = "l3";
    private static final BigDecimal MAX = new BigDecimal("9999999999999.99999999");
    private static final BigDecimal MIN = new BigDecimal("-9999999999999.99999999");
    private static final BigDecimal ZERO = new BigDecimal("0");
    private static final String RESOURCE_PATH = "com.kingdee.eas.eqm.common.core.GeneResource";
    public static final String System_CU_ID = "00000000-0000-0000-0000-000000000000CCE7AED4";
    private static final String DATEREGEX = "(([1][8-9][0-9]{2})|([2-9][0-9]{3}))-(((0[13578]|1[02])-(0[1-9]|[12][0-9]|3[01]))|((0[469]|11)-(0[1-9]|[12][0-9]|30))|(02-(0[1-9]|[1][0-9]|2[0-8])))|((([0-9]{2})(0[48]|[2468][048]|[13579][26])|((0[48]|[2468][048]|[3579][26])00))-02-29)";
    private volatile BigInteger intVal;

    public static EntityViewInfo getViewInfo(FilterInfo filter) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        return viewInfo;
    }

    public static String getLoc(Context ctx) {
        return LocaleUtils.getLocaleString((Locale)ctx.getLocale()).toUpperCase();
    }

    public static String getDataString(Hashtable hsData, String fieldName) {
        return (String)((DataToken)hsData.get((Object)fieldName)).data;
    }

    public static BigDecimal getDataBigDecimal(Hashtable hsData, String fieldName) {
        Object o = ((DataToken)hsData.get((Object)fieldName)).data;
        if (o == null) {
            return null;
        }
        String str = o.toString();
        if (str == null || "".equals(str)) {
            return null;
        }
        return new BigDecimal(str);
    }

    public static boolean getDataboolean(Hashtable hsData, String fieldName) {
        Object o = ((DataToken)hsData.get((Object)fieldName)).data;
        if (o == null) {
            return false;
        }
        String str = o.toString();
        if (str == null || "".equals(str)) {
            return false;
        }
        return str.equals("Y") || str.equals("1") || str.equals("true");
    }

    public static boolean getDataboolean(Hashtable hsData, String fieldName, boolean defaultValue) {
        Object o = ((DataToken)hsData.get((Object)fieldName)).data;
        if (o == null) {
            return defaultValue;
        }
        String str = o.toString();
        if (str == null || "".equals(str)) {
            return defaultValue;
        }
        if (str.equalsIgnoreCase("Y") || str.equalsIgnoreCase("1") || str.equalsIgnoreCase("true")) {
            return true;
        }
        if (str.equalsIgnoreCase("N") || str.equalsIgnoreCase("0") || str.equalsIgnoreCase("false")) {
            return false;
        }
        return defaultValue;
    }

    public static int getDataint(Hashtable hsData, String fieldName) {
        Object o = ((DataToken)hsData.get((Object)fieldName)).data;
        if (o == null) {
            return 0;
        }
        String str = o.toString();
        if (str == null || "".equals(str)) {
            return 0;
        }
        return new Integer(str);
    }

    public static Date getDataDate(Hashtable hsData, String fieldName) throws Exception {
        Object o = ((DataToken)hsData.get((Object)fieldName)).data;
        if (o == null) {
            return null;
        }
        String str = o.toString();
        if (str == null || "".equals(str)) {
            return null;
        }
        return TypeConversionUtils.objToDate((Object)str);
    }

    public static GeneCheckedStatusEnum getCheckedStatus(String value) throws TaskExternalException {
        if (value == null || "".equals(value)) {
            return GeneCheckedStatusEnum.AUDITED;
        }
        if (DataImportEqmTools.enumEqualByAlias(value, (Enum)GeneCheckedStatusEnum.UNAUDITED)) {
            return GeneCheckedStatusEnum.UNAUDITED;
        }
        if (DataImportEqmTools.enumEqualByAlias(value, (Enum)GeneCheckedStatusEnum.AUDITED)) {
            return GeneCheckedStatusEnum.AUDITED;
        }
        return GeneCheckedStatusEnum.AUDITED;
    }

    public static GeneUsableStatusEnum getUsableStatus(String value) throws TaskExternalException {
        if (value == null || "".equals(value)) {
            return GeneUsableStatusEnum.USABLE;
        }
        if (DataImportEqmTools.enumEqualByAlias(value, (Enum)GeneUsableStatusEnum.UNCHECKED)) {
            return GeneUsableStatusEnum.UNCHECKED;
        }
        if (DataImportEqmTools.enumEqualByAlias(value, (Enum)GeneUsableStatusEnum.USABLE)) {
            return GeneUsableStatusEnum.USABLE;
        }
        if (DataImportEqmTools.enumEqualByAlias(value, (Enum)GeneUsableStatusEnum.FORBIDDEN)) {
            return GeneUsableStatusEnum.FORBIDDEN;
        }
        return GeneUsableStatusEnum.USABLE;
    }

    public static boolean getBooleanDataType(String value) throws TaskExternalException {
        boolean ret = false;
        if (DataImportEqmTools.enumEqualByAlias(value, (Enum)BooleanDataType.FALSE)) {
            ret = false;
        } else if (DataImportEqmTools.enumEqualByAlias(value, (Enum)BooleanDataType.TRUE)) {
            ret = true;
        }
        return ret;
    }

    public static GeneBillBaseStatusEnum getBillBaseStatus(String value) throws TaskExternalException {
        if (value == null || "".equals(value)) {
            throw new TaskExternalException(DataImportEqmTools.getResourceMsg("billBaseStatusErr"));
        }
        if (DataImportEqmTools.enumEqualByAlias(value, (Enum)GeneBillBaseStatusEnum.CLOSED)) {
            return GeneBillBaseStatusEnum.CLOSED;
        }
        if (DataImportEqmTools.enumEqualByAlias(value, (Enum)GeneBillBaseStatusEnum.AddNew)) {
            return GeneBillBaseStatusEnum.AddNew;
        }
        if (DataImportEqmTools.enumEqualByAlias(value, (Enum)GeneBillBaseStatusEnum.SAVE)) {
            return GeneBillBaseStatusEnum.SAVE;
        }
        if (DataImportEqmTools.enumEqualByAlias(value, (Enum)GeneBillBaseStatusEnum.Submit)) {
            return GeneBillBaseStatusEnum.Submit;
        }
        if (DataImportEqmTools.enumEqualByAlias(value, (Enum)GeneBillBaseStatusEnum.Audit)) {
            return GeneBillBaseStatusEnum.Audit;
        }
        if (DataImportEqmTools.enumEqualByAlias(value, (Enum)GeneBillBaseStatusEnum.Plan)) {
            return GeneBillBaseStatusEnum.Plan;
        }
        if (DataImportEqmTools.enumEqualByAlias(value, (Enum)GeneBillBaseStatusEnum.CLOSED)) {
            return GeneBillBaseStatusEnum.CLOSED;
        }
        if (DataImportEqmTools.enumEqualByAlias(value, (Enum)GeneBillBaseStatusEnum.ForceClosed)) {
            return GeneBillBaseStatusEnum.ForceClosed;
        }
        throw new TaskExternalException(DataImportEqmTools.getResourceMsg("billBaseStatusErr"));
    }

    public static ActivedStatusEnum getActivedStatus(String value) throws TaskExternalException {
        if (value == null || "".equals(value)) {
            return ActivedStatusEnum.ACTIVE;
        }
        if (DataImportEqmTools.enumEqualByAlias(value, (Enum)ActivedStatusEnum.ACTIVE)) {
            return ActivedStatusEnum.ACTIVE;
        }
        if (DataImportEqmTools.enumEqualByAlias(value, (Enum)ActivedStatusEnum.UNACTIVE)) {
            return ActivedStatusEnum.UNACTIVE;
        }
        return ActivedStatusEnum.ACTIVE;
    }

    public static boolean enumEqualByAlias(String value, Enum enumValue) {
        return value.equals(enumValue.getAlias(new Locale(Locale_zh))) || value.equals(enumValue.getAlias(new Locale(Locale_tw))) || value.equals(enumValue.getAlias(new Locale(Locale_en)));
    }

    public static OrgUnitCollection getOrgByDelegateRelation(Context ctx, OrgType srcType, OrgType destType, String orgID, boolean isto) throws Exception {
        IOrgUnitRelation iorgRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        OrgUnitCollection orgCols = null;
        orgCols = isto ? iorgRelation.getToUnit(orgID, srcType.getValue(), destType.getValue()) : iorgRelation.getFromUnit(orgID, destType.getValue(), srcType.getValue());
        return orgCols;
    }

    public static String getResourceMsg(String key) {
        return ResourceBase.getString((String)RESOURCE_PATH, (String)key, (Locale)ContextUtils.getLocaleFromEnv());
    }

    public static String getResourceMsg(String path, String key, Object[] objs) {
        String msg = ResourceBase.getString((String)path, (String)key, (Locale)ContextUtils.getLocaleFromEnv());
        if (objs != null && objs.length > 0) {
            msg = MessageFormat.format(msg, objs);
        }
        return msg;
    }

    public static OrgUnitInfo[] getAuthorizedOrgUnits(Context ctx, OrgType orgType, String permissionItem) throws BOSException, EASBizException {
        if (ctx == null) {
            return GeneCommonFacadeFactory.getRemoteInstance().getAuthorizedOrgUnits(orgType, permissionItem);
        }
        return GeneCommonFacadeFactory.getLocalInstance(ctx).getAuthorizedOrgUnits(orgType, permissionItem);
    }

    public static OrgUnitInfo[] getAuthorizedBizOrgUnits(Context ctx, OrgType orgType, String permissionItem) throws BOSException, EASBizException {
        if (ctx == null) {
            return GeneCommonFacadeFactory.getRemoteInstance().getAuthorizedBizOrgUnits(orgType, permissionItem);
        }
        return GeneCommonFacadeFactory.getLocalInstance(ctx).getAuthorizedBizOrgUnits(orgType, permissionItem);
    }

    public static String getNumByPrecision(String num, int precision) {
        if (num == null || "".equals(num.trim())) {
            return num;
        }
        if (precision == 0) {
            return new BigDecimal(num).setScale(precision, 1).toString();
        }
        return DataImportEqmTools.getValueString(new BigDecimal(num).setScale(precision, 1));
    }

    public static BigDecimal getNumByPrecision(String num, int precision, String fieldName, boolean isNotAllowMinus) throws TaskExternalException {
        if (num == null || "".equals(num.trim())) {
            return null;
        }
        DataImportEqmTools.verifyNumberLength(num, fieldName, isNotAllowMinus);
        return new BigDecimal(num).setScale(precision, 1);
    }

    public static BigDecimal getNumByPrecision(String num, int precision, String fieldName, boolean isNotAllowMinus, boolean isAllowZero) throws TaskExternalException {
        if (num == null || "".equals(num.trim())) {
            return null;
        }
        DataImportEqmTools.verifyNumberLength(num, fieldName, isNotAllowMinus);
        BigDecimal temp = new BigDecimal(num).setScale(precision, 1);
        if (!isAllowZero && temp.compareTo(ZERO) == 0) {
            String msg = ResourceBase.getString((String)"com.kingdee.eas.eqm.common.COMMONAutoGenerateResource", (String)"22_DataImportEqmTools", (Locale)ContextUtils.getLocaleFromEnv());
            MessageFormat mf = new MessageFormat(msg);
            throw new TaskExternalException(mf.format(new String[]{fieldName}));
        }
        return temp;
    }

    private static String getValueString(BigDecimal bd) {
        StringBuffer buf;
        int signum = bd.signum();
        String intString = bd.unscaledValue().toString();
        int scale = bd.scale();
        int insertionPoint = intString.length() - scale;
        if (insertionPoint == 0) {
            return (signum < 0 ? "-0." : "0.") + intString;
        }
        if (insertionPoint > 0) {
            buf = new StringBuffer(intString);
            buf.insert(insertionPoint, '.');
            if (signum < 0) {
                buf.insert(0, '-');
            }
        } else {
            buf = new StringBuffer(3 - insertionPoint + intString.length());
            buf.append(signum < 0 ? "-0." : "0.");
            for (int i = 0; i < -insertionPoint; ++i) {
                buf.append('0');
            }
            buf.append(intString);
        }
        return buf.toString();
    }

    public static void verifyNumberLength(String num, String fieldName, boolean isNotAllowMinus) throws TaskExternalException {
        BigDecimal number;
        try {
            number = new BigDecimal(num);
        }
        catch (Exception e) {
            String msg = ResourceBase.getString((String)"com.kingdee.eas.eqm.common.COMMONAutoGenerateResource", (String)"23_DataImportEqmTools", (Locale)ContextUtils.getLocaleFromEnv());
            MessageFormat mf = new MessageFormat(msg);
            throw new TaskExternalException(mf.format(new String[]{fieldName}));
        }
        if (number.compareTo(ZERO) < 0 && isNotAllowMinus) {
            String msg = ResourceBase.getString((String)"com.kingdee.eas.eqm.common.COMMONAutoGenerateResource", (String)"24_DataImportEqmTools", (Locale)ContextUtils.getLocaleFromEnv());
            MessageFormat mf = new MessageFormat(msg);
            throw new TaskExternalException(mf.format(new String[]{fieldName}));
        }
        if (number.compareTo(MAX) > 0 || number.compareTo(MIN) < 0 || number.scale() > 8) {
            String msg = ResourceBase.getString((String)"com.kingdee.eas.eqm.common.COMMONAutoGenerateResource", (String)"25_DataImportEqmTools", (Locale)ContextUtils.getLocaleFromEnv());
            MessageFormat mf = new MessageFormat(msg);
            throw new TaskExternalException(mf.format(new String[]{fieldName}));
        }
    }

    public static void checkMaxLen(Context ctx, AbstractObjectValue dataBaseInfo, String value, String propertyName, int maxLen) throws TaskExternalException {
        if (ctx == null || dataBaseInfo == null || propertyName == null || maxLen <= 0) {
            return;
        }
        if (value == null || !(value instanceof String)) {
            return;
        }
        if (value.length() > maxLen) {
            String propertyAlias = DataImportEqmTools.getPropertyAlias(ctx, dataBaseInfo, propertyName);
            throw new TaskExternalException(MessageFormat.format(ResourceBase.getString((String)RESOURCE_PATH, (String)"MAX_LENGTH", (Locale)ctx.getLocale()), propertyAlias, String.valueOf(maxLen)));
        }
    }

    public static void checkIsNull(Context ctx, AbstractObjectValue dataBaseInfo, String value, String propertyName) throws TaskExternalException {
        if (ctx == null || dataBaseInfo == null || propertyName == null) {
            return;
        }
        if (value == null || "".equals(value.trim())) {
            String propertyAlias = DataImportEqmTools.getPropertyAlias(ctx, dataBaseInfo, propertyName);
            throw new TaskExternalException(MessageFormat.format(ResourceBase.getString((String)RESOURCE_PATH, (String)"IS_NULL", (Locale)ctx.getLocale()), propertyAlias));
        }
    }

    public static String getPropertyAlias(Context ctx, AbstractObjectValue dataBaseInfo, String propertyName) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx);
        EntityObjectInfo entity = loader.getEntity(dataBaseInfo.getBOSType());
        PropertyInfo property = entity.getPropertyByName(propertyName);
        if (property == null) {
            return propertyName;
        }
        return property.getAlias();
    }

    public static Date getFormatDate(String dateValue) throws ParseException {
        DateFormat formatter = BOSLocaleUtil.getDateFormat();
        Date value = formatter.parse(dateValue);
        if (!DataImportEqmTools.isRegularRptCode(dateValue)) {
            throw new ParseException("date is error!", 0);
        }
        return value;
    }

    public static boolean isRegularRptCode(String rptCode) {
        Pattern p = Pattern.compile(DATEREGEX);
        Matcher m = p.matcher(rptCode);
        boolean rs = m.matches();
        return rs;
    }
}

