/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.maintain.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.AppLogFactory;
import com.kingdee.eas.base.log.IAppLog;
import com.kingdee.eas.base.log.app.LogServerUtil;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.eqm.common.core.GeneBillBaseInfo;
import com.kingdee.eas.eqm.common.core.GeneBillBaseStatusEnum;
import com.kingdee.eas.eqm.common.core.GeneException;
import com.kingdee.eas.eqm.common.core.app.action.IServerAction;
import com.kingdee.eas.eqm.common.core.app.action.IServerActionManager;
import com.kingdee.eas.eqm.common.core.app.util.GeneDbUtil;
import com.kingdee.eas.eqm.common.core.app.util.GeneSeverMetadataUtils;
import com.kingdee.eas.eqm.common.core.app.verify.BillStatusDeleteVerifyItem;
import com.kingdee.eas.eqm.common.core.app.verify.BillStatusModifyVerifyItem;
import com.kingdee.eas.eqm.common.core.util.GeneCommonUtils;
import com.kingdee.eas.eqm.common.core.util.GeneParamUtil;
import com.kingdee.eas.eqm.common.core.verify.AbstractVerifyItem;
import com.kingdee.eas.eqm.common.core.verify.IVerifyItem;
import com.kingdee.eas.eqm.common.core.verify.IVerifyManager;
import com.kingdee.eas.eqm.common.core.verify.VerifyManager;
import com.kingdee.eas.eqm.maintain.MaintainNotifyEntryInfo;
import com.kingdee.eas.eqm.maintain.MaintainNotifyException;
import com.kingdee.eas.eqm.maintain.MaintainNotifyInfo;
import com.kingdee.eas.eqm.maintain.WorkOrderCollection;
import com.kingdee.eas.eqm.maintain.WorkOrderFactory;
import com.kingdee.eas.eqm.maintain.WorkOrderInfo;
import com.kingdee.eas.eqm.maintain.app.AbstractMaintainNotifyControllerBean;
import com.kingdee.eas.eqm.maintain.app.MaintainNotifyAuditAction;
import com.kingdee.eas.eqm.maintain.app.MaintainNotifyForceCloseAction;
import com.kingdee.eas.eqm.maintain.app.MaintainNotifyUnAuditAction;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class MaintainNotifyControllerBean
extends AbstractMaintainNotifyControllerBean {
    private static final String BEFORE_CLOSE = "Before_Close";
    private static final String AFTER_CLOSE = "After_Close";
    private static final String BEFORE_FORCECLOSE = "Before_ForceClose";
    private static final String AFTER_FORCECLOSE = "After_ForceClose";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.eqm.maintain.app.MaintainNotifyControllerBean");

    protected void regesterServerAction(Context ctx, IServerActionManager serverActionManager) throws BOSException {
        super.regesterServerAction(ctx, serverActionManager);
        serverActionManager.addServerAction((IServerAction)new MaintainNotifyAuditAction("AFTER_AUDIT"));
        serverActionManager.addServerAction((IServerAction)new MaintainNotifyUnAuditAction("AFTER_UNAUDIT"));
        serverActionManager.addServerAction((IServerAction)new MaintainNotifyForceCloseAction(AFTER_FORCECLOSE));
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.calcBaseQty(ctx, model);
        super._addnew(ctx, pk, model);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.calcBaseQty(ctx, model);
        return super._addnew(ctx, model);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.calcBaseQty(ctx, model);
        super._update(ctx, pk, model);
    }

    protected void _unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("storageOrgUnit.id"));
        sic.add(new SelectorItemInfo("storageOrgUnit.number"));
        sic.add(new SelectorItemInfo("storageOrgUnit.name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("notifyType"));
        MaintainNotifyInfo model = this.getMaintainNotifyInfo(ctx, pk, sic);
        if (this.canUnAudit(ctx, (GeneBillBaseInfo)model)) {
            try {
                String sql = " Select 1 FID from T_IM_MaterialReqBillEntry where fsourcebillid = '" + pk.toString() + "'";
                IRowSet rs = GeneDbUtil.executeQuery((Context)ctx, (String)sql);
                if (rs.next()) {
                    this.writeLog(ctx, model, "unaudit", Boolean.FALSE);
                    throw new MaintainNotifyException(MaintainNotifyException.MAINTAINPICKINGHAVEDGENATED, new Object[]{model.getNumber()});
                }
            }
            catch (SQLException e) {
                this.writeLog(ctx, model, "unaudit", Boolean.FALSE);
                throw new BOSException((Throwable)e);
            }
            try {
                super._unAudit(ctx, pk);
                this.writeLog(ctx, model, "unaudit", Boolean.TRUE);
            }
            catch (BOSException e1) {
                this.writeLog(ctx, model, "unaudit", Boolean.FALSE);
                throw e1;
            }
            catch (EASBizException e2) {
                this.writeLog(ctx, model, "unaudit", Boolean.FALSE);
                throw e2;
            }
        }
        this.writeLog(ctx, model, "unaudit", Boolean.FALSE);
        throw new MaintainNotifyException(MaintainNotifyException.PARAMCANNOTUNAUDIT, new String[]{model.getNotifyType().getAlias(), model.getNumber()});
    }

    @Override
    public MaintainNotifyInfo getMaintainNotifyInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        try {
            return super.getMaintainNotifyInfo(ctx, pk);
        }
        catch (ObjectNotFoundException e) {
            throw new GeneException(GeneException.OBJECTNOEXIST);
        }
    }

    @Override
    public MaintainNotifyInfo getMaintainNotifyInfo(Context ctx, IObjectPK pk, SelectorItemCollection selector) throws BOSException, EASBizException {
        try {
            return super.getMaintainNotifyInfo(ctx, pk, selector);
        }
        catch (ObjectNotFoundException e) {
            throw new GeneException(GeneException.OBJECTNOEXIST);
        }
    }

    private boolean canUnAudit(Context ctx, GeneBillBaseInfo info) throws BOSException, EASBizException {
        return GeneParamUtil.paramIsSelected((Context)ctx, (String)"EQM004", (String)info.getMainOrgUnit().getId().toString());
    }

    protected boolean isAuditBySubmit(Context ctx, GeneBillBaseInfo info) throws BOSException, EASBizException {
        return GeneParamUtil.paramIsSelected((Context)ctx, (String)"EQM002", (String)info.getMainOrgUnit().getId().toString());
    }

    private void calcBaseQty(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        MaintainNotifyInfo info = (MaintainNotifyInfo)model;
        if (info.getEntrys() != null && info.getEntrys().size() > 0) {
            Iterator iter = info.getEntrys().iterator();
            while (iter.hasNext()) {
                MaintainNotifyEntryInfo entryInfo = (MaintainNotifyEntryInfo)iter.next();
                if (entryInfo.getMaterial() == null || entryInfo.getMaterial().getId() == null) continue;
                if (entryInfo.getBaseOutQty() == null) {
                    entryInfo.setBaseUnit(entryInfo.getMaterial().getBaseUnit());
                }
                BigDecimal baseReqQty = SCMUtils.getExchangePrecisionQtyForServer((Context)ctx, (String)entryInfo.getMaterial().getId().toString(), (MeasureUnitInfo)entryInfo.getUnit(), (MeasureUnitInfo)entryInfo.getBaseUnit(), (BigDecimal)(entryInfo.getReqQty() == null ? new BigDecimal(0) : entryInfo.getReqQty()));
                entryInfo.setBaseReqQty(baseReqQty);
                BigDecimal baseOutQty = SCMUtils.getExchangePrecisionQtyForServer((Context)ctx, (String)entryInfo.getMaterial().getId().toString(), (MeasureUnitInfo)entryInfo.getUnit(), (MeasureUnitInfo)entryInfo.getBaseUnit(), (BigDecimal)(entryInfo.getOutQty() == null ? new BigDecimal(0) : entryInfo.getOutQty()));
                entryInfo.setBaseOutQty(baseOutQty);
            }
        }
    }

    protected IVerifyManager getAddnewVerifyManager(Context ctx, GeneBillBaseInfo info) {
        IVerifyManager verifyManager = super.getAddnewVerifyManager(ctx, info);
        MaintainNotifyInfo notifyInfo = (MaintainNotifyInfo)info;
        verifyManager.addVerifyItem((IVerifyItem)new EntryChildVerifyItem(notifyInfo));
        verifyManager.addVerifyItem((IVerifyItem)new QtyUpZeroVerifyItem(notifyInfo));
        return verifyManager;
    }

    protected IVerifyManager getUnAuditVerifyManager(Context ctx, GeneBillBaseInfo info) {
        final MaintainNotifyInfo notifyInfo = (MaintainNotifyInfo)info;
        IVerifyManager verifyManager = super.getUnAuditVerifyManager(ctx, info);
        verifyManager.addVerifyItem((IVerifyItem)new AbstractVerifyItem(){

            public boolean verify() throws EASBizException, BOSException {
                for (int i = 0; i < notifyInfo.getEntrys().size(); ++i) {
                    MaintainNotifyEntryInfo entry = notifyInfo.getEntrys().get(i);
                    if (!entry.isIsGenDestBill()) continue;
                    throw new MaintainNotifyException(MaintainNotifyException.CANNOTUNAUDIT_GENEDESTBILL, new String[]{notifyInfo.getNumber()});
                }
                return true;
            }
        });
        return verifyManager;
    }

    protected IVerifyManager getDeleteVerifyManager(Context ctx, GeneBillBaseInfo info) {
        VerifyManager verifymanager = new VerifyManager();
        verifymanager.addVerifyItem((IVerifyItem)new BillStatusDeleteVerifyItem(info));
        return verifymanager;
    }

    protected IVerifyManager getUpdateVerifyManager(Context ctx, GeneBillBaseInfo info) {
        MaintainNotifyInfo notifyInfo = (MaintainNotifyInfo)info;
        IVerifyManager verifyManager = super.getUpdateVerifyManager(ctx, info);
        verifyManager.addVerifyItem((IVerifyItem)new BillStatusModifyVerifyItem(info));
        verifyManager.addVerifyItem((IVerifyItem)new IdentificationVerifyItem(ctx, (MaintainNotifyInfo)info));
        verifyManager.addVerifyItem((IVerifyItem)new EntryChildVerifyItem(notifyInfo));
        verifyManager.addVerifyItem((IVerifyItem)new QtyUpZeroVerifyItem(notifyInfo));
        return verifyManager;
    }

    @Override
    protected void _close(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        GeneBillBaseInfo info = (GeneBillBaseInfo)this.getValue(ctx, pk);
        String sql = "update " + this.getTableName(ctx) + " set FBillStatus=?  where fid =?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(49), pk.toString()});
        this.fireServerAction(ctx, info, AFTER_CLOSE);
    }

    @Override
    protected void _forceClose(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("storageOrgUnit.id"));
        sic.add(new SelectorItemInfo("storageOrgUnit.number"));
        sic.add(new SelectorItemInfo("storageOrgUnit.name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("billStatus"));
        MaintainNotifyInfo info = (MaintainNotifyInfo)this.getValue(ctx, pk, sic);
        if (info.getBillStatus() != GeneBillBaseStatusEnum.Audit) {
            this.writeLog(ctx, info, "forceclose", Boolean.FALSE);
            throw new MaintainNotifyException(MaintainNotifyException.FORCECLOSEVERIFY, new String[]{info.getBillStatus().getAlias()});
        }
        try {
            String sql = "update " + this.getTableName(ctx) + " set FBillStatus=?  where fid =?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(60), pk.toString()});
            this.fireServerAction(ctx, info, AFTER_FORCECLOSE);
            this.writeLog(ctx, info, "forceclose", Boolean.TRUE);
        }
        catch (BOSException e1) {
            this.writeLog(ctx, info, "forceclose", Boolean.FALSE);
            throw e1;
        }
        catch (EASBizException e2) {
            this.writeLog(ctx, info, "forceclose", Boolean.FALSE);
            throw e2;
        }
    }

    public void handleAfterTransform(Context ctx, String action, IObjectCollection collection) throws BOSException, EASBizException {
        super.handleAfterTransform(ctx, action, collection);
    }

    public void handleAfterTransform(Context ctx, String action, IObjectValue objectValue) throws BOSException, EASBizException {
        super.handleAfterTransform(ctx, action, objectValue);
        MaintainNotifyInfo model = (MaintainNotifyInfo)objectValue;
        Iterator it = model.getEntrys().iterator();
        while (it.hasNext()) {
            MaintainNotifyEntryInfo entryInfo = (MaintainNotifyEntryInfo)it.next();
            if ((entryInfo.getReqQty() == null || entryInfo.getReqQty().compareTo(new BigDecimal(0)) != 0) && entryInfo.getMaterial() != null) continue;
            it.remove();
        }
    }

    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("storageOrgUnit.id"));
        sic.add(new SelectorItemInfo("storageOrgUnit.number"));
        sic.add(new SelectorItemInfo("storageOrgUnit.name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        MaintainNotifyInfo info = (MaintainNotifyInfo)this.getValue(ctx, pk, sic);
        try {
            super._audit(ctx, pk);
            this.writeLog(ctx, info, "audit", Boolean.TRUE);
        }
        catch (BOSException e1) {
            this.writeLog(ctx, info, "audit", Boolean.FALSE);
            throw e1;
        }
        catch (EASBizException e2) {
            this.writeLog(ctx, info, "audit", Boolean.FALSE);
            throw e2;
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("storageOrgUnit.id"));
        sic.add(new SelectorItemInfo("storageOrgUnit.number"));
        sic.add(new SelectorItemInfo("storageOrgUnit.name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        MaintainNotifyInfo info = (MaintainNotifyInfo)this.getValue(ctx, pk, sic);
        try {
            super._delete(ctx, pk);
            this.writeLog(ctx, info, "delete", Boolean.TRUE);
        }
        catch (BOSException e1) {
            this.writeLog(ctx, info, "delete", Boolean.FALSE);
            throw e1;
        }
        catch (EASBizException e2) {
            this.writeLog(ctx, info, "delete", Boolean.FALSE);
            throw e2;
        }
    }

    private void writeLog(Context ctx, MaintainNotifyInfo info, String operation, Boolean isSuccessed) throws BOSException {
        if (this.getLogItem(operation) == null || "".equals(this.getLogItem(operation))) {
            return;
        }
        IAppLog appLog = AppLogFactory.getLocalInstance((Context)ctx);
        EntityObjectInfo entityObjectInfo = GeneSeverMetadataUtils.getBOSEntity((Context)ctx, (BOSObjectType)this.getBOSType());
        HashMap<String, Object> hashLog = new HashMap<String, Object>();
        LogServerUtil.setLogInfo(null, (Context)ctx, hashLog);
        hashLog.put("isSuccessed", new Boolean(false));
        hashLog.put("successed", isSuccessed);
        hashLog.put("FEntityID", this.getBOSType().toString());
        hashLog.put("FEntityName", entityObjectInfo.getName());
        hashLog.put("FEntityAlias_L1", entityObjectInfo.getAlias(ctx.getLocale()));
        hashLog.put("FEntityAlias_L2", entityObjectInfo.getAlias(ctx.getLocale()));
        hashLog.put("FEntityAlias_L3", entityObjectInfo.getAlias(ctx.getLocale()));
        hashLog.put("FMethodName", "close");
        hashLog.put("FCompanyName_L1", info.getStorageOrgUnit().getName(ctx.getLocale()));
        hashLog.put("FCompanyName_L2", info.getStorageOrgUnit().getName(ctx.getLocale()));
        hashLog.put("FCompanyName_L3", info.getStorageOrgUnit().getName(ctx.getLocale()));
        hashLog.put("FInstanceID", info.getId().toString());
        hashLog.put("FInstanceNo", info.getLogInfo());
        hashLog.put("FItemName", this.getLogItem(operation));
        hashLog.put("LOG_HIDDEN_WRITE_MODE", "LOG_HIDDEN_WRITE_MODE");
        appLog.writeLog(hashLog);
    }

    private Object getLogItem(String operation) {
        String logItem = "";
        if (operation.equals("forceclose")) {
            logItem = "eqm_maintainpickingnotify_forceclose";
        } else if (operation.equals("delete")) {
            logItem = "eqm_maintainpickingnotify_remove";
        } else if (operation.equals("audit")) {
            logItem = "eqm_maintainpickingnotify_audit";
        } else if (operation.equals("unaudit")) {
            logItem = "eqm_maintainpickingnotify_unAudit";
        }
        return logItem;
    }

    private static class QtyUpZeroVerifyItem
    extends AbstractVerifyItem {
        private MaintainNotifyInfo model = null;

        public QtyUpZeroVerifyItem(MaintainNotifyInfo model) {
            this.model = model;
        }

        public boolean verify() throws EASBizException, BOSException {
            if (!GeneCommonUtils.isEmpty((AbstractObjectCollection)this.model.getEntrys())) {
                Iterator it = this.model.getEntrys().iterator();
                while (it.hasNext()) {
                    MaintainNotifyEntryInfo entryInfo = (MaintainNotifyEntryInfo)it.next();
                    if (entryInfo.getReqQty().compareTo(new BigDecimal(0)) > 0) continue;
                    throw new MaintainNotifyException(MaintainNotifyException.PICKINGENTRYMUSTUPZERO, new String[]{this.model.getNumber(), entryInfo.getSeq() + ""});
                }
            }
            return true;
        }
    }

    private static class IdentificationVerifyItem
    extends AbstractVerifyItem {
        private MaintainNotifyInfo model = null;
        private Context ctx = null;

        public IdentificationVerifyItem(Context ctx, MaintainNotifyInfo model) {
            this.model = model;
            this.ctx = ctx;
        }

        public boolean verify() throws EASBizException, BOSException {
            if (!GeneCommonUtils.isEmpty((AbstractObjectCollection)this.model.getEntrys()) && this.model.getSourceBillType().getValue() == 20) {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add("id");
                sic.add("taskEntry.id");
                sic.add("taskEntry.childseq");
                WorkOrderInfo info = WorkOrderFactory.getLocalInstance(this.ctx).getWorkOrderInfo((IObjectPK)new ObjectUuidPK(this.model.getWorkOrder().getId()), sic);
                WorkOrderCollection taskEntry = info.getTaskEntry();
                ArrayList<String> l = new ArrayList<String>();
                if (taskEntry != null && taskEntry.size() > 0) {
                    Iterator it = taskEntry.iterator();
                    while (it.hasNext()) {
                        WorkOrderInfo entryInfo = (WorkOrderInfo)it.next();
                        l.add(entryInfo.getChildseq());
                    }
                }
                StringBuffer nonTaskNumber = new StringBuffer();
                Iterator it = this.model.getEntrys().iterator();
                while (it.hasNext()) {
                    MaintainNotifyEntryInfo entryInfo = (MaintainNotifyEntryInfo)it.next();
                    if (entryInfo.getIdentification() == null || l.contains(entryInfo.getIdentification())) continue;
                    nonTaskNumber.append(entryInfo.getIdentification() + ";");
                }
                if (nonTaskNumber.length() > 0) {
                    throw new MaintainNotifyException(MaintainNotifyException.IDENTIFYEXCEPTION, new String[]{nonTaskNumber.substring(0, nonTaskNumber.lastIndexOf(";")), this.model.getWorkOrder().getNumber()});
                }
            }
            return true;
        }
    }

    private static class EntryChildVerifyItem
    extends AbstractVerifyItem {
        private MaintainNotifyInfo model = null;

        public EntryChildVerifyItem(MaintainNotifyInfo model) {
            this.model = model;
        }

        public boolean verify() throws EASBizException, BOSException {
            if (this.model.getEntrys().isEmpty()) {
                throw new MaintainNotifyException(MaintainNotifyException.ENTRY_CANNOTBENULL, new String[]{this.model.getNumber()});
            }
            return true;
        }
    }
}

