/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.maintain.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.log.AppLogFactory;
import com.kingdee.eas.base.log.IAppLog;
import com.kingdee.eas.base.log.app.LogServerUtil;
import com.kingdee.eas.base.log.app.adapter.LogControllManager;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.eqm.archives.EquipmentArchivesInfo;
import com.kingdee.eas.eqm.basedata.EquipmentLocationInfo;
import com.kingdee.eas.eqm.basedata.EquipmentSuspendReasonInfo;
import com.kingdee.eas.eqm.basedata.EquipmentWorkOrderModelInfo;
import com.kingdee.eas.eqm.common.core.GeneBillBaseInfo;
import com.kingdee.eas.eqm.common.core.GeneBillBaseStatusEnum;
import com.kingdee.eas.eqm.common.core.GeneException;
import com.kingdee.eas.eqm.common.core.app.action.IServerAction;
import com.kingdee.eas.eqm.common.core.app.action.IServerActionManager;
import com.kingdee.eas.eqm.common.core.app.util.GeneSeverMetadataUtils;
import com.kingdee.eas.eqm.common.core.util.GeneDateUtils;
import com.kingdee.eas.eqm.common.core.util.GeneParamUtil;
import com.kingdee.eas.eqm.common.core.verify.AbstractVerifyItem;
import com.kingdee.eas.eqm.common.core.verify.IVerifyItem;
import com.kingdee.eas.eqm.common.core.verify.IVerifyManager;
import com.kingdee.eas.eqm.common.eqmcore.app.util.EQMDBUtilForDB2;
import com.kingdee.eas.eqm.maintain.FaultLevelEnum;
import com.kingdee.eas.eqm.maintain.TaskReqCollection;
import com.kingdee.eas.eqm.maintain.TaskReqException;
import com.kingdee.eas.eqm.maintain.TaskReqFactory;
import com.kingdee.eas.eqm.maintain.TaskReqInfo;
import com.kingdee.eas.eqm.maintain.TaskReqSrcTypeEnum;
import com.kingdee.eas.eqm.maintain.app.AbstractTaskReqControllerBean;
import com.kingdee.eas.eqm.maintain.app.TaskReqDeleteAction;
import com.kingdee.eas.eqm.maintain.app.TaskReqUpdateAction;
import com.kingdee.eas.eqm.maintain.app.action.StatusMontorMsgAction;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.mm.basedata.BasedataException;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import org.apache.log4j.Logger;

public class TaskReqControllerBean
extends AbstractTaskReqControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.eqm.maintain.app.TaskReqControllerBean");
    private static final String RASKREQ_RESOURCE_PATH = "com.kingdee.eas.eqm.maintain.TaskReqResource";

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.verifyInput(ctx, model);
        return super._submit(ctx, model);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK pk = super._addnew(ctx, model);
        this.createTaskReqForCheckingPlan(ctx, model, pk);
        return pk;
    }

    protected void regesterServerAction(Context ctx, IServerActionManager serverActionManager) throws BOSException {
        super.regesterServerAction(ctx, serverActionManager);
        serverActionManager.addServerAction((IServerAction)new TaskReqDeleteAction("BEFORE_DELETE"));
        serverActionManager.addServerAction((IServerAction)new StatusMontorMsgAction("AFTER_DELETE"));
        serverActionManager.addServerAction((IServerAction)new TaskReqUpdateAction("AFTER_UPDATE"));
    }

    protected boolean isAuditBySubmit(Context ctx, GeneBillBaseInfo info) throws BOSException, EASBizException {
        boolean isAutoAudit = GeneParamUtil.paramIsSelected((Context)ctx, (String)"EQM012", (String)info.getMainOrgUnit().getId().toString());
        return isAutoAudit;
    }

    protected void verifyInput(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TaskReqInfo info = (TaskReqInfo)model;
        StringBuffer showInfo = new StringBuffer();
        if (info.getStorageOrgUnit() == null) {
            showInfo.append(this.getResourceMsg("storageOrgUnit_IsNull") + "\n");
        }
        if (info.getBizDate() == null) {
            showInfo.append(this.getResourceMsg("dateBizDate_IsNull") + "\n");
        }
        if (info.getFaultSort() == null) {
            showInfo.append(this.getResourceMsg("faultSort_IsNull") + "\n");
        }
        if (info.getMaintainOrgUnit() == null) {
            showInfo.append(this.getResourceMsg("maintainOrgUnit_IsNull") + "\n");
        }
        if (info.getEquipmentLocation() == null && info.getEquipmentArchives() == null) {
            showInfo.append(this.getResourceMsg("equipmentAndLocation_isNull") + "\n");
        }
        if (showInfo.length() > 0) {
            throw new BasedataException(BasedataException.BLANK, (Object[])new String[]{showInfo.toString()});
        }
    }

    private String getResourceMsg(String key) {
        return ResourceUtils.getMessage((String)RASKREQ_RESOURCE_PATH, (String)key);
    }

    protected IVerifyManager getAuditVerifyManager(Context ctx, GeneBillBaseInfo info) {
        IVerifyManager verifymanager = super.getAuditVerifyManager(ctx, info);
        final TaskReqInfo editdata = (TaskReqInfo)info;
        verifymanager.addVerifyItem((IVerifyItem)new AbstractVerifyItem(){

            public boolean verify() throws EASBizException, BOSException {
                EquipmentSuspendReasonInfo suspendReasonInfo = editdata.getSuspendReason();
                if (suspendReasonInfo != null) {
                    throw new TaskReqException(TaskReqException.CHECKSUSPENDREASON);
                }
                return true;
            }
        });
        return verifymanager;
    }

    @Override
    protected void _suspend(Context ctx, String id, String supendReasonID) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        try {
            sql.append(" UPDATE T_EQM_TaskReq SET FBillStatus = ?,FSuspendReasonID=? ");
            sql.append(" WHERE FID = ? ");
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{new Integer(70), supendReasonID, id});
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected IObjectCollection _getCollectionByIds(Context ctx, Set idSet) throws BOSException, EASBizException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        entityViewInfo.setFilter(filterInfo);
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add(new SelectorItemInfo("*"));
        selectorItemCollection.add(new SelectorItemInfo("equipmentLocation.*"));
        selectorItemCollection.add(new SelectorItemInfo("equipmentArchives.*"));
        selectorItemCollection.add(new SelectorItemInfo("faultSort.*"));
        selectorItemCollection.add(new SelectorItemInfo("workOrderModel.*"));
        selectorItemCollection.add(new SelectorItemInfo("maintainOrgUnit.*"));
        selectorItemCollection.add(new SelectorItemInfo("maintainWorkShop.*"));
        selectorItemCollection.add(new SelectorItemInfo("finder.*"));
        selectorItemCollection.add(new SelectorItemInfo("suspendReason.*"));
        entityViewInfo.setSelector(selectorItemCollection);
        TaskReqCollection taskReqCollection = TaskReqFactory.getLocalInstance(ctx).getTaskReqCollection(entityViewInfo);
        return taskReqCollection;
    }

    @Override
    protected boolean _checkFaultSort(Context ctx, IObjectValue equipmentLocation, IObjectValue equipmentArchives, String storageOrgUnitID, String faultSortID, String id) throws BOSException, EASBizException {
        boolean bRet = false;
        try {
            StringBuffer sql = new StringBuffer();
            EquipmentLocationInfo equipmentLocationInfo = (EquipmentLocationInfo)equipmentLocation;
            EquipmentArchivesInfo equipmentArchivesInfo = (EquipmentArchivesInfo)equipmentArchives;
            if (equipmentArchivesInfo != null) {
                String equipmentArchivesID = equipmentArchivesInfo.getId().toString();
                sql.append("select FId from T_EQM_TaskReq where ");
                sql.append("FStorageOrgUnitID = '").append(storageOrgUnitID).append("' and ");
                sql.append("FFaultSortID = '").append(faultSortID).append("' and ");
                sql.append(" FEquipmentArchivesID = '").append(equipmentArchivesID).append("' and ");
                sql.append(" (FBillStatus = ?  or FBillStatus = ? or FBillStatus = ? or FBillStatus = ?) ");
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{new Integer(40), new Integer(70), new Integer(30), new Integer(20)});
                while (rs.next()) {
                    String strId = rs.getString("FId");
                    if (strId.equals(id)) {
                        bRet = false;
                        continue;
                    }
                    bRet = true;
                }
            } else {
                String equipmentLocationID = equipmentLocationInfo.getId().toString();
                sql.append("select FId from T_EQM_TaskReq where ");
                sql.append("FStorageOrgUnitID = '").append(storageOrgUnitID).append("' and ");
                sql.append("FFaultSortID = '").append(faultSortID).append("' and ");
                sql.append(" FEquipmentLocationID = '").append(equipmentLocationID).append("' and ");
                sql.append(" (FBillStatus = ?  or FBillStatus = ? or FBillStatus = ? or FBillStatus = ? )");
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{new Integer(40), new Integer(70), new Integer(30), new Integer(20)});
                while (rs.next()) {
                    String strId = rs.getString("FId");
                    if (strId.equals(id)) {
                        bRet = false;
                        continue;
                    }
                    bRet = true;
                }
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return bRet;
    }

    @Override
    protected void _forceComplete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("name");
        selector.add("number");
        selector.add("storageOrgUnit.number");
        selector.add("storageOrgUnit.name");
        TaskReqInfo taskReqInfo = TaskReqFactory.getLocalInstance(ctx).getTaskReqInfo(pk, selector);
        try {
            LogControllManager.getInstance().enableLog();
            StringBuffer sql = new StringBuffer();
            Calendar cal = Calendar.getInstance();
            Date curDate = cal.getTime();
            sql.append(" SELECT FBillStatus,FNumber FROM T_EQM_TaskReq WHERE FID = ? ");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{pk.toString()});
            try {
                if (rowSet.next()) {
                    String number = rowSet.getString("FNumber");
                    int billStatus = rowSet.getInt("FBillStatus");
                    if (billStatus != 30 && billStatus != 70 && billStatus != 40) {
                        throw new TaskReqException(TaskReqException.CHECK_FORCECLOSEDSTATUS, new Object[]{number, GeneBillBaseStatusEnum.getEnum((int)billStatus).getAlias()});
                    }
                }
                sql.setLength(0);
                sql.append(" UPDATE T_EQM_TaskReq SET FBillStatus = ?,FCloseDate=?");
                sql.append(" WHERE FID = ? ");
                DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{new Integer(60), new Timestamp(curDate.getTime()), pk.toString()});
            }
            catch (SQLException e) {
                this.writeLog(ctx, taskReqInfo, "forceclosed", new Boolean(false));
                throw new BOSException((Throwable)e);
            }
            this.writeLog(ctx, taskReqInfo, "forceclosed", new Boolean(true));
        }
        catch (BOSException e1) {
            this.writeLog(ctx, taskReqInfo, "forceclosed", new Boolean(false));
            throw e1;
        }
        catch (EASBizException e2) {
            this.writeLog(ctx, taskReqInfo, "forceclosed", new Boolean(false));
            throw e2;
        }
    }

    @Override
    protected void _complete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("name");
        selector.add("number");
        selector.add("storageOrgUnit.number");
        selector.add("storageOrgUnit.name");
        TaskReqInfo taskReqInfo = TaskReqFactory.getLocalInstance(ctx).getTaskReqInfo(pk, selector);
        try {
            LogControllManager.getInstance().enableLog();
            StringBuffer sql = new StringBuffer();
            Calendar cal = Calendar.getInstance();
            Date curDate = cal.getTime();
            sql.append(" SELECT FBillStatus,FNumber FROM T_EQM_TaskReq WHERE FID = ? ");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{pk.toString()});
            try {
                if (rowSet.next()) {
                    String number = rowSet.getString("FNumber");
                    int billStatus = rowSet.getInt("FBillStatus");
                    if (billStatus != 30 && billStatus != 70 && billStatus != 40) {
                        throw new TaskReqException(TaskReqException.CHECK_CLOSEDSTATUS, new Object[]{number, GeneBillBaseStatusEnum.getEnum((int)billStatus).getAlias()});
                    }
                }
                sql.setLength(0);
                sql.append(" UPDATE T_EQM_TaskReq SET FBillStatus = ?,FCloseDate=?");
                sql.append(" WHERE FID = ? ");
                DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{new Integer(49), new Timestamp(curDate.getTime()), pk.toString()});
            }
            catch (SQLException e) {
                this.writeLog(ctx, taskReqInfo, "closed", new Boolean(false));
                throw new BOSException((Throwable)e);
            }
            this.writeLog(ctx, taskReqInfo, "closed", new Boolean(true));
        }
        catch (BOSException e1) {
            this.writeLog(ctx, taskReqInfo, "closed", new Boolean(false));
            throw e1;
        }
        catch (EASBizException e2) {
            this.writeLog(ctx, taskReqInfo, "closed", new Boolean(false));
            throw e2;
        }
    }

    @Override
    public TaskReqInfo getTaskReqInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        try {
            return super.getTaskReqInfo(ctx, pk);
        }
        catch (ObjectNotFoundException e) {
            throw new GeneException(GeneException.OBJECTNOEXIST);
        }
    }

    @Override
    public TaskReqInfo getTaskReqInfo(Context ctx, IObjectPK pk, SelectorItemCollection selector) throws BOSException, EASBizException {
        try {
            return super.getTaskReqInfo(ctx, pk, selector);
        }
        catch (ObjectNotFoundException e) {
            throw new GeneException(GeneException.OBJECTNOEXIST);
        }
    }

    @Override
    protected TaskReqInfo _createTaskReqForStatusDetect(Context ctx, EquipmentArchivesInfo equipment, EquipmentLocationInfo location, StorageOrgUnitInfo storageOrgUnit, EquipmentWorkOrderModelInfo workOrderType, String description) throws BOSException, EASBizException {
        Calendar cal = Calendar.getInstance();
        Date curDate = cal.getTime();
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss sssss");
        String strDate = sf.format(curDate);
        try {
            TaskReqInfo taskReq = this.newInstanceData();
            taskReq.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
            if (equipment != null) {
                taskReq.setEquipmentArchives(equipment);
            }
            if (location != null) {
                taskReq.setEquipmentLocation(location);
            }
            if (storageOrgUnit != null) {
                taskReq.setStorageOrgUnit(storageOrgUnit);
                taskReq.setMaintainOrgUnit(storageOrgUnit);
            }
            if (workOrderType != null) {
                taskReq.setWorkOrderModel(workOrderType);
            }
            taskReq.setFaultLevel(FaultLevelEnum.Two);
            taskReq.setEqmRunning(false);
            taskReq.setSourceType(TaskReqSrcTypeEnum.BYMETER);
            String result = null;
            ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            if (taskReq.getStorageOrgUnit() != null && taskReq.getStorageOrgUnit().getId() != null && codingRuleManager.isExist((IObjectValue)taskReq, taskReq.getStorageOrgUnit().getId().toString())) {
                result = codingRuleManager.getNumber((IObjectValue)taskReq, taskReq.getStorageOrgUnit().getId().toString());
            }
            if (result == null) {
                cal.setTimeInMillis(6L);
                taskReq.setNumber("Req" + strDate);
            } else {
                taskReq.setNumber(result);
            }
            if (description != null) {
                taskReq.setAccessoryDetails(description);
            }
            TaskReqFactory.getLocalInstance(ctx).save((CoreBaseInfo)taskReq);
            return taskReq;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected void createTaskReqForCheckingPlan(Context ctx, IObjectValue model, IObjectPK pk) throws BOSException, EASBizException {
        TaskReqInfo info = (TaskReqInfo)model;
        if (info.getSourceType().equals((Object)TaskReqSrcTypeEnum.BYPOINTINSPECTION)) {
            StringBuffer sql = new StringBuffer();
            String checkPlanId = (String)model.get("CheckPlanningId");
            if (checkPlanId != null) {
                String CheckPlanBillEntryID = BOSUuid.create((String)"1A2F30DB").toString();
                sql.append("INSERT INTO T_EQM_CheckPlanningMaintain ");
                sql.append("(FID,FPARENTID,FTASKID,FFAULTID,FBILLTYPE,FBILL) VALUES");
                sql.append("(?,?,?,?,?,?)");
                EQMDBUtilForDB2.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{CheckPlanBillEntryID, checkPlanId == null ? null : checkPlanId, model.get("TaskEntryId") == null ? null : model.get("TaskEntryId").toString(), model.get("FaultEntryId") == null ? null : model.get("FaultEntryId").toString(), new Integer(20), pk.toString()});
            }
        }
    }

    protected TaskReqInfo newInstanceData() throws BOSException, ParseException {
        TaskReqInfo objectValue = new TaskReqInfo();
        Calendar cal = Calendar.getInstance();
        Date curDate = cal.getTime();
        DateFormat sf = BOSLocaleUtil.getDateTimeFormat();
        String strDate = sf.format(curDate);
        Date formatDate = sf.parse(strDate);
        objectValue.setFindDate(formatDate);
        objectValue.setBizDate(formatDate);
        objectValue.setCreateTime(GeneDateUtils.nowTime());
        objectValue.setEqmRunning(false);
        return objectValue;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("name");
        selector.add("number");
        selector.add("storageOrgUnit.number");
        selector.add("storageOrgUnit.name");
        TaskReqInfo taskReqInfo = TaskReqFactory.getLocalInstance(ctx).getTaskReqInfo(pk, selector);
        try {
            super._delete(ctx, pk);
            this.writeLog(ctx, taskReqInfo, "delete", new Boolean(true));
        }
        catch (BOSException e1) {
            this.writeLog(ctx, taskReqInfo, "delete", new Boolean(false));
            throw e1;
        }
        catch (EASBizException e2) {
            this.writeLog(ctx, taskReqInfo, "delete", new Boolean(false));
            throw e2;
        }
    }

    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("name");
        selector.add("number");
        selector.add("storageOrgUnit.number");
        selector.add("storageOrgUnit.name");
        TaskReqInfo taskReqInfo = TaskReqFactory.getLocalInstance(ctx).getTaskReqInfo(pk, selector);
        try {
            super._audit(ctx, pk);
            this.writeLog(ctx, taskReqInfo, "audit", new Boolean(true));
        }
        catch (BOSException e1) {
            this.writeLog(ctx, taskReqInfo, "audit", new Boolean(false));
            throw e1;
        }
        catch (EASBizException e2) {
            this.writeLog(ctx, taskReqInfo, "audit", new Boolean(false));
            throw e2;
        }
    }

    protected void _unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("name");
        selector.add("number");
        selector.add("storageOrgUnit.number");
        selector.add("storageOrgUnit.name");
        TaskReqInfo taskReqInfo = TaskReqFactory.getLocalInstance(ctx).getTaskReqInfo(pk, selector);
        try {
            super._unAudit(ctx, pk);
            this.writeLog(ctx, taskReqInfo, "unaudit", new Boolean(true));
        }
        catch (BOSException e1) {
            this.writeLog(ctx, taskReqInfo, "unaudit", new Boolean(false));
            throw e1;
        }
        catch (EASBizException e2) {
            this.writeLog(ctx, taskReqInfo, "unaudit", new Boolean(false));
            throw e2;
        }
    }

    private void writeLog(Context ctx, TaskReqInfo taskReqInfo, String operation, Boolean isSuccessed) throws BOSException {
        if (this.getLogItem(operation) == null || "".equals(this.getLogItem(operation))) {
            return;
        }
        IAppLog appLog = AppLogFactory.getLocalInstance((Context)ctx);
        EntityObjectInfo entityObjectInfo = GeneSeverMetadataUtils.getBOSEntity((Context)ctx, (BOSObjectType)this.getBOSType());
        HashMap<String, Object> hashLog = new HashMap<String, Object>();
        LogServerUtil.setLogInfo(null, (Context)ctx, hashLog);
        hashLog.put("isSuccessed", new Boolean(false));
        hashLog.put("successed", isSuccessed);
        hashLog.put("FEntityID", this.getBOSType().toString());
        hashLog.put("FEntityName", entityObjectInfo.getName());
        hashLog.put("FEntityAlias_L1", entityObjectInfo.getAlias(ctx.getLocale()));
        hashLog.put("FEntityAlias_L2", entityObjectInfo.getAlias(ctx.getLocale()));
        hashLog.put("FEntityAlias_L3", entityObjectInfo.getAlias(ctx.getLocale()));
        hashLog.put("FMethodName", "close");
        hashLog.put("FCompanyName_L1", taskReqInfo.getStorageOrgUnit().getName(ctx.getLocale()));
        hashLog.put("FCompanyName_L2", taskReqInfo.getStorageOrgUnit().getName(ctx.getLocale()));
        hashLog.put("FCompanyName_L3", taskReqInfo.getStorageOrgUnit().getName(ctx.getLocale()));
        hashLog.put("FInstanceID", taskReqInfo.getId().toString());
        hashLog.put("FInstanceNo", taskReqInfo.getLogInfo());
        hashLog.put("FItemName", this.getLogItem(operation));
        hashLog.put("LOG_HIDDEN_WRITE_MODE", "LOG_HIDDEN_WRITE_MODE");
        appLog.writeLog(hashLog);
    }

    private Object getLogItem(String operation) {
        String logItem = "";
        if (operation.equals("delete")) {
            logItem = "eqm_maintain_taskreq_delete";
        } else if (operation.equals("audit")) {
            logItem = "eqm_maintain_taskreq_audit";
        } else if (operation.equals("unaudit")) {
            logItem = "eqm_maintain_taskreq_unaudit";
        } else if ("closed".equals(operation)) {
            logItem = "eqm_maintain_taskreq_closed";
        } else if ("forceclosed".equals(operation)) {
            logItem = "eqm_maintain_taskreq_forceclosed";
        }
        return logItem;
    }
}

