/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.maintain.app.action;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.eqm.common.core.GeneBillBaseStatusEnum;
import com.kingdee.eas.eqm.common.core.verify.AbstractVerifyItem;
import com.kingdee.eas.eqm.common.core.verify.IVerifyItem;
import com.kingdee.eas.eqm.maintain.WorkOrderException;
import com.kingdee.eas.eqm.maintain.WorkOrderInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.text.MessageFormat;
import java.util.Locale;

public class WorkOrderPermitVerifyItem
extends AbstractVerifyItem
implements IVerifyItem {
    private Context ctx = null;
    private WorkOrderInfo workOrder = null;
    private GeneBillBaseStatusEnum[] status = null;
    private GeneBillBaseStatusEnum currentStatus = null;
    protected static final String RESOURCE_PATH = "com.kingdee.eas.eqm.maintain.WorkOrderResource";

    public WorkOrderPermitVerifyItem(Context ctx, WorkOrderInfo workOrderInfo, GeneBillBaseStatusEnum[] status, GeneBillBaseStatusEnum currentStatus) {
        this.ctx = ctx;
        this.workOrder = workOrderInfo;
        this.status = status;
        this.currentStatus = currentStatus;
    }

    public boolean verify() throws EASBizException, BOSException {
        String sql = "SELECT T0.FID, T0.FPARENTID, T0.FBILLSTATUS, T0.FSTATUSEXTEND,T1.FID AS FWORKPERMITID,T1.FBILLSTATUS AS FPERMITSTATUS,T0.FNUMBER AS FWORKORDERNUMBER,T1.FNUMBER AS FWORKPERMITNUMBER FROM T_EQM_WORKORDER T0,T_EQM_WorkPermit T1 WHERE T0.FSUPERPARENTID = ? AND T0.FID = T1.FWorkOrderID AND T1.FIsStrictControl = 1 ";
        IRowSet workOrderTree = DbUtil.executeQuery((Context)this.ctx, (String)sql, (Object[])new Object[]{this.workOrder.getSuperParent().getId().toString()});
        StringBuffer errmsg = new StringBuffer();
        this.loopVerify(workOrderTree, this.workOrder.getId().toString(), this.status, errmsg);
        if (errmsg.length() > 0) {
            StringBuffer headMsg = new StringBuffer();
            headMsg.append("\n");
            headMsg.append(MessageFormat.format(ResourceBase.getString((String)RESOURCE_PATH, (String)"STARTWORKERRORHEADMSG", (Locale)ContextUtils.getLocaleFromEnv()), this.currentStatus.getAlias()) + "\n");
            headMsg.append(errmsg.toString());
            headMsg.append("\n");
            throw new WorkOrderException(WorkOrderException.GENERAL, new String[]{headMsg.toString()});
        }
        return true;
    }

    private void loopVerify(IRowSet workOrderTree, String parentid, GeneBillBaseStatusEnum[] status, StringBuffer errmsg) throws BOSException {
        try {
            if (workOrderTree == null || workOrderTree.size() <= 0) {
                return;
            }
            for (int i = 0; i < workOrderTree.size(); ++i) {
                int j;
                workOrderTree.absolute(i + 1);
                String workorderid = workOrderTree.getString("FID");
                int permitStatus = workOrderTree.getInt("FPERMITSTATUS");
                String workOrderNumber = workOrderTree.getString("FWORKORDERNUMBER");
                String permitNumber = workOrderTree.getString("FWORKPERMITNUMBER");
                boolean include = false;
                if (!parentid.equals(workorderid)) continue;
                if (status != null && status.length > 0) {
                    String detailMsg;
                    for (j = 0; j < status.length; ++j) {
                        if (permitStatus != status[j].getValue()) continue;
                        include = true;
                        break;
                    }
                    if (!include && errmsg.indexOf(detailMsg = MessageFormat.format(ResourceBase.getString((String)RESOURCE_PATH, (String)"STARTWORKERRORDETAIL", (Locale)ContextUtils.getLocaleFromEnv()), workOrderNumber, permitNumber, GeneBillBaseStatusEnum.getEnum((int)permitStatus).getAlias())) < 0) {
                        errmsg.append(detailMsg + "\n");
                    }
                }
                for (j = 0; j < workOrderTree.size(); ++j) {
                    workOrderTree.absolute(j + 1);
                    String subWorkOrderID = workOrderTree.getString("FID");
                    String subWorkOrderParentID = workOrderTree.getString("FPARENTID");
                    int subWorkOrderStatusExtend = workOrderTree.getInt("FSTATUSEXTEND");
                    if (subWorkOrderParentID == null || !subWorkOrderParentID.equals(parentid) || subWorkOrderStatusExtend != 1) continue;
                    this.loopVerify(workOrderTree, subWorkOrderID, status, errmsg);
                }
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }
}

