/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.maintain.app.verify;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.eqm.common.core.GeneBillBaseInfo;
import com.kingdee.eas.eqm.common.core.verify.AbstractVerifyItem;
import com.kingdee.eas.eqm.common.core.verify.IVerifyItem;
import com.kingdee.eas.eqm.maintain.WorkOrderException;
import com.kingdee.eas.eqm.maintain.WorkOrderInfo;
import com.kingdee.eas.eqm.maintain.WorkOrderMaterialEntryCollection;
import com.kingdee.eas.eqm.maintain.WorkOrderMaterialEntryInfo;
import com.kingdee.eas.eqm.maintain.WorkOrderServiceEntryCollection;
import com.kingdee.eas.eqm.maintain.WorkOrderServiceEntryInfo;
import com.kingdee.eas.eqm.maintain.WorkOrderToolsEntryCollection;
import com.kingdee.eas.eqm.maintain.WorkOrderToolsEntryInfo;
import com.kingdee.eas.eqm.maintain.WorkOrderUserEntryCollection;
import com.kingdee.eas.eqm.maintain.WorkOrderUserEntryInfo;

public class WorkOrderEmptyVerifyItem
extends AbstractVerifyItem
implements IVerifyItem {
    protected static final String RESOURCE_PATH = "com.kingdee.eas.eqm.maintain.WorkOrderResource";
    private Context ctx = null;
    private GeneBillBaseInfo info;
    private boolean verifyChildren;

    public WorkOrderEmptyVerifyItem(Context ctx, GeneBillBaseInfo info, boolean verifyChildren) {
        this.ctx = ctx;
        this.info = info;
        this.verifyChildren = verifyChildren;
    }

    public boolean verify() throws EASBizException, BOSException {
        WorkOrderInfo woInfo = (WorkOrderInfo)this.info;
        if (!this.verifyChildren && woInfo.isFastReport()) {
            this.verifyInput(woInfo);
            return true;
        }
        return true;
    }

    public void verifyInput(WorkOrderInfo info) throws BOSException, EASBizException {
        WorkOrderServiceEntryCollection serviceC;
        WorkOrderToolsEntryCollection toolsC;
        WorkOrderMaterialEntryCollection materialC;
        if (info == null) {
            return;
        }
        WorkOrderUserEntryCollection userC = info.getUserEntry();
        if (userC != null && userC.size() > 0) {
            for (int i = 0; i < userC.size(); ++i) {
                WorkOrderUserEntryInfo entry = userC.get(i);
                if (entry.getCurrency() != null) continue;
                throw new WorkOrderException(WorkOrderException.USER_CURRENCY_NULL, new Object[]{info.getNumber()});
            }
        }
        if ((materialC = info.getMaterialEntry()) != null && materialC.size() > 0) {
            for (int i = 0; i < materialC.size(); ++i) {
                WorkOrderMaterialEntryInfo entry = materialC.get(i);
                if (entry.getCurrency() != null) continue;
                throw new WorkOrderException(WorkOrderException.MATERIAL_CURRENCY_NULL, new Object[]{info.getNumber()});
            }
        }
        if ((toolsC = info.getToolsEntry()) != null && toolsC.size() > 0) {
            for (int i = 0; i < toolsC.size(); ++i) {
                WorkOrderToolsEntryInfo entry = toolsC.get(i);
                if (entry.getCurrency() != null) continue;
                throw new WorkOrderException(WorkOrderException.TOOLS_CURRENCY_NULL, new Object[]{info.getNumber()});
            }
        }
        if ((serviceC = info.getServiceEntry()) != null && serviceC.size() > 0) {
            for (int i = 0; i < serviceC.size(); ++i) {
                WorkOrderServiceEntryInfo entry = serviceC.get(i);
                if (entry.getCurrency() != null) continue;
                throw new WorkOrderException(WorkOrderException.SERVICE_CURRENCY_NULL, new Object[]{info.getNumber()});
            }
        }
    }
}

