/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.planning.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.log.app.adapter.LogControllManager;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.eqm.common.core.GeneBillBaseStatusEnum;
import com.kingdee.eas.eqm.common.core.app.util.GeneDbUtil;
import com.kingdee.eas.eqm.common.core.util.GeneSelectorUtils;
import com.kingdee.eas.eqm.maintain.TaskReqCollection;
import com.kingdee.eas.eqm.maintain.TaskReqFactory;
import com.kingdee.eas.eqm.maintain.TaskReqInfo;
import com.kingdee.eas.eqm.maintain.WorkOrderCollection;
import com.kingdee.eas.eqm.maintain.WorkOrderFactory;
import com.kingdee.eas.eqm.maintain.WorkOrderInfo;
import com.kingdee.eas.eqm.planning.CheckingPlanningCpMatintainCollection;
import com.kingdee.eas.eqm.planning.CheckingPlanningCpMatintainFactory;
import com.kingdee.eas.eqm.planning.CheckingPlanningCpMatintainInfo;
import com.kingdee.eas.eqm.planning.CheckingPlanningCpTaskCollection;
import com.kingdee.eas.eqm.planning.CheckingPlanningCpTaskInfo;
import com.kingdee.eas.eqm.planning.CheckingPlanningException;
import com.kingdee.eas.eqm.planning.CheckingPlanningInfo;
import com.kingdee.eas.eqm.planning.SrcBillTypeEnum;
import com.kingdee.eas.eqm.planning.app.AbstractCheckingPlanningControllerBean;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class CheckingPlanningControllerBean
extends AbstractCheckingPlanningControllerBean {
    private static final long serialVersionUID = 1645102973067877288L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.eqm.planning.app.CheckingPlanningControllerBean");
    private static final int MAX_DATA_ROW = 100;

    @Override
    protected void _closed(Context ctx, IObjectPK id) throws BOSException, EASBizException {
        LogControllManager.getInstance().enableLog();
        IObjectValue model = this._getValue(ctx, id);
        CheckingPlanningInfo info = (CheckingPlanningInfo)model;
        if (info.getBillStatus().getValue() != 45) {
            throw new CheckingPlanningException(CheckingPlanningException.ISNOTRELEASESTATUS);
        }
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        info.setBillStatus(GeneBillBaseStatusEnum.CLOSED);
        info.setHandlerTime(new Date());
        info.setHandler(user);
        super._update(ctx, id, model);
    }

    @Override
    protected void _release(Context ctx, IObjectPK id) throws BOSException, EASBizException {
        LogControllManager.getInstance().enableLog();
        IObjectValue model = this._getValue(ctx, id);
        CheckingPlanningInfo info = (CheckingPlanningInfo)model;
        if (info.getBillStatus().getValue() != 10) {
            throw new CheckingPlanningException(CheckingPlanningException.ISNOTSAVESTATUS);
        }
        CheckingPlanningCpTaskCollection tasks = info.getCpTask();
        if (tasks.size() > 0) {
            Iterator task = tasks.iterator();
            while (task.hasNext()) {
                CheckingPlanningCpTaskInfo taskInfo = (CheckingPlanningCpTaskInfo)task.next();
                if (!StringUtil.isEmptyString((String)taskInfo.getTaskDescription())) continue;
                throw new CheckingPlanningException(CheckingPlanningException.DESCRIPTIONISNULL);
            }
        } else {
            throw new CheckingPlanningException(CheckingPlanningException.ATLEASTONETASK);
        }
        info.setBillStatus(GeneBillBaseStatusEnum.Release);
        super._update(ctx, id, model);
    }

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        CheckingPlanningInfo info = (CheckingPlanningInfo)super._getValue(ctx, pk);
        this.loadMaintain(ctx, info);
        return info;
    }

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk, SelectorItemCollection selector) throws BOSException, EASBizException {
        CheckingPlanningInfo info = (CheckingPlanningInfo)super._getValue(ctx, pk, selector);
        this.loadMaintain(ctx, info);
        return info;
    }

    @Override
    protected IObjectValue _getValue(Context ctx, String oql) throws BOSException, EASBizException {
        CheckingPlanningInfo info = (CheckingPlanningInfo)super._getValue(ctx, oql);
        this.loadMaintain(ctx, info);
        return info;
    }

    private void loadMaintain(Context ctx, CheckingPlanningInfo info) {
        try {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)info.getId().toString()));
            view.setFilter(filter);
            CheckingPlanningCpMatintainInfo p = null;
            SelectorItemCollection sic = new SelectorItemCollection();
            GeneSelectorUtils.addSelectorWithPros((SelectorItemCollection)sic, (String[])new String[]{"billType", "bill"});
            GeneSelectorUtils.addSelectorWithPros((SelectorItemCollection)sic, (String[])new String[]{"task.achieves.id", "task.achieves.number", "task.achieves.name", "task.location.id", "task.location.number", "task.location.name", "task.taskDescription"});
            GeneSelectorUtils.addSelectorWithPros((SelectorItemCollection)sic, (String[])new String[]{"fault.achieves.id", "fault.achieves.number", "fault.achieves.name", "fault.location.id", "fault.location.number", "fault.location.name", "fault.faultSort.id", "fault.faultSort.number", "fault.faultSort.name"});
            view.setSelector(sic);
            CheckingPlanningCpMatintainCollection cpMaintainList = null;
            cpMaintainList = CheckingPlanningCpMatintainFactory.getLocalInstance(ctx).getCheckingPlanningCpMatintainCollection(view);
            WorkOrderCollection workList = new WorkOrderCollection();
            TaskReqCollection taskreqList = new TaskReqCollection();
            for (int i = 0; i < cpMaintainList.size(); ++i) {
                p = cpMaintainList.get(i);
                if (p.getBillType().equals((Object)SrcBillTypeEnum.quickWorkOrder)) {
                    WorkOrderInfo workInfo = null;
                    SelectorItemCollection sicWO = new SelectorItemCollection();
                    sicWO.add(new SelectorItemInfo("id"));
                    sicWO.add(new SelectorItemInfo("number"));
                    sicWO.add(new SelectorItemInfo("name"));
                    sicWO.add(new SelectorItemInfo("billStatus"));
                    workInfo = WorkOrderFactory.getLocalInstance((Context)ctx).getWorkOrderInfo((IObjectPK)new ObjectUuidPK(p.getBill()), sicWO);
                    workList.add(workInfo);
                    cpMaintainList.add(p);
                    continue;
                }
                TaskReqInfo taskInfo = TaskReqFactory.getLocalInstance((Context)ctx).getTaskReqInfo((IObjectPK)new ObjectUuidPK(p.getBill()), this.getSelectors());
                taskreqList.add(taskInfo);
            }
            info.put("workList", workList);
            info.put("taskreqList", taskreqList);
            info.put("cpMaintainList", (Object)cpMaintainList);
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("storageOrgUnit.id"));
        sic.add(new SelectorItemInfo("storageOrgUnit.number"));
        sic.add(new SelectorItemInfo("storageOrgUnit.name"));
        sic.add(new SelectorItemInfo("billStatus"));
        sic.add(new SelectorItemInfo("equipmentLocation.id"));
        sic.add(new SelectorItemInfo("equipmentLocation.number"));
        sic.add(new SelectorItemInfo("equipmentLocation.name"));
        sic.add(new SelectorItemInfo("equipmentLocation.name"));
        sic.add(new SelectorItemInfo("equipmentArchives.id"));
        sic.add(new SelectorItemInfo("equipmentArchives.number"));
        sic.add(new SelectorItemInfo("equipmentArchives.name"));
        sic.add(new SelectorItemInfo("faultLevel"));
        sic.add(new SelectorItemInfo("faultSort.id"));
        sic.add(new SelectorItemInfo("faultSort.number"));
        sic.add(new SelectorItemInfo("faultSort.name"));
        sic.add(new SelectorItemInfo("finder.id"));
        sic.add(new SelectorItemInfo("finder.number"));
        sic.add(new SelectorItemInfo("finder.name"));
        sic.add(new SelectorItemInfo("findDate"));
        sic.add(new SelectorItemInfo("maintainOrgUnit.id"));
        sic.add(new SelectorItemInfo("maintainOrgUnit.number"));
        sic.add(new SelectorItemInfo("maintainOrgUnit.name"));
        return sic;
    }

    private void updateCheckPointLog(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE T_EQM_CheckPointLog SET FCheckPlanningID = ").append("null").append(" WHERE FCheckPlanningID = ?");
        try {
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{pk.toString()});
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
    }

    private void updateCheckPointLog(Context ctx, IObjectPK[] logpks) throws BOSException, EASBizException {
        Connection conn = null;
        Statement statement = null;
        StringBuffer sql = new StringBuffer();
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            sql.append("UPDATE T_EQM_CheckPointLog SET FCheckPlanningID = ").append("null").append(" WHERE FCheckPlanningID in ('");
            for (int i = 0; i < logpks.length; ++i) {
                sql.append(logpks[i].toString()).append("'");
                if (i != logpks.length - 1) {
                    sql.append(",'");
                    continue;
                }
                sql.append(")");
            }
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup(statement, (Connection)conn);
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.updateCheckPointLog(ctx, pk);
        super._delete(ctx, pk);
    }

    protected void _delete(Context ctx, IObjectPK[] arrayPK) throws BOSException, EASBizException {
        this.updateCheckPointLog(ctx, arrayPK);
        super._delete(ctx, arrayPK);
    }

    public BatchActionResults batchDelete(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        long deleteStart = System.currentTimeMillis();
        BatchActionResults batchResults = BatchActionResults.populateActionResults((BatchExecuteParamsEntry[])entries);
        if (entries != null && entries.length != 0) {
            BatchExecuteParamsEntry[] paramEntries = batchResults.getParamEntries();
            String sql1 = " DELETE FROM T_EQM_CHECKPLANNING WHERE FID = ? ";
            String sql2 = " DELETE FROM T_EQM_CHECKPLANNINGCPTASK WHERE FPARENTID = ? ";
            String sql3 = " DELETE FROM T_EQM_CHECKPLANNINGCPFAULTSORT WHERE FPARENTID = ? ";
            String sql4 = " DELETE FROM T_EQM_CHECKPLANNINGMAINTAIN WHERE FPARENTID = ? ";
            ArrayList<Object[]> list = new ArrayList<Object[]>();
            int n = paramEntries.length;
            for (int i = 0; i < n; ++i) {
                list.add(new Object[]{paramEntries[i].get(0).toString()});
            }
            GeneDbUtil.executeBatchWithOutTimeOut((Context)ctx, (String)sql1, list);
            GeneDbUtil.executeBatchWithOutTimeOut((Context)ctx, (String)sql2, list);
            GeneDbUtil.executeBatchWithOutTimeOut((Context)ctx, (String)sql3, list);
            GeneDbUtil.executeBatchWithOutTimeOut((Context)ctx, (String)sql4, list);
            long deleteEnd = System.currentTimeMillis();
            double deleteTime = (double)(deleteEnd - deleteStart) / 1000.0;
            System.out.println("CheckPlanning_Delete_Time = " + deleteTime + "s");
        }
        return batchResults;
    }

    public BatchActionResults batchRelease(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        long releaseStart = System.currentTimeMillis();
        BatchActionResults batchResults = BatchActionResults.populateActionResults((BatchExecuteParamsEntry[])entries);
        if (entries != null && entries.length != 0) {
            BatchExecuteParamsEntry[] paramEntries = batchResults.getParamEntries();
            ArrayList<String> toDoIdsList = new ArrayList<String>();
            ArrayList<Object[]> successedIdsList = new ArrayList<Object[]>();
            int n = paramEntries.length;
            for (int i = 0; i < n; ++i) {
                ObjectUuidPK id = (ObjectUuidPK)paramEntries[i].get(0);
                toDoIdsList.add(id.toString());
            }
            try {
                IRowSet rs = null;
                String verifyBillStatusSql = null;
                String verifyTaskDescriptionSql = null;
                StringBuffer verifyBillStatusSB = new StringBuffer();
                StringBuffer verifyTaskDescriptionSB = new StringBuffer();
                verifyBillStatusSB.append(" SELECT FID FROM T_EQM_CHECKPLANNING WHERE FID IN ( ");
                int i = 0;
                int j = toDoIdsList.size();
                int k = 1;
                while (i < j) {
                    verifyBillStatusSB.append("'").append((String)toDoIdsList.get(i)).append("',");
                    if (k == 100) {
                        verifyBillStatusSB.deleteCharAt(verifyBillStatusSB.length() - 1).append(" ) AND FBILLSTATUS <> 10 ");
                        verifyBillStatusSql = verifyBillStatusSB.toString();
                        verifyBillStatusSB.setLength(0);
                        verifyBillStatusSB.append(" SELECT FID FROM T_EQM_CHECKPLANNING WHERE FID IN ( ");
                        k = 0;
                        rs = DbUtil.executeQuery((Context)ctx, (String)verifyBillStatusSql);
                        while (rs != null && rs.next()) {
                            batchResults.addError(rs.getString("FID"), (Exception)((Object)new CheckingPlanningException(CheckingPlanningException.ISNOTSAVESTATUS)));
                            toDoIdsList.remove(rs.getString("FID"));
                            --i;
                            --j;
                        }
                    }
                    ++i;
                    ++k;
                }
                if (",".equals(verifyBillStatusSB.substring(verifyBillStatusSB.length() - 1))) {
                    verifyBillStatusSB.deleteCharAt(verifyBillStatusSB.length() - 1).append(" ) AND FBILLSTATUS <> 10 ");
                    verifyBillStatusSql = verifyBillStatusSB.toString();
                    rs = DbUtil.executeQuery((Context)ctx, (String)verifyBillStatusSql);
                    while (rs != null && rs.next()) {
                        batchResults.addError(rs.getString("FID"), (Exception)((Object)new CheckingPlanningException(CheckingPlanningException.ISNOTSAVESTATUS)));
                        toDoIdsList.remove(rs.getString("FID"));
                    }
                }
                verifyTaskDescriptionSB.append(" SELECT FPARENTID FROM T_EQM_CHECKPLANNINGCPTASK WHERE FPARENTID IN ( ");
                i = 0;
                j = toDoIdsList.size();
                k = 1;
                while (i < j) {
                    verifyTaskDescriptionSB.append("'").append((String)toDoIdsList.get(i)).append("',");
                    if (k == 100) {
                        verifyTaskDescriptionSB.deleteCharAt(verifyTaskDescriptionSB.length() - 1).append(" ) AND FTASKDESCRIPTION IS NULL ORDER BY FPARENTID");
                        verifyTaskDescriptionSql = verifyTaskDescriptionSB.toString();
                        verifyTaskDescriptionSB.setLength(0);
                        verifyTaskDescriptionSB.append(" SELECT FPARENTID FROM T_EQM_CHECKPLANNINGCPTASK WHERE FPARENTID IN ( ");
                        k = 0;
                        rs = DbUtil.executeQuery((Context)ctx, (String)verifyTaskDescriptionSql);
                        while (rs != null && rs.next()) {
                            batchResults.addError(rs.getString("FPARENTID"), (Exception)((Object)new CheckingPlanningException(CheckingPlanningException.DESCRIPTIONISNULL)));
                            toDoIdsList.remove(rs.getString("FPARENTID"));
                            --i;
                            --j;
                        }
                    }
                    ++i;
                    ++k;
                }
                if (",".equals(verifyTaskDescriptionSB.substring(verifyTaskDescriptionSB.length() - 1))) {
                    verifyTaskDescriptionSB.deleteCharAt(verifyTaskDescriptionSB.length() - 1).append(" ) AND FTASKDESCRIPTION IS NULL ORDER BY FPARENTID");
                    verifyTaskDescriptionSql = verifyTaskDescriptionSB.toString();
                    rs = DbUtil.executeQuery((Context)ctx, (String)verifyTaskDescriptionSql);
                    while (rs != null && rs.next()) {
                        batchResults.addError(rs.getString("FPARENTID"), (Exception)((Object)new CheckingPlanningException(CheckingPlanningException.DESCRIPTIONISNULL)));
                        toDoIdsList.remove(rs.getString("FPARENTID"));
                    }
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            for (int i = 0; i < toDoIdsList.size(); ++i) {
                successedIdsList.add(new Object[]{toDoIdsList.get(i)});
            }
            String sql = " UPDATE T_EQM_CHECKPLANNING SET FBillStatus = 45 WHERE FID = ? ";
            GeneDbUtil.executeBatchWithOutTimeOut((Context)ctx, (String)sql, successedIdsList);
            long releaseEnd = System.currentTimeMillis();
            double releaseTime = (double)(releaseEnd - releaseStart) / 1000.0;
            System.out.println("CheckPlanning_Release_Time = " + releaseTime + "s");
        }
        return batchResults;
    }
}

