/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.planning.app;

import com.kingdee.bos.ContextUtils;
import com.kingdee.eas.eqm.common.core.util.GeneDateUtils;
import com.kingdee.eas.util.ResourceBase;
import java.text.ParseException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;

public class DateUtils {
    public static boolean before(Date d1, Date d2) {
        DateUtils.validArgs(d1, d2);
        try {
            return GeneDateUtils.compareByDate((Date)d1, (Date)d2) == -1;
        }
        catch (ParseException e) {
            throw new RuntimeException("Date compare error from GeneDateUtils.compareByDate():" + e.getMessage());
        }
    }

    public static boolean beforeOrSame(Date d1, Date d2) {
        DateUtils.validArgs(d1, d2);
        try {
            return GeneDateUtils.compareByDate((Date)d1, (Date)d2) <= 0;
        }
        catch (ParseException e) {
            throw new RuntimeException("Date compare error from GeneDateUtils.compareByDate():" + e.getMessage());
        }
    }

    public static boolean after(Date d1, Date d2) {
        DateUtils.validArgs(d1, d2);
        try {
            return GeneDateUtils.compareByDate((Date)d1, (Date)d2) == 1;
        }
        catch (ParseException e) {
            throw new RuntimeException("Date compare error from GeneDateUtils.compareByDate():" + e.getMessage());
        }
    }

    public static boolean afterOrSame(Date d1, Date d2) {
        DateUtils.validArgs(d1, d2);
        try {
            return GeneDateUtils.compareByDate((Date)d1, (Date)d2) >= 0;
        }
        catch (ParseException e) {
            throw new RuntimeException("Date compare error from GeneDateUtils.compareByDate():" + e.getMessage());
        }
    }

    public static int getDiffDays(Date d1, Date d2) {
        DateUtils.validArgs(d1, d2);
        Date date1 = DateUtils.trimTime(d1);
        Date date2 = DateUtils.trimTime(d2);
        long diff = date1.getTime() - date2.getTime();
        int days = new Long(diff /= 86400000L).intValue();
        return days;
    }

    public static Date trimTime(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("can't input a null date argument.");
        }
        GregorianCalendar c1 = new GregorianCalendar();
        c1.setTime(date);
        GregorianCalendar c2 = new GregorianCalendar();
        c2.set(1, c1.get(1));
        c2.set(2, c1.get(2));
        c2.set(5, c1.get(5));
        c2.set(11, 0);
        c2.set(12, 0);
        c2.set(13, 0);
        c2.set(14, 0);
        return c2.getTime();
    }

    private static void validArgs(Date d1, Date d2) {
        if (d1 == null) {
            throw new IllegalArgumentException(ResourceBase.getString((String)"com.kingdee.eas.eqm.planning.PLANNINGAutoGenerateResource", (String)"0_DateUtils", (Locale)ContextUtils.getLocaleFromEnv()));
        }
        if (d2 == null) {
            throw new IllegalArgumentException(ResourceBase.getString((String)"com.kingdee.eas.eqm.planning.PLANNINGAutoGenerateResource", (String)"1_DateUtils", (Locale)ContextUtils.getLocaleFromEnv()));
        }
    }

    public static void main(String[] args) {
    }
}

