/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.planning.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.bp.BPOption;
import com.kingdee.bos.framework.bp.DynamicBackground;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.base.log.app.adapter.LogControllManager;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.eqm.basedata.EquipmentMeterApplyInfo;
import com.kingdee.eas.eqm.common.core.GeneDataBaseInfo;
import com.kingdee.eas.eqm.common.core.GeneUsableStatusEnum;
import com.kingdee.eas.eqm.common.core.IGeneBaseInfo;
import com.kingdee.eas.eqm.common.core.app.verify.NameDuplicateVerifyItem;
import com.kingdee.eas.eqm.common.core.verify.IVerifyItem;
import com.kingdee.eas.eqm.common.core.verify.IVerifyManager;
import com.kingdee.eas.eqm.common.core.verify.VerifyManager;
import com.kingdee.eas.eqm.planning.EQMPlanningException;
import com.kingdee.eas.eqm.planning.PreMaintainStrategyCollection;
import com.kingdee.eas.eqm.planning.PreMaintainStrategyFactory;
import com.kingdee.eas.eqm.planning.PreMaintainStrategyInfo;
import com.kingdee.eas.eqm.planning.RunningModeEnum;
import com.kingdee.eas.eqm.planning.StrategyGenerateWOFacadeFactory;
import com.kingdee.eas.eqm.planning.StrategyStructureEntryCollection;
import com.kingdee.eas.eqm.planning.StrategyStructureEntryInfo;
import com.kingdee.eas.eqm.planning.app.AbstractPreMaintainStrategyControllerBean;
import com.kingdee.eas.eqm.planning.app.verify.DAGValidator;
import com.kingdee.eas.eqm.planning.app.verify.OpenedStatusDeleteVerifyItem;
import com.kingdee.eas.eqm.planning.app.verify.StrategyAuditVerifyItem;
import com.kingdee.eas.eqm.planning.app.verify.StrategyClosedVerifyItem;
import com.kingdee.eas.eqm.planning.app.verify.StrategyOpenedVerifyItem;
import com.kingdee.eas.eqm.planning.app.verify.StrategyUnAuditVerifyItem;
import com.kingdee.eas.eqm.planning.app.verify.StrategyUsingVerifyItem;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class PreMaintainStrategyControllerBean
extends AbstractPreMaintainStrategyControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.eqm.planning.app.PreMaintainStrategyControllerBean");

    protected List _strategyStructureCheck(Context ctx, OrgUnitInfo planOrgUnit) throws BOSException, EQMPlanningException {
        DAGValidator validator = new DAGValidator();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemInfo item = new FilterItemInfo("storageOrgUnit.id", (Object)planOrgUnit.getId());
        filter.getFilterItems().add(item);
        PreMaintainStrategyCollection strategies = PreMaintainStrategyFactory.getLocalInstance(ctx).getPreMaintainStrategyCollection(view);
        if (strategies.size() == 0) {
            throw new EQMPlanningException(EQMPlanningException.NOSTATEGYTOVALID);
        }
        for (int i = 0; i < strategies.size(); ++i) {
            this.addDAGNode(validator, strategies.get(i), i);
        }
        return validator.validate();
    }

    private void addDAGNode(DAGValidator validator, PreMaintainStrategyInfo strategyInfo, int i) {
        validator.addNode(strategyInfo.getId().toString(), strategyInfo.getName());
        StrategyStructureEntryCollection structures = strategyInfo.getStructureEntry();
        for (int j = 0; j < structures.size(); ++j) {
            StrategyStructureEntryInfo structureInfo = structures.get(j);
            validator.addArc(strategyInfo.getId().toString(), structureInfo.getMaintainStrategy().getId().toString());
        }
    }

    @Override
    protected boolean _checkCanModifyLevelToUp(Context ctx, String strategyID) throws BOSException {
        String sql_query = "select fid from T_EQM_StrategyStructureEntry where FMaintainStrategyID = '" + strategyID + "'";
        IRowSet reqRow = DbUtil.executeQuery((Context)ctx, (String)sql_query);
        try {
            String id;
            if (reqRow.next() && (id = reqRow.getString(1)) != null && id.trim().length() > 0) {
                return false;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return true;
    }

    protected IVerifyManager getAddnewVerifyManager(Context ctx, GeneDataBaseInfo info) {
        IVerifyManager verifymanager = super.getAddnewVerifyManager(ctx, info);
        NameDuplicateVerifyItem verifyItem = new NameDuplicateVerifyItem(ctx, (IGeneBaseInfo)info, "storageOrgUnit", null);
        verifymanager.addVerifyItem((IVerifyItem)verifyItem);
        return verifymanager;
    }

    protected IVerifyManager getDeleteVerifyManager(Context ctx, GeneDataBaseInfo info) {
        IVerifyManager verifymanager = super.getDeleteVerifyManager(ctx, info);
        verifymanager.addVerifyItem((IVerifyItem)new OpenedStatusDeleteVerifyItem((PreMaintainStrategyInfo)info));
        StrategyUsingVerifyItem verifyItem = new StrategyUsingVerifyItem(ctx, (PreMaintainStrategyInfo)info);
        verifymanager.addVerifyItem((IVerifyItem)verifyItem);
        return verifymanager;
    }

    protected IVerifyManager getUpdateVerifyManager(Context ctx, GeneDataBaseInfo info) {
        IVerifyManager verifymanager = super.getUpdateVerifyManager(ctx, info);
        NameDuplicateVerifyItem verifyItem = new NameDuplicateVerifyItem(ctx, (IGeneBaseInfo)info, "storageOrgUnit", null);
        verifymanager.addVerifyItem((IVerifyItem)verifyItem);
        return verifymanager;
    }

    protected void beforeDelete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        String sql = "delete from T_EQM_PreMaintainOperationLog where FPreMaintainStrate='" + pk.toString() + "'";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        super._delete(ctx, pk);
    }

    @Override
    protected void _unUse(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.lockData(ctx, pk.toString());
        LogControllManager.getInstance().enableLog();
        PreMaintainStrategyInfo info = (PreMaintainStrategyInfo)this.getValue(ctx, pk);
        VerifyManager verifyManager = new VerifyManager();
        verifyManager.addVerifyItem((IVerifyItem)new StrategyClosedVerifyItem(info));
        verifyManager.verify();
        String sql = "update " + this.getTableName(ctx) + " set FOpenedStatus=? where fid =?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(3), pk.toString()});
    }

    @Override
    protected void _use(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.lockData(ctx, pk.toString());
        LogControllManager.getInstance().enableLog();
        PreMaintainStrategyInfo info = (PreMaintainStrategyInfo)this.getValue(ctx, pk);
        VerifyManager verifyManager = new VerifyManager();
        verifyManager.addVerifyItem((IVerifyItem)new StrategyOpenedVerifyItem(info));
        verifyManager.verify();
        String sql = "update " + this.getTableName(ctx) + " set FOpenedStatus=? where fid =?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(2), pk.toString()});
    }

    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.lockData(ctx, pk.toString());
        PreMaintainStrategyInfo info = (PreMaintainStrategyInfo)this.getValue(ctx, pk);
        VerifyManager verifyManager = new VerifyManager();
        verifyManager.addVerifyItem((IVerifyItem)new StrategyAuditVerifyItem(info));
        verifyManager.verify();
        String sql = "update " + this.getTableName(ctx) + " set FOpenedStatus=? where fid =?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(2), pk.toString()});
    }

    protected void _unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.lockData(ctx, pk.toString());
        PreMaintainStrategyInfo info = (PreMaintainStrategyInfo)this.getValue(ctx, pk);
        VerifyManager verifyManager = new VerifyManager();
        verifyManager.addVerifyItem((IVerifyItem)new StrategyUnAuditVerifyItem(info));
        verifyManager.verify();
        String sql = "update " + this.getTableName(ctx) + " set FOpenedStatus=? where fid =?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(1), pk.toString()});
    }

    public IObjectPK submit(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        Connection conn = null;
        Statement batchStatement = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            batchStatement = conn.createStatement();
            Map a = (Map)model.get("meterReading");
            for (String meterID : a.keySet()) {
                EquipmentMeterApplyInfo info = (EquipmentMeterApplyInfo)a.get(meterID);
                BigDecimal reading = info.getDayAverageValue();
                String fid = info.getId().toString();
                String sql_updateReading = "update T_EQM_EquipmentMeterApply set fDayAverageValue = " + reading + " where fid = '" + fid + "'";
                batchStatement.addBatch(sql_updateReading);
            }
            StrategyStructureEntryCollection sseColl = ((PreMaintainStrategyInfo)model).getStructureEntry();
            for (int i = 0; i < sseColl.size(); ++i) {
                StrategyStructureEntryInfo sseInfo = sseColl.get(i);
                PreMaintainStrategyInfo pmsInfo = sseInfo.getMaintainStrategy();
                String sql_uptStrategy = "update t_eqm_PreMaintainStrategy set FIfDefinedStructure = 1 where fid = '" + pmsInfo.getId().toString() + "'";
                batchStatement.addBatch(sql_uptStrategy);
            }
            batchStatement.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(batchStatement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)batchStatement, (Connection)conn);
        return super.submit(ctx, model);
    }

    @Override
    protected String _generateWorkOrder(Context ctx, IObjectValue strategy, Date startDate, Date endDate, Date planWODate, RunningModeEnum runningMode, boolean valid) throws BOSException, EASBizException {
        String result = "";
        if (((PreMaintainStrategyInfo)strategy).getOpenedStatus() != GeneUsableStatusEnum.USABLE) {
            throw new EQMPlanningException(EQMPlanningException.STRATEGYNOTAUDIT);
        }
        if (RunningModeEnum.FOREGROUND.equals((Object)runningMode)) {
            result = this.runGenerateWorkOrder(ctx, (PreMaintainStrategyInfo)strategy, startDate, endDate, planWODate, runningMode, Boolean.valueOf(valid).toString());
        } else {
            BPOption bpOption = new BPOption();
            bpOption.setImmediately(true);
            DynamicBackground bd = new DynamicBackground(ctx);
            bd.invokeBackound(this.getBOSType(), "runGenerateWorkOrder", new Class[]{PreMaintainStrategyInfo.class, Date.class, Date.class, Date.class, RunningModeEnum.class, String.class}, new Object[]{strategy, startDate, endDate, planWODate, runningMode, Boolean.valueOf(valid).toString()}, bpOption);
        }
        return result;
    }

    @Override
    protected String _runGenerateWorkOrder(Context ctx, IObjectValue strategy, Date startDate, Date endDate, Date planWODate, RunningModeEnum runningMode, String strValid) throws BOSException, EASBizException {
        String proNumber = null;
        boolean valid = Boolean.valueOf(strValid);
        Timestamp runBegin = new Timestamp(System.currentTimeMillis());
        proNumber = valid ? StrategyGenerateWOFacadeFactory.getLocalInstance(ctx).GenerateWOFromStrategy(strategy, startDate, endDate, runningMode) : StrategyGenerateWOFacadeFactory.getLocalInstance(ctx).GenerateWOFromStrategyByDate(strategy, planWODate, runningMode);
        this.updateStrategyRunInfo(ctx, (PreMaintainStrategyInfo)strategy, runBegin, proNumber);
        return proNumber;
    }

    private void updateStrategyRunInfo(Context ctx, PreMaintainStrategyInfo info, Timestamp runBegin, String pronumber) throws BOSException, EASBizException {
        String sql = "select distinct count(*) from T_EQM_PreMaintainOperationLog  t right join T_EQM_WorkOrder w on t.FWorkOrderId=w.FId where  Fprocesssequence=?";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{pronumber});
        int genWOCount = 0;
        if (rowSet != null && rowSet.size() > 0) {
            try {
                rowSet.next();
                genWOCount = rowSet.getInt(1);
            }
            catch (SQLException e) {
                logger.error((Object)"count strategy generated workorder occurs error.");
            }
        }
        if (genWOCount > 0) {
            info.setLastGenWOCount(genWOCount);
            info.setLastRunTime(runBegin);
            info.setTotalRunTimes(info.getTotalRunTimes() + 1);
        }
        PreMaintainStrategyFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(info.getId()), (CoreBaseInfo)info);
    }

    @Override
    protected void _validStructure(Context ctx, IObjectValue planOrgUnit) throws BOSException, EASBizException {
        List result = this._strategyStructureCheck(ctx, (OrgUnitInfo)planOrgUnit);
        if (result == null || result.size() == 0) {
            return;
        }
        StringBuffer msg = new StringBuffer();
        for (DAGValidator.Node node : result) {
            if (msg.length() > 0) {
                msg.append("->");
            }
            msg.append(node.getName());
        }
        msg.append("->").append(((DAGValidator.Node)result.get(0)).getName());
        throw new EQMPlanningException(EQMPlanningException.STRATEGYSTRUCTUREINVALID, new String[]{msg.toString()});
    }
}

