/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.planning.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.app.adapter.LogControllManager;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexLockType;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.eqm.archives.EquipmentArchivesFactory;
import com.kingdee.eas.eqm.archives.EquipmentArchivesInfo;
import com.kingdee.eas.eqm.basedata.EquipmentLocationInfo;
import com.kingdee.eas.eqm.basedata.EquipmentMaintainRouteInfo;
import com.kingdee.eas.eqm.basedata.EquipmentMaintainSiteCollection;
import com.kingdee.eas.eqm.basedata.EquipmentMaintainSiteInfo;
import com.kingdee.eas.eqm.basedata.EquipmentMeterApplyCollection;
import com.kingdee.eas.eqm.basedata.EquipmentMeterApplyFactory;
import com.kingdee.eas.eqm.basedata.EquipmentStandardOperationFactory;
import com.kingdee.eas.eqm.basedata.EquipmentStandardOperationInfo;
import com.kingdee.eas.eqm.common.core.GeneUsableStatusEnum;
import com.kingdee.eas.eqm.common.core.util.GeneEqualsUtils;
import com.kingdee.eas.eqm.common.core.util.GeneSelectorUtils;
import com.kingdee.eas.eqm.common.core.verify.IVerifyItem;
import com.kingdee.eas.eqm.common.core.verify.VerifyManager;
import com.kingdee.eas.eqm.maintain.WorkOrderSrcTypeEnum;
import com.kingdee.eas.eqm.planning.BaseDateFrequencyEntryCollection;
import com.kingdee.eas.eqm.planning.BaseMeterFrequencyEntryCollection;
import com.kingdee.eas.eqm.planning.BaseMeterFrequencyEntryInfo;
import com.kingdee.eas.eqm.planning.EQMCalendarTypeEnum;
import com.kingdee.eas.eqm.planning.EQMFireModeEnum;
import com.kingdee.eas.eqm.planning.EQMPlanningException;
import com.kingdee.eas.eqm.planning.EQMSWFireRuleEnum;
import com.kingdee.eas.eqm.planning.EQMSequencyFireRuleEnum;
import com.kingdee.eas.eqm.planning.EQMStrategyLevelEnum;
import com.kingdee.eas.eqm.planning.EquipmentMaintainSchemaAssetCollection;
import com.kingdee.eas.eqm.planning.EquipmentMaintainSchemaAssetInfo;
import com.kingdee.eas.eqm.planning.EquipmentMaintainSchemaFactory;
import com.kingdee.eas.eqm.planning.EquipmentMaintainSchemaInfo;
import com.kingdee.eas.eqm.planning.IRestrainHandleFacade;
import com.kingdee.eas.eqm.planning.IStrategyDateHandleFacade;
import com.kingdee.eas.eqm.planning.PreMaintainStrategyFactory;
import com.kingdee.eas.eqm.planning.PreMaintainStrategyInfo;
import com.kingdee.eas.eqm.planning.PreMaintainStrategySeqItemCollection;
import com.kingdee.eas.eqm.planning.PreMaintainStrategySeqItemInfo;
import com.kingdee.eas.eqm.planning.RestrainHandleFacadeFactory;
import com.kingdee.eas.eqm.planning.RunningModeEnum;
import com.kingdee.eas.eqm.planning.StrategyDateHandleFacadeFactory;
import com.kingdee.eas.eqm.planning.StrategyStructureEntryCollection;
import com.kingdee.eas.eqm.planning.TiggerModeEnum;
import com.kingdee.eas.eqm.planning.WorkOrderHandleFacadeFactory;
import com.kingdee.eas.eqm.planning.app.AbstractStrategyGenerateWOFacadeControllerBean;
import com.kingdee.eas.eqm.planning.app.DateUtils;
import com.kingdee.eas.eqm.planning.app.verify.StrategyRunVerifyItem;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.mm.basedata.FactoryCalendarFactory;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.Uuid;
import edu.emory.mathcs.backport.java.util.Collections;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class StrategyGenerateWOFacadeControllerBean
extends AbstractStrategyGenerateWOFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static int FIRSTORDERNUM = 10;
    private static int INCREASEOFORDERNUM = 10;
    private static final Format longDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss SSSSS");
    private static final Format dateFormat = BOSLocaleUtil.getDateFormat();
    private static final String EQM_PM_MUTEXLOCK = "EQM_PM_MUTEXLOCK";
    private static final long MILLISECONDS_PER_DAY = 86400000L;
    private String[] parentID;
    private String[] superParentID;
    private PreMaintainStrategyInfo topmsInfo;
    boolean baseMeter = false;

    public String[] getParentID() {
        return this.parentID;
    }

    public void setParentID(String[] parentID) {
        this.parentID = parentID;
    }

    public String[] getSuperParentID() {
        return this.superParentID;
    }

    public void setSuperParentID(String[] superParentID) {
        this.superParentID = superParentID;
    }

    public PreMaintainStrategyInfo getTopmsInfo() {
        return this.topmsInfo;
    }

    public void setTopmsInfo(PreMaintainStrategyInfo topmsInfo) {
        this.topmsInfo = topmsInfo;
    }

    public static MutexParameter setMutexParameter(Uuid mutexUuid, String orgUnitID) {
        MutexParameter mutexParam = new MutexParameter();
        mutexParam.setRequestId(mutexUuid);
        mutexParam.setOrgUnitID(BOSUuid.read((String)orgUnitID));
        mutexParam.setMutexLockType(MutexLockType.EXCLUSIVE_LOCK);
        mutexParam.setMutexName(EQM_PM_MUTEXLOCK);
        return mutexParam;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String _GenerateWOFromStrategy(Context ctx, IObjectValue preMaintainStrategyInfo, Date startDate, Date endDate, RunningModeEnum runMode) throws BOSException, EASBizException {
        PreMaintainStrategyInfo info = (PreMaintainStrategyInfo)preMaintainStrategyInfo;
        String pronumber = null;
        Uuid mutexUuid = null;
        try {
            mutexUuid = Uuid.create();
            IMutexServiceControl mutexService = MutexServiceControlFactory.getLocalInstance((Context)ctx);
            boolean requestFlag = mutexService.requestMutex(StrategyGenerateWOFacadeControllerBean.setMutexParameter(mutexUuid, info.getStorageOrgUnit().getId().toString()));
            if (!requestFlag) {
                throw new EQMPlanningException(EQMPlanningException.LOCKREQUESTFAILURE);
            }
            this.checkMeterInit(ctx, info);
            VerifyManager verifyManager = new VerifyManager();
            verifyManager.addVerifyItem((IVerifyItem)new StrategyRunVerifyItem(ctx, info, true));
            if (!verifyManager.verify()) {
                String string = null;
                return string;
            }
            String tmpTableName = WorkOrderHandleFacadeFactory.getLocalInstance(ctx).generateTmpWOTable();
            String tmpLogTableName = WorkOrderHandleFacadeFactory.getLocalInstance(ctx).generateTmpLogTable();
            Timestamp runBegin = new Timestamp(System.currentTimeMillis());
            pronumber = longDateFormat.format(runBegin);
            this.innerGenerateWOFromStrategy(ctx, pronumber, 1, 1, null, (IObjectValue)info, startDate, endDate, runBegin, tmpTableName, tmpLogTableName, TiggerModeEnum.MANUAL, runMode);
            this.releaseTempTable(ctx, tmpTableName);
            this.releaseTempTable(ctx, tmpLogTableName);
        }
        finally {
            if (mutexUuid != null) {
                IMutexServiceControl mutexService = MutexServiceControlFactory.getLocalInstance((Context)ctx);
                mutexService.releaseMutex(mutexUuid);
            }
        }
        return pronumber;
    }

    private void innerGenerateWOFromStrategy(Context ctx, String proNumber, int assetCount, int seq, EquipmentMaintainSchemaInfo schemaInfo, IObjectValue preMaintainStrategyInfo, Date startDate, Date endDate, Timestamp runBegin, String tmpWOtableName, String tmpLogTableName, TiggerModeEnum fireMode, RunningModeEnum runMode) throws BOSException, EASBizException {
        PreMaintainStrategyInfo info = (PreMaintainStrategyInfo)preMaintainStrategyInfo;
        EQMSWFireRuleEnum fireRule = info.getStandWorkFireRule();
        switch (fireRule.getValue()) {
            case 10: {
                EquipmentStandardOperationInfo soInfo = info.getMainStdOper();
                this.mainSWFireHandle(ctx, proNumber, assetCount, seq, schemaInfo, soInfo, info, startDate, endDate, runBegin, tmpWOtableName, tmpLogTableName, fireMode, runMode);
                break;
            }
            case 20: {
                this.swFrequenceFireHandle(ctx, proNumber, assetCount, seq, schemaInfo, info, startDate, endDate, runBegin, tmpWOtableName, tmpLogTableName, fireMode, runMode);
            }
        }
        WorkOrderHandleFacadeFactory.getLocalInstance(ctx).insertTempDataToWO(info.getStorageOrgUnit().getId().toString(), tmpWOtableName, tmpLogTableName);
    }

    private void checkMeterInit(Context ctx, PreMaintainStrategyInfo strategy) throws BOSException, EASBizException {
        PreMaintainStrategySeqItemCollection soList = strategy.getSoSeqEntry();
        if (soList.size() == 0) {
            return;
        }
        boolean baseFrequency = false;
        for (int i = 0; i < soList.size(); ++i) {
            PreMaintainStrategySeqItemInfo so = soList.get(i);
            if (so.getFireMode() != EQMFireModeEnum.BASEFREQUENCY) continue;
            baseFrequency = true;
            break;
        }
        if (!baseFrequency) {
            return;
        }
        HashSet<String> meterIdSet = new HashSet<String>();
        BaseMeterFrequencyEntryCollection meterList = strategy.getMeterSeqEntry();
        if (meterList.size() == 0) {
            return;
        }
        for (int i = 0; i < meterList.size(); ++i) {
            BaseMeterFrequencyEntryInfo meter = meterList.get(i);
            meterIdSet.add(meter.getMeter().getId().toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemInfo item = new FilterItemInfo("currentValue", null);
        filter.getFilterItems().add(item);
        item = new FilterItemInfo("meter.id", meterIdSet, CompareType.INCLUDE);
        filter.getFilterItems().add(item);
        if (strategy.getArchives() != null) {
            item = new FilterItemInfo("equipment.id", (Object)strategy.getArchives().getId());
            filter.getFilterItems().add(item);
        } else {
            item = new FilterItemInfo("location.id", (Object)strategy.getLocation().getId());
            filter.getFilterItems().add(item);
        }
        EquipmentMeterApplyCollection c = EquipmentMeterApplyFactory.getLocalInstance((Context)ctx).getEquipmentMeterApplyCollection(view);
        if (c.size() > 0) {
            throw new EQMPlanningException(EQMPlanningException.METERNOTINIT, new Object[]{strategy.getNumber()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String _GenerateWOFromSchema(Context ctx, IObjectValue maintainSchemaInfo, Date startDate, Date endDate, RunningModeEnum runMode) throws BOSException, EASBizException {
        IMutexServiceControl mutexService;
        EquipmentMaintainSchemaInfo schema = (EquipmentMaintainSchemaInfo)maintainSchemaInfo;
        String processNumber = null;
        Uuid mutexUuid = null;
        try {
            mutexUuid = Uuid.create();
            mutexService = MutexServiceControlFactory.getLocalInstance((Context)ctx);
            boolean requestFlag = mutexService.requestMutex(StrategyGenerateWOFacadeControllerBean.setMutexParameter(mutexUuid, schema.getStorageOrgUnit().getId().toString()));
            if (!requestFlag) {
                throw new EQMPlanningException(EQMPlanningException.LOCKREQUESTFAILURE);
            }
            processNumber = this.innerGenerateWOFromSchema(ctx, maintainSchemaInfo, startDate, endDate, TiggerModeEnum.MANUAL, runMode);
        }
        finally {
            if (mutexUuid != null) {
                mutexService = MutexServiceControlFactory.getLocalInstance((Context)ctx);
                mutexService.releaseMutex(mutexUuid);
            }
        }
        return processNumber;
    }

    private String innerGenerateWOFromSchema(Context ctx, IObjectValue maintainSchemaInfo, Date startDate, Date endDate, TiggerModeEnum fireMode, RunningModeEnum runMode) throws BOSException, EASBizException {
        String tmpTableName = WorkOrderHandleFacadeFactory.getLocalInstance(ctx).generateTmpWOTable();
        String tmpLogTableName = WorkOrderHandleFacadeFactory.getLocalInstance(ctx).generateTmpLogTable();
        Timestamp runBegin = new Timestamp(System.currentTimeMillis());
        String pronumber = longDateFormat.format(runBegin);
        EquipmentMaintainSchemaInfo sinfo = (EquipmentMaintainSchemaInfo)maintainSchemaInfo;
        EquipmentMaintainSchemaAssetCollection saColl = sinfo.getAssets();
        ArrayList<EquipmentArchivesInfo> acvLst = new ArrayList<EquipmentArchivesInfo>();
        ArrayList<EquipmentLocationInfo> locLst = new ArrayList<EquipmentLocationInfo>();
        HashSet<String> acvSet = new HashSet<String>();
        HashSet<String> locSet = new HashSet<String>();
        for (int i = 0; i < saColl.size(); ++i) {
            EquipmentMaintainSchemaAssetInfo saInfo = saColl.get(i);
            if (saInfo.getEquipmentArchives() != null) {
                acvLst.add(saInfo.getEquipmentArchives());
                acvSet.add(saInfo.getEquipmentArchives().getId().toString());
                continue;
            }
            if (saInfo.getEquipmentLocation() == null) continue;
            locLst.add(saInfo.getEquipmentLocation());
            locSet.add(saInfo.getEquipmentLocation().getId().toString());
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection selectors = this.getInnerSelectors();
        GeneSelectorUtils.addSelectorWithIDAndNumberAndName((SelectorItemCollection)selectors, (String)"parent");
        GeneSelectorUtils.addSelectorWithPros((SelectorItemCollection)selectors, (String)"mainStdOper", (String[])new String[]{"id", "number", "name", "checkedStatus", "usableStatus"});
        GeneSelectorUtils.addSelectorWithPros((SelectorItemCollection)selectors, (String)"soSeqEntry.standardOperation", (String[])new String[]{"id", "number", "name", "checkedStatus", "usableStatus"});
        GeneSelectorUtils.addSelectorWithPros((SelectorItemCollection)selectors, (String)"storageOrgUnit.CU", (String[])new String[]{"id"});
        GeneSelectorUtils.addSelectorWithPros((SelectorItemCollection)selectors, (String)"maintainRoute", (String[])new String[]{"id", "number", "name", "usableStatus"});
        GeneSelectorUtils.addSelectorWithIDAndNumberAndName((SelectorItemCollection)selectors, (String)"maintainRoute.sites");
        GeneSelectorUtils.addSelectorWithIDAndNumberAndName((SelectorItemCollection)selectors, (String)"maintainRoute.sites.standardOperation");
        GeneSelectorUtils.addSelectorWithPros((SelectorItemCollection)selectors, (String)"maintainRoute.sites.standardOperation", (String[])new String[]{"usableStatus"});
        GeneSelectorUtils.addSelectorWithIDAndNumberAndName((SelectorItemCollection)selectors, (String)"maintainRoute.sites.equipmentArchives");
        GeneSelectorUtils.addSelectorWithIDAndNumberAndName((SelectorItemCollection)selectors, (String)"maintainRoute.sites.equipmentLocation");
        GeneSelectorUtils.addSelectorWithPros((SelectorItemCollection)selectors, (String)"archives", (String[])new String[]{"level"});
        GeneSelectorUtils.addSelectorWithPros((SelectorItemCollection)selectors, (String)"location", (String[])new String[]{"level"});
        GeneSelectorUtils.addSelectorWithPros((SelectorItemCollection)selectors, (String)"meterSeqEntry.meter", (String[])new String[]{"countType"});
        viewInfo.setSelector(selectors);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("openedStatus", (Object)new Integer(2), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("ifRun", (Object)new Boolean(true), CompareType.EQUALS));
        if (acvSet.size() > 0 && locSet.size() > 0) {
            filterInfo.getFilterItems().add(new FilterItemInfo("archives.id", acvSet, CompareType.INCLUDE));
            filterInfo.getFilterItems().add(new FilterItemInfo("archives.id", null, CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("location.id", locSet, CompareType.INCLUDE));
            filterInfo.setMaskString("#0 and #1 and( #2 or( #3 and #4))");
        } else if (acvSet.size() > 0) {
            filterInfo.getFilterItems().add(new FilterItemInfo("archives.id", acvSet, CompareType.INCLUDE));
            filterInfo.setMaskString("#0 and #1 and #2 ");
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("archives.id", null, CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("location.id", locSet, CompareType.INCLUDE));
            filterInfo.setMaskString("#0 and #1 and  #2 and #3");
        }
        viewInfo.setFilter(filterInfo);
        CoreBaseCollection c = PreMaintainStrategyFactory.getLocalInstance(ctx).getCollection(viewInfo);
        HashMap acvMap = new HashMap();
        HashMap locMap = new HashMap();
        for (int i = 0; i < c.size(); ++i) {
            List<PreMaintainStrategyInfo> lst;
            PreMaintainStrategyInfo info = (PreMaintainStrategyInfo)c.get(i);
            this.checkMeterInit(ctx, info);
            EquipmentArchivesInfo archivesInfo = info.getArchives();
            EquipmentLocationInfo locationInfo = info.getLocation();
            if (archivesInfo != null) {
                if (acvMap.containsKey(archivesInfo.getId().toString())) {
                    lst = (List)acvMap.get(archivesInfo.getId().toString());
                    lst.add(info);
                    continue;
                }
                lst = new ArrayList<PreMaintainStrategyInfo>();
                lst.add(info);
                acvMap.put(archivesInfo.getId().toString(), lst);
                continue;
            }
            if (locMap.containsKey(locationInfo.getId().toString())) {
                lst = (List)locMap.get(locationInfo.getId().toString());
                lst.add(info);
                continue;
            }
            lst = new ArrayList();
            lst.add(info);
            locMap.put(locationInfo.getId().toString(), lst);
        }
        int locCount = locLst.size();
        int locseq = 1;
        while (locLst.size() > 0) {
            EquipmentLocationInfo locationInfo = null;
            for (int j = 0; j < locLst.size(); ++j) {
                boolean isMin = true;
                EquipmentLocationInfo eaInfo = (EquipmentLocationInfo)locLst.get(j);
                int level = eaInfo.getLevel();
                for (int k = 0; k < locLst.size(); ++k) {
                    if (level <= ((EquipmentLocationInfo)locLst.get(k)).getLevel()) continue;
                    isMin = false;
                    break;
                }
                if (!isMin) continue;
                locationInfo = eaInfo;
                break;
            }
            List execLst = this.getSortedListOfStrategy(ctx, (IObjectValue)locationInfo, locMap);
            for (int i = 0; i < execLst.size(); ++i) {
                PreMaintainStrategyInfo preMaintainStrategyInfo = (PreMaintainStrategyInfo)execLst.get(i);
                this.innerGenerateWOFromStrategy(ctx, pronumber, locCount, locseq, sinfo, (IObjectValue)preMaintainStrategyInfo, startDate, endDate, runBegin, tmpTableName, tmpLogTableName, fireMode, runMode);
                ++locseq;
                DbUtil.execute((Context)ctx, (String)("delete from " + tmpTableName));
                DbUtil.execute((Context)ctx, (String)("delete from " + tmpLogTableName));
            }
            locLst.remove(locationInfo);
        }
        int arcCount = acvLst.size();
        int arcSeq = 1;
        while (acvLst.size() > 0) {
            EquipmentArchivesInfo archivesInfo = null;
            for (int j = 0; j < acvLst.size(); ++j) {
                boolean isMin = true;
                EquipmentArchivesInfo eaInfo = (EquipmentArchivesInfo)acvLst.get(j);
                int level = eaInfo.getLevel();
                for (int k = 0; k < acvLst.size(); ++k) {
                    if (level <= ((EquipmentArchivesInfo)acvLst.get(k)).getLevel()) continue;
                    isMin = false;
                    break;
                }
                if (!isMin) continue;
                archivesInfo = eaInfo;
                break;
            }
            List execLst = this.getSortedListOfStrategy(ctx, (IObjectValue)archivesInfo, acvMap);
            for (int i = 0; i < execLst.size(); ++i) {
                PreMaintainStrategyInfo preMaintainStrategyInfo = (PreMaintainStrategyInfo)execLst.get(i);
                this.innerGenerateWOFromStrategy(ctx, pronumber, arcCount, arcSeq, sinfo, (IObjectValue)preMaintainStrategyInfo, startDate, endDate, runBegin, tmpTableName, tmpLogTableName, fireMode, runMode);
                ++arcSeq;
                DbUtil.execute((Context)ctx, (String)("delete from " + tmpTableName));
                DbUtil.execute((Context)ctx, (String)("delete from " + tmpLogTableName));
            }
            acvLst.remove(archivesInfo);
        }
        this.releaseTempTable(ctx, tmpTableName);
        this.releaseTempTable(ctx, tmpLogTableName);
        sinfo.setLastRunningDate(runBegin);
        LogControllManager.getInstance().disableLog();
        EquipmentMaintainSchemaFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(sinfo.getId()), (CoreBaseInfo)sinfo);
        return pronumber;
    }

    protected SelectorItemCollection getInnerSelectors() {
        try {
            return GeneSelectorUtils.getSelector((BOSObjectType)new BOSObjectType("2D3E0BB5"), (String)"", (boolean)true, (boolean)true, (boolean)false);
        }
        catch (Exception e) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            return sic;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String _GenerateWOFromStrategyByDate(Context ctx, IObjectValue preMaintainStrategyInfo, Date specifyDate, RunningModeEnum runMode) throws BOSException, EASBizException {
        IMutexServiceControl mutexService;
        PreMaintainStrategyInfo info = (PreMaintainStrategyInfo)preMaintainStrategyInfo;
        String pronumber = null;
        Uuid mutexUuid = null;
        try {
            mutexUuid = Uuid.create();
            mutexService = MutexServiceControlFactory.getLocalInstance((Context)ctx);
            boolean requestFlag = mutexService.requestMutex(StrategyGenerateWOFacadeControllerBean.setMutexParameter(mutexUuid, info.getStorageOrgUnit().getId().toString()));
            if (!requestFlag) {
                throw new EQMPlanningException(EQMPlanningException.LOCKREQUESTFAILURE);
            }
            VerifyManager verifyManager = new VerifyManager();
            verifyManager.addVerifyItem((IVerifyItem)new StrategyRunVerifyItem(ctx, info, true));
            verifyManager.verify();
            String tmpTableName = WorkOrderHandleFacadeFactory.getLocalInstance(ctx).generateTmpWOTable();
            String tmpLogTableName = WorkOrderHandleFacadeFactory.getLocalInstance(ctx).generateTmpLogTable();
            Timestamp runBegin = new Timestamp(System.currentTimeMillis());
            pronumber = longDateFormat.format(runBegin);
            EQMSWFireRuleEnum fireRule = info.getStandWorkFireRule();
            switch (fireRule.getValue()) {
                case 10: {
                    EquipmentStandardOperationInfo soInfo = info.getMainStdOper();
                    this.mainSWFireHandleOfSpcDate(ctx, pronumber, 1, 1, soInfo, info, specifyDate, runBegin, tmpTableName, tmpLogTableName, TiggerModeEnum.MANUAL, runMode);
                    break;
                }
                case 20: {
                    this.swFrequenceFireHandleOfSpcDate(ctx, pronumber, 1, 1, info, specifyDate, runBegin, tmpTableName, tmpLogTableName, TiggerModeEnum.MANUAL, runMode);
                }
            }
            WorkOrderHandleFacadeFactory.getLocalInstance(ctx).insertTempDataToWO(info.getStorageOrgUnit().getId().toString(), tmpTableName, tmpLogTableName);
            this.releaseTempTable(ctx, tmpTableName);
            this.releaseTempTable(ctx, tmpLogTableName);
        }
        finally {
            if (mutexUuid != null) {
                mutexService = MutexServiceControlFactory.getLocalInstance((Context)ctx);
                mutexService.releaseMutex(mutexUuid);
            }
        }
        return pronumber;
    }

    private List getSortedListOfStrategy(Context ctx, IObjectValue asset, Map assetMap) throws BOSException, EASBizException {
        String assetID = null;
        if (asset instanceof EquipmentArchivesInfo) {
            assetID = ((EquipmentArchivesInfo)asset).getId().toString();
        } else if (asset instanceof EquipmentLocationInfo) {
            assetID = ((EquipmentLocationInfo)asset).getId().toString();
        }
        ArrayList rtnList = new ArrayList();
        if (assetMap.containsKey(assetID)) {
            List strtgLst = (List)assetMap.get(assetID);
            HashMap mainMap = new HashMap();
            ArrayList<PreMaintainStrategyInfo> seqList = new ArrayList<PreMaintainStrategyInfo>();
            ArrayList<PreMaintainStrategyInfo> downList = new ArrayList<PreMaintainStrategyInfo>();
            for (int i = 0; i < strtgLst.size(); ++i) {
                PreMaintainStrategyInfo info = (PreMaintainStrategyInfo)strtgLst.get(i);
                EQMStrategyLevelEnum level = info.getStrategyLevel();
                EQMSWFireRuleEnum fireRule = info.getStandWorkFireRule();
                if (level == EQMStrategyLevelEnum.TOP) {
                    if (fireRule == EQMSWFireRuleEnum.MAINSW) {
                        List<PreMaintainStrategyInfo> lst;
                        EquipmentStandardOperationInfo soInfo = info.getMainStdOper();
                        if (mainMap.containsKey(soInfo)) {
                            lst = (List)mainMap.get(soInfo);
                            lst.add(info);
                            continue;
                        }
                        lst = new ArrayList();
                        lst.add(info);
                        mainMap.put(soInfo, lst);
                        continue;
                    }
                    seqList.add(info);
                    continue;
                }
                downList.add(info);
            }
            ArrayList mainList = new ArrayList();
            Iterator e = mainMap.keySet().iterator();
            while (e.hasNext()) {
                mainList.add(e.next());
            }
            List sortList = this.getRestrainHandle(ctx).sortStandardOperation(mainList, asset);
            for (int i = 0; i < sortList.size(); ++i) {
                if (!mainMap.containsKey(sortList.get(i))) continue;
                rtnList.addAll((List)mainMap.get(sortList.get(i)));
            }
            rtnList.addAll(downList);
            rtnList.addAll(seqList);
        }
        return rtnList;
    }

    private void mainSWFireHandle(Context ctx, String proNumber, int assetCount, int seq, EquipmentMaintainSchemaInfo schemaInfo, EquipmentStandardOperationInfo mainSOInfo, PreMaintainStrategyInfo msInfo, Date startDate, Date endDate, Timestamp runBegin, String tmpWOtableName, String tmpLogTableName, TiggerModeEnum fireMode, RunningModeEnum runMode) throws BOSException, EASBizException {
        PreMaintainStrategySeqItemInfo msoSeqInfo = this.findStrategySeqItemByStandardOperation(mainSOInfo, msInfo);
        if (msoSeqInfo == null) {
            throw new EQMPlanningException(EQMPlanningException.MAINSONOTEXIST);
        }
        Date woDate = null;
        if (msInfo.getStrategyLevel().equals((Object)EQMStrategyLevelEnum.DOWN) && msInfo.isIfRun() && (woDate = this.getDateHandle(ctx).getLastWODateForDownStrategy(startDate, endDate, msInfo)) != null) {
            startDate = woDate;
        }
        if (woDate == null) {
            woDate = this.getDateHandle(ctx).getLastWorkOrderDate((IObjectValue)msoSeqInfo.getStandardOperation(), this.getAssetId(msInfo), this.isLocation(msInfo), false, startDate);
        }
        if (woDate == null) {
            woDate = startDate;
        }
        if (DateUtils.after(woDate, endDate)) {
            return;
        }
        switch (msoSeqInfo.getFireMode().getValue()) {
            case 20: {
                this.mainSWFireBaseDateHandle(ctx, proNumber, assetCount, seq, schemaInfo, mainSOInfo, msInfo, endDate, runBegin, tmpWOtableName, tmpLogTableName, fireMode, runMode, msoSeqInfo, woDate);
                break;
            }
            case 10: {
                this.mainSWFireBaseFrequencyHandle(ctx, proNumber, assetCount, seq, schemaInfo, mainSOInfo, msInfo, startDate, endDate, runBegin, tmpWOtableName, tmpLogTableName, fireMode, runMode, msoSeqInfo, woDate);
            }
        }
    }

    private void mainSWFireBaseFrequencyHandle(Context ctx, String proNumber, int assetCount, int seq, EquipmentMaintainSchemaInfo schemaInfo, EquipmentStandardOperationInfo mainSOInfo, PreMaintainStrategyInfo msInfo, Date startDate, Date endDate, Timestamp runBegin, String tmpWOtableName, String tmpLogTableName, TiggerModeEnum fireMode, RunningModeEnum runMode, PreMaintainStrategySeqItemInfo msoSeqInfo, Date woDate) throws BOSException, EASBizException {
        switch (msInfo.getSequenceFireRule().getValue()) {
            case 10: {
                this.mainSWFireBaseEachFrequencyHandle(ctx, proNumber, assetCount, seq, schemaInfo, mainSOInfo, msInfo, startDate, endDate, runBegin, tmpWOtableName, tmpLogTableName, fireMode, runMode, msoSeqInfo, woDate);
                break;
            }
            case 20: {
                this.mainSWFireBaseAllFrequencyHandle(ctx, proNumber, assetCount, seq, schemaInfo, mainSOInfo, msInfo, startDate, endDate, runBegin, tmpWOtableName, tmpLogTableName, fireMode, runMode, msoSeqInfo, woDate);
            }
        }
    }

    private void mainSWFireBaseAllFrequencyHandle(Context ctx, String proNumber, int assetCount, int seq, EquipmentMaintainSchemaInfo schemaInfo, EquipmentStandardOperationInfo mainSOInfo, PreMaintainStrategyInfo msInfo, Date startDate, Date endDate, Timestamp runBegin, String tmpWOtableName, String tmpLogTableName, TiggerModeEnum fireMode, RunningModeEnum runMode, PreMaintainStrategySeqItemInfo msoSeqInfo, Date woDate) throws BOSException, EASBizException {
        List allLst = this.getDateListOfAllAtTerm(ctx, msInfo, msoSeqInfo, startDate, endDate, this.getAssetId(msInfo), this.isLocation(msInfo), false, tmpWOtableName);
        if (allLst == null) {
            return;
        }
        List distinctDate = this.getDistinctDate(allLst);
        if (distinctDate == null || distinctDate.size() < 1) {
            return;
        }
        int freq3 = 0;
        int range = 0;
        for (int i = 0; i < distinctDate.size(); ++i) {
            Date stWODate;
            Map distDate = (Map)distinctDate.get(i);
            if (distDate.get(stWODate = (Date)distDate.keySet().iterator().next()) instanceof Integer) {
                range = (Integer)distDate.get(stWODate);
            } else {
                Object[] obj = (Object[])distDate.get(stWODate);
                range = (Integer)obj[0];
            }
            Date fromDate = null;
            Date toDate = null;
            if (msInfo.getCalendarType() == EQMCalendarTypeEnum.GENERALCALENDAR) {
                fromDate = new Date(stWODate.getTime() - (long)range * 86400000L);
                toDate = new Date(stWODate.getTime() + (long)range * 86400000L);
            } else {
                fromDate = FactoryCalendarFactory.getLocalInstance((Context)ctx).findDateFromFCalendar(msInfo.getStorageOrgUnit().getId().toString(), stWODate, 2, range, 2);
                toDate = FactoryCalendarFactory.getLocalInstance((Context)ctx).findDateFromFCalendar(msInfo.getStorageOrgUnit().getId().toString(), stWODate, 1, range, 2);
            }
            if (this.getRestrainHandle(ctx).checkRestrain((IObjectValue)mainSOInfo, this.getAsset(msInfo), stWODate, fromDate, toDate, true, tmpWOtableName, msInfo.getCalendarType(), msInfo)) continue;
            HashMap<PreMaintainStrategySeqItemInfo, Map> map = new HashMap<PreMaintainStrategySeqItemInfo, Map>();
            map.put(msoSeqInfo, distDate);
            if (++freq3 == 1) {
                WorkOrderHandleFacadeFactory.getLocalInstance(ctx).deleteInvalidWO(proNumber, assetCount, seq, (IObjectValue)schemaInfo, (IObjectValue)msInfo, (IObjectValue)mainSOInfo, this.getAsset(msInfo), startDate, -1, 0, tmpWOtableName, true, tmpLogTableName, runBegin, fireMode, runMode);
            }
            this.generateWorkOrderByStrategy(ctx, proNumber, assetCount, seq, schemaInfo, msInfo, map, false, stWODate, null, tmpWOtableName, runBegin, tmpLogTableName, fireMode, runMode, FIRSTORDERNUM);
        }
    }

    private void mainSWFireBaseEachFrequencyHandle(Context ctx, String proNumber, int assetCount, int seq, EquipmentMaintainSchemaInfo schemaInfo, EquipmentStandardOperationInfo mainSOInfo, PreMaintainStrategyInfo msInfo, Date startDate, Date endDate, Timestamp runBegin, String tmpWOtableName, String tmpLogTableName, TiggerModeEnum fireMode, RunningModeEnum runMode, PreMaintainStrategySeqItemInfo msoSeqInfo, Date woDate) throws BOSException, EASBizException {
        List dateLst = this.getDateListOfEachAtTerm(ctx, msInfo, msoSeqInfo, startDate, endDate, this.getAssetId(msInfo), this.isLocation(msInfo), false, tmpWOtableName);
        if (dateLst == null) {
            return;
        }
        List distinctDate = this.getDistinctDate(dateLst);
        if (distinctDate == null || distinctDate.size() < 1) {
            return;
        }
        int freq2 = 0;
        int range = 0;
        for (int i = 0; i < distinctDate.size(); ++i) {
            Date stWODate;
            Map distDate = (Map)distinctDate.get(i);
            if (distDate.get(stWODate = (Date)distDate.keySet().iterator().next()) instanceof Integer) {
                range = (Integer)distDate.get(stWODate);
            } else {
                Object[] obj = (Object[])distDate.get(stWODate);
                range = (Integer)obj[0];
            }
            Date fromDate = null;
            Date toDate = null;
            if (msInfo.getCalendarType() == EQMCalendarTypeEnum.GENERALCALENDAR) {
                Calendar cp = Calendar.getInstance();
                cp.setTime(stWODate);
                cp.add(5, -range);
                fromDate = cp.getTime();
                cp.setTime(stWODate);
                cp.add(5, range);
                toDate = cp.getTime();
            } else {
                fromDate = FactoryCalendarFactory.getLocalInstance((Context)ctx).findDateFromFCalendar(msInfo.getStorageOrgUnit().getId().toString(), stWODate, 2, range, 2);
                toDate = FactoryCalendarFactory.getLocalInstance((Context)ctx).findDateFromFCalendar(msInfo.getStorageOrgUnit().getId().toString(), stWODate, 1, range, 2);
            }
            if (this.getRestrainHandle(ctx).checkRestrain((IObjectValue)mainSOInfo, this.getAsset(msInfo), stWODate, fromDate, toDate, true, tmpWOtableName, msInfo.getCalendarType(), msInfo)) continue;
            HashMap<PreMaintainStrategySeqItemInfo, Map> map = new HashMap<PreMaintainStrategySeqItemInfo, Map>();
            map.put(msoSeqInfo, distDate);
            if (++freq2 == 1) {
                WorkOrderHandleFacadeFactory.getLocalInstance(ctx).deleteInvalidWO(proNumber, assetCount, seq, (IObjectValue)schemaInfo, (IObjectValue)msInfo, (IObjectValue)mainSOInfo, this.getAsset(msInfo), startDate, -1, 0, tmpWOtableName, true, tmpLogTableName, runBegin, fireMode, runMode);
            }
            this.generateWorkOrderByStrategy(ctx, proNumber, assetCount, seq, schemaInfo, msInfo, map, false, stWODate, null, tmpWOtableName, runBegin, tmpLogTableName, fireMode, runMode, FIRSTORDERNUM);
        }
    }

    private void mainSWFireBaseDateHandle(Context ctx, String proNumber, int assetCount, int seq, EquipmentMaintainSchemaInfo schemaInfo, EquipmentStandardOperationInfo mainSOInfo, PreMaintainStrategyInfo msInfo, Date endDate, Timestamp runBegin, String tmpWOtableName, String tmpLogTableName, TiggerModeEnum fireMode, RunningModeEnum runMode, PreMaintainStrategySeqItemInfo msoSeqInfo, Date woDate) throws BOSException, EASBizException {
        List sdateLst = this.getDateHandle(ctx).getAllDateListFromSpeciDateEntry((IObjectValue)msInfo, woDate, endDate, msoSeqInfo.getFrequencyTimes(), (IObjectValue)msoSeqInfo.getStandardOperation(), true);
        for (int i = 0; i < sdateLst.size(); ++i) {
            Date[] getDates = (Date[])sdateLst.get(i);
            if (getDates[0] == null) continue;
            Date stWODate = getDates[0];
            Date fromDate = getDates[1];
            Date toDate = getDates[2];
            if (msInfo.getArchives() != null ? this.getRestrainHandle(ctx).checkRestrain((IObjectValue)mainSOInfo, (IObjectValue)msInfo.getArchives(), stWODate, fromDate, toDate, true, tmpWOtableName, msInfo.getCalendarType(), msInfo) : this.getRestrainHandle(ctx).checkRestrain((IObjectValue)mainSOInfo, (IObjectValue)msInfo.getLocation(), stWODate, fromDate, toDate, false, tmpWOtableName, msInfo.getCalendarType(), msInfo)) continue;
            ArrayList<PreMaintainStrategySeqItemInfo> seqLst = new ArrayList<PreMaintainStrategySeqItemInfo>();
            seqLst.add(msoSeqInfo);
            ArrayList<Date> dateList = new ArrayList<Date>();
            dateList.add(stWODate);
            ArrayList<Object[]> dateRange = new ArrayList<Object[]>();
            dateRange.add(new Object[]{fromDate, toDate});
            this.generateWorkOrderByStrategyOfSpcDate(ctx, proNumber, assetCount, seq, schemaInfo, msInfo, seqLst, false, dateList, null, tmpWOtableName, runBegin, tmpLogTableName, fireMode, runMode, FIRSTORDERNUM, dateRange);
        }
    }

    private boolean isLocation(PreMaintainStrategyInfo strategy) {
        return strategy.getArchives() == null && strategy.getLocation() != null;
    }

    private IObjectValue getAsset(PreMaintainStrategyInfo strategy) {
        EquipmentArchivesInfo result = null;
        if (strategy.getArchives() != null) {
            result = strategy.getArchives();
        } else if (strategy.getLocation() != null) {
            result = strategy.getLocation();
        }
        return result;
    }

    private PreMaintainStrategySeqItemInfo findStrategySeqItemByStandardOperation(EquipmentStandardOperationInfo mainSOInfo, PreMaintainStrategyInfo msInfo) {
        PreMaintainStrategySeqItemInfo msoSeqInfo = null;
        PreMaintainStrategySeqItemCollection seqColl = msInfo.getSoSeqEntry();
        for (int i = 0; i < seqColl.size(); ++i) {
            PreMaintainStrategySeqItemInfo seqInfo = seqColl.get(i);
            if (!mainSOInfo.getId().equals((Object)seqInfo.getStandardOperation().getId())) continue;
            msoSeqInfo = seqInfo;
            break;
        }
        return msoSeqInfo;
    }

    private String getAssetId(PreMaintainStrategyInfo msInfo) {
        return this.getAsset(msInfo).get("id").toString();
    }

    private void mainSWFireHandleOfSpcDate(Context ctx, String proNumber, int assetCount, int seq, EquipmentStandardOperationInfo soInfo, PreMaintainStrategyInfo msInfo, Date specifyDate, Timestamp runBegin, String tmpWOtableName, String tmpLogTableName, TiggerModeEnum fireMode, RunningModeEnum runMode) throws BOSException, EASBizException {
        PreMaintainStrategySeqItemInfo msoSeqInfo = this.findStrategySeqItemByStandardOperation(soInfo, msInfo);
        if (msoSeqInfo == null) {
            return;
        }
        ArrayList<PreMaintainStrategySeqItemInfo> seqLst = new ArrayList<PreMaintainStrategySeqItemInfo>();
        seqLst.add(msoSeqInfo);
        ArrayList<Date> dateList = new ArrayList<Date>();
        dateList.add(specifyDate);
        this.generateWorkOrderByStrategyOfSpcDate(ctx, proNumber, assetCount, seq, null, msInfo, seqLst, false, dateList, null, tmpWOtableName, runBegin, tmpLogTableName, fireMode, runMode, FIRSTORDERNUM);
    }

    private void generateWorkOrderByStrategy(Context ctx, String proNumber, int assetCount, int seq, EquipmentMaintainSchemaInfo schemaInfo, PreMaintainStrategyInfo strtgInfo, Map soAndDateMap, boolean isFromParent, Date planDate, String parentWorkOrderID, String tmpWOtableName, Timestamp runBegin, String tmpLogtableName, TiggerModeEnum fireMode, RunningModeEnum runMode, int secondWONum) throws BOSException, EASBizException {
        List routeSite;
        EquipmentMaintainRouteInfo mrInfo;
        int j;
        EquipmentStandardOperationInfo soInfo;
        String woID = parentWorkOrderID;
        Date startDate4Seq = null;
        Date endDate4Seq = null;
        String[] woIDs = null;
        String archivesID = null;
        String locationID = null;
        if (strtgInfo.getArchives() != null) {
            archivesID = strtgInfo.getArchives().getId().toString();
            EquipmentArchivesInfo archivesInfo = strtgInfo.getArchives();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("location.id"));
            sic.add(new SelectorItemInfo("location.number"));
            sic.add(new SelectorItemInfo("location.name"));
            archivesInfo = EquipmentArchivesFactory.getLocalInstance((Context)ctx).getEquipmentArchivesInfo((IObjectPK)new ObjectUuidPK(archivesInfo.getId().toString()), sic);
            if (archivesInfo != null && archivesInfo.getLocation() != null) {
                locationID = archivesInfo.getLocation().getId().toString();
            }
        } else if (strtgInfo.getLocation() != null) {
            locationID = strtgInfo.getLocation().getId().toString();
        }
        boolean ifSeqNotIncludeMainSO = false;
        if (!isFromParent && strtgInfo.getStandWorkFireRule() == EQMSWFireRuleEnum.MAINSW && (soInfo = strtgInfo.getMainStdOper()) != null) {
            if (soInfo.getUsableStatus() != GeneUsableStatusEnum.USABLE) {
                return;
            }
            PreMaintainStrategySeqItemInfo msoSeqInfo = (PreMaintainStrategySeqItemInfo)soAndDateMap.keySet().iterator().next();
            Map dateMap = (Map)soAndDateMap.get(msoSeqInfo);
            woIDs = WorkOrderHandleFacadeFactory.getLocalInstance(ctx).generateTmpWOFromSO(proNumber, assetCount, seq, (IObjectValue)schemaInfo, strtgInfo, strtgInfo, soInfo.getName(), 0, archivesID, locationID, msoSeqInfo.getMaintainOrgUnit().getId().toString(), dateMap, null, (IObjectValue)soInfo, null, null, null, tmpWOtableName, this.getWorkOrderSrcTypeEnum(schemaInfo), true, true, tmpLogtableName, runBegin, fireMode, runMode, null);
            if (woIDs == null || woIDs.length < 1 || woIDs[0] == null) {
                return;
            }
            this.setSuperParentID(woIDs);
            this.setParentID(woIDs);
            this.setTopmsInfo(strtgInfo);
            isFromParent = true;
            ifSeqNotIncludeMainSO = true;
        }
        if (isFromParent) {
            int i;
            boolean hasVirtual = false;
            if (soAndDateMap == null && strtgInfo.getSoSeqEntry().size() > 0 || strtgInfo.getSoSeqEntry() == null || strtgInfo.getSoSeqEntry().size() == 0) {
                HashMap<Date, Integer> pDateMap = new HashMap<Date, Integer>();
                pDateMap.put(planDate, new Integer(0));
                String[] ids = null;
                if (this.getSuperParentID() != null && this.getSuperParentID().length > 0) {
                    woIDs = new String[this.getSuperParentID().length];
                    for (i = 0; i < this.getSuperParentID().length; ++i) {
                        ids = WorkOrderHandleFacadeFactory.getLocalInstance(ctx).generateTmpWOFromSO(proNumber, assetCount, seq, (IObjectValue)schemaInfo, this.getTopmsInfo(), strtgInfo, strtgInfo.getName(), secondWONum, archivesID, locationID, strtgInfo.getMaintainOrgUnit().getId().toString(), pDateMap, null, null, parentWorkOrderID, this.getSuperParentID()[i], null, tmpWOtableName, this.getWorkOrderSrcTypeEnum(schemaInfo), false, false, tmpLogtableName, runBegin, fireMode, runMode, null);
                        woIDs[i] = ids[0];
                    }
                    secondWONum += INCREASEOFORDERNUM;
                    hasVirtual = true;
                }
            }
            PreMaintainStrategySeqItemCollection ssc = strtgInfo.getSoSeqEntry();
            int downWONum = FIRSTORDERNUM;
            for (i = 0; i < ssc.size(); ++i) {
                Map<Date, Integer> dateMap;
                PreMaintainStrategySeqItemInfo ssi = ssc.get(i);
                EquipmentStandardOperationInfo soi = ssi.getStandardOperation();
                if (soi.getUsableStatus() != GeneUsableStatusEnum.USABLE || ifSeqNotIncludeMainSO && soi.getId().toString().equals(strtgInfo.getMainStdOper().getId().toString())) continue;
                if (soAndDateMap == null) {
                    dateMap = new HashMap<Date, Integer>();
                    dateMap.put(planDate, new Integer(0));
                } else {
                    dateMap = (Map)soAndDateMap.get(ssi);
                }
                String moID = null;
                if (ssi.getMaintainOrgUnit() != null) {
                    moID = ssi.getMaintainOrgUnit().getId().toString();
                }
                if (woIDs == null || woIDs.length <= 0) continue;
                for (int j2 = 0; j2 < woIDs.length; ++j2) {
                    String superParentID = this.getSuperParentID() == null || this.getSuperParentID().length < 1 ? null : this.getSuperParentID()[j2];
                    WorkOrderHandleFacadeFactory.getLocalInstance(ctx).generateTmpWOFromSOOfSpcDate(proNumber, assetCount, seq, (IObjectValue)schemaInfo, (IObjectValue)this.getTopmsInfo(), (IObjectValue)strtgInfo, soi.getName(), downWONum, archivesID, locationID, moID, planDate, (IObjectValue)soi, woIDs[j2], superParentID, null, tmpWOtableName, this.getWorkOrderSrcTypeEnum(schemaInfo), false, false, tmpLogtableName, runBegin, fireMode, runMode, (IObjectValue)ssi);
                }
                downWONum += INCREASEOFORDERNUM;
                if (hasVirtual) continue;
                secondWONum += INCREASEOFORDERNUM;
            }
        } else if (soAndDateMap.size() > 0) {
            Map dMap;
            EquipmentStandardOperationInfo soInfo2;
            ArrayList dateList = new ArrayList();
            for (PreMaintainStrategySeqItemInfo msoSeqInfo : soAndDateMap.keySet()) {
                Map dMap2 = (Map)soAndDateMap.get(msoSeqInfo);
                dateList.add(dMap2.keySet().iterator().next());
            }
            Date[] dates = this.getMinMaxDateOfArray(dateList);
            startDate4Seq = dates[0];
            endDate4Seq = dates[1];
            Integer count = new Integer(1);
            for (PreMaintainStrategySeqItemInfo msoSeqInfo : soAndDateMap.keySet()) {
                Map dMap3 = (Map)soAndDateMap.get(msoSeqInfo);
                if (dMap3.get(startDate4Seq) == null) continue;
                if (dMap3.get(startDate4Seq) instanceof Integer) break;
                Object[] obj = (Object[])dMap3.get(startDate4Seq);
                count = (Integer)obj[1];
                break;
            }
            HashMap<Date, Object[]> dateMap = new HashMap<Date, Object[]>();
            dateMap.put(startDate4Seq, new Object[]{new Integer(0), count});
            HashMap<PreMaintainStrategySeqItemInfo, Integer> countMap = new HashMap<PreMaintainStrategySeqItemInfo, Integer>();
            Integer parentCount = new Integer(1);
            if (count > 0) {
                for (PreMaintainStrategySeqItemInfo msoSeqInfo : soAndDateMap.keySet()) {
                    soInfo2 = msoSeqInfo.getStandardOperation();
                    if (soInfo2.getUsableStatus() != GeneUsableStatusEnum.USABLE) continue;
                    dMap = (Map)soAndDateMap.get(msoSeqInfo);
                    Date seqDate = (Date)dMap.keySet().iterator().next();
                    HashMap<Date, Object[]> seqDateMap = new HashMap<Date, Object[]>();
                    seqDateMap.put(seqDate, new Object[]{new Integer(0), count});
                    Integer seqCount = new Integer(WorkOrderHandleFacadeFactory.getLocalInstance(ctx).getSeqCountPerDay(proNumber, (IObjectValue)strtgInfo, (IObjectValue)soInfo2, seqDateMap, assetCount, seq, (IObjectValue)schemaInfo, strtgInfo.getMainOrgUnit().getId().toString(), tmpLogtableName, runBegin, fireMode, runMode));
                    if (seqCount.compareTo(parentCount) > 0) {
                        parentCount = new Integer(seqCount);
                    }
                    countMap.put(msoSeqInfo, seqCount);
                }
            }
            woIDs = new String[parentCount.intValue()];
            for (int i = 0; i < parentCount; ++i) {
                String[] ids = WorkOrderHandleFacadeFactory.getLocalInstance(ctx).generateTmpWOFromSO(proNumber, assetCount, seq, (IObjectValue)schemaInfo, strtgInfo, strtgInfo, strtgInfo.getName(), 0, archivesID, locationID, strtgInfo.getMainOrgUnit().getId().toString(), dateMap, endDate4Seq, null, null, null, null, tmpWOtableName, this.getWorkOrderSrcTypeEnum(schemaInfo), false, false, tmpLogtableName, runBegin, fireMode, runMode, null);
                woIDs[i] = ids[0];
            }
            if (woIDs == null || woIDs.length < 1 || woIDs[0] == null) {
                return;
            }
            this.setSuperParentID(woIDs);
            this.setTopmsInfo(strtgInfo);
            for (PreMaintainStrategySeqItemInfo msoSeqInfo : soAndDateMap.keySet()) {
                String superParentID;
                soInfo2 = msoSeqInfo.getStandardOperation();
                if (soInfo2.getUsableStatus() != GeneUsableStatusEnum.USABLE) continue;
                dMap = (Map)soAndDateMap.get(msoSeqInfo);
                int childCount = 1;
                Date seqDate = (Date)dMap.keySet().iterator().next();
                if (msoSeqInfo.getFireMode() == EQMFireModeEnum.BASEDATE) {
                    if (countMap.size() > 0) {
                        childCount = (Integer)countMap.get(msoSeqInfo);
                    }
                    for (j = 0; j < childCount; ++j) {
                        superParentID = this.getSuperParentID() == null || this.getSuperParentID().length < 1 ? null : this.getSuperParentID()[j];
                        WorkOrderHandleFacadeFactory.getLocalInstance(ctx).generateTmpWOFromSOOfSpcDate(proNumber, assetCount, seq, (IObjectValue)schemaInfo, (IObjectValue)this.getTopmsInfo(), (IObjectValue)strtgInfo, soInfo2.getName(), secondWONum, archivesID, locationID, msoSeqInfo.getMaintainOrgUnit().getId().toString(), seqDate, (IObjectValue)soInfo2, woIDs[j], superParentID, null, tmpWOtableName, this.getWorkOrderSrcTypeEnum(schemaInfo), false, false, tmpLogtableName, runBegin, fireMode, runMode, (IObjectValue)msoSeqInfo);
                    }
                    secondWONum += INCREASEOFORDERNUM;
                    continue;
                }
                if (dMap == null) continue;
                if (countMap.size() > 0) {
                    childCount = (Integer)countMap.get(msoSeqInfo);
                }
                for (j = 0; j < childCount; ++j) {
                    superParentID = this.getSuperParentID() == null || this.getSuperParentID().length < 1 ? null : this.getSuperParentID()[j];
                    WorkOrderHandleFacadeFactory.getLocalInstance(ctx).generateTmpWOFromSO(proNumber, assetCount, seq, (IObjectValue)schemaInfo, this.getTopmsInfo(), strtgInfo, soInfo2.getName(), secondWONum, archivesID, locationID, msoSeqInfo.getMaintainOrgUnit().getId().toString(), dMap, null, (IObjectValue)soInfo2, woIDs[j], superParentID, null, tmpWOtableName, this.getWorkOrderSrcTypeEnum(schemaInfo), true, false, tmpLogtableName, runBegin, fireMode, runMode, (IObjectValue)msoSeqInfo);
                }
                secondWONum += INCREASEOFORDERNUM;
            }
            if (!GeneEqualsUtils.equals((Object)startDate4Seq, (Object)endDate4Seq)) {
                WorkOrderHandleFacadeFactory.getLocalInstance(ctx).updateDateForTopSeq(tmpWOtableName, woIDs);
            }
        }
        if (strtgInfo.getMaintainRoute() != null && (mrInfo = strtgInfo.getMaintainRoute()).getUsableStatus() == GeneUsableStatusEnum.USABLE && (routeSite = this.getSortedRouteSites(mrInfo.getSites())).size() > 0) {
            HashMap<Date, Integer> dMap = new HashMap<Date, Integer>();
            if (startDate4Seq != null) {
                dMap.put(startDate4Seq, new Integer(0));
            } else {
                dMap.put(planDate, new Integer(0));
            }
            if (woIDs != null && woIDs.length > 0) {
                String superParentID;
                String[] mrWOIDs = new String[woIDs.length];
                for (int j3 = 0; j3 < woIDs.length; ++j3) {
                    superParentID = this.getSuperParentID() == null || this.getSuperParentID().length < 1 ? null : this.getSuperParentID()[j3];
                    String[] mrWOID = WorkOrderHandleFacadeFactory.getLocalInstance(ctx).generateTmpWOFromSO(proNumber, assetCount, seq, (IObjectValue)schemaInfo, this.getTopmsInfo(), strtgInfo, mrInfo.getName(), secondWONum, archivesID, locationID, strtgInfo.getMaintainOrgUnit().getId().toString(), dMap, endDate4Seq, null, woIDs[j3], superParentID, mrInfo.getId().toString(), tmpWOtableName, this.getWorkOrderSrcTypeEnum(schemaInfo), false, false, tmpLogtableName, runBegin, fireMode, runMode, null);
                    mrWOIDs[j3] = mrWOID[0];
                }
                secondWONum += INCREASEOFORDERNUM;
                int downWONum = FIRSTORDERNUM;
                for (int index = 0; index < routeSite.size(); ++index) {
                    String aID = null;
                    String lID = null;
                    String woName = null;
                    if (((EquipmentMaintainSiteInfo)routeSite.get(index)).getEquipmentArchives() != null) {
                        aID = ((EquipmentMaintainSiteInfo)routeSite.get(index)).getEquipmentArchives().getId().toString();
                        woName = ((EquipmentMaintainSiteInfo)routeSite.get(index)).getEquipmentArchives().getName().toString();
                    }
                    if (((EquipmentMaintainSiteInfo)routeSite.get(index)).getEquipmentLocation() != null) {
                        lID = ((EquipmentMaintainSiteInfo)routeSite.get(index)).getEquipmentLocation().getId().toString();
                        if (woName == null) {
                            woName = ((EquipmentMaintainSiteInfo)routeSite.get(index)).getEquipmentLocation().getName().toString();
                        }
                    }
                    if (aID == null && lID == null) continue;
                    EquipmentStandardOperationInfo mrSoInfo = ((EquipmentMaintainSiteInfo)routeSite.get(index)).getStandardOperation();
                    downWONum = ((EquipmentMaintainSiteInfo)routeSite.get(index)).getOrderNumber();
                    if (mrSoInfo == null) {
                        woName = woName + ResourceBase.getString((String)"com.kingdee.eas.eqm.planning.PLANNINGAutoGenerateResource", (String)"4_StrategyGenerateWOFacadeControllerBean", (Locale)ctx.getLocale());
                        if (mrWOIDs == null || mrWOIDs.length <= 0) continue;
                        for (int j4 = 0; j4 < mrWOIDs.length; ++j4) {
                            superParentID = this.getSuperParentID() == null || this.getSuperParentID().length < 1 ? null : this.getSuperParentID()[j4];
                            WorkOrderHandleFacadeFactory.getLocalInstance(ctx).generateTmpWOFromSO(proNumber, assetCount, seq, (IObjectValue)schemaInfo, this.getTopmsInfo(), strtgInfo, woName, downWONum, aID, lID, strtgInfo.getMaintainOrgUnit().getId().toString(), dMap, endDate4Seq, null, mrWOIDs[j4], superParentID, mrInfo.getId().toString(), tmpWOtableName, this.getWorkOrderSrcTypeEnum(schemaInfo), false, false, tmpLogtableName, runBegin, fireMode, runMode, null);
                        }
                        downWONum += INCREASEOFORDERNUM;
                        continue;
                    }
                    if (mrSoInfo.getUsableStatus() != GeneUsableStatusEnum.USABLE || mrWOIDs == null || mrWOIDs.length <= 0) continue;
                    SelectorItemCollection selectors = new SelectorItemCollection();
                    GeneSelectorUtils.addSelectorWithPros((SelectorItemCollection)selectors, (String)"", (String[])new String[]{"id", "number", "name", "duration"});
                    ObjectUuidPK pk = new ObjectUuidPK(mrSoInfo.getId());
                    mrSoInfo = (EquipmentStandardOperationInfo)EquipmentStandardOperationFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)pk, selectors);
                    for (j = 0; j < mrWOIDs.length; ++j) {
                        superParentID = this.getSuperParentID() == null || this.getSuperParentID().length < 1 ? null : this.getSuperParentID()[j];
                        WorkOrderHandleFacadeFactory.getLocalInstance(ctx).generateTmpWOFromSO(proNumber, assetCount, seq, (IObjectValue)schemaInfo, this.getTopmsInfo(), strtgInfo, mrSoInfo.getName(), downWONum, aID, lID, strtgInfo.getMaintainOrgUnit().getId().toString(), dMap, endDate4Seq, (IObjectValue)mrSoInfo, mrWOIDs[j], superParentID, mrInfo.getId().toString(), tmpWOtableName, this.getWorkOrderSrcTypeEnum(schemaInfo), false, false, tmpLogtableName, runBegin, fireMode, runMode, null);
                    }
                    downWONum += INCREASEOFORDERNUM;
                }
            }
        }
        StrategyStructureEntryCollection ssc = strtgInfo.getStructureEntry();
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < ssc.size(); ++i) {
            PreMaintainStrategyInfo sonInfo = ssc.get(i).getMaintainStrategy();
            idSet.add(sonInfo.getId().toString());
        }
        if (idSet.size() > 0) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            SelectorItemCollection selectors = this.getInnerSelectors();
            GeneSelectorUtils.addSelectorWithIDAndNumberAndName((SelectorItemCollection)selectors, (String)"parent");
            GeneSelectorUtils.addSelectorWithPros((SelectorItemCollection)selectors, (String)"mainStdOper", (String[])new String[]{"id", "number", "name", "checkedStatus", "usableStatus", "duration"});
            GeneSelectorUtils.addSelectorWithPros((SelectorItemCollection)selectors, (String)"soSeqEntry.standardOperation", (String[])new String[]{"id", "number", "name", "checkedStatus", "usableStatus", "duration"});
            GeneSelectorUtils.addSelectorWithIDAndNumberAndName((SelectorItemCollection)selectors, (String)"soSeqEntry.maintainOrgUnit");
            GeneSelectorUtils.addSelectorWithPros((SelectorItemCollection)selectors, (String)"storageOrgUnit.CU", (String[])new String[]{"id"});
            GeneSelectorUtils.addSelectorWithPros((SelectorItemCollection)selectors, (String)"maintainRoute", (String[])new String[]{"id", "number", "name", "usableStatus"});
            GeneSelectorUtils.addSelectorWithIDAndNumberAndName((SelectorItemCollection)selectors, (String)"maintainRoute.sites");
            GeneSelectorUtils.addSelectorWithIDAndNumberAndName((SelectorItemCollection)selectors, (String)"maintainRoute.sites.standardOperation");
            GeneSelectorUtils.addSelectorWithPros((SelectorItemCollection)selectors, (String)"maintainRoute.sites.standardOperation", (String[])new String[]{"usableStatus"});
            GeneSelectorUtils.addSelectorWithIDAndNumberAndName((SelectorItemCollection)selectors, (String)"maintainRoute.sites.equipmentArchives");
            GeneSelectorUtils.addSelectorWithIDAndNumberAndName((SelectorItemCollection)selectors, (String)"maintainRoute.sites.equipmentLocation");
            viewInfo.setSelector(selectors);
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            filterInfo.getFilterItems().add(new FilterItemInfo("openedStatus", (Object)new Integer(2), CompareType.EQUALS));
            filterInfo.setMaskString("#0 and #1 ");
            viewInfo.setFilter(filterInfo);
            CoreBaseCollection c = PreMaintainStrategyFactory.getLocalInstance(ctx).getCollection(viewInfo);
            for (int i = 0; i < c.size(); ++i) {
                PreMaintainStrategyInfo sonInfo = (PreMaintainStrategyInfo)c.get(i);
                if (woIDs != null && woIDs.length > 0) {
                    woID = woIDs[0];
                }
                this.generateWorkOrderByStrategy(ctx, proNumber, assetCount, seq, schemaInfo, sonInfo, null, true, planDate, woID, tmpWOtableName, runBegin, tmpLogtableName, fireMode, runMode, secondWONum);
            }
        }
    }

    private void generateWorkOrderByStrategyOfSpcDate(Context ctx, String proNumber, int assetCount, int seq, EquipmentMaintainSchemaInfo schemaInfo, PreMaintainStrategyInfo strtgInfo, List seqlst, boolean isFromParent, List dateList, String parentWorkOrderID, String tmpWOtableName, Timestamp runBegin, String tmpLogtableName, TiggerModeEnum fireMode, RunningModeEnum runMode, int secondWONum) throws BOSException, EASBizException {
        this.generateWorkOrderByStrategyOfSpcDate(ctx, proNumber, assetCount, seq, schemaInfo, strtgInfo, seqlst, isFromParent, dateList, parentWorkOrderID, tmpWOtableName, runBegin, tmpLogtableName, fireMode, runMode, secondWONum, null);
    }

    private void generateWorkOrderByStrategyOfSpcDate(Context ctx, String proNumber, int assetCount, int seq, EquipmentMaintainSchemaInfo schemaInfo, PreMaintainStrategyInfo strtgInfo, List seqlst, boolean isFromParent, List dateList, String parentWorkOrderID, String tmpWOtableName, Timestamp runBegin, String tmpLogtableName, TiggerModeEnum fireMode, RunningModeEnum runMode, int secondWONum, List dateRange) throws BOSException, EASBizException {
        List routeSites;
        EquipmentMaintainRouteInfo mrInfo;
        int i;
        EquipmentStandardOperationInfo soInfo;
        EquipmentArchivesInfo asset = null;
        String woID = parentWorkOrderID;
        String[] woIDs = new String[1];
        String archivesID = null;
        String locationID = null;
        if (strtgInfo.getArchives() != null) {
            archivesID = strtgInfo.getArchives().getId().toString();
            asset = strtgInfo.getArchives();
            EquipmentArchivesInfo archivesInfo = strtgInfo.getArchives();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("location.id"));
            sic.add(new SelectorItemInfo("location.number"));
            sic.add(new SelectorItemInfo("location.name"));
            archivesInfo = EquipmentArchivesFactory.getLocalInstance((Context)ctx).getEquipmentArchivesInfo((IObjectPK)new ObjectUuidPK(archivesInfo.getId().toString()), sic);
            if (archivesInfo != null && archivesInfo.getLocation() != null) {
                locationID = archivesInfo.getLocation().getId().toString();
            }
        } else if (strtgInfo.getLocation() != null) {
            locationID = strtgInfo.getLocation().getId().toString();
            if (asset == null) {
                asset = strtgInfo.getLocation();
            }
        }
        String mtOrgUnitID = null;
        if (strtgInfo.getMaintainOrgUnit() != null) {
            mtOrgUnitID = strtgInfo.getMaintainOrgUnit().getId().toString();
        }
        boolean ifSeqNotIncludeMainSO = false;
        Date planDate = null;
        planDate = dateList.size() == 1 ? (Date)dateList.get(0) : this.getMinDateOfArray(dateList);
        if (planDate == null) {
            return;
        }
        if (!isFromParent && strtgInfo.getStandWorkFireRule() == EQMSWFireRuleEnum.MAINSW && (soInfo = strtgInfo.getMainStdOper()) != null) {
            if (soInfo.getUsableStatus() != GeneUsableStatusEnum.USABLE) {
                return;
            }
            PreMaintainStrategySeqItemInfo msoSeqInfo = (PreMaintainStrategySeqItemInfo)seqlst.get(0);
            String msoMtOrg = null;
            if (msoSeqInfo.getMaintainOrgUnit() != null) {
                msoMtOrg = msoSeqInfo.getMaintainOrgUnit().getId().toString();
            }
            woIDs[0] = woID = WorkOrderHandleFacadeFactory.getLocalInstance(ctx).generateTmpWOFromSOOfSpcDate(proNumber, assetCount, seq, (IObjectValue)schemaInfo, (IObjectValue)strtgInfo, (IObjectValue)strtgInfo, soInfo.getName(), 0, archivesID, locationID, msoMtOrg, planDate, (IObjectValue)soInfo, null, null, null, tmpWOtableName, this.getWorkOrderSrcTypeEnum(schemaInfo), true, true, tmpLogtableName, runBegin, fireMode, runMode, (IObjectValue)msoSeqInfo);
            this.setSuperParentID(woIDs);
            this.setParentID(woIDs);
            this.setTopmsInfo(strtgInfo);
            isFromParent = true;
            ifSeqNotIncludeMainSO = true;
        }
        if (isFromParent) {
            if (seqlst == null || seqlst.size() == 0) {
                woID = WorkOrderHandleFacadeFactory.getLocalInstance(ctx).generateTmpWOFromSOOfSpcDate(proNumber, assetCount, seq, (IObjectValue)schemaInfo, (IObjectValue)this.getTopmsInfo(), (IObjectValue)strtgInfo, strtgInfo.getName(), secondWONum, archivesID, locationID, strtgInfo.getMaintainOrgUnit().getId().toString(), planDate, null, parentWorkOrderID, this.getSuperParentID()[0], null, tmpWOtableName, this.getWorkOrderSrcTypeEnum(schemaInfo), false, false, tmpLogtableName, runBegin, fireMode, runMode, null);
                secondWONum += INCREASEOFORDERNUM;
            }
            PreMaintainStrategySeqItemCollection ssc = strtgInfo.getSoSeqEntry();
            int downWONum = FIRSTORDERNUM;
            for (i = 0; i < ssc.size(); ++i) {
                PreMaintainStrategySeqItemInfo ssi = ssc.get(i);
                EquipmentStandardOperationInfo soi = ssi.getStandardOperation();
                if (soi.getUsableStatus() != GeneUsableStatusEnum.USABLE || ifSeqNotIncludeMainSO && soi.getId().toString().equals(strtgInfo.getMainStdOper().getId().toString())) continue;
                String ssiOrgID = null;
                ssiOrgID = ssi.getMaintainOrgUnit() == null ? null : ssi.getMaintainOrgUnit().getId().toString();
                WorkOrderHandleFacadeFactory.getLocalInstance(ctx).generateTmpWOFromSOOfSpcDate(proNumber, assetCount, seq, (IObjectValue)schemaInfo, (IObjectValue)this.getTopmsInfo(), (IObjectValue)strtgInfo, soi.getName(), downWONum, archivesID, locationID, ssiOrgID, planDate, (IObjectValue)soi, woID, this.getSuperParentID()[0], null, tmpWOtableName, this.getWorkOrderSrcTypeEnum(schemaInfo), false, false, tmpLogtableName, runBegin, fireMode, runMode, (IObjectValue)ssi);
                downWONum += INCREASEOFORDERNUM;
            }
            if (secondWONum == FIRSTORDERNUM) {
                secondWONum = downWONum;
            }
        } else {
            woIDs[0] = woID = WorkOrderHandleFacadeFactory.getLocalInstance(ctx).generateTmpWOFromSOOfSpcDate(proNumber, assetCount, seq, (IObjectValue)schemaInfo, (IObjectValue)strtgInfo, (IObjectValue)strtgInfo, strtgInfo.getName(), secondWONum, archivesID, locationID, mtOrgUnitID, planDate, null, null, null, null, tmpWOtableName, this.getWorkOrderSrcTypeEnum(schemaInfo), false, false, tmpLogtableName, runBegin, fireMode, runMode, null);
            secondWONum += INCREASEOFORDERNUM;
            this.setSuperParentID(woIDs);
            this.setTopmsInfo(strtgInfo);
            int dowmWONum = FIRSTORDERNUM;
            List<EquipmentStandardOperationInfo> staoprList = new ArrayList();
            for (i = 0; i < seqlst.size(); ++i) {
                PreMaintainStrategySeqItemInfo msoSeqInfo = (PreMaintainStrategySeqItemInfo)seqlst.get(i);
                EquipmentStandardOperationInfo soInfo2 = msoSeqInfo.getStandardOperation();
                staoprList.add(soInfo2);
            }
            staoprList = this.getRestrainHandle(ctx).findStandardOperationListNotBeRestricted(staoprList, (IObjectValue)asset);
            for (int j = 0; j < staoprList.size(); ++j) {
                EquipmentStandardOperationInfo st = (EquipmentStandardOperationInfo)staoprList.get(j);
                int index = this.getIndexByStandardOperation(st.getId(), seqlst);
                PreMaintainStrategySeqItemInfo msoSeqInfo = (PreMaintainStrategySeqItemInfo)seqlst.get(index);
                EquipmentStandardOperationInfo soInfo3 = msoSeqInfo.getStandardOperation();
                if (soInfo3.getUsableStatus() != GeneUsableStatusEnum.USABLE) continue;
                Date localDate = null;
                localDate = dateList.size() == 1 ? (Date)dateList.get(0) : (Date)dateList.get(index);
                if (localDate == null) {
                    localDate = planDate;
                }
                if (dateRange != null) {
                    Object[] ds = (Object[])dateRange.get(index);
                    Date from = (Date)ds[0];
                    Date to = (Date)ds[1];
                    if (this.getRestrainHandle(ctx).checkRestrain((IObjectValue)soInfo3, (IObjectValue)asset, localDate, from, to, false, tmpWOtableName, strtgInfo.getCalendarType(), strtgInfo)) continue;
                }
                WorkOrderHandleFacadeFactory.getLocalInstance(ctx).generateTmpWOFromSOOfSpcDate(proNumber, assetCount, seq, (IObjectValue)schemaInfo, (IObjectValue)this.getTopmsInfo(), (IObjectValue)strtgInfo, soInfo3.getName(), dowmWONum, archivesID, locationID, msoSeqInfo.getMaintainOrgUnit().getId().toString(), localDate, (IObjectValue)soInfo3, woID, this.getSuperParentID()[0], null, tmpWOtableName, this.getWorkOrderSrcTypeEnum(schemaInfo), true, false, tmpLogtableName, runBegin, fireMode, runMode, (IObjectValue)msoSeqInfo);
                dowmWONum += INCREASEOFORDERNUM;
            }
            if (secondWONum == FIRSTORDERNUM) {
                secondWONum = dowmWONum;
            }
        }
        if (strtgInfo.getMaintainRoute() != null && (mrInfo = strtgInfo.getMaintainRoute()).getUsableStatus() == GeneUsableStatusEnum.USABLE && (routeSites = this.getSortedRouteSites(mrInfo.getSites())).size() > 0) {
            String mrWOID = WorkOrderHandleFacadeFactory.getLocalInstance(ctx).generateTmpWOFromSOOfSpcDate(proNumber, assetCount, seq, (IObjectValue)schemaInfo, (IObjectValue)this.getTopmsInfo(), (IObjectValue)strtgInfo, mrInfo.getName(), secondWONum, archivesID, locationID, mtOrgUnitID, planDate, null, woID, this.getSuperParentID()[0], mrInfo.getId().toString(), tmpWOtableName, this.getWorkOrderSrcTypeEnum(schemaInfo), false, false, tmpLogtableName, runBegin, fireMode, runMode, null);
            int dowmWONum = FIRSTORDERNUM;
            for (int index = 0; index < routeSites.size(); ++index) {
                String aID = null;
                EquipmentMaintainSiteInfo siteInfo = (EquipmentMaintainSiteInfo)routeSites.get(index);
                String woName = null;
                if (siteInfo.getEquipmentArchives() != null) {
                    aID = siteInfo.getEquipmentArchives().getId().toString();
                    woName = siteInfo.getEquipmentArchives().getName().toString();
                }
                String lID = null;
                if (siteInfo.getEquipmentLocation() != null) {
                    lID = siteInfo.getEquipmentLocation().getId().toString();
                    if (woName == null) {
                        woName = siteInfo.getEquipmentLocation().getName().toString();
                    }
                }
                woName = woName + ResourceBase.getString((String)"com.kingdee.eas.eqm.planning.PLANNINGAutoGenerateResource", (String)"4_StrategyGenerateWOFacadeControllerBean", (Locale)ctx.getLocale());
                if (aID == null && lID == null) continue;
                EquipmentStandardOperationInfo mrSoInfo = siteInfo.getStandardOperation();
                if (mrSoInfo != null) {
                    woName = mrSoInfo.getName();
                    if (mrSoInfo.getUsableStatus() != GeneUsableStatusEnum.USABLE) continue;
                    SelectorItemCollection selectors = new SelectorItemCollection();
                    GeneSelectorUtils.addSelectorWithPros((SelectorItemCollection)selectors, (String)"", (String[])new String[]{"id", "number", "name", "duration"});
                    ObjectUuidPK pk = new ObjectUuidPK(mrSoInfo.getId());
                    mrSoInfo = (EquipmentStandardOperationInfo)EquipmentStandardOperationFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)pk, selectors);
                }
                dowmWONum = siteInfo.getOrderNumber();
                WorkOrderHandleFacadeFactory.getLocalInstance(ctx).generateTmpWOFromSOOfSpcDate(proNumber, assetCount, seq, (IObjectValue)schemaInfo, (IObjectValue)this.getTopmsInfo(), (IObjectValue)strtgInfo, woName, dowmWONum, aID, lID, mtOrgUnitID, planDate, (IObjectValue)mrSoInfo, mrWOID, this.getSuperParentID()[0], mrInfo.getId().toString(), tmpWOtableName, this.getWorkOrderSrcTypeEnum(schemaInfo), false, false, tmpLogtableName, runBegin, fireMode, runMode, null);
                dowmWONum += INCREASEOFORDERNUM;
            }
        }
        StrategyStructureEntryCollection ssc = strtgInfo.getStructureEntry();
        HashSet<String> idSet = new HashSet<String>();
        for (int i2 = 0; i2 < ssc.size(); ++i2) {
            PreMaintainStrategyInfo sonInfo = ssc.get(i2).getMaintainStrategy();
            idSet.add(sonInfo.getId().toString());
        }
        if (idSet.size() > 0) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            SelectorItemCollection selectors = this.getInnerSelectors();
            GeneSelectorUtils.addSelectorWithIDAndNumberAndName((SelectorItemCollection)selectors, (String)"parent");
            GeneSelectorUtils.addSelectorWithPros((SelectorItemCollection)selectors, (String)"mainStdOper", (String[])new String[]{"id", "number", "name", "checkedStatus", "usableStatus"});
            GeneSelectorUtils.addSelectorWithPros((SelectorItemCollection)selectors, (String)"soSeqEntry.standardOperation", (String[])new String[]{"id", "number", "name", "checkedStatus", "usableStatus"});
            GeneSelectorUtils.addSelectorWithPros((SelectorItemCollection)selectors, (String)"storageOrgUnit.CU", (String[])new String[]{"id"});
            GeneSelectorUtils.addSelectorWithPros((SelectorItemCollection)selectors, (String)"maintainRoute", (String[])new String[]{"id", "number", "name", "usableStatus"});
            GeneSelectorUtils.addSelectorWithIDAndNumberAndName((SelectorItemCollection)selectors, (String)"maintainRoute.sites");
            GeneSelectorUtils.addSelectorWithIDAndNumberAndName((SelectorItemCollection)selectors, (String)"maintainRoute.sites.standardOperation");
            GeneSelectorUtils.addSelectorWithIDAndNumberAndName((SelectorItemCollection)selectors, (String)"maintainRoute.sites.equipmentArchives");
            GeneSelectorUtils.addSelectorWithIDAndNumberAndName((SelectorItemCollection)selectors, (String)"maintainRoute.sites.equipmentLocation");
            GeneSelectorUtils.addSelectorWithPros((SelectorItemCollection)selectors, (String)"meterSeqEntry.meter", (String[])new String[]{"countType"});
            viewInfo.setSelector(selectors);
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            filterInfo.getFilterItems().add(new FilterItemInfo("openedStatus", (Object)new Integer(2), CompareType.EQUALS));
            filterInfo.setMaskString("#0 and #1 ");
            viewInfo.setFilter(filterInfo);
            CoreBaseCollection c = PreMaintainStrategyFactory.getLocalInstance(ctx).getCollection(viewInfo);
            for (int i3 = 0; i3 < c.size(); ++i3) {
                PreMaintainStrategyInfo sonInfo = (PreMaintainStrategyInfo)c.get(i3);
                ArrayList<Date> downDate = new ArrayList<Date>();
                downDate.add(planDate);
                this.generateWorkOrderByStrategyOfSpcDate(ctx, proNumber, assetCount, seq, schemaInfo, sonInfo, null, true, downDate, woID, tmpWOtableName, runBegin, tmpLogtableName, fireMode, runMode, secondWONum);
            }
        }
    }

    private int getIndexByStandardOperation(BOSUuid staoprId, List seqlst) {
        for (int i = 0; i < seqlst.size(); ++i) {
            PreMaintainStrategySeqItemInfo msoSeqInfo = (PreMaintainStrategySeqItemInfo)seqlst.get(i);
            EquipmentStandardOperationInfo soInfo = msoSeqInfo.getStandardOperation();
            if (!soInfo.getId().equals((Object)staoprId)) continue;
            return i;
        }
        return seqlst.size() - 1;
    }

    private Date getMinDateOfArray(List dateList) throws BOSException, EASBizException {
        Date rtn = null;
        for (int i = 0; i < dateList.size(); ++i) {
            if (rtn != null && !DateUtils.after(rtn, (Date)dateList.get(i))) continue;
            rtn = (Date)dateList.get(i);
        }
        return rtn;
    }

    private Date[] getMinMaxDateOfArray(List dateList) throws BOSException, EASBizException {
        Date[] rtn = new Date[2];
        Date minDate = null;
        Date maxDate = null;
        for (int i = 0; i < dateList.size(); ++i) {
            if (minDate == null || DateUtils.after(minDate, (Date)dateList.get(i))) {
                minDate = (Date)dateList.get(i);
            }
            if (maxDate != null && !DateUtils.after((Date)dateList.get(i), maxDate)) continue;
            maxDate = (Date)dateList.get(i);
        }
        rtn[0] = minDate;
        rtn[1] = maxDate;
        return rtn;
    }

    private List getStandardOperationList(PreMaintainStrategySeqItemCollection strategyItemCollection) {
        ArrayList<EquipmentStandardOperationInfo> result = new ArrayList<EquipmentStandardOperationInfo>();
        for (int i = 0; i < strategyItemCollection.size(); ++i) {
            result.add(strategyItemCollection.get(i).getStandardOperation());
        }
        return result;
    }

    private List getStandardOperationList(PreMaintainStrategySeqItemCollection strategyItemCollection, EQMFireModeEnum fireMode) {
        ArrayList<EquipmentStandardOperationInfo> result = new ArrayList<EquipmentStandardOperationInfo>();
        for (int i = 0; i < strategyItemCollection.size(); ++i) {
            if (strategyItemCollection.get(i).getFireMode() != EQMFireModeEnum.BASEDATE) continue;
            result.add(strategyItemCollection.get(i).getStandardOperation());
        }
        return result;
    }

    private PreMaintainStrategySeqItemInfo findStrategyItem(EquipmentStandardOperationInfo standardOperation, PreMaintainStrategySeqItemCollection strategyItemCollection) {
        for (int i = 0; i < strategyItemCollection.size(); ++i) {
            if (!strategyItemCollection.get(i).getStandardOperation().getId().equals((Object)standardOperation.getId())) continue;
            return strategyItemCollection.get(i);
        }
        return null;
    }

    private void swFrequenceFireHandle(Context ctx, String proNumber, int assetCount, int seq, EquipmentMaintainSchemaInfo schemaInfo, PreMaintainStrategyInfo strategy, Date startDate, Date endDate, Timestamp runBegin, String tmpWOtableName, String tmpLogTableName, TiggerModeEnum fireMode, RunningModeEnum runMode) throws BOSException, EASBizException {
        IObjectValue asset = null;
        asset = this.getAsset(strategy);
        List sortedStandardOperationList = this.getRestrainHandle(ctx).sortStandardOperation(this.getStandardOperationList(strategy.getSoSeqEntry()), asset);
        HashMap specifyDateStrategyItemAndDateMap = new HashMap();
        LinkedHashMap frequenceStrategyItemAndDateMap = new LinkedHashMap();
        HashMap lstwoMap = new HashMap();
        int[] counts = this.collectStrategyItemsInfo(ctx, strategy, startDate, endDate, tmpWOtableName, asset, sortedStandardOperationList, specifyDateStrategyItemAndDateMap, frequenceStrategyItemAndDateMap, lstwoMap);
        int specifyCount = counts[0];
        int maxArrayCnt = counts[1];
        HashMap mergeMap = new HashMap();
        this.mergeFrequenceStrategyItemAndDateMap(ctx, asset, frequenceStrategyItemAndDateMap, maxArrayCnt, mergeMap);
        for (int i = 0; i < maxArrayCnt; ++i) {
            HashMap genMap = new HashMap();
            Date minDate = null;
            Date maxDate = null;
            Date[] dateRange = this.filterAndCopyMap(ctx, strategy, tmpWOtableName, asset, mergeMap, i, genMap);
            minDate = dateRange[0];
            maxDate = dateRange[1];
            if (genMap.size() > 0) {
                this.mergeSepcialDateToGenMap(ctx, strategy, tmpWOtableName, asset, specifyDateStrategyItemAndDateMap, genMap, minDate, maxDate);
            }
            HashMap delMap = new HashMap();
            for (PreMaintainStrategySeqItemInfo keyInfo : genMap.keySet()) {
                if (!lstwoMap.containsKey(keyInfo) || keyInfo.getFireMode() == EQMFireModeEnum.BASEDATE) continue;
                delMap.put(keyInfo, lstwoMap.get(keyInfo));
                lstwoMap.remove(keyInfo);
            }
            if (!delMap.isEmpty()) {
                WorkOrderHandleFacadeFactory.getLocalInstance(ctx).deleteInvalidWOOfSeq(proNumber, assetCount, seq, (IObjectValue)schemaInfo, (IObjectValue)strategy, asset, startDate, delMap, -1, 0, tmpWOtableName, tmpLogTableName, runBegin, fireMode, runMode);
            }
            if (minDate == null) continue;
            this.generateWorkOrderByStrategy(ctx, proNumber, assetCount, seq, schemaInfo, strategy, genMap, false, minDate, strategy.getName(), tmpWOtableName, runBegin, tmpLogTableName, fireMode, runMode, FIRSTORDERNUM);
        }
        for (int s = 0; s < specifyCount; ++s) {
            ArrayList<PreMaintainStrategySeqItemInfo> seqList = new ArrayList<PreMaintainStrategySeqItemInfo>();
            ArrayList<Date> dateList = new ArrayList<Date>();
            ArrayList<Object[]> dateRange = new ArrayList<Object[]>();
            for (PreMaintainStrategySeqItemInfo pmsInfo : specifyDateStrategyItemAndDateMap.keySet()) {
                Date[] dates;
                List dateLst = (List)specifyDateStrategyItemAndDateMap.get(pmsInfo);
                if (s > dateLst.size() - 1 || dateLst.size() <= 0 || dateLst.get(s) == null || (dates = (Date[])dateLst.get(s))[0] == null) continue;
                seqList.add(pmsInfo);
                dateList.add(dates[0]);
                dateRange.add(new Object[]{dates[1], dates[2]});
            }
            if (seqList.size() <= 0) continue;
            this.generateWorkOrderByStrategyOfSpcDate(ctx, proNumber, assetCount, seq, schemaInfo, strategy, seqList, false, dateList, strategy.getName(), tmpWOtableName, runBegin, tmpLogTableName, fireMode, runMode, FIRSTORDERNUM, dateRange);
        }
    }

    private void mergeSepcialDateToGenMap(Context ctx, PreMaintainStrategyInfo strategy, String tmpWOtableName, IObjectValue asset, Map specifyDateStrategyItemAndDateMap, Map genMap, Date minDate, Date maxDate) throws BOSException, EASBizException {
        Iterator e = specifyDateStrategyItemAndDateMap.keySet().iterator();
        while (e.hasNext()) {
            ArrayList<Date[]> notHandledLst = new ArrayList<Date[]>();
            PreMaintainStrategySeqItemInfo pmsInfo = (PreMaintainStrategySeqItemInfo)e.next();
            EquipmentStandardOperationInfo esoInfo = pmsInfo.getStandardOperation();
            List dateLst = (List)specifyDateStrategyItemAndDateMap.get(pmsInfo);
            for (int l = 0; l < dateLst.size(); ++l) {
                Date[] dates = (Date[])dateLst.get(l);
                if (dates == null || dates.length == 0 || dates[0] == null) continue;
                Date d = dates[0];
                Date fromDate = dates[1];
                Date toDate = dates[2];
                if (this.getRestrainHandle(ctx).checkRestrain((IObjectValue)esoInfo, asset, d, fromDate, toDate, false, tmpWOtableName, strategy.getCalendarType(), strategy)) continue;
                HashMap<Date, Integer> map = new HashMap<Date, Integer>();
                map.put(d, new Integer(0));
                if (d != null && !java.sql.Date.valueOf(dateFormat.format(d)).before(java.sql.Date.valueOf(dateFormat.format(minDate))) && !java.sql.Date.valueOf(dateFormat.format(d)).after(java.sql.Date.valueOf(dateFormat.format(maxDate)))) {
                    genMap.put(pmsInfo, map);
                    notHandledLst.add(null);
                    continue;
                }
                notHandledLst.add(new Date[]{d, null, null});
            }
            specifyDateStrategyItemAndDateMap.put(pmsInfo, notHandledLst);
        }
    }

    private Date[] filterAndCopyMap(Context ctx, PreMaintainStrategyInfo strategy, String tmpWOtableName, IObjectValue asset, Map fromMap, int dateIndex, Map toMap) throws BOSException, EASBizException {
        Date minDate = null;
        Date maxDate = null;
        for (PreMaintainStrategySeqItemInfo strategyItem : fromMap.keySet()) {
            List mergeMapDateList;
            if (strategyItem.getStandardOperation().getUsableStatus() != GeneUsableStatusEnum.USABLE || (mergeMapDateList = (List)fromMap.get(strategyItem)).get(dateIndex) == null) continue;
            int range = 0;
            Date pDate = (Date)((Map)mergeMapDateList.get(dateIndex)).keySet().iterator().next();
            if (((Map)mergeMapDateList.get(dateIndex)).get(pDate) instanceof Integer) {
                range = (Integer)((Map)mergeMapDateList.get(dateIndex)).get(pDate);
            } else {
                Object[] obj = (Object[])((Map)mergeMapDateList.get(dateIndex)).get(pDate);
                range = (Integer)obj[0];
            }
            Date fromDate = null;
            Date toDate = null;
            if (strategy.getCalendarType() == EQMCalendarTypeEnum.GENERALCALENDAR) {
                fromDate = new Date(pDate.getTime() - (long)range * 86400000L);
                toDate = new Date(pDate.getTime() + (long)range * 86400000L);
            } else {
                fromDate = FactoryCalendarFactory.getLocalInstance((Context)ctx).findDateFromFCalendar(strategy.getStorageOrgUnit().getId().toString(), pDate, 2, range, 2);
                toDate = FactoryCalendarFactory.getLocalInstance((Context)ctx).findDateFromFCalendar(strategy.getStorageOrgUnit().getId().toString(), pDate, 1, range, 2);
            }
            if (this.getRestrainHandle(ctx).checkRestrain((IObjectValue)strategyItem.getStandardOperation(), asset, pDate, fromDate, toDate, false, tmpWOtableName, strategy.getCalendarType(), strategy)) continue;
            toMap.put(strategyItem, mergeMapDateList.get(dateIndex));
            if (minDate == null) {
                minDate = pDate;
            } else if (java.sql.Date.valueOf(dateFormat.format(pDate)).before(java.sql.Date.valueOf(dateFormat.format(minDate)))) {
                minDate = pDate;
            }
            if (maxDate == null) {
                maxDate = pDate;
                continue;
            }
            if (!java.sql.Date.valueOf(dateFormat.format(pDate)).after(java.sql.Date.valueOf(dateFormat.format(maxDate)))) continue;
            maxDate = pDate;
        }
        return new Date[]{minDate, maxDate};
    }

    private void mergeFrequenceStrategyItemAndDateMap(Context ctx, IObjectValue asset, Map frequenceStrategyItemAndDateMap, int maxArrayCnt, Map mergeMap) throws BOSException {
        for (PreMaintainStrategySeqItemInfo strategyItem : frequenceStrategyItemAndDateMap.keySet()) {
            List dateMapList = (List)frequenceStrategyItemAndDateMap.get(strategyItem);
            ArrayList filledDateMapList = new ArrayList();
            for (int j = 0; j < dateMapList.size(); ++j) {
                this.addNullToList(filledDateMapList, strategyItem.getFrequencyTimes() - 1);
                Object currentDateMap = dateMapList.get(j);
                if (this.isRestrictedByOtherStrategyItemsInMergeMap(ctx, asset, mergeMap, strategyItem, currentDateMap)) {
                    filledDateMapList.add(null);
                    continue;
                }
                filledDateMapList.add(currentDateMap);
            }
            this.addNullToList(filledDateMapList, maxArrayCnt - filledDateMapList.size());
            mergeMap.put(strategyItem, filledDateMapList);
        }
    }

    private void addNullToList(List arrDateLst, int count) {
        for (int k = 0; k < count; ++k) {
            arrDateLst.add(null);
        }
    }

    private boolean isRestrictedByOtherStrategyItemsInMergeMap(Context ctx, IObjectValue asset, Map mergeMap, PreMaintainStrategySeqItemInfo strategyItem, Object currentDate) throws BOSException {
        boolean restrict = false;
        for (PreMaintainStrategySeqItemInfo currentStrategyItem : mergeMap.keySet()) {
            if (strategyItem.getId().toString().equals(currentStrategyItem.getId().toString())) continue;
            EquipmentStandardOperationInfo standardOperation = currentStrategyItem.getStandardOperation();
            List dates = (List)mergeMap.get(currentStrategyItem);
            if (!this.contains(dates, currentDate)) continue;
            EquipmentStandardOperationInfo currentSta = strategyItem.getStandardOperation();
            restrict = this.getRestrainHandle(ctx).checkRestrain(currentSta, standardOperation, asset);
            if (!restrict) continue;
            break;
        }
        return restrict;
    }

    private boolean contains(List dates, Object currentDate) {
        boolean contained = false;
        if (dates == null || dates.size() < 1 || currentDate == null) {
            return contained;
        }
        for (int i = 0; i < dates.size(); ++i) {
            Object date = dates.get(i);
            if (date == null) continue;
            if (date instanceof Map && currentDate instanceof Map) {
                Map dateMap = (Map)date;
                Map currentDateMap = (Map)currentDate;
                contained = GeneEqualsUtils.equals(dateMap.keySet(), currentDateMap.keySet());
            }
            if (contained) break;
        }
        return contained;
    }

    private int[] collectStrategyItemsInfo(Context ctx, PreMaintainStrategyInfo strategy, Date startDate, Date endDate, String tmpWOtableName, IObjectValue asset, List sortedStandardOperationList, Map specifyDateStrategyItemAndDateMap, Map frequenceStrategyItemAndDateMap, Map lstwoMap) throws BOSException, EASBizException {
        int maxArrayCnt = 0;
        int specifyCount = 0;
        block8: for (int index = 0; index < sortedStandardOperationList.size(); ++index) {
            EquipmentStandardOperationInfo standardOperation = (EquipmentStandardOperationInfo)sortedStandardOperationList.get(index);
            PreMaintainStrategySeqItemInfo strategyItem = this.findStrategyItem(standardOperation, strategy.getSoSeqEntry());
            if (strategyItem.getFireMode() == EQMFireModeEnum.BASEDATE && !this.isStandardOperationNotBeRestricted(ctx, standardOperation, strategy.getSoSeqEntry(), asset)) continue;
            Date woDate = this.getDateHandle(ctx).getLastWorkOrderDate((IObjectValue)standardOperation, this.getAssetId(strategy), this.isLocation(strategy), true, startDate);
            Date date = woDate = woDate != null ? woDate : startDate;
            if (DateUtils.after(woDate, endDate)) continue;
            HashMap<Date, Integer> t = new HashMap<Date, Integer>();
            t.put(woDate, new Integer(0));
            lstwoMap.put(strategyItem, t);
            switch (strategyItem.getFireMode().getValue()) {
                case 20: {
                    List sdateLst = this.getDateHandle(ctx).getAllDateListFromSpeciDateEntry((IObjectValue)strategy, woDate, endDate, strategyItem.getFrequencyTimes(), (IObjectValue)standardOperation, false);
                    if (specifyCount == 0) {
                        specifyCount = sdateLst.size();
                    }
                    if (specifyCount <= 0) continue block8;
                    specifyDateStrategyItemAndDateMap.put(strategyItem, sdateLst);
                    continue block8;
                }
                case 10: {
                    EQMSequencyFireRuleEnum sfr = strategy.getSequenceFireRule();
                    List dateLst = null;
                    List distinctDate = null;
                    switch (sfr.getValue()) {
                        case 10: {
                            dateLst = this.getDateListOfEachAtTerm(ctx, strategy, strategyItem, startDate, endDate, this.getAssetId(strategy), this.isLocation(strategy), true, tmpWOtableName);
                            distinctDate = this.getDistinctDate(dateLst);
                            break;
                        }
                        case 20: {
                            dateLst = this.getDateListOfAllAtTerm(ctx, strategy, strategyItem, startDate, endDate, this.getAssetId(strategy), this.isLocation(strategy), true, tmpWOtableName);
                            distinctDate = this.getDistinctDate(dateLst);
                        }
                    }
                    if (distinctDate == null || distinctDate.size() <= 0) continue block8;
                    if (strategyItem.getFrequencyTimes() * distinctDate.size() > maxArrayCnt) {
                        maxArrayCnt = strategyItem.getFrequencyTimes() * distinctDate.size();
                    }
                    frequenceStrategyItemAndDateMap.put(strategyItem, distinctDate);
                }
            }
        }
        return new int[]{specifyCount, maxArrayCnt};
    }

    private IStrategyDateHandleFacade getDateHandle(Context ctx) throws BOSException {
        return StrategyDateHandleFacadeFactory.getLocalInstance(ctx);
    }

    private boolean isStandardOperationNotBeRestricted(Context ctx, EquipmentStandardOperationInfo soInfo, PreMaintainStrategySeqItemCollection strategyItemCollection, IObjectValue asset) throws BOSException, EASBizException {
        List rootStandardOperations = this.getRestrainHandle(ctx).findStandardOperationListNotBeRestricted(this.getStandardOperationList(strategyItemCollection, EQMFireModeEnum.BASEDATE), asset);
        boolean rootContains = false;
        for (EquipmentStandardOperationInfo op : rootStandardOperations) {
            if (!op.getId().equals((Object)soInfo.getId())) continue;
            rootContains = true;
            break;
        }
        return rootContains;
    }

    private IRestrainHandleFacade getRestrainHandle(Context ctx) throws BOSException {
        return RestrainHandleFacadeFactory.getLocalInstance(ctx);
    }

    private void swFrequenceFireHandleOfSpcDate(Context ctx, String proNumber, int assetCount, int seq, PreMaintainStrategyInfo msInfo, Date specifyDate, Timestamp runBegin, String tmpWOtableName, String tmpLogTableName, TiggerModeEnum fireMode, RunningModeEnum runMode) throws BOSException, EASBizException {
        PreMaintainStrategySeqItemCollection mssColl = msInfo.getSoSeqEntry();
        ArrayList<EquipmentStandardOperationInfo> originLst = new ArrayList<EquipmentStandardOperationInfo>();
        HashMap<EquipmentStandardOperationInfo, PreMaintainStrategySeqItemInfo> soMap = new HashMap<EquipmentStandardOperationInfo, PreMaintainStrategySeqItemInfo>();
        ArrayList<PreMaintainStrategySeqItemInfo> ssiLst = new ArrayList<PreMaintainStrategySeqItemInfo>();
        for (int i = 0; i < mssColl.size(); ++i) {
            originLst.add(mssColl.get(i).getStandardOperation());
            soMap.put(mssColl.get(i).getStandardOperation(), mssColl.get(i));
            ssiLst.add(mssColl.get(i));
        }
        ArrayList<Date> dateList = new ArrayList<Date>();
        dateList.add(specifyDate);
        this.generateWorkOrderByStrategyOfSpcDate(ctx, proNumber, assetCount, seq, null, msInfo, ssiLst, false, dateList, msInfo.getName(), tmpWOtableName, runBegin, tmpLogTableName, fireMode, runMode, FIRSTORDERNUM);
    }

    private List getDateListOfEachAtTerm(Context ctx, PreMaintainStrategyInfo msInfo, PreMaintainStrategySeqItemInfo msoSeqInfo, Date startDate, Date endDate, String id, boolean isLocation, boolean isSeq, String tmpWOtableName) throws BOSException, EASBizException {
        Map fstMap = this.getDateHandle(ctx).getFirstDateFromDateEntry((IObjectValue)msInfo, (IObjectValue)msoSeqInfo, startDate, endDate, isSeq);
        Map dateMap = this.getDateHandle(ctx).getFirstDateFromMeterEntry((IObjectValue)msInfo, (IObjectValue)msoSeqInfo, startDate, endDate, id, isLocation, isSeq, true, null);
        ArrayList dateLst = new ArrayList();
        Object[] lastMeterMap = new Object[]{null, null};
        while (fstMap != null && fstMap.size() > 0 || dateMap != null && dateMap.size() > 0) {
            Date nextWODate;
            Object[] objs;
            Date firstWODate = null;
            if (fstMap != null) {
                firstWODate = (Date)fstMap.keySet().iterator().next();
            }
            String meterID2 = "";
            Date fstDateFromMeter = null;
            if (dateMap != null) {
                for (String meterID2 : dateMap.keySet()) {
                    objs = (Object[])dateMap.get(meterID2);
                    fstDateFromMeter = (Date)objs[0];
                }
            }
            if (firstWODate == null) {
                this.baseMeter = true;
                nextWODate = fstDateFromMeter;
            } else if (fstDateFromMeter == null) {
                this.baseMeter = false;
                nextWODate = firstWODate;
            } else if (DateUtils.before(firstWODate, fstDateFromMeter)) {
                this.baseMeter = false;
                nextWODate = firstWODate;
            } else {
                this.baseMeter = true;
                nextWODate = fstDateFromMeter;
            }
            if (nextWODate == null || !DateUtils.beforeOrSame(nextWODate, endDate)) break;
            HashMap<Date, Integer> dMap = new HashMap<Date, Integer>();
            if (this.baseMeter) {
                objs = (Object[])dateMap.get(dateMap.keySet().iterator().next());
                Integer interval = (Integer)objs[3];
                dMap.put(nextWODate, interval);
                lastMeterMap[0] = (Date)objs[0];
                lastMeterMap[1] = (BigDecimal)objs[1];
                List meterColl = msInfo.getMeterEntryItems();
                EQMCalendarTypeEnum ctEnum = msInfo.getCalendarType();
                int frqTimes = msoSeqInfo.getFrequencyTimes();
                dateMap = this.getDateHandle(ctx).getFirstDateFromMeterEntry((IObjectValue)msInfo, (IObjectValue)msoSeqInfo, nextWODate, endDate, id, isLocation, isSeq, false, null);
                BaseDateFrequencyEntryCollection seqColl = msInfo.getDateSeqEntry();
                fstMap = this.getDateHandle(ctx).getNextDateBaseDateEntry(seqColl, nextWODate, frqTimes, msInfo.getStorageOrgUnit().getId().toString(), msInfo.getCalendarType());
            } else {
                dMap.put(nextWODate, (Integer)fstMap.get(fstMap.keySet().iterator().next()));
                int frqTimes = msoSeqInfo.getFrequencyTimes();
                if (dateMap != null && dateMap.size() > 0) {
                    dateMap = this.getDateHandle(ctx).getFirstDateFromMeterEntry((IObjectValue)msInfo, (IObjectValue)msoSeqInfo, nextWODate, endDate, id, isLocation, isSeq, false, null);
                }
                BaseDateFrequencyEntryCollection seqColl = msInfo.getDateSeqEntry();
                fstMap = this.getDateHandle(ctx).getNextDateBaseDateEntry(seqColl, nextWODate, frqTimes, msInfo.getStorageOrgUnit().getId().toString(), msInfo.getCalendarType());
            }
            Calendar cp2 = Calendar.getInstance();
            cp2.setTime(startDate);
            cp2.set(11, 0);
            cp2.set(12, 0);
            cp2.set(13, 0);
            cp2.set(14, 0);
            Date startDateNotTime = cp2.getTime();
            if (nextWODate.before(startDateNotTime)) continue;
            dateLst.add(dMap);
        }
        return dateLst;
    }

    private List getDateListOfAllAtTerm(Context ctx, PreMaintainStrategyInfo msInfo, PreMaintainStrategySeqItemInfo msoSeqInfo, Date startDate, Date endDate, String id, boolean isLocation, boolean isSeq, String tmpWOtableName) throws BOSException, EASBizException {
        Map fstMap = this.getDateHandle(ctx).getFirstDateFromDateEntry((IObjectValue)msInfo, (IObjectValue)msoSeqInfo, startDate, endDate, isSeq);
        Map dateMap = this.getDateHandle(ctx).getFirstDateFromMeterEntry((IObjectValue)msInfo, (IObjectValue)msoSeqInfo, startDate, endDate, id, isLocation, isSeq, true, null);
        ArrayList dateLst = new ArrayList();
        Object[] lastMeterMap = new Object[]{null, null};
        while (fstMap != null && fstMap.size() > 0 || dateMap != null && dateMap.size() > 0) {
            Date nextWODate;
            Object[] objs;
            Date firstWODate = null;
            if (fstMap != null) {
                firstWODate = (Date)fstMap.keySet().iterator().next();
            }
            String meterID2 = "";
            Date fstDateFromMeter = null;
            for (String meterID2 : dateMap.keySet()) {
                objs = (Object[])dateMap.get(meterID2);
                fstDateFromMeter = (Date)objs[0];
            }
            if (firstWODate == null) {
                this.baseMeter = true;
                nextWODate = fstDateFromMeter;
            } else if (fstDateFromMeter == null) {
                this.baseMeter = false;
                nextWODate = firstWODate;
            } else if (DateUtils.after(firstWODate, fstDateFromMeter)) {
                this.baseMeter = false;
                nextWODate = firstWODate;
            } else {
                this.baseMeter = true;
                nextWODate = fstDateFromMeter;
            }
            if (nextWODate == null) break;
            HashMap<Date, Integer> dMap = new HashMap<Date, Integer>();
            if (!DateUtils.beforeOrSame(nextWODate, endDate)) break;
            if (this.baseMeter) {
                objs = (Object[])dateMap.get(dateMap.keySet().iterator().next());
                Integer interval = (Integer)objs[3];
                dMap.put(nextWODate, interval);
                lastMeterMap[0] = (Date)objs[0];
                lastMeterMap[1] = (BigDecimal)objs[1];
                List meterColl = msInfo.getMeterEntryItems();
                EQMCalendarTypeEnum ctEnum = msInfo.getCalendarType();
                int frqTimes = msoSeqInfo.getFrequencyTimes();
                dateMap = this.getDateHandle(ctx).getFirstDateFromMeterEntry((IObjectValue)msInfo, (IObjectValue)msoSeqInfo, nextWODate, endDate, id, isLocation, isSeq, false, null);
                BaseDateFrequencyEntryCollection seqColl = msInfo.getDateSeqEntry();
                fstMap = this.getDateHandle(ctx).getNextDateBaseDateEntry(seqColl, nextWODate, frqTimes, msInfo.getStorageOrgUnit().getId().toString(), msInfo.getCalendarType());
            } else {
                dMap.put(nextWODate, (Integer)fstMap.get(fstMap.keySet().iterator().next()));
                int frqTimes = msoSeqInfo.getFrequencyTimes();
                dateMap = this.getDateHandle(ctx).getFirstDateFromMeterEntry((IObjectValue)msInfo, (IObjectValue)msoSeqInfo, nextWODate, endDate, id, isLocation, isSeq, false, null);
                BaseDateFrequencyEntryCollection seqColl = msInfo.getDateSeqEntry();
                fstMap = this.getDateHandle(ctx).getNextDateBaseDateEntry(seqColl, nextWODate, frqTimes, msInfo.getStorageOrgUnit().getId().toString(), msInfo.getCalendarType());
            }
            Calendar cp2 = Calendar.getInstance();
            cp2.setTime(startDate);
            cp2.set(11, 0);
            cp2.set(12, 0);
            cp2.set(13, 0);
            cp2.set(14, 0);
            Date startDateNotTime = cp2.getTime();
            if (nextWODate.before(startDateNotTime)) continue;
            dateLst.add(dMap);
        }
        return dateLst;
    }

    private List getDateList4PM(Context ctx, PreMaintainStrategyInfo msInfo, PreMaintainStrategySeqItemInfo msoSeqInfo, Date startDate, Date endDate, String id, boolean isLocation, boolean isSeq, EQMSequencyFireRuleEnum fireRule) throws BOSException, EASBizException {
        Date nextWODate = null;
        Map fstMap = this.getDateHandle(ctx).getFirstDateFromDateEntry((IObjectValue)msInfo, (IObjectValue)msoSeqInfo, startDate, endDate, isSeq);
        Map dateMap = this.getDateHandle(ctx).getFirstDateFromMeterEntry((IObjectValue)msInfo, (IObjectValue)msoSeqInfo, startDate, endDate, id, isLocation, isSeq, true, null);
        ArrayList<Map> dateList = new ArrayList<Map>();
        int frqTimes = msoSeqInfo.getFrequencyTimes();
        BaseDateFrequencyEntryCollection seqColl = msInfo.getDateSeqEntry();
        while ((fstMap != null && fstMap.size() > 0 || dateMap != null && dateMap.size() > 0) && (nextWODate = this.getNextWODate(fstMap, dateMap, fireRule)) != null) {
            Map dMap = this.getNextWODateMap(fstMap, dateMap, nextWODate, startDate);
            if (dMap != null) {
                dateList.add(dMap);
            }
            if (!DateUtils.beforeOrSame(nextWODate, endDate)) break;
            fstMap = this.getDateHandle(ctx).getNextDateBaseDateEntry(seqColl, nextWODate, frqTimes, msInfo.getStorageOrgUnit().getId().toString(), msInfo.getCalendarType());
            dateMap = this.getDateHandle(ctx).getFirstDateFromMeterEntry((IObjectValue)msInfo, (IObjectValue)msoSeqInfo, nextWODate, endDate, id, isLocation, isSeq, false, null);
        }
        return dateList;
    }

    private Map getNextWODateMap(Map fstMap, Map dateMap, Date nextWODate, Date startDate) {
        HashMap<Date, Integer> dMap = new HashMap<Date, Integer>();
        if (this.baseMeter) {
            Object[] objs = (Object[])dateMap.get(dateMap.keySet().iterator().next());
            Integer interval = (Integer)objs[3];
            dMap.put(nextWODate, interval);
        } else {
            dMap.put(nextWODate, (Integer)fstMap.get(fstMap.keySet().iterator().next()));
        }
        Calendar cp2 = Calendar.getInstance();
        cp2.setTime(startDate);
        cp2.set(11, 0);
        cp2.set(12, 0);
        cp2.set(13, 0);
        cp2.set(14, 0);
        Date startDateNotTime = cp2.getTime();
        if (!nextWODate.before(startDateNotTime)) {
            return dMap;
        }
        return null;
    }

    private Date getNextWODate(Map fstMap, Map dateMap, EQMSequencyFireRuleEnum fireRule) {
        Date nextWODate = null;
        Date firstWODate = null;
        if (fstMap != null) {
            firstWODate = (Date)fstMap.keySet().iterator().next();
        }
        Date fstDateFromMeter = null;
        for (String meterID : dateMap.keySet()) {
            Object[] objs = (Object[])dateMap.get(meterID);
            fstDateFromMeter = (Date)objs[0];
        }
        if (firstWODate == null) {
            this.baseMeter = true;
            nextWODate = fstDateFromMeter;
        } else if (fstDateFromMeter == null) {
            this.baseMeter = false;
            nextWODate = firstWODate;
        } else if (EQMSequencyFireRuleEnum.ALL.equals((Object)fireRule)) {
            if (DateUtils.after(firstWODate, fstDateFromMeter)) {
                this.baseMeter = false;
                nextWODate = firstWODate;
            } else {
                this.baseMeter = true;
                nextWODate = fstDateFromMeter;
            }
        } else if (EQMSequencyFireRuleEnum.EACH.equals((Object)fireRule)) {
            if (DateUtils.before(firstWODate, fstDateFromMeter)) {
                this.baseMeter = false;
                nextWODate = firstWODate;
            } else {
                this.baseMeter = true;
                nextWODate = fstDateFromMeter;
            }
        }
        return nextWODate;
    }

    protected void releaseTempTable(Context ctx, String tableName) throws BOSException, EASBizException {
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        pool.releaseTable(tableName);
    }

    private List getSortedRouteSites(EquipmentMaintainSiteCollection siteCollection) {
        ArrayList<EquipmentMaintainSiteInfo> results = new ArrayList<EquipmentMaintainSiteInfo>();
        for (int i = 0; i < siteCollection.size(); ++i) {
            results.add(siteCollection.get(i));
        }
        Collections.sort(results, (Comparator)new Comparator(){

            public int compare(Object obj1, Object obj2) {
                EquipmentMaintainSiteInfo site1 = (EquipmentMaintainSiteInfo)obj1;
                EquipmentMaintainSiteInfo site2 = (EquipmentMaintainSiteInfo)obj2;
                return new Integer(site1.getOrderNumber()).compareTo(new Integer(site2.getOrderNumber()));
            }
        });
        return results;
    }

    private WorkOrderSrcTypeEnum getWorkOrderSrcTypeEnum(EquipmentMaintainSchemaInfo schema) {
        if (schema == null) {
            return WorkOrderSrcTypeEnum.MAINTAINSTRATEGY;
        }
        return WorkOrderSrcTypeEnum.MAINTAINSCHEMA;
    }

    private List getDistinctDate(List dateList) {
        ArrayList distinctDate = new ArrayList();
        HashMap<Date, Object[]> distinctMap = new HashMap<Date, Object[]>();
        if (dateList == null || dateList.size() < 1) {
            return null;
        }
        Date comparedDate = null;
        Integer count = new Integer(1);
        if (dateList.size() > 1) {
            for (int i = 0; i < dateList.size(); ++i) {
                Map dateMap = (Map)dateList.get(i);
                Date stWODate = (Date)dateMap.keySet().iterator().next();
                Integer range = (Integer)dateMap.get(stWODate);
                if (i == 0) {
                    comparedDate = stWODate;
                    continue;
                }
                if (comparedDate.compareTo(stWODate) != 0) {
                    distinctMap.put(comparedDate, new Object[]{range, count});
                    comparedDate = stWODate;
                    count = new Integer(1);
                    if (i != dateList.size() - 1) continue;
                    distinctMap.put(stWODate, new Object[]{range, count});
                    continue;
                }
                if (i == dateList.size() - 1) {
                    count = new Integer(count + 1);
                    distinctMap.put(comparedDate, new Object[]{range, count});
                    continue;
                }
                count = new Integer(count + 1);
            }
        } else {
            return dateList;
        }
        if (dateList.size() == distinctMap.size()) {
            return dateList;
        }
        ArrayList arrayList = new ArrayList(distinctMap.entrySet());
        Map.Entry[] entries = arrayList.toArray(new Map.Entry[arrayList.size()]);
        Arrays.sort(entries, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                Object key1 = ((Map.Entry)arg0).getKey();
                Object key2 = ((Map.Entry)arg1).getKey();
                return ((Comparable)key1).compareTo(key2);
            }
        });
        for (int i = 0; i < entries.length; ++i) {
            HashMap map = new HashMap();
            map.put(entries[i].getKey(), entries[i].getValue());
            distinctDate.add(i, map);
        }
        return distinctDate;
    }
}

