/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.eqm.planning.app.verify;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DAGValidator {
    private Map nodes = new HashMap();
    private Map arcs = new HashMap();
    private Map indegreeCount = new HashMap();

    public List validate() {
        Arc nextArc;
        if (this.nodes.size() == 0) {
            return null;
        }
        while (this.removeOneLeafNode()) {
        }
        while (this.removeOneRootNode()) {
        }
        if (this.nodes.size() == 0) {
            return null;
        }
        if (this.nodes.size() == 0) {
            return null;
        }
        List<Object> result = new ArrayList();
        String currentNodeKey = (String)this.nodes.entrySet().iterator().next().getKey();
        while ((nextArc = this.getNextArc(currentNodeKey)) != null) {
            result.add(this.nodes.get(currentNodeKey));
            if (result.indexOf(nextArc.getTo()) == 0) break;
            if (result.contains(nextArc.getTo())) {
                result = result.subList(result.indexOf(nextArc.getTo()), result.size());
                break;
            }
            nextArc.setScanned(true);
            currentNodeKey = nextArc.getTo();
        }
        return result;
    }

    private Arc getNextArc(String currentNodeKey) {
        List arcList = (List)this.arcs.get(currentNodeKey);
        Arc nextArc = null;
        for (int i = 0; i < arcList.size(); ++i) {
            Arc a = (Arc)arcList.get(i);
            if (a.isScanned()) continue;
            nextArc = a;
            break;
        }
        return nextArc;
    }

    private boolean removeOneRootNode() {
        Iterator it = this.nodes.entrySet().iterator();
        while (it.hasNext()) {
            String nodeKey = (String)it.next().getKey();
            if (this.hasArcTo(nodeKey)) continue;
            this.nodes.remove(nodeKey);
            this.arcs.remove(nodeKey);
            return true;
        }
        return false;
    }

    private boolean hasArcTo(String nodeKey) {
        boolean result = false;
        block0: for (Map.Entry en : this.arcs.entrySet()) {
            if (en.getValue() == null) continue;
            List arcList = (List)en.getValue();
            for (int i = 0; i < arcList.size(); ++i) {
                Arc arc = (Arc)arcList.get(i);
                if (!arc.getTo().equals(nodeKey)) continue;
                result = true;
                break block0;
            }
        }
        return result;
    }

    private boolean removeOneLeafNode() {
        for (Map.Entry en : this.nodes.entrySet()) {
            if (this.arcs.get(en.getKey()) != null) continue;
            this.nodes.remove(en.getKey());
            this.removeArcsTo((String)en.getKey());
            return true;
        }
        return false;
    }

    private void removeArcsTo(String nodeKey) {
        ArrayList shouldRemoveArcs = new ArrayList();
        for (Map.Entry en : this.arcs.entrySet()) {
            List arcList = (List)en.getValue();
            for (int i = arcList.size() - 1; i >= 0; --i) {
                Arc arc = (Arc)arcList.get(i);
                if (!arc.getTo().equals(nodeKey)) continue;
                arcList.remove(i);
            }
            if (arcList.size() != 0) continue;
            shouldRemoveArcs.add(en.getKey());
        }
        for (Map.Entry object : shouldRemoveArcs) {
            this.arcs.remove(object);
        }
    }

    public void addNode(String key, String name) {
        this.nodes.put(key, new Node(key, name));
    }

    public void addArc(String from, String to) {
        Object obj = this.arcs.get(from);
        if (obj == null) {
            this.arcs.put(from, new ArrayList());
        }
        ((List)this.arcs.get(from)).add(new Arc(from, to));
        this.increaseIndegreeCount(to);
    }

    private void increaseIndegreeCount(String to) {
        if (this.indegreeCount.get(to) == null) {
            this.indegreeCount.put(to, Integer.valueOf("0"));
        }
        int i = (Integer)this.indegreeCount.get(to) + 1;
        this.indegreeCount.put(to, Integer.valueOf(i + ""));
    }

    private Integer getIndegreeCount(Node node) {
        Integer result = Integer.valueOf("0");
        if (this.indegreeCount.get(node.getKey()) != null) {
            result = (Integer)this.indegreeCount.get(node.getKey());
        }
        return result;
    }

    public Node getNode(String key) {
        return (Node)this.nodes.get(key);
    }

    public List sort() {
        ArrayList result = new ArrayList();
        while (this.nodes.size() > 0) {
            List rootNodes = this.collectSortRootNodeKyes();
            result.addAll(rootNodes);
        }
        return result;
    }

    private List collectSortRootNodeKyes() {
        List rootNodes = this.getRootNodes();
        Collections.sort(rootNodes, new Comparator(){

            public int compare(Object node, Object otherNode) {
                return DAGValidator.this.getIndegreeCount((Node)node).compareTo(DAGValidator.this.getIndegreeCount((Node)otherNode));
            }
        });
        Iterator it = rootNodes.iterator();
        while (it.hasNext()) {
            String nodeKey = ((Node)it.next()).getKey();
            this.nodes.remove(nodeKey);
            this.arcs.remove(nodeKey);
        }
        return rootNodes;
    }

    public List getRootNodes() {
        ArrayList rootNodes = new ArrayList();
        Iterator it = this.nodes.entrySet().iterator();
        while (it.hasNext()) {
            String nodeKey = (String)it.next().getKey();
            if (this.hasArcTo(nodeKey)) continue;
            rootNodes.add(this.nodes.get(nodeKey));
        }
        return rootNodes;
    }

    public static class Arc {
        private String from;
        private String to;
        private boolean scanned;

        private Arc(String from, String to) {
            this.from = from;
            this.to = to;
            this.scanned = false;
        }

        public boolean isScanned() {
            return this.scanned;
        }

        public void setScanned(boolean scanned) {
            this.scanned = scanned;
        }

        public String getFrom() {
            return this.from;
        }

        public String getTo() {
            return this.to;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.from == null ? 0 : this.from.hashCode());
            result = 31 * result + (this.to == null ? 0 : this.to.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Arc other = (Arc)obj;
            if (this.from == null ? other.from != null : !this.from.equals(other.from)) {
                return false;
            }
            return !(this.to == null ? other.to != null : !this.to.equals(other.to));
        }
    }

    public static class Node {
        private String name;
        private String key;

        public String getName() {
            return this.name;
        }

        public String getKey() {
            return this.key;
        }

        protected Node(String key, String name) {
            this.key = key;
            this.name = name;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Node other = (Node)obj;
            return !(this.key == null ? other.key != null : !this.key.equals(other.key));
        }

        public String toString() {
            return "Node[" + this.key + "," + this.name + "]";
        }
    }
}

